/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.supervision;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;

public class SupervisionFinishEditPlugin
extends AbstractPmfsBillPlugin
implements BeforeF7SelectListener {
    private static final String BUSI_BILL_NO_CALL_BACK = "busiBillNoCallBack";
    private static final String WORK_ITEM_CALL_BACK = "workItemCallBack";

    public void registerListener(EventObject e) {
        TextEdit bizBillNo;
        super.registerListener(e);
        BasedataEdit workItem = (BasedataEdit)this.getControl("workitem");
        if (workItem != null) {
            workItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizBillNo = (TextEdit)this.getView().getControl("bizbillno")) != null) {
            bizBillNo.addButtonClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if (source != null && source.equals("report")) {
            this.getModel().setValue("org", formShowParameter.getCustomParam("org"));
            this.getModel().setValue("project", formShowParameter.getCustomParam("project"));
            this.getModel().setValue("workitem", formShowParameter.getCustomParam("workitem"));
            if (formShowParameter.getCustomParam("actualendtime") != null) {
                this.getModel().setValue("actualendtime", formShowParameter.getCustomParam("actualendtime"));
            }
            this.getModel().setValue("sysbill", formShowParameter.getCustomParam("sysbill"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "workitem": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"SupervisionFinishEditPlugin_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                QFilter workItemFilter = ProjectSupervisionHelper.getWorkItemFilterByProject((Object)project.getPkValue());
                param.getListFilterParameter().setFilter(workItemFilter);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WORK_ITEM_CALL_BACK));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "bizbillno": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"SupervisionFinishEditPlugin_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject sysBill = (DynamicObject)this.getModel().getValue("sysbill");
                if (sysBill == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7cfb\u7edf\u5355\u636e\u3002", (String)"SupervisionFinishEditPlugin_4", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("pmfs_supervisionbill");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("sysBill", (Object)sysBill.getString("sysbill.number"));
                formShowParameter.setCustomParam("projectId", project.getPkValue());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUSI_BILL_NO_CALL_BACK));
                this.getView().getFormShowParameter().setCustomParam("sysbill", (Object)sysBill.getString("sysbill.number"));
                this.getPageCache().put("sysbill", sysBill.getString("sysbill.number"));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "busiBillNoCallBack": {
                String pk = (String)e.getReturnData();
                if (pk == null) break;
                String sysBill = this.getPageCache().get("sysbill");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pk), (String)sysBill);
                this.getModel().setValue("bizbillno", dynamicObject.get("billno"));
                this.getModel().setValue("bizbillid", (Object)pk);
                break;
            }
            case "workItemCallBack": {
                ListSelectedRowCollection objCollection = (ListSelectedRowCollection)e.getReturnData();
                if (objCollection == null) break;
                Object pkValue = objCollection.get(0).getPrimaryKeyValue();
                DynamicObject workItem = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmbs_workexecution");
                this.getModel().setValue("workitem", (Object)workItem);
                if (workItem.getDate("actualendtime") == null) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5de5\u4f5c\u9879\u5df2\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u586b\u62a5\u3002", (String)"SupervisionFinishEditPlugin_5", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(WORK_ITEM_CALL_BACK, (IFormPlugin)this));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "project": {
                this.getModel().setValue("workitem", null);
                break;
            }
            case "sysbill": {
                this.getModel().setValue("bizbillno", null);
                this.getModel().setValue("bizbillid", null);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "workItemCallBack": {
                if (result.getValue() != MessageBoxResult.Cancel.getValue()) break;
                this.getModel().setValue("workitem", null);
                this.getModel().setValue("actualendtime", null);
                break;
            }
        }
    }
}

