/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.supervision;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class UpdateSupervisionLightTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.updateSupervisionLight();
    }

    protected void updateSupervisionLight() {
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter projectFilter = new QFilter("billproject", "!=", (Object)0L);
        DynamicObject[] superPerforms = BusinessDataServiceHelper.load((String)"pmfs_supervisperform", (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, billproject, prowarninglight, billscanend,superentryentity,superentryentity.sysbill,superentryentity.keypropconfigid,superentryentity.project,superentryentity.estimateendtime,superentryentity.actualendtime,superentryentity.scanend,superentryentity.deleted,superentryentity.itemwarninglight,superentryentity.hiddendata,superentryentity.relatebizbillids,superentryentity.applyyear", (QFilter[])new QFilter[]{billStatusFilter, projectFilter});
        Set proIdSet = Arrays.stream(superPerforms).filter(o -> o.getDynamicObject("billproject") != null).map(o -> o.getDynamicObject("billproject").getPkValue()).collect(Collectors.toSet());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter billProFilter = new QFilter("project", "in", proIdSet);
        DynamicObject[] proExecuStatusObjs = BusinessDataServiceHelper.load((String)"pmsc_projectexecstatus", (String)"project,newstatus", (QFilter[])new QFilter[]{statusFilter, billProFilter});
        Map<Object, List<DynamicObject>> proIdToExeStatusObjMap = Arrays.stream(proExecuStatusObjs).collect(Collectors.groupingBy(obj -> obj.get("project")));
        for (DynamicObject superPerform : superPerforms) {
            DynamicObject billProject = superPerform.getDynamicObject("billproject");
            if (billProject == null) continue;
            List<DynamicObject> proExecuStatusObjList = proIdToExeStatusObjMap.get(billProject.getPkValue());
            DynamicObject proExecuStatusObj = null;
            if (proExecuStatusObjList != null && !proExecuStatusObjList.isEmpty()) {
                proExecuStatusObj = proExecuStatusObjList.get(0);
            }
            boolean isStopScan = this.isStopScan(proExecuStatusObj);
            boolean isBillOldScanEnd = superPerform.getBoolean("billscanend");
            if (isBillOldScanEnd && isStopScan) continue;
            DynamicObjectCollection superEntryEntity = superPerform.getDynamicObjectCollection("superentryentity");
            for (DynamicObject entryObj : superEntryEntity) {
                boolean isHiddenData = entryObj.getBoolean("hiddendata");
                boolean isDeleted = entryObj.getBoolean("deleted");
                if (isHiddenData || isDeleted) continue;
                Date estimateDate = entryObj.getDate("estimateendtime");
                Date actualEndTime = entryObj.getDate("actualendtime");
                String itemWarnLightValue = ProjectSupervisionHelper.getItemWarnLight((Date)estimateDate, (Date)actualEndTime);
                entryObj.set("itemwarninglight", (Object)itemWarnLightValue);
            }
            String projectWarnLightValue = ProjectSupervisionHelper.getProjectWarnLight((DynamicObjectCollection)superEntryEntity);
            superPerform.set("prowarninglight", (Object)projectWarnLightValue);
        }
        SaveServiceHelper.update((DynamicObject[])superPerforms);
    }

    protected boolean isStopScan(DynamicObject proExecuStatusObj) {
        String number;
        DynamicObject proStatus;
        boolean isStopScan = false;
        if (proExecuStatusObj != null && (proStatus = proExecuStatusObj.getDynamicObject("newstatus")) != null && StringUtils.equals((CharSequence)(number = proStatus.getString("number")), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
            isStopScan = true;
        }
        return isStopScan;
    }
}

