/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.supervision;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.business.helper.SupervisionPropertyHelper;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.SupervisionDatasourceEnum;
import kd.pmgt.pmbs.common.enums.SupervisionIdentTypeEnum;
import kd.pmgt.pmbs.common.enums.supervision.FinishStatusWarningEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.MetadataUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmbs.common.utils.task.PmptTaskUtil;
import org.jetbrains.annotations.NotNull;

public class UpdateSupervisionTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(UpdateSupervisionTask.class);
    protected static final int UPDATE_FALSE = 0;
    protected static final int UPDATE_TRUE = 1;

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.updateSupervisionRecord();
    }

    protected void updateSupervisionRecord() {
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter projectFilter = new QFilter("billproject", "!=", (Object)0L);
        DynamicObject[] superPerforms = BusinessDataServiceHelper.load((String)"pmfs_supervisperform", (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, billproject, prowarninglight, billscanend,superentryentity,superentryentity.sysbill,superentryentity.keypropconfigid,superentryentity.project,superentryentity.estimateendtime,superentryentity.actualendtime,superentryentity.scanend,superentryentity.deleted,superentryentity.itemwarninglight,superentryentity.hiddendata,superentryentity.relatebizbillids,superentryentity.applyyear", (QFilter[])new QFilter[]{billStatusFilter, projectFilter});
        Set proIdSet = Arrays.stream(superPerforms).filter(o -> o.getDynamicObject("billproject") != null).map(o -> o.getDynamicObject("billproject").getPkValue()).collect(Collectors.toSet());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter billProFilter = new QFilter("project", "in", proIdSet);
        DynamicObject[] proExecuStatusObjs = BusinessDataServiceHelper.load((String)"pmsc_projectexecstatus", (String)"project,newstatus", (QFilter[])new QFilter[]{statusFilter, billProFilter});
        Map<Object, List<DynamicObject>> proIdToExeStatusObjMap = Arrays.stream(proExecuStatusObjs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
        ArrayList<String> newBizIdList = new ArrayList<String>();
        ArrayList<String> updateBizIdList = new ArrayList<String>();
        ArrayList<String> modifyBizIdList = new ArrayList<String>();
        HashMap<String, DynamicObject> updateBizMap = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> newRecordList = new ArrayList<DynamicObject>(superPerforms.length);
        ArrayList<DynamicObject> updateRecordList = new ArrayList<DynamicObject>(superPerforms.length);
        ArrayList<DynamicObject> modifyRecordList = new ArrayList<DynamicObject>(superPerforms.length);
        for (DynamicObject superPerform : superPerforms) {
            DynamicObject billProject = superPerform.getDynamicObject("billproject");
            if (billProject == null) continue;
            List<DynamicObject> proExecuStatusObjList = proIdToExeStatusObjMap.get(billProject.getPkValue());
            DynamicObject proExecuStatusObj = null;
            if (proExecuStatusObjList != null && !proExecuStatusObjList.isEmpty()) {
                proExecuStatusObj = proExecuStatusObjList.get(0);
            }
            boolean isStopScan = this.isStopScan(proExecuStatusObj);
            boolean isBillOldScanEnd = superPerform.getBoolean("billscanend");
            if (isBillOldScanEnd && isStopScan) continue;
            int updateValue = this.getUpdateValue(superPerform, proExecuStatusObj);
            DynamicObjectCollection superEntryEntity = superPerform.getDynamicObjectCollection("superentryentity");
            for (DynamicObject entryObj : superEntryEntity) {
                newBizIdList.clear();
                updateBizIdList.clear();
                modifyBizIdList.clear();
                updateBizMap.clear();
                entryObj.set("scanend", (Object)updateValue);
                boolean isHiddenData = entryObj.getBoolean("hiddendata");
                boolean isDeleted = entryObj.getBoolean("deleted");
                if (isHiddenData || isDeleted) continue;
                DynamicObject sysBillObj = entryObj.getDynamicObject("sysbill");
                DynamicObject workItem = BusinessDataServiceHelper.loadSingle((Object)entryObj.getPkValue(), (String)"pmbs_workexecution");
                DynamicObject task = workItem.getDynamicObject("task");
                if (task != null) {
                    task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"pmpt_task");
                    if (BigDecimal.valueOf(100L).compareTo(task.getBigDecimal("percent")) == 0) {
                        logger.info("\u8be5\u7763\u5bfc\u5de5\u4f5c\u9879\u7531\u4efb\u52a1\u6c47\u62a5\u5b8c\u6210\uff0c\u4e0d\u518d\u5b9a\u65f6\u66f4\u65b0\u3002");
                        continue;
                    }
                }
                if (sysBillObj == null) {
                    String relateBizBillids = entryObj.getString("relatebizbillids");
                    if (StringUtils.isEmpty((CharSequence)relateBizBillids)) {
                        this.updateWorkItemField(modifyBizIdList, entryObj, new DynamicObject[0]);
                        continue;
                    }
                    String[] relaBizBillIdSplit = relateBizBillids.split(",");
                    modifyBizIdList = new ArrayList<String>(Arrays.asList(relaBizBillIdSplit));
                    this.updateWorkItemField(modifyBizIdList, entryObj, new DynamicObject[0]);
                    this.modifyFinishRecord(modifyRecordList, entryObj, modifyBizIdList);
                    continue;
                }
                DynamicObject[] metaBills = this.getBizBills(statusFilter, billProject, entryObj, sysBillObj);
                String relateBizBillids = entryObj.getString("relatebizbillids");
                if (metaBills.length <= 0) {
                    if (StringUtils.isEmpty((CharSequence)relateBizBillids)) {
                        this.updateWorkItemField(modifyBizIdList, entryObj, metaBills);
                        continue;
                    }
                    String[] relaBizBillIdSplit = relateBizBillids.split(",");
                    modifyBizIdList = new ArrayList<String>(Arrays.asList(relaBizBillIdSplit));
                    this.updateWorkItemField(modifyBizIdList, entryObj, metaBills);
                    this.modifyFinishRecord(modifyRecordList, entryObj, modifyBizIdList);
                } else {
                    this.addDataToRelaCollection(newBizIdList, updateBizIdList, modifyBizIdList, updateBizMap, metaBills, relateBizBillids);
                    this.updateWorkItemField(modifyBizIdList, entryObj, metaBills);
                    if (StringUtils.isEmpty((CharSequence)relateBizBillids)) {
                        this.generateFinishRecord(newRecordList, entryObj, metaBills);
                    } else {
                        this.generateFinishRecord(newRecordList, entryObj, newBizIdList);
                        this.updateFinishRecord(updateRecordList, entryObj, updateBizMap);
                        this.modifyFinishRecord(modifyRecordList, entryObj, modifyBizIdList);
                    }
                }
                newBizIdList.addAll(updateBizIdList);
                newBizIdList.addAll(modifyBizIdList);
                String relateIds = String.join((CharSequence)",", newBizIdList);
                entryObj.set("relatebizbillids", (Object)relateIds);
            }
            String projectWarnLightValue = ProjectSupervisionHelper.getProjectWarnLight((DynamicObjectCollection)superEntryEntity);
            superPerform.set("billscanend", (Object)updateValue);
            superPerform.set("prowarninglight", (Object)projectWarnLightValue);
        }
        SaveServiceHelper.save((DynamicObject[])newRecordList.toArray(new DynamicObject[newRecordList.size()]));
        SaveServiceHelper.update((DynamicObject[])updateRecordList.toArray(new DynamicObject[updateRecordList.size()]));
        SaveServiceHelper.update((DynamicObject[])modifyRecordList.toArray(new DynamicObject[modifyRecordList.size()]));
        SaveServiceHelper.update((DynamicObject[])superPerforms);
    }

    protected DynamicObject[] getBizBills(QFilter statusFilter, DynamicObject billProject, DynamicObject workItem, DynamicObject sysBillObj) {
        MainEntityType dt;
        DynamicProperty auditDateProp;
        String keyPropConfigId = workItem.getString("keypropconfigid");
        DynamicObject sysBill = sysBillObj.getDynamicObject("sysbill");
        String formBillId = sysBill.getString("number");
        String proFieldNum = sysBillObj.getString("profieldnum");
        QFilter projectFilter = new QFilter(proFieldNum, "=", billProject.getPkValue());
        QFilter specialBillFilter = SupervisionPropertyHelper.getSpecialBillFilter((String)formBillId);
        QFilter propFilter = null;
        if (!StringUtils.isEmpty((CharSequence)keyPropConfigId)) {
            propFilter = SupervisionPropertyHelper.spv2QFilter((Long)Long.parseLong(keyPropConfigId));
        }
        if ((auditDateProp = (dt = EntityMetadataCache.getDataEntityType((String)formBillId)).getProperty("auditdate")) != null) {
            return BusinessDataServiceHelper.load((String)formBillId, (String)"billno, modifytime, auditdate,creator", (QFilter[])new QFilter[]{statusFilter, projectFilter, propFilter, specialBillFilter}, (String)"auditdate asc");
        }
        statusFilter = new QFilter("status", "=", (Object)StatusEnum.TEMPSAVE.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.load((String)formBillId, (String)"number, modifytime,creator", (QFilter[])new QFilter[]{statusFilter, enableFilter, projectFilter, propFilter, specialBillFilter}, (String)"modifytime asc");
    }

    protected int getUpdateValue(DynamicObject superPerform, DynamicObject proExecuStatusObj) {
        String number;
        DynamicObject proStatus;
        boolean isBillOldScanEnd = superPerform.getBoolean("billscanend");
        int updateValue = 0;
        if (isBillOldScanEnd) {
            if (proExecuStatusObj == null) {
                updateValue = 0;
            } else {
                DynamicObject proStatus2 = proExecuStatusObj.getDynamicObject("newstatus");
                if (proStatus2 == null) {
                    updateValue = 0;
                } else {
                    String number2 = proStatus2.getString("number");
                    if (!StringUtils.equals((CharSequence)number2, (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
                        updateValue = 0;
                    }
                }
            }
        } else if (proExecuStatusObj != null && (proStatus = proExecuStatusObj.getDynamicObject("newstatus")) != null && StringUtils.equals((CharSequence)(number = proStatus.getString("number")), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
            updateValue = 1;
        }
        return updateValue;
    }

    protected boolean isStopScan(DynamicObject proExecuStatusObj) {
        String number;
        DynamicObject proStatus;
        boolean isStopScan = false;
        if (proExecuStatusObj != null && (proStatus = proExecuStatusObj.getDynamicObject("newstatus")) != null && StringUtils.equals((CharSequence)(number = proStatus.getString("number")), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
            isStopScan = true;
        }
        return isStopScan;
    }

    /*
     * Unable to fully structure code
     */
    protected void updateWorkItemField(List<String> modifyBizIdList, DynamicObject workItem, DynamicObject[] metaBills) {
        actualEndTime = null;
        workItemFilter = new QFilter("workitem", "=", workItem.getPkValue());
        statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        notSysSourceFilter = new QFilter("datasource", "!=", (Object)SupervisionDatasourceEnum.SYSTEM.getValue());
        bizBillIdFilter = new QFilter("bizbillid", "not in", modifyBizIdList);
        sysSourceFilter = new QFilter("datasource", "=", (Object)SupervisionDatasourceEnum.SYSTEM.getValue());
        identFilter = new QFilter("identificationtype", "=", (Object)SupervisionIdentTypeEnum.AUDIT.getValue());
        qFilter = workItemFilter.and(statusFilter).and(notSysSourceFilter.or(sysSourceFilter.and(bizBillIdFilter).and(identFilter)));
        spvFinishObjs = BusinessDataServiceHelper.load((String)"pmfs_supervisionfinish", (String)"billno, actualendtime", (QFilter[])new QFilter[]{qFilter}, (String)"actualendtime asc");
        isBill = true;
        if (spvFinishObjs.length <= 0) {
            if (metaBills.length > 0) {
                actualEndTime = this.getActualEndDate(metaBills[0]);
            }
        } else if (metaBills.length > 0) {
            dt = metaBills[0].getDynamicObjectType();
            auditDateProp = dt.getProperty("auditdate");
            if (auditDateProp != null) {
                auditDate = metaBills[0].getDate("auditdate");
                if (auditDate == null) {
                    auditDate = metaBills[0].getDate("modifytime");
                }
            } else {
                isBill = false;
                auditDate = metaBills[0].getDate("modifytime");
            }
            actualEndTime = spvFinishObjs[0].getDate("actualendtime");
            try {
                if (actualEndTime == null) {
                    actualEndTime = auditDate;
                }
                if (!actualEndTime.after(auditDate)) ** GOTO lbl41
                actualEndTime = auditDate;
            }
            catch (NullPointerException e) {
                if (auditDate != null) ** GOTO lbl41
                name = metaBills[0].getDynamicObjectType().getName();
                project = workItem.getDynamicObject("project");
                num = isBill != false ? metaBills[0].getString("billno") : metaBills[0].getString("number");
                UpdateSupervisionTask.logger.error(String.format("current bizbill:%s, billno:%s, auditdate is null;project is %s", new Object[]{name, num, project}), (Throwable)e);
                throw new KDBizException(String.format("current bizbill:%s, billno:%s, auditdate is null;project is %s", new Object[]{name, num, project}));
            }
        } else {
            actualEndTime = spvFinishObjs[0].getDate("actualendtime");
        }
lbl41:
        // 6 sources

        workItem.set("actualendtime", actualEndTime);
        estimateDate = workItem.getDate("estimateendtime");
        oldItemWarningLight = workItem.getString("itemwarninglight");
        newItemWarnLightValue = ProjectSupervisionHelper.getItemWarnLight((Date)estimateDate, (Date)actualEndTime);
        workItem.set("itemwarninglight", (Object)newItemWarnLightValue);
        finishWarningList = Arrays.asList(new String[]{FinishStatusWarningEnum.ONTIMEFINISH.getValue(), FinishStatusWarningEnum.OVERDUEFINISH.getValue()});
        v0 = needTryReport = StringUtils.equals((CharSequence)oldItemWarningLight, (CharSequence)newItemWarnLightValue) == false && finishWarningList.contains(newItemWarnLightValue) != false;
        if (actualEndTime != null && needTryReport && (task = (workItem = BusinessDataServiceHelper.loadSingle((Object)workItem.getPkValue(), (String)"pmbs_workexecution")).getDynamicObject("task")) != null) {
            task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"pmpt_task");
            task.set("realendtime", (Object)actualEndTime);
            task.set("percent", (Object)100);
            planEndTime = task.getDate("planendtime");
            project = task.getDynamicObject("project");
            realTimeDeviation = null;
            realTimeDeviation = project != null ? PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)actualEndTime, (Date)planEndTime) : BigDecimal.valueOf(DateUtil.getDaysBetweenTwoDate((Date)actualEndTime, (Date)planEndTime));
            task.set("realtimedeviation", (Object)realTimeDeviation);
            if (DateUtil.compareByDay((Date)actualEndTime, (Date)planEndTime) <= 0) {
                task.set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
            } else if (DateUtil.compareByDay((Date)actualEndTime, (Date)planEndTime) > 0) {
                task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
            }
            taskReport = PmptTaskUtil.createNewTaskReportByTask((DynamicObject)task);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskReport});
            sysBillAttachmentId = "";
            sysBill = workItem.getDynamicObject("sysbill");
            if (sysBill != null) {
                sysBillId = sysBill.getString("sysbill_id");
                controlAps = MetadataUtil.getFormMetadata((String)sysBillId);
                for (ControlAp controlAp : controlAps) {
                    if (!(controlAp instanceof AttachmentPanelAp)) continue;
                    sysBillAttachmentId = controlAp.getKey();
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)sysBillAttachmentId) && metaBills.length > 0) {
                    FileAttachmentHelper.copyFileFromAToB((String)sysBillId, (Object)metaBills[0].getPkValue(), (String)sysBillAttachmentId, (String)"pmpt_taskreport", (Object)taskReport.getPkValue(), (String)"attachmentpanel");
                }
            }
        }
    }

    protected void addDataToRelaCollection(List<String> newBizIdList, List<String> updateBizIdList, List<String> modifyBizIdList, Map<String, DynamicObject> updateBizMap, DynamicObject[] metaBills, String relateBizBillids) {
        if (StringUtils.isEmpty((CharSequence)relateBizBillids)) {
            if (metaBills.length <= 0) {
                return;
            }
            List metaBillIds = Arrays.stream(metaBills).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
            newBizIdList.addAll(metaBillIds);
            return;
        }
        String[] relaBizBillIdSplit = relateBizBillids.split(",");
        Set bizBillIds = Arrays.stream(metaBills).map(o -> o.getPkValue().toString()).collect(Collectors.toSet());
        Set relaBizBillIds = Arrays.stream(relaBizBillIdSplit).collect(Collectors.toSet());
        for (String relaBizBillId : relaBizBillIds) {
            if (bizBillIds.contains(relaBizBillId)) {
                updateBizIdList.add(relaBizBillId);
                continue;
            }
            modifyBizIdList.add(relaBizBillId);
        }
        for (String billId : bizBillIds) {
            if (relaBizBillIds.contains(billId)) continue;
            newBizIdList.add(billId);
        }
        block2: for (String updateBizId : updateBizIdList) {
            for (DynamicObject metaBill : metaBills) {
                if (!StringUtils.equals((CharSequence)metaBill.getPkValue().toString(), (CharSequence)updateBizId)) continue;
                updateBizMap.put(updateBizId, metaBill);
                continue block2;
            }
        }
    }

    protected void modifyFinishRecord(List<DynamicObject> modifyRecordList, DynamicObject workItem, List<String> modifyBizIdList) {
        if (modifyBizIdList == null || modifyBizIdList.isEmpty()) {
            return;
        }
        DynamicObject workSysBill = workItem.getDynamicObject("sysbill");
        QFilter workItemFilter = new QFilter("workitem", "=", workItem.getPkValue());
        QFilter dataSourceFilter = new QFilter("datasource", "=", (Object)SupervisionDatasourceEnum.SYSTEM.getValue());
        QFilter bizIdFilter = new QFilter("bizbillid", "in", modifyBizIdList);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] modifyRecords = BusinessDataServiceHelper.load((String)"pmfs_supervisionfinish", (String)"actualendtime, identificationtype, auditdate, modifytime, identificationtime, sysbill, bizbillid, description", (QFilter[])new QFilter[]{workItemFilter, bizIdFilter, dataSourceFilter, statusFilter});
        Date curDate = new Date();
        for (DynamicObject modifyRecord : modifyRecords) {
            String idenType = modifyRecord.getString("identificationtype");
            if (!StringUtils.equals((CharSequence)idenType, (CharSequence)SupervisionIdentTypeEnum.AUDIT.getValue())) continue;
            modifyRecord.set("identificationtype", (Object)SupervisionIdentTypeEnum.UNAUDIT.getValue());
            modifyRecord.set("actualendtime", null);
            modifyRecord.set("modifytime", (Object)curDate);
            modifyRecord.set("auditdate", (Object)curDate);
            modifyRecord.set("identificationtime", (Object)curDate);
            if (this.sysBillEquals(workSysBill, modifyRecord)) {
                modifyRecord.set("description", (Object)ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u626b\u63cf\u81ea\u52a8\u751f\u6210\u3002", (String)"UpdateSupervisionTask_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            } else {
                modifyRecord.set("description", (Object)ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u626b\u63cf\u81ea\u52a8\u751f\u6210\u3002\uff08\u6ce8\uff1a\u8be5\u5b8c\u6210\u8bb0\u5f55\u7cfb\u7edf\u5355\u636e\u53d1\u751f\u53d8\u66f4\u3002\uff09", (String)"UpdateSupervisionTask_1", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            }
            modifyRecordList.add(modifyRecord);
        }
    }

    protected boolean sysBillEquals(DynamicObject workSysBill, DynamicObject modifyRecord) {
        if (workSysBill == null) {
            return false;
        }
        DynamicObject recordSysBill = modifyRecord.getDynamicObject("sysbill");
        DynamicObject recordSysBillObj = recordSysBill.getDynamicObject("sysbill");
        String recordFormBillId = recordSysBillObj.getString("number");
        DynamicObject workSysBillObj = workSysBill.getDynamicObject("sysbill");
        String workFormBillId = workSysBillObj.getString("number");
        return StringUtils.equals((CharSequence)workFormBillId, (CharSequence)recordFormBillId);
    }

    protected void updateFinishRecord(List<DynamicObject> updateRecordList, DynamicObject workItem, Map<String, DynamicObject> updateBizMap) {
        if (updateBizMap == null || updateBizMap.isEmpty()) {
            return;
        }
        Set<String> bizBillIdSet = updateBizMap.keySet();
        QFilter workItemFilter = new QFilter("workitem", "=", workItem.getPkValue());
        QFilter bizIdFilter = new QFilter("bizbillid", "in", bizBillIdSet);
        QFilter dataSourceFilter = new QFilter("datasource", "=", (Object)SupervisionDatasourceEnum.SYSTEM.getValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] updateRecords = BusinessDataServiceHelper.load((String)"pmfs_supervisionfinish", (String)"actualendtime, sysbill, bizbillno, bizbillid, auditdate, modifytime, identificationtime, identificationtype", (QFilter[])new QFilter[]{workItemFilter, bizIdFilter, dataSourceFilter, statusFilter});
        Date curDate = new Date();
        for (DynamicObject updateRecord : updateRecords) {
            DynamicObject bizBillObj = updateBizMap.get(updateRecord.getString("bizbillid"));
            DynamicObjectType dt = bizBillObj.getDynamicObjectType();
            updateRecord.set("actualendtime", (Object)this.getActualEndDate(bizBillObj));
            updateRecord.set("sysbill", workItem.get("sysbill"));
            DynamicProperty numProp = dt.getProperty("billno");
            if (numProp != null) {
                updateRecord.set("bizbillno", (Object)bizBillObj.getString("billno"));
            } else {
                updateRecord.set("bizbillno", (Object)bizBillObj.getString("number"));
            }
            updateRecord.set("modifytime", (Object)curDate);
            updateRecord.set("auditdate", (Object)curDate);
            updateRecord.set("identificationtime", (Object)curDate);
            updateRecord.set("identificationtype", (Object)SupervisionIdentTypeEnum.AUDIT.getValue());
            updateRecordList.add(updateRecord);
        }
    }

    protected void generateFinishRecord(List<DynamicObject> newRecordList, DynamicObject workItem, List<String> newBizIdList) {
        if (newBizIdList == null || newBizIdList.isEmpty()) {
            return;
        }
        DynamicObject sysBillObj = workItem.getDynamicObject("sysbill");
        DynamicObject sysBill = sysBillObj.getDynamicObject("sysbill");
        String formBillId = sysBill.getString("number");
        List newBizIds = newBizIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", newBizIds);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formBillId);
        DynamicProperty auditDate = dt.getProperty("auditdate");
        if (auditDate != null) {
            DynamicObject[] metaBills = BusinessDataServiceHelper.load((String)formBillId, (String)"billno, auditdate,creator", (QFilter[])new QFilter[]{idFilter}, (String)"auditdate asc");
            this.generateFinishRecord(newRecordList, workItem, metaBills);
        } else {
            DynamicObject[] metaBills = BusinessDataServiceHelper.load((String)formBillId, (String)"number, modifytime,creator", (QFilter[])new QFilter[]{idFilter}, (String)"modifytime asc");
            this.generateFinishRecord(newRecordList, workItem, metaBills);
        }
    }

    protected void generateFinishRecord(List<DynamicObject> newRecordList, DynamicObject workItem, DynamicObject[] bizBills) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmfs_supervisionfinish");
        Date curdate = new Date();
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("pmfs_supervisionfinish", bizBills.length);
        int index = 0;
        for (DynamicObject bizBill : bizBills) {
            long mainOrgId;
            DynamicObject spvFinishRecord = new DynamicObject((DynamicObjectType)dt);
            spvFinishRecord.set("id", (Object)ids[index++]);
            DynamicObject project = workItem.getDynamicObject("project");
            spvFinishRecord.set("project", (Object)project);
            spvFinishRecord.set("org", project.get("pmascreateorg"));
            spvFinishRecord.set("workitem", (Object)workItem);
            DynamicObjectType bizDt = bizBill.getDynamicObjectType();
            DynamicProperty billnoProp = bizDt.getProperty("billno");
            Date actualEndDate = this.getActualEndDate(bizBill);
            spvFinishRecord.set("actualendtime", (Object)actualEndDate);
            spvFinishRecord.set("sysbill", workItem.get("sysbill"));
            if (billnoProp != null) {
                spvFinishRecord.set("bizbillno", bizBill.get("billno"));
            } else {
                spvFinishRecord.set("bizbillno", bizBill.get("number"));
            }
            spvFinishRecord.set("bizbillid", (Object)bizBill.getPkValue().toString());
            spvFinishRecord.set("billno", (Object)this.getBillNoByTime(curdate));
            spvFinishRecord.set("description", (Object)ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u626b\u63cf\u81ea\u52a8\u751f\u6210\u3002", (String)"UpdateSupervisionTask_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            spvFinishRecord.set("datasource", (Object)SupervisionDatasourceEnum.SYSTEM.getValue());
            spvFinishRecord.set("identificationtype", (Object)SupervisionIdentTypeEnum.AUDIT.getValue());
            spvFinishRecord.set("identificationtime", (Object)curdate);
            spvFinishRecord.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            spvFinishRecord.set("createtime", (Object)curdate);
            spvFinishRecord.set("modifytime", (Object)curdate);
            spvFinishRecord.set("auditdate", (Object)curdate);
            spvFinishRecord.set("creator", bizBill.get("creator"));
            if (bizBill.get("creator") != null && (mainOrgId = UserServiceHelper.getUserMainOrgId((long)((Long)bizBill.getDynamicObject("creator").getPkValue()))) != 0L) {
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)mainOrgId, (String)"bos_org");
                spvFinishRecord.set("createorg", (Object)org);
            }
            newRecordList.add(spvFinishRecord);
        }
    }

    private Date getActualEndDate(DynamicObject bizBill) {
        Date actualEndDate;
        DynamicObjectType bizDt = bizBill.getDynamicObjectType();
        DynamicProperty auditdateProp = bizDt.getProperty("auditdate");
        if (auditdateProp == null) {
            actualEndDate = bizBill.getDate("modifytime");
        } else {
            actualEndDate = bizBill.getDate("auditdate");
            if (actualEndDate == null) {
                actualEndDate = bizBill.getDate("modifytime");
            }
        }
        return actualEndDate;
    }

    @NotNull
    private DynamicObject getAuditDate(List<DynamicObject> outBuidgetList, List<DynamicObject> inBuidgetList, DynamicObject bizBill, DynamicObject spvFinishRecord) {
        boolean isSys;
        String formBillId = bizBill.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)formBillId, (CharSequence)"pmas_outbudget")) {
            boolean isSys2 = (bizBill = BusinessDataServiceHelper.loadSingle((Object)bizBill.getPkValue(), (String)formBillId)).getBoolean("issys");
            if (isSys2) {
                DynamicObject bizProject = bizBill.getDynamicObject("project");
                QFilter proFilter = new QFilter("pro", "=", bizProject.getPkValue());
                DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"auditor, auditdate", (QFilter[])new QFilter[]{proFilter});
                bizBill.set("auditor", proApp.get("auditor"));
                bizBill.set("auditdate", proApp.get("auditdate"));
                outBuidgetList.add(bizBill);
                spvFinishRecord.set("actualendtime", proApp.get("auditdate"));
            }
        } else if (StringUtils.equals((CharSequence)formBillId, (CharSequence)"pmas_inbudget") && (isSys = (bizBill = BusinessDataServiceHelper.loadSingle((Object)bizBill.getPkValue(), (String)formBillId)).getBoolean("issys"))) {
            DynamicObject bizProject = bizBill.getDynamicObject("project");
            QFilter proFilter = new QFilter("pro", "=", bizProject.getPkValue());
            DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"auditor, auditdate", (QFilter[])new QFilter[]{proFilter});
            bizBill.set("auditor", proApp.get("auditor"));
            bizBill.set("auditdate", proApp.get("auditdate"));
            inBuidgetList.add(bizBill);
            spvFinishRecord.set("actualendtime", proApp.get("auditdate"));
        }
        return bizBill;
    }

    protected String getBillNoByTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(date));
        sb.append('-');
        String time = date.getTime() + "";
        int length = time.length();
        String last4Time = time.substring(length - 4, length);
        sb.append(last4Time);
        return sb.toString();
    }
}

