/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmim.common.enums.InvestConclusionEnum;
import kd.pmgt.pmim.common.enums.InvestCycleEnum;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class InvestPlanSpecApproEditPlugin
extends AbstractPmimBillPlugin
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_DEL = "btndel";
    private static final String SELECTOR_All = "project, entryinvesttype, entryinvestcycle, entryinvestperiod, entryinvestamt, entrycurinvestamt, specialorg, specialperson, entryclaimdate, claimtype, conclusion, suporg, entryauditdesc, finalstate, isvalid, preentryid, sourceentryid, entrycurrency, islatest, projectnum, projectname,investentry.id, investentry.fundsourcetype, investentry.entryamt, investentry.currententryamt, investentry.comment,";
    private static final String ENTRY_PROJECT = "projectentry";
    private static final String ENTRY_INVEST = "investentry";
    private static final String ENTRY_SUBENTRYENTITY = "subentryentity";
    private static final String ENTRY_ENTRYENTITY = "entryentity";
    private static final String PROJECTRECORD_FORMID = "pmim_invesclaimtrecord";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_PROJECT);
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        Button addBtn = (Button)this.getView().getControl(BTN_ADD);
        Button delBtn = (Button)this.getView().getControl(BTN_DEL);
        if (addBtn != null) {
            addBtn.addClickListener((ClickListener)this);
        }
        if (delBtn != null) {
            delBtn.addClickListener((ClickListener)this);
        }
        BasedataEdit listBillF7 = (BasedataEdit)this.getView().getControl("subsuporg");
        listBillF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount(ENTRY_PROJECT);
        if (rowCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"investpanel"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"investcycle"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"yearperiod"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"monthperiod"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"investpanel"});
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PROJECT);
            this.setRightPanelVal(rowIndex);
            DynamicObjectCollection entryProjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PROJECT);
            for (DynamicObject entryProject : entryProjects) {
                String conclusion = entryProject.getString("conclusion");
                entryProject.set("showconclusion", (Object)conclusion);
            }
            this.getModel().updateEntryCache(entryProjects);
            this.getView().updateView(ENTRY_PROJECT);
        }
    }

    private void setRightPanelVal(int rowIndex) {
        String preentryId = (String)this.getModel().getValue("preentryid", rowIndex);
        if (StringUtils.isEmpty((CharSequence)preentryId)) {
            return;
        }
        QFilter preIdFilter = new QFilter("id", "=", (Object)Long.parseLong(preentryId));
        DynamicObject preObj = BusinessDataServiceHelper.loadSingle((String)PROJECTRECORD_FORMID, (String)SELECTOR_All, (QFilter[])new QFilter[]{preIdFilter});
        DynamicObject specialOrg = preObj.getDynamicObject("specialorg");
        DynamicObject specialPerson = preObj.getDynamicObject("specialperson");
        Date claimDate = preObj.getDate("entryclaimdate");
        BigDecimal planInvTotalAmt = (BigDecimal)this.getModel().getValue("entryinvestamt", rowIndex);
        BigDecimal curInvTotalAmt = (BigDecimal)this.getModel().getValue("entrycurinvestamt", rowIndex);
        String conclusion = (String)this.getModel().getValue("conclusion", rowIndex);
        DynamicObject supOrg = (DynamicObject)this.getModel().getValue("suporg", rowIndex);
        String finalState = (String)this.getModel().getValue("finalstate", rowIndex);
        String auditDesc = (String)this.getModel().getValue("entryauditdesc", rowIndex);
        this.getModel().setValue("declareorg", (Object)specialOrg);
        this.getModel().setValue("claimperson", (Object)specialPerson);
        this.getModel().setValue("claimdate", (Object)claimDate);
        this.getModel().setValue("planinvtotalamt", (Object)planInvTotalAmt);
        this.getModel().setValue("curinvtotalamt", (Object)curInvTotalAmt);
        this.getModel().setValue("subconclusion", (Object)conclusion);
        ComboEdit conclusionCtl = (ComboEdit)this.getControl("subconclusion");
        conclusionCtl.setMustInput(true);
        if ("reportsup".equals(conclusion)) {
            OrgEdit subsuporg = (OrgEdit)this.getControl("subsuporg");
            subsuporg.setMustInput(true);
            this.getModel().setValue("subsuporg", (Object)supOrg);
        }
        this.getModel().setValue("subfinalstate", (Object)finalState);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) && ("pass".equals(finalState) || "nopass".equals(finalState))) {
            this.getModel().setValue("showconclusion", (Object)finalState);
        }
        this.getModel().setValue("subdescription", (Object)auditDesc);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRY_PROJECT, (CharSequence)source.getKey())) {
            int rowIndex = evt.getRow();
            this.setRightPanelVal(rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"addproject", (CharSequence)key)) {
            this.addProject();
        } else if (StringUtils.equals((CharSequence)"deleteproentry", (CharSequence)key)) {
            this.deleteProject();
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PROJECT);
            DynamicObject proEntry = this.getModel().getEntryRowEntity(ENTRY_PROJECT, rowIndex);
            if (proEntry == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u5f85\u5ba1\u6279\u9879\u76ee\u3002", (String)"InvestPlanSpecApproEditPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject item = this.getModel().getEntryRowEntity(ENTRY_PROJECT, arg0.getRowIndex());
        DynamicObject proObj = item.getDynamicObject("project");
        Object proPk = proObj.getPkValue();
        QFilter proFilter = new QFilter("pro", "=", proPk);
        DynamicObject approveObj = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{proFilter});
        HashMap<String, Object> custormMap = new HashMap<String, Object>();
        custormMap.put("proAppId", approveObj.getPkValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", "pmba_projectkanban");
        map.put("customParams", custormMap);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private void deleteProject() {
        int curIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PROJECT);
        DynamicObject proEntryObj = this.getModel().getEntryRowEntity(ENTRY_PROJECT, curIndex);
        if (proEntryObj == null) {
            return;
        }
        Object proEntryObjId = proEntryObj.getPkValue();
        QFilter proEntryObjFilter = new QFilter("id", "=", proEntryObjId);
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((String)PROJECTRECORD_FORMID, (String)SELECTOR_All, (QFilter[])new QFilter[]{proEntryObjFilter});
        if (recordObj == null) {
            return;
        }
        ArrayList<DynamicObject> preObjList = new ArrayList<DynamicObject>(10);
        boolean islatest = recordObj.getBoolean("islatest");
        String preId = (String)recordObj.get("preentryid");
        QFilter preIdFilter = new QFilter("id", "=", (Object)Long.parseLong(preId));
        DynamicObject preObj = BusinessDataServiceHelper.loadSingle((String)PROJECTRECORD_FORMID, (String)SELECTOR_All, (QFilter[])new QFilter[]{preIdFilter});
        if (preObj != null) {
            preObj.set("islatest", (Object)Boolean.TRUE);
            preObjList.add(preObj);
        }
        SaveServiceHelper.save((DynamicObject[])preObjList.toArray(new DynamicObject[preObjList.size()]));
    }

    private void addProject() {
        SimpleDateFormat sdf;
        Date investPeriod;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String orgValue = org.getString("name");
        String investcycle = (String)model.getValue("investcycle");
        String periodStr = "";
        if (StringUtils.equals((CharSequence)investcycle, (CharSequence)InvestCycleEnum.Year.getValue())) {
            investPeriod = (Date)model.getValue("yearperiod");
            sdf = new SimpleDateFormat("yyyy", Locale.getDefault());
            periodStr = sdf.format(investPeriod);
        } else if (StringUtils.equals((CharSequence)investcycle, (CharSequence)InvestCycleEnum.Month.getValue())) {
            investPeriod = (Date)model.getValue("monthperiod");
            sdf = new SimpleDateFormat("yyyy-MM", Locale.getDefault());
            periodStr = sdf.format(investPeriod);
        }
        if (StringUtils.isEmpty((CharSequence)orgValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e13\u9879\u5ba1\u6279\u7ec4\u7ec7\u3002", (String)"InvestPlanSpecApproEditPlugin_1", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> idList = new ArrayList<Long>(10);
        int rowCount = model.getEntryRowCount(ENTRY_PROJECT);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject project = model.getEntryRowEntity(ENTRY_PROJECT, i);
            if (project == null) continue;
            idList.add(project.getLong("preentryid"));
        }
        QFilter idListFilter = null;
        if (idList != null && !idList.isEmpty()) {
            idListFilter = new QFilter("id", "not in", idList);
        }
        QFilter investcycleFilter = new QFilter("entryinvestcycle", "=", (Object)investcycle);
        QFilter periodFilter = new QFilter("entryinvestperiod", "=", (Object)periodStr);
        QFilter conclusionFilter = new QFilter("conclusion", "=", (Object)InvestConclusionEnum.ReportSup.getValue());
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)Boolean.TRUE);
        QFilter filter = new QFilter("suporg.id", "=", org.getPkValue()).and(investcycleFilter).and(periodFilter).and(conclusionFilter).and(isLatestFilter);
        if (idListFilter != null) {
            filter.and(idListFilter);
        }
        ListShowParameter para = ShowFormHelper.createShowListForm((String)PROJECTRECORD_FORMID, (boolean)true);
        para.getListFilterParameter().getQFilters().add(filter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PROJECTRECORD_FORMID);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        int rowCount;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"deleteproentry", (CharSequence)key) && (rowCount = this.getModel().getEntryRowCount(ENTRY_PROJECT)) == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"investpanel"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"investcycle"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"yearperiod"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"monthperiod"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)PROJECTRECORD_FORMID) && returnData != null) {
            ListSelectedRowCollection claimProjectCollection = (ListSelectedRowCollection)returnData;
            ArrayList<Object> claimProjectIdList = new ArrayList<Object>(claimProjectCollection.size());
            for (ListSelectedRow claimProjectRow : claimProjectCollection) {
                claimProjectIdList.add(claimProjectRow.getPrimaryKeyValue());
            }
            DynamicObject[] recordObjs = BusinessDataServiceHelper.load((Object[])claimProjectIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PROJECTRECORD_FORMID));
            if (recordObjs == null || recordObjs.length <= 0) {
                return;
            }
            IDataModel model = this.getModel();
            for (DynamicObject recordObj : recordObjs) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"investpanel"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"investcycle"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"yearperiod"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"monthperiod"});
                DynamicObject project = (DynamicObject)recordObj.get("project");
                String claimType = (String)recordObj.get("claimtype");
                DynamicObject specialOrg = (DynamicObject)recordObj.get("specialorg");
                DynamicObject specialPerson = (DynamicObject)recordObj.get("specialperson");
                Date claimDate = (Date)recordObj.get("entryclaimdate");
                BigDecimal planInvTotalAmt = (BigDecimal)recordObj.get("entryinvestamt");
                BigDecimal curInvTotalAmt = (BigDecimal)recordObj.get("entrycurinvestamt");
                boolean isValid = (Boolean)recordObj.get("isvalid");
                String preId = recordObj.getPkValue().toString();
                String sourceId = recordObj.getString("sourceentryid");
                DynamicObject entryCurrency = (DynamicObject)recordObj.get("entrycurrency");
                String projectNum = recordObj.getString("projectnum");
                String projectName = recordObj.getString("projectname");
                model.setValue("currency", (Object)entryCurrency);
                int rowIndex = model.createNewEntryRow(ENTRY_PROJECT);
                model.setValue("project", (Object)project, rowIndex);
                model.setValue("claimtype", (Object)claimType, rowIndex);
                model.setValue("entryinvestamt", (Object)planInvTotalAmt, rowIndex);
                model.setValue("entrycurinvestamt", (Object)curInvTotalAmt, rowIndex);
                model.setValue("conclusion", (Object)"pass", rowIndex);
                model.setValue("showconclusion", (Object)"pass", rowIndex);
                model.setValue("finalstate", (Object)"pass", rowIndex);
                model.setValue("isvalid", (Object)isValid, rowIndex);
                model.setValue("preentryid", (Object)preId, rowIndex);
                model.setValue("sourceentryid", (Object)sourceId, rowIndex);
                model.setValue("entrycurrency", (Object)entryCurrency, rowIndex);
                model.setValue("projectnum", (Object)projectNum, rowIndex);
                model.setValue("projectname", (Object)projectName, rowIndex);
                this.getModel().updateCache();
                CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_PROJECT);
                cardEntry.selectRows(rowIndex, true);
                model.setValue("declareorg", (Object)specialOrg);
                model.setValue("claimperson", (Object)specialPerson);
                model.setValue("claimdate", (Object)claimDate);
                model.setValue("planinvtotalamt", (Object)planInvTotalAmt);
                model.setValue("curinvtotalamt", (Object)curInvTotalAmt);
                DynamicObject curProjectEntryObj = model.getEntryRowEntity(ENTRY_PROJECT, rowIndex);
                this.setInvestDetailEntry(recordObj, curProjectEntryObj);
                this.setInvestAttachEntry(recordObj, curProjectEntryObj);
                DynamicObjectCollection entryProjects = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_PROJECT);
                entryProjects.set(rowIndex, (Object)curProjectEntryObj);
                this.getModel().updateEntryCache(entryProjects);
                this.getView().updateView(ENTRY_INVEST);
                this.getView().updateView(ENTRY_SUBENTRYENTITY);
            }
        }
    }

    private void setInvestAttachEntry(DynamicObject recordObj, DynamicObject curProjectEntryObj) {
        DynamicObjectCollection oldAttachmentfield = (DynamicObjectCollection)recordObj.get(ENTRY_ENTRYENTITY);
        DynamicObjectCollection attachCols = curProjectEntryObj.getDynamicObjectCollection(ENTRY_SUBENTRYENTITY);
        DynamicObjectType attachDt = attachCols.getDynamicObjectType();
        DynamicObject attach = null;
        DynamicObject planAttach = null;
        if (oldAttachmentfield != null && oldAttachmentfield.size() > 0) {
            for (DynamicObject oldAttach : oldAttachmentfield) {
                attach = new DynamicObject(attachDt);
                DynamicObjectCollection planAttchCols = attach.getDynamicObjectCollection("planattch");
                DynamicObjectType planAttachDt = planAttchCols.getDynamicObjectType();
                if (oldAttach.getDynamicObjectCollection("planattch").size() > 0) {
                    for (DynamicObject oldPlanAttch : oldAttach.getDynamicObjectCollection("planattch")) {
                        planAttach = new DynamicObject(planAttachDt);
                        long attchmentId = DB.genLongId((String)"t_pmim_planattch");
                        planAttach.set("fpkid", (Object)attchmentId);
                        planAttach.set("fbasedataid", (Object)oldPlanAttch.getDynamicObject("fbasedataid"));
                        planAttchCols.add((Object)planAttach);
                    }
                    attach.set("planattch", (Object)planAttchCols);
                    attach.set("attchtext", (Object)"text");
                    attachCols.add((Object)attach);
                    continue;
                }
                attach.set("attchtext", (Object)"text");
                attachCols.add((Object)attach);
            }
        } else {
            attach = new DynamicObject(attachDt);
            attach.set("attchtext", (Object)"text");
            attachCols.add((Object)attach);
        }
        this.getModel().updateEntryCache(attachCols);
        this.getView().updateView(ENTRY_SUBENTRYENTITY);
    }

    public void setInvestDetailEntry(DynamicObject recordObj, DynamicObject curProjectEntryObj) {
        DynamicObjectCollection oldInvestDetailCols = recordObj.getDynamicObjectCollection(ENTRY_INVEST);
        DynamicObjectCollection curInvestDetailCols = curProjectEntryObj.getDynamicObjectCollection(ENTRY_INVEST);
        DynamicObjectType dt = curInvestDetailCols.getDynamicObjectType();
        if (oldInvestDetailCols != null && oldInvestDetailCols.size() > 0) {
            for (DynamicObject oldInvestDetail : oldInvestDetailCols) {
                DynamicObject investDetail = new DynamicObject(dt);
                investDetail.set("fundsourcetype", oldInvestDetail.get("fundsourcetype"));
                investDetail.set("planinvestamt", oldInvestDetail.get("entryamt"));
                investDetail.set("curinvestamt", oldInvestDetail.get("currententryamt"));
                investDetail.set("comment", oldInvestDetail.get("comment"));
                investDetail.set("formofinvest", oldInvestDetail.get("formofinvest"));
                investDetail.set("investcurrency", oldInvestDetail.get("investcurrency"));
                investDetail.set("scale", oldInvestDetail.get("scale"));
                curInvestDetailCols.add((Object)investDetail);
            }
        }
        this.getModel().updateEntryCache(curInvestDetailCols);
        this.getView().updateView(ENTRY_INVEST);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int curIndex = -1;
        switch (key) {
            case "subconclusion": {
                curIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PROJECT);
                if ("pass".equals(propValue)) {
                    this.getModel().setValue("subfinalstate", (Object)"pass");
                    this.getModel().setValue("conclusion", (Object)"pass", curIndex);
                    this.getModel().setValue("showconclusion", (Object)"pass", curIndex);
                    this.getModel().setValue("finalstate", (Object)"pass", curIndex);
                    this.getModel().setValue("subsuporg", null, curIndex);
                    break;
                }
                if ("nopass".equals(propValue)) {
                    this.getModel().setValue("subfinalstate", (Object)"nopass");
                    this.getModel().setValue("conclusion", (Object)"nopass", curIndex);
                    this.getModel().setValue("showconclusion", (Object)"nopass", curIndex);
                    this.getModel().setValue("finalstate", (Object)"nopass", curIndex);
                    this.getModel().setValue("subsuporg", null, curIndex);
                    break;
                }
                if (!"reportsup".equals(propValue)) break;
                String finalState = (String)this.getModel().getValue("finalstate", curIndex);
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) && ("pass".equals(finalState) || "nopass".equals(finalState))) {
                    this.getModel().setValue("finalstate", (Object)finalState, curIndex);
                    this.getModel().setValue("showconclusion", (Object)finalState);
                    break;
                }
                OrgEdit subSupOrg = (OrgEdit)this.getControl("subsuporg");
                subSupOrg.setMustInput(true);
                this.setReportOrg(curIndex);
                this.getModel().setValue("subfinalstate", (Object)"auditing");
                this.getModel().setValue("conclusion", (Object)"reportsup", curIndex);
                this.getModel().setValue("showconclusion", null, curIndex);
                this.getModel().setValue("finalstate", (Object)"auditing", curIndex);
                break;
            }
            case "subdescription": {
                curIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PROJECT);
                this.getModel().setValue("entryauditdesc", propValue, curIndex);
                break;
            }
            case "subsuporg": {
                curIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PROJECT);
                this.getModel().setValue("suporg", propValue, curIndex);
                break;
            }
        }
    }

    private void setReportOrg(int curIndex) {
        QFilter billFilter = new QFilter("billcode.number", "=", (Object)"pmim_specialapproval");
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject reqOrgConf = BusinessDataServiceHelper.loadSingle((String)"pmbs_reqorgconf", (String)"billcode,entryentity,reportorg,declarateorg,enable,projectkind", (QFilter[])new QFilter[]{billFilter, enableFilter});
        if (reqOrgConf == null) {
            return;
        }
        DynamicObjectCollection entryEntity = reqOrgConf.getDynamicObjectCollection(ENTRY_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (org != null) {
            DynamicObject kind;
            DynamicObject reportOrg = null;
            for (kind = project.getDynamicObject("group"); kind != null; kind = kind.getDynamicObject("parent")) {
                reportOrg = this.getReportOrg(org, kind, entryEntity);
                if (reportOrg != null) {
                    this.getModel().setValue("subsuporg", (Object)reportOrg, curIndex);
                    break;
                }
                kind = BusinessDataServiceHelper.loadSingle((Object)kind.getPkValue(), (String)"bd_projectkind");
            }
            if (kind == null && reportOrg == null) {
                reportOrg = this.getReportOrg(org, kind, entryEntity);
                this.getModel().setValue("subsuporg", (Object)reportOrg, curIndex);
            }
        }
    }

    private DynamicObject getReportOrg(DynamicObject org, DynamicObject kind, DynamicObjectCollection entryEntity) {
        for (DynamicObject entryRow : entryEntity) {
            DynamicObject projectKind = entryRow.getDynamicObject("projectkind");
            if (kind != null ? projectKind == null || !StringUtils.equals((CharSequence)projectKind.getPkValue().toString(), (CharSequence)kind.getPkValue().toString()) : projectKind != null) continue;
            DynamicObjectCollection declarateOrgList = entryRow.getDynamicObjectCollection("declarateorg");
            for (DynamicObject declarateOrg : declarateOrgList) {
                if (!declarateOrg.getDynamicObject("fbasedataid").getPkValue().equals(org.getPkValue())) continue;
                DynamicObject reportOrg = entryRow.getDynamicObject("reportorg");
                return reportOrg;
            }
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("subsuporg".equals(key)) {
            String subConCluSion = dataEntity.getString("subconclusion");
            if (InvestConclusionEnum.ReportSup.getValue().equals(subConCluSion)) {
                DynamicObject declareOrg;
                List qFilters = param.getListFilterParameter().getQFilters();
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org != null) {
                    qFilters.add(new QFilter("id", "!=", org.getPkValue()));
                }
                if ((declareOrg = dataEntity.getDynamicObject("declareorg")) != null) {
                    qFilters.add(new QFilter("id", "!=", declareOrg.getPkValue()));
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }
}

