/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.AuthProjectKindHelper;
import kd.pmgt.pmbs.business.support.LeftTreeRightGridBillSupport;
import kd.pmgt.pmbs.business.utils.ReportConfigUtils;
import kd.pmgt.pmbs.common.enums.DocuimentTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmim.business.helper.AunualinvesPlanHelper;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class AunualinvesPlanBillPlugin
extends AbstractPmimBillPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
HyperLinkClickListener,
TipsListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(AunualinvesPlanBillPlugin.class);
    private static final String CURRENTTREENODE = "currentTreeNode";
    private static final String CURRENT_GRID_ROW_NO = "currentgridrowno";
    private static final String ROOTNODEID = "001";
    private static final String CALL_BACK_REPORT_ORG = "callbackreportorg";
    private static final String CTRL_proSelect = "selectpro";
    private static final String CTRL_secReserve = "secreserve";
    private static final String CTRL_addFunSource = "newfunsource";
    private static final String CTRL_deleteFunSource = "deletefunsource";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.TRUE, new String[]{"billname"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"billno"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"year"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"description"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"inventry"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
        Object billOrg = this.getModel().getValue("org");
        if (billOrg == null) {
            long orgId = RequestContext.get().getOrgId();
            DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            this.getModel().setValue("org", (Object)orgObject);
        }
        if (this.getModel().getValue("org") != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject currency = CurrencyHelper.getCurrency((Long)Long.parseLong(org.getPkValue().toString()));
            this.getModel().setValue("currency", (Object)currency);
            AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)"projectkindtree", (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"AunualinvesPlanBillPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)Long.parseLong(org.getPkValue().toString()));
            this.getPageCache().put(CURRENTTREENODE, ROOTNODEID);
            this.treeDataUpdateView(ROOTNODEID);
        }
    }

    public void afterLoadData(EventObject e) {
        FormShowParameter formShowParameter;
        Object isView;
        DynamicObject aunLivesPlan;
        super.afterLoadData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)"projectkindtree", (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"AunualinvesPlanBillPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)Long.parseLong(org.getPkValue().toString()));
        }
        if ("D".equals((aunLivesPlan = this.getModel().getDataEntity(true)).getString("billstatus"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"billno"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"billname"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"year"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"description"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"inventry"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
        if ((isView = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("isView")) != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"report"});
        }
        this.getPageCache().put(CURRENTTREENODE, ROOTNODEID);
        this.treeDataUpdateView(ROOTNODEID);
        this.updateControlMetadata();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FieldEdit planAmtFieldEdit = (FieldEdit)this.getView().getControl("annualstrategicplanamt");
        planAmtFieldEdit.addTipsListener((TipsListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl("inventry_reportorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String ctrlName = e.getProperty().getName();
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        ChangeData changeData = e.getChangeSet()[0];
        switch (ctrlName) {
            case "year": {
                String documentType = aunLivesPlan.getString("docuimenttype");
                if (DocuimentTypeEnum.DECLARE.getValue().equals(documentType) && this.isExistDeclareRecord(changeData.getNewValue()).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u8be5\u5e74\u5ea6\u7684\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u62a5\u3002", (String)"AunualinvesPlanBillPlugin_14", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("year", changeData.getOldValue());
                    this.getModel().endInit();
                    this.getView().updateView("year");
                    return;
                }
                DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("inventry");
                entries.clear();
                this.getView().updateView("inventry");
                this.getModel().setValue("investbudamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("financialexbudamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("investbudaddamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("financialexbudaddamt", (Object)BigDecimal.ZERO);
                if (changeData.getNewValue() == null) {
                    this.getModel().setValue("annualstrategicplanamt", (Object)BigDecimal.ZERO);
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"annualstrategicplanamt"});
                    break;
                }
                Date declareDate = (Date)changeData.getNewValue();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                BigDecimal annualStrategicPlanAmt = BigDecimal.ZERO;
                if (org != null) {
                    annualStrategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, org);
                }
                this.getModel().setValue("annualstrategicplanamt", (Object)annualStrategicPlanAmt);
                if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0) {
                    this.updateControlMetadata();
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"annualstrategicplanamt"});
                break;
            }
            case "currententryamt": {
                this.changeCurEntryAmt();
                break;
            }
            case "entryamt": {
                this.changeEntryAmt();
                this.autoCalculationScale();
                break;
            }
            case "investbudamt": {
                this.updateControlMetadata();
                break;
            }
        }
    }

    private void autoCalculationScale() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("inventry");
        if (entries.size() > 0) {
            DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
            BigDecimal proInvestSumAmt = invEntry.getBigDecimal("projcetbugamt");
            DynamicObjectCollection functionEntry = invEntry.getDynamicObjectCollection("funsourceentry");
            for (int i = 0; i < functionEntry.size(); ++i) {
                DynamicObject funSource = (DynamicObject)functionEntry.get(i);
                if (proInvestSumAmt.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal entryAmt = funSource.getBigDecimal("entryamt");
                    BigDecimal scale = entryAmt.divide(proInvestSumAmt, 4, 4).multiply(new BigDecimal(100));
                    funSource.set("scale", (Object)scale);
                    continue;
                }
                funSource.set("scale", (Object)BigDecimal.ZERO);
            }
            this.getView().updateView("funsourceentry");
        }
    }

    private void changeEntryAmt() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("inventry");
        if (entries.size() > 0) {
            DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
            this.sumProInvestSumAmt(invEntry);
            this.updateViewEntry();
        }
        this.getView().updateView("inventry", selectRows[0]);
        this.focusLastRow(selectRows[0]);
    }

    private void changeCurEntryAmt() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("inventry");
        if (entries.size() > 0) {
            DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
            this.sumDeclareAmt(invEntry);
        }
        this.summaryAunLivesPlanAmt();
        this.getView().updateView("inventry", selectRows[0]);
        this.focusLastRow(selectRows[0]);
    }

    private Boolean isExistDeclareRecord(Object newValue) {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        DynamicObject org = aunLivesPlan.getDynamicObject("org");
        boolean isExist = false;
        if (newValue != null && org != null) {
            Date declareDate = (Date)newValue;
            int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            qFilter.and("YEAR(year)", "=", (Object)declareYear);
            qFilter.and("docuimenttype", "=", (Object)DocuimentTypeEnum.DECLARE.getValue());
            DynamicObject[] declareBills = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (declareBills.length > 0) {
                isExist = true;
            }
        }
        return isExist;
    }

    private void sumDeclareAmt(DynamicObject invEntry) {
        DynamicObjectCollection funSources = invEntry.getDynamicObjectCollection("funsourceentry");
        BigDecimal declareAmt = BigDecimal.ZERO;
        if (funSources.size() > 0) {
            declareAmt = funSources.stream().map(o -> o.getBigDecimal("currententryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        invEntry.set("inventry_anlinvesdeclamt", (Object)declareAmt);
        invEntry.set("inventry_approveamt", (Object)declareAmt);
        BigDecimal oriAunLinesAmt = invEntry.getBigDecimal("inventry_oriannualincest");
        invEntry.set("inventry_investbudincrea", (Object)declareAmt.subtract(oriAunLinesAmt));
    }

    private void sumProInvestSumAmt(DynamicObject invEntry) {
        DynamicObjectCollection funSources = invEntry.getDynamicObjectCollection("funsourceentry");
        BigDecimal proInvestSumAmt = BigDecimal.ZERO;
        if (funSources.size() > 0) {
            proInvestSumAmt = funSources.stream().map(o -> o.getBigDecimal("entryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        invEntry.set("projcetbugamt", (Object)proInvestSumAmt);
        invEntry.set("projcetbugappamt", (Object)proInvestSumAmt);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String ctrlName;
        this.getPageCache().put(CURRENT_GRID_ROW_NO, String.valueOf(e.getRowIndex()));
        FieldEdit fieldEdit = (FieldEdit)e.getSource();
        switch (ctrlName = fieldEdit.getProperty().getName()) {
            case "entryamt": 
            case "fundsourcetype": 
            case "formofinvest": 
            case "currententryamt": 
            case "investcurrency": 
            case "comment": 
            case "scale": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("inventry");
                int[] selectRows = grid.getSelectRows();
                if (selectRows.length == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6295\u8d44\u6e05\u5355\u8bb0\u5f55\u3002", (String)"AunualinvesPlanBillPlugin_4", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "inventry_approvalcon": {
                DynamicObject selectDyObject = this.selectDynamicObject();
                String curValue = e.getValue().toString();
                if ("report".equals(curValue)) {
                    DynamicObject projectKind = selectDyObject.getDynamicObject("inventry_projectkind");
                    if (null != projectKind) {
                        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
                        DynamicObject org = aunLivesPlan.getDynamicObject("org");
                        DynamicObject reportOrg = ReportConfigUtils.gainReportorg((String)projectKind.getPkValue().toString(), (String)org.getPkValue().toString(), (String)this.getView().getEntityId());
                        if (reportOrg != null) {
                            selectDyObject.set("inventry_reportorg", (Object)reportOrg);
                            selectDyObject.set("inventry_approvalcon", (Object)curValue);
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u9879\u76ee\u4e91>\u57fa\u7840\u8d44\u6599>\u4e0a\u62a5\u7ec4\u7ec7\u5c42\u7ea7\u8bbe\u7f6e\u201d\u4e2d\u7ef4\u62a4\u4e0a\u62a5\u7ec4\u7ec7\uff0c\u5f53\u524d\u201c\u4e0a\u62a5\u7ec4\u7ec7\u8bbe\u7f6e\u201d\u4e3a\u7a7a\u3002", (String)"AunualinvesPlanBillPlugin_15", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                            selectDyObject.set("inventry_reportorg", null);
                        }
                    }
                } else {
                    selectDyObject.set("inventry_reportorg", null);
                    selectDyObject.set("inventry_approvalcon", (Object)curValue);
                }
                String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
                this.treeDataUpdateView(currentTreeNodeId);
                this.summaryAunLivesPlanAmt();
                e.setCancel(true);
                break;
            }
            case "inventry_approveamt": {
                DynamicObject selectDyObject = this.selectDynamicObject();
                BigDecimal approveAmt = NumberHelper.toBigDecimal((Object)e.getValue());
                BigDecimal oriAunLinesAmt = selectDyObject.getBigDecimal("inventry_oriannualincest");
                selectDyObject.set("inventry_investbudincrea", (Object)approveAmt.subtract(oriAunLinesAmt));
                selectDyObject.set("inventry_approveamt", (Object)approveAmt);
                String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
                this.treeDataUpdateView(currentTreeNodeId);
                this.summaryAunLivesPlanAmt();
                e.setCancel(true);
                break;
            }
            case "inventry_anlinvesdeclamt": {
                DynamicObject selectDyObject = this.selectDynamicObject();
                BigDecimal investDeclareAmt = NumberHelper.toBigDecimal((Object)e.getValue());
                selectDyObject.set("inventry_approveamt", (Object)investDeclareAmt);
                selectDyObject.set("inventry_anlinvesdeclamt", (Object)investDeclareAmt);
                String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
                this.treeDataUpdateView(currentTreeNodeId);
                this.summaryAunLivesPlanAmt();
                e.setCancel(true);
                break;
            }
            case "inventry_finanapproveamt": {
                DynamicObject selectDyObject = this.selectDynamicObject();
                BigDecimal finApproveAmt = NumberHelper.toBigDecimal((Object)e.getValue());
                BigDecimal oriFinAnCiaLex = selectDyObject.getBigDecimal("inventry_orifinancialex");
                selectDyObject.set("inventry_finaexbudincreas", (Object)finApproveAmt.subtract(oriFinAnCiaLex));
                selectDyObject.set("inventry_finanapproveamt", (Object)finApproveAmt);
                String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
                this.treeDataUpdateView(currentTreeNodeId);
                this.summaryAunLivesPlanAmt();
                e.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteinventry": {
                this.changeEntryColumnIndex();
                break;
            }
            case "newfunsource": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("inventry");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows.length == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6295\u8d44\u6e05\u5355\u8bb0\u5f55\u3002", (String)"AunualinvesPlanBillPlugin_4", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "deletefunsource": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("inventry");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6295\u8d44\u6e05\u5355\u8bb0\u5f55\u3002", (String)"AunualinvesPlanBillPlugin_4", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                EntryGrid subGrid = (EntryGrid)this.getControl("funsourceentry");
                int[] selRows = subGrid.getEntryState().getSelectedRows();
                if (selRows.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AunualinvesPlanBillPlugin_16", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void changeEntryColumnIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
        LeftTreeRightGridBillSupport leftTreeRightGridBillSupport = new LeftTreeRightGridBillSupport("inventry_projectkind", this.buildRootNode(), ((EntryGrid)this.getView().getControl("inventry")).getSelectRows(), this.getModel().getDataEntity(true).getDynamicObjectCollection("inventry"), this.getPageCache().get(CURRENTTREENODE), true);
        int[] newSelectedRows = leftTreeRightGridBillSupport.switchSelectedViewIndex2GridIndex();
        if (newSelectedRows.length > 0) {
            entryGrid.getEntryState().selectRow(newSelectedRows);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "autoimppjproposaldata": {
                this.autoImpProjectProposalData();
                break;
            }
            case "imppjproposaldata": {
                this.showProjectProposalF7Form();
                break;
            }
            case "selectpro": {
                this.showProjectF7Form();
                break;
            }
            case "secreserve": {
                this.showReserveF7From();
                break;
            }
            case "deleteinventry": {
                this.deleteInvestEntry();
                break;
            }
            case "unaudit": {
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"billno"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"billname"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"year"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"description"});
                DynamicObjectCollection invEntries = this.getModel().getEntryEntity("inventry");
                for (int i = 0; i < invEntries.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"inventry_approvalcon"});
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"inventry_approveamt"});
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"inventry_finanapproveamt"});
                    String approvalCon = ((DynamicObject)invEntries.get(i)).getString("inventry_approvalcon");
                    this.getView().setEnable(Boolean.valueOf("report".equals(approvalCon)), i, new String[]{"inventry_reportorg"});
                }
                this.getView().updateView("inventry");
                break;
            }
            case "deletefunsource": {
                DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
                int[] selectRows = entryGrid.getSelectRows();
                DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("inventry");
                if (entries.size() > 0) {
                    DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
                    this.sumDeclareAmt(invEntry);
                    this.sumProInvestSumAmt(invEntry);
                    this.autoCalculationScale();
                }
                this.summaryAunLivesPlanAmt();
                this.getView().updateView("inventry", selectRows[0]);
                this.focusLastRow(selectRows[0]);
                break;
            }
        }
    }

    protected void autoImpProjectProposalData() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        if (null == aunLivesPlan.getDate("year")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"AunualinvesPlanBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.gainProjectProposal(aunLivesPlan);
        this.summaryAunLivesPlanAmt();
        this.getView().updateView();
        String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
        this.treeDataUpdateView(currentTreeNodeId);
    }

    protected void createFunSource(DynamicObject item) {
        Date curDate = (Date)this.getModel().getValue("year");
        LocalDate curLocalDate = curDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        DynamicObjectCollection funSources = item.getDynamicObjectCollection("funsourceentry");
        funSources.clear();
        DynamicObjectCollection fundEntry = null;
        String investListId = item.getString("inventry_investlistid");
        DynamicObject fundSourceBill = null;
        if (StringUtils.isNotEmpty((CharSequence)investListId)) {
            if (QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)investListId)) {
                DynamicObject projectPoSalF7 = BusinessDataServiceHelper.loadSingle((Object)investListId, (String)"pmim_projectproposal_f7");
                fundEntry = projectPoSalF7.getDynamicObjectCollection("funsourceentry");
            } else {
                DynamicObject projectPoSal = BusinessDataServiceHelper.loadSingle((Object)investListId, (String)"pmim_projectproposal");
                fundEntry = projectPoSal.getDynamicObjectCollection("sourceentry");
            }
        } else {
            DynamicObject[] fundSourceBills;
            DynamicObject project = item.getDynamicObject("projectno");
            QFilter qFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
            if (project != null) {
                qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            }
            if ((fundSourceBills = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"year desc")).length > 0) {
                fundSourceBill = BusinessDataServiceHelper.loadSingle((Object)fundSourceBills[0].getPkValue(), (String)"pmas_projfundsource");
                fundEntry = fundSourceBill.getDynamicObjectCollection("fundentry");
            }
        }
        if (fundEntry != null && fundEntry.size() > 0) {
            long[] ids = DB.genLongIds((String)"t_pmim_funsourceentry", (int)fundEntry.size());
            BigDecimal declareAmt = BigDecimal.ZERO;
            BigDecimal proInvestSumAmt = BigDecimal.ZERO;
            for (int i = 0; i < fundEntry.size(); ++i) {
                DynamicObject funSource = (DynamicObject)fundEntry.get(i);
                DynamicObject entry = funSources.addNew();
                entry.set("id", (Object)ids[i]);
                entry.set("seq", (Object)funSources.size());
                if (StringUtils.isNotEmpty((CharSequence)investListId)) {
                    if (QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)investListId)) {
                        entry.set("fundsourcetype", (Object)funSource.getDynamicObject("fundsourcetype"));
                        entry.set("formofinvest", (Object)funSource.getString("formofinvest"));
                        entry.set("entryamt", (Object)funSource.getBigDecimal("entryamt"));
                        entry.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                        entry.set("investcurrency", (Object)funSource.getDynamicObject("investcurrency"));
                        entry.set("scale", (Object)funSource.getBigDecimal("scale"));
                        entry.set("comment", (Object)funSource.getString("comment"));
                    } else {
                        entry.set("fundsourcetype", (Object)funSource.getDynamicObject("sourceentry_fundresource"));
                        entry.set("formofinvest", (Object)funSource.getString("sourceentry_formofinvest"));
                        entry.set("entryamt", (Object)funSource.getBigDecimal("sourceentry_amount"));
                        entry.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                        entry.set("investcurrency", (Object)funSource.getDynamicObject("sourceentry_currency"));
                        entry.set("scale", (Object)funSource.getBigDecimal("sourceentry_scale"));
                        entry.set("comment", (Object)funSource.getString("sourceentry_remark"));
                    }
                    declareAmt = declareAmt.add(entry.getBigDecimal("currententryamt"));
                    proInvestSumAmt = proInvestSumAmt.add(entry.getBigDecimal("entryamt"));
                } else {
                    int year;
                    entry.set("fundsourcetype", (Object)funSource.getDynamicObject("sourcetype"));
                    entry.set("formofinvest", (Object)funSource.getString("formofinvest"));
                    entry.set("entryamt", (Object)funSource.getBigDecimal("amount"));
                    if (fundSourceBill != null && (year = fundSourceBill.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear()) == curLocalDate.getYear()) {
                        entry.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                    }
                    entry.set("investcurrency", (Object)funSource.getDynamicObject("investcurrency"));
                    entry.set("scale", (Object)funSource.getBigDecimal("scale"));
                    entry.set("comment", (Object)funSource.getString("note"));
                    declareAmt = declareAmt.add(funSource.getBigDecimal("currententryamt"));
                    proInvestSumAmt = proInvestSumAmt.add(funSource.getBigDecimal("amount"));
                }
                item.set("inventry_anlinvesdeclamt", (Object)declareAmt);
                item.set("projcetbugamt", (Object)proInvestSumAmt);
                item.set("inventry_approveamt", (Object)declareAmt);
                item.set("inventry_investbudincrea", (Object)declareAmt.subtract(item.getBigDecimal("inventry_oriannualincest")));
            }
        }
    }

    protected void gainProjectProposal(DynamicObject aunLivesPlan) {
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "org", "year", "projcetbugamt", "projcetfiamt", "yearbugamt", "yearfiamt", "oriannualincest", "orifinancialex", "arrearsamt", "lastyearbugamt", "lastyearfiamt", "isquote", "budgetapplyresult", "auditorg", "yearbugappamt", "yearfiappamt", "version", "projectkind", "approvalcon", "sourceorg", "accepted", "datasource", "projectproposalid", "investlistid", "declaretype");
        DynamicObjectCollection investEntry = aunLivesPlan.getDynamicObjectCollection("inventry");
        QFilter qFilter = this.handleQFilter(aunLivesPlan);
        if (investEntry.size() > 0) {
            Set selectProIds;
            Set selectPoSalIds = investEntry.stream().filter(entry -> !"bd_project".equals(entry.getString("projecttype"))).map(entry -> entry.getDynamicObject("projectno").getPkValue().toString()).collect(Collectors.toSet());
            if (selectPoSalIds.size() > 0) {
                qFilter.and("projectproposalid", "not in", selectPoSalIds);
            }
            if ((selectProIds = investEntry.stream().filter(entry -> "bd_project".equals(entry.getString("projecttype"))).map(entry -> Long.parseLong(entry.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
                qFilter.and("project", "not in", selectProIds);
            }
        }
        qFilter.and("datasource", "!=", (Object)"projectProposal");
        DynamicObject[] projectProData = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (projectProData.length > 0) {
            HashMap<String, DynamicObject> projectProposalMap = new HashMap<String, DynamicObject>();
            for (DynamicObject projectProposal : projectProData) {
                BigDecimal version2;
                String dataSource = projectProposal.getString("datasource");
                if (StringUtil.isEmpty((String)dataSource)) {
                    dataSource = "projectProposal";
                }
                String approvalCon = projectProposal.getString("approvalcon");
                if (("inveslist".equals(dataSource) || "project".equals(dataSource)) && !"report".equals(approvalCon)) continue;
                String number = projectProposal.getString("number");
                DynamicObject projectProposalF7 = (DynamicObject)projectProposalMap.get(number);
                if (projectProposalF7 == null) {
                    projectProposalMap.put(number, projectProposal);
                    continue;
                }
                BigDecimal version1 = projectProposalF7.getBigDecimal("version");
                if (version1.compareTo(version2 = projectProposal.getBigDecimal("version")) >= 0) continue;
                projectProposalMap.put(number, projectProposal);
            }
            for (Map.Entry projectProposalEntry : projectProposalMap.entrySet()) {
                DynamicObject projectProposalF7 = (DynamicObject)projectProposalEntry.getValue();
                projectProposalF7 = BusinessDataServiceHelper.loadSingle((Object)projectProposalF7.getPkValue(), (String)"pmim_projectproposal_f7");
                DynamicObject entry2 = investEntry.addNew();
                entry2.set("seq", (Object)investEntry.size());
                entry2 = new AunualinvesPlanHelper().packInvestItem(entry2, projectProposalF7);
                this.createFunSource(entry2);
            }
            this.focusLastRow(-1);
        }
    }

    private QFilter handleQFilter(DynamicObject aunLivesPlan) {
        DynamicObject curOrg = aunLivesPlan.getDynamicObject("org");
        QFilter qFilter = new QFilter("reportorg", "=", (Object)Long.parseLong(curOrg.getPkValue().toString()));
        qFilter.and("reportbudget", "=", (Object)true);
        qFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("isquote", "=", (Object)false);
        qFilter.and("accepted", "=", (Object)false);
        LocalDate curYear = aunLivesPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
        return qFilter;
    }

    protected String getAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    protected void showProjectF7Form() {
        Set<Object> declaredPros;
        QFilter declaredQFilter;
        Set selectProjects;
        DynamicObjectCollection investEntryCol;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (null == model.getValue("year")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"AunualinvesPlanBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null == model.getValue("org")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\uff01", (String)"AunualinvesPlanBillPlugin_6", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)true);
        lsp.setFormId("bd_projecttreelist");
        lsp.setAppId(this.getAppId());
        lsp.setMultiSelect(true);
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>(16);
        QFilter qFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            qFilter.and("pmascreateorg", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        }
        rangeFilterList.add(qFilter);
        ArrayList<String> removeStatus = new ArrayList<String>();
        removeStatus.add(ProjectStatusEnum.BUSSINESS_CLOSE.getValue());
        removeStatus.add(ProjectStatusEnum.FINANCIAL_CLOSE.getValue());
        removeStatus.add(ProjectStatusEnum.SUSPEND.getValue());
        QFilter qStatusIDS = new QFilter("number", "in", removeStatus);
        DynamicObject[] prostatuss = BusinessDataServiceHelper.load((String)"bd_projectstatus", (String)"id", (QFilter[])new QFilter[]{qStatusIDS});
        if (prostatuss.length > 0) {
            List prostatusIds = Arrays.stream(prostatuss).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toList());
            QFilter qFilterStatus = new QFilter("prostatus", "not in", prostatusIds);
            rangeFilterList.add(qFilterStatus);
        }
        if ((investEntryCol = model.getEntryEntity("inventry")).size() > 0 && (selectProjects = investEntryCol.stream().filter(it -> StringUtils.equals((CharSequence)it.getString("projecttype"), (CharSequence)"bd_project") && null != it.getDynamicObject("projectno")).map(it -> Long.parseLong(it.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
            rangeFilterList.add(new QFilter("id", "not in", selectProjects));
        }
        DynamicObject aunLivesPlan = model.getDataEntity();
        LocalDate curYear = aunLivesPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String documentType = (String)this.getModel().getValue("docuimenttype");
        if (DocuimentTypeEnum.DECLARE.getValue().equals(documentType)) {
            declaredQFilter = new QFilter("approvalcon", "!=", (Object)"unpass");
            declaredQFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
            declaredQFilter.and("isquote", "=", (Object)true);
            declaredQFilter.and("project", "!=", (Object)0L);
            DynamicObject[] declaredRecord = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)"project", (QFilter[])new QFilter[]{declaredQFilter});
            if (declaredRecord.length > 0 && (declaredPros = Arrays.stream(declaredRecord).map(it -> Long.parseLong(it.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
                rangeFilterList.add(new QFilter("id", "not in", declaredPros));
            }
        } else {
            declaredQFilter = new QFilter("YEAR(year)", "=", (Object)curYear.getYear());
            declaredQFilter.and("inventry.projecttype", "=", (Object)"bd_project");
            declaredQFilter.and("inventry.projectno", "!=", (Object)0L);
            DynamicObject[] declaredRecords = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)"inventry,inventry.projectno,", (QFilter[])new QFilter[]{declaredQFilter});
            if (declaredRecords.length > 0) {
                declaredPros = new HashSet(16);
                for (DynamicObject declaredRecord : declaredRecords) {
                    DynamicObjectCollection invEntry = declaredRecord.getDynamicObjectCollection("inventry");
                    if (invEntry.size() <= 0) continue;
                    declaredPros.addAll(invEntry.stream().map(o -> Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet()));
                }
                if (declaredPros.size() > 0) {
                    rangeFilterList.add(new QFilter("id", "not in", declaredPros));
                }
            }
        }
        DynamicObjectCollection proIds = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])rangeFilterList.toArray(new QFilter[0]));
        QFilter proQFilters = new QFilter("pro.id", "in", (Object)proIds.stream().map(obj -> obj.getLong("id")).toArray());
        DynamicObjectCollection approvalIds = QueryServiceHelper.query((String)"pmas_pro_approval", (String)"id,pro", (QFilter[])new QFilter[]{proQFilters});
        QFilter approvalProQFilter = new QFilter("id", "in", (Object)approvalIds.stream().map(obj -> obj.getLong("pro")).toArray());
        lsp.getListFilterParameter().getQFilters().add(approvalProQFilter);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_project"));
        view.showForm((FormShowParameter)lsp);
    }

    protected void showReserveF7From() {
        Set selectProposals;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (null == model.getValue("year")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"AunualinvesPlanBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null == model.getValue("org")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\uff01", (String)"AunualinvesPlanBillPlugin_6", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"pmim_reserveprolib", (boolean)true);
        lsp.setFormId("bos_listf7");
        lsp.setAppId(this.getAppId());
        lsp.setMultiSelect(true);
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject org = (DynamicObject)model.getValue("org");
        qFilter.and("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("reportbudget", "=", (Object)Boolean.TRUE);
        qFilter.and("bizstatus", "=", (Object)BizStatusEnum.NORMAL.getValue());
        qFilter.and("approvalstatus", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection investEntryCol = model.getEntryEntity("inventry");
        if (investEntryCol.size() > 0 && (selectProposals = investEntryCol.stream().filter(investEntry -> StringUtils.equals((CharSequence)investEntry.getString("projecttype"), (CharSequence)"pmim_proposalbill_f7")).filter(investEntry -> investEntry.getDynamicObject("projectno") != null).map(investEntry -> Long.parseLong(investEntry.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
            qFilter.and("id", "not in", selectProposals);
        }
        DynamicObject aunLivesPlan = model.getDataEntity();
        LocalDate curYear = aunLivesPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        QFilter declaredQFilter = new QFilter("YEAR(year)", "=", (Object)curYear.getYear());
        declaredQFilter.and("inventry.projecttype", "=", (Object)"pmim_proposalbill_f7");
        declaredQFilter.and("inventry.projectno", "!=", (Object)0L);
        DynamicObject[] declaredRecords = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)"inventry,inventry.projectno,inventry.projecttype", (QFilter[])new QFilter[]{declaredQFilter});
        if (declaredRecords.length > 0) {
            HashSet declaredPros = new HashSet(16);
            for (DynamicObject declaredRecord : declaredRecords) {
                DynamicObjectCollection invEntry = declaredRecord.getDynamicObjectCollection("inventry");
                if (invEntry.size() <= 0) continue;
                declaredPros.addAll(invEntry.stream().filter(o -> StringUtil.equals((String)"pmim_proposalbill_f7", (String)o.getString("projecttype"))).map(o -> Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet()));
            }
            if (declaredPros.size() > 0) {
                rangeFilterList.add(new QFilter("id", "not in", declaredPros));
            }
        }
        rangeFilterList.add(qFilter);
        lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CTRL_secReserve));
        view.showForm((FormShowParameter)lsp);
    }

    protected void showProjectProposalF7Form() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (null == model.getValue("year")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"AunualinvesPlanBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject aunLivesPlan = model.getDataEntity();
        LocalDate year = aunLivesPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Optional.ofNullable(year).ifPresent(y -> {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"pmim_projectproposal_f7", (boolean)true);
            lsp.setFormId("pmim_proproposal_listf7");
            lsp.setAppId(this.getAppId());
            lsp.setMultiSelect(true);
            ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
            QFilter qFilter = this.handleQFilter(aunLivesPlan);
            DynamicObjectCollection investEntryCol = model.getEntryEntity("inventry");
            int size = investEntryCol.size();
            Optional.of(investEntryCol).ifPresent(col -> {
                if (size != 0) {
                    Object[] projectProposalIds = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        projectProposalIds[i] = Optional.ofNullable(col.get(i)).map(investEntry -> investEntry.getLong("inventry_investlistid")).orElse(null);
                    }
                    qFilter.and("id", "not in", (Object)projectProposalIds);
                }
            });
            rangeFilterList.add(qFilter);
            lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmim_projectproposal_f7"));
            view.showForm((FormShowParameter)lsp);
        });
    }

    private void deleteInvestEntry() {
        this.summaryAunLivesPlanAmt();
        this.getView().updateView();
        String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
        this.treeDataUpdateView(currentTreeNodeId);
    }

    private void focusLastRow(int row) {
        DynamicObjectCollection invEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("inventry");
        EntryGrid grid = (EntryGrid)this.getView().getControl("inventry");
        for (int i = 0; i < invEntries.size(); ++i) {
            DynamicObject item = (DynamicObject)invEntries.get(i);
            DynamicObjectCollection funSources = item.getDynamicObjectCollection("funsourceentry");
            if (funSources.size() > 0) {
                grid.getView().setEnable(Boolean.valueOf(false), i, new String[]{"inventry_anlinvesdeclamt"});
                grid.getView().setEnable(Boolean.valueOf(false), i, new String[]{"projcetbugamt"});
                continue;
            }
            grid.getView().setEnable(Boolean.valueOf(true), i, new String[]{"inventry_anlinvesdeclamt"});
            grid.getView().setEnable(Boolean.valueOf(true), i, new String[]{"projcetbugamt"});
        }
        if (row != -1) {
            grid.selectRows(row, true);
        } else {
            grid.selectRows(invEntries.size() - 1, true);
        }
    }

    protected void summaryAunLivesPlanAmt() {
        DynamicObjectCollection invEntries = this.getModel().getEntryEntity("inventry");
        BigDecimal investBudAmt = BigDecimal.ZERO;
        BigDecimal fiCiaLexBudAmt = BigDecimal.ZERO;
        BigDecimal investBudAddAmt = BigDecimal.ZERO;
        BigDecimal fiCiaLexBudAddAmt = BigDecimal.ZERO;
        if (null != invEntries && invEntries.size() > 0) {
            for (int i = 0; i < invEntries.size(); ++i) {
                DynamicObject invEntry = (DynamicObject)invEntries.get(i);
                String approvalCon = invEntry.getString("inventry_approvalcon");
                if (!"unpass".equals(approvalCon)) {
                    investBudAmt = investBudAmt.add(invEntry.getBigDecimal("inventry_approveamt"));
                    fiCiaLexBudAmt = fiCiaLexBudAmt.add(invEntry.getBigDecimal("inventry_finanapproveamt"));
                    investBudAddAmt = investBudAddAmt.add(invEntry.getBigDecimal("inventry_investbudincrea"));
                    fiCiaLexBudAddAmt = fiCiaLexBudAddAmt.add(invEntry.getBigDecimal("inventry_finaexbudincreas"));
                }
                if ("report".equals(approvalCon)) {
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"inventry_reportorg"});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"inventry_reportorg"});
            }
        }
        this.getModel().setValue("investbudamt", (Object)investBudAmt);
        this.getModel().setValue("financialexbudamt", (Object)fiCiaLexBudAmt);
        this.getModel().setValue("investbudaddamt", (Object)investBudAddAmt);
        this.getModel().setValue("financialexbudaddamt", (Object)fiCiaLexBudAddAmt);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)args.getReturnData();
        if (returnDatas == null || returnDatas.isEmpty()) {
            return;
        }
        Optional.ofNullable(returnDatas).ifPresent(col -> {
            String actionId = args.getActionId();
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)args.getReturnData();
            if ("pmim_projectproposal_f7".equals(actionId)) {
                this.addProjectProposal2InvestEntry(returnData, this.getModel(), this.getView());
            } else if (StringUtils.equals((CharSequence)CALL_BACK_REPORT_ORG, (CharSequence)actionId)) {
                ListSelectedRow data = returnData.get(0);
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)data.getPrimaryKeyValue(), (String)"bos_org");
                DynamicObject clickRowData = this.selectDynamicObject();
                clickRowData.set("inventry_reportorg", (Object)org);
                String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
                this.treeDataUpdateView(currentTreeNodeId);
            } else if ("bd_project".equals(actionId)) {
                this.addProjectInvestEntry(returnData, this.getModel(), this.getView());
            } else if (CTRL_secReserve.equals(actionId)) {
                this.addReserveInvestEntry(returnData, this.getModel(), this.getView());
            }
        });
    }

    protected void addProjectInvestEntry(ListSelectedRowCollection projects, IDataModel model, IFormView view) {
        DynamicObjectCollection invEntries = model.getDataEntity(true).getDynamicObjectCollection("inventry");
        for (ListSelectedRow project : projects) {
            DynamicObject ppInfo = BusinessDataServiceHelper.loadSingle((Object)project.getPrimaryKeyValue(), (String)"bd_project");
            DynamicObject item = invEntries.addNew();
            item.set("seq", (Object)invEntries.size());
            item = new AunualinvesPlanHelper().packInvestItem(item, ppInfo);
            this.createFunSource(item);
        }
        this.summaryAunLivesPlanAmt();
        view.updateView();
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            this.treeDataUpdateView(this.getPageCache().get(CURRENTTREENODE));
        }
        this.focusLastRow(-1);
    }

    protected void addReserveInvestEntry(ListSelectedRowCollection reserveLibs, IDataModel model, IFormView view) {
        DynamicObjectCollection invEntries = model.getDataEntity(true).getDynamicObjectCollection("inventry");
        for (ListSelectedRow reserveLib : reserveLibs) {
            DynamicObject ppInfo = BusinessDataServiceHelper.loadSingle((Object)reserveLib.getPrimaryKeyValue(), (String)"pmim_projectproposal");
            DynamicObject item = invEntries.addNew();
            item.set("seq", (Object)invEntries.size());
            item = new AunualinvesPlanHelper().packInvestItem(item, ppInfo);
            this.createFunSource(item);
        }
        this.summaryAunLivesPlanAmt();
        view.updateView();
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            this.treeDataUpdateView(this.getPageCache().get(CURRENTTREENODE));
        }
        this.focusLastRow(-1);
    }

    protected void addProjectProposal2InvestEntry(ListSelectedRowCollection projectProposals, IDataModel model, IFormView view) {
        DynamicObjectCollection invEntries = model.getDataEntity(true).getDynamicObjectCollection("inventry");
        for (ListSelectedRow projectProposal : projectProposals) {
            DynamicObject ppInfo = BusinessDataServiceHelper.loadSingle((Object)projectProposal.getPrimaryKeyValue(), (String)"pmim_projectproposal_f7");
            DynamicObject item = invEntries.addNew();
            item.set("seq", (Object)invEntries.size());
            item = new AunualinvesPlanHelper().packInvestItem(item, ppInfo);
            this.createFunSource(item);
        }
        this.summaryAunLivesPlanAmt();
        view.updateView();
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            this.treeDataUpdateView(this.getPageCache().get(CURRENTTREENODE));
        }
        this.focusLastRow(-1);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(CURRENTTREENODE, nodeId);
        this.treeDataUpdateView(nodeId);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        BillShowParameter showParameter = this.getHyperLinkClickShowParameter(event);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "inventry_reportorg": {
                e.setCancel(true);
            }
        }
    }

    private void treeDataUpdateView(String nodeId) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("inventry");
        DynamicObjectCollection viewEntries = (DynamicObjectCollection)entries.clone();
        this.getEntriesByProjectKind(nodeId, entries);
        if (viewEntries == null || viewEntries.isEmpty()) {
            return;
        }
        this.getModel().getDataEntity(true).set("inventry", (Object)entries);
        this.updateViewEntry();
        this.getModel().getDataEntity(true).set("inventry", (Object)viewEntries);
        this.focusLastRow(0);
    }

    private void getEntriesByProjectKind(String nodeId, DynamicObjectCollection entrys) {
        Map projectKindMap = new AunualinvesPlanHelper().getProjectKindMap();
        Iterator iterator = entrys.iterator();
        while (iterator.hasNext()) {
            DynamicObject viewEntry = (DynamicObject)iterator.next();
            DynamicObject projectKind = viewEntry.getDynamicObject("inventry_projectkind");
            if (null == projectKind || this.checkIsShow2Panel(nodeId, projectKind, projectKindMap)) continue;
            iterator.remove();
        }
    }

    private boolean checkIsShow2Panel(String nodeId, DynamicObject projectKind, Map<Long, DynamicObject> projectKindMap) {
        if (nodeId == null || ROOTNODEID.equals(nodeId) || nodeId.equals(projectKind.getPkValue().toString())) {
            return true;
        }
        if (null == (projectKind = projectKindMap.get(projectKind.getPkValue())).get("parent")) {
            return false;
        }
        DynamicObject parent = projectKind.getDynamicObject("parent");
        return this.checkIsShow2Panel(nodeId, projectKindMap.get(parent.getPkValue()), projectKindMap);
    }

    private BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent event) {
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = model.getDynamicObjectCollection("inventry");
        TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
        String proKindId = treeView.getTreeState().getFocusNodeId();
        DynamicObjectCollection entriesByProKind = (DynamicObjectCollection)entries.clone();
        this.getEntriesByProjectKind(proKindId, entriesByProKind);
        DynamicObject curRow = (DynamicObject)entriesByProKind.get(event.getRowIndex());
        String projectType = curRow.getString("projecttype");
        long billId = 0L;
        String formId = "";
        DynamicObject project = curRow.getDynamicObject("projectno");
        BillShowParameter showParameter = new BillShowParameter();
        if ("bd_project".equals(projectType)) {
            QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (proApp == null) {
                DynamicObject sysProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                if (sysProject != null) {
                    billId = Long.parseLong(sysProject.getPkValue().toString());
                    formId = "bd_project";
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                }
            } else {
                billId = Long.parseLong(proApp.getPkValue().toString());
                formId = "pmas_pro_approval";
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            }
        } else {
            formId = "pmim_projectproposal";
            billId = project.getLong("id");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        showParameter.setCustomParam("isView", (Object)true);
        showParameter.setFormId(formId);
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId((Object)billId);
        return showParameter;
    }

    private DynamicObject selectDynamicObject() {
        String currentTreeNodeId = this.getPageCache().get(CURRENTTREENODE);
        String currentGridRowId = this.getPageCache().get(CURRENT_GRID_ROW_NO);
        LeftTreeRightGridBillSupport leftTreeRightGridBillSupport = new LeftTreeRightGridBillSupport("inventry_projectkind", this.buildRootNode(), Integer.parseInt(currentGridRowId), this.getModel().getDataEntity(true).getDynamicObjectCollection("inventry"), currentTreeNodeId, true);
        int clickRowIndex = leftTreeRightGridBillSupport.switchCurrentViewIndex2GridIndex();
        DynamicObject clickRowData = this.getModel().getEntryRowEntity("inventry", clickRowIndex);
        return clickRowData;
    }

    public void updateViewEntry() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        DynamicObjectCollection invEntry = aunLivesPlan.getDynamicObjectCollection("inventry");
        for (int i = 0; i < invEntry.size(); ++i) {
            String approvalCon = ((DynamicObject)invEntry.get(i)).getString("inventry_approvalcon");
            if (!"report".equals(approvalCon)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"inventry_reportorg"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"inventry_reportorg"});
        }
        this.getView().updateView("inventry");
    }

    private TreeNode buildRootNode() {
        TreeNode rootNode = new TreeNode("", ROOTNODEID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"AunualinvesPlanBillPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        String childJson = this.getPageCache().get("PROJECT_KIND_LIST_CACHE_KEY");
        if (StringUtils.isBlank((CharSequence)childJson)) {
            return rootNode;
        }
        List newChildren = SerializationUtils.fromJsonStringToList((String)childJson, TreeNode.class);
        newChildren.forEach(arg_0 -> ((TreeNode)rootNode).addChild(arg_0));
        return rootNode;
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        int hasPerm;
        DynamicObject bill = this.getModel().getDataEntity(true);
        Date declareDate = bill.getDate("year");
        if (declareDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"AunualinvesPlanBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject org = bill.getDynamicObject("org");
        String documentType = (String)this.getModel().getValue("docuimenttype");
        String billFormId = StringUtils.equals((CharSequence)documentType, (CharSequence)DocuimentTypeEnum.DECLARE.getValue()) ? "pmim_aunualinvestplan" : "pmim_specialdeclarainvest";
        Map permObj = ProjectPermissionHelper.getPermObj((String)billFormId, (String)"new");
        if (permObj != null && org != null && (hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong(org.getPkValue().toString()), (String)"pmim", (String)billFormId, (String)((String)permObj.get("id")))) != 1) {
            String tips = StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmim_aunualinvestplan") ? ResManager.loadKDString((String)"\u65e0\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u62a5\u5355\u7f16\u8f91\u6743\u9650\uff0c\u65e0\u6cd5\u83b7\u53d6\u6b64\u503c\u3002", (String)"AunualinvesPlanBillPlugin_17", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u6295\u8d44\u9884\u7b97\u4e13\u9879\u7533\u62a5\u5355\u7f16\u8f91\u6743\u9650\uff0c\u65e0\u6cd5\u83b7\u53d6\u6b64\u503c\u3002", (String)"AunualinvesPlanBillPlugin_18", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            evt.setCancel(true);
            return;
        }
        int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        BigDecimal annualStrategicPlanAmt = BigDecimal.ZERO;
        if (org != null) {
            annualStrategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, org);
        }
        if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("annualstrategicplanamt", (Object)annualStrategicPlanAmt);
            this.updateControlMetadata();
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (!StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)billStatus) && annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) != 0) {
            bill.set("annualstrategicplanamt", (Object)annualStrategicPlanAmt);
            SaveServiceHelper.update((DynamicObject)bill);
        }
        evt.setCancel(true);
    }

    private void updateControlMetadata() {
        BigDecimal annualStrategicPlanAmt = (BigDecimal)this.getModel().getValue("annualstrategicplanamt");
        if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0) {
            String documentType = (String)this.getModel().getValue("docuimenttype");
            if (StringUtils.equals((CharSequence)documentType, (CharSequence)DocuimentTypeEnum.DECLARE.getValue())) {
                BigDecimal InvestBudAmt = (BigDecimal)this.getModel().getValue("investbudamt");
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("fc", annualStrategicPlanAmt.compareTo(InvestBudAmt) < 0 ? "#FF0000" : "#000000");
                this.getView().updateControlMetadata("investbudamt", propMap);
            }
            DynamicObject bill = this.getModel().getDataEntity(true);
            DynamicObject org = bill.getDynamicObject("org");
            Date declareDate = bill.getDate("year");
            int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            BigDecimal strategicPlanAmt = BigDecimal.ZERO;
            if (org != null) {
                strategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, org);
            }
            if (strategicPlanAmt.compareTo(BigDecimal.ZERO) > 0 && strategicPlanAmt.compareTo(annualStrategicPlanAmt) == 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"annualstrategicplanamt"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"annualstrategicplanamt"});
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"suminvestamt")) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            new AunualinvesPlanHelper().packageSumInvestListByDeclare(bill);
            this.getView().updateView("suminvestlist");
        }
    }

    public void afterShowTips(AfterShowTipsEvent evt) {
    }
}

