/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.AuthProjectKindHelper;
import kd.pmgt.pmbs.business.helper.ConstructorTreeDataHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmim.business.helper.InvestBudgetPlanHelper;
import kd.pmgt.pmim.common.enums.ReportStatusEnum;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;
import kd.pmgt.pmim.formplugin.buget.InvestBudgetPlanPropertyChanged;

public class InvestBudgetPlanBillPlugin
extends AbstractPmimBillPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static final String BD_PROJECTKIND = "bd_projectkind";
    private static final String CURRENTTREENODE = "currentTreeNode";
    private static final String PARENTTREENODE = "parentTreeNode";
    private static final String ROOTNODEID = "001";
    protected IDataModelChangeListener propertyChange;
    protected InvestBudgetPlanHelper investBudgetPlanHelper;

    protected String getAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public void initialize() {
        super.initialize();
        this.initPropertyChanged();
    }

    protected void initPropertyChanged() {
        this.propertyChange = new InvestBudgetPlanPropertyChanged((AbstractBillPlugIn)this, this.getModel());
        this.investBudgetPlanHelper = new InvestBudgetPlanHelper();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String openSource = (String)this.getView().getFormShowParameter().getCustomParam("openSource");
        if ("investBudgetAudit".equals(openSource)) {
            Container container = (Container)this.getView().getControl("titlepanelflex");
            container.deleteControls(new String[]{"titlepanelflex"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.propertyChange.propertyChanged(e);
        String ctrlName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (ctrlName) {
            case "isreport": {
                if (null != this.getPageCache().get(CURRENTTREENODE)) {
                    this.treeDataUpdateView(this.getPageCache().get(CURRENTTREENODE));
                }
                this.isReportPropertyChange(newValue);
                break;
            }
        }
    }

    private void isReportPropertyChange(Object newValue) {
        boolean isReport = (Boolean)newValue;
        if (isReport) {
            this.setReportOrg();
        } else {
            this.getModel().setValue("reportorg", null);
        }
    }

    private void setReportOrg() {
        QFilter billFilter = new QFilter("billcode.number", "=", (Object)"pmim_investbugetplan");
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject reqOrgConf = BusinessDataServiceHelper.loadSingle((String)"pmbs_reqorgconf", (String)"billcode,entryentity,reportorg,declarateorg,enable,projectkind", (QFilter[])new QFilter[]{billFilter, enableFilter});
        if (reqOrgConf == null) {
            return;
        }
        DynamicObjectCollection entryEntity = reqOrgConf.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            DynamicObject reportOrg = this.getReportOrgWithNoKind(org, entryEntity);
            this.getModel().setValue("reportorg", (Object)reportOrg);
        }
    }

    private DynamicObject getReportOrgWithNoKind(DynamicObject org, DynamicObjectCollection entryEntity) {
        for (DynamicObject entryRow : entryEntity) {
            DynamicObject projectKind = entryRow.getDynamicObject("projectkind");
            if (projectKind != null) continue;
            DynamicObjectCollection declareOrgList = entryRow.getDynamicObjectCollection("declarateorg");
            for (DynamicObject declareOrg : declareOrgList) {
                DynamicObject fBaseDataId = declareOrg.getDynamicObject("fbasedataid");
                if (fBaseDataId == null || !fBaseDataId.getPkValue().equals(org.getPkValue())) continue;
                return entryRow.getDynamicObject("reportorg");
            }
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)"projectkindtree", (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvestBudgetPlanBillPlugin_5", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)Long.parseLong(org.getPkValue().toString()));
        }
    }

    public void afterLoadData(EventObject e) {
        FormShowParameter formShowParameter;
        Object isView;
        super.afterLoadData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)"projectkindtree", (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvestBudgetPlanBillPlugin_5", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)Long.parseLong(org.getPkValue().toString()));
        }
        if ((isView = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("isView")) != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_report"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteinventry": {
                this.beforeDeleteEntryLogic();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "autoimppjproposaldata": {
                this.autoImpProjectProposalData();
                break;
            }
            case "imppjproposaldata": {
                this.showProjectProposalF7Form();
                break;
            }
            case "report": {
                this.report2InvestAuditData();
                break;
            }
            case "deleteinventry": {
                this.deleteInvestEntry();
                break;
            }
            case "newentry": {
                DynamicObject dynamicObject = this.getModel().getDataEntity(true);
                DynamicObjectCollection invEntries = dynamicObject.getDynamicObjectCollection("inventry");
                if (null == this.getPageCache().get(CURRENTTREENODE)) break;
                DynamicObject invEntry = invEntries.addNew();
                invEntry.set("seq", (Object)invEntries.size());
                invEntry.set("id", (Object)ORM.create().genLongId((IDataEntityType)invEntry.getDynamicObjectType()));
                DynamicObject projectKind = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(this.getPageCache().get(CURRENTTREENODE)), (String)BD_PROJECTKIND);
                invEntry.set("inventry_projectkind", (Object)projectKind);
                TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
                treeView.treeNodeClick(this.getPageCache().get(PARENTTREENODE), this.getPageCache().get(CURRENTTREENODE));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        ListSelectedRowCollection projectProposals = (ListSelectedRowCollection)args.getReturnData();
        Optional.ofNullable(projectProposals).ifPresent(col -> {
            String actionId = args.getActionId();
            if ("pmim_projectproposal_f7".equals(actionId)) {
                this.addProjectProposal2InvestEntry((ListSelectedRowCollection)col, this.getModel(), this.getView());
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inventry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(CURRENTTREENODE, nodeId);
        this.treeDataUpdateView(nodeId);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        BillShowParameter showParameter = this.getHyperLinkClickShowParameter(event);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        String billNo = sourceData.get("billno").toString();
        boolean isExists = QueryServiceHelper.exists((String)"pmim_investbugetplan", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (isExists) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6295\u8d44\u9884\u7b97\u7533\u8bf7\u5355%s\u5df2\u5b58\u5728\u3002", (String)"InvestBudgetPlanBillPlugin_10", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), billNo));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
    }

    protected void summaryBudgetAmt() {
        DynamicObject investBudgetPlan = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = investBudgetPlan.getDynamicObjectCollection("inventry");
        BigDecimal totalBugAmt = BigDecimal.ZERO;
        BigDecimal totalYearBugAmt = BigDecimal.ZERO;
        BigDecimal totalYearFiAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            totalBugAmt = null != entry.get("inventry_bugetamt") ? totalBugAmt.add(entry.getBigDecimal("inventry_bugetamt")) : totalBugAmt.add(BigDecimal.ZERO);
            totalYearBugAmt = null != entry.get("inventry_yearbugamt") ? totalYearBugAmt.add(entry.getBigDecimal("inventry_yearbugamt")) : totalYearBugAmt.add(BigDecimal.ZERO);
            totalYearFiAmt = null != entry.get("inventry_yearfiamt") ? totalYearFiAmt.add(entry.getBigDecimal("inventry_yearfiamt")) : totalYearFiAmt.add(BigDecimal.ZERO);
        }
        investBudgetPlan.set("bugamt", (Object)totalBugAmt);
        investBudgetPlan.set("yearbugamt", (Object)totalYearBugAmt);
        investBudgetPlan.set("yearfiamt", (Object)totalYearFiAmt);
    }

    protected void constructorPJKindTreeData() {
        ConstructorTreeDataHelper helper = new ConstructorTreeDataHelper(this.getView(), "projectkindtree", BD_PROJECTKIND, ROOTNODEID);
        helper.setQFilters(new QFilter[]{new QFilter("enable", "=", (Object)true)});
        helper.constructorTreeData(false);
    }

    protected void report2InvestAuditData() {
        DynamicObject investBudgetPlan = this.getModel().getDataEntity(true);
        boolean isReport = QueryServiceHelper.exists((String)"pmim_budgetaudit", (QFilter[])new QFilter[]{new QFilter("yearbugappno", "=", investBudgetPlan.get("id"))});
        if (isReport) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6295\u8d44\u9884\u7b97\u7533\u8bf7\u5355\u5df2\u4e0a\u62a5\uff0c\u65e0\u9700\u91cd\u590d\u4e0a\u62a5\u3002", (String)"InvestBudgetPlanBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.investBudgetPlanHelper.syncBudgetAuditBill(investBudgetPlan);
        investBudgetPlan.set("reportstatus", (Object)ReportStatusEnum.HASREPORT.getValue());
        SaveServiceHelper.update((DynamicObject)investBudgetPlan);
        this.getView().updateView();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u62a5\u6210\u529f\u3002", (String)"InvestBudgetPlanBillPlugin_9", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
    }

    protected void autoImpProjectProposalData() {
        DynamicObject investBudgetPlan = this.getModel().getDataEntity(true);
        if (null == investBudgetPlan.getDate("year")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"InvestBudgetPlanBillPlugin_11", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        LocalDate year = investBudgetPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String selectProperties = String.join((CharSequence)",", "yearbugamt", "yearbugamt", "yearfiamt", "arrearsamt", "lastyearbugamt", "lastyearfiamt", "projectkind", "projectproposalid", "ownershipstructure", "registeredcapital", "shareholding", "enterpriselevel", "ohpartsamt", "ohmaterialamt", "ohprocessamt", "ohoutsourcamt", "ohoutpreccamt", "ohinprojectamt", "ohvehicleamt", "ohaddress", "equipweight", "ohperiod", "projectstatus", "version");
        QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)year.getYear());
        DynamicObject org = investBudgetPlan.getDynamicObject("org");
        qFilter.and("reportorg", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("reportbudget", "=", (Object)true);
        qFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("datasource", "=", (Object)"projectProposal");
        QFilter finalQFilter = qFilter.and("isquote", "=", (Object)false);
        DynamicObjectCollection investEntryCol = investBudgetPlan.getDynamicObjectCollection("inventry");
        int size = investEntryCol.size();
        Optional.ofNullable(investEntryCol).ifPresent(col -> {
            Object[] projectProposalIds = new Object[size];
            for (int i = 0; i < size; ++i) {
                projectProposalIds[i] = Optional.ofNullable(col.get(i)).map(investEntry -> investEntry.getDynamicObject("inventry_projectproposal")).map(o -> o.getPkValue()).orElse(null);
            }
            if (projectProposalIds.length > 0) {
                finalQFilter.or("id", "in", (Object)projectProposalIds);
            }
        });
        DynamicObject[] ppDatas = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)selectProperties, (QFilter[])new QFilter[]{finalQFilter});
        if (ppDatas.length > 0) {
            HashMap<String, DynamicObject> projectProposalMap = new HashMap<String, DynamicObject>();
            for (DynamicObject projectProposal : ppDatas) {
                BigDecimal version2;
                String number = projectProposal.getString("number");
                DynamicObject projectProposalF7 = (DynamicObject)projectProposalMap.get(number);
                if (projectProposalF7 == null) {
                    projectProposalMap.put(number, projectProposal);
                    continue;
                }
                BigDecimal version1 = projectProposalF7.getBigDecimal("version");
                if (version1.compareTo(version2 = projectProposal.getBigDecimal("version")) >= 0) continue;
                projectProposalMap.put(number, projectProposal);
            }
            DynamicObjectCollection investEntry = investBudgetPlan.getDynamicObjectCollection("inventry");
            investEntry.clear();
            for (Map.Entry projectProposalEntry : projectProposalMap.entrySet()) {
                DynamicObject projectProposal;
                projectProposal = (DynamicObject)projectProposalEntry.getValue();
                DynamicObject entry = investEntry.addNew();
                entry.set("seq", (Object)investEntry.size());
                this.syncProjectProposal2Entry(entry, projectProposal);
            }
        }
        this.summaryBudgetAmt();
        this.getView().updateView();
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
            treeView.treeNodeClick(this.getPageCache().get(PARENTTREENODE), this.getPageCache().get(CURRENTTREENODE));
        }
    }

    protected void addProjectProposal2InvestEntry(ListSelectedRowCollection projectProposals, IDataModel model, IFormView view) {
        DynamicObjectCollection invEntries = model.getDataEntity(true).getDynamicObjectCollection("inventry");
        invEntries.clear();
        for (ListSelectedRow projectProposal : projectProposals) {
            DynamicObject ppInfo = BusinessDataServiceHelper.loadSingle((Object)projectProposal.getPrimaryKeyValue(), (String)"pmim_projectproposal_f7");
            DynamicObject invEntry = invEntries.addNew();
            invEntry.set("seq", (Object)invEntries.size());
            this.syncProjectProposal2Entry(invEntry, ppInfo);
        }
        this.summaryBudgetAmt();
        view.updateView();
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            this.treeDataUpdateView(this.getPageCache().get(CURRENTTREENODE));
        }
    }

    protected void syncProjectProposal2Entry(DynamicObject entry, DynamicObject projectProposal) {
        entry.set("id", (Object)this.createEntryId(entry.getDynamicObjectType()));
        entry.set("inventry_projectproposal", (Object)projectProposal);
        entry.set("inventry_bugetnumber", projectProposal.get("number"));
        entry.set("inventry_bugetamt", projectProposal.get("yearbugamt"));
        entry.set("inventry_arrearsamt", projectProposal.get("arrearsamt"));
        entry.set("inventry_lastyearbugamt", projectProposal.get("lastyearbugamt"));
        entry.set("inventry_lastyearfiamt", projectProposal.get("lastyearfiamt"));
        entry.set("inventry_projectkind", projectProposal.get("projectkind"));
        entry.set("inventry_projectstatus", projectProposal.get("projectstatus"));
        entry.set("inventry_ownshipstruct", projectProposal.get("ownershipstructure"));
        entry.set("inventry_registercapital", projectProposal.get("registeredcapital"));
        entry.set("inventry_shareholding", projectProposal.get("shareholding"));
        entry.set("inventry_enterpriselevel", projectProposal.get("enterpriselevel"));
        entry.set("inventry_ohpartsamt", projectProposal.get("ohpartsamt"));
        entry.set("inventry_ohmaterialamt", projectProposal.get("ohmaterialamt"));
        entry.set("inventry_ohprocessamt", projectProposal.get("ohprocessamt"));
        entry.set("inventry_ohoutsourcamt", projectProposal.get("ohoutsourcamt"));
        entry.set("inventry_ohoutpreccamt", projectProposal.get("ohoutpreccamt"));
        entry.set("inventry_ohinprojectamt", projectProposal.get("ohinprojectamt"));
        entry.set("inventry_ohvehicleamt", projectProposal.get("ohvehicleamt"));
        entry.set("inventry_ohaddress", projectProposal.get("ohaddress"));
        entry.set("inventry_equipweight", projectProposal.get("equipweight"));
        entry.set("inventry_ohperiod", projectProposal.get("ohperiod"));
        entry.set("inventry_yearbugamt", projectProposal.get("yearbugamt"));
        entry.set("inventry_yearfiamt", projectProposal.get("yearfiamt"));
    }

    private Long createEntryId(DynamicObjectType dynamicObjectType) {
        return ORM.create().genLongId((IDataEntityType)dynamicObjectType);
    }

    private void treeDataUpdateView(String nodeId) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("inventry");
        DynamicObjectCollection viewEntries = (DynamicObjectCollection)entries.clone();
        this.getEntriesByProjectKind(nodeId, entries);
        if (viewEntries == null || viewEntries.isEmpty()) {
            return;
        }
        this.getModel().getDataEntity(true).set("inventry", (Object)entries);
        this.getView().updateView("inventry");
        this.getModel().getDataEntity(true).set("inventry", (Object)viewEntries);
    }

    private void getEntriesByProjectKind(String nodeId, DynamicObjectCollection entries) {
        Map<Long, DynamicObject> projectKindMap = this.getProjectKindMap();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            DynamicObject viewEntry = (DynamicObject)iterator.next();
            DynamicObject projectKind = viewEntry.getDynamicObject("inventry_projectkind");
            if (null == projectKind || this.checkIsShow2Panel(nodeId, projectKind, projectKindMap)) continue;
            iterator.remove();
        }
    }

    private void beforeDeleteEntryLogic() {
        EntryGrid invEntryGrid = (EntryGrid)this.getView().getControl("inventry");
        int[] selectRows = invEntryGrid.getSelectRows();
        int[] newSelectRows = new int[selectRows.length];
        if (selectRows.length == 0) {
            return;
        }
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            String currentTreeNode = this.getPageCache().get(CURRENTTREENODE);
            Stack<Integer> stack = new Stack<Integer>();
            for (int i = selectRows.length - 1; i >= 0; --i) {
                stack.push(selectRows[i]);
            }
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            DynamicObjectCollection invEntries = dynamicObject.getDynamicObjectCollection("inventry");
            int findIndex = 0;
            int dataIndex = 0;
            int selectIndex = 0;
            for (DynamicObject invEntry : invEntries) {
                DynamicObject projectKind = invEntry.getDynamicObject("inventry_projectkind");
                if (null != projectKind && currentTreeNode.equals(projectKind.getPkValue().toString())) {
                    int selectRowIndex = (Integer)stack.pop();
                    if (selectRowIndex == findIndex) {
                        newSelectRows[selectIndex] = dataIndex;
                        ++selectIndex;
                    } else {
                        stack.push(selectRowIndex);
                    }
                    ++findIndex;
                }
                if (stack.isEmpty()) break;
                ++dataIndex;
            }
            if (ROOTNODEID.equals(currentTreeNode)) {
                newSelectRows = Arrays.copyOf(selectRows, selectRows.length);
            }
            invEntryGrid.getEntryState().selectRow(newSelectRows);
        }
    }

    private void deleteInvestEntry() {
        this.summaryBudgetAmt();
        this.getView().updateView();
        if (null != this.getPageCache().get(CURRENTTREENODE)) {
            TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
            treeView.treeNodeClick(this.getPageCache().get(PARENTTREENODE), this.getPageCache().get(CURRENTTREENODE));
        }
    }

    private void showProjectProposalF7Form() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (null == model.getValue("year")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"InvestBudgetPlanBillPlugin_11", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject investBudgetPlan = model.getDataEntity();
        LocalDate year = investBudgetPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Optional.ofNullable(year).ifPresent(y -> {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"pmim_projectproposal_f7", (boolean)true);
            lsp.setAppId(this.getAppId());
            lsp.setMultiSelect(true);
            ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)year.getYear());
            DynamicObject org = investBudgetPlan.getDynamicObject("org");
            qFilter.and("reportorg", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            qFilter.and("reportbudget", "=", (Object)true);
            qFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
            qFilter.and("datasource", "=", (Object)"projectProposal");
            QFilter finalQFilter = qFilter.and("isquote", "=", (Object)false);
            DynamicObjectCollection investEntryCol = model.getEntryEntity("inventry");
            int size = investEntryCol.size();
            Optional.ofNullable(investEntryCol).ifPresent(col -> {
                if (size != 0) {
                    Object[] projectProposalIds = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        projectProposalIds[i] = Optional.ofNullable(col.get(i)).map(investEntry -> investEntry.getDynamicObject("inventry_projectproposal")).map(o -> o.getPkValue()).orElse(null);
                    }
                    lsp.setSelectedRows(projectProposalIds);
                    finalQFilter.or("id", "in", (Object)projectProposalIds);
                }
            });
            rangeFilterList.add(finalQFilter);
            lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmim_projectproposal_f7"));
            view.showForm((FormShowParameter)lsp);
        });
    }

    private boolean checkIsShow2Panel(String nodeId, DynamicObject projectKind, Map<Long, DynamicObject> projectKindMap) {
        if (nodeId == null || ROOTNODEID.equals(nodeId) || nodeId.equals(projectKind.getPkValue().toString())) {
            return true;
        }
        if (null == (projectKind = projectKindMap.get(projectKind.getPkValue())).get("parent")) {
            return false;
        }
        DynamicObject parent = projectKind.getDynamicObject("parent");
        return this.checkIsShow2Panel(nodeId, projectKindMap.get(parent.getPkValue()), projectKindMap);
    }

    private Map<Long, DynamicObject> getProjectKindMap() {
        DynamicObject[] projectKindCol = BusinessDataServiceHelper.load((String)BD_PROJECTKIND, (String)String.join((CharSequence)",", "number", "name", "parent"), (QFilter[])new QFilter[0]);
        HashMap<Long, DynamicObject> projectKindMap = new HashMap<Long, DynamicObject>(projectKindCol.length);
        for (DynamicObject projectKind : projectKindCol) {
            projectKindMap.put((Long)projectKind.getPkValue(), projectKind);
        }
        return projectKindMap;
    }

    private BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent event) {
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = model.getDynamicObjectCollection("inventry");
        TreeView treeView = (TreeView)this.getView().getControl("projectkindtree");
        String proKindId = treeView.getTreeState().getFocusNodeId();
        DynamicObjectCollection entriesByProKind = (DynamicObjectCollection)entrys.clone();
        this.getEntriesByProjectKind(proKindId, entriesByProKind);
        DynamicObject curRow = (DynamicObject)entriesByProKind.get(event.getRowIndex());
        DynamicObject projectProposalF7 = curRow.getDynamicObject("inventry_projectproposal");
        Long projectProposalId = projectProposalF7.getLong("projectproposalid");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setCustomParam("isView", (Object)true);
        showParameter.setFormId("pmim_projectproposal");
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)projectProposalId);
        return showParameter;
    }
}

