/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InvestBudgetPlanPropertyChanged
implements IDataModelChangeListener {
    protected AbstractBillPlugIn plugin;
    protected IDataModel dataModel;
    protected IFormView view;
    protected IPageCache pageCache;
    private static final String CURRENTTREENODE = "currentTreeNode";

    public InvestBudgetPlanPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        this.plugin = plugin;
        this.dataModel = dataModel;
        this.view = plugin.getView();
        this.pageCache = plugin.getPageCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        String ctrlName = e.getProperty().getName();
        DynamicObject investBudgetPlan = this.dataModel.getDataEntity(true);
        switch (ctrlName) {
            case "isreport": {
                this.isReportChange(investBudgetPlan, newValue, oldValue);
                break;
            }
            case "inventry_yearbugamt": {
                this.invEntry_yearBudgetAmtChange(changeData);
                break;
            }
            case "inventry_yearfiamt": {
                this.invEntry_yearFiAmtChange(changeData);
                break;
            }
            case "year": {
                this.yearChange(investBudgetPlan, newValue, oldValue);
            }
        }
    }

    private void yearChange(DynamicObject investBudgetPlan, Object newValue, Object oldValue) {
        DynamicObjectCollection inventrys = investBudgetPlan.getDynamicObjectCollection("inventry");
        inventrys.clear();
        this.view.updateView("inventry");
    }

    private void invEntry_yearFiAmtChange(ChangeData changeData) {
        DynamicObject projectKind;
        String projectKindId;
        int selectIndex = changeData.getRowIndex();
        DynamicObject entry = changeData.getDataEntity();
        Object oldValue = changeData.getOldValue();
        String oldId = entry.getPkValue().toString();
        int seq = entry.getInt("seq");
        if (!(null == this.pageCache.get(CURRENTTREENODE) || (projectKindId = (projectKind = entry.getDynamicObject("inventry_projectkind")).getPkValue().toString()).equals(this.pageCache.get(CURRENTTREENODE)) && seq - 1 == selectIndex)) {
            DynamicObject dynamicObject = this.dataModel.getDataEntity(true);
            int dataIndex = 0;
            DynamicObjectCollection inventrys = dynamicObject.getDynamicObjectCollection("inventry");
            for (DynamicObject inventry : inventrys) {
                String entryId = inventry.getPkValue().toString();
                if (oldId.equals(entryId)) {
                    inventry.set("inventry_yearfiamt", oldValue);
                }
                if (!(projectKindId = (projectKind = inventry.getDynamicObject("inventry_projectkind")).getPkValue().toString()).equals(this.pageCache.get(CURRENTTREENODE))) continue;
                if (dataIndex != selectIndex) {
                    ++dataIndex;
                    continue;
                }
                BigDecimal entryOldAmt = inventry.getBigDecimal("inventry_yearfiamt");
                seq = inventry.getInt("seq");
                inventry.set("inventry_yearfiamt", changeData.getNewValue());
                changeData = new ChangeData(seq - 1, inventry, (Object)entryOldAmt, changeData.getNewValue());
            }
        }
        BigDecimal[] totalYearFiAmt = new BigDecimal[]{BigDecimal.ZERO};
        DynamicObject projectProposal = this.dataModel.getDataEntity(true);
        Object newValue = changeData.getNewValue();
        oldValue = changeData.getOldValue();
        Optional.ofNullable(projectProposal.getBigDecimal("yearfiamt")).ifPresent(yearFiAmt -> {
            totalYearFiAmt[0] = yearFiAmt;
        });
        Optional.ofNullable(oldValue).map(amt -> amt.toString()).ifPresent(oldAmt -> {
            totalYearFiAmt[0] = totalYearFiAmt[0].subtract(new BigDecimal((String)oldAmt));
        });
        Optional.ofNullable(newValue).ifPresent(newAmt -> {
            totalYearFiAmt[0] = totalYearFiAmt[0].add(new BigDecimal(newAmt.toString()));
        });
        projectProposal.set("yearfiamt", (Object)totalYearFiAmt[0]);
        this.view.updateView("yearfiamt");
    }

    private void invEntry_yearBudgetAmtChange(ChangeData changeData) {
        DynamicObject projectKind;
        String projectKindId;
        int selectIndex = changeData.getRowIndex();
        DynamicObject entry = changeData.getDataEntity();
        Object oldValue = changeData.getOldValue();
        String oldId = entry.getPkValue().toString();
        int seq = entry.getInt("seq");
        if (!(null == this.pageCache.get(CURRENTTREENODE) || (projectKindId = (projectKind = entry.getDynamicObject("inventry_projectkind")).getPkValue().toString()).equals(this.pageCache.get(CURRENTTREENODE)) && seq - 1 == selectIndex)) {
            DynamicObject dynamicObject = this.dataModel.getDataEntity(true);
            int dataIndex = 0;
            DynamicObjectCollection inventrys = dynamicObject.getDynamicObjectCollection("inventry");
            for (DynamicObject inventry : inventrys) {
                String entryId = inventry.getPkValue().toString();
                if (oldId.equals(entryId)) {
                    inventry.set("inventry_yearbugamt", oldValue);
                }
                if (!(projectKindId = (projectKind = inventry.getDynamicObject("inventry_projectkind")).getPkValue().toString()).equals(this.pageCache.get(CURRENTTREENODE))) continue;
                if (dataIndex != selectIndex) {
                    ++dataIndex;
                    continue;
                }
                BigDecimal entryOldAmt = inventry.getBigDecimal("inventry_yearbugamt");
                seq = inventry.getInt("seq");
                inventry.set("inventry_yearbugamt", changeData.getNewValue());
                changeData = new ChangeData(seq - 1, inventry, (Object)entryOldAmt, changeData.getNewValue());
            }
        }
        BigDecimal[] totalYearBudgetAmt = new BigDecimal[]{BigDecimal.ZERO};
        DynamicObject projectProposal = this.dataModel.getDataEntity(true);
        Object newValue = changeData.getNewValue();
        oldValue = changeData.getOldValue();
        Optional.ofNullable(projectProposal.getBigDecimal("yearbugamt")).ifPresent(yearBudgetAmt -> {
            totalYearBudgetAmt[0] = yearBudgetAmt;
        });
        Optional.ofNullable(oldValue).map(amt -> amt.toString()).ifPresent(oldAmt -> {
            totalYearBudgetAmt[0] = totalYearBudgetAmt[0].subtract(new BigDecimal((String)oldAmt));
        });
        Optional.ofNullable(newValue).ifPresent(newAmt -> {
            totalYearBudgetAmt[0] = totalYearBudgetAmt[0].add(new BigDecimal(newAmt.toString()));
        });
        projectProposal.set("yearbugamt", (Object)totalYearBudgetAmt[0]);
        this.view.updateView("yearbugamt");
    }

    private void isReportChange(DynamicObject investBudgetPlan, Object newValue, Object oldValue) {
        if (null == investBudgetPlan.get("org")) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"InvestBudgetPlanPropertyChanged_1", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!((Boolean)newValue).booleanValue()) {
            investBudgetPlan.set("reportorg", null);
            this.view.updateView();
            return;
        }
        DynamicObject org = investBudgetPlan.getDynamicObject("org");
        QFilter qFilter = new QFilter("billcode.number", "=", (Object)"pmim_investbugetplan").and("enable", "=", (Object)true);
        DynamicObject reqOrgConf = BusinessDataServiceHelper.loadSingle((String)"pmbs_reqorgconf", (String)"billcode,entryentity,reportorg,declarateorg", (QFilter[])new QFilter[]{qFilter});
        if (null == reqOrgConf) {
            return;
        }
        DynamicObject reportOrg = null;
        DynamicObjectCollection entryentitys = reqOrgConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentitys) {
            DynamicObjectCollection declarateorgs = entryentity.getDynamicObjectCollection("declarateorg");
            for (DynamicObject declarateorg : declarateorgs) {
                DynamicObject applyOrg = declarateorg.getDynamicObject("fbasedataid");
                if (null == applyOrg || !applyOrg.getPkValue().toString().equals(org.getPkValue().toString())) continue;
                reportOrg = entryentity.getDynamicObject("reportorg");
                break;
            }
            if (null == reportOrg) continue;
            break;
        }
        investBudgetPlan.set("reportorg", reportOrg);
        this.view.updateView();
    }
}

