/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.AuthProjectKindHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmas.CapitalTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmim.business.helper.AunualinvesPlanHelper;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class InvestPlanAdjustBillPlugin
extends AbstractPmimBillPlugin
implements TreeNodeClickListener,
HyperLinkClickListener,
TipsListener,
TabSelectListener {
    private static final String CURRENTTREENODE = "currentTreeNode";
    private static final String Effective = "effective";
    private static final String ROOTNODEID = "001";
    public static final String TREE_PROJECTKIND = "projectkindtree";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static Log logger = LogFactory.getLog(InvestPlanAdjustBillPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FieldEdit planAmtFieldEdit = (FieldEdit)this.getView().getControl("annualstrategicplanamt");
        planAmtFieldEdit.addTipsListener((TipsListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("investentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_PROJECTKIND);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object billOrg = this.getModel().getValue("org");
        if (billOrg == null) {
            long orgId = RequestContext.get().getOrgId();
            DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            this.getModel().setValue("org", (Object)orgObject);
        }
        if (this.getModel().getValue("org") != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject currency = CurrencyHelper.getCurrency((Long)Long.parseLong(org.getPkValue().toString()));
            this.getModel().setValue("currency", (Object)currency);
            AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)TREE_PROJECTKIND, (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvestPlanAdjustBillPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)Long.parseLong(org.getPkValue().toString()));
            this.getPageCache().put(CURRENTTREENODE, ROOTNODEID);
            this.treeDataUpdateView(ROOTNODEID);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object year = this.getModel().getValue("year");
        if (year == null) {
            this.getModel().setValue("year", (Object)new Date());
        }
        DateEdit yearEdit = (DateEdit)this.getView().getControl("year");
        Date initDate = DateUtil.getYearStartTime((Date)new Date());
        yearEdit.setMinDate(DateUtil.getBeforeOrNextYearDate((Date)initDate, (boolean)false, (int)2));
        yearEdit.setMaxDate(DateUtil.getBeforeOrNextYearDate((Date)initDate, (boolean)true, (int)2));
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)TREE_PROJECTKIND, (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvestPlanAdjustBillPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)Long.parseLong(org.getPkValue().toString()));
        }
        this.getPageCache().put(CURRENTTREENODE, ROOTNODEID);
        this.treeDataUpdateView(ROOTNODEID);
        this.updateControlMetadata();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(CURRENTTREENODE, nodeId);
        this.treeDataUpdateView(nodeId);
    }

    private void treeDataUpdateView(String nodeId) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("investentry");
        DynamicObjectCollection viewEntries = (DynamicObjectCollection)entries.clone();
        this.getEntriesByProjectKind(nodeId, entries);
        if (viewEntries == null || viewEntries.isEmpty()) {
            return;
        }
        this.getModel().getDataEntity(true).set("investentry", (Object)entries);
        this.getView().updateView("investentry");
        this.getModel().getDataEntity(true).set("investentry", (Object)viewEntries);
        this.focusLastRow(0);
    }

    private void focusLastRow(int row) {
        DynamicObjectCollection invEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("investentry");
        EntryGrid grid = (EntryGrid)this.getView().getControl("investentry");
        if (row != -1) {
            grid.selectRows(row, true);
        } else {
            grid.selectRows(invEntries.size() - 1, true);
        }
    }

    private void getEntriesByProjectKind(String nodeId, DynamicObjectCollection entry) {
        Map projectKindMap = new AunualinvesPlanHelper().getProjectKindMap();
        Iterator iterator = entry.iterator();
        while (iterator.hasNext()) {
            DynamicObject viewEntry = (DynamicObject)iterator.next();
            DynamicObject projectKind = viewEntry.getDynamicObject("projectkind");
            if (null == projectKind || this.checkIsShow2Panel(nodeId, projectKind, projectKindMap)) continue;
            iterator.remove();
        }
    }

    private boolean checkIsShow2Panel(String nodeId, DynamicObject projectKind, Map<Long, DynamicObject> projectKindMap) {
        if (nodeId == null || ROOTNODEID.equals(nodeId) || nodeId.equals(projectKind.getPkValue().toString())) {
            return true;
        }
        if (null == (projectKind = projectKindMap.get(projectKind.getPkValue())).get("parent")) {
            return false;
        }
        DynamicObject parent = projectKind.getDynamicObject("parent");
        return this.checkIsShow2Panel(nodeId, projectKindMap.get(parent.getPkValue()), projectKindMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": 
            case "deleteentry": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("investentry");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows.length == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6295\u8d44\u9879\u76ee\u6e05\u5355\u3002", (String)"InvestPlanAdjustBillPlugin_1", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "submit": {
                DynamicObject investPlanAdjust = this.getModel().getDataEntity(true);
                DynamicObject org = investPlanAdjust.getDynamicObject("org");
                Date declareDate = investPlanAdjust.getDate("year");
                if (declareDate == null) break;
                int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
                qFilter.and("YEAR(year)", "=", (Object)declareYear);
                qFilter.and("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
                DynamicObject[] investPlanAdjusts = BusinessDataServiceHelper.load((String)"pmim_investplanadjustment", (String)"", (QFilter[])new QFilter[]{qFilter});
                if (investPlanAdjusts.length <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%1$s\u5e74\u5ea6\u5b58\u5728\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\u7684\u6295\u8d44\u8ba1\u5212\u8c03\u6574\u5355\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"InvestPlanAdjustBillPlugin_2", (String)"pmgt-pmim-formplugin", (Object[])new Object[]{declareYear}));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        DynamicObject investPlanAdjust = this.getModel().getDataEntity(true);
        FormOperate formOperate = (FormOperate)args.getSource();
        block8 : switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                this.updateControlMetadata();
                break;
            }
            case "deleteentry": {
                this.calculationOwnOrExAmt();
                this.changeEntryAmt(null);
                this.updateControlMetadata();
                break;
            }
            case "submit": {
                DynamicObjectCollection entries;
                OperationResult operationResult = args.getOperationResult();
                boolean success = operationResult.isSuccess();
                if (success || (entries = investPlanAdjust.getDynamicObjectCollection("investentry")).size() <= 0) break;
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    BigDecimal useBudgetAmt = entry.getBigDecimal("usebudgetamt");
                    BigDecimal proBudAppAmtAfAdjust = entry.getBigDecimal("probudappamtafadjust");
                    if (useBudgetAmt.compareTo(BigDecimal.ZERO) > 0 && useBudgetAmt.compareTo(proBudAppAmtAfAdjust) > 0) {
                        this.focusLastRow(i);
                        break block8;
                    }
                    BigDecimal yearUseBudgetAmt = entry.getBigDecimal("yearusebudgetamt");
                    BigDecimal yearAppAmtAfAdjust = entry.getBigDecimal("yearappamtafadjust");
                    if (yearUseBudgetAmt.compareTo(BigDecimal.ZERO) <= 0 || yearUseBudgetAmt.compareTo(yearAppAmtAfAdjust) <= 0) continue;
                    this.focusLastRow(i);
                    break block8;
                }
                break;
            }
            case "audit": 
            case "unaudit": {
                OperationResult operationResult = args.getOperationResult();
                boolean success = operationResult.isSuccess();
                if (!success) break;
                new AunualinvesPlanHelper().updateProposalAndDeclare(investPlanAdjust, operateKey);
                break;
            }
            case "effective": {
                OperationResult operationResult = args.getOperationResult();
                boolean success = operationResult.isSuccess();
                if (!success) break;
                new AunualinvesPlanHelper().updateEffectiveBill(investPlanAdjust);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f\u3002", (String)"InvestPlanAdjustBillPlugin_7", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String ctrlName;
        FieldEdit fieldEdit = (FieldEdit)e.getSource();
        switch (ctrlName = fieldEdit.getProperty().getName()) {
            case "entryamt": 
            case "fundsourcetype": 
            case "formofinvest": 
            case "currententryamt": 
            case "investcurrency": 
            case "comment": 
            case "scale": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("investentry");
                int[] selectRows = grid.getSelectRows();
                if (selectRows.length == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6295\u8d44\u9879\u76ee\u6e05\u5355\u3002", (String)"InvestPlanAdjustBillPlugin_1", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String ctrlName = e.getProperty().getName();
        DynamicObject investPlanAdjust = this.getModel().getDataEntity(true);
        ChangeData changeData = e.getChangeSet()[0];
        switch (ctrlName) {
            case "year": {
                DynamicObjectCollection entries = investPlanAdjust.getDynamicObjectCollection("investentry");
                if (entries.size() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u5e74\u5ea6\uff0c\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\u91cd\u65b0\u53d6\u6570\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u53d8\u66f4\uff1f", (String)"InvestPlanAdjustBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("changeYear", (IFormPlugin)this));
                    String oldYear = "";
                    if (changeData.getOldValue() != null) {
                        Date oldValue = (Date)changeData.getOldValue();
                        oldYear = this.sdf.format(oldValue);
                    }
                    this.getPageCache().put("oldYear", oldYear);
                    break;
                }
                this.changeYear();
                break;
            }
            case "currententryamt": {
                this.calculationOwnOrExAmt();
                this.changeEntryAmt("currententryamt");
                break;
            }
            case "entryamt": {
                this.calculationOwnOrExAmt();
                this.changeEntryAmt("entryamt");
                this.autoCalculationScale();
                break;
            }
            case "fundsourcetype": {
                this.calculationOwnOrExAmt();
            }
            case "yearappamtafadjust": {
                this.summaryInvestBudAmtAfAdjustAmt();
                this.updateControlMetadata();
                break;
            }
            case "probudappamtafadjust": {
                this.updateControlMetadata();
                break;
            }
            case "approvalcon": {
                this.summaryInvestBudAmtAfAdjustAmt();
                this.summaryInvestBudAmtBeAdjustAmt();
                this.updateControlMetadata();
                break;
            }
        }
    }

    private void changeEntryAmt(String column) {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("investentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("investentry");
        if (entries.size() > 0) {
            DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
            DynamicObjectCollection budgetFundsSource = invEntry.getDynamicObjectCollection("budgetfundssource");
            if (StringUtils.equals((CharSequence)"currententryamt", (CharSequence)column)) {
                BigDecimal investBudAmtAfAdjust = budgetFundsSource.stream().map(o -> o.getBigDecimal("currententryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                invEntry.set("yearappamtafadjust", (Object)investBudAmtAfAdjust);
            } else if (StringUtils.equals((CharSequence)"entryamt", (CharSequence)column)) {
                BigDecimal proBudAppAmtAfAdjust = budgetFundsSource.stream().map(o -> o.getBigDecimal("entryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                invEntry.set("probudappamtafadjust", (Object)proBudAppAmtAfAdjust);
            } else {
                BigDecimal investBudAmtAfAdjust = budgetFundsSource.stream().map(o -> o.getBigDecimal("currententryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                invEntry.set("yearappamtafadjust", (Object)investBudAmtAfAdjust);
                BigDecimal proBudAppAmtAfAdjust = budgetFundsSource.stream().map(o -> o.getBigDecimal("entryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                invEntry.set("probudappamtafadjust", (Object)proBudAppAmtAfAdjust);
            }
        }
        this.getView().updateView("investentry", selectRows[0]);
        this.focusLastRow(selectRows[0]);
        this.summaryInvestBudAmtAfAdjustAmt();
        this.updateControlMetadata();
    }

    private void calculationOwnOrExAmt() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("investentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("investentry");
        if (entries.size() > 0) {
            DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
            DynamicObjectCollection budgetFundsSource = invEntry.getDynamicObjectCollection("budgetfundssource");
            BigDecimal proOwnedFunds = BigDecimal.ZERO;
            BigDecimal proExternalFunds = BigDecimal.ZERO;
            BigDecimal proYearOwnedFunds = BigDecimal.ZERO;
            BigDecimal proYearExternalFunds = BigDecimal.ZERO;
            if (budgetFundsSource.size() > 0) {
                for (DynamicObject fundsSource : budgetFundsSource) {
                    BigDecimal entryAmt = fundsSource.getBigDecimal("entryamt");
                    BigDecimal currentEntryAmt = fundsSource.getBigDecimal("currententryamt");
                    DynamicObject fundSourceType = fundsSource.getDynamicObject("fundsourcetype");
                    if (fundSourceType == null) continue;
                    String capitalType = fundSourceType.getString("capitaltype");
                    if (CapitalTypeEnum.OWN_FUNDS.getValue().equals(capitalType)) {
                        proOwnedFunds = proOwnedFunds.add(entryAmt);
                        proYearOwnedFunds = proYearOwnedFunds.add(currentEntryAmt);
                        continue;
                    }
                    proExternalFunds = proExternalFunds.add(entryAmt);
                    proYearExternalFunds = proYearExternalFunds.add(currentEntryAmt);
                }
            }
            this.getModel().setValue("proownedfunds", (Object)proOwnedFunds, selectRows[0]);
            this.getModel().setValue("proexternalfunds", (Object)proExternalFunds, selectRows[0]);
            this.getModel().setValue("proyearexternalfunds", (Object)proYearExternalFunds, selectRows[0]);
            this.getModel().setValue("proyearownedfunds", (Object)proYearOwnedFunds, selectRows[0]);
        }
    }

    private void summaryInvestBudAmtAfAdjustAmt() {
        DynamicObjectCollection invEntries = this.getModel().getEntryEntity("investentry");
        if (invEntries.size() > 0) {
            BigDecimal investBudAmtAfAdjust = invEntries.stream().filter(o -> !StringUtils.equals((CharSequence)"unpass", (CharSequence)o.getString("approvalcon"))).map(o -> o.getBigDecimal("yearappamtafadjust")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            this.getModel().setValue("investbudamtafadjust", (Object)investBudAmtAfAdjust);
        }
    }

    private void summaryInvestBudAmtBeAdjustAmt() {
        DynamicObjectCollection invEntries = this.getModel().getEntryEntity("investentry");
        if (invEntries.size() > 0) {
            BigDecimal investBudAmtAfAdjust = invEntries.stream().filter(o -> !StringUtils.equals((CharSequence)"unpass", (CharSequence)o.getString("approvalcon"))).map(o -> o.getBigDecimal("yearapproveamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            this.getModel().setValue("investbudamtbeadjust", (Object)investBudAmtAfAdjust);
        }
    }

    private void autoCalculationScale() {
        DynamicObject aunLivesPlan = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("investentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = aunLivesPlan.getDynamicObjectCollection("investentry");
        if (entries.size() > 0) {
            DynamicObject invEntry = (DynamicObject)entries.get(selectRows[0]);
            BigDecimal proInvestSumAmt = invEntry.getBigDecimal("probudappamtafadjust");
            DynamicObjectCollection functionEntry = invEntry.getDynamicObjectCollection("budgetfundssource");
            for (DynamicObject funSource : functionEntry) {
                if (proInvestSumAmt.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal entryAmt = funSource.getBigDecimal("entryamt");
                    BigDecimal scale = entryAmt.divide(proInvestSumAmt, 4, 4).multiply(new BigDecimal(100));
                    funSource.set("scale", (Object)scale);
                    continue;
                }
                funSource.set("scale", (Object)BigDecimal.ZERO);
            }
            this.getView().updateView("budgetfundssource");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("changeYear".equals(key)) {
            if (MessageBoxResult.Yes == evt.getResult()) {
                DynamicObject investPlanAdjust = this.getModel().getDataEntity(true);
                DynamicObjectCollection entries = investPlanAdjust.getDynamicObjectCollection("investentry");
                entries.clear();
                this.getView().updateView("investentry");
                this.getModel().setValue("annualstrategicplanamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("investbudamtafadjust", (Object)BigDecimal.ZERO);
                this.getModel().setValue("investbudamtbeadjust", (Object)BigDecimal.ZERO);
                this.changeYear();
            } else {
                String oldYear = this.getPageCache().get("oldYear");
                this.getModel().beginInit();
                if (StringUtils.isNotBlank((CharSequence)oldYear)) {
                    try {
                        Date year = this.sdf.parse(oldYear);
                        this.getModel().setValue("year", (Object)year);
                        this.getView().updateView("year");
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                    }
                } else {
                    this.getModel().setValue("year", null);
                    this.getView().updateView("year");
                }
                this.getModel().endInit();
            }
        }
    }

    private void changeYear() {
        DynamicObject investPlanAdjust = this.getModel().getDataEntity(true);
        Date declareDate = investPlanAdjust.getDate("year");
        if (declareDate != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            boolean hasInvestDeclare = new AunualinvesPlanHelper().judgeHasInvestDeclare(declareYear, org);
            if (hasInvestDeclare) {
                BigDecimal annualStrategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, org);
                this.getModel().setValue("annualstrategicplanamt", (Object)annualStrategicPlanAmt);
                DynamicObjectCollection entries = investPlanAdjust.getDynamicObjectCollection("investentry");
                Map investListMap = new AunualinvesPlanHelper().getInvestListByOrgYear(declareYear, org);
                List investList = (List)investListMap.get("adjust");
                if (investList != null && investList.size() > 0) {
                    new AunualinvesPlanHelper().packageInvestList(entries, investList, "pmim_investplanadjustment", declareYear);
                } else {
                    investList = (List)investListMap.get("annual");
                    new AunualinvesPlanHelper().packageInvestList(entries, investList, "pmim_aunualinvestplan", declareYear);
                }
                investList = (List)investListMap.get("special");
                new AunualinvesPlanHelper().packageInvestList(entries, investList, "pmim_specialdeclarainvest", declareYear);
                this.getView().updateView("investentry");
                if (entries.size() > 0) {
                    BigDecimal investBudAmtBeAdjust = entries.stream().filter(o -> !StringUtils.equals((CharSequence)"unpass", (CharSequence)o.getString("approvalcon"))).map(o -> o.getBigDecimal("yearapproveamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    this.getModel().setValue("investbudamtbeadjust", (Object)investBudAmtBeAdjust);
                    BigDecimal investBudAmtAfAdjust = entries.stream().filter(o -> !StringUtils.equals((CharSequence)"unpass", (CharSequence)o.getString("approvalcon"))).map(o -> o.getBigDecimal("yearappamtafadjust")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    this.getModel().setValue("investbudamtafadjust", (Object)investBudAmtAfAdjust);
                }
                this.updateControlMetadata();
                if (null != this.getPageCache().get(CURRENTTREENODE)) {
                    this.treeDataUpdateView(this.getPageCache().get(CURRENTTREENODE));
                }
                this.focusLastRow(-1);
            } else {
                String tip = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u201c%2$s\u201d\u5e74\u5df2\u7533\u62a5\u7684\u6570\u636e\uff0c\u65e0\u9700\u8c03\u6574\u3002", (String)"InvestPlanAdjustBillPlugin_9", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), org.getString("name"), declareYear);
                this.getView().showTipNotification(tip);
                this.getModel().beginInit();
                this.getModel().setValue("year", null);
                this.getView().updateView("year");
                this.getModel().endInit();
            }
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        DynamicObject bill = this.getModel().getDataEntity(true);
        Date declareDate = bill.getDate("year");
        if (declareDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"InvestPlanAdjustBillPlugin_5", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject org = bill.getDynamicObject("org");
        int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        BigDecimal annualStrategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, org);
        if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("annualstrategicplanamt", (Object)annualStrategicPlanAmt);
        }
        evt.setCancel(true);
    }

    private void updateControlMetadata() {
        DynamicObject investPlanAdjust;
        DynamicObjectCollection entries;
        BigDecimal annualStrategicPlanAmt = (BigDecimal)this.getModel().getValue("annualstrategicplanamt");
        if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal InvestBudAmt = (BigDecimal)this.getModel().getValue("investbudamtafadjust");
            HashMap<String, String> propMap = new HashMap<String, String>();
            String foreColor = "#000000";
            if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0 && annualStrategicPlanAmt.compareTo(InvestBudAmt) < 0) {
                foreColor = "#FF0000";
            }
            propMap.put("fc", foreColor);
            this.getView().updateControlMetadata("investbudamtafadjust", propMap);
        }
        if ((entries = (investPlanAdjust = this.getModel().getDataEntity(true)).getDynamicObjectCollection("investentry")).size() > 0) {
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject investList = (DynamicObject)entries.get(i);
                DynamicObjectCollection budgetFunSources = investList.getDynamicObjectCollection("budgetfundssource");
                if (budgetFunSources.size() > 0) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"probudappamtafadjust"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"yearappamtafadjust"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"probudappamtafadjust"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"yearappamtafadjust"});
                }
                BigDecimal proBudAppAmtAfAdjust = investList.getBigDecimal("probudappamtafadjust");
                BigDecimal useBudgetAmt = investList.getBigDecimal("usebudgetamt");
                String foreColor = "#000000";
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(i);
                cellStyle.setFieldKey("probudappamtafadjust");
                if (useBudgetAmt.compareTo(BigDecimal.ZERO) > 0 && useBudgetAmt.compareTo(proBudAppAmtAfAdjust) > 0) {
                    foreColor = "#FF0000";
                }
                cellStyle.setForeColor(foreColor);
                cellStyles.add(cellStyle);
                BigDecimal yearAppAmtAfAdjust = investList.getBigDecimal("yearappamtafadjust");
                BigDecimal yearUseBudgetAmt = investList.getBigDecimal("yearusebudgetamt");
                foreColor = "#000000";
                cellStyle = new CellStyle();
                cellStyle.setRow(i);
                cellStyle.setFieldKey("yearappamtafadjust");
                if (yearUseBudgetAmt.compareTo(BigDecimal.ZERO) > 0 && yearUseBudgetAmt.compareTo(yearAppAmtAfAdjust) > 0) {
                    foreColor = "#FF0000";
                }
                cellStyle.setForeColor(foreColor);
                cellStyles.add(cellStyle);
            }
            if (cellStyles.size() > 0) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("investentry");
                entryGrid.setCellStyle(cellStyles);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        BillShowParameter showParameter = this.getHyperLinkClickShowParameter(event);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent event) {
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = model.getDynamicObjectCollection("investentry");
        TreeView treeView = (TreeView)this.getView().getControl(TREE_PROJECTKIND);
        String proKindId = treeView.getTreeState().getFocusNodeId();
        DynamicObjectCollection entriesByProKind = (DynamicObjectCollection)entries.clone();
        this.getEntriesByProjectKind(proKindId, entriesByProKind);
        DynamicObject curRow = (DynamicObject)entriesByProKind.get(event.getRowIndex());
        DynamicObject project = curRow.getDynamicObject("projectno");
        String projectType = curRow.getString("projecttype");
        long billId = project.getLong("id");
        String formId = "pmim_projectproposal";
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("bd_project".equals(projectType)) {
            QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (proApp == null) {
                DynamicObject sysProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                if (sysProject != null) {
                    billId = Long.parseLong(sysProject.getPkValue().toString());
                    formId = "bd_project";
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                }
            } else {
                billId = Long.parseLong(proApp.getPkValue().toString());
                formId = "pmas_pro_approval";
            }
        }
        showParameter.setCustomParam("isView", (Object)true);
        showParameter.setFormId(formId);
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        showParameter.setPkId((Object)billId);
        return showParameter;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"suminvestamt")) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            new AunualinvesPlanHelper().packageSumInvestListByAdjust(bill);
            this.getView().updateView("suminvestlist");
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }
}

