/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ProjectKindHelper;
import kd.pmgt.pmbs.business.helper.SerializeHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.AddPmsgEntryTypeEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmim.business.helper.ProjectProposalHelper;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class ProjectProposalBillPlugin
extends AbstractPmimBillPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
BeforeQuickAddNewListener {
    public static final String SELECT_ROWS_PK = "selectRowsPk";
    public static final String CTRL_ADJUST = "adjust";
    public static final String CTRL_IMPORTPROJECTMSG = "importprojectmsg";
    public static final String CTRL_DELETEENTRY = "deleteentry";
    public static final String CTRL_CANCEL = "cancel";
    public static final String CTRL_UNCANCEL = "uncancel";
    public static final String CTRL_DEILTEFUNENTRY = "fundsourcedeleteentry";

    public String getAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public void registerListener(EventObject e) {
        BasedataEdit Index;
        BasedataEdit reportOrg;
        BasedataEdit proLeader;
        EntryGrid pmsgEntry;
        super.registerListener(e);
        BasedataEdit projectKind = (BasedataEdit)this.getView().getControl("projectkind");
        if (projectKind != null) {
            projectKind.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            projectKind.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        }
        if ((pmsgEntry = (EntryGrid)this.getView().getControl("pmsgentry")) != null) {
            pmsgEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((proLeader = (BasedataEdit)this.getControl("projectower")) != null) {
            proLeader.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((reportOrg = (BasedataEdit)this.getControl("reportorg")) != null) {
            reportOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((Index = (BasedataEdit)this.getControl("indexname")) != null) {
            Index.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (null != org) {
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((Long)((Long)org.getPkValue())));
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (null != formShowParameter.getCustomParam("isView")) {
            this.getModel().setValue("isView", (Object)true);
        }
        BasedataEdit reportOrg = (BasedataEdit)this.getControl("reportorg");
        Boolean reportBudget = (Boolean)this.getModel().getValue("reportbudget");
        reportOrg.setMustInput(reportBudget.booleanValue());
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        String key = ((Control)event.getSource()).getKey();
        FormShowParameter formShowParameter = event.getShowParameter();
        switch (key) {
            case "projectkind": {
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.Modal);
                formShowParameter.setOpenStyle(openStyle);
                formShowParameter.setCustomParam("quickAddNew", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "importprojectmsg": {
                this.beforeReSubmit(args);
                break;
            }
            case "deleteentry": {
                this.checkDeleteEntryRow(args);
                break;
            }
            case "adjust": {
                this.beforeAdjust(args);
                break;
            }
            case "save": 
            case "submit": {
                this.beforeSaveAndSubmit(operateKey);
                break;
            }
        }
    }

    private void beforeSaveAndSubmit(String operateKey) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("pmsgentry");
        if (entries.size() == 0) {
            this.getModel().createNewEntryRow("pmsgentry");
        }
        this.getModel().setValue("pmsgentry_year", this.getModel().getValue("year"), 0);
        if (!((Boolean)this.getModel().getValue("reportbudget")).booleanValue() && "submit".equals(operateKey)) {
            this.getModel().setValue("pmsgentry_isquote", (Object)true, 0);
        }
        this.getModel().setValue("pmsg_reportbudget", this.getModel().getValue("reportbudget"), 0);
        this.getModel().setValue("pmsg_reportorg", this.getModel().getValue("reportorg"), 0);
        this.getModel().setValue("pmsgentry_yearfiamt", this.getModel().getValue("yearfiamt"), 0);
        this.getModel().setValue("pmsgentry_yearbugamt", this.getModel().getValue("yearbugamt"), 0);
        this.getModel().setValue("pmsgentry_arrearsamt", this.getModel().getValue("arrearsamt"), 0);
        this.getModel().setValue("pmsgentry_lastyearbugamt", this.getModel().getValue("lastyearbugamt"), 0);
        this.getModel().setValue("pmsgentry_lastyearfiamt", this.getModel().getValue("lastyearfiamt"), 0);
        this.getModel().setValue("version", (Object)BigDecimal.ONE, 0);
    }

    private void beforeAdjust(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pmsgentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8c03\u6574\u7684\u5e74\u5ea6\u4fe1\u606f\u3002", (String)"ProjectProposalBillPlugin_7", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u8c03\u6574\u4e00\u884c\u5e74\u5ea6\u4fe1\u606f\u3002", (String)"ProjectProposalBillPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!ProjectProposalHelper.checkCanDoOperation((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (BeforeDoOperationEventArgs)args, (String)AddPmsgEntryTypeEnum.ADJUST.getValue())) {
            return;
        }
        DynamicObjectCollection pmsgEntries = this.getModel().getEntryEntity("pmsgentry");
        DynamicObject selected = (DynamicObject)pmsgEntries.get(selectRows[0]);
        int selectedYear = selected.getDate("pmsgentry_year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        BigDecimal selectedVersion = selected.getBigDecimal("version");
        for (int i = 0; i < pmsgEntries.size(); ++i) {
            if (i == selectRows[0]) continue;
            int entryYear = ((DynamicObject)pmsgEntries.get(i)).getDate("pmsgentry_year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            BigDecimal entryVersion = ((DynamicObject)pmsgEntries.get(i)).getBigDecimal("version");
            if (selectedYear != entryYear || entryVersion.compareTo(selectedVersion) < 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e74\u5ea6\u9884\u7b97\u5df2\u8c03\u6574\uff0c\u8bf7\u9009\u62e9\u6700\u65b0\u7248\u8c03\u6574\u3002", (String)"ProjectProposalBillPlugin_29", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean reportBudget = selected.getBoolean("pmsg_reportbudget");
        boolean isQuote = selected.getBoolean("pmsgentry_isquote");
        if (reportBudget && !isQuote) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e74\u5ea6\u9884\u7b97\u672a\u7533\u62a5\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"ProjectProposalBillPlugin_30", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String budgetApplyResult = selected.getString("budgetapplyresult");
        if (reportBudget && isQuote && (budgetApplyResult == null || budgetApplyResult.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e74\u5ea6\u9884\u7b97\u6b63\u5728\u7533\u62a5\u4e2d\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"ProjectProposalBillPlugin_31", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.showProjectProposalF7(selectRows[0], AddPmsgEntryTypeEnum.ADJUST.getValue(), false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentry": {
                this.afterDeleteEntryRow();
                break;
            }
            case "cancel": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.cancelProjectProposal();
                break;
            }
            case "uncancel": {
                this.unCancelProjectProposal();
                break;
            }
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                ProjectProposalHelper.updateCurBillAndDataF7((DynamicObject)this.getModel().getDataEntity(true), (String)operateKey);
                this.getView().updateView("pmsgentry");
                this.getView().updateView("indexentity");
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submit": {
                this.getView().updateView("indexentity");
                break;
            }
            case "save": {
                QFilter idFilter = new QFilter("id", "=", this.getModel().getDataEntity().getPkValue());
                boolean isExists = QueryServiceHelper.exists((String)"pmim_projectproposal", (QFilter[])new QFilter[]{idFilter});
                if (!isExists) break;
                DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"pmim_projectproposal");
                ProjectProposalHelper.syncProjectProposalF7((DynamicObject)projectProposal);
                break;
            }
            case "fundsourcedeleteentry": {
                this.autoCalculationScale();
                this.sumToYearBugamt();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "pmsgentry": {
                this.reFlashProjectMsgData();
                break;
            }
            case "cancel": {
                this.reFlashProjectProjectProposalData();
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        String billNo = sourceData.get("billno").toString();
        boolean isExists = QueryServiceHelper.exists((String)"pmim_projectproposal", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (isExists) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bae\u4e66%s\u5df2\u5b58\u5728\u3002", (String)"ProjectProposalBillPlugin_32", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), billNo));
        }
    }

    protected void cancelProjectProposal() {
        Long[] billIds;
        DynamicObject model = this.getModel().getDataEntity();
        if (!BizStatusEnum.NORMAL.getValue().equals(model.getString("bizstatus")) || !StatusEnum.CHECKED.getValue().equals(model.getString("billstatus"))) {
            return;
        }
        for (DynamicObject pmsgEntry : model.getDynamicObjectCollection("pmsgentry")) {
            boolean isRefenced = ProjectProposalHelper.checkProjectProposalF7IsRefenced((Object)pmsgEntry.getPkValue());
            boolean isReport = pmsgEntry.getBoolean("pmsg_reportbudget");
            if (!isReport || !isRefenced && !pmsgEntry.getBoolean("pmsgentry_isquote")) continue;
            return;
        }
        String sourceEntityNumber = model.getDataEntityType().getName();
        Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)sourceEntityNumber, (Long[])(billIds = new Long[]{model.getLong("id")}));
        if (null != targetBillIds && !targetBillIds.isEmpty()) {
            return;
        }
        this.showCancelForm();
    }

    private void unCancelProjectProposal() {
        this.getModel().setValue("bizstatus", (Object)BizStatusEnum.NORMAL.getValue());
        DynamicObject projectProposal = this.getModel().getDataEntity();
        SaveServiceHelper.update((DynamicObject)projectProposal);
        this.getView().updateView();
    }

    private void checkDeleteEntryRow(BeforeDoOperationEventArgs args) {
        LocalDate year;
        DynamicObject projectProposal = this.getModel().getDataEntity(true);
        Date applyYear = projectProposal.getDate("year");
        LocalDate localDate = year = applyYear == null ? null : applyYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (year == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u884c\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"ProjectProposalBillPlugin_25", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pmsgentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entries = projectProposal.getDynamicObjectCollection("pmsgentry");
        ArrayList<Object> selectRowsPk = new ArrayList<Object>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject select = (DynamicObject)entries.get(index);
            if (!this.checkIsQuote(select)) {
                args.setCancel(true);
                return;
            }
            Date entryApplyYear = select.getDate("pmsgentry_year");
            LocalDate entrySelectedYear = entryApplyYear == null ? null : entryApplyYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            BigDecimal version = select.getBigDecimal("version");
            if (entrySelectedYear == null || entrySelectedYear.getYear() == year.getYear() && version.compareTo(BigDecimal.ONE) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u884c\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"ProjectProposalBillPlugin_25", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int i = 0; i < entries.size(); ++i) {
                LocalDate entryYear;
                LocalDate localDate2 = entryYear = ((DynamicObject)entries.get(i)).getDate("pmsgentry_year") == null ? null : ((DynamicObject)entries.get(i)).getDate("pmsgentry_year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                if (i == index || entryYear == null || entrySelectedYear.getYear() != entryYear.getYear() || select.getBigDecimal("version").compareTo(((DynamicObject)entries.get(i)).getBigDecimal("version")) >= 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e74\u5ea6\u9879\u76ee\u4fe1\u606f\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ProjectProposalBillPlugin_33", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            selectRowsPk.add(select.getPkValue());
        }
        if (!ProjectProposalHelper.checkCanDoOperation((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (BeforeDoOperationEventArgs)args, (String)CTRL_DELETEENTRY)) {
            return;
        }
        this.getPageCache().put(SELECT_ROWS_PK, SerializeHelper.serialize(selectRowsPk));
    }

    private boolean checkIsQuote(DynamicObject select) {
        Boolean isQuote = select.getBoolean("pmsgentry_isquote");
        boolean isReport = select.getBoolean("pmsg_reportbudget");
        if (isReport && isQuote.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e74\u5ea6\u9879\u76ee\u4fe1\u606f\u5df2\u7533\u62a5\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ProjectProposalBillPlugin_34", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return false;
        }
        String algoKey = "ProjectProposalBillPlugin.checkIsQuote";
        String invEntrySelect = "SELECT fid FROM t_pmim_inventry where fprojectproposalid = ?";
        DataSet invEntryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)invEntrySelect, (Object[])new Object[]{Long.parseLong(select.getPkValue().toString())});
        String auInvestPlanEntrySelect = "SELECT fid FROM t_pmim_auinvestplanentry where finvestlistid = ?";
        DataSet auInvestPlanEntryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)auInvestPlanEntrySelect, (Object[])new Object[]{select.getPkValue().toString()});
        if (invEntryDataSet.iterator().hasNext() || auInvestPlanEntryDataSet.iterator().hasNext()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e74\u5ea6\u9879\u76ee\u4fe1\u606f\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ProjectProposalBillPlugin_35", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void afterDeleteEntryRow() {
        DynamicObject projectProposal = this.getModel().getDataEntity(true);
        DynamicObjectCollection pMSGEntry = projectProposal.getDynamicObjectCollection("pmsgentry");
        List selectRowsPk = (List)SerializeHelper.unserialize((String)this.getPageCache().get(SELECT_ROWS_PK));
        DeleteServiceHelper.delete((IDataEntityType)pMSGEntry.getDynamicObjectType(), (Object[])selectRowsPk.toArray(new Object[selectRowsPk.size()]));
        projectProposal = BusinessDataServiceHelper.loadSingle((Object)projectProposal.getPkValue(), (String)"pmim_projectproposal");
        ProjectProposalHelper.syncProjectProposalF7((DynamicObject)projectProposal);
        pMSGEntry = projectProposal.getDynamicObjectCollection("pmsgentry");
        ProjectProposalHelper.reSetPMSGEntrySeq((DynamicObjectCollection)pMSGEntry);
        ProjectProposalHelper.updateSumAppAmt((DynamicObject)projectProposal);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u5df2\u6210\u529f\u5220\u9664\u3002", (String)"ProjectProposalBillPlugin_36", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
    }

    private void reFlashProjectMsgData() {
        IDataModel model = this.getModel();
        long id = (Long)model.getValue("id");
        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmim_projectproposal");
        DynamicObjectCollection pmsgEntries = projectProposal.getDynamicObjectCollection("pmsgentry");
        model.getDataEntity(true).set("pmsgentry", (Object)pmsgEntries);
        this.getView().updateView("pmsgentry");
        ProjectProposalHelper.updateSumAppAmt((DynamicObject)projectProposal);
        this.getView().invokeOperation("refresh");
    }

    private void reFlashProjectProjectProposalData() {
        IDataModel model = this.getModel();
        long id = (Long)model.getValue("id");
        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmim_projectproposal");
        model.getDataEntity().set("operationer", projectProposal.get("operationer"));
        model.getDataEntity().set("operationdate", projectProposal.get("operationdate"));
        model.getDataEntity().set("canceldescription", projectProposal.get("canceldescription"));
        model.getDataEntity().set("bizstatus", projectProposal.get("bizstatus"));
        this.getView().updateView();
        if (projectProposal.getString("bizstatus").equals(BizStatusEnum.CANCEL.getValue())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f\u3002", (String)"ProjectProposalBillPlugin_28", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforeReSubmit(BeforeDoOperationEventArgs args) {
        if (!ProjectProposalHelper.checkCanDoOperation((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (BeforeDoOperationEventArgs)args, (String)AddPmsgEntryTypeEnum.RESUBMIT.getValue())) {
            return;
        }
        this.showProjectProposalF7(-1, AddPmsgEntryTypeEnum.RESUBMIT.getValue(), false);
    }

    private void showProjectProposalF7(int selectRow, String type, boolean modify) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmim_projectproposal_f7");
        showParameter.setAppId(this.getAppId());
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("selectRow", (Object)selectRow);
        if (AddPmsgEntryTypeEnum.ADJUST.getValue().equals(type)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u5e74\u5ea6\u6295\u8d44\u8c03\u6574", (String)"ProjectProposalBillPlugin_15", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        }
        if (modify) {
            showParameter.setPkId(this.getModel().getEntryRowEntity("pmsgentry", selectRow).getPkValue());
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCustomParam("pmim_projectproposal", (Object)this.getModel().getValue("id").toString());
        showParameter.setCustomParam("type", (Object)type);
        showParameter.setCustomParam("modify", (Object)modify);
        IDataModel dataModel = this.getModel();
        DynamicObject proposal = dataModel.getDataEntity();
        DynamicObject org = proposal.getDynamicObject("org");
        showParameter.setCustomParam("createorg", (Object)org.getPkValue().toString());
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            showParameter.setCustomParam("currency", (Object)currency.getPkValue().toString());
        } else if (org.getBoolean("fisaccounting")) {
            currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()));
            if (currency == null) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u5e01\u79cd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"ProjectProposalBillPlugin_24", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setCustomParam("currency", (Object)currency.getPkValue().toString());
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmsgentry"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showCancelForm() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId("pmim_ppcancelpage");
        showParameter.setStatus(OperationStatus.EDIT);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("pmim_projectproposal", model.getValue("id"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CTRL_CANCEL));
        view.showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        super.beforeF7Select(beforeF7SelectEvent);
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "projectower": {
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                long currUserId = RequestContext.get().getCurrUserId();
                List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)currUserId);
                if (userOrgRanges.size() <= 0) break;
                qFilterList.add(new QFilter("entryentity.dpt.id", "in", (Object)userOrgRanges));
                break;
            }
            case "projectkind": {
                DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)"id", (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)"0")});
                ArrayList<Object> projectIdList = new ArrayList<Object>(10);
                for (DynamicObject projectKind : projectKinds) {
                    projectIdList.add(projectKind.getPkValue());
                }
                DynamicObject[] projectKindSettingArray = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"projectkind", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)EnableEnum.DISABLE.getValue())});
                if (projectKindSettingArray != null && projectKindSettingArray.length > 0) {
                    projectIdList.addAll(Arrays.stream(projectKindSettingArray).map(it -> it.getDynamicObject("projectkind").getPkValue()).collect(Collectors.toSet()));
                }
                QFilter leafFilter = new QFilter("id", "not in", (Object)projectIdList.toArray());
                beforeF7SelectEvent.addCustomQFilter(leafFilter);
                QFilter projectKindFilter = ProjectKindHelper.projectKindIdFilter();
                beforeF7SelectEvent.addCustomQFilter(projectKindFilter);
                List treeNodes = ProjectKindHelper.getProjectKindTreeNodeWithoutRoot((IFormView)this.getView());
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("treeNodes", (Object)SerializationUtils.toJsonString((Object)treeNodes));
                break;
            }
            case "indexname": {
                DynamicObject indexname;
                int row = beforeF7SelectEvent.getRow();
                DynamicObject indexentity = this.getModel().getEntryRowEntity("indexentity", row);
                if (indexentity == null || (indexname = indexentity.getDynamicObject("indexname")) == null) break;
                long indexId = Long.parseLong(indexname.getPkValue().toString());
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setSelectedRow((Object)indexId);
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        e.getSourceData();
        IDataModel dataModel = this.getModel();
        DynamicObject proposal = dataModel.getDataEntity();
        DynamicObjectCollection pmsgEntry = proposal.getDynamicObjectCollection("pmsgentry");
        if (pmsgEntry.size() == 0) {
            DynamicObject addNew = pmsgEntry.addNew();
            if (proposal.getDate("year") != null) {
                addNew.set("pmsgentry_year", (Object)proposal.getDate("year"));
            }
            if (proposal.getBigDecimal("yearbugamt") != null) {
                addNew.set("pmsgentry_yearbugamt", (Object)proposal.getBigDecimal("yearbugamt"));
            }
            if (proposal.getBigDecimal("yearfiamt") != null) {
                addNew.set("pmsgentry_yearfiamt", (Object)proposal.getBigDecimal("yearfiamt"));
            }
            if (proposal.getBigDecimal("arrearsamt") != null) {
                addNew.set("pmsgentry_arrearsamt", (Object)proposal.getBigDecimal("arrearsamt"));
            }
            if (proposal.getBigDecimal("lastyearbugamt") != null) {
                addNew.set("pmsgentry_lastyearbugamt", (Object)proposal.getBigDecimal("lastyearbugamt"));
            }
            if (proposal.getBigDecimal("lastyearfiamt") != null) {
                addNew.set("pmsgentry_lastyearfiamt", (Object)proposal.getBigDecimal("lastyearfiamt"));
            }
            if (proposal.getString("ownershipstructure") != null) {
                addNew.set("pmsgentry_ownershipstruct", (Object)proposal.getString("ownershipstructure"));
            }
            if (proposal.getBigDecimal("registeredcapital") != null) {
                addNew.set("pmsgentry_registeredcapit", (Object)proposal.getBigDecimal("registeredcapital"));
            }
            if (proposal.getBigDecimal("shareholding") != null) {
                addNew.set("pmsgentry_shareholding", (Object)proposal.getBigDecimal("shareholding"));
            }
            if (proposal.getString("enterpriselevel") != null) {
                addNew.set("pmsgentry_enterpriselevel", (Object)proposal.getString("enterpriselevel"));
            }
            if (proposal.getDynamicObject("projectstatus") != null) {
                addNew.set("pmsgentry_projectstatus", (Object)proposal.getDynamicObject("projectstatus"));
            }
            if (proposal.getBigDecimal("ohpartsamt") != null) {
                addNew.set("pmsgentry_ohpartsamt", (Object)proposal.getBigDecimal("ohpartsamt"));
            }
            if (proposal.getBigDecimal("ohmaterialamt") != null) {
                addNew.set("pmsgentry_ohmaterialamt", (Object)proposal.getBigDecimal("ohmaterialamt"));
            }
            if (proposal.getBigDecimal("ohprocessamt") != null) {
                addNew.set("pmsgentry_ohprocessamt", (Object)proposal.getBigDecimal("ohprocessamt"));
            }
            if (proposal.getBigDecimal("ohoutsourcamt") != null) {
                addNew.set("pmsgentry_ohoutsourcamt", (Object)proposal.getBigDecimal("ohoutsourcamt"));
            }
            if (proposal.getBigDecimal("ohoutpreccamt") != null) {
                addNew.set("pmsgentry_ohoutpreccamt", (Object)proposal.getBigDecimal("ohoutpreccamt"));
            }
            if (proposal.getBigDecimal("ohinprojectamt") != null) {
                addNew.set("pmsgentry_ohinprojectamt", (Object)proposal.getBigDecimal("ohinprojectamt"));
            }
            if (proposal.getBigDecimal("ohvehicleamt") != null) {
                addNew.set("pmsgentry_ohvehicleamt", (Object)proposal.getBigDecimal("ohvehicleamt"));
            }
            if (proposal.getString("ohaddress") != null) {
                addNew.set("pmsgentry_ohaddress", (Object)proposal.getString("ohaddress"));
            }
            if (proposal.getBigDecimal("equipweight") != null) {
                addNew.set("pmsgentry_equipweight", (Object)proposal.getBigDecimal("equipweight"));
            }
            if (proposal.getBigDecimal("ohperiod") != null) {
                addNew.set("pmsgentry_ohperiod", (Object)proposal.getBigDecimal("ohperiod"));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String name = event.getFieldName();
        int rowIndex = event.getRowIndex();
        switch (name) {
            case "pmsgentry_year": {
                this.pmsgEntryYearHyperLink(rowIndex);
                break;
            }
        }
    }

    private void pmsgEntryYearHyperLink(int rowIndex) {
        BigDecimal version = (BigDecimal)this.getModel().getValue("version", rowIndex);
        if (version.compareTo(BigDecimal.ONE) > 0) {
            this.showProjectProposalF7(rowIndex, AddPmsgEntryTypeEnum.ADJUST.getValue(), true);
        } else {
            this.showProjectProposalF7(rowIndex, AddPmsgEntryTypeEnum.RESUBMIT.getValue(), true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "org": {
                if (null == newValue) break;
                DynamicObject declareOrg = (DynamicObject)newValue;
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((Long)((Long)declareOrg.getPkValue())));
                break;
            }
            case "projectkind": {
                this.getModel().deleteEntryData("indexentity");
                DynamicObject projectKind = (DynamicObject)newValue;
                if (projectKind != null) {
                    DynamicObjectCollection settingIndexEntries;
                    QFilter proKindFilter = new QFilter("projectkind", "=", projectKind.getPkValue());
                    DynamicObject projectKindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id,proapplybilltype,proposalctrlapplyamt,applyctrlapprovalamt,budgetauditctrldrawupamt,absolutectrl,projectbugamtctrl,proyearbudgetamtctrl,probudgetctrl,overallctrlyear,projectctrlbudget,investbudgeconamt,outbudgettpl,inbudgettpl,ismajortype,enable,budgetcontrolmode,projectcostcontrol,probilltype,proposalbilltype,entryentity.id,entryentity.fieldname,entryentity.showname,entryentity.fieldtype,entryentity.ismustinput,entryentity.fieldkey,entryentity.assistgroup,spventryentity.id,spventryentity.spvprojectstage,spventryentity.workitem,spventryentity.keyitem,spventryentity.sysbill,spventryentity.keypropconfigid,projectkind,projectstageentry.id,projectstageentry.projectstage,budgetstageentry.id,budgetstageentry.budgetstage,outtreeentryentity.id,outtreeentryentity.outbudgetitem,outtreeentryentity.outbudgetname,intreeentryentity.id,intreeentryentity.inbudgetitem,intreeentryentity.inbudgetname,attachtypeentry.id,attachtypeentry.attachtype,attachtypeentry.necessary,filetypeentry.id,filetypeentry.filetype,filetypeentry.mustrecord,filetypeentry.moreuploads,indexentry.indexname,indexentry.standardindex,indexentry.excellentindex", (QFilter[])new QFilter[]{proKindFilter});
                    if (projectKindControlSetting == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u201c%s\u201d\u8fdb\u884c\u9879\u76ee\u5206\u7c7b\u7ba1\u63a7\u8bbe\u7f6e\uff0c\u518d\u64cd\u4f5c\u3002", (String)"ProjectProposalBillPlugin_37", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), projectKind.getLocaleString("name").getLocaleValue()));
                        this.getModel().beginInit();
                        this.getModel().setValue("projectkind", oldValue);
                        this.getModel().endInit();
                        this.getView().updateView("projectkind");
                        return;
                    }
                    if (!QueryServiceHelper.exists((String)"pmim_projectproposal", (Object)this.getModel().getValue("id"))) {
                        DynamicObject proposalBillType = projectKindControlSetting.getDynamicObject("proposalbilltype");
                        this.getModel().setValue("billtype", (Object)proposalBillType);
                        this.getModel().beginInit();
                        this.getModel().setValue("projectkind", (Object)projectKind);
                        this.getModel().endInit();
                        this.getView().updateView("projectkind");
                    }
                    if ((settingIndexEntries = projectKindControlSetting.getDynamicObjectCollection("indexentry")) == null || settingIndexEntries.size() <= 0) break;
                    for (DynamicObject settingIndexEntry : settingIndexEntries) {
                        int row = this.getModel().createNewEntryRow("indexentity");
                        this.getModel().beginInit();
                        this.getModel().setValue("indexname", settingIndexEntry.get("indexname"), row);
                        this.getModel().setValue("standardindex", (Object)settingIndexEntry.getBigDecimal("standardindex"), row);
                        this.getModel().setValue("excellentindex", settingIndexEntry.get("excellentindex"), row);
                        this.getModel().endInit();
                    }
                    this.getView().updateView("indexentity");
                    break;
                }
                if (QueryServiceHelper.exists((String)"pmim_projectproposal", (Object)this.getModel().getValue("id"))) break;
                this.getModel().setValue("billtype", null);
                break;
            }
            case "indexname": {
                if (null != newValue) {
                    QFilter indexFilter;
                    Object newPK = ((DynamicObject)newValue).getPkValue();
                    DynamicObjectCollection indexEntries = this.getModel().getEntryEntity("indexentity");
                    for (int index = 0; index < indexEntries.size(); ++index) {
                        DynamicObject indexName = ((DynamicObject)indexEntries.get(index)).getDynamicObject("indexname");
                        if (index == rowIndex || indexName == null || !indexName.getPkValue().equals(newPK)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u540d\u7684\u8003\u91cf\u6307\u6807\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ProjectProposalBillPlugin_38", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("indexname", oldValue, rowIndex);
                        return;
                    }
                    DynamicObject projectKind = (DynamicObject)this.getModel().getValue("projectkind");
                    if (projectKind == null) break;
                    QFilter proKindFilter = new QFilter("projectkind", "=", projectKind.getPkValue());
                    DynamicObject projectKindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id,proapplybilltype,proposalctrlapplyamt,applyctrlapprovalamt,budgetauditctrldrawupamt,absolutectrl,projectbugamtctrl,proyearbudgetamtctrl,probudgetctrl,overallctrlyear,projectctrlbudget,investbudgeconamt,outbudgettpl,inbudgettpl,ismajortype,enable,budgetcontrolmode,projectcostcontrol,probilltype,proposalbilltype,entryentity.id,entryentity.fieldname,entryentity.showname,entryentity.fieldtype,entryentity.ismustinput,entryentity.fieldkey,entryentity.assistgroup,spventryentity.id,spventryentity.spvprojectstage,spventryentity.workitem,spventryentity.keyitem,spventryentity.sysbill,spventryentity.keypropconfigid,projectkind,projectstageentry.id,projectstageentry.projectstage,budgetstageentry.id,budgetstageentry.budgetstage,outtreeentryentity.id,outtreeentryentity.outbudgetitem,outtreeentryentity.outbudgetname,intreeentryentity.id,intreeentryentity.inbudgetitem,intreeentryentity.inbudgetname,attachtypeentry.id,attachtypeentry.attachtype,attachtypeentry.necessary,filetypeentry.id,filetypeentry.filetype,filetypeentry.mustrecord,filetypeentry.moreuploads,indexentry.indexname,indexentry.standardindex,indexentry.excellentindex", (QFilter[])new QFilter[]{proKindFilter, indexFilter = new QFilter("indexentry.indexname", "=", newPK)});
                    if (projectKindControlSetting != null) {
                        for (DynamicObject settingIndexEntry : projectKindControlSetting.getDynamicObjectCollection("indexentry")) {
                            if (!settingIndexEntry.getDynamicObject("indexname").getPkValue().equals(((DynamicObject)newValue).getPkValue())) continue;
                            this.getModel().setValue("standardindex", settingIndexEntry.get("standardindex"), rowIndex);
                            this.getModel().setValue("excellentindex", settingIndexEntry.get("excellentindex"), rowIndex);
                            this.getModel().setValue("declarevalue", null, rowIndex);
                        }
                        break;
                    }
                    this.getModel().setValue("standardindex", null, rowIndex);
                    this.getModel().setValue("excellentindex", null, rowIndex);
                    this.getModel().setValue("declarevalue", null, rowIndex);
                    break;
                }
                this.getModel().setValue("standardindex", null, rowIndex);
                this.getModel().setValue("excellentindex", null, rowIndex);
                this.getModel().setValue("declarevalue", null, rowIndex);
                break;
            }
            case "sourceentry_amount": {
                this.autoCalculationScale();
                break;
            }
            case "currententryamt": {
                this.sumToYearBugamt();
                break;
            }
            case "sourceentry_currency": {
                this.autoCalculationScale();
                this.sumToYearBugamt();
                break;
            }
        }
    }

    private void autoCalculationScale() {
        DynamicObject proposal = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = proposal.getDynamicObjectCollection("sourceentry");
        if (entries.size() > 0) {
            BigDecimal exchangeRate;
            DynamicObject currentCur;
            BigDecimal sumEntryAmt = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal amount = entry.getBigDecimal("sourceentry_amount");
                currentCur = entry.getDynamicObject("sourceentry_currency");
                exchangeRate = this.getExchangeRate(currentCur);
                if (exchangeRate != null) {
                    amount = amount.multiply(exchangeRate);
                }
                sumEntryAmt = sumEntryAmt.add(amount);
            }
            this.getModel().setValue("projcetbugamt", (Object)sumEntryAmt);
            for (DynamicObject entry : entries) {
                BigDecimal entryAmt = entry.getBigDecimal("sourceentry_amount");
                currentCur = entry.getDynamicObject("sourceentry_currency");
                exchangeRate = this.getExchangeRate(currentCur);
                BigDecimal scale = BigDecimal.ZERO;
                if (sumEntryAmt.compareTo(BigDecimal.ZERO) > 0) {
                    if (exchangeRate != null) {
                        scale = entryAmt.multiply(exchangeRate).divide(sumEntryAmt, 10, 4).multiply(new BigDecimal(100));
                    }
                    entry.set("sourceentry_scale", (Object)scale);
                    continue;
                }
                entry.set("sourceentry_scale", (Object)scale);
            }
            this.getView().updateView("sourceentry");
        } else {
            this.getModel().setValue("projcetbugamt", null);
        }
    }

    protected void sumToYearBugamt() {
        DynamicObject proposal = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = proposal.getDynamicObjectCollection("sourceentry");
        if (entries.size() > 0) {
            BigDecimal sumEntryAmt = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal amount = entry.getBigDecimal("currententryamt");
                DynamicObject currentCur = entry.getDynamicObject("sourceentry_currency");
                BigDecimal exchangeRate = this.getExchangeRate(currentCur);
                if (exchangeRate != null) {
                    amount = amount.multiply(exchangeRate);
                }
                sumEntryAmt = sumEntryAmt.add(amount);
            }
            this.getModel().setValue("yearbugamt", (Object)sumEntryAmt);
        } else {
            this.getModel().setValue("yearbugamt", null);
        }
    }

    public BigDecimal getExchangeRate(DynamicObject currentCur) {
        DynamicObject billCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject exRateTable = null;
        if (org != null) {
            exRateTable = CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
        }
        if (org != null && billCurrency != null && exRateTable != null && currentCur != null) {
            Long srcCurId = (Long)currentCur.getPkValue();
            Long exRateTableId = (Long)exRateTable.getPkValue();
            BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)srcCurId, (Long)((Long)billCurrency.getPkValue()), (Long)exRateTableId, (Date)new Date());
            if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                exchangeRate = BigDecimal.ONE;
            }
            return exchangeRate;
        }
        return null;
    }
}

