/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.AddPmsgEntryTypeEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmim.business.helper.ProjectProposalHelper;
import kd.pmgt.pmim.formplugin.base.AbstractPmimListPlugin;

public class ProjectProposalListPlugin
extends AbstractPmimListPlugin {
    private static final String KIND_FILTER = "projectkind.name";
    private static final String KIND_ID = "projectkind.id";
    public static final String CTRL_Warehousing_one = "warehousing_one";
    public static final String CTRL_Warehousing_two = "warehousing_two";
    public static final String CTRL_Issue = "issue";
    public static final String CTRL_SUBMIT = "submit";
    public static final String CTRL_UNSUBMIT = "unsubmit";
    public static final String CTRL_UNCANCEL = "uncancel";
    public static final String CTRL_CANCEL = "cancel";
    public static final String CTRL_AUDIT = "audit";
    public static final String CTRL_UNAUDIT = "unaudit";

    public String getAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "importprojectmsg": {
                this.showPJMsgForm(args);
                break;
            }
            case "warehousing_one": 
            case "warehousing_two": {
                QFilter filter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter reportQFilter = new QFilter("reportbudget", "=", (Object)Boolean.FALSE);
                List selectOrgs = this.getControlFilters().getFilter("org.id");
                QFilter orgQFilter = null;
                if (selectOrgs.size() > 0) {
                    List orgIds = selectOrgs.stream().map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                    orgQFilter = new QFilter("org", "in", orgIds);
                }
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)CTRL_Warehousing_one)) {
                    filter.and("reservelevel", "=", (Object)"two");
                } else {
                    filter.and("reservelevel", "=", (Object)"one");
                }
                if (orgQFilter != null) {
                    filter.and(orgQFilter);
                    reportQFilter.and(orgQFilter);
                }
                reportQFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter allQFilter = filter.or(reportQFilter);
                ListShowParameter param = ShowFormHelper.createShowListForm((String)"pmim_proposalbill_f7", (boolean)true);
                param.getListFilterParameter().setFilter(allQFilter);
                param.setMultiSelect(true);
                param.setCustomParam("showproject", (Object)Boolean.FALSE);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
                param.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)param);
                break;
            }
            case "issue": {
                ListSelectedRowCollection modelCol = this.getSelectedRows().getBillListSelectedRowCollection();
                if (modelCol.size() <= 0) break;
                Set<Object> unApprovalIds = new HashSet(16);
                Set<Long> ids = modelCol.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toSet());
                Set<Long> hashApprovalIds = this.getHashApprovalIds(ids);
                if (hashApprovalIds.size() > 0) {
                    for (Long id : ids) {
                        if (!hashApprovalIds.contains(id)) {
                            unApprovalIds.add(id);
                            continue;
                        }
                        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmim_projectproposal", (String)"billno");
                        String billNo = bill.getString("billno");
                        this.getView().showErrorNotification(String.format(ResManager.loadKDStringExt((String)"\u50a8\u5907\u9879\u76ee\u201c%1$s\u201d\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u51fa\u5e93\u3002", (String)"ProjectProposalListPlugin_13", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), billNo));
                    }
                } else {
                    unApprovalIds = ids;
                }
                if (unApprovalIds.size() <= 0) break;
                QFilter qFilter = new QFilter("id", "in", unApprovalIds);
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmim_projectproposal", (String)String.join((CharSequence)",", "reportbudget", "reservelevel", "warehoustime"), (QFilter[])new QFilter[]{qFilter});
                if (bills.length <= 0) break;
                for (DynamicObject bill : bills) {
                    bill.set("reportbudget", (Object)Boolean.FALSE);
                    bill.set("reservelevel", (Object)"two");
                    bill.set("warehoustime", null);
                }
                SaveServiceHelper.update((DynamicObject[])bills);
                if (hashApprovalIds.size() == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51fa\u5e93\u6210\u529f", (String)"ProjectProposalListPlugin_5", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private Set<Long> getHashApprovalIds(Set<Long> ids) {
        HashSet<Long> hashApprovalIds = new HashSet(16);
        QFilter qFilter = new QFilter("proproposal", "in", ids);
        DynamicObject[] proAppBills = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"proproposal", (QFilter[])new QFilter[]{qFilter});
        if (proAppBills.length > 0) {
            hashApprovalIds = Arrays.stream(proAppBills).map(o -> Long.parseLong(o.getDynamicObject("proproposal").getPkValue().toString())).collect(Collectors.toSet());
        }
        qFilter = new QFilter("inventry.projectno", "in", ids);
        DynamicObject[] planBills = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)String.join((CharSequence)",", "inventry", "projectno"), (QFilter[])new QFilter[]{qFilter});
        if (planBills.length > 0) {
            for (DynamicObject planBill : planBills) {
                DynamicObjectCollection entries = planBill.getDynamicObjectCollection("inventry");
                if (entries.size() <= 0) continue;
                Set hashDeclares = entries.stream().map(o -> Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet());
                hashApprovalIds.addAll(hashDeclares);
            }
        }
        return hashApprovalIds;
    }

    private void showPJMsgForm(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection modelCol = this.getSelectedRows().getBillListSelectedRowCollection();
        if (modelCol.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ProjectProposalListPlugin_14", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow model = modelCol.get(0);
        if (!StatusEnum.CHECKED.getValue().equals(model.getBillStatus())) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f53\u524d\u72b6\u6001\u975e\u5ba1\u6279\u72b6\u6001\uff0c\u65e0\u6cd5\u7eed\u62a5\u3002", (String)"ProjectProposalListPlugin_15", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long id = (Long)model.getPrimaryKeyValue();
        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmim_projectproposal");
        if (!ProjectProposalHelper.checkCanDoOperation((IFormView)this.getView(), (DynamicObject)projectProposal, (BeforeDoOperationEventArgs)args, (String)AddPmsgEntryTypeEnum.RESUBMIT.getValue())) {
            return;
        }
        String billId = model.getPrimaryKeyValue().toString();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId("pmim_projectproposal_f7");
        showParameter.setStatus(OperationStatus.ADDNEW);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        DynamicObject currency = projectProposal.getDynamicObject("currency");
        DynamicObject org = projectProposal.getDynamicObject("org");
        if (currency != null) {
            showParameter.setCustomParam("currency", (Object)currency.getPkValue().toString());
        } else if (org.getBoolean("fisaccounting") && (currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()))) != null) {
            showParameter.setCustomParam("currency", (Object)currency.getPkValue().toString());
        }
        showParameter.setCustomParam("pmim_projectproposal", (Object)billId);
        showParameter.setCustomParam("selectRow", (Object)-1);
        showParameter.setCustomParam("type", (Object)AddPmsgEntryTypeEnum.RESUBMIT.getValue());
        showParameter.setCustomParam("modify", (Object)false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "cancel": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.cancelProjectProposal();
                break;
            }
            case "uncancel": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                ListSelectedRowCollection modelCol = this.getSelectedRows().getBillListSelectedRowCollection();
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)modelCol.get(0).getPrimaryKeyValue(), (String)"pmim_projectproposal");
                String bizStatus = bill.getString("bizstatus");
                if (!BizStatusEnum.NORMAL.getValue().equals(bizStatus)) break;
                ProjectProposalHelper.updateCurBillAndDataF7((DynamicObject)bill, (String)operateKey);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!KIND_FILTER.equals(filterColumn.getFieldName())) continue;
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
            DynamicObject[] kinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)"name", (QFilter[])new QFilter[]{enableFilter, leafFilter});
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(kinds.length);
            for (DynamicObject kind : kinds) {
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(kind.getPkValue()));
                item.setCaption(new LocaleString(kind.getString("name")));
                item.setValue(String.valueOf(kind.getPkValue()));
                combos.add(item);
            }
            ((CommonFilterColumn)filterColumn).setComboItems(combos);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "projectkind.id": {
                this.beforeProjectKindSelect(event);
                break;
            }
        }
    }

    private void beforeProjectKindSelect(BeforeFilterF7SelectEvent event) {
        event.setRefEntityId("bd_projectkind");
        event.setRefPropKey("id");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
        event.getQfilters().add(enableFilter);
        event.getQfilters().add(leafFilter);
    }

    private void cancelProjectProposal() {
        Long[] billIds;
        ListSelectedRowCollection modelCol = this.getSelectedRows().getBillListSelectedRowCollection();
        if (modelCol.size() > 1) {
            return;
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelCol.get(0).getPrimaryKeyValue(), (String)"pmim_projectproposal");
        if (!BizStatusEnum.NORMAL.getValue().equals(model.getString("bizstatus")) || !StatusEnum.CHECKED.getValue().equals(model.getString("billstatus"))) {
            return;
        }
        for (DynamicObject pmsgEntry : model.getDynamicObjectCollection("pmsgentry")) {
            Boolean isRefenced = ProjectProposalHelper.checkProjectProposalF7IsRefenced((Object)pmsgEntry.getPkValue());
            boolean isReport = pmsgEntry.getBoolean("pmsg_reportbudget");
            if (!isReport || !isRefenced.booleanValue() && !pmsgEntry.getBoolean("pmsgentry_isquote")) continue;
            return;
        }
        String sourceEntityNumber = model.getDataEntityType().getName();
        Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)sourceEntityNumber, (Long[])(billIds = new Long[]{model.getLong("id")}));
        if (null != targetBillIds && !targetBillIds.isEmpty()) {
            return;
        }
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId("pmim_ppcancelpage");
        showParameter.setStatus(OperationStatus.EDIT);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("pmim_projectproposal", model.getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CTRL_CANCEL));
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        String returnValue = null != args.getReturnData() ? args.getReturnData().toString() : "";
        switch (actionId) {
            case "cancel": {
                if (!"cancelSuccess".equals(returnValue)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f\u3002", (String)"ProjectProposalListPlugin_12", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
            case "warehousing_one": 
            case "warehousing_two": {
                String reserveLevel = StringUtils.equals((CharSequence)actionId, (CharSequence)CTRL_Warehousing_one) ? "one" : "two";
                ListSelectedRowCollection rows = (ListSelectedRowCollection)args.getReturnData();
                if (rows == null || rows.size() <= 0) break;
                Set<Object> unHashApprovalIds = new HashSet(16);
                Set<Long> ids = rows.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toSet());
                Set<Long> hashApprovalIds = this.getHashApprovalIds(ids);
                if (hashApprovalIds.size() > 0) {
                    for (Long id : ids) {
                        if (!hashApprovalIds.contains(id)) {
                            unHashApprovalIds.add(id);
                            continue;
                        }
                        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmim_projectproposal", (String)"billno");
                        String billNo = bill.getString("billno");
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bae\u4e66\u201c%1$s\u201d\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5165\u5e93\u3002", (String)"ProjectProposalListPlugin_16", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), billNo));
                    }
                } else {
                    unHashApprovalIds = ids;
                }
                if (unHashApprovalIds.size() <= 0) break;
                QFilter qFilter = new QFilter("id", "in", unHashApprovalIds);
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmim_projectproposal", (String)String.join((CharSequence)",", "reportbudget", "reservelevel", "warehoustime"), (QFilter[])new QFilter[]{qFilter});
                if (bills.length <= 0) break;
                for (DynamicObject bill : bills) {
                    bill.set("reportbudget", (Object)Boolean.TRUE);
                    bill.set("reservelevel", (Object)reserveLevel);
                    bill.set("warehoustime", (Object)new Date());
                }
                SaveServiceHelper.update((DynamicObject[])bills);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5165\u5e93\u6210\u529f\u3002", (String)"ProjectProposalListPlugin_6", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object billId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String billFormId = billList.getBillFormId();
        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmim_reserveprolib")) {
            args.setCancel(true);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(billId);
            showParameter.setFormId("pmim_projectproposal");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("isView", (Object)true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

