/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.buget;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmim.business.helper.AunualinvesPlanHelper;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class SpecialDeclareInvestBillPlugin
extends AbstractPmimBillPlugin
implements TipsListener {
    public void registerListener(EventObject e) {
        FieldEdit planAmtFieldEdit = (FieldEdit)this.getView().getControl("annualapprovalbudvol");
        planAmtFieldEdit.addTipsListener((TipsListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String ctrlName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (ctrlName) {
            case "year": {
                if (changeData.getNewValue() == null) {
                    this.getModel().setValue("annualapprovalbudvol", (Object)BigDecimal.ZERO);
                    break;
                }
                Date declareDate = (Date)changeData.getNewValue();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                BigDecimal annualApprovalBudVolAmt = new AunualinvesPlanHelper().getAnnualApprovalBudVol(declareYear, org);
                this.getModel().setValue("annualapprovalbudvol", (Object)annualApprovalBudVolAmt);
                break;
            }
            case "investbudamt": 
            case "annualapprovalbudvol": {
                this.updateControlMetadata();
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.updateControlMetadata();
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        int hasPerm;
        DynamicObject bill = this.getModel().getDataEntity(true);
        Date declareDate = bill.getDate("year");
        if (declareDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u5e74\u5ea6\u3002", (String)"SpecialDeclareInvestBillPlugin_0", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject org = bill.getDynamicObject("org");
        Map permObj = ProjectPermissionHelper.getPermObj((String)"pmim_specialdeclarainvest", (String)"new");
        if (permObj != null && org != null && (hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong(org.getPkValue().toString()), (String)"pmim", (String)"pmim_specialdeclarainvest", (String)((String)permObj.get("id")))) != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6295\u8d44\u9884\u7b97\u4e13\u9879\u7533\u62a5\u5355\u7f16\u8f91\u6743\u9650\uff0c\u65e0\u6cd5\u83b7\u53d6\u6b64\u503c\u3002", (String)"SpecialDeclareInvestBillPlugin_2", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        BigDecimal annualApprovalBudVolAmt = BigDecimal.ZERO;
        if (org != null) {
            annualApprovalBudVolAmt = new AunualinvesPlanHelper().getAnnualApprovalBudVol(declareYear, org);
        }
        if (annualApprovalBudVolAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("annualapprovalbudvol", (Object)annualApprovalBudVolAmt);
            this.updateControlMetadata();
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (!StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)billStatus) && annualApprovalBudVolAmt.compareTo(BigDecimal.ZERO) != 0) {
            bill.set("annualapprovalbudvol", (Object)annualApprovalBudVolAmt);
            SaveServiceHelper.update((DynamicObject)bill);
        }
        evt.setCancel(true);
    }

    private void updateControlMetadata() {
        BigDecimal annualStrategicPlanAmt = (BigDecimal)this.getModel().getValue("annualstrategicplanamt");
        if (annualStrategicPlanAmt.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal investBudAmt = (BigDecimal)this.getModel().getValue("investbudamt");
            BigDecimal annualApprovalBudVolAmt = (BigDecimal)this.getModel().getValue("annualapprovalbudvol");
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("fc", annualStrategicPlanAmt.compareTo(investBudAmt.add(annualApprovalBudVolAmt)) < 0 ? "#FF0000" : "#000000");
            this.getView().updateControlMetadata("investbudamt", propMap);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicProperty financialProperty;
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicProperty investProperty = dataEntity.getDynamicObjectType().getProperty("investbudaddamt");
        if (investProperty != null) {
            dataEntity.getDataEntityState().setBizChanged(investProperty.getOrdinal(), false);
        }
        if ((financialProperty = dataEntity.getDynamicObjectType().getProperty("financialexbudaddamt")) != null) {
            dataEntity.getDataEntityState().setBizChanged(financialProperty.getOrdinal(), false);
        }
    }
}

