/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.claim;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmim.common.enums.ClaimTypeEnum;
import kd.pmgt.pmim.common.enums.InvestConclusionEnum;
import kd.pmgt.pmim.common.enums.InvestCycleEnum;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class InvestPlanClaimBillPlugin
extends AbstractPmimBillPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry projectEntry = (CardEntry)this.getControl("projectentry");
        projectEntry.addRowClickListener((RowClickEventListener)this);
        projectEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"projectentry", (CharSequence)control.getKey())) {
            int index = this.getModel().getEntryCurrentRowIndex("projectentry");
            this.getPageCache().put("curModelRow", String.valueOf(index));
            BigDecimal entryInvestAmt = (BigDecimal)this.getModel().getValue("entryinvestamt", index);
            BigDecimal entryCurInvestAmt = (BigDecimal)this.getModel().getValue("entrycurinvestamt", index);
            String entryConclusion = (String)this.getModel().getValue("conclusion", index);
            DynamicObject entrySuporg = (DynamicObject)this.getModel().getValue("suporg", index);
            String entryFinalState = (String)this.getModel().getValue("finalstate", index);
            String entryAuditdesc = (String)this.getModel().getValue("entryauditdesc", index);
            this.getModel().setValue("subinvestamt", (Object)entryInvestAmt);
            this.getModel().setValue("subcurinvestamt", (Object)entryCurInvestAmt);
            this.getModel().setValue("subconclusion", (Object)entryConclusion);
            this.getModel().setValue("subsuporg", (Object)entrySuporg);
            if (StringUtils.isEmpty((CharSequence)entryFinalState)) {
                this.getModel().setValue("subfinalstate", (Object)"auditing");
            } else {
                this.getModel().setValue("subfinalstate", (Object)entryFinalState);
            }
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) && (InvestConclusionEnum.Pass.getValue().equals(entryFinalState) || InvestConclusionEnum.NoPass.getValue().equals(entryFinalState))) {
                this.getModel().setValue("showfinalstate", (Object)entryFinalState, index);
            }
            this.getModel().setValue("auditdesc", (Object)entryAuditdesc);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit yearDate = (DateEdit)this.getControl("yearperiod");
        yearDate.setMustInput(true);
        DateEdit monthDate = (DateEdit)this.getControl("monthperiod");
        monthDate.setMustInput(true);
        FieldEdit subConclusionEdit = (FieldEdit)this.getControl("subconclusion");
        subConclusionEdit.setMustInput(true);
        String investCycle = this.getModel().getValue("investcycle").toString();
        if (InvestCycleEnum.Year.getValue().equals(investCycle)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"yearperiod"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"monthperiod"});
            this.getModel().setValue("monthperiod", null);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"yearperiod"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"monthperiod"});
            this.getModel().setValue("yearperiod", null);
        }
        int rowCount = this.getModel().getEntryRowCount("projectentry");
        if (rowCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"investpanel"});
            this.setHeadFieldLocked(false);
        } else {
            CardEntry projectEntry = (CardEntry)this.getControl("projectentry");
            projectEntry.selectRows(0);
            this.getPageCache().put("curModelRow", String.valueOf(0));
            this.getView().setVisible(Boolean.TRUE, new String[]{"investpanel"});
            this.setHeadFieldLocked(true);
        }
        String subConclusion = (String)this.getModel().getValue("subconclusion");
        if (InvestConclusionEnum.ReportSup.getValue().equals(subConclusion)) {
            BasedataEdit reportSupCtrl = (BasedataEdit)this.getControl("subsuporg");
            reportSupCtrl.setMustInput(true);
        }
    }

    protected void setTotalAmout(String entryField, String totalField) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("investentry");
        BigDecimal sum = new BigDecimal(0);
        if (!entryEntity.isEmpty()) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject exRateTable = null;
            if (org != null) {
                exRateTable = CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
            }
            if (org == null || currency == null || exRateTable == null) {
                EntryGrid grid = (EntryGrid)this.getControl("investentry");
                BigDecimal sumOfNotConsiderCur = grid.getSum(entryField);
                this.getModel().setValue(totalField, (Object)sumOfNotConsiderCur);
                return;
            }
            Long targCurId = (Long)currency.getPkValue();
            Long exRateTableId = (Long)exRateTable.getPkValue();
            for (DynamicObject row : entryEntity) {
                DynamicObject currentCur = row.getDynamicObject("investcurrency");
                BigDecimal currentAmount = row.getBigDecimal(entryField);
                if (currentCur == null || currentAmount == null || currentAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                Long srcCurId = (Long)currentCur.getPkValue();
                BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)srcCurId, (Long)targCurId, (Long)exRateTableId, (Date)new Date());
                if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    exchangeRate = BigDecimal.ONE;
                }
                BigDecimal convertedAmount = currentAmount.multiply(exchangeRate);
                sum = sum.add(convertedAmount);
            }
        }
        this.getModel().setValue(totalField, (Object)sum);
        this.getView().updateView(totalField);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int curModelRow = 0;
        if (this.getPageCache().get("curModelRow") != null) {
            curModelRow = Integer.parseInt(this.getPageCache().get("curModelRow"));
        }
        switch (key) {
            case "investcycle": {
                if (InvestCycleEnum.Year.getValue().equals(propValue.toString())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"yearperiod"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"monthperiod"});
                    this.getModel().setValue("monthperiod", null);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"yearperiod"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"monthperiod"});
                this.getModel().setValue("yearperiod", null);
                break;
            }
            case "entryamt": {
                this.setTotalAmout("entryamt", "subinvestamt");
                break;
            }
            case "currententryamt": {
                this.setTotalAmout("currententryamt", "subcurinvestamt");
                break;
            }
            case "investcurrency": {
                this.setTotalAmout("entryamt", "subinvestamt");
                this.setTotalAmout("currententryamt", "subcurinvestamt");
                break;
            }
            case "subinvestamt": {
                this.getModel().setValue("entryinvestamt", propValue, curModelRow);
                this.sumHeadAmount(true, false);
                break;
            }
            case "subcurinvestamt": {
                this.getModel().setValue("entrycurinvestamt", propValue, curModelRow);
                this.sumHeadAmount(false, true);
                break;
            }
            case "subconclusion": {
                this.getModel().setValue("conclusion", propValue, curModelRow);
                this.sumHeadAmount(true, true);
                if (InvestConclusionEnum.Pass.getValue().equals(propValue)) {
                    this.getModel().setValue("subfinalstate", (Object)InvestConclusionEnum.Pass.getValue(), curModelRow);
                    this.getModel().setValue("showfinalstate", (Object)InvestConclusionEnum.Pass.getValue(), curModelRow);
                    this.getModel().setValue("finalstate", (Object)InvestConclusionEnum.Pass.getValue(), curModelRow);
                    this.getModel().setValue("subsuporg", null, curModelRow);
                    break;
                }
                if (InvestConclusionEnum.NoPass.getValue().equals(propValue)) {
                    this.getModel().setValue("subfinalstate", (Object)InvestConclusionEnum.NoPass.getValue(), curModelRow);
                    this.getModel().setValue("showfinalstate", (Object)InvestConclusionEnum.NoPass.getValue(), curModelRow);
                    this.getModel().setValue("finalstate", (Object)InvestConclusionEnum.NoPass.getValue(), curModelRow);
                    this.getModel().setValue("subsuporg", null, curModelRow);
                    break;
                }
                String entryFinalState = (String)this.getModel().getValue("finalstate", curModelRow);
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) && (InvestConclusionEnum.Pass.getValue().equals(entryFinalState) || InvestConclusionEnum.NoPass.getValue().equals(entryFinalState))) {
                    this.getModel().setValue("showfinalstate", (Object)entryFinalState, curModelRow);
                    break;
                }
                this.getModel().setValue("subfinalstate", (Object)"auditing", curModelRow);
                this.getModel().setValue("showfinalstate", null, curModelRow);
                this.getModel().setValue("finalstate", (Object)"auditing", curModelRow);
                BasedataEdit reportSupCtrl = (BasedataEdit)this.getControl("subsuporg");
                reportSupCtrl.setMustInput(true);
                this.setReportOrg(curModelRow);
                break;
            }
            case "subsuporg": {
                this.getModel().setValue("suporg", propValue, curModelRow);
                break;
            }
            case "auditdesc": {
                this.getModel().setValue("entryauditdesc", propValue, curModelRow);
                break;
            }
        }
    }

    private void setReportOrg(int curModelRow) {
        QFilter billFilter = new QFilter("billcode.number", "=", (Object)"pmim_investplanclaim");
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject reqOrgConf = BusinessDataServiceHelper.loadSingle((String)"pmbs_reqorgconf", (String)"billcode,entryentity,reportorg,declarateorg,enable,projectkind", (QFilter[])new QFilter[]{billFilter, enableFilter});
        if (reqOrgConf == null) {
            return;
        }
        DynamicObjectCollection entryEntity = reqOrgConf.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (org != null) {
            DynamicObject reportOrg;
            DynamicObject kind;
            for (kind = project.getDynamicObject("group"); kind != null; kind = kind.getDynamicObject("parent")) {
                reportOrg = this.getReportOrg(org, kind, entryEntity);
                if (reportOrg != null) {
                    this.getModel().setValue("subsuporg", (Object)reportOrg, curModelRow);
                    break;
                }
                kind = BusinessDataServiceHelper.loadSingle((Object)kind.getPkValue(), (String)"bd_projectkind");
            }
            if (kind == null) {
                reportOrg = this.getReportOrg(org, kind, entryEntity);
                this.getModel().setValue("subsuporg", (Object)reportOrg, curModelRow);
            }
        }
    }

    private DynamicObject getReportOrg(DynamicObject org, DynamicObject kind, DynamicObjectCollection entryEntity) {
        for (DynamicObject entryRow : entryEntity) {
            DynamicObject projectKind = entryRow.getDynamicObject("projectkind");
            if (kind != null ? projectKind == null || !StringUtils.equals((CharSequence)projectKind.getPkValue().toString(), (CharSequence)kind.getPkValue().toString()) : projectKind != null) continue;
            DynamicObjectCollection declarateOrgList = entryRow.getDynamicObjectCollection("declarateorg");
            for (DynamicObject declarateOrg : declarateOrgList) {
                if (!declarateOrg.getDynamicObject("fbasedataid").getPkValue().equals(org.getPkValue())) continue;
                DynamicObject reportOrg = entryRow.getDynamicObject("reportorg");
                return reportOrg;
            }
        }
        return null;
    }

    private void sumHeadAmount(boolean isSumInvest, boolean isSumCurInvest) {
        DynamicObjectCollection projectEntryCol = this.getModel().getEntryEntity("projectentry");
        if (isSumInvest) {
            double investamt = projectEntryCol.stream().mapToDouble(obj -> {
                String conclusion = obj.getString("conclusion");
                BigDecimal entryInvestAmt = obj.getBigDecimal("entryinvestamt");
                if (InvestConclusionEnum.Pass.getValue().equals(conclusion) || InvestConclusionEnum.ReportSup.getValue().equals(conclusion)) {
                    return entryInvestAmt.doubleValue();
                }
                return 0.0;
            }).sum();
            this.getModel().setValue("investamt", (Object)investamt);
        }
        if (isSumCurInvest) {
            double currentinvestamt = projectEntryCol.stream().mapToDouble(obj -> {
                String conclusion = obj.getString("conclusion");
                BigDecimal entryCurInvestAmt = obj.getBigDecimal("entrycurinvestamt");
                if (InvestConclusionEnum.Pass.getValue().equals(conclusion) || InvestConclusionEnum.ReportSup.getValue().equals(conclusion)) {
                    return entryCurInvestAmt.doubleValue();
                }
                return 0.0;
            }).sum();
            this.getModel().setValue("currentinvestamt", (Object)currentinvestamt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeDoSaveAndSubmit(e);
                break;
            }
            case "deleteinvestentry": {
                this.beforeDeleteInvestEntry(e);
                break;
            }
            case "deleteproentry": {
                this.beforeDeleteProEntry();
                break;
            }
        }
    }

    private void beforeDeleteProEntry() {
        CardEntry projectEntry = (CardEntry)this.getControl("projectentry");
        int[] proEntrySelRows = projectEntry.getSelectRows();
        if (proEntrySelRows.length > 0) {
            int selRow = proEntrySelRows[0];
            String claimType = (String)this.getModel().getValue("claimtype");
            if (ClaimTypeEnum.AdjustInvest.getValue().equals(claimType) || ClaimTypeEnum.ContinueInvest.getValue().equals(claimType)) {
                String preEntryId = (String)this.getModel().getValue("preentryid", selRow);
                DynamicObject preEntryObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(preEntryId), (String)"pmim_invesclaimtrecord");
                preEntryObj.set("islatest", (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{preEntryObj});
            }
        }
    }

    private void beforeDeleteInvestEntry(BeforeDoOperationEventArgs e) {
        CardEntry projectEntry = (CardEntry)this.getControl("projectentry");
        int[] proEntrySelRows = projectEntry.getSelectRows();
        EntryGrid investEntry = (EntryGrid)this.getControl("investentry");
        int[] investEntrySelRows = investEntry.getSelectRows();
        if (proEntrySelRows.length > 0) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project", proEntrySelRows[0]);
            for (int investEntrySelRow : investEntrySelRows) {
                boolean isadd = (Boolean)this.getModel().getValue("isadd", investEntrySelRow);
                if (!isadd) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u643a\u5e26\u7684\u6295\u8d44\u8be6\u60c5\u8bb0\u5f55%s\u53ea\u80fd\u4fee\u6539\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InvestPlanClaimBillPlugin_5", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), project.getString("name"));
                this.getView().showTipNotification(tipMsg);
                e.setCancel(true);
            }
        }
    }

    private void beforeDoSaveAndSubmit(BeforeDoOperationEventArgs e) {
        SimpleDateFormat sdf;
        Date investPeriod;
        DynamicObject investPlanType = (DynamicObject)this.getModel().getValue("investplantype");
        DynamicObject claimPerson = (DynamicObject)this.getModel().getValue("claimperson");
        DynamicObject claimOrg = (DynamicObject)this.getModel().getValue("org");
        String investCyle = (String)this.getModel().getValue("investcycle");
        Date claimDate = (Date)this.getModel().getValue("claimdate");
        String investPeriodStr = null;
        if (InvestCycleEnum.Year.getValue().equals(investCyle)) {
            investPeriod = (Date)this.getModel().getValue("yearperiod");
            sdf = new SimpleDateFormat("yyyy", Locale.getDefault());
            if (investPeriod != null) {
                investPeriodStr = sdf.format(investPeriod);
            }
        } else {
            investPeriod = (Date)this.getModel().getValue("monthperiod");
            sdf = new SimpleDateFormat("yyyy-MM", Locale.getDefault());
            if (investPeriod != null) {
                investPeriodStr = sdf.format(investPeriod);
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("projectentry");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int rowCount = entryEntity.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject supOrg;
            this.getModel().setValue("entryinvesttype", (Object)investPlanType, i);
            this.getModel().setValue("entryinvestcycle", (Object)investCyle, i);
            this.getModel().setValue("entryinvestperiod", (Object)investPeriodStr, i);
            this.getModel().setValue("isvalid", (Object)Boolean.FALSE, i);
            this.getModel().setValue("entrycurrency", (Object)currency, i);
            this.getModel().setValue("specialperson", (Object)claimPerson, i);
            this.getModel().setValue("specialorg", (Object)claimOrg, i);
            this.getModel().setValue("entryclaimdate", (Object)claimDate, i);
            DynamicObject project = ((DynamicObject)entryEntity.get(i)).getDynamicObject("project");
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9879\u76ee\u3002", (String)"InvestPlanClaimBillPlugin_3", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String conclusion = ((DynamicObject)entryEntity.get(i)).getString("conclusion");
            if (InvestConclusionEnum.ReportSup.getValue().equals(conclusion) && (supOrg = ((DynamicObject)entryEntity.get(i)).getDynamicObject("suporg")) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u201c%1$s\u201d\u7684\u4e13\u9879\u5ba1\u6279\u7ec4\u7ec7\u3002", (String)"InvestPlanClaimBillPlugin_6", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), project.getString("number")));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("projectnum", (Object)project.getString("number"), i);
            this.getModel().setValue("projectname", (Object)project.getString("name"), i);
        }
        this.getModel().setValue("periodstr", (Object)investPeriodStr);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "newinvest": {
                this.newInvest();
                break;
            }
            case "adjustinvest": {
                this.adjustInvest();
                break;
            }
            case "continueinvest": {
                this.continueInvest();
                break;
            }
            case "deleteproentry": {
                int rowCount = this.getModel().getEntryRowCount("projectentry");
                if (rowCount == 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"investpanel"});
                    this.setHeadFieldLocked(false);
                    this.getModel().beginInit();
                    this.getModel().setValue("subinvestamt", null);
                    this.getModel().setValue("subcurinvestamt", null);
                    this.getModel().endInit();
                }
                this.sumHeadAmount(true, true);
                break;
            }
            case "deleteinvestentry": {
                this.setTotalAmout("entryamt", "subinvestamt");
                this.setTotalAmout("currententryamt", "subcurinvestamt");
                break;
            }
            case "delete": {
                if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) break;
                this.getView().close();
                break;
            }
        }
    }

    private void continueInvest() {
        String investPeriodStr = this.checkInputAndCycle();
        if (investPeriodStr == null) {
            return;
        }
        String investCycle = (String)this.getModel().getValue("investcycle");
        Set<String> proIdSet = this.getPermedProIdSet(ClaimTypeEnum.ContinueInvest.getValue());
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"pmim_invesclaimtrecord", (boolean)true);
        param.setShowUsed(true);
        param.setShowApproved(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ClaimTypeEnum.ContinueInvest.getValue()));
        QFilter investCycleFilter = new QFilter("entryinvestcycle", "=", (Object)investCycle);
        QFilter investPeriodFilter = new QFilter("entryinvestperiod", "<", (Object)investPeriodStr);
        QFilter finalStateFilter = new QFilter("finalstate", "=", (Object)"pass");
        QFilter validFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)Boolean.TRUE);
        ArrayList<Long> recordIdList = new ArrayList<Long>();
        for (String proId : proIdSet) {
            QFilter proIdFilter = new QFilter("project", "=", (Object)Long.parseLong(proId));
            DynamicObject[] claimRecord = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"id", (QFilter[])new QFilter[]{proIdFilter, investCycleFilter, investPeriodFilter, finalStateFilter, validFilter, isLatestFilter}, (String)"entryinvestperiod desc");
            if (claimRecord.length <= 0) continue;
            recordIdList.add(claimRecord[0].getLong("id"));
        }
        param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", recordIdList));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ClaimTypeEnum.ContinueInvest.getValue()));
        this.getView().showForm((FormShowParameter)param);
    }

    private void adjustInvest() {
        String investPeriodStr = this.checkInputAndCycle();
        if (investPeriodStr == null) {
            return;
        }
        String investCycle = (String)this.getModel().getValue("investcycle");
        Set<String> proIdSet = this.getPermedProIdSet(ClaimTypeEnum.AdjustInvest.getValue());
        Long[] proIdArr = proIdSet.stream().map(Long::parseLong).collect(Collectors.toList()).toArray(new Long[0]);
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"pmim_invesclaimtrecord", (boolean)true);
        param.setShowUsed(true);
        param.setShowApproved(true);
        QFilter proFilter = new QFilter("project.id", "in", (Object)proIdArr);
        QFilter validFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
        QFilter finalStateFilter = new QFilter("finalstate", "=", (Object)InvestConclusionEnum.Pass.getValue());
        QFilter investCycleFilter = new QFilter("entryinvestcycle", "=", (Object)investCycle);
        QFilter investPeriodFilter = new QFilter("entryinvestperiod", "=", (Object)investPeriodStr);
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)Boolean.TRUE);
        List filterList = param.getListFilterParameter().getQFilters();
        filterList.add(proFilter);
        filterList.add(validFilter);
        filterList.add(finalStateFilter);
        filterList.add(investCycleFilter);
        filterList.add(investPeriodFilter);
        filterList.add(isLatestFilter);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ClaimTypeEnum.AdjustInvest.getValue()));
        this.getView().showForm((FormShowParameter)param);
    }

    private void newInvest() {
        String investPeriodStr = this.checkInputAndCycle();
        if (investPeriodStr == null) {
            return;
        }
        Set<String> proIdSet = this.getPermedProIdSet(ClaimTypeEnum.NewInvest.getValue());
        Long[] proIdArr = proIdSet.stream().map(Long::parseLong).collect(Collectors.toList()).toArray(new Long[0]);
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)true);
        param.setShowUsed(true);
        param.setShowApproved(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ClaimTypeEnum.NewInvest.getValue()));
        QFilter filter = new QFilter("id", "in", (Object)proIdArr);
        param.getListFilterParameter().getQFilters().add(filter);
        this.getView().showForm((FormShowParameter)param);
    }

    private String checkInputAndCycle() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u7ec4\u7ec7\u3002", (String)"InvestPlanClaimBillPlugin_7", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return null;
        }
        String investCycle = (String)this.getModel().getValue("investcycle");
        String investPeriodStr = null;
        if (InvestCycleEnum.Year.getValue().equals(investCycle)) {
            Date investPeriod = (Date)this.getModel().getValue("yearperiod");
            if (investPeriod != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy", Locale.getDefault());
                investPeriodStr = sdf.format(investPeriod);
            }
        } else {
            Date investPeriod = (Date)this.getModel().getValue("monthperiod");
            if (investPeriod != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM", Locale.getDefault());
                investPeriodStr = sdf.format(investPeriod);
            }
        }
        if (investPeriodStr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u8d44\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvestPlanClaimBillPlugin_2", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return null;
        }
        return investPeriodStr;
    }

    private Set<String> getPermedProIdSet(String type) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<String> excludeStatusIds = new ArrayList<String>();
        excludeStatusIds.add(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
        excludeStatusIds.add(ProjectStatusEnum.SUSPEND.getId());
        excludeStatusIds.add(ProjectStatusEnum.QUIT.getId());
        DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatusAndOrg((Long)((Long)org.getPkValue()), (boolean)true, (String)"pmas_pro_approval", (String)"view", (String[])excludeStatusIds.toArray(new String[0]));
        HashSet<String> proIdSet = new HashSet<String>(16);
        for (DynamicObject project : projects) {
            proIdSet.add(project.getString("id"));
        }
        int rowCount = this.getModel().getEntryRowCount("projectentry");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project", i);
            if (project == null) continue;
            proIdSet.remove(project.getString("id"));
        }
        ArrayList<String> removedIds = new ArrayList<String>();
        for (String proId : proIdSet) {
            QFilter proFilter = new QFilter("project.id", "=", (Object)Long.valueOf(proId));
            QFilter stageFilter = new QFilter("projectstage", "=", (Object)Long.valueOf(ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S.getId()));
            QFilter statusFilter = new QFilter("projectstatus.number", "!=", (Object)"PASS_S");
            DynamicObject[] proStatusArr = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project,projectstage,projectstatus", (QFilter[])new QFilter[]{proFilter, stageFilter, statusFilter});
            if (proStatusArr.length <= 0) continue;
            removedIds.add(proId);
        }
        for (String rmId : removedIds) {
            proIdSet.remove(rmId);
        }
        switch (type) {
            case "newinvest": {
                DynamicObject[] usedEntrys;
                Object curBillPK = this.getModel().getDataEntity().getPkValue();
                QFilter excludedbillFilter = new QFilter("billId", "!=", curBillPK);
                for (DynamicObject entry : usedEntrys = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"project", (QFilter[])new QFilter[]{excludedbillFilter})) {
                    if (proIdSet.size() <= 0) continue;
                    proIdSet.remove(entry.getDynamicObject("project").getString("id"));
                }
                break;
            }
        }
        return proIdSet;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "newinvest": {
                ListSelectedRowCollection col = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.newInvestEntry(col);
                break;
            }
            case "adjustinvest": {
                ListSelectedRowCollection col = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.addInvestEntry(col, ClaimTypeEnum.AdjustInvest.getValue());
                break;
            }
            case "continueinvest": {
                ListSelectedRowCollection col = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.addInvestEntry(col, ClaimTypeEnum.ContinueInvest.getValue());
                break;
            }
        }
    }

    private void newInvestEntry(ListSelectedRowCollection col) {
        ORM orm = ORM.create();
        DynamicObjectType projectEntryDT = this.getModel().getDataEntity().getDynamicObjectCollection("projectentry").getDynamicObjectType();
        long[] rowIds = orm.genLongIds((IDataEntityType)projectEntryDT, col.size());
        for (int i = 0; i < col.size(); ++i) {
            ListSelectedRow row = col.get(i);
            Object projectPkId = row.getPrimaryKeyValue();
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectPkId, (String)"bd_project");
            DynamicObjectCollection projectEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("projectentry");
            DynamicObject projectEntryObj = projectEntries.addNew();
            projectEntryObj.set("id", (Object)rowIds[i]);
            projectEntryObj.set("project", (Object)project);
            projectEntryObj.set("claimtype", (Object)ClaimTypeEnum.NewInvest.getValue());
            projectEntryObj.set("sourceentryid", (Object)rowIds[i]);
            projectEntryObj.set("projectname", (Object)project.getString("name"));
            projectEntryObj.set("projectnum", (Object)project.getString("number"));
            int index = projectEntries.size() - 1;
            this.getView().updateView("projectentry", index);
            this.getModel().updateCache();
            CardEntry projectEntryCtl = (CardEntry)this.getControl("projectentry");
            projectEntryCtl.selectRows(index);
            this.getPageCache().put("curModelRow", String.valueOf(index));
            projectEntryObj = this.getModel().getEntryRowEntity("projectentry", index);
            DynamicObjectCollection subAttachEntryCol = projectEntryObj.getDynamicObjectCollection("attchentry");
            if (subAttachEntryCol.size() == 0) {
                DynamicObject subAttachEntryObj = new DynamicObject(subAttachEntryCol.getDynamicObjectType());
                subAttachEntryObj.set("attchtext", (Object)"text");
                subAttachEntryCol.add((Object)subAttachEntryObj);
                this.getView().updateView("attchentry");
            }
            QFilter proFilter = new QFilter("project", "=", projectPkId);
            QFilter validFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
            DynamicObject fundSourceObj = BusinessDataServiceHelper.loadSingle((String)"pmas_projfundsource", (String)"id,billno,fundentry.sourcetype,fundentry.formofinvest,fundentry.amount,fundentry.investcurrency,fundentry.scale,fundentry.note", (QFilter[])new QFilter[]{proFilter, validFilter});
            if (fundSourceObj == null) continue;
            DynamicObjectCollection fsEntryOfFund = fundSourceObj.getDynamicObjectCollection("fundentry");
            DynamicObjectCollection fsEntryOfInvest = projectEntryObj.getDynamicObjectCollection("investentry");
            for (DynamicObject fsRowOfFund : fsEntryOfFund) {
                DynamicObject fsRowOfInv = fsEntryOfInvest.addNew();
                fsRowOfInv.set("fundsourcetype", fsRowOfFund.get("sourcetype"));
                fsRowOfInv.set("formofinvest", fsRowOfFund.get("formofinvest"));
                fsRowOfInv.set("entryamt", fsRowOfFund.get("amount"));
                fsRowOfInv.set("investcurrency", fsRowOfFund.get("investcurrency"));
                fsRowOfInv.set("scale", fsRowOfFund.get("scale"));
                fsRowOfInv.set("comment", fsRowOfFund.get("note"));
                fsRowOfInv.set("isadd", (Object)Boolean.TRUE);
            }
            this.getView().updateView("investentry");
            this.setTotalAmout("entryamt", "subinvestamt");
            this.setTotalAmout("currententryamt", "subcurinvestamt");
        }
        if (this.getModel().getEntryRowCount("projectentry") > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"investpanel"});
            this.setHeadFieldLocked(true);
        }
    }

    private void addInvestEntry(ListSelectedRowCollection col, String type) {
        int rowCount;
        for (ListSelectedRow row : col) {
            DynamicObject source;
            Object projectEntryKey = row.getPrimaryKeyValue();
            DynamicObjectType projectEntryDT = this.getModel().getDataEntity().getDynamicObjectCollection("projectentry").getDynamicObjectType();
            DynamicObject projectEntryRow = BusinessDataServiceHelper.loadSingle((Object)projectEntryKey, (DynamicObjectType)projectEntryDT);
            int index = this.getModel().createNewEntryRow("projectentry");
            DynamicObject project = projectEntryRow.getDynamicObject("project");
            String preEntryId = projectEntryRow.getString("id");
            String sourceEntryId = projectEntryRow.getString("sourceentryid");
            this.getModel().setValue("preentryid", (Object)preEntryId, index);
            this.getModel().setValue("sourceentryid", (Object)sourceEntryId, index);
            this.getModel().setValue("project", (Object)project.getString("id"), index);
            this.getModel().setValue("projectname", (Object)project.getString("name"), index);
            this.getModel().setValue("projectnum", (Object)project.getString("number"), index);
            this.getModel().setValue("claimtype", (Object)type, index);
            this.getModel().updateCache();
            this.getPageCache().put("curModelRow", String.valueOf(index));
            CardEntry projectEntryCtl = (CardEntry)this.getControl("projectentry");
            projectEntryCtl.selectRows(index);
            DynamicObjectCollection oldAttchEntry = projectEntryRow.getDynamicObjectCollection("attchentry");
            DynamicObjectCollection curAttchEntry = this.getModel().getEntryEntity("attchentry");
            DynamicObject curAttchEntryObj = new DynamicObject(curAttchEntry.getDynamicObjectType());
            curAttchEntryObj.set("attchtext", (Object)"text");
            DynamicObjectCollection curAttchCol = curAttchEntryObj.getDynamicObjectCollection("subattachment");
            for (DynamicObject attchRow : oldAttchEntry) {
                DynamicObjectCollection oldAttachCol = attchRow.getDynamicObjectCollection("subattachment");
                for (DynamicObject oldAttch : oldAttachCol) {
                    DynamicObject curAttch = new DynamicObject(oldAttch.getDynamicObjectType());
                    long curAttchId = ORM.create().genLongId((IDataEntityType)oldAttch.getDynamicObjectType());
                    curAttch.set("fpkid", (Object)curAttchId);
                    curAttch.set("fbasedataid", (Object)oldAttch.getDynamicObject("fbasedataid"));
                    curAttchCol.add((Object)curAttch);
                }
                curAttchEntry.add((Object)curAttchEntryObj);
                this.getView().updateView("attchentry");
            }
            DynamicObject projectEntryObj = this.getModel().getEntryRowEntity("projectentry", index);
            DynamicObjectCollection investEntryCol = projectEntryObj.getDynamicObjectCollection("investentry");
            DynamicObjectCollection investEntryOfLoad = projectEntryRow.getDynamicObjectCollection("investentry");
            String period = projectEntryRow.getString("entryinvestperiod");
            String cycle = projectEntryRow.getString("entryinvestcycle");
            if (cycle.equals("monthplan")) {
                period = period.split("-")[0];
            }
            if ((source = this.gainLastVersionSourceData(Long.parseLong(project.getPkValue().toString()), period)) != null) {
                DynamicObjectCollection fundEntry = source.getDynamicObjectCollection("fundentry");
                investEntryCol.clear();
                if (fundEntry != null && fundEntry.size() > 0) {
                    for (DynamicObject entry : fundEntry) {
                        DynamicObject investEntryObj = investEntryCol.addNew();
                        investEntryObj.set("fundsourcetype", entry.get("sourcetype"));
                        investEntryObj.set("entryamt", (Object)entry.getBigDecimal("amount"));
                        investEntryObj.set("isadd", (Object)Boolean.TRUE);
                        investEntryObj.set("formofinvest", entry.get("formofinvest"));
                        investEntryObj.set("investcurrency", entry.get("investcurrency"));
                        investEntryObj.set("scale", entry.get("scale"));
                        investEntryObj.set("comment", entry.get("note"));
                    }
                }
                this.getView().updateView("investentry");
            } else if (investEntryOfLoad != null && investEntryOfLoad.size() > 0) {
                for (DynamicObject investRowOfLoad : investEntryOfLoad) {
                    DynamicObject investEntryObj = investEntryCol.addNew();
                    investEntryObj.set("fundsourcetype", investRowOfLoad.get("fundsourcetype"));
                    investEntryObj.set("entryamt", (Object)investRowOfLoad.getBigDecimal("entryamt"));
                    investEntryObj.set("currententryamt", (Object)investRowOfLoad.getBigDecimal("currententryamt"));
                    investEntryObj.set("isadd", (Object)Boolean.TRUE);
                    investEntryObj.set("formofinvest", investRowOfLoad.get("formofinvest"));
                    investEntryObj.set("investcurrency", investRowOfLoad.get("investcurrency"));
                    investEntryObj.set("scale", investRowOfLoad.get("scale"));
                }
                this.getView().updateView("investentry");
            }
            this.setTotalAmout("entryamt", "subinvestamt");
            this.setTotalAmout("currententryamt", "subcurinvestamt");
        }
        if (this.getModel().getEntryRowCount("projectentry") > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"investpanel"});
            this.setHeadFieldLocked(true);
        }
        if ((rowCount = this.getModel().getEntryRowCount("attchentry")) == 0) {
            this.getModel().createNewEntryRow("attchentry");
        }
    }

    private DynamicObject gainLastVersionSourceData(Long projectId, String year) {
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("YEAR(year)", "=", (Object)Integer.parseInt(year));
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (bill != null) {
            return BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"pmas_projfundsource");
        }
        return null;
    }

    private void setHeadFieldLocked(boolean isLocked) {
        if (isLocked) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"investcycle"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"yearperiod"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"monthperiod"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"investcycle"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"yearperiod"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"monthperiod"});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject item = this.getModel().getEntryRowEntity("projectentry", hyperLinkClickEvent.getRowIndex());
        DynamicObject proObj = item.getDynamicObject("project");
        Object proPk = proObj.getPkValue();
        QFilter proFilter = new QFilter("pro", "=", proPk);
        DynamicObject approveObj = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{proFilter});
        HashMap<String, Object> custormMap = new HashMap<String, Object>();
        if (null != approveObj) {
            custormMap.put("proAppId", approveObj.getPkValue());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", "pmba_projectkanban");
        map.put("customParams", custormMap);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }
}

