/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.screen;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmim.business.helper.InvestScreenService;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class InvestmentScreenShowPlugin
extends AbstractPmimBillPlugin {
    private static final Log logger = LogFactory.getLog(InvestmentScreenShowPlugin.class);
    private InvestScreenService investScreenService = new InvestScreenService();
    private BigDecimal ONE_HUNDRED_DECIMAL = new BigDecimal(100);
    private static String CUSTOM_CONTROL_AP = "customcontrolap";
    private static String VIEW_PERM_ITEM_ID = "47150e89000000ac";
    private static String[] COLUMNKEY = new String[]{"projectkind", "month_1", "month_2", "month_3", "month_4", "month_5", "month_6", "month_7", "month_8", "month_9", "month_10", "month_11", "month_12", "month_13"};
    private String[] header = null;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject requestData;
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"invokeCustomEvent") && (requestData = (JSONObject)JSONObject.parse((String)args)) != null && requestData.get((Object)"content") != null) {
            Long orgId = RequestContext.get().getOrgId();
            DynamicObject currency = CurrencyHelper.getCurrency((Long)orgId);
            if (currency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"InvestmentScreenShowPlugin_1", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject content = JSON.parseObject((String)requestData.get((Object)"content").toString());
            String type = content.getString("type");
            JSONObject requestParams = content.getJSONObject("value");
            JSONObject returnData = new JSONObject();
            switch (type) {
                case "init_data": {
                    this.investScreenService.getInitData(returnData, this.getView());
                    returnData.put("type", (Object)type);
                    this.setCustomControlData(returnData);
                    break;
                }
                case "get_all_data": {
                    this.investScreenService.getAllData(requestParams, returnData, this.getView());
                    returnData.put("type", (Object)type);
                    this.setCustomControlData(returnData);
                    break;
                }
                case "get_reserve_pro_data": {
                    this.investScreenService.getReserveProData(requestParams, returnData);
                    returnData.put("type", (Object)type);
                    this.setCustomControlData(returnData);
                    break;
                }
                case "get_approval_pro_data": {
                    this.investScreenService.getApprovalProData(requestParams, returnData);
                    returnData.put("type", (Object)type);
                    this.setCustomControlData(returnData);
                    break;
                }
                case "get_complete_pro_data": {
                    this.investScreenService.getCompleteProData(requestParams, returnData);
                    returnData.put("type", (Object)type);
                    this.setCustomControlData(returnData);
                    break;
                }
                case "get_invest_data": {
                    this.investScreenService.getInvestData(requestParams, returnData, this.getView());
                    returnData.put("type", (Object)type);
                    this.setCustomControlData(returnData);
                    break;
                }
                case "export_invest_data": {
                    this.investScreenService.exportInvestData(this.getView());
                    break;
                }
            }
        }
    }

    private void setCustomControlData(JSONObject data) {
        CustomControl control = (CustomControl)this.getView().getControl(CUSTOM_CONTROL_AP);
        data.put("UUID", (Object)UUID.randomUUID().toString());
        control.setData((Object)data);
    }
}

