/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.formplugin.tacticinvestplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmim.EffectStatusEnum;
import kd.pmgt.pmbs.common.enums.pmim.IssueStatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmim.business.helper.TacticInvestPlanAmountHelper;
import kd.pmgt.pmim.business.helper.TacticInvestPlanImportHelper;
import kd.pmgt.pmim.formplugin.base.AbstractPmimBillPlugin;

public class TacticInvestPlanEditPlugin
extends AbstractPmimBillPlugin
implements BeforeF7SelectListener,
UploadListener {
    private static final String OP_AFTER_CONFIRM = "afterConfirm";
    private static final String CONFIRM_TOTAL_AMOUNT = "confirmTotalAmount";
    private static final String PARENT_AMOUNT = "parentAmount";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final String PAGE_CACHE_YEAR = "beforeSelectYear";
    private static final String PAGE_CACHE_AMT_UNIT = "beforeSelectYear";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgBaseDataEdit = (BasedataEdit)this.getView().getControl("org");
        orgBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object adjustId = this.getView().getFormShowParameter().getCustomParam("adjustId");
        if (adjustId != null) {
            this.getModel().setValue("id", (Object)ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType()));
            DynamicObject adjust = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmim_tacticinvestplan");
            BigDecimal newVersion = adjust.getBigDecimal("version").add(BigDecimal.ONE).setScale(1, RoundingMode.HALF_UP);
            this.getModel().setValue("org", adjust.get("org"));
            String oldVersion = adjust.getBigDecimal("version").setScale(1, RoundingMode.HALF_UP).toPlainString();
            String oldVersionFlag = String.format("%s%s", "&", oldVersion);
            String newVersionFlag = String.format("%s%s", "&", newVersion);
            String billName = adjust.getString("billname");
            if (billName.contains(oldVersionFlag)) {
                this.getModel().setValue("billname", (Object)billName.replace(oldVersionFlag, newVersionFlag));
            } else {
                this.getModel().setValue("billname", (Object)String.format("%s%s%s", adjust.getString("billname"), "&", newVersion.toPlainString()));
            }
            this.getModel().setValue("version", (Object)newVersion);
            this.getModel().setValue("year", adjust.get("year"));
            this.getModel().setValue("currencyfield", adjust.get("currencyfield"));
            this.getModel().setValue("totalinvestamount", adjust.get("totalinvestamount"));
            this.getModel().setValue("explain", adjust.get("explain"));
            this.getModel().setValue("orglevel", adjust.get("orglevel"));
            this.getModel().setValue("monetaryunit", adjust.get("monetaryunit"));
            DynamicObjectCollection entries = adjust.getDynamicObjectCollection("treeentryentity");
            this.createEntryData(this.getModel().getEntryEntity("treeentryentity"), entries);
            List amountNameList = TacticInvestPlanAmountHelper.getAmountName((DynamicObject)this.getModel().getDataEntity());
            String moneyUnit = this.getModel().getDataEntity().getString("monetaryunit");
            BigDecimal unit = StringUtils.isBlank((String)moneyUnit) ? BigDecimal.ONE : new BigDecimal(moneyUnit);
            TacticInvestPlanAmountHelper.convertMoneyUnit((DynamicObject)this.getModel().getDataEntity(), (BigDecimal)unit, (boolean)false, (List)amountNameList);
            this.getView().updateView("treeentryentity");
            this.getPageCache().put(PARENT_AMOUNT, adjust.get("totalinvestamount").toString());
            String sourceBillFormId = adjust.getDynamicObjectType().toString();
            Object sourceBillId = adjust.getPkValue();
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENT_PANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENT_PANEL);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DateEdit year = (DateEdit)this.getView().getControl("year");
        Date initDate = DateUtil.getYearStartTime((Date)new Date());
        year.setMinDate(DateUtil.getBeforeOrNextYearDate((Date)initDate, (boolean)false, (int)2));
        year.setMaxDate(DateUtil.getYearEndTime((Date)new Date()));
        Date selectYear = (Date)this.getModel().getValue("year");
        if (selectYear != null) {
            this.changeEntryHeaderYear(selectYear);
        }
        this.getModel().setValue("percent", (Object)new BigDecimal("20"));
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        List amountNameList = TacticInvestPlanAmountHelper.getAmountName((DynamicObject)this.getModel().getDataEntity());
        String moneyUnit = this.getModel().getDataEntity().getString("monetaryunit");
        BigDecimal unit = StringUtils.isBlank((String)moneyUnit) ? BigDecimal.ONE : new BigDecimal(moneyUnit);
        TacticInvestPlanAmountHelper.convertMoneyUnit((DynamicObject)this.getModel().getDataEntity(), (BigDecimal)unit, (boolean)false, (List)amountNameList);
        this.getView().updateView("treeentryentity");
    }

    public void afterBindData(EventObject e) {
        BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        if (BillOperationStatus.ADDNEW.getValue() == billShowParameter.getBillStatus().getValue()) {
            this.validateCompile();
        }
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "submit": {
                DynamicObjectCollection submitEntryEntity = this.getModel().getEntryEntity("treeentryentity");
                if (!this.validateMustInput(args, submitEntryEntity)) {
                    return;
                }
                BigDecimal currentSummary = submitEntryEntity.stream().filter(dyn -> dyn.getLong("pid") == 0L).map(dyn -> dyn.getBigDecimal("currentyearamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                long currentOrgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                if (rootOrgId == currentOrgId) {
                    this.getModel().setValue("totalinvestamount", (Object)currentSummary);
                    this.getModel().updateCache();
                    break;
                }
                BigDecimal currentAmount = this.getModel().getDataEntity().getBigDecimal("totalinvestamount");
                int compareFlag = currentSummary.compareTo(currentAmount);
                if (compareFlag == 0) break;
                RefObject afterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(OP_AFTER_CONFIRM, afterConfirm)) break;
                String moneyUnit = this.getModel().getDataEntity().getString("monetaryunit");
                ComboProp comboProp = (ComboProp)this.getModel().getProperty("monetaryunit");
                String displayName = comboProp.getItemByName(moneyUnit);
                if (compareFlag > 0) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5e74\u5ea6\u89c4\u5212\u6295\u8d44\u989d%1$s\u3001%2$s\uff0c\u8d85\u8fc7\u4e0a\u7ea7\u4e0b\u8fbe\u7684\u5e74\u5ea6\u6295\u8d44\u603b\u989d%3$s\u3001%4$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TacticInvestPlanEditPlugin_33", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), this.setAmtScale(currentSummary), displayName, this.setAmtScale(currentAmount), displayName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_TOTAL_AMOUNT, (IFormPlugin)this));
                } else {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5e74\u5ea6\u89c4\u5212\u6295\u8d44\u989d%1$s\u3001%2$s\uff0c\u5c0f\u4e8e\u4e0a\u7ea7\u4e0b\u8fbe\u7684\u5e74\u5ea6\u6295\u8d44\u603b\u989d%3$s\u3001%4$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TacticInvestPlanEditPlugin_34", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), this.setAmtScale(currentSummary), displayName, this.setAmtScale(currentAmount), displayName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_TOTAL_AMOUNT, (IFormPlugin)this));
                }
                args.setCancel(true);
                break;
            }
            case "autoload": {
                if (this.getModel().getValue("year") == null) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e74\u5ea6\u3002", (String)"TacticInvestPlanEditPlugin_35", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    return;
                }
                int entryEntitySize = this.getModel().getEntryEntity("treeentryentity").size();
                if (entryEntitySize > 0) {
                    args.setCancel(true);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u53d6\u6570\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\u91cd\u65b0\u53d6\u6570\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TacticInvestPlanEditPlugin_36", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener("autoload", (IFormPlugin)this));
                } else {
                    DynamicObjectCollection newEntry = this.buildOrgTree();
                    this.getModel().updateEntryCache(newEntry);
                    TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
                    grid.setCollapse(false);
                    this.getView().updateView("treeentryentity");
                    this.autoLoadData();
                    this.convertEntryAmountUnit();
                }
                this.getModel().updateCache();
                this.getView().updateView();
                break;
            }
            case "takeeffect": {
                QFilter effectStatusFilter;
                RefObject afterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(OP_AFTER_CONFIRM, afterConfirm)) {
                    return;
                }
                String billStatus = this.getModel().getDataEntity().getString("billstatus");
                if (!StatusEnum.CHECKED.getValue().equals(billStatus)) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u751f\u6548\u3002", (String)"TacticInvestPlanEditPlugin_37", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    return;
                }
                String effectStatus = this.getModel().getDataEntity().getString("effectivestatus");
                if (!EffectStatusEnum.PENDINGEFFECT.getValue().equals(effectStatus)) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDStringExt((String)"\u5355\u636e\u4f7f\u7528\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u6267\u884c\u751f\u6548\u64cd\u4f5c\u3002", (String)"TacticInvestPlanEditPlugin_5", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), EffectStatusEnum.getEnumByValue((Object)effectStatus).getName()));
                    return;
                }
                long orgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
                Date year = this.getModel().getDataEntity().getDate("year");
                QFilter yearFilter = new QFilter("year", ">=", (Object)DateUtil.getYearStartTime((Date)year)).and(new QFilter("year", "<=", (Object)DateUtil.getYearEndTime((Date)year)));
                DynamicObject[] billList = BusinessDataServiceHelper.load((String)"pmim_tacticinvestplan", (String)"id,org,treeentryentity,treeentryentity.orgfield", (QFilter[])new QFilter[]{yearFilter, effectStatusFilter = new QFilter("effectivestatus", "=", (Object)EffectStatusEnum.USING.getValue())});
                if (billList.length <= 0) break;
                Optional<DynamicObject> optional = Arrays.stream(billList).filter(bill -> bill.getDynamicObject("org").getLong("id") == orgId).findFirst();
                if (optional.isPresent()) {
                    args.setCancel(true);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u751f\u6548\u7248\u672c\uff0c\u662f\u5426\u542f\u7528\u6b64\u7248\u672c\uff1f", (String)"TacticInvestPlanEditPlugin_38", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener("takeeffect", (IFormPlugin)this));
                    break;
                }
                Optional<DynamicObject> optional1 = Arrays.stream(billList).filter(bill -> bill.getLong("treeentryentity.orgfield") == orgId).findFirst();
                if (!optional1.isPresent()) break;
                args.setCancel(true);
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5df2\u5b58\u5728\u4e0a\u7ea7\u4f01\u4e1a\u751f\u6548\u7248\u672c\uff0c\u6b64\u7248\u672c\u4e0d\u53ef\u4f7f\u7528\u3002", (String)"TacticInvestPlanEditPlugin_39", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "unaudit": {
                this.validateIssue(args, formOperate);
                break;
            }
            case "autofill": {
                EntryGrid grid = (EntryGrid)this.getControl("treeentryentity");
                int[] selectRows = grid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8ba1\u7b97\u7684\u4f01\u4e1a\u884c\u3002", (String)"TacticInvestPlanEditPlugin_8", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BigDecimal percent = this.getModel().getDataEntity().getBigDecimal("percent");
                if (percent == null || percent.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u8ba1\u7b97\u767e\u5206\u6bd4\u201d\u3002", (String)"TacticInvestPlanEditPlugin_40", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection entry = this.getModel().getEntryEntity("treeentryentity");
                this.fillInvestAmount(entry, selectRows, percent);
                break;
            }
            case "import": {
                DynamicObjectCollection importEntryEntity = this.getModel().getEntryEntity("treeentryentity");
                if (importEntryEntity.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u81ea\u52a8\u53d6\u6570\u6309\u94ae\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5c42\u7ea7\u3002", (String)"TacticInvestPlanEditPlugin_41", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                TacticInvestPlanImportHelper.importExcel((AbstractBillPlugIn)this, this.getHeader());
            }
        }
    }

    protected boolean validateMustInput(BeforeDoOperationEventArgs args, DynamicObjectCollection submitEntryEntity) {
        if (submitEntryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u83b7\u53d6\u7ec4\u7ec7\u5e76\u89c4\u5212\u6295\u8d44\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"TacticInvestPlanEditPlugin_42", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String billNo = this.getModel().getDataEntity().getString("billno");
        if (StringUtils.isBlank((String)billNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u53f7\u3002", (String)"TacticInvestPlanEditPlugin_10", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String billName = this.getModel().getDataEntity().getString("billname");
        if (StringUtils.isBlank((String)billName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"TacticInvestPlanEditPlugin_11", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        DynamicObject createorg = this.getModel().getDataEntity().getDynamicObject("createorg");
        if (createorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u90e8\u95e8\u3002", (String)"TacticInvestPlanEditPlugin_30", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        for (DynamicObject dynamicObject : submitEntryEntity) {
            BigDecimal currentAmount = dynamicObject.getBigDecimal("currentyearamount", true);
            if ((currentAmount = this.setAmtScale(currentAmount)).compareTo(BigDecimal.ZERO) != 0) continue;
            Date year = this.getModel().getDataEntity().getDate("year");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            String currentYearStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), sdf.format(year));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u6295\u8d44\u89c4\u5212\u989d\u3002", (String)"TacticInvestPlanEditPlugin_43", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), currentYearStr));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.getValidateResult().isSuccess()) {
            switch (key) {
                case "takeeffect": 
                case "issue": 
                case "blockup": 
                case "submit": 
                case "unsubmit": 
                case "audit": 
                case "unaudit": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (result.getValue() == MessageBoxResult.Cancel.getValue()) {
            String yearStr;
            if ("year".equals(callBackId) && (yearStr = this.getPageCache().get("beforeSelectYear")) != null) {
                Date beforeSelectYear;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    beforeSelectYear = format.parse(yearStr);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                this.getModel().beginInit();
                this.getModel().setValue("year", (Object)beforeSelectYear);
                this.getModel().endInit();
                this.getView().updateView("year");
            }
            return;
        }
        switch (callBackId) {
            case "autoload": {
                long currentOrgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                if (rootOrgId == currentOrgId) {
                    this.getModel().setValue("totalinvestamount", null);
                }
                DynamicObjectCollection newEntry = this.buildOrgTree();
                this.getModel().updateEntryCache(newEntry);
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
                grid.setCollapse(false);
                this.getView().updateView("treeentryentity");
                this.autoLoadData();
                this.convertEntryAmountUnit();
                this.getModel().updateCache();
                this.getView().updateView();
                break;
            }
            case "takeeffect": {
                OperateOption takeEffectOperateOption = OperateOption.create();
                takeEffectOperateOption.setVariableValue(OP_AFTER_CONFIRM, "true");
                this.getView().invokeOperation("takeeffect", takeEffectOperateOption);
                break;
            }
            case "unaudit": {
                OperateOption unAuditOperateOption = OperateOption.create();
                unAuditOperateOption.setVariableValue(OP_AFTER_CONFIRM, "true");
                this.getView().invokeOperation("unaudit", unAuditOperateOption);
                break;
            }
            case "confirmTotalAmount": {
                DynamicObjectCollection submitEntryEntity = this.getModel().getEntryEntity("treeentryentity");
                BigDecimal currentSummary = submitEntryEntity.stream().filter(dyn -> dyn.getLong("pid") == 0L).map(dyn -> dyn.getBigDecimal("currentyearamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("totalinvestamount", (Object)currentSummary);
                OperateOption submitOperateOption = OperateOption.create();
                submitOperateOption.setVariableValue(OP_AFTER_CONFIRM, "true");
                this.getView().invokeOperation("submit", submitOperateOption);
                break;
            }
            case "year": {
                Date selectYear = (Date)this.getModel().getValue("year");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
                entryEntity.clear();
                this.getModel().updateEntryCache(entryEntity);
                this.getView().updateView("treeentryentity");
                if (selectYear == null) break;
                this.changeEntryHeaderYear(selectYear);
                this.validateCompile();
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key;
        super.beforePropertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "year": {
                Date beforeSelectYear = this.getModel().getDataEntity().getDate("year");
                if (beforeSelectYear == null) break;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                String formatYear = format.format(beforeSelectYear);
                this.getPageCache().put("beforeSelectYear", formatYear);
                break;
            }
            case "monetaryunit": {
                Integer beforeSelectUnit = this.getModel().getDataEntity().getInt("monetaryunit");
                if (beforeSelectUnit == null) break;
                this.getPageCache().put("beforeSelectYear", beforeSelectUnit.toString());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "year": {
                int entrySize = this.getModel().getEntryEntity("treeentryentity").size();
                if (entrySize > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u52a8\u5e74\u5ea6\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TacticInvestPlanEditPlugin_44", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener("year", (IFormPlugin)this));
                    break;
                }
                Date selectYear = (Date)this.getModel().getValue("year");
                if (selectYear == null) break;
                this.changeEntryHeaderYear(selectYear);
                this.validateCompile();
                break;
            }
            case "org": {
                this.validateCompile();
                break;
            }
            case "monetaryunit": {
                String parentAmountStr = this.getPageCache().get(PARENT_AMOUNT);
                if (StringUtils.isNotEmpty((String)parentAmountStr)) {
                    BigDecimal parentAmount = new BigDecimal(parentAmountStr);
                    String moneyUnitStr = this.getModel().getDataEntity().getString("monetaryunit");
                    BigDecimal moneyUnit = new BigDecimal(moneyUnitStr);
                    BigDecimal newAmount = parentAmount.divide(moneyUnit, RoundingMode.HALF_UP);
                    this.getModel().setValue("totalinvestamount", (Object)newAmount);
                    this.getView().updateView("totalinvestamount");
                }
                String unitStr = this.getPageCache().get("beforeSelectYear");
                BigDecimal beforeUnit = new BigDecimal(unitStr);
                String changeUnitStr = this.getModel().getDataEntity().getString("monetaryunit");
                BigDecimal currentUnit = new BigDecimal(changeUnitStr);
                BigDecimal differ = beforeUnit.divide(currentUnit, 10, RoundingMode.HALF_UP);
                List entryAmountNameList = TacticInvestPlanAmountHelper.getBillEntryAmountName((DynamicObject)this.getModel().getDataEntity());
                DynamicObjectCollection treeEntity = this.getModel().getEntryEntity("treeentryentity");
                if (!treeEntity.isEmpty()) {
                    TacticInvestPlanAmountHelper.convertMoneyUnit((DynamicObject)this.getModel().getDataEntity(), (BigDecimal)differ, (boolean)true, (List)entryAmountNameList);
                }
                this.getModel().updateCache();
                this.getView().updateView("treeentryentity");
                break;
            }
            case "currentyearamount": {
                this.collectInvestAmt("currentyearamount");
                break;
            }
            case "nextyearamount": {
                this.collectInvestAmt("nextyearamount");
                break;
            }
            case "afternextyearamount": {
                this.collectInvestAmt("afternextyearamount");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String name = event.getProperty().getName();
        if ("org".equals(name)) {
            QFilter patternTypeFilter = new QFilter("orgpattern.id", "in", (Object)new Long[]{1L, 2L, 7L, 8L});
            event.addCustomQFilter(patternTypeFilter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicProperty percentProperty = dataEntity.getDynamicObjectType().getProperty("percent");
        dataEntity.getDataEntityState().setBizChanged(percentProperty.getOrdinal(), false);
        DynamicProperty totalAmountProperty = dataEntity.getDynamicObjectType().getProperty("totalinvestamount");
        dataEntity.getDataEntityState().setBizChanged(totalAmountProperty.getOrdinal(), false);
        BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        int billStatus = billShowParameter.getBillStatus().getValue();
        if (billStatus == BillOperationStatus.VIEW.getValue() || billStatus == BillOperationStatus.SUBMIT.getValue() || billStatus == BillOperationStatus.AUDIT.getValue()) {
            e.setCheckDataChange(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("importentry".equals(actionId)) {
            this.uploadEntry(e);
        }
    }

    private void collectInvestAmt(String key) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        if (selectRows.length > 0) {
            this.updateParentAmt((DynamicObject)entryEntity.get(selectRows[0]), entryEntity, key);
        }
    }

    private void updateParentAmt(DynamicObject row, DynamicObjectCollection treeEntryEntity, String investAmtName) {
        long pid = row.getLong("pid");
        if (pid == 0L) {
            this.getView().updateView("treeentryentity");
            return;
        }
        Optional<DynamicObject> optional = treeEntryEntity.stream().filter(dyn -> dyn.getLong("id") == pid).findFirst();
        if (optional.isPresent()) {
            DynamicObject parent = optional.get();
            BigDecimal childSummary = treeEntryEntity.stream().filter(dyn -> dyn.getLong("pid") == parent.getLong("id")).map(dyn -> dyn.getBigDecimal(investAmtName)).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().beginInit();
            parent.set(investAmtName, (Object)childSummary);
            this.getModel().endInit();
            this.updateParentAmt(parent, treeEntryEntity, investAmtName);
        }
    }

    private void validateIssue(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        String issueStatus = this.getModel().getDataEntity().getString("issuestatus");
        if (IssueStatusEnum.ISSUED.getValue().equals(issueStatus)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5355\u636e\u6570\u636e\u5df2\u4e0b\u53d1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"TacticInvestPlanEditPlugin_13", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
        List orgIdList = collection.stream().map(dyn -> dyn.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        QFilter unauditOrgFilter = new QFilter("org", "in", orgIdList);
        QFilter effectFilter = new QFilter("effectivestatus", "=", (Object)EffectStatusEnum.USING.getValue());
        DynamicObject[] billList = BusinessDataServiceHelper.load((String)"pmim_tacticinvestplan", (String)"org", (QFilter[])new QFilter[]{unauditOrgFilter, effectFilter});
        if (billList.length > 0) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4e0b\u7ea7\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TacticInvestPlanEditPlugin_45", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        }
        String unAuditEffectStatus = this.getModel().getDataEntity().getString("effectivestatus");
        if (EffectStatusEnum.USING.getValue().equals(unAuditEffectStatus)) {
            RefObject afterConfirm = new RefObject();
            if (!formOperate.getOption().tryGetVariableValue(OP_AFTER_CONFIRM, afterConfirm)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u6570\u636e\u5df2\u4f7f\u7528\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5ba1\u6838\uff1f", (String)"TacticInvestPlanEditPlugin_46", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener("unaudit", (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    private void changeEntryHeaderYear(Date selectDate) {
        EntryGrid grid = (EntryGrid)this.getControl("treeentryentity");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date beforeLastYear = DateUtil.getBeforeOrNextYearDate((Date)selectDate, (boolean)false, (int)2);
        String beforeLastYearFormat = sdf.format(beforeLastYear);
        this.updateHeaderLocale(grid, "beforelastyeargroupap", beforeLastYearFormat);
        Date lastYear = DateUtil.getBeforeOrNextYearDate((Date)selectDate, (boolean)false, (int)1);
        String lastYearFormat = sdf.format(lastYear);
        this.updateHeaderLocale(grid, "lastyeargroupap", lastYearFormat);
        String currentYearFormat = sdf.format(selectDate);
        this.updateHeaderLocale(grid, "currentyearamount", currentYearFormat);
        Date nextYear = DateUtil.getBeforeOrNextYearDate((Date)selectDate, (boolean)true, (int)1);
        String nextYearFormat = sdf.format(nextYear);
        this.updateHeaderLocale(grid, "nextyearamount", nextYearFormat);
        Date afterNextYear = DateUtil.getBeforeOrNextYearDate((Date)selectDate, (boolean)true, (int)2);
        String afterNextYearFormat = sdf.format(afterNextYear);
        this.updateHeaderLocale(grid, "afternextyearamount", afterNextYearFormat);
        this.getView().updateView("treeentryentity");
    }

    private void updateHeaderLocale(EntryGrid grid, String metadataId, String yearFormat) {
        String year = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), yearFormat);
        grid.setColumnProperty(metadataId, "header", (Object)year);
    }

    private void autoLoadData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        List<Long> orgIdList = entryEntity.stream().map(dyn -> dyn.getDynamicObject("orgfield").getLong("id")).collect(Collectors.toList());
        Date selectYear = (Date)this.getModel().getValue("year");
        this.fillBeforeInvestAmount(entryEntity, selectYear, orgIdList);
        QFilter orgFilter = new QFilter("treeentryentity.orgfield", "in", orgIdList);
        QFilter yearFilter = new QFilter("year", "<=", (Object)DateUtil.getYearEndTime((Date)selectYear));
        QFilter effectStatusFilter = new QFilter("effectivestatus", "=", (Object)EffectStatusEnum.USING.getValue());
        DynamicObject[] billList = BusinessDataServiceHelper.load((String)"pmim_tacticinvestplan", (String)"monetaryunit,year,treeentryentity,treeentryentity.orgfield,treeentryentity.totalamount,treeentryentity.registeramount,treeentryentity.currentyearamount,treeentryentity.nextyearamount,treeentryentity.afternextyearamount", (QFilter[])new QFilter[]{orgFilter, yearFilter, effectStatusFilter});
        ArrayList orgCompileList = new ArrayList();
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject dyn2 : entry) {
                long id = dyn2.getDynamicObject("orgfield").getLong("id");
                if (!orgIdList.contains(id)) continue;
                Optional<Map> optional = orgCompileList.stream().filter(map -> Long.parseLong(map.get("orgId").toString()) == id).findFirst();
                if (optional.isPresent()) {
                    Map oldMap = optional.get();
                    Date oldYear = (Date)oldMap.get("year");
                    Date newYear = bill.getDate("year");
                    if (newYear.compareTo(oldYear) <= 0) continue;
                    oldMap.put("entity", dyn2);
                    oldMap.put("year", newYear);
                    continue;
                }
                HashMap<String, Comparable<Long>> orgCompileMap = new HashMap<String, Comparable<Long>>(16);
                orgCompileMap.put("orgId", Long.valueOf(id));
                orgCompileMap.put("entity", (Comparable<Long>)dyn2);
                orgCompileMap.put("year", bill.getDate("year"));
                orgCompileList.add(orgCompileMap);
            }
        }
        for (DynamicObject entity : entryEntity) {
            long orgId = entity.getDynamicObject("orgfield").getLong("id");
            Optional<Map> optional = orgCompileList.stream().filter(map -> Long.parseLong(map.get("orgId").toString()) == orgId).findFirst();
            if (!optional.isPresent()) continue;
            Map map2 = optional.get();
            Date year = (Date)map2.get("year");
            DynamicObject entityData = (DynamicObject)map2.get("entity");
            entity.set("totalamount", entityData.get("totalamount"));
            entity.set("registeramount", entityData.get("registeramount"));
            int diff = DateUtil.calculateDifferYear((Date)selectYear, (Date)year);
            if (diff == 0) {
                entity.set("currentyearamount", entityData.get("currentyearamount"));
                entity.set("nextyearamount", entityData.get("nextyearamount"));
                entity.set("afternextyearamount", entityData.get("afternextyearamount"));
                continue;
            }
            if (diff == 1) {
                entity.set("currentyearamount", entityData.get("nextyearamount"));
                entity.set("nextyearamount", entityData.get("afternextyearamount"));
                continue;
            }
            if (diff != 2) continue;
            entity.set("currentyearamount", entityData.get("afternextyearamount"));
        }
    }

    private void convertEntryAmountUnit() {
        List entryAmountNameList = TacticInvestPlanAmountHelper.getBillEntryAmountName((DynamicObject)this.getModel().getDataEntity());
        String moneyUnit = this.getModel().getDataEntity().getString("monetaryunit");
        BigDecimal unit = StringUtils.isBlank((String)moneyUnit) ? BigDecimal.ONE : new BigDecimal(moneyUnit);
        TacticInvestPlanAmountHelper.convertMoneyUnit((DynamicObject)this.getModel().getDataEntity(), (BigDecimal)unit, (boolean)false, (List)entryAmountNameList);
    }

    private void fillBeforeInvestAmount(DynamicObjectCollection entryEntity, Date year, List<Long> orgIdList) {
        Date beforeLastYear = DateUtil.getBeforeOrNextYearDate((Date)year, (boolean)false, (int)2);
        Map<Long, BigDecimal> beforeLastYearCostSplit = this.getCostSplit(beforeLastYear, orgIdList);
        Map<Long, BigDecimal> beforeLastYearPayRegister = this.getPayRegister(beforeLastYear, orgIdList);
        HashMap<Long, BigDecimal> beforeLastYearAmountMap = new HashMap<Long, BigDecimal>(16);
        for (Long id : orgIdList) {
            BigDecimal amount = BigDecimal.ZERO;
            if (beforeLastYearCostSplit.get(id) != null) {
                amount = amount.add(beforeLastYearCostSplit.get(id));
            }
            if (beforeLastYearPayRegister.get(id) != null) {
                amount = amount.add(beforeLastYearPayRegister.get(id));
            }
            beforeLastYearAmountMap.put(id, amount);
        }
        Date lastYear = DateUtil.getBeforeOrNextYearDate((Date)year, (boolean)false, (int)1);
        Map<Long, BigDecimal> lastYearCostSplit = this.getCostSplit(lastYear, orgIdList);
        Map<Long, BigDecimal> lastYearPayRegister = this.getPayRegister(lastYear, orgIdList);
        HashMap<Long, BigDecimal> lastYearAmountMap = new HashMap<Long, BigDecimal>(16);
        for (Long id : orgIdList) {
            BigDecimal amount = BigDecimal.ZERO;
            if (lastYearCostSplit.get(id) != null) {
                amount = amount.add(lastYearCostSplit.get(id));
            }
            if (lastYearPayRegister.get(id) != null) {
                amount = amount.add(lastYearPayRegister.get(id));
            }
            lastYearAmountMap.put(id, amount);
        }
        for (DynamicObject dyn : entryEntity) {
            long orgId = dyn.getDynamicObject("orgfield").getLong("id");
            if (beforeLastYearAmountMap.get(orgId) != null) {
                dyn.set("beforelastyearamount", beforeLastYearAmountMap.get(orgId));
            }
            if (lastYearAmountMap.get(orgId) == null) continue;
            dyn.set("lastyearamount", lastYearAmountMap.get(orgId));
        }
    }

    private Map<Long, BigDecimal> getCostSplit(Date year, List<Long> orgIdList) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String yearFormat = sdf.format(year);
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter yearFilter = new QFilter("period.periodyear", "=", (Object)Integer.parseInt(yearFormat));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pmco_procostsplit", (String)"org.id,totalcostamt", (QFilter[])new QFilter[]{orgFilter, yearFilter, statusFilter});
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject costSplit : collection) {
            long orgId = costSplit.getLong("org.id");
            BigDecimal totalCostAmt = costSplit.getBigDecimal("totalcostamt");
            if (map.containsKey(orgId)) {
                BigDecimal amount = (BigDecimal)map.get(orgId);
                map.put(orgId, amount.add(totalCostAmt));
                continue;
            }
            map.put(orgId, totalCostAmt);
        }
        return map;
    }

    private Map<Long, BigDecimal> getPayRegister(Date year, List<Long> orgIdList) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String yearFormat = sdf.format(year);
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter yearFilter = new QFilter("period.periodyear", "=", (Object)Integer.parseInt(yearFormat));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pmct_paymentregister", (String)"org.id,entryentity.thispaymentoftaxamount", (QFilter[])new QFilter[]{orgFilter, yearFilter, statusFilter});
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject payRegister : collection) {
            long orgId = payRegister.getLong("org.id");
            BigDecimal payAmount = payRegister.getBigDecimal("entryentity.thispaymentoftaxamount");
            if (map.containsKey(orgId)) {
                BigDecimal amount = (BigDecimal)map.get(orgId);
                map.put(orgId, amount.add(payAmount));
                continue;
            }
            map.put(orgId, payAmount);
        }
        return map;
    }

    private DynamicObjectCollection buildOrgTree() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        int orgLevel = 1;
        Object orgLevelByModel = this.getModel().getValue("orglevel");
        if (orgLevelByModel != null) {
            orgLevel = Integer.parseInt(orgLevelByModel.toString());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        entryEntity.clear();
        ArrayList<Long> tempParentOrgIdList = new ArrayList<Long>();
        tempParentOrgIdList.add(org.getLong("id"));
        ArrayList tempEntryIdList = new ArrayList();
        HashMap<String, Long> rootIdMap = new HashMap<String, Long>(16);
        rootIdMap.put("orgId", org.getLong("id"));
        rootIdMap.put("entryId", 0L);
        tempEntryIdList.add(rootIdMap);
        ORM orm = ORM.create();
        for (int i = 0; i < orgLevel; ++i) {
            QFilter orgFilter = new QFilter("structure.viewparent", "in", tempParentOrgIdList);
            orgFilter.and(new QFilter("structure.view", "=", (Object)Integer.parseInt("01")));
            orgFilter.and(new QFilter("orgpattern.id", "in", (Object)new Long[]{1L, 2L, 7L, 8L}));
            DynamicObjectCollection childrenOrgList = QueryServiceHelper.query((String)"bos_org", (String)"id,name,structure,structure.viewparent,structure.viewparent.name,structure.view,orgpattern", (QFilter[])orgFilter.toArray());
            long[] ids = orm.genLongIds((IDataEntityType)dynamicObjectType, childrenOrgList.size());
            tempParentOrgIdList.clear();
            int childrenOrgListSize = childrenOrgList.size();
            for (int j = 0; j < childrenOrgListSize; ++j) {
                DynamicObject child = (DynamicObject)childrenOrgList.get(j);
                DynamicObject currentRow = new DynamicObject(dynamicObjectType);
                currentRow.set("id", (Object)ids[j]);
                Long parentOrgId = child.getLong("structure.viewparent");
                currentRow.set("parentorg_id", (Object)parentOrgId);
                for (Map map : tempEntryIdList) {
                    if (!Objects.equals(map.get("orgId"), parentOrgId)) continue;
                    currentRow.set("pid", map.get("entryId"));
                    break;
                }
                currentRow.set("orgfield_id", child.get("id"));
                entryEntity.add((Object)currentRow);
                HashMap<String, Long> idMap = new HashMap<String, Long>(16);
                idMap.put("orgId", child.getLong("id"));
                idMap.put("entryId", ids[j]);
                tempEntryIdList.add(idMap);
                tempParentOrgIdList.add(child.getLong("id"));
            }
        }
        return entryEntity;
    }

    private void validateCompile() {
        Date year = this.getModel().getDataEntity().getDate("year");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            return;
        }
        long currentOrgId = org.getLong("id");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (rootOrgId == currentOrgId) {
            return;
        }
        boolean childrenCompiled = this.validateChildrenCompiled(org, year);
        if (childrenCompiled) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4e0a\u7ea7\u5df2\u5206\u914d\u6295\u8d44\u89c4\u5212\u989d\uff0c\u4e0d\u5141\u8bb8\u672c\u7ec4\u7ec7\u518d\u89c4\u5212\u3002", (String)"TacticInvestPlanEditPlugin_47", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("year", null);
            this.getModel().endInit();
            this.getView().updateView("year");
            return;
        }
        DynamicObject parentBill = this.getParentCompile(org, year);
        if (parentBill == null) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u672a\u83b7\u53d6\u5230\u4e0a\u7ea7\u89c4\u5212\u7684\u5e74\u5ea6\u6295\u8d44\u989d\uff0c\u8bf7\u7b49\u5f85\u3002", (String)"TacticInvestPlanEditPlugin_48", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("year", null);
            this.getModel().endInit();
            this.getModel().updateCache();
            this.getView().updateView("year");
        } else {
            DynamicObjectCollection treeEntryEntity = parentBill.getDynamicObjectCollection("treeentryentity");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(year);
            int currentYear = calendar.get(1);
            Calendar parentCa = Calendar.getInstance();
            parentCa.setTime(parentBill.getDate("year"));
            int parentYear = parentCa.get(1);
            for (DynamicObject entity : treeEntryEntity) {
                DynamicObject orgField = entity.getDynamicObject("orgfield");
                if (currentOrgId != orgField.getLong("id")) continue;
                String moneyUnit = this.getModel().getDataEntity().getString("monetaryunit");
                BigDecimal parentAmount = currentYear == parentYear ? entity.getBigDecimal("currentyearamount") : (currentYear == parentYear + 1 ? entity.getBigDecimal("nextyearamount") : entity.getBigDecimal("afternextyearamount"));
                this.getPageCache().put(PARENT_AMOUNT, parentAmount.toString());
                this.getModel().setValue("totalinvestamount", (Object)parentAmount);
                BigDecimal unit = StringUtils.isBlank((String)moneyUnit) ? BigDecimal.ONE : new BigDecimal(moneyUnit);
                TacticInvestPlanAmountHelper.convertMoneyUnit((DynamicObject)this.getModel().getDataEntity(), (BigDecimal)unit, (boolean)false, Collections.singletonList("totalinvestamount"));
                this.getView().updateView("totalinvestamount");
                break;
            }
        }
    }

    private DynamicObject getParentCompile(DynamicObject org, Date year) {
        QFilter orgFilter = new QFilter("treeentryentity.orgfield", "=", (Object)org.getLong("id"));
        QFilter effectStatusFilter = new QFilter("effectivestatus", "=", (Object)EffectStatusEnum.USING.getValue());
        QFilter issueStatusFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ISSUED.getValue());
        DynamicObject[] parentList = BusinessDataServiceHelper.load((String)"pmim_tacticinvestplan", (String)"id,year,treeentryentity,treeentryentity.orgfield,treeentryentity.currentyearamount,treeentryentity.nextyearamount,treeentryentity.afternextyearamount", (QFilter[])new QFilter[]{orgFilter, issueStatusFilter, effectStatusFilter}, (String)"year desc");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(year);
        int currentYear = calendar.get(1);
        long parentId = 0L;
        for (DynamicObject parent : parentList) {
            BigDecimal amount;
            Calendar parentCa = Calendar.getInstance();
            parentCa.setTime(parent.getDate("year"));
            Optional<DynamicObject> optional = parent.getDynamicObjectCollection("treeentryentity").stream().filter(dyn -> dyn.getDynamicObject("orgfield").getLong("id") == org.getLong("id")).findFirst();
            if (!optional.isPresent()) continue;
            DynamicObject detail = optional.get();
            int parentYear = parentCa.get(1);
            if (currentYear == parentYear) {
                amount = detail.getBigDecimal("currentyearamount");
                if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                parentId = parent.getLong("id");
                break;
            }
            if (currentYear == parentYear + 1) {
                amount = detail.getBigDecimal("nextyearamount");
                if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                parentId = parent.getLong("id");
                break;
            }
            if (currentYear != parentYear + 2 || (amount = detail.getBigDecimal("afternextyearamount")) == null || amount.compareTo(BigDecimal.ZERO) <= 0) continue;
            parentId = parent.getLong("id");
            break;
        }
        if (parentId == 0L) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"pmim_tacticinvestplan");
    }

    private boolean validateChildrenCompiled(DynamicObject org, Date year) {
        QFilter orgFilter = new QFilter("structure.viewparent", "in", (Object)org.getLong("id"));
        orgFilter.and(new QFilter("structure.view", "=", (Object)Integer.parseInt("01")));
        orgFilter.and(new QFilter("orgpattern.id", "in", (Object)new Long[]{1L, 2L, 7L, 8L}));
        DynamicObjectCollection childrenOrgList = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])orgFilter.toArray());
        List childrenOrgIdList = childrenOrgList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter childrenOrgFilter = new QFilter("treeentryentity.orgfield", "in", childrenOrgIdList);
        QFilter parentOrgFilter = new QFilter("org", "!=", (Object)org.getLong("id"));
        QFilter issueStatusFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ISSUED.getValue());
        QFilter effectStatusFilter = new QFilter("effectivestatus", "=", (Object)EffectStatusEnum.USING.getValue());
        DynamicObject[] parentList = BusinessDataServiceHelper.load((String)"pmim_tacticinvestplan", (String)"id,year,treeentryentity,treeentryentity.orgfield,treeentryentity.currentyearamount,treeentryentity.nextyearamount,treeentryentity.afternextyearamount", (QFilter[])new QFilter[]{childrenOrgFilter, parentOrgFilter, issueStatusFilter, effectStatusFilter}, (String)"year desc");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(year);
        int currentYear = calendar.get(1);
        for (DynamicObject parent : parentList) {
            BigDecimal amount;
            Calendar parentCa = Calendar.getInstance();
            parentCa.setTime(parent.getDate("year"));
            Optional<DynamicObject> optional = parent.getDynamicObjectCollection("treeentryentity").stream().filter(dyn -> dyn.getDynamicObject("orgfield").getLong("id") == org.getLong("id")).findFirst();
            if (!optional.isPresent()) continue;
            DynamicObject detail = optional.get();
            int parentYear = parentCa.get(1);
            if (!(currentYear == parentYear ? (amount = detail.getBigDecimal("currentyearamount")) != null && amount.compareTo(BigDecimal.ZERO) > 0 : (currentYear == parentYear + 1 ? (amount = detail.getBigDecimal("nextyearamount")) != null && amount.compareTo(BigDecimal.ZERO) > 0 : currentYear == parentYear + 2 && (amount = detail.getBigDecimal("afternextyearamount")) != null && amount.compareTo(BigDecimal.ZERO) > 0))) continue;
            return true;
        }
        return false;
    }

    private void fillInvestAmount(DynamicObjectCollection entryEntity, int[] selectRows, BigDecimal percent) {
        for (int index : selectRows) {
            BigDecimal afterNextYearAmount;
            BigDecimal nextYearAmount;
            BigDecimal currentYearAmount;
            DynamicObject entity = (DynamicObject)entryEntity.get(index);
            BigDecimal baseData = null;
            boolean useLastYear = true;
            BigDecimal lastYearAmount = entity.getBigDecimal("lastyearamount");
            if (lastYearAmount != null && lastYearAmount.compareTo(BigDecimal.ZERO) != 0) {
                baseData = lastYearAmount;
            } else {
                BigDecimal beforeLastYearAmount = entity.getBigDecimal("beforelastyearamount");
                if (beforeLastYearAmount != null && beforeLastYearAmount.compareTo(BigDecimal.ZERO) != 0) {
                    baseData = beforeLastYearAmount;
                    useLastYear = false;
                }
            }
            if (baseData == null) continue;
            BigDecimal increase = percent.divide(new BigDecimal(100L), 2, RoundingMode.HALF_UP).add(BigDecimal.ONE);
            int compareFlag = increase.compareTo(BigDecimal.ZERO);
            if (compareFlag == 0) {
                if (useLastYear) {
                    currentYearAmount = BigDecimal.ZERO;
                    nextYearAmount = currentYearAmount.subtract(baseData);
                    afterNextYearAmount = nextYearAmount.subtract(baseData);
                } else {
                    currentYearAmount = BigDecimal.ZERO.subtract(baseData);
                    nextYearAmount = currentYearAmount.subtract(baseData);
                    afterNextYearAmount = nextYearAmount.subtract(baseData);
                }
            } else if (compareFlag > 0) {
                if (useLastYear) {
                    currentYearAmount = baseData.multiply(increase);
                    nextYearAmount = baseData.multiply(increase.pow(2));
                    afterNextYearAmount = baseData.multiply(increase.pow(3));
                } else {
                    currentYearAmount = baseData.multiply(increase.pow(2));
                    nextYearAmount = baseData.multiply(increase.pow(3));
                    afterNextYearAmount = baseData.multiply(increase.pow(4));
                }
            } else {
                currentYearAmount = baseData.add(baseData.multiply(increase));
                nextYearAmount = currentYearAmount.add(currentYearAmount.multiply(increase));
                afterNextYearAmount = nextYearAmount.add(nextYearAmount.multiply(increase));
            }
            entity.set("currentyearamount", (Object)currentYearAmount);
            entity.set("nextyearamount", (Object)nextYearAmount);
            entity.set("afternextyearamount", (Object)afterNextYearAmount);
        }
        this.getView().updateView("treeentryentity");
    }

    protected void createEntryData(DynamicObjectCollection newEntry, DynamicObjectCollection oldEntry) {
        DynamicObjectType dynamicObjectType = newEntry.getDynamicObjectType();
        HashMap<Long, Long> newPk = new HashMap<Long, Long>(16);
        ORM orm = ORM.create();
        long[] newIds = orm.genLongIds((IDataEntityType)dynamicObjectType, oldEntry.size());
        int index = 0;
        for (DynamicObject entry : oldEntry) {
            newPk.put((Long)entry.getPkValue(), newIds[index++]);
        }
        for (DynamicObject old : oldEntry) {
            DynamicObject newTreeEntryData = new DynamicObject(dynamicObjectType);
            newTreeEntryData.set("orgfield", old.get("orgfield"));
            newTreeEntryData.set("parentorg", old.get("parentorg"));
            newTreeEntryData.set("totalamount", old.get("totalamount"));
            newTreeEntryData.set("registeramount", old.get("registeramount"));
            newTreeEntryData.set("beforelastyearamount", old.get("beforelastyearamount"));
            newTreeEntryData.set("beforelastyearrate", old.get("beforelastyearrate"));
            newTreeEntryData.set("lastyearamount", old.get("lastyearamount"));
            newTreeEntryData.set("lastyearrate", old.get("lastyearrate"));
            newTreeEntryData.set("currentyearamount", old.get("currentyearamount"));
            newTreeEntryData.set("nextyearamount", old.get("nextyearamount"));
            newTreeEntryData.set("afternextyearamount", old.get("afternextyearamount"));
            newTreeEntryData.set("remark", old.get("remark"));
            Long pid = (Long)old.get("pid");
            Long newpid = 0L;
            if (pid != null && !pid.equals(0L)) {
                newpid = (Long)newPk.get(pid);
            }
            newTreeEntryData.set("pid", (Object)newpid);
            newTreeEntryData.set("id", newPk.get(old.getPkValue()));
            newEntry.add((Object)newTreeEntryData);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeEntryGrid.setCollapse(false);
        this.getView().updateView("treeentryentity");
    }

    protected Map<String, List<String>> getHeader() {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>(16);
        Date currentYear = this.getModel().getDataEntity().getDate("year");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String currentYearStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), sdf.format(currentYear));
        Date lastYear = DateUtil.getBeforeOrNextYearDate((Date)currentYear, (boolean)false, (int)1);
        String lastYearStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), sdf.format(lastYear));
        Date beforeLastYear = DateUtil.getBeforeOrNextYearDate((Date)currentYear, (boolean)false, (int)2);
        String beforeLastYearStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), sdf.format(beforeLastYear));
        Date nextYear = DateUtil.getBeforeOrNextYearDate((Date)currentYear, (boolean)true, (int)1);
        String nextYearStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), sdf.format(nextYear));
        Date afterNextYear = DateUtil.getBeforeOrNextYearDate((Date)currentYear, (boolean)true, (int)2);
        String afterNextYearStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"TacticInvestPlanEditPlugin_27", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), sdf.format(afterNextYear));
        ArrayList<String> titleList = new ArrayList<String>();
        titleList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0ID", (String)"TacticInvestPlanEditPlugin_20", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0", (String)"TacticInvestPlanEditPlugin_21", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u516c\u53f8\u603b\u8d44\u4ea7", (String)"TacticInvestPlanEditPlugin_22", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u672c", (String)"TacticInvestPlanEditPlugin_23", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u989d", (String)"TacticInvestPlanEditPlugin_32", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), beforeLastYearStr));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u6536\u76ca\u7387\uff08%%\uff09", (String)"TacticInvestPlanEditPlugin_31", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), beforeLastYearStr));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u989d", (String)"TacticInvestPlanEditPlugin_32", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), lastYearStr));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u6536\u76ca\u7387\uff08%%\uff09", (String)"TacticInvestPlanEditPlugin_31", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), lastYearStr));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u89c4\u5212\u989d", (String)"TacticInvestPlanEditPlugin_24", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), currentYearStr));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u89c4\u5212\u989d", (String)"TacticInvestPlanEditPlugin_24", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), nextYearStr));
        titleList.add(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u89c4\u5212\u989d", (String)"TacticInvestPlanEditPlugin_24", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]), afterNextYearStr));
        titleList.add(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"TacticInvestPlanEditPlugin_26", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        headerMap.put("title", titleList);
        ArrayList<String> nameTitleList = new ArrayList<String>();
        nameTitleList.add("orgfield_id");
        nameTitleList.add("orgfield");
        nameTitleList.add("totalamount");
        nameTitleList.add("registeramount");
        nameTitleList.add("beforelastyearamount");
        nameTitleList.add("beforelastyearrate");
        nameTitleList.add("lastyearamount");
        nameTitleList.add("lastyearrate");
        nameTitleList.add("currentyearamount");
        nameTitleList.add("nextyearamount");
        nameTitleList.add("afternextyearamount");
        nameTitleList.add("remark");
        headerMap.put("nametitle", nameTitleList);
        return headerMap;
    }

    private void uploadEntry(ClosedCallBackEvent e) {
        Map<String, List<String>> titleMap;
        List<String> nameTitleList;
        String url = (String)e.getReturnData();
        if (url == null || "".equals(url.trim())) {
            return;
        }
        List title = TacticInvestPlanImportHelper.getHeadByExcel((String)url);
        boolean flag = TacticInvestPlanImportHelper.checkTitle((List)title, nameTitleList = (titleMap = this.getHeader()).get("nametitle"));
        if (flag) {
            DynamicObjectCollection newEntry = TacticInvestPlanImportHelper.buildEntryExcel((String)url, (IFormView)this.getView(), (String)"treeentryentity", nameTitleList);
            this.getModel().setValue("treeentryentity", (Object)newEntry);
            this.getModel().updateEntryCache(newEntry);
            this.getView().updateView("treeentryentity");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u683c\u5f0f\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5Excel\u6587\u4ef6\u3002", (String)"TacticInvestPlanEditPlugin_49", (String)"pmgt-pmim-formplugin", (Object[])new Object[0]));
        }
    }

    private BigDecimal setAmtScale(BigDecimal amt) {
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currencyfield");
        int amtPrecision = currency.getInt("amtprecision");
        amt = amt.setScale(amtPrecision, RoundingMode.HALF_UP);
        return amt;
    }
}

