/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmim.report.base.AbstractPmimReportFormPlugin;

public class RepositoryFilterPlugin
extends AbstractPmimReportFormPlugin
implements BeforeFilterF7SelectListener {
    private static final String FILTERCONTAINERID = "filtercontainerap";
    private static final String ID_NAME = "id,name";
    private static final String BOS_ORG = "bos_org";
    private static final String ORG_FIELD_NAME = "org.id";
    private static final String CACHEKEY_ORGCOMBOITEMS = "orgcomboitems";
    private static final String ORG_ID = "orgid";
    private static final String ALL_ORG_ID = "allorgid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        this.setOrgFilter(e);
    }

    protected void setOrgFilter(BeforeFilterF7SelectEvent e) {
        String fieldName = e.getFieldName();
        if (!StringUtils.equals((CharSequence)ORG_FIELD_NAME, (CharSequence)fieldName)) {
            return;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"pmim", (String)"pmim_projectproposal", (String)"47150e89000000ac");
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        boolean hasAllOrgPerm = permOrgResult.hasAllOrgPerm();
        ArrayList<QFilter> setQFilters = new ArrayList<QFilter>(10);
        if (!hasAllOrgPerm) {
            QFilter sFilter = new QFilter("id", "in", (Object)hasPermOrgs.toArray());
            setQFilters.add(sFilter);
        }
        e.setCustomQFilters(setQFilters);
    }

    protected QFilter getOrgFilter() {
        String orgIds = this.getPageCache().get(ORG_ID);
        List<String> orgIdList = this.getOrgsByCacheString(orgIds);
        return new QFilter("org", "in", orgIdList.stream().map(Long::parseLong).collect(Collectors.toList()));
    }

    protected List<String> getOrgsByCacheString(String orgIds) {
        String allOrgs = this.getPageCache().get(ALL_ORG_ID);
        if (orgIds == null) {
            String string = orgIds = allOrgs == null ? "" : allOrgs;
        }
        if (orgIds.contains("\"")) {
            orgIds = orgIds.replace("\"", "");
        }
        ArrayList<String> orgList = new ArrayList<String>();
        if (StringUtils.equals((CharSequence)"[]", (CharSequence)orgIds) && allOrgs != null) {
            orgIds = this.getPageCache().get(ALL_ORG_ID);
        }
        if (orgIds != null && orgIds.length() > 2) {
            String[] orgs;
            String substring = orgIds.substring(1, orgIds.length() - 1);
            for (String org : orgs = substring.split(",")) {
                orgList.add(org);
            }
        }
        return orgList;
    }

    protected void filterContainerInit(FilterContainerInitEvent filtercontainerinitevent, ReportQueryParam reportqueryparam) {
        super.filterContainerInit(filtercontainerinitevent, reportqueryparam);
        List filterColumnList = filtercontainerinitevent.getCommonFilterColumns();
        this.initOrgFilterColumn(filterColumnList);
    }

    protected void initOrgFilterColumn(List<FilterColumn> filterColumnList) {
        CommonFilterColumn orgColumn = this.buildOrgFilterColumn();
        if (!filterColumnList.contains(orgColumn)) {
            filterColumnList.add(0, (FilterColumn)orgColumn);
            HashSet<Long> hasPermOrgs = new HashSet<Long>();
            if (orgColumn.getComboItems() != null) {
                for (ComboItem item : orgColumn.getComboItems()) {
                    hasPermOrgs.add(Long.valueOf(item.getId()));
                }
            }
            this.getPageCache().put(ALL_ORG_ID, ((Object)hasPermOrgs).toString());
        }
    }

    private CommonFilterColumn buildOrgFilterColumn() {
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setKey(ORG_FIELD_NAME);
        orgColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7533\u62a5\u7ec4\u7ec7", (String)"RepositoryFilterPlugin_1", (String)"pmgt-pmim-report", (Object[])new Object[0])));
        orgColumn.setFieldName(ORG_FIELD_NAME);
        orgColumn.setMustInput(false);
        orgColumn.setMulti(true);
        List<ComboItem> combos = this.buildOrgComboItems();
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        return orgColumn;
    }

    private List<ComboItem> buildOrgComboItems() {
        ORM orm;
        String cacheString = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            return SerializationUtils.fromJsonStringToList((String)cacheString, ComboItem.class);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"pmim", (String)"pmim_projectproposal", (String)"47150e89000000ac");
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        boolean hasAllOrgPerm = permOrgResult.hasAllOrgPerm();
        DynamicObjectCollection col = null;
        if (hasAllOrgPerm) {
            orm = ORM.create();
            col = orm.query(BOS_ORG, ID_NAME, new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        } else if (!hasPermOrgs.isEmpty()) {
            orm = ORM.create();
            col = orm.query(BOS_ORG, ID_NAME, new QFilter[]{new QFilter("id", "in", (Object)hasPermOrgs)});
        }
        if (col != null && !col.isEmpty()) {
            for (DynamicObject org : col) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getPkValue()));
                item.setCaption(new LocaleString(org.getString("name")));
                item.setValue(String.valueOf(org.getPkValue()));
                combos.add(item);
            }
        }
        cacheString = SerializationUtils.toJsonString(combos);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, cacheString);
        return combos;
    }
}

