/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.report.form;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmim.report.base.AbstractPmimReportFormPlugin;

public class RepositoryReportFormPlugin
extends AbstractPmimReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        String name = null;
        for (DynamicObject dyn : rowData) {
            DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"pmim_projectproposal", (String)String.join((CharSequence)",", "planbegindate", "planenddate", "projectname"), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)dyn.getString("billno"))});
            if (data == null) continue;
            DynamicObjectCollection projectName = data.getDynamicObjectCollection("projectname");
            ArrayList<String> projectList = new ArrayList<String>(10);
            for (DynamicObject dy : projectName) {
                name = dy.getDynamicObject("fbasedataid").getString("billname");
                if (name == null) continue;
                projectList.add(name);
            }
            dyn.set("projectname", (Object)StringUtils.strip((String)((Object)projectList).toString(), (String)"[]"));
            Date planBeginDate = data.getDate("planbegindate");
            Date planEndDate = data.getDate("planenddate");
            if (planBeginDate != null) {
                dyn.set("begindate", (Object)dateFormat.format(planBeginDate));
            } else {
                dyn.set("begindate", (Object)"");
            }
            if (planEndDate != null) {
                dyn.set("enddate", (Object)dateFormat.format(planEndDate));
                continue;
            }
            dyn.set("enddate", (Object)"");
        }
        this.getModel().deleteEntryData("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int clickRowIndex = evt.getRow();
        if (clickRowIndex < 0) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        ReportList list = (ReportList)this.getControl("reportlistap");
        String billno = (String)list.getReportModel().getValue(clickRowIndex, "billno");
        DynamicObject[] proProposalCol = BusinessDataServiceHelper.load((String)"pmim_projectproposal", (String)String.join((CharSequence)",", "pmsgentry_year", "pmsgentry_yearbugamt", "pmsgentry_yearfiamt", "pmsgentry_arrearsamt", "pmsgentry_lastyearbugamt", "pmsgentry_lastyearfiamt", "version", "yearbugappamt", "budgetapplyresult", "yearfiappamt"), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        DynamicObject projectProposal = proProposalCol[0];
        DynamicObjectCollection pmsgentrycol = projectProposal.getDynamicObjectCollection("pmsgentry");
        DynamicObjectCollection proposalCol = this.getModel().getEntryEntity("entryentity");
        proposalCol.clear();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        for (DynamicObject dy : pmsgentrycol) {
            DynamicObject proposalEntry = proposalCol.addNew();
            proposalEntry.set("pmsgentry_year", (Object)formatter.format(dy.getDate("pmsgentry_year")));
            proposalEntry.set("pyearbugamt", (Object)dy.getBigDecimal("pmsgentry_yearbugamt"));
            proposalEntry.set("budgetapplyresult", (Object)dy.getString("budgetapplyresult"));
            proposalEntry.set("pyearfiamt", (Object)dy.getBigDecimal("pmsgentry_yearfiamt"));
            proposalEntry.set("parrearsamt", (Object)dy.getBigDecimal("pmsgentry_arrearsamt"));
            proposalEntry.set("plastyearbugamt", (Object)dy.getBigDecimal("pmsgentry_lastyearbugamt"));
            proposalEntry.set("plastyearfiamt", (Object)dy.getBigDecimal("pmsgentry_lastyearfiamt"));
            proposalEntry.set("version", (Object)dy.getBigDecimal("version"));
            proposalEntry.set("yearfiappamt", (Object)dy.getBigDecimal("yearfiappamt"));
            proposalEntry.set("yearbugappamt", (Object)dy.getBigDecimal("yearbugappamt"));
        }
        this.getModel().getDataEntity(true).set("entryentity", (Object)proposalCol);
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String filename = event.getFieldName();
        int rowIndex = event.getRowIndex();
        ReportList list = (ReportList)this.getControl("reportlistap");
        if (filename.equals("billno")) {
            String billno = (String)list.getReportModel().getValue(rowIndex, filename);
            DynamicObject model = this.getModel().getDataEntity(true);
            DynamicObject[] projectProposalCol = BusinessDataServiceHelper.load((String)"pmim_projectproposal", (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            DynamicObject projectProposal = projectProposalCol[0];
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmim_projectproposal");
            map.put("pkId", String.valueOf(projectProposal.getPkValue()));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Boolean isView = true;
            parameter.setCustomParam("isView", (Object)isView);
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refresh")) {
            this.getModel().deleteEntryData("entryentity");
        }
    }
}

