/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.utils.SynFunSourceHelper;
import kd.pmgt.pmim.common.enums.InvestConclusionEnum;
import kd.pmgt.pmim.common.enums.InvestCycleEnum;

public class InvestPlanSpecialApprovalOp
extends AbstractOperationServicePlugIn {
    private static final String FORMBILLID = "pmim_specialapproval";
    private static final String SELECTOR_All = "project, entryinvesttype, entryinvestcycle, entryinvestperiod, entryinvestamt, entrycurinvestamt, specialorg, specialperson, entryclaimdate, claimtype, conclusion, suporg, approdescrip, finalstate, isvalid, preentryid, sourceentryid, entrycurrency, attachmentfield, islatest, sourcebilltype, billid, investentry.id, investentry.fundsourcetype, investentry.entryamt, investentry.currententryamt, investentry.comment";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("subconclusion");
        fields.add("subsuporg");
        fields.add("org");
        fields.add("specapproperson");
        fields.add("specapprodate");
        fields.add("investcycle");
        fields.add("yearperiod");
        fields.add("monthperiod");
        fields.add("showperiod");
        fields.add("projectentry");
        fields.add("project");
        fields.add("conclusion");
        fields.add("finalstate");
        fields.add("specialorg");
        fields.add("specialperson");
        fields.add("entryclaimdate");
        fields.add("conclusion");
        fields.add("suporg");
        fields.add("isvalid");
        fields.add("islatest");
        fields.add("entryinvestcycle");
        fields.add("entryinvestperiod");
        fields.add("preentryid");
        fields.add("sourceentryid");
        fields.add("sourcebilltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> preObjList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> srcObjList = new ArrayList<DynamicObject>(10);
        switch (operationKey) {
            case "save": 
            case "submit": {
                this.saveAndSubmitBill(dataEntities, preObjList);
                break;
            }
            case "audit": {
                this.auditBill(dataEntities, srcObjList);
                break;
            }
            case "unaudit": {
                this.unauditBill(dataEntities, srcObjList);
                break;
            }
            case "delete": {
                this.deleteBill(e, dataEntities, preObjList);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "unaudit": {
                this.afterDoUnAudit(dataEntities);
                break;
            }
        }
    }

    private void afterDoUnAudit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            Date yearPeriod = bill.getDate("yearperiod");
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
            proEntryCollection.forEach(proEntryObj -> {
                String conclusion = (String)proEntryObj.get("conclusion");
                if (InvestConclusionEnum.Pass.getValue().equals(conclusion)) {
                    DynamicObject project = proEntryObj.getDynamicObject("project");
                    SynFunSourceHelper.deleteFunSource((DynamicObject)project, (Date)yearPeriod);
                    LocalDate localDate = yearPeriod.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    QFilter qFilter = new QFilter("entryinvestperiod", "=", (Object)String.valueOf(localDate.getYear()));
                    qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("finalstate", "=", (Object)InvestConclusionEnum.Pass.getValue());
                    qFilter.and("isvalid", "=", (Object)true);
                    DynamicObject investClaimRecord = BusinessDataServiceHelper.loadSingle((String)"pmim_invesclaimtrecord", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (investClaimRecord != null) {
                        investClaimRecord = BusinessDataServiceHelper.loadSingle((Object)investClaimRecord.getPkValue(), (String)"pmim_invesclaimtrecord");
                        SynFunSourceHelper.createFunSource((DynamicObject)investClaimRecord, (Date)yearPeriod, (String)"pmim_invesclaimtrecord");
                    } else {
                        DynamicObject approvePro = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "pro", "budgetperiod", "budgetproname", "budgetpronumber", "currencyfield"), (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()))});
                        if (approvePro != null) {
                            approvePro = BusinessDataServiceHelper.loadSingle((Object)approvePro.getPkValue(), (String)"pmas_pro_approval");
                            SynFunSourceHelper.createFunSource((DynamicObject)approvePro, (Date)yearPeriod, (String)"pmas_pro_approval");
                        }
                    }
                }
            });
        }
    }

    private void unauditBill(DynamicObject[] dataEntities, List<DynamicObject> srcObjList) {
        ArrayList lastObjList = new ArrayList();
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
            proEntryCollection.forEach(proEntryObj -> {
                boolean islatest;
                String conclusion = (String)proEntryObj.get("conclusion");
                if (InvestConclusionEnum.Pass.getValue().equals(conclusion) || InvestConclusionEnum.NoPass.getValue().equals(conclusion)) {
                    DynamicObject[] srcProObjs;
                    proEntryObj.set("isvalid", (Object)Boolean.FALSE);
                    proEntryObj.set("islatest", (Object)Boolean.FALSE);
                    String sourceId = (String)proEntryObj.get("sourceentryid");
                    QFilter sourceIdFilter = new QFilter("sourceentryid", "=", (Object)sourceId);
                    sourceIdFilter.and("conclusion", "=", (Object)"reportsup");
                    for (DynamicObject srcProObj : srcProObjs = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{sourceIdFilter})) {
                        srcProObj.set("finalstate", (Object)"auditing");
                        srcObjList.add(srcProObj);
                    }
                    String preEntryId = (String)proEntryObj.get("preentryid");
                    if (StringUtils.isNotBlank((CharSequence)preEntryId)) {
                        DynamicObject lastValidRecord = this.gainLastValidRecord(Long.parseLong(preEntryId));
                        lastValidRecord.set("islatest", (Object)false);
                        lastValidRecord.set("isvalid", (Object)true);
                        lastObjList.add(lastValidRecord);
                    }
                } else if (InvestConclusionEnum.ReportSup.getValue().equals(conclusion) && (islatest = proEntryObj.getBoolean("islatest"))) {
                    proEntryObj.set("islatest", (Object)Boolean.FALSE);
                }
            });
        }
        SaveServiceHelper.save((DynamicObject[])srcObjList.toArray(new DynamicObject[srcObjList.size()]));
        SaveServiceHelper.save((DynamicObject[])lastObjList.toArray(new DynamicObject[lastObjList.size()]));
    }

    private void auditBill(DynamicObject[] dataEntities, List<DynamicObject> srcObjList) {
        ArrayList lastObjList = new ArrayList();
        for (DynamicObject bill : dataEntities) {
            Date yearPeriod = bill.getDate("yearperiod");
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
            proEntryCollection.forEach(proEntryObj -> {
                DynamicObject[] srcProObjs;
                String conclusion = (String)proEntryObj.get("conclusion");
                String sourceId = (String)proEntryObj.get("sourceentryid");
                QFilter sourceIdFilter = new QFilter("sourceentryid", "=", (Object)sourceId);
                sourceIdFilter.and("conclusion", "=", (Object)"reportsup");
                for (DynamicObject srcProObj : srcProObjs = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{sourceIdFilter})) {
                    srcProObj.set("finalstate", (Object)conclusion);
                    srcProObj.set("islatest", (Object)false);
                    srcObjList.add(srcProObj);
                }
                String preEntryId = (String)proEntryObj.get("preentryid");
                if (StringUtils.isNotBlank((CharSequence)preEntryId)) {
                    DynamicObject lastValidRecord = this.gainLastValidRecord(Long.parseLong(preEntryId));
                    lastValidRecord.set("islatest", (Object)false);
                    if (InvestConclusionEnum.Pass.getValue().equals(conclusion)) {
                        lastValidRecord.set("isvalid", (Object)false);
                    } else if (InvestConclusionEnum.NoPass.getValue().equals(conclusion)) {
                        lastValidRecord.set("isvalid", (Object)true);
                    }
                    lastObjList.add(lastValidRecord);
                }
                proEntryObj.set("islatest", (Object)Boolean.TRUE);
                if (InvestConclusionEnum.Pass.getValue().equals(conclusion)) {
                    proEntryObj.set("isvalid", (Object)Boolean.TRUE);
                    DynamicObject project = proEntryObj.getDynamicObject("project");
                    SynFunSourceHelper.deleteFunSource((DynamicObject)project, (Date)yearPeriod);
                    Long entryId = proEntryObj.getLong("id");
                    DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"pmim_invesclaimtrecord");
                    SynFunSourceHelper.createFunSource((DynamicObject)record, (Date)yearPeriod, (String)"pmim_invesclaimtrecord");
                } else if (InvestConclusionEnum.NoPass.getValue().equals(conclusion)) {
                    proEntryObj.set("isvalid", (Object)Boolean.FALSE);
                }
            });
        }
        SaveServiceHelper.save((DynamicObject[])srcObjList.toArray(new DynamicObject[srcObjList.size()]));
        SaveServiceHelper.save((DynamicObject[])lastObjList.toArray(new DynamicObject[lastObjList.size()]));
    }

    private DynamicObject gainLastValidRecord(Long pk) {
        DynamicObject record = null;
        if (QueryServiceHelper.exists((String)"pmim_invesclaimtrecord", (Object)pk) && !(record = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pmim_invesclaimtrecord")).getString("finalstate").equals("pass")) {
            this.gainLastValidRecord(record.getLong("preentryid"));
        }
        return record;
    }

    private void saveAndSubmitBill(DynamicObject[] dataEntities, List<DynamicObject> preObjList) {
        for (DynamicObject bill : dataEntities) {
            DynamicObject org = (DynamicObject)bill.get("org");
            DynamicObject specapproperson = (DynamicObject)bill.get("specapproperson");
            Date specapprodate = (Date)bill.get("specapprodate");
            String investcycle = bill.getString("investcycle");
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
            for (DynamicObject proEntryObj : proEntryCollection) {
                String periodStr;
                SimpleDateFormat sdf;
                proEntryObj.set("specialorg", (Object)org);
                proEntryObj.set("specialperson", (Object)specapproperson);
                proEntryObj.set("entryclaimdate", (Object)specapprodate);
                proEntryObj.set("islatest", (Object)Boolean.FALSE);
                if (StringUtils.equals((CharSequence)investcycle, (CharSequence)InvestCycleEnum.Year.getValue())) {
                    Date yearperiod = (Date)bill.get("yearperiod");
                    sdf = new SimpleDateFormat("yyyy", Locale.getDefault());
                    periodStr = sdf.format(yearperiod);
                    proEntryObj.set("entryinvestcycle", (Object)investcycle);
                    proEntryObj.set("entryinvestperiod", (Object)periodStr);
                    bill.set("showperiod", (Object)periodStr);
                } else if (StringUtils.equals((CharSequence)investcycle, (CharSequence)InvestCycleEnum.Month.getValue())) {
                    Date monthperiod = (Date)bill.get("monthperiod");
                    sdf = new SimpleDateFormat("yyyy-MM", Locale.getDefault());
                    periodStr = sdf.format(monthperiod);
                    proEntryObj.set("entryinvestcycle", (Object)investcycle);
                    proEntryObj.set("entryinvestperiod", (Object)periodStr);
                    bill.set("showperiod", (Object)periodStr);
                }
                Object preId = proEntryObj.get("preentryid");
                QFilter preIdFilter = new QFilter("id", "=", (Object)Long.parseLong(preId.toString()));
                DynamicObject preObj = BusinessDataServiceHelper.loadSingle((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{preIdFilter});
                if (preObj == null) continue;
                preObj.set("islatest", (Object)Boolean.FALSE);
                preObjList.add(preObj);
            }
        }
        SaveServiceHelper.save((DynamicObject[])preObjList.toArray(new DynamicObject[preObjList.size()]));
    }

    private void deleteBill(BeginOperationTransactionArgs e, DynamicObject[] dataEntities, List<DynamicObject> preObjList) {
        ArrayList<DynamicObject> deleBillList = new ArrayList<DynamicObject>(10);
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
            for (DynamicObject proEntryObj : proEntryCollection) {
                boolean islatest = proEntryObj.getBoolean("islatest");
                if (islatest) continue;
                this.writeBackPreEntryObj(preObjList, proEntryObj);
            }
            deleBillList.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])preObjList.toArray(new DynamicObject[preObjList.size()]));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMBILLID);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleBillList.toArray());
    }

    private void writeBackPreEntryObj(List<DynamicObject> preObjList, DynamicObject proEntryObj) {
        String preId = (String)proEntryObj.get("preentryid");
        QFilter preIdFilter = new QFilter("id", "=", (Object)Long.parseLong(preId));
        DynamicObject preObj = BusinessDataServiceHelper.loadSingle((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{preIdFilter});
        if (preObj != null) {
            preObj.set("islatest", (Object)Boolean.TRUE);
            preObjList.add(preObj);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isSaveAndsubmit = false;
        boolean isUnaudit = false;
        boolean isDelete = false;
        boolean isAudit = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if ("save".equals(key) || "submit".equals(key)) {
                isSaveAndsubmit = true;
                continue;
            }
            if ("unaudit".equals(key)) {
                isUnaudit = true;
                continue;
            }
            if ("delete".equals(key)) {
                isDelete = true;
                continue;
            }
            if (!"audit".equals(key)) continue;
            isAudit = true;
        }
        if (isSaveAndsubmit) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String errMsg = InvestPlanSpecialApprovalOp.this.saveAndSubmitValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            });
        } else if (isUnaudit) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String errMsg = InvestPlanSpecialApprovalOp.this.unAuditValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            });
        } else if (isDelete) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        String errMsg = InvestPlanSpecialApprovalOp.this.deleteValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            });
        } else if (isAudit) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        String errMsg = InvestPlanSpecialApprovalOp.this.auditValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addWarningMessage(dataEntity, errMsg);
                    }
                }
            });
        }
    }

    private String auditValidate(DynamicObject bill) {
        DynamicObjectCollection projectEntries = bill.getDynamicObjectCollection("projectentry");
        Date yearPeriod = bill.getDate("yearperiod");
        for (DynamicObject proEntryObj : projectEntries) {
            String conclusion = proEntryObj.getString("conclusion");
            if (!InvestConclusionEnum.Pass.getValue().equals(conclusion)) continue;
            LocalDate localDate = yearPeriod.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)localDate.getYear());
            DynamicObject project = proEntryObj.getDynamicObject("project");
            qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            DynamicObject[] oldFunSources = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (oldFunSources.length <= 0) continue;
            return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5df2\u5b58\u5728\u5f53\u524d\u5e74\u5ea6\u7684\u8d44\u91d1\u6765\u6e90\u6570\u636e\uff0c\u5c06\u4ee5\u6700\u65b0\u6570\u636e\u8fdb\u884c\u66ff\u6362\u3002", (String)"InvestPlanSpecialApprovalOp_14", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name"));
        }
        return null;
    }

    private String unAuditValidate(DynamicObject bill) {
        DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
        for (DynamicObject proEntryObj : proEntryCollection) {
            DynamicObject projectStatus;
            DynamicObject project;
            DynamicObject bdProject;
            String id = proEntryObj.getPkValue().toString();
            QFilter preIdFilter = new QFilter("preentryid", "=", (Object)id);
            DynamicObject proObj = BusinessDataServiceHelper.loadSingle((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{preIdFilter});
            if (proObj != null) {
                String srcBillType = proObj.getString("sourcebilltype");
                StringBuffer billName = new StringBuffer();
                if ("investplanclaim".equals(srcBillType)) {
                    String claimType = proObj.getString("claimtype");
                    if ("adjustinvest".equals(claimType)) {
                        return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u5e74\u5ea6\u6295\u8d44\u8ba1\u5212\u5df2\u5b58\u5728\u8c03\u6574\u6295\u8d44\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestPlanSpecialApprovalOp_15", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), proEntryObj.getDynamicObject("project").get("name"));
                    }
                    if ("continueinvest".equals(claimType)) {
                        return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u5e74\u5ea6\u6295\u8d44\u8ba1\u5212\u5df2\u5b58\u5728\u7ee7\u7eed\u6295\u8d44\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestPlanSpecialApprovalOp_16", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), proEntryObj.getDynamicObject("project").get("name"));
                    }
                } else {
                    String billId = proObj.getString("billid");
                    DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)FORMBILLID);
                    billName.append(String.format(ResManager.loadKDString((String)"\u6295\u8d44\u8ba1\u5212\u4e13\u9879\u5ba1\u6279\u5355\u201c%s\u201d ", (String)"InvestPlanSpecialApprovalOp_13", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), usedBill.getString("name")));
                    return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u5e74\u5ea6\u6295\u8d44\u8ba1\u5212\u5df2\u88ab\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestPlanSpecialApprovalOp_17", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), proEntryObj.getDynamicObject("project").get("name"), billName);
                }
            }
            if ((bdProject = proEntryObj.getDynamicObject("project")) == null || (project = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"prostatus", (QFilter[])new QFilter[]{new QFilter("pro", "=", bdProject.getPkValue())})) == null || (projectStatus = project.getDynamicObject("prostatus")) == null) continue;
            String projectStatusId = projectStatus.getPkValue().toString();
            if (!ProjectStatusEnum.FINANCIAL_CLOSE.getId().equals(projectStatusId)) continue;
            return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u5df2\u7ecf\u8d22\u52a1\u5173\u95ed\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"InvestPlanSpecialApprovalOp_6", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), bdProject.get("name"));
        }
        return null;
    }

    private String saveAndSubmitValidate(DynamicObject bill) {
        DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
        for (DynamicObject proEntryObj : proEntryCollection) {
            String preId = proEntryObj.getString("preentryid");
            String curProId = proEntryObj.getDynamicObject("project").getPkValue().toString();
            QFilter preIdFilter = new QFilter("preentryid", "=", (Object)preId);
            DynamicObject proObj = BusinessDataServiceHelper.loadSingle((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{preIdFilter});
            if (proObj == null || curProId.equals(proObj.getDynamicObject("project").getPkValue().toString())) continue;
            StringBuffer billName = new StringBuffer(ResManager.loadKDString((String)"\u6295\u8d44\u8ba1\u5212\u5ba1\u6279\u5355", (String)"InvestPlanSpecialApprovalOp_1", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
            String billId = proObj.getString("billid");
            DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)FORMBILLID);
            billName.append('-');
            billName.append(usedBill.getString("name"));
            return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5df2\u88ab\u201c%2$s\u201d\u4f7f\u7528\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvestPlanSpecialApprovalOp_18", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), proEntryObj.getDynamicObject("project").get("name"), billName);
        }
        return null;
    }

    private String deleteValidate(DynamicObject bill) {
        DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("projectentry");
        for (DynamicObject proEntryObj : proEntryCollection) {
            String id = proEntryObj.getPkValue().toString();
            QFilter proIdFilter = new QFilter("preentryid", "=", (Object)id);
            DynamicObject proObj = BusinessDataServiceHelper.loadSingle((String)"pmim_invesclaimtrecord", (String)SELECTOR_All, (QFilter[])new QFilter[]{proIdFilter});
            if (proObj != null) {
                String srcBillType = proObj.getString("sourcebilltype");
                StringBuilder billName = new StringBuilder();
                if ("investplanclaim".equals(srcBillType)) {
                    billName.append(ResManager.loadKDString((String)"\u6295\u8d44\u8ba1\u5212\u7533\u62a5\u5355", (String)"InvestPlanSpecialApprovalOp_0", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                    String billId = proObj.getString("billid");
                    DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_investplanclaim");
                    billName.append('-');
                    billName.append(usedBill.getString("name"));
                } else {
                    billName.append(ResManager.loadKDString((String)"\u6295\u8d44\u8ba1\u5212\u5ba1\u6279\u5355", (String)"InvestPlanSpecialApprovalOp_1", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                    String billId = proObj.getString("billid");
                    DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)FORMBILLID);
                    billName.append('-');
                    billName.append(usedBill.getString("name"));
                }
                return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5df2\u88ab\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InvestPlanSpecialApprovalOp_19", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), proEntryObj.getDynamicObject("project").get("name"), billName);
            }
            boolean islatest = proEntryObj.getBoolean("islatest");
            if (!islatest) continue;
            return String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u53cd\u5ba1\u6838\u9879\u76ee\u201c%s\u201d\uff0c\u518d\u8fdb\u884c\u5220\u9664\u3002", (String)"InvestPlanSpecialApprovalOp_20", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), proEntryObj.getDynamicObject("project").get("name"));
        }
        return null;
    }
}

