/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.pmim.EffectStatusEnum;
import kd.pmgt.pmbs.common.enums.pmim.IssueStatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.WorkFlowHelper;
import kd.pmgt.pmim.business.helper.TacticInvestPlanAmountHelper;
import kd.pmgt.pmim.opplugin.validator.TacticInvestPlanOpValidator;

public class TacticInvestPlanOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("billno");
        fields.add("org");
        fields.add("tacticinvestplan");
        fields.add("pkValue");
        fields.add("billstatus");
        fields.add("creator");
        fields.add("modifier");
        fields.add("auditor");
        fields.add("auditdate");
        fields.add("modifytime");
        fields.add("createtime");
        fields.add("org");
        fields.add("treeentryentity");
        fields.add("seq");
        fields.add("pid");
        fields.add("isGroupNode");
        fields.add("orgfield");
        fields.add("remark");
        fields.add("totalamount");
        fields.add("registeramount");
        fields.add("beforelastyearamount");
        fields.add("lastyearamount");
        fields.add("currentyearamount");
        fields.add("nextyearamount");
        fields.add("afternextyearamount");
        fields.add("beforelastyearrate");
        fields.add("lastyearrate");
        fields.add("parentorg");
        fields.add("version");
        fields.add("billname");
        fields.add("year");
        fields.add("effectivetime");
        fields.add("issuetime");
        fields.add("stoptime");
        fields.add("effectivestatus");
        fields.add("issuestatus");
        fields.add("totalinvestamount");
        fields.add("currencyfield");
        fields.add("explain");
        fields.add("orglevel");
        fields.add("percent");
        fields.add("textfield1");
        fields.add("monetaryunit");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new TacticInvestPlanOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        block16: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "submit": {
                    this.setMoneyUnitConvert(dataEntity);
                    continue block16;
                }
                case "audit": {
                    boolean processEnable = WorkFlowHelper.getProcessEnable((String)"pmim_tacticinvestplan");
                    if (processEnable) continue block16;
                    this.setMoneyUnitConvert(dataEntity);
                    continue block16;
                }
                case "takeeffect": {
                    Optional<DynamicObject> optional;
                    long orgId = dataEntity.getDynamicObject("org").getLong("id");
                    Date year = dataEntity.getDate("year");
                    QFilter yearFilter = new QFilter("year", ">=", (Object)DateUtil.getYearStartTime((Date)year)).and(new QFilter("year", "<=", (Object)DateUtil.getYearEndTime((Date)year)));
                    QFilter effectStatusFilter = new QFilter("effectivestatus", "=", (Object)EffectStatusEnum.USING.getValue());
                    DynamicObject[] billList = BusinessDataServiceHelper.load((String)"pmim_tacticinvestplan", (String)"id,org,treeentryentity,treeentryentity.orgfield,effectivestatus", (QFilter[])new QFilter[]{yearFilter, effectStatusFilter});
                    if (billList.length > 0 && (optional = Arrays.stream(billList).filter(bill -> bill.getDynamicObject("org").getLong("id") == orgId).findFirst()).isPresent()) {
                        DynamicObject bill2 = BusinessDataServiceHelper.loadSingle((Object)optional.get().get("id"), (String)"pmim_tacticinvestplan");
                        bill2.set("effectivestatus", (Object)EffectStatusEnum.STOP.getValue());
                        bill2.set("stoptime", (Object)new Date());
                        SaveServiceHelper.update((DynamicObject)bill2);
                    }
                    dataEntity.set("effectivestatus", (Object)EffectStatusEnum.USING.getValue());
                    dataEntity.set("effectivetime", (Object)new Date());
                    this.setMoneyUnitConvert(dataEntity);
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                    continue block16;
                }
                case "blockup": {
                    dataEntity.set("effectivestatus", (Object)EffectStatusEnum.STOP.getValue());
                    dataEntity.set("stoptime", (Object)new Date());
                    this.setMoneyUnitConvert(dataEntity);
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                    continue block16;
                }
                case "issue": {
                    dataEntity.set("issuestatus", (Object)IssueStatusEnum.ISSUED.getValue());
                    dataEntity.set("issuetime", (Object)new Date());
                    this.setMoneyUnitConvert(dataEntity);
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                    continue block16;
                }
                case "unaudit": {
                    dataEntity.set("effectivestatus", (Object)EffectStatusEnum.PENDINGEFFECT.getValue());
                    dataEntity.set("effectivetime", null);
                    dataEntity.set("stoptime", null);
                    continue block16;
                }
            }
        }
    }

    private void setMoneyUnitConvert(DynamicObject dataEntity) {
        List amountNameList = TacticInvestPlanAmountHelper.getAmountName((DynamicObject)dataEntity);
        String moneyUnit = dataEntity.getString("monetaryunit");
        BigDecimal unit = StringUtils.isBlank((CharSequence)moneyUnit) ? BigDecimal.ONE : new BigDecimal(moneyUnit);
        TacticInvestPlanAmountHelper.convertMoneyUnit((DynamicObject)dataEntity, (BigDecimal)unit, (boolean)true, (List)amountNameList);
    }
}

