/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.buget;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmim.business.helper.AunualinvesPlanHelper;
import kd.pmgt.pmim.business.helper.InvestBudgetPlanHelper;
import kd.pmgt.pmim.opplugin.validator.AunualinvesPlantOpValidator;

public class AunualinvesPlanUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("year");
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("billstatus");
        fieldKeys.add("docuimenttype");
        fieldKeys.add("inventry");
        fieldKeys.add("funsourceentry");
        fieldKeys.add("fundsourcetype");
        fieldKeys.add("fundtype");
        fieldKeys.add("scale");
        fieldKeys.add("comment");
        fieldKeys.add("currententryamt");
        fieldKeys.add("entryamt");
        fieldKeys.add("formofinvest");
        fieldKeys.add("investcurrency");
        fieldKeys.add("seq");
        fieldKeys.add("projectno");
        fieldKeys.add("projecttype");
        fieldKeys.add("projectstatus");
        fieldKeys.add("inventry_projectkind");
        fieldKeys.add("inventry_reportorg");
        fieldKeys.add("inventry_sourceorg");
        fieldKeys.add("inventry_datasource");
        fieldKeys.add("inventry_oriannualincest");
        fieldKeys.add("inventry_orifinancialex");
        fieldKeys.add("inventry_arrearsamt");
        fieldKeys.add("inventry_lastyearbugamt");
        fieldKeys.add("inventry_lastyearfiamt");
        fieldKeys.add("inventry_approveamt");
        fieldKeys.add("inventry_finanapproveamt");
        fieldKeys.add("inventry_investlistid");
        fieldKeys.add("inventry_declaretype");
        fieldKeys.add("inventry_approvalcon");
        fieldKeys.add("inventry_accepted");
        fieldKeys.add("inventry_anlinvesdeclamt");
        fieldKeys.add("inventry_approveamt");
        fieldKeys.add("inventry_anfinaexbuddeamt");
        fieldKeys.add("inventry_finanapproveamt");
        fieldKeys.add("projcetbugamt");
        fieldKeys.add("industrykind");
        fieldKeys.add("investdirection");
        fieldKeys.add("investkind");
        fieldKeys.add("overseapro");
        fieldKeys.add("projcetbugappamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AunualinvesPlantOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        InvestBudgetPlanHelper investBudgetPlanHelper = new InvestBudgetPlanHelper();
        for (DynamicObject bill : bills = e.getDataEntities()) {
            String billFromId = bill.getDataEntityType().getName();
            investBudgetPlanHelper.syncBudgetBaseData(bill, billFromId, e.getOperationKey());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills;
        AunualinvesPlanHelper aunualinvesPlanHelper = new AunualinvesPlanHelper();
        for (DynamicObject bill : bills = e.getDataEntities()) {
            aunualinvesPlanHelper.updateProjectProposalF7(bill, e.getOperationKey());
            aunualinvesPlanHelper.deleteProjectProposalF7(bill);
            aunualinvesPlanHelper.synProjectProposal(bill, e.getOperationKey());
            aunualinvesPlanHelper.synFunSourceBill(bill, OperationEnum.UNAUDIT.getValue());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills;
        AunualinvesPlanHelper aunualinvesPlanHelper = new AunualinvesPlanHelper();
        for (DynamicObject bill : bills = e.getDataEntities()) {
            aunualinvesPlanHelper.synProjectData(bill, OperationEnum.UNAUDIT.getValue());
        }
    }
}

