/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.buget;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.pmgt.pmim.business.helper.InvestBudgetPlanHelper;

public class InvestBudgetAuditAuditOp
extends AbstractOperationServicePlugIn {
    protected static final String AUDIT = "audit";
    protected static final String UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("investbudgetplan");
    }

    public final void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey;
                switch (operateKey = this.getOperateKey()) {
                    case "unaudit": {
                        this.validateUnaudit(e);
                        break;
                    }
                }
            }

            private void validateUnaudit(AddValidatorsEventArgs e2) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObject budgetBaseData = BusinessDataServiceHelper.loadSingle((String)"pmim_budgetbase", (String)"investbudgetplan,projectname", (QFilter[])new QFilter[]{new QFilter("investbudgetplan", "=", obj.get("investbudgetplan"))});
                    if (budgetBaseData == null || budgetBaseData.getDynamicObjectCollection("projectname").isEmpty()) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u88ab\u9879\u76ee\u7acb\u9879\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestBudgetAuditAuditOp_1", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey;
        super.beginOperationTransaction(e);
        switch (operateKey = e.getOperationKey()) {
            case "audit": {
                this.insertIntoBudgetDataBase(e);
                break;
            }
            case "unaudit": {
                this.deleteBudgetDataBase(e);
                break;
            }
        }
    }

    private void deleteBudgetDataBase(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        ArrayList<String> investbudgetplanIdList = new ArrayList<String>(10);
        for (DynamicObject budgetAudit : dynamicObjects) {
            String investbudgetplanId = budgetAudit.getString("investbudgetplan");
            investbudgetplanIdList.add(investbudgetplanId);
            if (investbudgetplanId == null || investbudgetplanId.isEmpty()) continue;
            DynamicObject investbudgetplan = BusinessDataServiceHelper.loadSingle((Object)investbudgetplanId, (String)"pmim_investbugetplan");
            new InvestBudgetPlanHelper().syncBudgetBaseData(investbudgetplan, "pmim_budgetaudit", e.getOperationKey());
        }
        DeleteServiceHelper.delete((String)"pmim_budgetbase", (QFilter[])new QFilter[]{new QFilter("investbudgetplan", "in", (Object)investbudgetplanIdList.toArray())});
    }

    private void insertIntoBudgetDataBase(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        InvestBudgetPlanHelper helper = new InvestBudgetPlanHelper();
        for (DynamicObject budgetAudit : dynamicObjects) {
            String investbudgetplanId = budgetAudit.getString("investbudgetplan");
            if (investbudgetplanId == null || investbudgetplanId.isEmpty()) continue;
            DynamicObject investbudgetplan = BusinessDataServiceHelper.loadSingle((Object)investbudgetplanId, (String)"pmim_investbugetplan");
            helper.syncBudgetBaseData(investbudgetplan, "pmim_budgetaudit", e.getOperationKey());
        }
    }
}

