/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.buget;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmim.business.helper.InvestBudgetPlanHelper;

public class InvestBudgetPlanSubmitOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("year");
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("isreport");
        fieldKeys.add("reportorg");
        fieldKeys.add("inventry");
        fieldKeys.add("inventry_projectproposal");
        fieldKeys.add("inventry_yearfiamt");
        fieldKeys.add("inventry_arrearsamt");
        fieldKeys.add("inventry_yearbugamt");
        fieldKeys.add("inventry_lastyearfiamt");
        fieldKeys.add("inventry_lastyearbugamt");
        fieldKeys.add("inventry_projectproposal");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    String billStatus = dynamicObject.getString("billstatus");
                    if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) continue;
                    if (dynamicObject.getBoolean("isreport") && null == dataEntity.getDataEntity().getDynamicObject("reportorg")) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4e0a\u62a5\u7ec4\u7ec7\u201d\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u8005\u914d\u7f6e\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"InvestBudgetPlanSubmitOpPlugin_12", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection invEntrys = dynamicObject.getDynamicObjectCollection("inventry");
                    if (invEntrys.isEmpty()) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6295\u8d44\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvestBudgetPlanSubmitOpPlugin_8", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    LocalDate year = dynamicObject.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    int yearNum = year.getYear();
                    DynamicObject org = dynamicObject.getDynamicObject("org");
                    long orgId = Long.parseLong(org.getPkValue().toString());
                    if (QueryServiceHelper.exists((String)"pmim_investbugetplan", (QFilter[])new QFilter[]{new QFilter("YEAR(year)", "=", (Object)yearNum).and("org", "=", (Object)orgId).and("billstatus", "=", (Object)"C")})) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u7ec4\u7ec7\u540c\u5e74\u5ea6\u53ea\u80fd\u7533\u8bf7\u4e00\u6b21\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvestBudgetPlanSubmitOpPlugin_13", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection("inventry");
                    for (DynamicObject entry : col) {
                        DynamicObject f7 = entry.getDynamicObject("inventry_projectproposal");
                        if (null == f7) {
                            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u8054\u7684\u9879\u76ee\u5efa\u8bae\u4e66\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"InvestBudgetPlanSubmitOpPlugin_10", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        String name = f7.getString("name");
                        if (!f7.getBoolean("isquote")) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5173\u8054\u7684\u9879\u76ee\u5efa\u8bae\u4e66\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"InvestBudgetPlanSubmitOpPlugin_14", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), name));
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            InvestBudgetPlanHelper.syncProjectProposalIsQuote((DynamicObject)dynamicObject, (boolean)true);
        }
    }
}

