/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.buget;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.pmgt.pmim.business.helper.InvestBudgetPlanHelper;

public class InvestBudgetPlanUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("year");
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("isreport");
        fieldKeys.add("inventry");
        fieldKeys.add("reportorg");
        fieldKeys.add("inventry_yearfiamt");
        fieldKeys.add("inventry_arrearsamt");
        fieldKeys.add("inventry_yearbugamt");
        fieldKeys.add("inventry_lastyearfiamt");
        fieldKeys.add("inventry_lastyearbugamt");
        fieldKeys.add("inventry_projectproposal");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObjectCollection pjCol;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    boolean isReport = QueryServiceHelper.exists((String)"pmim_budgetaudit", (QFilter[])new QFilter[]{new QFilter("yearbugappno", "=", dynamicObject.get("id"))});
                    if (isReport) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6295\u8d44\u9884\u7b97\u7533\u8bf7\u5355\u5df2\u4e0a\u62a5\u3002", (String)"InvestBudgetPlanUnAuditOpPlugin_4", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    DynamicObject budgetBaseInfo = BusinessDataServiceHelper.loadSingle((String)"pmim_budgetbase", (String)String.join((CharSequence)",", "projectname"), (QFilter[])new QFilter[]{new QFilter("investbudgetplan", "=", (Object)dynamicObject.getPkValue().toString())});
                    if (null == budgetBaseInfo || (pjCol = budgetBaseInfo.getDynamicObjectCollection("projectname")).isEmpty()) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6295\u8d44\u9884\u7b97\u7533\u8bf7\u5df2\u7acb\u9879\u3002", (String)"InvestBudgetPlanUnAuditOpPlugin_3", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dynamicObjectCol = e.getDataEntities();
        ArrayList<String> investBudgetIds = new ArrayList<String>(dynamicObjectCol.length);
        for (DynamicObject dynamicObject : dynamicObjectCol) {
            InvestBudgetPlanHelper.syncProjectProposalIsQuote((DynamicObject)dynamicObject, (boolean)false);
            investBudgetIds.add(dynamicObject.getPkValue().toString());
            if (dynamicObject.getBoolean("isreport")) continue;
            new InvestBudgetPlanHelper().syncBudgetBaseData(dynamicObject, "pmim_investbugetplan", e.getOperationKey());
        }
        DeleteServiceHelper.delete((String)"pmim_budgetbase", (QFilter[])new QFilter[]{new QFilter("investbudgetplan", "in", (Object)investBudgetIds.toArray())});
    }
}

