/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.buget;

import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;
import kd.pmgt.pmim.business.helper.ProjectProposalHelper;

public class ProjectProposalCancelOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("pmsgentry");
        fieldKeys.add("pmsgentry_isquote");
        fieldKeys.add("pmsg_reportbudget");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] bills = this.getDataEntities();
                if (bills.length > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u6570\u636e\u3002", (String)"ProjectProposalCancelOpPlugin_9", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                }
                for (ExtendedDataEntity bill : bills) {
                    Long[] billIds;
                    DynamicObject projectProposal = bill.getDataEntity();
                    String bizStatus = bill.getDataEntity().get("bizstatus").toString();
                    String billStatus = bill.getDataEntity().get("billstatus").toString();
                    if (!bizStatus.equals(BizStatusEnum.NORMAL.getValue()) || !billStatus.equals("C")) {
                        this.addMessage(bill, ResManager.loadKDString((String)"\u5355\u636e\u5fc5\u987b\u5904\u4e8e\u201c\u6b63\u5e38\u201d\u4e14\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"ProjectProposalCancelOpPlugin_3", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    Map reFencedMap = BaseDataRefrenceHelper.checkRefrenced((String)"pmim_proposalbill_f7", (Object[])new Object[]{projectProposal.getPkValue()}, null, null, null);
                    if (!reFencedMap.isEmpty()) {
                        BaseDataCheckRefrenceResult referResult = (BaseDataCheckRefrenceResult)reFencedMap.get(projectProposal.getPkValue());
                        String refFormId = referResult.getRefenceKey().getRefEntityKey();
                        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refFormId);
                        String billName = refMainType.getDisplayName().toString();
                        this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u6570\u636e\u5df2\u88ab\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u3002", (String)"ProjectProposalCancelOpPlugin_10", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("billno"), billName));
                        continue;
                    }
                    DynamicObjectCollection pmsgEntrys = projectProposal.getDynamicObjectCollection("pmsgentry");
                    for (DynamicObject pmsgEntry : pmsgEntrys) {
                        Boolean isRefenced;
                        boolean isReport = pmsgEntry.getBoolean("pmsg_reportbudget");
                        if (!isReport || !(isRefenced = Boolean.valueOf(ProjectProposalHelper.checkProjectProposalF7IsRefenced((Object)pmsgEntry.getPkValue()))).booleanValue()) continue;
                        this.addMessage(bill, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u6570\u636e\u5df2\u88ab\u201c\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u8bf7\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u3002", (String)"ProjectProposalCancelOpPlugin_11", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("billno")), ErrorLevel.Error);
                    }
                    String sourceEntityNumber = bill.getDataEntity().getDataEntityType().getName();
                    Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)sourceEntityNumber, (Long[])(billIds = new Long[]{bill.getDataEntity().getLong("id")}));
                    if (null == targetBillIds || targetBillIds.isEmpty()) continue;
                    this.addMessage(bill, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5efa\u8bae\u4e66\u5df2\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectProposalCancelOpPlugin_12", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
    }
}

