/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.buget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.DocuimentTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;
import kd.pmgt.pmim.business.helper.ProjectProposalHelper;

public class ProjectProposalUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    static final String PMIM_PROPOSAL_F7 = "pmim_proposalbill_f7";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizstatus");
        fieldKeys.add("pmsgentry");
        fieldKeys.add("pmsgentry_year");
        fieldKeys.add("pmsgentry_isquote");
        fieldKeys.add("pmsg_reportbudget");
        fieldKeys.add("pmsgentry_yearfiamt");
        fieldKeys.add("pmsgentry_yearbugamt");
        fieldKeys.add("budgetapplyresult");
        fieldKeys.add("yearbugappamt");
        fieldKeys.add("yearfiappamt");
        fieldKeys.add("profinexbudappamt");
        fieldKeys.add("proinvestbudappamt");
        fieldKeys.add("reportbudget");
        fieldKeys.add("currency");
        fieldKeys.add("yearbugapprovalamt");
        fieldKeys.add("indexwarnlight");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection indexEntry = bill.getDynamicObjectCollection("indexentity");
            for (DynamicObject index : indexEntry) {
                index.set("indexwarnlight", null);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        DynamicObject[] projectProposalF7Arr = new DynamicObject[]{};
        ArrayList<DynamicObject> updateProjectProposalF7s = new ArrayList<DynamicObject>();
        List ids = Arrays.stream(bills).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
        if (ids.size() > 0) {
            QFilter qFilter = new QFilter("projectproposalid", "in", ids);
            projectProposalF7Arr = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)String.join((CharSequence)",", "projectproposalid", "status"), (QFilter[])new QFilter[]{qFilter});
        }
        for (DynamicObject bill : bills) {
            DynamicObject[] projectProposalF7s;
            String id = bill.getPkValue().toString();
            if (projectProposalF7Arr.length <= 0) continue;
            for (DynamicObject projectProposalF7 : projectProposalF7s = (DynamicObject[])Arrays.stream(projectProposalF7Arr).filter(o -> StringUtils.equals((CharSequence)id, (CharSequence)o.getString("projectproposalid"))).toArray(DynamicObject[]::new)) {
                projectProposalF7.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                updateProjectProposalF7s.add(projectProposalF7);
            }
            bill.set("yearbugapprovalamt", (Object)BigDecimal.ZERO);
            bill.set("proinvestbudappamt", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.update((DynamicObject[])bills);
        if (updateProjectProposalF7s.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateProjectProposalF7s.toArray(new DynamicObject[0]));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities.length == 0) {
                    return;
                }
                Object[] ids = Arrays.stream(dataEntities).map(o -> o.getDataEntity().getPkValue()).toArray(Object[]::new);
                ArrayList<String> ignoreEntityIds = new ArrayList<String>(10);
                ignoreEntityIds.add("pmim_budgetbase");
                Map reFencedMap = BaseDataRefrenceHelper.checkRefrenced((String)ProjectProposalUnAuditOpPlugin.PMIM_PROPOSAL_F7, (Object[])ids, ignoreEntityIds, null, null);
                QFilter qFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
                qFilter.and("inventry.projectno", "in", (Object)ids);
                DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmim_specialdeclarainvest", (String)String.join((CharSequence)",", "inventry", "projectno"), (QFilter[])new QFilter[]{qFilter});
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject projectProposal = dataEntity.getDataEntity();
                    String bizStatus = projectProposal.getString("bizstatus");
                    if (!BizStatusEnum.NORMAL.getValue().equals(bizStatus)) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u4e1a\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ProjectProposalUnAuditOpPlugin_5", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (!reFencedMap.isEmpty()) {
                        BaseDataCheckRefrenceResult referResult = (BaseDataCheckRefrenceResult)reFencedMap.get(projectProposal.getPkValue());
                        String refFormId = referResult.getRefenceKey().getRefEntityKey();
                        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refFormId);
                        if ("pmim_aunualinvestplan".equals(refFormId) || "pmim_specialdeclarainvest".equals(refFormId)) {
                            String id = projectProposal.getPkValue().toString();
                            ArrayList<DynamicObject> planList = new ArrayList<DynamicObject>();
                            for (DynamicObject plan : plans) {
                                Optional<DynamicObject> first;
                                DynamicObjectCollection inventry = plan.getDynamicObjectCollection("inventry");
                                if (inventry.size() <= 0 || !(first = inventry.stream().filter(o -> o.getDynamicObject("projectno") != null).filter(o -> StringUtils.equals((CharSequence)id, (CharSequence)o.getDynamicObject("projectno").getPkValue().toString())).findFirst()).isPresent()) continue;
                                planList.add(plan);
                            }
                            refMainType = planList.size() > 0 ? EntityMetadataCache.getDataEntityType((String)"pmim_specialdeclarainvest") : EntityMetadataCache.getDataEntityType((String)"pmim_aunualinvestplan");
                        }
                        String billName = refMainType.getDisplayName().toString();
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u6570\u636e\u5df2\u88ab\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectProposalUnAuditOpPlugin_6", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("billno"), billName));
                        continue;
                    }
                    DynamicObjectCollection pmsgEntrys = projectProposal.getDynamicObjectCollection("pmsgentry");
                    for (DynamicObject pmsgEntry : pmsgEntrys) {
                        Boolean isRefenced;
                        boolean isReport = pmsgEntry.getBoolean("pmsg_reportbudget");
                        if (!isReport || !(isRefenced = Boolean.valueOf(ProjectProposalHelper.checkProjectProposalF7IsRefenced((Object)pmsgEntry.getPkValue()))).booleanValue()) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u6570\u636e\u5df2\u88ab\u201c\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u62a5\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectProposalUnAuditOpPlugin_7", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("billno")), ErrorLevel.Error);
                    }
                }
            }
        });
    }
}

