/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.claim;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.SynFunSourceHelper;
import kd.pmgt.pmim.common.enums.ClaimTypeEnum;
import kd.pmgt.pmim.common.enums.InvestConclusionEnum;
import kd.pmgt.pmim.common.enums.InvestCycleEnum;

public class InvestPlanClaimOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("investcycle");
        fields.add("yearperiod");
        fields.add("monthperiod");
        fields.add("projectentry");
        fields.add("entryinvesttype");
        fields.add("preentryid");
        fields.add("sourceentryid");
        fields.add("isvalid");
        fields.add("finalstate");
        fields.add("entryinvesttype");
        fields.add("project");
        fields.add("conclusion");
        fields.add("claimtype");
        fields.add("suporg");
        fields.add("islatest");
        fields.add("investentry");
        fields.add("scale");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                this.audit(dataEntities);
                break;
            }
            case "unaudit": {
                this.unaudit(dataEntities);
                break;
            }
        }
    }

    private void unaudit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection projectEntryCol = bill.getDynamicObjectCollection("projectentry");
            Date yearPeriod = bill.getDate("yearperiod");
            projectEntryCol.forEach(projectEntryObj -> {
                String preEntryId = projectEntryObj.getString("preentryid");
                projectEntryObj.set("isvalid", (Object)Boolean.FALSE);
                projectEntryObj.set("islatest", (Object)Boolean.FALSE);
                if (preEntryId != null && StringUtils.isNotEmpty((String)preEntryId) && QueryServiceHelper.exists((String)"pmim_invesclaimtrecord", (Object)preEntryId)) {
                    DynamicObject preProEntry = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(preEntryId), (String)"pmim_invesclaimtrecord");
                    preProEntry.set("isvalid", (Object)Boolean.TRUE);
                    preProEntry.set("islatest", (Object)Boolean.TRUE);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{preProEntry});
                }
                String conclusion = (String)projectEntryObj.get("conclusion");
                if (InvestConclusionEnum.Pass.getValue().equals(conclusion)) {
                    DynamicObject project = projectEntryObj.getDynamicObject("project");
                    SynFunSourceHelper.deleteFunSource((DynamicObject)project, (Date)yearPeriod);
                    if (preEntryId != null && StringUtils.isNotEmpty((String)preEntryId) && QueryServiceHelper.exists((String)"pmim_invesclaimtrecord", (Object)preEntryId)) {
                        DynamicObject investClaimRecord = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(preEntryId), (String)"pmim_invesclaimtrecord");
                        SynFunSourceHelper.createFunSource((DynamicObject)investClaimRecord, (Date)yearPeriod, (String)"pmim_invesclaimtrecord");
                    } else {
                        DynamicObject approvePro = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()))});
                        if (approvePro != null) {
                            Date applyDate = (approvePro = BusinessDataServiceHelper.loadSingle((Object)approvePro.getPkValue(), (String)"pmas_pro_approval")).getDate("projectapplydate");
                            if (applyDate == null) {
                                applyDate = approvePro.getDate("createtime");
                            }
                            LocalDate localApplyDate = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            LocalDate localPeriodDate = yearPeriod.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            if (localApplyDate != null && localApplyDate.getYear() == localPeriodDate.getYear()) {
                                SynFunSourceHelper.createFunSource((DynamicObject)approvePro, (Date)yearPeriod, (String)"pmas_pro_approval");
                            }
                        }
                    }
                }
            });
        }
    }

    private void audit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection projectEntryCol = bill.getDynamicObjectCollection("projectentry");
            projectEntryCol.forEach(projectEntryObj -> {
                String claimType = projectEntryObj.getString("claimtype");
                String conclusion = projectEntryObj.getString("conclusion");
                String sourceEntryId = projectEntryObj.getString("sourceentryid");
                if (ClaimTypeEnum.NewInvest.getValue().equals(claimType) && InvestConclusionEnum.Pass.getValue().equals(conclusion)) {
                    projectEntryObj.set("isvalid", (Object)Boolean.TRUE);
                    projectEntryObj.set("finalstate", (Object)"pass");
                }
                if ((ClaimTypeEnum.AdjustInvest.getValue().equals(claimType) || ClaimTypeEnum.ContinueInvest.getValue().equals(claimType)) && InvestConclusionEnum.Pass.getValue().equals(conclusion)) {
                    projectEntryObj.set("isvalid", (Object)Boolean.TRUE);
                    projectEntryObj.set("finalstate", (Object)"pass");
                    Long curEntryId = projectEntryObj.getLong("id");
                    QFilter entryIdFilter = new QFilter("id", "!=", (Object)curEntryId);
                    QFilter sourceEntryFilter = new QFilter("sourceentryid", "=", (Object)sourceEntryId);
                    DynamicObject[] entryCol = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"sourceentryid,isvalid", (QFilter[])new QFilter[]{entryIdFilter, sourceEntryFilter});
                    if (entryCol.length > 0) {
                        for (DynamicObject entryObj : entryCol) {
                            entryObj.set("isvalid", (Object)Boolean.FALSE);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])entryCol);
                }
            });
            if (projectEntryCol.isEmpty()) continue;
            int size = projectEntryCol.size();
            DynamicObject[] investClaimRecordArr = new DynamicObject[size];
            Date yearPeriod = bill.getDate("yearperiod");
            for (int i = 0; i < size; ++i) {
                DynamicObject proEntryObj = (DynamicObject)projectEntryCol.get(i);
                Long entryId = proEntryObj.getLong("id");
                DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"pmim_invesclaimtrecord");
                record.set("islatest", (Object)Boolean.TRUE);
                investClaimRecordArr[i] = record;
                String finalState = proEntryObj.getString("finalstate");
                if (!"pass".equals(finalState)) continue;
                DynamicObject project = proEntryObj.getDynamicObject("project");
                SynFunSourceHelper.deleteFunSource((DynamicObject)project, (Date)yearPeriod);
                SynFunSourceHelper.createFunSource((DynamicObject)record, (Date)yearPeriod, (String)"pmim_invesclaimtrecord");
            }
            SaveServiceHelper.save((DynamicObject[])investClaimRecordArr);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isSubmit = false;
        boolean isUnaudit = false;
        boolean isSave = false;
        boolean isAudit = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if ("submit".equals(key)) {
                isSubmit = true;
                continue;
            }
            if ("unaudit".equals(key)) {
                isUnaudit = true;
                continue;
            }
            if ("save".equals(key)) {
                isSave = true;
                continue;
            }
            if (!"audit".equals(key)) continue;
            isAudit = true;
        }
        if (isSave) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        String errMsg = InvestPlanClaimOp.this.isProjectExistValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            });
        } else if (isSubmit) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        String errMsg = InvestPlanClaimOp.this.submitValidate(dataEntity.getDataEntity());
                        if (errMsg != null) {
                            this.addErrorMessage(dataEntity, errMsg);
                            return;
                        }
                        errMsg = InvestPlanClaimOp.this.isProjectExistValidate(dataEntity.getDataEntity());
                        if (errMsg != null) {
                            this.addErrorMessage(dataEntity, errMsg);
                            return;
                        }
                        errMsg = InvestPlanClaimOp.this.hundredScaleValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addWarningMessage(dataEntity, errMsg);
                    }
                }
            });
        } else if (isUnaudit) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String errMsg = InvestPlanClaimOp.this.unAuditValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            });
        } else if (isAudit) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String errMsg = InvestPlanClaimOp.this.auditValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addWarningMessage(dataEntity, errMsg);
                    }
                }
            });
        }
    }

    private String auditValidate(DynamicObject bill) {
        DynamicObjectCollection projectEntries = bill.getDynamicObjectCollection("projectentry");
        Date yearPeriod = bill.getDate("yearperiod");
        for (DynamicObject proEntryObj : projectEntries) {
            String conclusion = proEntryObj.getString("conclusion");
            if (!InvestConclusionEnum.Pass.getValue().equals(conclusion)) continue;
            LocalDate localDate = yearPeriod.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)localDate.getYear());
            DynamicObject project = proEntryObj.getDynamicObject("project");
            qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            DynamicObject[] oldFunSources = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (oldFunSources.length <= 0) continue;
            return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201c\u5df2\u5b58\u5728\u5f53\u524d\u5e74\u5ea6\u7684\u8d44\u91d1\u6765\u6e90\u6570\u636e\uff0c\u5c06\u4ee5\u6700\u65b0\u6570\u636e\u8fdb\u884c\u66ff\u6362\u3002", (String)"InvestPlanClaimOp_37", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name"));
        }
        return null;
    }

    private String hundredScaleValidate(DynamicObject dataEntity) {
        DynamicObjectCollection projectEntries = dataEntity.getDynamicObjectCollection("projectentry");
        StringBuilder scaleStrBuf = new StringBuilder();
        for (DynamicObject projectEntryObj : projectEntries) {
            DynamicObject project = projectEntryObj.getDynamicObject("project");
            BigDecimal totalScale = BigDecimal.ZERO;
            DynamicObjectCollection investEntries = projectEntryObj.getDynamicObjectCollection("investentry");
            for (DynamicObject investEntry : investEntries) {
                totalScale = totalScale.add(investEntry.getBigDecimal("scale"));
            }
            if (NumberHelper.compareValue((Object)100, (Object)totalScale) == 0 || null == project) continue;
            scaleStrBuf.append(project.getString("name")).append(',');
        }
        if (scaleStrBuf.length() > 1) {
            String errMsg = scaleStrBuf.substring(0, scaleStrBuf.length() - 1);
            return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u201c\u9879\u76ee\u6295\u8d44\u8be6\u60c5\u201d\u5360\u6bd4\u5408\u8ba1\u4e3a\u201c%2$s\u201d\uff0c\u5e94\u7b49\u4e8e100\u3002", (String)"InvestPlanClaimOp_38", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), errMsg, "%");
        }
        return null;
    }

    private String isProjectExistValidate(DynamicObject bill) {
        DynamicObjectCollection projectEntryCol = bill.getDynamicObjectCollection("projectentry");
        Long billId = bill.getLong("id");
        for (DynamicObject projectEntryObj : projectEntryCol) {
            QFilter billIdFilter;
            String claimType = projectEntryObj.getString("claimtype");
            DynamicObject project = projectEntryObj.getDynamicObject("project");
            String projectName = project.getString("name");
            Long projectId = project.getLong("id");
            if (StringUtils.isNotEmpty((String)claimType) && claimType.equals(ClaimTypeEnum.NewInvest.getValue())) {
                QFilter billIdFilter2 = new QFilter("billid", "!=", (Object)billId);
                QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
                DynamicObject[] investRecord = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"project", (QFilter[])new QFilter[]{billIdFilter2, projectFilter});
                if (investRecord.length <= 0) continue;
                return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u5df2\u88ab\u5176\u4ed6\u6295\u8d44\u7533\u62a5\u5355\u5f15\u7528\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"InvestPlanClaimOp_39", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectName);
            }
            String preId = projectEntryObj.getString("preentryid");
            QFilter preEntryFilter = new QFilter("preentryid", "=", (Object)preId);
            DynamicObject[] preProEntries = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"id,billid,sourcebilltype", (QFilter[])new QFilter[]{preEntryFilter, billIdFilter = new QFilter("billid", "!=", (Object)billId)});
            if (preProEntries.length <= 0) continue;
            String billName = "";
            DynamicObject preProEntry = preProEntries[0];
            String sourceBillType = preProEntry.getString("sourcebilltype");
            billId = preProEntry.getLong("billid");
            String errorMsg = "";
            if ("investplanclaim".equals(sourceBillType)) {
                DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_investplanclaim");
                errorMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee%1$s\u5df2\u88ab\u6295\u8d44\u8ba1\u5212\u7533\u62a5\u5355\u7f16\u7801\u4e3a\uff1a%2$s\u8c03\u6574\u6295\u8d44\u6216\u7ee7\u7eed\u6295\u8d44\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvestPlanClaimOp_35", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectName, usedBill.getString("billno"));
            } else {
                DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_specialapproval");
                errorMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee%1$s\u5df2\u88ab\u6295\u8d44\u8ba1\u5212\u5ba1\u6279\u5355\u7f16\u7801\u4e3a\uff1a%2$s\u8c03\u6574\u6295\u8d44\u6216\u7ee7\u7eed\u6295\u8d44\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvestPlanClaimOp_36", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectName, usedBill.getString("billno"));
            }
            return errorMsg;
        }
        return null;
    }

    private String unAuditValidate(DynamicObject bill) {
        DynamicObjectCollection projectEntryCol = bill.getDynamicObjectCollection("projectentry");
        for (DynamicObject projectEntryObj : projectEntryCol) {
            Long projectId;
            DynamicObject project;
            String statusNum;
            DynamicObject entryProject = projectEntryObj.getDynamicObject("project");
            String curEntryId = projectEntryObj.getString("id");
            QFilter preEntryFilter = new QFilter("preentryid", "=", (Object)curEntryId);
            DynamicObject[] preProEntries = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"id,billid,sourcebilltype,claimtype", (QFilter[])new QFilter[]{preEntryFilter});
            if (preProEntries.length > 0) {
                String projectName = entryProject.getString("name");
                String billName = "";
                DynamicObject preProEntry = preProEntries[0];
                String sourceBillType = preProEntry.getString("sourcebilltype");
                Long billId = preProEntry.getLong("billid");
                if ("investplanclaim".equals(sourceBillType)) {
                    String claimType = preProEntry.getString("claimtype");
                    if ("adjustinvest".equals(claimType)) {
                        return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u5e74\u5ea6\u6295\u8d44\u8ba1\u5212\u5df2\u5b58\u5728\u8c03\u6574\u6295\u8d44\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestPlanClaimOp_40", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectName);
                    }
                    if ("continueinvest".equals(claimType)) {
                        return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u5e74\u5ea6\u6295\u8d44\u8ba1\u5212\u5df2\u5b58\u5728\u7ee7\u7eed\u6295\u8d44\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestPlanClaimOp_41", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectName);
                    }
                } else {
                    DynamicObject usedBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_specialapproval");
                    billName = billName + String.format(ResManager.loadKDString((String)"\u6295\u8d44\u8ba1\u5212\u4e13\u9879\u5ba1\u6279\u5355\u201c%s\u201d ", (String)"InvestPlanClaimOp_29", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), usedBill.getString("billno"));
                    return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u5e74\u5ea6\u6295\u8d44\u8ba1\u5212\u5df2\u88ab\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InvestPlanClaimOp_42", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectName, billName.substring(0, billName.length() - 1));
                }
            }
            if ("FINANCIALCLOSURE_S".equals(statusNum = (project = BusinessDataServiceHelper.loadSingle((Object)(projectId = Long.valueOf(entryProject.getLong("id"))), (String)"bd_project", (String)"name,prostatus")).getDynamicObject("prostatus").getString("number"))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u72b6\u6001\u4e3a\u201c\u8d22\u52a1\u5173\u95ed\u201d\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"InvestPlanClaimOp_43", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name"));
                return errorMsg;
            }
            String conclusion = projectEntryObj.getString("conclusion");
            if (!InvestConclusionEnum.ReportSup.getValue().equals(conclusion)) continue;
            QFilter entryIdFilter = new QFilter("id", "=", (Object)projectEntryObj.getLong("id"));
            QFilter sourceBillTypeFilter = new QFilter("sourcebilltype", "=", (Object)"specicalapproval");
            DynamicObject[] specialEntries = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)"id", (QFilter[])new QFilter[]{entryIdFilter, sourceBillTypeFilter});
            if (specialEntries.length <= 0) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u6295\u8d44\u8ba1\u5212\u5df2\u88ab\u4e0a\u7ea7\u7ec4\u7ec7\u5ba1\u6279\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"InvestPlanClaimOp_44", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name"));
            return errorMsg;
        }
        return null;
    }

    private String submitValidate(DynamicObject bill) {
        String errMsg;
        String investCycle = bill.getString("investcycle");
        Date investPeriod = InvestCycleEnum.Year.getValue().equals(investCycle) ? bill.getDate("yearperiod") : bill.getDate("monthperiod");
        if (investPeriod == null) {
            return ResManager.loadKDString((String)"\u6295\u8d44\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvestPlanClaimOp_45", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection projectEntries = bill.getDynamicObjectCollection("projectentry");
        if (projectEntries.size() == 0) {
            return ResManager.loadKDString((String)"\u6295\u8d44\u9879\u76ee\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvestPlanClaimOp_46", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]);
        }
        StringBuilder conclusionStrBuf = new StringBuilder();
        StringBuilder supOrgStrBuf = new StringBuilder();
        for (DynamicObject projectEntryObj : projectEntries) {
            if (projectEntryObj.getString("conclusion") == null) {
                conclusionStrBuf.append(projectEntryObj.getDynamicObject("project").getString("name")).append(',');
                continue;
            }
            if (!InvestConclusionEnum.ReportSup.getValue().equals(projectEntryObj.getString("conclusion")) || projectEntryObj.getDynamicObject("suporg") != null) continue;
            supOrgStrBuf.append(projectEntryObj.getDynamicObject("project").getString("name")).append(',');
        }
        if (conclusionStrBuf.length() > 1) {
            errMsg = conclusionStrBuf.substring(0, conclusionStrBuf.length() - 1);
            return String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9879\u76ee\u201c%s\u201d\u7684\u6295\u8d44\u8be6\u60c5\u5206\u5f55\u4e2d\u7684\u5ba1\u6279\u7ed3\u8bba\u662f\u5426\u5df2\u586b\u5199\u3002", (String)"InvestPlanClaimOp_47", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), errMsg);
        }
        if (supOrgStrBuf.length() > 1) {
            errMsg = supOrgStrBuf.substring(0, conclusionStrBuf.length() - 2);
            return String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u4e0a\u62a5\u4e0a\u7ea7\u201d\uff0c\u4e0a\u62a5\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"InvestPlanClaimOp_48", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), errMsg);
        }
        return null;
    }
}

