/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.opplugin.validator;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmbs.common.enums.DocuimentTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;

public class AunualinvesPlantOpValidator
extends AbstractValidator {
    private static String investBudgeConWay1 = "remindercontrol";
    private static String investBudgeConWay2 = "strictcontrol";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String key = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isInWorkflow = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)bill.getPkValue().toString()));
            DynamicObjectCollection investEntry = bill.getDynamicObjectCollection("inventry");
            if ("submit".equals(key) || "audit".equals(key) || isInWorkflow) {
                if (StringUtils.isEmpty((CharSequence)bill.getString("billno"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AunualinvesPlantOpValidator_23", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((CharSequence)bill.getString("billname"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AunualinvesPlantOpValidator_24", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                }
                if (null == bill.getDate("year")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u62a5\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AunualinvesPlantOpValidator_25", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                }
                if (null != investEntry && investEntry.size() > 0) {
                    for (int i = 0; i < investEntry.size(); ++i) {
                        String errMsg;
                        String errMsg2;
                        boolean isExistF7;
                        long investListId;
                        DynamicObject projectKind;
                        DynamicObject entry = (DynamicObject)investEntry.get(i);
                        DynamicObject projectBill = entry.getDynamicObject("projectno");
                        String approvalCon = entry.getString("inventry_approvalcon");
                        String projectType = entry.getString("projecttype");
                        DynamicObject reportOrg = entry.getDynamicObject("inventry_reportorg");
                        if ("report".equals(approvalCon) && null == reportOrg) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6295\u8d44\u6e05\u5355\u7684\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u4e0a\u62a5\u201d\uff0c\u4e0a\u62a5\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"AunualinvesPlantOpValidator_26", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                        }
                        if ("bd_project".equals(projectType) && "unpass".equals(approvalCon) && "audit".equals(key)) {
                            this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684%2$s\u9879\u76ee\u5e74\u5ea6\u9884\u7b97\u5df2\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\uff0c\u662f\u5426\u5c06\u8be5\u9879\u76ee\u6682\u505c\uff1f", (String)"AunualinvesPlantOpValidator_28", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), i + 1, projectBill.getString("name")));
                        }
                        if ((projectKind = entry.getDynamicObject("inventry_projectkind")) != null) {
                            String projectNumber = "bd_project".equals(projectType) ? projectBill.getString("number") : projectBill.getString("number");
                            QFilter qFilter = new QFilter("projectkind", "=", (Object)Long.parseLong(projectKind.getPkValue().toString()));
                            DynamicObject projectKindSet = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"investbudgeconamt", (QFilter[])new QFilter[]{qFilter});
                            if (projectKindSet != null) {
                                String investBudgeConModel = projectKindSet.getString("investbudgeconamt");
                                BigDecimal anlInvestDeclareAmt = entry.getBigDecimal("inventry_anlinvesdeclamt");
                                BigDecimal approveAmt = entry.getBigDecimal("inventry_approveamt");
                                if (approveAmt.compareTo(anlInvestDeclareAmt) > 0) {
                                    if (investBudgeConWay1.equals(investBudgeConModel)) {
                                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u6279\u590d\u989d\u5df2\u8d85\u51fa\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u62a5\u989d\u3002", (String)"AunualinvesPlantOpValidator_37", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), bill.getString("billno"), projectNumber));
                                    } else if (investBudgeConWay2.equals(investBudgeConModel)) {
                                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u6279\u590d\u989d\u5df2\u8d85\u51fa\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u62a5\u989d\u3002", (String)"AunualinvesPlantOpValidator_37", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), bill.getString("billno"), projectNumber));
                                    }
                                }
                                BigDecimal anFinaExBudgeAmt = entry.getBigDecimal("inventry_anfinaexbuddeamt");
                                BigDecimal finaApproveAmt = entry.getBigDecimal("inventry_finanapproveamt");
                                if (finaApproveAmt.compareTo(anFinaExBudgeAmt) > 0) {
                                    if (investBudgeConWay1.equals(investBudgeConModel)) {
                                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u5e74\u5ea6\u8d22\u52a1\u652f\u51fa\u9884\u7b97\u6279\u590d\u989d\u5df2\u8d85\u51fa\u5e74\u5ea6\u8d22\u52a1\u652f\u51fa\u9884\u7b97\u7533\u62a5\u989d\u3002", (String)"AunualinvesPlantOpValidator_38", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), bill.getString("billno"), projectNumber));
                                    } else if (investBudgeConWay2.equals(investBudgeConModel)) {
                                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u5e74\u5ea6\u8d22\u52a1\u652f\u51fa\u9884\u7b97\u6279\u590d\u989d\u5df2\u8d85\u51fa\u5e74\u5ea6\u8d22\u52a1\u652f\u51fa\u9884\u7b97\u7533\u62a5\u989d\u3002", (String)"AunualinvesPlantOpValidator_38", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), bill.getString("billno"), projectNumber));
                                    }
                                }
                            }
                        }
                        if ((investListId = entry.getLong("inventry_investlistid")) == 0L || !"submit".equals(key) || !(isExistF7 = QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)investListId))) continue;
                        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)investListId, (String)"pmim_projectproposal_f7");
                        if ("projectProposal".equals(projectProposal.getString("datasource"))) {
                            if (projectProposal.getBoolean("isquote")) {
                                errMsg2 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bae\u4e66\uff1a\u201c%s\u201d\u5df2\u7533\u62a5\u9884\u7b97\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u62a5\u3002", (String)"AunualinvesPlantOpValidator_29", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("number"));
                                this.addErrorMessage(dataEntity, errMsg2);
                            }
                        } else if ("project".equals(projectProposal.getString("datasource"))) {
                            if (projectProposal.getBoolean("accepted")) {
                                errMsg2 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u9884\u7b97\u7533\u62a5\u5df2\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u3002", (String)"AunualinvesPlantOpValidator_30", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("number"));
                                this.addErrorMessage(dataEntity, errMsg2);
                            }
                        } else if (projectProposal.getBoolean("accepted")) {
                            errMsg2 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bae\u4e66\uff1a\u201c%s\u201d\u7684\u9884\u7b97\u7533\u62a5\u5df2\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u3002", (String)"AunualinvesPlantOpValidator_7", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("number"));
                            this.addErrorMessage(dataEntity, errMsg2);
                        }
                        QFilter qFilter = new QFilter("inventry.id", "=", (Object)investListId);
                        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)String.join((CharSequence)",", "billstatus", "billno", "docuimenttype"), (QFilter[])new QFilter[]{qFilter});
                        if (sourceBill == null || sourceBill.getString("billstatus").equals("D")) continue;
                        if (DocuimentTypeEnum.DECLARE.getValue().equals(sourceBill.getString("docuimenttype"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bae\u4e66\u201c%1$s\u201d\u6240\u5728\u7684\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u7533\u62a5\u201c%2$s\u201d\u5df2\u53d6\u6d88\u4e0a\u62a5\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"AunualinvesPlantOpValidator_31", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("number"), sourceBill.getString("billno"));
                            this.addErrorMessage(dataEntity, errMsg);
                            continue;
                        }
                        errMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bae\u4e66\u201c%1$s\u201d\u6240\u5728\u7684\u6295\u8d44\u9884\u7b97\u4e13\u9879\u7533\u62a5\u201c%2$s\u201d\u5df2\u53d6\u6d88\u4e0a\u62a5\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"AunualinvesPlantOpValidator_32", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), projectProposal.getString("number"), sourceBill.getString("billno"));
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                    continue;
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6295\u8d44\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AunualinvesPlantOpValidator_27", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"unaudit".equals(key) || null == investEntry || investEntry.size() <= 0) continue;
            QFilter qFilter = new QFilter("investbudgetplan", "=", (Object)bill.getPkValue().toString());
            DynamicObject[] budgetBases = BusinessDataServiceHelper.load((String)"pmim_budgetbase", (String)"id", (QFilter[])new QFilter[]{qFilter});
            Set budgetBaseIds = Arrays.stream(budgetBases).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toSet());
            qFilter = new QFilter("bugproname", "in", budgetBaseIds);
            DynamicObject[] approvals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"billno", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject approval : approvals) {
                String approvalBillNo = approval.getString("billno");
                String planBillNo = bill.getString("billno");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u88ab\u9879\u76ee\u7acb\u9879\u201c%2$s\u201d\u4f7f\u7528\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"AunualinvesPlantOpValidator_33", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), planBillNo, approvalBillNo));
            }
            for (DynamicObject entry : investEntry) {
                DynamicObject project;
                String approvalCon = entry.getString("inventry_approvalcon");
                String projectType = entry.getString("projecttype");
                if (!"bd_project".equals(projectType) || (project = entry.getDynamicObject("projectno")) == null) continue;
                DynamicObject proStatus = (project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project")).getDynamicObject("prostatus");
                if (proStatus != null && !StringUtils.equals((CharSequence)proStatus.getPkValue().toString(), (CharSequence)ProjectStatusEnum.SUSPEND.getId()) && "unpass".equals(approvalCon)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u72b6\u6001\u5df2\u53d8\u66f4\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"AunualinvesPlantOpValidator_34", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name"), proStatus.getString("name")));
                }
                if (!"pass".equals(approvalCon)) continue;
                qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                qFilter.and("year", ">", (Object)bill.getDate("year"));
                DynamicObject[] funSources = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"year", (QFilter[])new QFilter[]{qFilter});
                if (funSources.length > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5b58\u5728\u5927\u4e8e\u5f53\u524d\u7533\u62a5\u5e74\u5ea6\u7684\u8d44\u91d1\u6765\u6e90\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"AunualinvesPlantOpValidator_35", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name")));
                }
                qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                LocalDate curYear = bill.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                funSources = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"createtime", (QFilter[])new QFilter[]{qFilter}, (String)" createtime desc");
                if (funSources.length <= 0) continue;
                DynamicObject funSource = funSources[0];
                Date createTime = funSource.getDate("createtime");
                Date declareAuditDate = bill.getDate("auditdate");
                if (createTime == null || declareAuditDate == null || !createTime.after(declareAuditDate)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u6700\u65b0\u7248\u672c\u8d44\u91d1\u6765\u6e90\u6570\u636e\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"AunualinvesPlantOpValidator_36", (String)"pmgt-pmim-opplugin", (Object[])new Object[0]), project.getString("name")));
            }
        }
    }
}

