/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.DocuimentTypeEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmas.CapitalTypeEnum;
import kd.pmgt.pmbs.common.utils.coderule.CodeRuleHelper;
import kd.pmgt.pmim.business.helper.ProjectProposalHelper;

public class AunualinvesPlanHelper {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");

    public void syncProjectProposalF7(DynamicObject annualInvestPlan) {
        DynamicObjectCollection entries = annualInvestPlan.getDynamicObjectCollection("inventry");
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (DynamicObject entry : entries) {
            String approvalCon;
            Date curDate;
            DynamicObject projectBill;
            DynamicObject bill;
            String projectType = entry.getString("projecttype");
            if ("bd_project".equals(projectType) && (bill = AunualinvesPlanHelper.createBackupsFunSource(projectBill = entry.getDynamicObject("projectno"), curDate = annualInvestPlan.getDate("year"))) != null) {
                bills.add(bill);
            }
            if (!"report".equals(approvalCon = entry.getString("inventry_approvalcon"))) {
                long billId;
                boolean exists;
                if (StringUtils.isBlank((CharSequence)entry.getString("inventry_investlistid")) || !(exists = QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)(billId = entry.getLong("inventry_investlistid"))))) continue;
                DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_projectproposal_f7");
                if ("pass".equals(approvalCon)) {
                    projectProposal.set("budgetapplyresult", (Object)"PASS");
                    projectProposal.set("approvalcon", (Object)"pass");
                    projectProposal.set("auditorg", (Object)annualInvestPlan.getDynamicObject("org"));
                    projectProposal.set("yearbugappamt", (Object)entry.getBigDecimal("inventry_approveamt"));
                    projectProposal.set("yearfiappamt", (Object)entry.getBigDecimal("inventry_finanapproveamt"));
                    projectProposal.set("accepted", (Object)Boolean.TRUE);
                } else if ("unpass".equals(approvalCon)) {
                    projectProposal.set("budgetapplyresult", (Object)"NO_PASS");
                    projectProposal.set("approvalcon", (Object)"unpass");
                    projectProposal.set("auditorg", (Object)annualInvestPlan.getDynamicObject("org"));
                    projectProposal.set("yearbugappamt", (Object)BigDecimal.ZERO);
                    projectProposal.set("yearfiappamt", (Object)BigDecimal.ZERO);
                    projectProposal.set("accepted", (Object)Boolean.TRUE);
                }
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{projectProposal});
                continue;
            }
            MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"pmim_projectproposal_f7");
            bill = new DynamicObject((DynamicObjectType)dynamicObjectType);
            DynamicObject projectBill2 = entry.getDynamicObject("projectno");
            if ("bd_project".equals(projectType)) {
                projectBill2 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectBill2.getPkValue().toString()), (String)"bd_project");
                bill.set("number", (Object)projectBill2.getString("number"));
                bill.set("name", (Object)projectBill2.getString("name"));
                bill.set("project", (Object)projectBill2);
                bill.set("datasource", (Object)"project");
            } else {
                projectBill2 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectBill2.getPkValue().toString()), (String)"pmim_projectproposal");
                bill.set("number", (Object)projectBill2.getString("billno"));
                bill.set("name", (Object)projectBill2.getString("billname"));
                bill.set("projectproposalid", projectBill2.getPkValue());
                bill.set("datasource", (Object)"inveslist");
            }
            bill.set("approvalcon", (Object)"report");
            bill.set("declaretype", entry.get("inventry_declaretype"));
            bill.set("projectkind", entry.get("inventry_projectkind"));
            bill.set("enable", (Object)"1");
            bill.set("status", (Object)"C");
            bill.set("reportbudget", (Object)false);
            String investListId = entry.getString("inventry_investlistid");
            if (StringUtils.isNotBlank((CharSequence)investListId) && QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)investListId)) {
                DynamicObject projectProposalF7 = BusinessDataServiceHelper.loadSingle((Object)investListId, (String)"pmim_projectproposal_f7");
                BigDecimal version = projectProposalF7.getBigDecimal("version");
                bill.set("version", (Object)version.add(BigDecimal.valueOf(0.001)));
            } else {
                bill.set("version", (Object)BigDecimal.ONE);
            }
            bill.set("org", (Object)annualInvestPlan.getDynamicObject("org"));
            bill.set("year", (Object)annualInvestPlan.getDate("year"));
            bill.set("reportorg", (Object)entry.getDynamicObject("inventry_reportorg"));
            bill.set("auditorg", (Object)entry.getDynamicObject("inventry_reportorg"));
            bill.set("sourceorg", (Object)annualInvestPlan.getDynamicObject("org"));
            bill.set("accepted", (Object)false);
            bill.set("id", (Object)Long.parseLong(entry.getPkValue().toString()));
            bill.set("investlistid", (Object)entry.getLong("inventry_investlistid"));
            bill.set("oriannualincest", (Object)entry.getBigDecimal("inventry_oriannualincest"));
            bill.set("orifinancialex", (Object)entry.getBigDecimal("inventry_orifinancialex"));
            bill.set("yearbugappamt", (Object)entry.getBigDecimal("inventry_approveamt"));
            bill.set("yearfiappamt", (Object)entry.getBigDecimal("inventry_finanapproveamt"));
            bill.set("arrearsamt", (Object)entry.getBigDecimal("inventry_arrearsamt"));
            bill.set("lastyearbugamt", (Object)entry.getBigDecimal("inventry_lastyearbugamt"));
            bill.set("lastyearfiamt", (Object)entry.getBigDecimal("inventry_lastyearfiamt"));
            bill.set("currency", (Object)entry.getDynamicObject("inventry_currency"));
            bill.set("createtime", (Object)new Date());
            DynamicObjectCollection funSources = entry.getDynamicObjectCollection("funsourceentry");
            if (funSources.size() > 0) {
                DynamicObjectCollection sourceEntry = bill.getDynamicObjectCollection("funsourceentry");
                sourceEntry.clear();
                funSources.forEach(funSource -> {
                    DynamicObject source = sourceEntry.addNew();
                    source.set("seq", (Object)sourceEntry.size());
                    source.set("fundsourcetype", (Object)funSource.getDynamicObject("fundsourcetype"));
                    source.set("investcurrency", (Object)funSource.getDynamicObject("investcurrency"));
                    source.set("entryamt", (Object)funSource.getBigDecimal("entryamt"));
                    source.set("formofinvest", (Object)funSource.getString("formofinvest"));
                    source.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                    source.set("scale", (Object)funSource.getBigDecimal("scale"));
                    source.set("comment", (Object)funSource.getString("comment"));
                });
            }
            bills.add(bill);
        }
        if (bills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject createBackupsFunSource(DynamicObject project, Date curDate) {
        DynamicObjectCollection fundEntry;
        DynamicObject bill = null;
        LocalDate curYear = curDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
        qFilter.and("datasource", "=", (Object)"fundsource");
        DynamicObject poSalF7 = BusinessDataServiceHelper.loadSingle((String)"pmim_projectproposal_f7", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (poSalF7 != null) {
            return null;
        }
        qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
        DynamicObject funSourceBill = BusinessDataServiceHelper.loadSingle((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (funSourceBill != null && (fundEntry = (funSourceBill = BusinessDataServiceHelper.loadSingle((Object)funSourceBill.getPkValue(), (String)"pmas_projfundsource")).getDynamicObjectCollection("fundentry")).size() > 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmim_projectproposal_f7");
            bill = new DynamicObject((DynamicObjectType)dt);
            bill.set("project", (Object)project);
            bill.set("year", (Object)curDate);
            bill.set("datasource", (Object)"fundsource");
            bill.set("version", (Object)funSourceBill.getBigDecimal("version"));
            bill.set("yearbugappamt", (Object)funSourceBill.getBigDecimal("yearbudgetapproveamt"));
            bill.set("yearbugamt", (Object)funSourceBill.getBigDecimal("totalamount"));
            bill.set("totaloldamount", (Object)funSourceBill.getBigDecimal("totaloldamount"));
            bill.set("totaldiffamount", (Object)funSourceBill.getBigDecimal("totaldiffamount"));
            DynamicObjectCollection funSourceEntry = bill.getDynamicObjectCollection("funsourceentry");
            funSourceEntry.clear();
            fundEntry.forEach(funSource -> {
                DynamicObject entry = funSourceEntry.addNew();
                entry.set("fundsourcetype", (Object)funSource.getDynamicObject("sourcetype"));
                entry.set("investcurrency", (Object)funSource.getDynamicObject("investcurrency"));
                entry.set("entryamt", (Object)funSource.getBigDecimal("amount"));
                entry.set("formofinvest", (Object)funSource.getString("formofinvest"));
                entry.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                entry.set("scale", (Object)funSource.getBigDecimal("scale"));
                entry.set("comment", (Object)funSource.getString("note"));
                entry.set("oldamount", (Object)funSource.getBigDecimal("oldamount"));
                entry.set("diffamount", (Object)funSource.getBigDecimal("diffamount"));
            });
        }
        return bill;
    }

    public void synProjectProposal(DynamicObject annualInvestPlan, String operationKey) {
        DynamicObjectCollection entries = annualInvestPlan.getDynamicObjectCollection("inventry");
        boolean isInPlan = StringUtils.equals((CharSequence)DocuimentTypeEnum.DECLARE.getValue(), (CharSequence)annualInvestPlan.getString("docuimenttype"));
        HashSet projectProposalPKSet = new HashSet();
        entries.forEach(entry -> {
            this.syncInvestList(annualInvestPlan, (DynamicObject)entry, operationKey);
            String approvalCon = entry.getString("inventry_approvalcon");
            String declareType = entry.getString("inventry_declaretype");
            if ("pass".equals(approvalCon) && "addnew".equals(declareType)) {
                DynamicObject projectProposal = entry.getDynamicObject("projectno");
                projectProposalPKSet.add(Long.parseLong(projectProposal.getPkValue().toString()));
            }
        });
        if (!projectProposalPKSet.isEmpty()) {
            ArrayList<DynamicObject> projectProposalList = new ArrayList<DynamicObject>(projectProposalPKSet.size());
            for (Long projectProposalPK : projectProposalPKSet) {
                DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)projectProposalPK, (String)"pmim_projectproposal");
                ProjectProposalHelper.updateSumAppAmt(projectProposal);
                for (DynamicObject entry2 : entries) {
                    DynamicObject projectNo = entry2.getDynamicObject("projectno");
                    if (projectNo == null || Long.parseLong(projectNo.getPkValue().toString()) != projectProposalPK) continue;
                    projectProposal.set("projectstatus", entry2.get("industrykind"));
                    projectProposal.set("investdirection", entry2.get("investdirection"));
                    projectProposal.set("investkind", entry2.get("investkind"));
                    String projectArea = entry2.getString("overseapro");
                    if (StringUtils.equals((CharSequence)"0", (CharSequence)projectArea)) {
                        projectProposal.set("projectarea", (Object)"province");
                    } else if (StringUtils.equals((CharSequence)"1", (CharSequence)projectArea)) {
                        projectProposal.set("projectarea", (Object)"abroad");
                    } else {
                        projectProposal.set("projectarea", (Object)"outsideprovince");
                    }
                    projectProposal.set("proinplan", (Object)isInPlan);
                    projectProposal.set("approvalstatus", (Object)true);
                    projectProposal.set("approvaltime", (Object)new Date());
                    projectProposal.set("yearbugamt", (Object)entry2.getBigDecimal("inventry_anlinvesdeclamt"));
                    projectProposal.set("projcetbugamt", (Object)entry2.getBigDecimal("projcetbugamt"));
                    String approvalCon = entry2.getString("inventry_approvalcon");
                    if (!StringUtils.equals((CharSequence)"pass", (CharSequence)approvalCon)) continue;
                    projectProposal.set("proinvestbudappamt", (Object)entry2.getBigDecimal("projcetbugappamt"));
                    projectProposal.set("yearbugapprovalamt", (Object)entry2.getBigDecimal("inventry_approveamt"));
                }
                projectProposalList.add(projectProposal);
            }
            SaveServiceHelper.update((DynamicObject[])projectProposalList.toArray(new DynamicObject[0]));
        }
    }

    public void syncInvestList(DynamicObject annualInvestPlan, DynamicObject entry, String operation) {
        long billId = entry.getLong("inventry_investlistid");
        boolean isExist = QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)billId);
        if (!isExist) {
            return;
        }
        LocalDate curYear = annualInvestPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_projectproposal_f7");
        String dataSource = projectProposal.getString("datasource");
        String updateSql = "";
        Object[] params = null;
        if ("submit".equals(operation)) {
            updateSql = "projectProposal".equals(dataSource) ? "update t_pmim_pmsgentry set fisquote = 1 where FEntryID = ?" : "update t_pmim_auinvestplanentry set fisaccepted = 1 where FEntryID = ?";
            params = new Object[]{projectProposal.getPkValue()};
        } else if ("unsubmit".equals(operation)) {
            updateSql = "projectProposal".equals(dataSource) ? "update t_pmim_pmsgentry set fisquote = 0 where FEntryID = ?" : "update t_pmim_auinvestplanentry set fisaccepted = 0 where FEntryID = ?";
            params = new Object[]{projectProposal.getPkValue()};
        } else if ("audit".equals(operation)) {
            DynamicObject lastVersion;
            String approvalCon = entry.getString("inventry_approvalcon");
            long projectProposalPK = Long.parseLong(projectProposal.getPkValue().toString());
            if ("inveslist".equals(dataSource) && (lastVersion = this.gainLastVersion(curYear, projectProposal.getString("projectproposalid"))) != null) {
                projectProposalPK = Long.parseLong(lastVersion.getPkValue().toString());
            }
            if ("pass".equals(approvalCon) && !"project".equals(dataSource)) {
                updateSql = "update t_pmim_pmsgentry set fbudgetapplyresult = 'PASS',fauditorg = ?,fyearbugappamt = ?,fyearfiappamt = ? where FEntryID = ?";
                params = new Object[]{annualInvestPlan.getDynamicObject("org").getPkValue(), entry.getBigDecimal("inventry_approveamt"), entry.getBigDecimal("inventry_finanapproveamt"), projectProposalPK};
            } else if ("unpass".equals(approvalCon) && !"project".equals(dataSource)) {
                updateSql = "update t_pmim_pmsgentry set fbudgetapplyresult = 'NO_PASS',fauditorg = ?,fyearbugappamt = ?,fyearfiappamt = ? where FEntryID = ?";
                params = new Object[]{annualInvestPlan.getDynamicObject("org").getPkValue(), BigDecimal.ZERO, BigDecimal.ZERO, projectProposalPK};
            }
        } else if ("unaudit".equals(operation)) {
            long projectProposalPK = Long.parseLong(projectProposal.getPkValue().toString());
            if ("projectProposal".equals(dataSource)) {
                updateSql = "update t_pmim_pmsgentry set fbudgetapplyresult = ' ',fauditorg = 0,fisquote = 0,fyearbugappamt = ?,fyearfiappamt = ? where FEntryID = ?";
                params = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, projectProposalPK};
            } else {
                updateSql = "update t_pmim_auinvestplanentry set fisaccepted = 0 where FEntryID = ?";
                params = new Object[]{projectProposalPK};
                DB.execute((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, (Object[])params);
                params = null;
                if ("inveslist".equals(dataSource)) {
                    DynamicObject lastVersion = this.gainLastVersion(curYear, projectProposal.getString("projectproposalid"));
                    if (lastVersion != null) {
                        projectProposalPK = Long.parseLong(lastVersion.getPkValue().toString());
                    }
                    updateSql = "update t_pmim_pmsgentry set fbudgetapplyresult = ' ',fauditorg = 0,fyearbugappamt = ?,fyearfiappamt = ? where FEntryID = ?";
                    params = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, projectProposalPK};
                }
            }
        }
        if (params != null) {
            DB.execute((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, (Object[])params);
        }
    }

    public void updateProjectProposalF7(DynamicObject annualInvestPlan, String operation) {
        DynamicObjectCollection entries = annualInvestPlan.getDynamicObjectCollection("inventry");
        ArrayList<DynamicObject> projectProposalList = new ArrayList<DynamicObject>(16);
        for (DynamicObject entry : entries) {
            DynamicObject projectProposal;
            if ("report".equals(operation) || "cancelreport".equals(operation)) {
                if (!QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)entry.getPkValue())) continue;
                projectProposal = BusinessDataServiceHelper.loadSingle((Object)entry.getPkValue(), (String)"pmim_projectproposal_f7");
                Boolean idReport = "report".equals(operation) ? Boolean.TRUE : Boolean.FALSE;
                projectProposal.set("reportbudget", (Object)idReport);
                projectProposalList.add(projectProposal);
                continue;
            }
            long billId = entry.getLong("inventry_investlistid");
            boolean isExist = QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)billId);
            if (!isExist) continue;
            projectProposal = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_projectproposal_f7");
            if ("submit".equals(operation)) {
                projectProposal.set("isquote", (Object)true);
                if (!"projectProposal".equals(projectProposal.getString("datasource"))) {
                    projectProposal.set("accepted", (Object)true);
                }
            } else if ("unsubmit".equals(operation) || "unaudit".equals(operation)) {
                projectProposal.set("isquote", (Object)false);
                projectProposal.set("accepted", (Object)false);
                if ("unaudit".equals(operation) && !"projectProposal".equals(projectProposal.getString("datasource"))) {
                    String selectSql = "select fapproveamt,ffinanapproveamt from t_pmim_auinvestplanentry where FEntryID = ? ";
                    Object[] params = new Object[]{Long.parseLong(projectProposal.getPkValue().toString())};
                    List amtList = (List)DB.query((DBRoute)DBRoute.of((String)"cr"), (String)selectSql, (Object[])params, rs -> {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(1);
                        while (rs.next()) {
                            list.add(rs.getBigDecimal("fapproveamt"));
                            list.add(rs.getBigDecimal("ffinanapproveamt"));
                        }
                        return list;
                    });
                    projectProposal.set("yearbugappamt", amtList.get(0));
                    projectProposal.set("yearfiappamt", amtList.get(1));
                    projectProposal.set("budgetapplyresult", (Object)" ");
                    projectProposal.set("auditorg", (Object)0L);
                }
            }
            if (projectProposal != null) {
                projectProposalList.add(projectProposal);
            }
            this.syncInvestList(annualInvestPlan, entry, operation);
        }
        if (projectProposalList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])projectProposalList.toArray(new DynamicObject[0]));
        }
    }

    public void deleteProjectProposalF7(DynamicObject annualInvestPlan) {
        DynamicObjectCollection entries = annualInvestPlan.getDynamicObjectCollection("inventry");
        ArrayList<Long> investListIds = new ArrayList<Long>(entries.size());
        for (DynamicObject entry : entries) {
            if (!"report".equals(entry.getString("inventry_approvalcon"))) continue;
            long billId = Long.parseLong(entry.getPkValue().toString());
            investListIds.add(billId);
        }
        DeleteServiceHelper.delete((String)"pmim_projectproposal_f7", (QFilter[])new QFilter[]{new QFilter("id", "in", investListIds)});
    }

    private DynamicObject gainLastVersion(LocalDate curYear, String projectProposalId) {
        QFilter qFilter = new QFilter("projectproposalid", "=", (Object)projectProposalId);
        qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
        qFilter.and("datasource", "=", (Object)"projectProposal");
        qFilter.and("reportbudget", "=", (Object)Boolean.TRUE);
        qFilter.and("accepted", "=", (Object)Boolean.FALSE);
        DynamicObject[] lastVersion = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"version desc");
        if (lastVersion.length > 0) {
            return lastVersion[0];
        }
        return null;
    }

    public void synFunSourceBill(DynamicObject annualInvestPlan, String operationKey) {
        DynamicObjectCollection entries = annualInvestPlan.getDynamicObjectCollection("inventry");
        if (entries.size() > 0) {
            entries.forEach(entry -> {
                DynamicObjectCollection funSources = entry.getDynamicObjectCollection("funsourceentry");
                String approvalCon = entry.getString("inventry_approvalcon");
                if (funSources.size() > 0 && "pass".equals(approvalCon)) {
                    if (operationKey.equals(OperationEnum.AUDIT.getValue())) {
                        this.synFunSourceBillToProject(annualInvestPlan, (DynamicObject)entry, OperationEnum.AUDIT.getValue());
                        this.synFunSourceBillToProjectProposal((DynamicObject)entry, funSources);
                    } else if (operationKey.equals(OperationEnum.UNAUDIT.getValue())) {
                        String projectType = entry.getString("projecttype");
                        if ("bd_project".equals(projectType)) {
                            this.synFunSourceBillToProject(annualInvestPlan, (DynamicObject)entry, operationKey);
                        } else {
                            DynamicObject propoSal = entry.getDynamicObject("projectno");
                            QFilter qFilter = new QFilter("projectproposalid", "=", (Object)propoSal.getPkValue().toString());
                            qFilter.and("datasource", "=", (Object)"projectProposal");
                            DynamicObject poSalF7 = BusinessDataServiceHelper.loadSingle((String)"pmim_projectproposal_f7", (String)"id", (QFilter[])new QFilter[]{qFilter});
                            if (poSalF7 != null) {
                                poSalF7 = BusinessDataServiceHelper.loadSingle((Object)poSalF7.getPkValue(), (String)"pmim_projectproposal_f7");
                                funSources = poSalF7.getDynamicObjectCollection("funsourceentry");
                                this.synFunSourceBillToProjectProposal((DynamicObject)entry, funSources);
                            }
                        }
                    }
                }
            });
        }
    }

    public void synProjectData(DynamicObject annualInvestPlan, String operationKey) {
        DynamicObjectCollection entries = annualInvestPlan.getDynamicObjectCollection("inventry");
        if (entries.size() > 0) {
            entries.forEach(entry -> {
                String projectType = entry.getString("projecttype");
                String approvalCon = entry.getString("inventry_approvalcon");
                DynamicObject projectBill = entry.getDynamicObject("projectno");
                if ("bd_project".equals(projectType) && (projectBill = BusinessDataServiceHelper.loadSingle((Object)projectBill.getPkValue(), (String)"bd_project")) != null) {
                    QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(projectBill.getPkValue().toString()));
                    String selectProperties = String.join((CharSequence)",", "projcetbugamt", "prostatus", "investdirection", "industrykind", "investkind", "overseapro");
                    DynamicObject proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
                    if (operationKey.equals(OperationEnum.AUDIT.getValue())) {
                        if ("unpass".equals(approvalCon)) {
                            entry.set("projectstatus", (Object)projectBill.getDynamicObject("prostatus"));
                            projectBill.set("prostatus", (Object)Long.parseLong(ProjectStatusEnum.SUSPEND.getId()));
                        }
                        if (proApproval != null) {
                            if ("unpass".equals(approvalCon)) {
                                proApproval.set("prostatus", (Object)Long.parseLong(ProjectStatusEnum.SUSPEND.getId()));
                            } else {
                                proApproval.set("projcetbugamt", (Object)entry.getBigDecimal("projcetbugamt"));
                                proApproval.set("industrykind", entry.get("industrykind"));
                                proApproval.set("investdirection", entry.get("investdirection"));
                                proApproval.set("investkind", entry.get("investkind"));
                                proApproval.set("overseapro", entry.get("overseapro"));
                            }
                        }
                    } else if (operationKey.equals(OperationEnum.UNAUDIT.getValue())) {
                        DynamicObject sourceProStatus = entry.getDynamicObject("projectstatus");
                        projectBill.set("prostatus", (Object)sourceProStatus);
                        if (proApproval != null) {
                            proApproval.set("prostatus", (Object)sourceProStatus);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proApproval});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectBill});
                }
            });
        }
        if (operationKey.equals(OperationEnum.AUDIT.getValue())) {
            annualInvestPlan.set("auditdate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{annualInvestPlan});
        }
    }

    private void synFunSourceBillToProject(DynamicObject annualInvestPlan, DynamicObject entry, String operationKey) {
        String projectType = entry.getString("projecttype");
        if ("bd_project".equals(projectType)) {
            DynamicObjectCollection funSources;
            DynamicObject projectBill = entry.getDynamicObject("projectno");
            LocalDate curYear = annualInvestPlan.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(projectBill.getPkValue().toString()));
            qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
            qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
            DynamicObject funSourceBill = BusinessDataServiceHelper.loadSingle((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (OperationEnum.AUDIT.getValue().equals(operationKey)) {
                if (funSourceBill != null) {
                    funSourceBill = BusinessDataServiceHelper.loadSingle((Object)funSourceBill.getPkValue(), (String)"pmas_projfundsource");
                } else {
                    DynamicObject approvePro = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "budgetperiod", "billname", "budgetproname", "budgetpronumber", "currencyfield", "org", "kind"), (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)Long.parseLong(projectBill.getPkValue().toString()))});
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_projfundsource");
                    funSourceBill = new DynamicObject((DynamicObjectType)dt);
                    funSourceBill.set("project", (Object)projectBill);
                    funSourceBill.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s_\u8d44\u91d1\u6765\u6e90", (String)"AunualinvesPlanHelper_0", (String)"pmgt-pmim-business", (Object[])new Object[0]), approvePro.get("billname")));
                    DynamicObject org = approvePro.getDynamicObject("org");
                    funSourceBill.set("org", (Object)org);
                    String billNo = CodeRuleHelper.getBillNo((String)"pmas_projfundsource", (DynamicObject)funSourceBill, (String)org.getPkValue().toString());
                    if (StringUtils.isEmpty((CharSequence)billNo)) {
                        billNo = projectBill.get("number") + "_FUND";
                    }
                    funSourceBill.set("billno", (Object)billNo);
                    funSourceBill.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                    funSourceBill.set("projkind", approvePro.get("kind"));
                    funSourceBill.set("issys", (Object)DefaultEnum.YES.getValue());
                    funSourceBill.set("isvalid", (Object)DefaultEnum.YES.getValue());
                    funSourceBill.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                    funSourceBill.set("projkind", approvePro.get("kind"));
                    funSourceBill.set("issys", (Object)DefaultEnum.YES.getValue());
                    funSourceBill.set("isvalid", (Object)DefaultEnum.YES.getValue());
                    funSourceBill.set("currency", (Object)approvePro.getDynamicObject("currencyfield"));
                }
                funSourceBill.set("year", (Object)annualInvestPlan.getDate("year"));
                funSourceBill.set("type", (Object)BillTypeEnum.NEW.getValue());
                funSourceBill.set("version", (Object)1.0);
                funSourceBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                funSourceBill.set("createtime", (Object)new Date());
                funSourceBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                funSourceBill.set("modifytime", (Object)new Date());
                funSourceBill.set("auditdate", (Object)new Date());
                funSourceBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
                funSourceBill.set("totalamount", (Object)entry.getBigDecimal("projcetbugamt"));
                funSourceBill.set("yearbudgetapproveamt", (Object)entry.getBigDecimal("inventry_approveamt"));
                funSourceBill.set("totaloldamount", (Object)BigDecimal.ZERO);
                funSourceBill.set("totaldiffamount", (Object)BigDecimal.ZERO);
                funSourceBill.set("createorg", (Object)annualInvestPlan.getDynamicObject("createorg"));
                funSources = entry.getDynamicObjectCollection("funsourceentry");
                AunualinvesPlanHelper.doFunSourceEntry(funSourceBill, funSources, operationKey);
            }
            if (OperationEnum.UNAUDIT.getValue().equals(operationKey) && funSourceBill != null) {
                funSourceBill = BusinessDataServiceHelper.loadSingle((Object)funSourceBill.getPkValue(), (String)"pmas_projfundsource");
                qFilter = new QFilter("project", "=", (Object)Long.parseLong(projectBill.getPkValue().toString()));
                qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                qFilter.and("datasource", "=", (Object)"fundsource");
                DynamicObject poSalF7 = BusinessDataServiceHelper.loadSingle((String)"pmim_projectproposal_f7", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (poSalF7 != null) {
                    poSalF7 = BusinessDataServiceHelper.loadSingle((Object)poSalF7.getPkValue(), (String)"pmim_projectproposal_f7");
                    BigDecimal version = poSalF7.getBigDecimal("version");
                    funSourceBill.set("version", (Object)version);
                    if (version.compareTo(BigDecimal.ONE) != 0) {
                        funSourceBill.set("type", (Object)BillTypeEnum.ADJUST.getValue());
                        funSourceBill.set("issys", (Object)Boolean.FALSE);
                    }
                    funSourceBill.set("totalamount", (Object)poSalF7.getBigDecimal("yearbugamt"));
                    funSourceBill.set("yearbudgetapproveamt", (Object)poSalF7.getBigDecimal("yearbugappamt"));
                    funSourceBill.set("totaloldamount", (Object)poSalF7.getBigDecimal("totaloldamount"));
                    funSourceBill.set("totaldiffamount", (Object)poSalF7.getBigDecimal("totaldiffamount"));
                    funSources = poSalF7.getDynamicObjectCollection("funsourceentry");
                    AunualinvesPlanHelper.doFunSourceEntry(funSourceBill, funSources, operationKey);
                } else {
                    DeleteServiceHelper.delete((IDataEntityType)funSourceBill.getDynamicObjectType(), (Object[])new Object[]{funSourceBill.getPkValue()});
                }
            }
            if (funSourceBill != null) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{funSourceBill});
            }
            if (OperationEnum.UNAUDIT.getValue().equals(operationKey)) {
                qFilter = new QFilter("project", "=", (Object)Long.parseLong(projectBill.getPkValue().toString()));
                qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                qFilter.and("datasource", "=", (Object)"fundsource");
                DeleteServiceHelper.delete((String)"pmim_projectproposal_f7", (QFilter[])new QFilter[]{qFilter});
            }
        }
    }

    private static void doFunSourceEntry(DynamicObject funSourceBill, DynamicObjectCollection funSources, String operationKey) {
        if (null != funSources && funSources.size() > 0) {
            DynamicObjectCollection fundEntry = funSourceBill.getDynamicObjectCollection("fundentry");
            fundEntry.clear();
            funSources.forEach(funSource -> {
                DynamicObject sourceEntry = fundEntry.addNew();
                sourceEntry.set("sourcetype", (Object)funSource.getDynamicObject("fundsourcetype"));
                sourceEntry.set("amount", (Object)funSource.getBigDecimal("entryamt"));
                sourceEntry.set("note", (Object)funSource.getString("comment"));
                sourceEntry.set("formofinvest", (Object)funSource.getString("formofinvest"));
                sourceEntry.set("investcurrency", (Object)funSource.getDynamicObject("investcurrency"));
                sourceEntry.set("scale", (Object)funSource.getBigDecimal("scale"));
                sourceEntry.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                if (OperationEnum.UNAUDIT.getValue().equals(operationKey)) {
                    sourceEntry.set("oldamount", (Object)funSource.getBigDecimal("oldamount"));
                    sourceEntry.set("diffamount", (Object)funSource.getBigDecimal("diffamount"));
                }
            });
        }
    }

    private void synFunSourceBillToProjectProposal(DynamicObject entry, DynamicObjectCollection funSources) {
        DynamicObject projectBill;
        String projectType = entry.getString("projecttype");
        if (!"bd_project".equals(projectType) && (projectBill = entry.getDynamicObject("projectno")) != null) {
            projectBill = BusinessDataServiceHelper.loadSingle((Object)projectBill.getPkValue(), (String)"pmim_projectproposal");
            DynamicObjectCollection sourceEntry = projectBill.getDynamicObjectCollection("sourceentry");
            sourceEntry.clear();
            for (DynamicObject funSource : funSources) {
                DynamicObject source = sourceEntry.addNew();
                source.set("sourceentry_fundresource", (Object)funSource.getDynamicObject("fundsourcetype"));
                source.set("sourceentry_formofinvest", (Object)funSource.getString("formofinvest"));
                source.set("sourceentry_amount", (Object)funSource.getBigDecimal("entryamt"));
                source.set("sourceentry_currency", (Object)funSource.getDynamicObject("investcurrency"));
                source.set("sourceentry_scale", (Object)funSource.getBigDecimal("scale"));
                source.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                source.set("sourceentry_remark", (Object)funSource.getString("comment"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectBill});
        }
    }

    public DynamicObject packInvestItem(DynamicObject item, DynamicObject entry) {
        String dataSource;
        item.set("id", (Object)DB.genLongId((String)"t_pmim_auinvestplanentry"));
        Object approvalConDefValue = ((ComboProp)item.getDynamicObjectType().getProperty("inventry_approvalcon")).getDefValue();
        item.set("inventry_approvalcon", approvalConDefValue);
        String name = entry.getDynamicObjectType().getName();
        if ("pmim_projectproposal_f7".equals(name)) {
            item.set("inventry_investlistid", entry.getPkValue());
            dataSource = entry.getString("datasource");
            if (StringUtil.isEmpty((String)dataSource)) {
                dataSource = "projectProposal";
            }
        } else if ("pmim_projectproposal".equals(name)) {
            item.set("inventry_investlistid", entry.getPkValue());
            dataSource = "projectProposal";
        } else {
            dataSource = "project";
        }
        item.set("inventry_datasource", (Object)dataSource);
        if ("bd_project".equals(name)) {
            item.set("projectno", (Object)entry);
            item.set("inventry_proposalname", (Object)entry.getString("name"));
            item.set("inventry_sourceorg", (Object)entry.getDynamicObject("org"));
            item.set("inventry_anlinvesdeclamt", (Object)BigDecimal.ZERO);
            item.set("inventry_declaretype", (Object)"coninvest");
            item.set("projecttype", (Object)"bd_project");
            Object proPk = item.getDynamicObject("projectno").getPkValue();
            QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(proPk.toString()));
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "prostatus", "kind", "projcetbugamt", "projectarea", "currencyfield", "investdirection", "investkind", "industrykind"), (QFilter[])new QFilter[]{qFilter});
            if (projectApproval != null) {
                item.set("projcetbugamt", (Object)projectApproval.getBigDecimal("projcetbugamt"));
                item.set("finishinvestamt", (Object)ContractHelper.getFinishInvestmentAmt((Long)Long.parseLong(proPk.toString())));
                item.set("projectstatus", (Object)projectApproval.getDynamicObject("prostatus"));
                item.set("inventry_projectkind", (Object)projectApproval.getDynamicObject("kind"));
                String projectArea = projectApproval.getString("projectarea");
                if ("province".equals(projectArea)) {
                    item.set("overseapro", (Object)"0");
                } else if ("outsideprovince".equals(projectArea)) {
                    item.set("overseapro", (Object)"2");
                } else {
                    item.set("overseapro", (Object)"1");
                }
                item.set("inventry_currency", (Object)projectApproval.getDynamicObject("currencyfield"));
                item.set("investdirection", (Object)projectApproval.getString("investdirection"));
                item.set("investkind", (Object)projectApproval.getString("investkind"));
                item.set("industrykind", (Object)projectApproval.getDynamicObject("industrykind"));
            }
        }
        if ("pmim_projectproposal_f7".equals(name)) {
            Optional<DynamicObject> first;
            DynamicObjectCollection entries;
            QFilter qFilter;
            DynamicObject bill;
            if (StringUtils.equals((CharSequence)dataSource, (CharSequence)"inveslist") || StringUtils.equals((CharSequence)dataSource, (CharSequence)"projectProposal")) {
                String projectSalId = entry.getString("projectproposalid");
                DynamicObject proSalBill_f7 = BusinessDataServiceHelper.loadSingle((Object)projectSalId, (String)"pmim_proposalbill_f7");
                item.set("projectno", (Object)proSalBill_f7);
                item.set("inventry_proposalname", (Object)proSalBill_f7.getString("billname"));
                item.set("projecttype", (Object)"pmim_proposalbill_f7");
            }
            if (StringUtils.equals((CharSequence)dataSource, (CharSequence)"project")) {
                DynamicObject project = entry.getDynamicObject("project");
                item.set("projectno", (Object)project);
                item.set("inventry_proposalname", (Object)project.getString("name"));
                item.set("projecttype", (Object)"bd_project");
                Object proPk = item.getDynamicObject("projectno").getPkValue();
                QFilter qFilter2 = new QFilter("pro", "=", (Object)Long.parseLong(proPk.toString()));
                DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "prostatus"), (QFilter[])new QFilter[]{qFilter2});
                if (projectApproval != null) {
                    item.set("finishinvestamt", (Object)ContractHelper.getFinishInvestmentAmt((Long)Long.parseLong(proPk.toString())));
                    item.set("projectstatus", (Object)projectApproval.getDynamicObject("prostatus"));
                }
            }
            if ((bill = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("inventry.id", "=", (Object)Long.parseLong(entry.getPkValue().toString()))})) != null && (entries = (bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"pmim_aunualinvestplan")).getDynamicObjectCollection("inventry")).size() > 0 && (first = entries.stream().filter(o -> Long.parseLong(o.getPkValue().toString()) == Long.parseLong(entry.getPkValue().toString())).findFirst()).isPresent()) {
                Iterator firstEntry = first.get();
                item.set("investdirection", (Object)firstEntry.getString("investdirection"));
                item.set("investkind", (Object)firstEntry.getString("investkind"));
                item.set("industrykind", (Object)firstEntry.getDynamicObject("industrykind"));
                item.set("overseapro", (Object)firstEntry.getString("overseapro"));
                item.set("projcetbugamt", (Object)firstEntry.getBigDecimal("projcetbugamt"));
                item.set("inventry_currency", (Object)firstEntry.getDynamicObject("inventry_currency"));
                item.set("inventry_projectkind", (Object)firstEntry.getDynamicObject("inventry_projectkind"));
                item.set("startendtime", (Object)firstEntry.getString("startendtime"));
            }
            item.set("inventry_sourceorg", (Object)entry.getDynamicObject("sourceorg"));
            item.set("inventry_anlinvesdeclamt", (Object)entry.getBigDecimal("yearbugappamt"));
            item.set("inventry_anfinaexbuddeamt", (Object)entry.getBigDecimal("yearfiappamt"));
            item.set("inventry_declaretype", (Object)entry.getString("declaretype"));
            item.set("inventry_oriannualincest", (Object)entry.getBigDecimal("oriannualincest"));
            item.set("inventry_orifinancialex", (Object)entry.getBigDecimal("orifinancialex"));
            item.set("inventry_anlinvesdeclamt", (Object)entry.getBigDecimal("yearbugappamt"));
            item.set("inventry_anfinaexbuddeamt", (Object)entry.getBigDecimal("yearfiappamt"));
        }
        if (StringUtils.equals((CharSequence)dataSource, (CharSequence)"projectProposal")) {
            DynamicObject projectProposal;
            item.set("projecttype", (Object)"pmim_proposalbill_f7");
            if ("pmim_projectproposal".equals(name)) {
                projectProposal = BusinessDataServiceHelper.loadSingle((Object)entry.getPkValue(), (String)"pmim_projectproposal");
                item.set("inventry_anlinvesdeclamt", (Object)projectProposal.getBigDecimal("yearbugamt"));
                item.set("inventry_anfinaexbuddeamt", (Object)projectProposal.getBigDecimal("yearfiamt"));
            } else {
                projectProposal = BusinessDataServiceHelper.loadSingle((Object)entry.getLong("projectproposalid"), (String)"pmim_projectproposal");
                LocalDate pmsEntryYear = entry.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                BigDecimal version = entry.getBigDecimal("version");
                if (version.compareTo(BigDecimal.ONE) != 0 && version.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObjectCollection pmsEntries = projectProposal.getDynamicObjectCollection("pmsgentry");
                    pmsEntries.sort((d1, d2) -> {
                        BigDecimal balance = d1.getBigDecimal("version").subtract(d2.getBigDecimal("version"));
                        return balance.compareTo(BigDecimal.ZERO) > 0 ? 1 : -1;
                    });
                    for (DynamicObject pms : pmsEntries) {
                        LocalDate year = pms.getDate("pmsgentry_year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        String finBudGetApplyResult = pms.getString("budgetapplyresult");
                        BigDecimal edition = pms.getBigDecimal("version");
                        if (!pmsEntryYear.equals(year) || !"PASS".equals(finBudGetApplyResult) || edition.compareTo(version) >= 0) continue;
                        item.set("inventry_declaretype", (Object)"adjust");
                        item.set("inventry_oriannualincest", (Object)pms.getBigDecimal("yearbugappamt"));
                        item.set("inventry_orifinancialex", (Object)pms.getBigDecimal("yearfiappamt"));
                        break;
                    }
                }
                item.set("inventry_anlinvesdeclamt", (Object)entry.getBigDecimal("yearbugamt"));
                item.set("inventry_anfinaexbuddeamt", (Object)entry.getBigDecimal("yearfiamt"));
            }
            DynamicObject projectProposalF7 = BusinessDataServiceHelper.loadSingle((Object)projectProposal.getPkValue(), (String)"pmim_proposalbill_f7");
            item.set("projectno", (Object)projectProposalF7);
            item.set("inventry_proposalname", (Object)projectProposalF7.getString("billname"));
            item.set("investdirection", (Object)projectProposal.getString("investdirection"));
            item.set("investkind", (Object)projectProposal.getString("investkind"));
            item.set("industrykind", (Object)projectProposal.getDynamicObject("projectstatus"));
            String projectArea = projectProposal.getString("projectarea");
            if ("province".equals(projectArea)) {
                item.set("overseapro", (Object)"0");
            } else if ("outsideprovince".equals(projectArea)) {
                item.set("overseapro", (Object)"2");
            } else {
                item.set("overseapro", (Object)"1");
            }
            Date planBeginDate = projectProposal.getDate("planbegindate");
            Date planEndDate = projectProposal.getDate("planenddate");
            String startEndTime = "";
            if (planBeginDate != null) {
                startEndTime = this.sdf.format(planBeginDate);
            }
            if (planEndDate != null) {
                startEndTime = this.sdf.format(planEndDate);
            }
            if (planBeginDate != null && planEndDate != null) {
                startEndTime = String.join((CharSequence)"-", this.sdf.format(planBeginDate), this.sdf.format(planEndDate));
            }
            item.set("startendtime", (Object)startEndTime);
            item.set("projcetbugamt", (Object)projectProposal.getBigDecimal("projcetbugamt"));
            item.set("inventry_declaretype", (Object)"addnew");
        }
        if (!"project".equals(dataSource)) {
            if (!"pmim_projectproposal".equals(name)) {
                item.set("inventry_arrearsamt", (Object)entry.getBigDecimal("arrearsamt"));
                item.set("inventry_lastyearbugamt", (Object)entry.getBigDecimal("lastyearbugamt"));
                item.set("inventry_lastyearfiamt", (Object)entry.getBigDecimal("lastyearfiamt"));
                item.set("inventry_sourceorg", (Object)entry.getDynamicObject("sourceorg"));
                item.set("inventry_projectkind", (Object)entry.getDynamicObject("projectkind"));
                item.set("inventry_currency", (Object)entry.getDynamicObject("currency"));
            } else {
                item.set("inventry_arrearsamt", (Object)entry.getBigDecimal("arrearsamt"));
                item.set("inventry_lastyearbugamt", (Object)entry.getBigDecimal("lastyearbugamt"));
                item.set("inventry_lastyearfiamt", (Object)entry.getBigDecimal("lastyearfiamt"));
                item.set("inventry_sourceorg", (Object)entry.getDynamicObject("org"));
                item.set("inventry_projectkind", (Object)entry.getDynamicObject("projectkind"));
                item.set("inventry_currency", (Object)entry.getDynamicObject("currency"));
            }
        }
        item.set("projcetbugappamt", (Object)item.getBigDecimal("projcetbugamt"));
        item.set("inventry_approveamt", (Object)item.getBigDecimal("inventry_anlinvesdeclamt"));
        item.set("inventry_finanapproveamt", (Object)item.getBigDecimal("inventry_anfinaexbuddeamt"));
        item.set("inventry_investbudincrea", (Object)item.getBigDecimal("inventry_approveamt").subtract(item.getBigDecimal("inventry_oriannualincest")));
        item.set("inventry_finaexbudincreas", (Object)item.getBigDecimal("inventry_finanapproveamt").subtract(item.getBigDecimal("inventry_orifinancialex")));
        item.set("inventry_accepted", (Object)false);
        return item;
    }

    public BigDecimal getAnnualStrategicPlanAmt(int year, DynamicObject org) {
        BigDecimal planAmt = BigDecimal.ZERO;
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)year);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("effectivestatus", "=", (Object)"1");
        DynamicObject tacticInvestPlan = BusinessDataServiceHelper.loadSingle((String)"pmim_tacticinvestplan", (String)"totalinvestamount", (QFilter[])new QFilter[]{qFilter, orgFilter});
        if (tacticInvestPlan != null) {
            planAmt = tacticInvestPlan.getBigDecimal("totalinvestamount");
        } else {
            Optional<DynamicObject> first;
            DynamicObjectCollection treeEntryEntity;
            orgFilter = new QFilter("treeentryentity.orgfield", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            tacticInvestPlan = BusinessDataServiceHelper.loadSingle((String)"pmim_tacticinvestplan", (QFilter[])new QFilter[]{qFilter, orgFilter});
            if (tacticInvestPlan != null && (treeEntryEntity = tacticInvestPlan.getDynamicObjectCollection("treeentryentity")).size() > 0 && (first = treeEntryEntity.stream().filter(o -> o.getDynamicObject("orgfield") != null).filter(o -> Long.parseLong(o.getDynamicObject("orgfield").getPkValue().toString()) == Long.parseLong(org.getPkValue().toString())).findFirst()).isPresent()) {
                planAmt = first.get().getBigDecimal("currentyearamount");
            }
        }
        return planAmt;
    }

    public BigDecimal getAnnualApprovalBudVol(int year, DynamicObject org) {
        BigDecimal approvalAmt = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("YEAR(year)", "=", (Object)year);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter effectQFilter = new QFilter("effectivestatus", "=", (Object)"1");
        DynamicObject investPlanAdjustment = BusinessDataServiceHelper.loadSingle((String)"pmim_investplanadjustment", (String)"investbudamtafadjust", (QFilter[])new QFilter[]{qFilter, effectQFilter});
        if (investPlanAdjustment != null) {
            approvalAmt = investPlanAdjustment.getBigDecimal("investbudamtafadjust");
        } else {
            QFilter declareTypeQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.DECLARE.getValue());
            DynamicObject investPlan = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)"investbudamt", (QFilter[])new QFilter[]{qFilter, declareTypeQFilter});
            if (investPlan != null) {
                approvalAmt = investPlan.getBigDecimal("investbudamt");
            }
            declareTypeQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
            DynamicObject[] speInvestPlans = BusinessDataServiceHelper.load((String)"pmim_specialdeclarainvest", (String)"investbudamt", (QFilter[])new QFilter[]{qFilter, declareTypeQFilter});
            if (speInvestPlans.length > 0) {
                for (DynamicObject speInvestPlan : speInvestPlans) {
                    approvalAmt = approvalAmt.add(speInvestPlan.getBigDecimal("investbudamt"));
                }
            }
        }
        return approvalAmt;
    }

    public boolean judgeHasInvestDeclare(int year, DynamicObject org) {
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("YEAR(year)", "=", (Object)year);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        billStatus.or("billstatus", "=", (Object)"D");
        DynamicObject[] investDeclares = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter, billStatus});
        return investDeclares.length > 0;
    }

    public Map<String, List<DynamicObject>> getInvestListByOrgYear(int year, DynamicObject org) {
        HashMap<String, List<DynamicObject>> investListMap = new HashMap<String, List<DynamicObject>>(16);
        ArrayList<Object> investList = new ArrayList<Object>(16);
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("YEAR(year)", "=", (Object)year);
        QFilter billStatusQFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter effectQFilter = new QFilter("effectivestatus", "=", (Object)"1");
        DynamicObject investPlanAdjust = BusinessDataServiceHelper.loadSingle((String)"pmim_investplanadjustment", (String)"id", (QFilter[])new QFilter[]{qFilter, billStatusQFilter, effectQFilter});
        if (investPlanAdjust != null) {
            DynamicObjectCollection investEntry = (investPlanAdjust = BusinessDataServiceHelper.loadSingle((Object)investPlanAdjust.getPkValue(), (String)"pmim_investplanadjustment")).getDynamicObjectCollection("investentry");
            if (investEntry.size() > 0) {
                List passInvest = investEntry.stream().filter(o -> StringUtils.equals((CharSequence)"pass", (CharSequence)o.getString("approvalcon"))).collect(Collectors.toList());
                investList.addAll(passInvest);
                investListMap.put("adjust", investList);
            }
        } else {
            DynamicObjectCollection investEntry;
            qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            qFilter.and("YEAR(year)", "=", (Object)year);
            qFilter.and("docuimenttype", "=", (Object)DocuimentTypeEnum.DECLARE.getValue());
            qFilter.and("adjuststatus", "=", (Object)"0");
            billStatusQFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            billStatusQFilter.or("billstatus", "=", (Object)"D");
            DynamicObject investDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter, billStatusQFilter});
            if (investDeclare != null && (investEntry = (investDeclare = BusinessDataServiceHelper.loadSingle((Object)investDeclare.getPkValue(), (String)"pmim_aunualinvestplan")).getDynamicObjectCollection("inventry")).size() > 0) {
                List passInvest = investEntry.stream().filter(o -> StringUtils.equals((CharSequence)"pass", (CharSequence)o.getString("inventry_approvalcon"))).collect(Collectors.toList());
                investList.addAll(passInvest);
                List<DynamicObject> reportInvests = investEntry.stream().filter(o -> StringUtils.equals((CharSequence)"report", (CharSequence)o.getString("inventry_approvalcon"))).collect(Collectors.toList());
                List<DynamicObject> reportInvestByPass = this.getReportInvestByPass(reportInvests, year);
                if (reportInvestByPass.size() > 0) {
                    investList.addAll(reportInvestByPass);
                }
                investListMap.put("annual", investList);
            }
        }
        qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("YEAR(year)", "=", (Object)year);
        qFilter.and("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
        qFilter.and("adjuststatus", "=", (Object)"0");
        billStatusQFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        billStatusQFilter.or("billstatus", "=", (Object)"D");
        DynamicObject[] investDeclares = BusinessDataServiceHelper.load((String)"pmim_specialdeclarainvest", (String)"id", (QFilter[])new QFilter[]{qFilter, billStatusQFilter});
        if (investDeclares.length > 0) {
            investList = new ArrayList(16);
            for (DynamicObject investDeclare : investDeclares) {
                DynamicObjectCollection investEntry = (investDeclare = BusinessDataServiceHelper.loadSingle((Object)investDeclare.getPkValue(), (String)"pmim_specialdeclarainvest")).getDynamicObjectCollection("inventry");
                if (investEntry.size() <= 0) continue;
                List passInvest = investEntry.stream().filter(o -> StringUtils.equals((CharSequence)"pass", (CharSequence)o.getString("inventry_approvalcon"))).collect(Collectors.toList());
                investList.addAll(passInvest);
                List<DynamicObject> reportInvests = investEntry.stream().filter(o -> StringUtils.equals((CharSequence)"report", (CharSequence)o.getString("inventry_approvalcon"))).collect(Collectors.toList());
                List<DynamicObject> reportInvestByPass = this.getReportInvestByPass(reportInvests, year);
                if (reportInvestByPass.size() <= 0) continue;
                investList.addAll(reportInvestByPass);
            }
            if (investList.size() > 0) {
                investListMap.put("special", investList);
            }
        }
        return investListMap;
    }

    private List<DynamicObject> getReportInvestByPass(List<DynamicObject> reportInvests, int year) {
        ArrayList<DynamicObject> investList = new ArrayList<DynamicObject>(16);
        if (reportInvests.size() > 0) {
            QFilter billStatusQFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            billStatusQFilter.or("billstatus", "=", (Object)"D");
            QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)year);
            qFilter.and("inventry.inventry_approvalcon", "=", (Object)"pass");
            for (DynamicObject reportInvest : reportInvests) {
                DynamicObject project = reportInvest.getDynamicObject("projectno");
                qFilter.and("inventry.projectno", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                DynamicObject[] declareBills = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter, billStatusQFilter});
                if (declareBills.length <= 0) continue;
                for (DynamicObject declareBill : declareBills) {
                    DynamicObjectCollection investEntry = (declareBill = BusinessDataServiceHelper.loadSingle((Object)declareBill.getPkValue(), (String)"pmim_aunualinvestplan")).getDynamicObjectCollection("inventry");
                    if (investEntry.size() <= 0) continue;
                    List passInvest = investEntry.stream().filter(o -> StringUtils.equals((CharSequence)"pass", (CharSequence)o.getString("inventry_approvalcon"))).filter(o -> Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString()) == Long.parseLong(project.getPkValue().toString())).collect(Collectors.toList());
                    investList.addAll(passInvest);
                }
            }
        }
        return investList;
    }

    public void packageInvestList(DynamicObjectCollection entries, List<DynamicObject> investList, String formBillId, int declareYear) {
        DynamicObjectType dt = entries.getDynamicObjectType();
        if (investList != null && investList.size() > 0) {
            ORM orm = ORM.create();
            long[] entryIds = orm.genLongIds((IDataEntityType)dt, investList.size());
            int entryIndex = 0;
            for (DynamicObject invest : investList) {
                QFilter numberFilter;
                DynamicObject currency;
                DynamicObject entry = entries.addNew();
                entry.set("id", (Object)entryIds[entryIndex++]);
                entry.set("seq", (Object)entries.size());
                entry.set("investlistid", (Object)invest.getPkValue().toString());
                entry.set("approvalcon", (Object)"pass");
                entry.set("approvalstatus", (Object)this.getApprovalStatus(invest, formBillId));
                BigDecimal useBudgetAmt = BigDecimal.ZERO;
                BigDecimal yearUseBudgetAmt = BigDecimal.ZERO;
                if (!StringUtils.equals((CharSequence)"unapproval", (CharSequence)entry.getString("approvalstatus"))) {
                    DynamicObject project = invest.getDynamicObject("projectno");
                    if (invest.getString("projecttype").equals("bd_project")) {
                        useBudgetAmt = this.countBudgetUseAmt(Long.parseLong(project.getPkValue().toString()), 0);
                        yearUseBudgetAmt = this.countBudgetUseAmt(Long.parseLong(project.getPkValue().toString()), declareYear);
                    } else {
                        project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"pmim_projectproposal");
                        useBudgetAmt = this.countBudgetUserAmtByApproval(project, 0);
                        yearUseBudgetAmt = this.countBudgetUserAmtByApproval(project, declareYear);
                    }
                }
                entry.set("usebudgetamt", (Object)useBudgetAmt);
                entry.set("yearusebudgetamt", (Object)yearUseBudgetAmt);
                if ("pmim_investplanadjustment".equals(formBillId)) {
                    entry.set("sourceorg", (Object)invest.getDynamicObject("sourceorg"));
                    entry.set("projectkind", (Object)invest.getDynamicObject("projectkind"));
                    entry.set("projecttype", (Object)invest.getString("projecttype"));
                    entry.set("projectno", (Object)invest.getDynamicObject("projectno"));
                    entry.set("projectname", (Object)invest.getString("projectname"));
                    entry.set("projectstatus", (Object)invest.getDynamicObject("projectstatus"));
                    entry.set("declaretype", (Object)invest.getString("declaretype"));
                    entry.set("isinplan", (Object)invest.getBoolean("isinplan"));
                    currency = invest.getDynamicObject("imvestcurrency");
                    if (currency == null && (currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"", (QFilter[])new QFilter[]{numberFilter = new QFilter("number", "=", (Object)"CNY")})) != null) {
                        currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
                    }
                    entry.set("imvestcurrency", (Object)currency);
                    entry.set("projcetbugappamt", (Object)invest.getBigDecimal("probudappamtafadjust"));
                    entry.set("probudappamtafadjust", (Object)entry.getBigDecimal("projcetbugappamt"));
                    entry.set("proownedfunds", (Object)invest.getBigDecimal("proownedfunds"));
                    entry.set("proexternalfunds", (Object)invest.getBigDecimal("proexternalfunds"));
                    entry.set("yearapproveamt", (Object)invest.getBigDecimal("yearappamtafadjust"));
                    entry.set("yearappamtafadjust", (Object)entry.getBigDecimal("yearapproveamt"));
                    entry.set("proyearexternalfunds", (Object)invest.getBigDecimal("proyearexternalfunds"));
                    entry.set("proyearownedfunds", (Object)invest.getBigDecimal("proyearownedfunds"));
                    entry.set("startendtime", (Object)invest.getString("startendtime"));
                    entry.set("industrykind", (Object)invest.getDynamicObject("industrykind"));
                    entry.set("overseapro", (Object)invest.getString("overseapro"));
                    entry.set("investdirection", (Object)invest.getString("investdirection"));
                    entry.set("investkind", (Object)invest.getString("investkind"));
                    entry.set("investcomment", (Object)invest.getString("investcomment"));
                    DynamicObjectCollection fundsSource = entry.getDynamicObjectCollection("budgetfundssource");
                    DynamicObjectType sourceDt = fundsSource.getDynamicObjectType();
                    DynamicObjectCollection budgetFundsSources = invest.getDynamicObjectCollection("budgetfundssource");
                    if (budgetFundsSources.size() <= 0) continue;
                    long[] sourceIds = orm.genLongIds((IDataEntityType)sourceDt, budgetFundsSources.size());
                    int sourceIndex = 0;
                    for (DynamicObject budgetFundsSource : budgetFundsSources) {
                        DynamicObject source = fundsSource.addNew();
                        source.set("id", (Object)sourceIds[sourceIndex++]);
                        source.set("fundsourcetype", (Object)budgetFundsSource.getDynamicObject("fundsourcetype"));
                        source.set("formofinvest", (Object)budgetFundsSource.getString("formofinvest"));
                        source.set("entryamt", (Object)budgetFundsSource.getBigDecimal("entryamt"));
                        source.set("scale", (Object)budgetFundsSource.getBigDecimal("scale"));
                        source.set("investcurrency", (Object)budgetFundsSource.getDynamicObject("investcurrency"));
                        source.set("currententryamt", (Object)budgetFundsSource.getBigDecimal("currententryamt"));
                        source.set("comment", (Object)budgetFundsSource.getString("comment"));
                    }
                    continue;
                }
                entry.set("sourceorg", (Object)invest.getDynamicObject("inventry_sourceorg"));
                entry.set("projectkind", (Object)invest.getDynamicObject("inventry_projectkind"));
                entry.set("projecttype", (Object)invest.getString("projecttype"));
                entry.set("projectno", (Object)invest.getDynamicObject("projectno"));
                entry.set("projectname", (Object)invest.getString("inventry_proposalname"));
                entry.set("projectstatus", (Object)invest.getDynamicObject("projectstatus"));
                entry.set("declaretype", (Object)invest.getString("inventry_declaretype"));
                entry.set("isinplan", (Object)StringUtils.equals((CharSequence)"pmim_aunualinvestplan", (CharSequence)formBillId));
                currency = invest.getDynamicObject("inventry_currency");
                if (currency == null && (currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"", (QFilter[])new QFilter[]{numberFilter = new QFilter("number", "=", (Object)"CNY")})) != null) {
                    currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
                }
                entry.set("imvestcurrency", (Object)currency);
                entry.set("projcetbugappamt", (Object)invest.getBigDecimal("projcetbugappamt"));
                entry.set("probudappamtafadjust", (Object)invest.getBigDecimal("projcetbugappamt"));
                entry.set("yearapproveamt", (Object)invest.getBigDecimal("inventry_approveamt"));
                entry.set("yearappamtafadjust", (Object)invest.getBigDecimal("inventry_approveamt"));
                entry.set("startendtime", (Object)invest.getString("startendtime"));
                entry.set("industrykind", (Object)invest.getDynamicObject("industrykind"));
                entry.set("overseapro", (Object)invest.getString("overseapro"));
                entry.set("investdirection", (Object)invest.getString("investdirection"));
                entry.set("investkind", (Object)invest.getString("investkind"));
                BigDecimal proOwnedFunds = BigDecimal.ZERO;
                BigDecimal proExternalFunds = BigDecimal.ZERO;
                BigDecimal proYearOwnedFunds = BigDecimal.ZERO;
                BigDecimal proYearExternalFunds = BigDecimal.ZERO;
                DynamicObjectCollection fundsSource = entry.getDynamicObjectCollection("budgetfundssource");
                DynamicObjectType sourceDt = fundsSource.getDynamicObjectType();
                DynamicObjectCollection budgetFundsSources = invest.getDynamicObjectCollection("funsourceentry");
                if (budgetFundsSources.size() > 0) {
                    long[] budgetIds = orm.genLongIds((IDataEntityType)sourceDt, budgetFundsSources.size());
                    int budgetIndex = 0;
                    for (DynamicObject budgetFundsSource : budgetFundsSources) {
                        DynamicObject source = fundsSource.addNew();
                        source.set("id", (Object)budgetIds[budgetIndex++]);
                        source.set("comment", (Object)budgetFundsSource.getString("comment"));
                        source.set("scale", (Object)budgetFundsSource.getBigDecimal("scale"));
                        source.set("formofinvest", (Object)budgetFundsSource.getString("formofinvest"));
                        source.set("investcurrency", (Object)budgetFundsSource.getDynamicObject("investcurrency"));
                        BigDecimal entryAmt = budgetFundsSource.getBigDecimal("entryamt");
                        BigDecimal currentEntryAmt = budgetFundsSource.getBigDecimal("currententryamt");
                        DynamicObject fundSourceType = budgetFundsSource.getDynamicObject("fundsourcetype");
                        if (fundSourceType != null) {
                            String capitalType = fundSourceType.getString("capitaltype");
                            if (CapitalTypeEnum.OWN_FUNDS.getValue().equals(capitalType)) {
                                proOwnedFunds = proOwnedFunds.add(entryAmt);
                                proYearOwnedFunds = proYearOwnedFunds.add(currentEntryAmt);
                            } else {
                                proExternalFunds = proExternalFunds.add(entryAmt);
                                proYearExternalFunds = proYearExternalFunds.add(currentEntryAmt);
                            }
                        }
                        source.set("fundsourcetype", (Object)fundSourceType);
                        source.set("currententryamt", (Object)currentEntryAmt);
                        source.set("entryamt", (Object)entryAmt);
                    }
                }
                entry.set("proownedfunds", (Object)proOwnedFunds);
                entry.set("proexternalfunds", (Object)proExternalFunds);
                entry.set("proyearexternalfunds", (Object)proYearExternalFunds);
                entry.set("proyearownedfunds", (Object)proYearOwnedFunds);
            }
        }
    }

    private BigDecimal countBudgetUserAmtByApproval(DynamicObject proposal, int year) {
        Set approvalIds;
        DynamicObjectCollection approvalPro;
        BigDecimal budgetUseAmt = BigDecimal.ZERO;
        if (proposal != null && (approvalPro = proposal.getDynamicObjectCollection("project")).size() > 0 && (approvalIds = approvalPro.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> Long.parseLong(o.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
            QFilter qFilter = new QFilter("id", "in", approvalIds);
            qFilter.and("pro", "!=", (Object)0L);
            DynamicObject[] approvals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{qFilter});
            if (approvals.length > 0) {
                List projectIds = Arrays.stream(approvals).map(o -> Long.parseLong(o.getDynamicObject("pro").getPkValue().toString())).collect(Collectors.toList());
                for (Long projectId : projectIds) {
                    budgetUseAmt = budgetUseAmt.add(this.countBudgetUseAmt(projectId, year));
                }
            }
        }
        return budgetUseAmt;
    }

    private BigDecimal countBudgetUseAmt(Long projectId, int year) {
        DynamicObject[] proCostSplits;
        DynamicObject[] contractSign;
        BigDecimal budgetUseAmt = BigDecimal.ZERO;
        Set<Object> contractIds = new HashSet(16);
        QFilter qFilter = new QFilter("contract.project", "=", (Object)projectId);
        qFilter.and("contract.paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
        if (year != 0) {
            qFilter.and("YEAR(signdate)", "=", (Object)year);
        }
        if ((contractSign = BusinessDataServiceHelper.load((String)"pmct_contsign", (String)"contract", (QFilter[])new QFilter[]{qFilter})).length > 0) {
            contractIds = Arrays.stream(contractSign).map(o -> Long.parseLong(o.getDynamicObject("contract").getPkValue().toString())).collect(Collectors.toSet());
        }
        if (contractIds.size() > 0) {
            qFilter = new QFilter("id", "in", contractIds);
            DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"originaloftaxamount", (QFilter[])new QFilter[]{qFilter});
            if (contracts.length > 0) {
                budgetUseAmt = Arrays.stream(contracts).map(o -> o.getBigDecimal("originaloftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
        }
        qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("enablemultipro", "=", (Object)"0");
        if (year != 0) {
            qFilter.and("YEAR(auditdate)", "=", (Object)year);
        }
        if ((proCostSplits = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"totalcostamt", (QFilter[])new QFilter[]{qFilter})).length > 0) {
            BigDecimal totalCostAmt = Arrays.stream(proCostSplits).map(o -> o.getBigDecimal("totalcostamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            budgetUseAmt = budgetUseAmt.add(totalCostAmt);
        }
        qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("procostsplitentry.entryproject", "=", (Object)projectId);
        qFilter.and("enablemultipro", "=", (Object)"1");
        if (year != 0) {
            qFilter.and("YEAR(auditdate)", "=", (Object)year);
        }
        if ((proCostSplits = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)String.join((CharSequence)",", "entryproject", "costamt"), (QFilter[])new QFilter[]{qFilter})).length > 0) {
            for (DynamicObject proCostSplit : proCostSplits) {
                DynamicObjectCollection proCostSplitEntry = proCostSplit.getDynamicObjectCollection("procostsplitentry");
                if (proCostSplitEntry.size() <= 0) continue;
                BigDecimal totalCostAmt = proCostSplitEntry.stream().filter(o -> Long.parseLong(o.getDynamicObject("entryproject").getPkValue().toString()) == projectId).map(o -> o.getBigDecimal("costamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                budgetUseAmt = budgetUseAmt.add(totalCostAmt);
            }
        }
        return budgetUseAmt;
    }

    private String getApprovalStatus(DynamicObject invest, String formBillId) {
        String projectNo;
        String approvalStatus = "execution";
        String declareType = "pmim_investplanadjustment".equals(formBillId) ? "declaretype" : "inventry_declaretype";
        String projectType = "pmim_investplanadjustment".equals(formBillId) ? "projecttype" : "projecttype";
        String string = projectNo = "pmim_investplanadjustment".equals(formBillId) ? "projectno" : "projectno";
        if (StringUtils.equals((CharSequence)invest.getString(declareType), (CharSequence)"addnew") && !invest.getString(projectType).equals("bd_project")) {
            DynamicObject project = invest.getDynamicObject(projectNo);
            approvalStatus = StringUtils.equals((CharSequence)(project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"pmim_projectproposal", (String)"bizstatus")).getString("bizstatus"), (CharSequence)"approval") ? "approval" : "unapproval";
        }
        return approvalStatus;
    }

    public Map<Long, DynamicObject> getProjectKindMap() {
        DynamicObject[] projectKindCol = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)String.join((CharSequence)",", "number", "name", "parent"), (QFilter[])new QFilter[0]);
        HashMap<Long, DynamicObject> projectKindMap = new HashMap<Long, DynamicObject>(projectKindCol.length);
        for (DynamicObject projectKind : projectKindCol) {
            projectKindMap.put((Long)projectKind.getPkValue(), projectKind);
        }
        return projectKindMap;
    }

    public void packageSumInvestListByAdjust(DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("investentry");
        DynamicObjectCollection sumInvestList = bill.getDynamicObjectCollection("suminvestlist");
        sumInvestList.clear();
        if (entries.size() > 0) {
            int proQty;
            HashMap<Long, HashMap<String, BigDecimal>> sumMap = new HashMap<Long, HashMap<String, BigDecimal>>(16);
            Date declareDate = bill.getDate("year");
            int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            for (DynamicObject entry : entries) {
                DynamicObject sourceOrg;
                String approvalCon = entry.getString("approvalcon");
                if ("unpass".equals(approvalCon) || (sourceOrg = entry.getDynamicObject("sourceorg")) == null) continue;
                BigDecimal annualStrategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, sourceOrg);
                long sourceId = Long.parseLong(sourceOrg.getPkValue().toString());
                HashMap<String, BigDecimal> listMap = (HashMap<String, BigDecimal>)sumMap.get(sourceId);
                if (listMap == null) {
                    listMap = new HashMap<String, BigDecimal>(16);
                }
                listMap.putIfAbsent("strategicinvestplanamt", annualStrategicPlanAmt);
                listMap.put("sumcurrencu", (BigDecimal)entry.getDynamicObject("imvestcurrency"));
                Object proQtyObj = listMap.get("proqty");
                proQty = proQtyObj == null ? 1 : Integer.parseInt(proQtyObj.toString()) + 1;
                listMap.put("proqty", (BigDecimal)((Object)Integer.valueOf(proQty)));
                Object sumProBudAppAmtObj = listMap.get("sumprobudappamt");
                BigDecimal sumProBudAppAmt = entry.getBigDecimal("projcetbugappamt");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumprobudappamt", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("probudappamtafadjust");
                sumProBudAppAmtObj = listMap.get("sumprobudappamtafadjust");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumprobudappamtafadjust", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("proownedfunds");
                sumProBudAppAmtObj = listMap.get("sumownfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumownfunds", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("proexternalfunds");
                sumProBudAppAmtObj = listMap.get("sumexternalfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumexternalfunds", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("yearapproveamt");
                sumProBudAppAmtObj = listMap.get("sumyearbudappamt");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearbudappamt", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("yearappamtafadjust");
                sumProBudAppAmtObj = listMap.get("sumyearbudappamtafadjust");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearbudappamtafadjust", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("proyearownedfunds");
                sumProBudAppAmtObj = listMap.get("sumyearownfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearownfunds", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("proyearexternalfunds");
                sumProBudAppAmtObj = listMap.get("sumyearexternalfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearexternalfunds", sumProBudAppAmt);
                sumMap.put(sourceId, listMap);
            }
            if (sumMap.size() > 0) {
                Set entrySet = sumMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    DynamicObject investList = sumInvestList.addNew();
                    Long sourceId = (Long)entry.getKey();
                    DynamicObject sourceOrg = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"bos_org");
                    investList.set("orgbysource", (Object)sourceOrg);
                    Map listMap = (Map)entry.getValue();
                    BigDecimal strategicInvestPlanAmt = (BigDecimal)listMap.get("strategicinvestplanamt");
                    investList.set("strategicinvestplanamt", (Object)strategicInvestPlanAmt);
                    DynamicObject currency = (DynamicObject)listMap.get("sumcurrencu");
                    investList.set("sumcurrencu", (Object)currency);
                    proQty = (Integer)listMap.get("proqty");
                    investList.set("proqty", (Object)proQty);
                    BigDecimal sumProBudAppAmt = (BigDecimal)listMap.get("sumprobudappamt");
                    investList.set("sumprobudappamt", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumprobudappamtafadjust");
                    investList.set("sumprobudappamtafadjust", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumownfunds");
                    investList.set("sumownfunds", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumexternalfunds");
                    investList.set("sumexternalfunds", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearbudappamt");
                    investList.set("sumyearbudappamt", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearbudappamtafadjust");
                    investList.set("sumyearbudappamtafadjust", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearownfunds");
                    investList.set("sumyearownfunds", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearexternalfunds");
                    investList.set("sumyearexternalfunds", (Object)sumProBudAppAmt);
                }
            }
        }
    }

    public void packageSumInvestListByDeclare(DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("inventry");
        DynamicObjectCollection sumInvestList = bill.getDynamicObjectCollection("suminvestlist");
        sumInvestList.clear();
        if (entries.size() > 0) {
            int proQty;
            HashMap<Long, HashMap<String, BigDecimal>> sumMap = new HashMap<Long, HashMap<String, BigDecimal>>(16);
            Date declareDate = bill.getDate("year");
            int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            for (DynamicObject entry : entries) {
                DynamicObject sourceOrg;
                String approvalCon = entry.getString("inventry_approvalcon");
                if ("unpass".equals(approvalCon) || (sourceOrg = entry.getDynamicObject("inventry_sourceorg")) == null) continue;
                BigDecimal annualStrategicPlanAmt = new AunualinvesPlanHelper().getAnnualStrategicPlanAmt(declareYear, sourceOrg);
                long sourceId = Long.parseLong(sourceOrg.getPkValue().toString());
                HashMap<String, BigDecimal> listMap = (HashMap<String, BigDecimal>)sumMap.get(sourceId);
                if (listMap == null) {
                    listMap = new HashMap<String, BigDecimal>(16);
                }
                listMap.putIfAbsent("strategicinvestplanamt", annualStrategicPlanAmt);
                listMap.put("sumcurrencu", (BigDecimal)entry.getDynamicObject("inventry_currency"));
                Object proQtyObj = listMap.get("proqty");
                proQty = proQtyObj == null ? 1 : Integer.parseInt(proQtyObj.toString()) + 1;
                listMap.put("proqty", (BigDecimal)((Object)Integer.valueOf(proQty)));
                Object sumProBudAppAmtObj = listMap.get("sumprobudappamt");
                BigDecimal sumProBudAppAmt = entry.getBigDecimal("projcetbugappamt");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumprobudappamt", sumProBudAppAmt);
                Map<String, BigDecimal> fundsMap = this.calculationOwnOrExAmt(entry);
                sumProBudAppAmt = fundsMap.get("sumownfunds");
                sumProBudAppAmtObj = listMap.get("sumownfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumownfunds", sumProBudAppAmt);
                sumProBudAppAmt = fundsMap.get("sumexternalfunds");
                sumProBudAppAmtObj = listMap.get("sumexternalfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumexternalfunds", sumProBudAppAmt);
                sumProBudAppAmt = entry.getBigDecimal("inventry_approveamt");
                sumProBudAppAmtObj = listMap.get("sumyearbudappamt");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearbudappamt", sumProBudAppAmt);
                sumProBudAppAmt = fundsMap.get("sumyearownfunds");
                sumProBudAppAmtObj = listMap.get("sumyearownfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearownfunds", sumProBudAppAmt);
                sumProBudAppAmt = fundsMap.get("sumyearexternalfunds");
                sumProBudAppAmtObj = listMap.get("sumyearexternalfunds");
                if (sumProBudAppAmtObj != null) {
                    sumProBudAppAmt = sumProBudAppAmt.add((BigDecimal)sumProBudAppAmtObj);
                }
                listMap.put("sumyearexternalfunds", sumProBudAppAmt);
                sumMap.put(sourceId, listMap);
            }
            if (sumMap.size() > 0) {
                Set entrySet = sumMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    DynamicObject investList = sumInvestList.addNew();
                    Long sourceId = (Long)entry.getKey();
                    DynamicObject sourceOrg = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"bos_org");
                    investList.set("orgbysource", (Object)sourceOrg);
                    Map listMap = (Map)entry.getValue();
                    BigDecimal strategicInvestPlanAmt = (BigDecimal)listMap.get("strategicinvestplanamt");
                    investList.set("strategicinvestplanamt", (Object)strategicInvestPlanAmt);
                    DynamicObject currency = (DynamicObject)listMap.get("sumcurrencu");
                    investList.set("sumcurrencu", (Object)currency);
                    proQty = (Integer)listMap.get("proqty");
                    investList.set("proqty", (Object)proQty);
                    BigDecimal sumProBudAppAmt = (BigDecimal)listMap.get("sumprobudappamt");
                    investList.set("sumprobudappamt", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumownfunds");
                    investList.set("sumownfunds", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumexternalfunds");
                    investList.set("sumexternalfunds", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearbudappamt");
                    investList.set("sumyearbudappamt", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearownfunds");
                    investList.set("sumyearownfunds", (Object)sumProBudAppAmt);
                    sumProBudAppAmt = (BigDecimal)listMap.get("sumyearexternalfunds");
                    investList.set("sumyearexternalfunds", (Object)sumProBudAppAmt);
                }
            }
        }
    }

    private Map<String, BigDecimal> calculationOwnOrExAmt(DynamicObject entry) {
        HashMap<String, BigDecimal> fundsMap = new HashMap<String, BigDecimal>(16);
        BigDecimal proOwnedFunds = BigDecimal.ZERO;
        BigDecimal proExternalFunds = BigDecimal.ZERO;
        BigDecimal proYearOwnedFunds = BigDecimal.ZERO;
        BigDecimal proYearExternalFunds = BigDecimal.ZERO;
        DynamicObjectCollection funSourceEntries = entry.getDynamicObjectCollection("funsourceentry");
        if (funSourceEntries.size() > 0) {
            for (DynamicObject fundsSource : funSourceEntries) {
                BigDecimal entryAmt = fundsSource.getBigDecimal("entryamt");
                BigDecimal currentEntryAmt = fundsSource.getBigDecimal("currententryamt");
                DynamicObject fundSourceType = fundsSource.getDynamicObject("fundsourcetype");
                String capitalType = fundSourceType.getString("capitaltype");
                if (CapitalTypeEnum.OWN_FUNDS.getValue().equals(capitalType)) {
                    proOwnedFunds = proOwnedFunds.add(entryAmt);
                    proYearOwnedFunds = proYearOwnedFunds.add(currentEntryAmt);
                    continue;
                }
                proExternalFunds = proExternalFunds.add(entryAmt);
                proYearExternalFunds = proYearExternalFunds.add(currentEntryAmt);
            }
        }
        fundsMap.put("sumownfunds", proOwnedFunds);
        fundsMap.put("sumexternalfunds", proExternalFunds);
        fundsMap.put("sumyearownfunds", proYearOwnedFunds);
        fundsMap.put("sumyearexternalfunds", proYearExternalFunds);
        return fundsMap;
    }

    public void updateProposalAndDeclare(DynamicObject bill, String operateKey) {
        DynamicObjectCollection investLists = bill.getDynamicObjectCollection("investentry");
        ArrayList<DynamicObject> proposalList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> declareList = new ArrayList<DynamicObject>(10);
        for (DynamicObject investList : investLists) {
            QFilter qFilter;
            DynamicObject declare;
            String investListId;
            DynamicObject proposal;
            String projectType = investList.getString("projecttype");
            if (StringUtils.equals((CharSequence)projectType, (CharSequence)"pmim_proposalbill_f7") && (proposal = investList.getDynamicObject("projectno")) != null && QueryServiceHelper.exists((String)"pmim_projectproposal", (Object)proposal.getPkValue())) {
                proposal = BusinessDataServiceHelper.loadSingle((Object)proposal.getPkValue(), (String)"pmim_projectproposal");
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit")) {
                    proposal.set("proinvestbudappamt", (Object)investList.getBigDecimal("probudappamtafadjust"));
                    proposal.set("yearbugapprovalamt", (Object)investList.getBigDecimal("yearappamtafadjust"));
                    proposal.set("approvaltime", (Object)new Date());
                } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
                    proposal.set("proinvestbudappamt", (Object)investList.getBigDecimal("projcetbugappamt"));
                    proposal.set("yearbugapprovalamt", (Object)investList.getBigDecimal("yearapproveamt"));
                    proposal.set("approvaltime", null);
                }
                proposalList.add(proposal);
            }
            if (!StringUtils.isNotBlank((CharSequence)(investListId = investList.getString("investlistid"))) || (declare = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)"adjuststatus", (QFilter[])new QFilter[]{qFilter = new QFilter("inventry.id", "=", (Object)Long.parseLong(investListId))})) == null) continue;
            String adjustStatus = StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit") ? "1" : "0";
            declare.set("adjuststatus", (Object)adjustStatus);
            declareList.add(declare);
        }
        if (proposalList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])proposalList.toArray(new DynamicObject[0]));
        }
        if (declareList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])declareList.toArray(new DynamicObject[0]));
        }
    }

    public void updateEffectiveBill(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        Date declareDate = bill.getDate("year");
        int declareYear = declareDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
        qFilter.and("YEAR(year)", "=", (Object)declareYear);
        qFilter.and("effectivestatus", "=", (Object)"1");
        qFilter.and("id", "!=", (Object)Long.parseLong(bill.getPkValue().toString()));
        DynamicObject planAdjust = BusinessDataServiceHelper.loadSingle((String)"pmim_investplanadjustment", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (planAdjust != null) {
            planAdjust = BusinessDataServiceHelper.loadSingle((Object)planAdjust.get("id"), (String)"pmim_investplanadjustment");
            planAdjust.set("effectivestatus", (Object)"0");
            planAdjust.set("stoptime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)planAdjust);
        }
        bill.set("effectivestatus", (Object)"1");
        bill.set("effectivetime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)bill);
    }
}

