/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.business.helper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.DocuimentTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import org.apache.commons.lang3.StringUtils;

public class InvestBudgetPlanHelper {
    public static void syncProjectProposalIsQuote(DynamicObject dynamicObject, boolean isQuote) {
        DynamicObject[] ppCol;
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("inventry");
        HashSet<Long> billIds = new HashSet<Long>();
        HashSet<Long> entryIds = new HashSet<Long>();
        DynamicObject[] f7Col = new DynamicObject[entrys.size()];
        int index = 0;
        for (DynamicObject entry : entrys) {
            DynamicObject projectProposalf7 = entry.getDynamicObject("inventry_projectproposal");
            String projectProposalId = projectProposalf7.getString("projectproposalid");
            billIds.add(Long.parseLong(projectProposalId));
            entryIds.add((Long)projectProposalf7.getPkValue());
            projectProposalf7.set("isquote", (Object)isQuote);
            f7Col[index] = projectProposalf7;
            ++index;
        }
        SaveServiceHelper.update((DynamicObject[])f7Col);
        for (DynamicObject projectProposal : ppCol = BusinessDataServiceHelper.load((String)"pmim_projectproposal", (String)String.join((CharSequence)",", "pmsgentry", "pmsgentry_isquote"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds.toArray())})) {
            DynamicObjectCollection pmsgEntrys = projectProposal.getDynamicObjectCollection("pmsgentry");
            for (DynamicObject pmsgentry : pmsgEntrys) {
                if (entryIds.add((Long)pmsgentry.getPkValue())) continue;
                pmsgentry.set("pmsgentry_isquote", (Object)isQuote);
            }
        }
        SaveServiceHelper.update((DynamicObject[])ppCol);
    }

    public void syncBudgetAuditBill(DynamicObject dynamicObject) {
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"pmim_budgetaudit");
        DynamicObject budgetAudit = new DynamicObject((DynamicObjectType)dynamicObjectType);
        this.constructAuditBillData(dynamicObject, budgetAudit);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetAudit});
    }

    public void synProjectProposalData(DynamicObject dynamicObject, String operationKey) {
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("inventry");
        DynamicObject[] f7Col = new DynamicObject[entrys.size()];
        int index = 0;
        for (DynamicObject entry : entrys) {
            DynamicObject projectProposalf7 = entry.getDynamicObject("inventry_projectproposal");
            projectProposalf7 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectProposalf7.getPkValue().toString()), (String)"pmim_projectproposal_f7");
            String projectProposalId = projectProposalf7.getString("projectproposalid");
            if ("audit".equals(operationKey)) {
                projectProposalf7.set("budgetapplyresult", (Object)"PASS");
                projectProposalf7.set("auditorg", (Object)dynamicObject.getDynamicObject("reportorg"));
                projectProposalf7.set("yearbugappamt", (Object)entry.getBigDecimal("inventry_yearbugamt"));
                projectProposalf7.set("yearfiappamt", (Object)entry.getBigDecimal("inventry_yearfiamt"));
            } else if ("unaudit".equals(operationKey)) {
                projectProposalf7.set("budgetapplyresult", (Object)" ");
                projectProposalf7.set("auditorg", (Object)0L);
                projectProposalf7.set("yearbugappamt", (Object)BigDecimal.ZERO);
                projectProposalf7.set("yearfiappamt", (Object)BigDecimal.ZERO);
            }
            f7Col[index] = projectProposalf7;
            ++index;
            DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectProposalId), (String)"pmim_projectproposal");
            DynamicObjectCollection pmsgEntrys = projectProposal.getDynamicObjectCollection("pmsgentry");
            for (DynamicObject pmsgentry : pmsgEntrys) {
                if (!projectProposalf7.getPkValue().equals(pmsgentry.getPkValue())) continue;
                if ("audit".equals(operationKey)) {
                    pmsgentry.set("budgetapplyresult", (Object)"PASS");
                    pmsgentry.set("auditorg", (Object)dynamicObject.getDynamicObject("reportorg"));
                    pmsgentry.set("yearbugappamt", (Object)entry.getBigDecimal("inventry_yearbugamt"));
                    pmsgentry.set("yearfiappamt", (Object)entry.getBigDecimal("inventry_yearfiamt"));
                    break;
                }
                if (!"unaudit".equals(operationKey)) break;
                pmsgentry.set("budgetapplyresult", (Object)" ");
                pmsgentry.set("auditorg", (Object)0L);
                pmsgentry.set("yearbugappamt", (Object)BigDecimal.ZERO);
                pmsgentry.set("yearfiappamt", (Object)BigDecimal.ZERO);
                break;
            }
            SaveServiceHelper.update((DynamicObject)projectProposal);
        }
        SaveServiceHelper.update((DynamicObject[])f7Col);
    }

    public void syncBudgetBaseData(DynamicObject dynamicObject, String formBillId, String operationKey) {
        if (formBillId.equals("pmim_investbugetplan") || formBillId.equals("pmim_budgetaudit")) {
            this.syncBudgetBaseDataByInvestBudget(dynamicObject, formBillId, operationKey);
        } else if (formBillId.equals("pmim_aunualinvestplan") || formBillId.equals("pmim_specialdeclarainvest")) {
            this.syncBudgetBaseDataByDeclare(dynamicObject, operationKey);
        }
    }

    private void syncBudgetBaseDataByDeclare(DynamicObject curObject, String operationKey) {
        DynamicObjectCollection investEntries = curObject.getDynamicObjectCollection("inventry");
        List<DynamicObject> passInvests = investEntries.stream().filter(entry -> entry.getString("inventry_approvalcon").equals("pass")).collect(Collectors.toList());
        DynamicObject[] budgetBaseCol = null;
        if ("audit".equals(operationKey)) {
            budgetBaseCol = this.createBudgetBaseData(curObject, passInvests);
        } else if ("unaudit".equals(operationKey)) {
            budgetBaseCol = this.backOffBudgetBaseData(curObject, passInvests);
        }
        if (budgetBaseCol != null && budgetBaseCol.length > 0) {
            for (DynamicObject budgetBase : budgetBaseCol) {
                if (QueryServiceHelper.exists((String)"pmim_budgetbase", (Object)budgetBase.getPkValue())) {
                    SaveServiceHelper.update((DynamicObject)budgetBase);
                    continue;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetBase});
            }
        }
    }

    protected DynamicObject[] backOffBudgetBaseData(DynamicObject curObject, List<DynamicObject> passInvests) {
        DynamicObject[] budgetBaseCol = null;
        for (DynamicObject entry : passInvests) {
            String investBudgetPlanId;
            DynamicObject projectProposal = entry.getDynamicObject("projectno");
            if (projectProposal == null) continue;
            LocalDate curYear = curObject.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            QFilter deleteQFilter = new QFilter("YEAR(year)", "=", (Object)curYear.getYear());
            deleteQFilter.and("investbudgetplan", "=", (Object)curObject.getPkValue().toString());
            DeleteServiceHelper.delete((String)"pmim_budgetbase", (QFilter[])new QFilter[]{deleteQFilter});
            DynamicObject lastObject = this.gainLastVersionObj(curObject, entry);
            if (lastObject == null) continue;
            String billFormId = lastObject.getDataEntityType().getName();
            if ("pmim_aunualinvestplan".equals(billFormId) || "pmim_specialdeclarainvest".equals(billFormId)) {
                DynamicObjectCollection investEntries = lastObject.getDynamicObjectCollection("inventry");
                List<DynamicObject> lastInvest = investEntries.stream().filter(item -> item.getString("inventry_approvalcon").equals("pass")).collect(Collectors.toList());
                budgetBaseCol = this.createBudgetBaseData(lastObject, lastInvest);
            }
            if ("pmim_investbugetplan".equals(billFormId)) {
                DynamicObjectCollection lastInvest = lastObject.getDynamicObjectCollection("inventry");
                budgetBaseCol = new DynamicObject[lastInvest.size()];
                this.constructBudgetBaseData(lastObject, budgetBaseCol);
            }
            if (!"pmim_budgetaudit".equals(billFormId) || StringUtil.isEmpty((String)(investBudgetPlanId = lastObject.getString("investbudgetplan")))) continue;
            DynamicObject investBudgetPlan = BusinessDataServiceHelper.loadSingle((Object)investBudgetPlanId, (String)"pmim_investbugetplan");
            DynamicObjectCollection lastInvest = investBudgetPlan.getDynamicObjectCollection("inventry");
            budgetBaseCol = new DynamicObject[lastInvest.size()];
            this.constructBudgetBaseData(investBudgetPlan, budgetBaseCol);
        }
        return budgetBaseCol;
    }

    protected DynamicObject gainLastVersionObj(DynamicObject curObject, DynamicObject entry) {
        DynamicObject lastObject = null;
        String investListId = entry.getString("inventry_investlistid");
        DynamicObject projectProposal = entry.getDynamicObject("projectno");
        LocalDate curYear = curObject.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)curYear.getYear());
        qFilter.and("budgetapplyresult", "=", (Object)"PASS");
        if (StringUtils.isNotBlank((CharSequence)investListId)) {
            qFilter.and("id", "!=", (Object)Long.parseLong(investListId));
        }
        if ("bd_project".equals(entry.getString("projecttype"))) {
            qFilter.and("project", "=", (Object)Long.parseLong(projectProposal.getPkValue().toString()));
            DynamicObject[] projectProposalF7 = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");
            DynamicObject livestDeclare = null;
            QFilter declareQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.DECLARE.getValue());
            if (projectProposalF7.length > 0) {
                DynamicObject lastVersion = projectProposalF7[0];
                qFilter = new QFilter("inventry.inventry_investlistid", "=", (Object)lastVersion.getPkValue().toString());
                qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                livestDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter, declareQFilter});
                if (livestDeclare == null) {
                    declareQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
                    livestDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_specialdeclarainvest", (String)"id", (QFilter[])new QFilter[]{qFilter, declareQFilter});
                }
            } else {
                qFilter = new QFilter("YEAR(year)", "=", (Object)curYear.getYear());
                qFilter.and("inventry.projectno", "=", (Object)Long.parseLong(projectProposal.getPkValue().toString()));
                qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                qFilter.and("id", "!=", (Object)Long.parseLong(curObject.getPkValue().toString()));
                declareQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
                DynamicObject[] investBills = BusinessDataServiceHelper.load((String)"pmim_specialdeclarainvest", (String)"id", (QFilter[])new QFilter[]{qFilter, declareQFilter}, (String)" \nauditdate desc");
                if (investBills.length > 0) {
                    livestDeclare = investBills[0];
                }
            }
            if (livestDeclare != null) {
                String billFormId = livestDeclare.getDataEntityType().getName();
                lastObject = BusinessDataServiceHelper.loadSingle((Object)livestDeclare.getPkValue(), (String)billFormId);
            }
        } else {
            qFilter.and("projectproposalid", "=", (Object)projectProposal.getPkValue().toString());
            DynamicObject[] projectProposalF7 = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"version desc");
            if (projectProposalF7.length > 0) {
                DynamicObject lastVersion = projectProposalF7[0];
                qFilter = new QFilter("inventry.inventry_investlistid", "=", (Object)lastVersion.getPkValue().toString());
                qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter declareQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.DECLARE.getValue());
                DynamicObject livestDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_aunualinvestplan", (String)"id", (QFilter[])new QFilter[]{qFilter, declareQFilter});
                if (livestDeclare == null) {
                    declareQFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
                    livestDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_specialdeclarainvest", (String)"id", (QFilter[])new QFilter[]{qFilter, declareQFilter});
                }
                if (livestDeclare == null) {
                    qFilter = new QFilter("isreport", "=", (Object)false);
                    qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                    qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    qFilter.and(new QFilter("inventry.inventry_projectproposal", "=", (Object)Long.parseLong(lastVersion.getPkValue().toString())));
                    livestDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_investbugetplan", (String)"id", (QFilter[])new QFilter[]{qFilter});
                }
                if (livestDeclare == null) {
                    qFilter = new QFilter("isreport", "=", (Object)true);
                    qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                    qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    qFilter.and(new QFilter("inventry.inventry_projectproposal", "=", (Object)Long.parseLong(lastVersion.getPkValue().toString())));
                    DynamicObject reportLivest = BusinessDataServiceHelper.loadSingle((String)"pmim_investbugetplan", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (reportLivest != null) {
                        qFilter = new QFilter("investbudgetplan", "=", (Object)reportLivest.getPkValue().toString());
                        qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                        livestDeclare = BusinessDataServiceHelper.loadSingle((String)"pmim_budgetaudit", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    }
                }
                if (livestDeclare != null) {
                    String billFormId = livestDeclare.getDataEntityType().getName();
                    lastObject = BusinessDataServiceHelper.loadSingle((Object)livestDeclare.getPkValue(), (String)billFormId);
                }
            }
        }
        return lastObject;
    }

    protected DynamicObject[] createBudgetBaseData(DynamicObject curObject, List<DynamicObject> passInvests) {
        DynamicObject[] budgetBaseCol = new DynamicObject[passInvests.size()];
        int index = 0;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmim_budgetbase");
        for (DynamicObject entry : passInvests) {
            DynamicObject projectProposal = entry.getDynamicObject("projectno");
            if (projectProposal == null) continue;
            LocalDate curYear = curObject.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)curYear.getYear());
            DynamicObject budgetBase = null;
            if ("bd_project".equals(entry.getString("projecttype"))) {
                QFilter proQFilter = new QFilter("pro", "=", (Object)Long.parseLong(projectProposal.getPkValue().toString()));
                DynamicObject proAppF7 = BusinessDataServiceHelper.loadSingle((String)"pmas_proappf7", (String)"billname,proproposal,org", (QFilter[])new QFilter[]{proQFilter});
                if (proAppF7 != null) {
                    qFilter.and("projectname.fbasedataid_id", "in", proAppF7.getPkValue());
                    budgetBase = BusinessDataServiceHelper.loadSingle((String)"pmim_budgetbase", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    budgetBase = budgetBase == null ? new DynamicObject((DynamicObjectType)dt) : BusinessDataServiceHelper.loadSingle((Object)budgetBase.getPkValue(), (String)"pmim_budgetbase");
                    DynamicObjectCollection projectNames = budgetBase.getDynamicObjectCollection("projectname");
                    projectNames.clear();
                    DynamicObject projectName = new DynamicObject(projectNames.getDynamicObjectType());
                    projectName.set("fbasedataid_id", proAppF7.getPkValue());
                    projectNames.add((Object)projectName);
                    budgetBase.set("reportorg", (Object)proAppF7.getDynamicObject("org"));
                }
            } else {
                qFilter = new QFilter("proproposal", "=", (Object)Long.parseLong(projectProposal.getPkValue().toString()));
                budgetBase = BusinessDataServiceHelper.loadSingle((String)"pmim_budgetbase", (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, year, yearbugamt, yearfiamt, arrearsamt, lastyearbugamt, lastyearfiamt, proproposal, reportorg, replyorg, projectname, investbudgetplan,Projectkind", (QFilter[])new QFilter[]{qFilter});
                if (budgetBase == null) {
                    budgetBase = new DynamicObject((DynamicObjectType)dt);
                }
                qFilter = new QFilter("projectproposalid", "=", (Object)projectProposal.getPkValue().toString());
                qFilter.and("YEAR(year)", "=", (Object)curYear.getYear());
                qFilter.and("datasource", "=", (Object)"projectProposal");
                qFilter.and("reportbudget", "=", (Object)Boolean.TRUE);
                qFilter.and("accepted", "=", (Object)Boolean.FALSE);
                DynamicObject[] lastVersion = BusinessDataServiceHelper.load((String)"pmim_projectproposal_f7", (String)String.join((CharSequence)",", "id", "reportorg", "version"), (QFilter[])new QFilter[]{qFilter}, (String)"version desc");
                if (lastVersion.length > 0) {
                    budgetBase.set("reportorg", (Object)lastVersion[0].getDynamicObject("reportorg"));
                } else {
                    projectProposal = BusinessDataServiceHelper.loadSingle((Object)projectProposal.getPkValue(), (String)"pmim_proposalbill_f7");
                    budgetBase.set("reportorg", (Object)projectProposal.getDynamicObject("org"));
                }
                budgetBase.set("proproposal", (Object)projectProposal);
            }
            if (budgetBase == null) continue;
            budgetBase.set("investbudgetplan", (Object)curObject.getPkValue().toString());
            budgetBase.set("number", curObject.get("billno"));
            budgetBase.set("name", curObject.get("billname"));
            budgetBase.set("year", curObject.get("year"));
            budgetBase.set("replyorg", curObject.get("org"));
            budgetBase.set("yearbugamt", entry.get("inventry_approveamt"));
            budgetBase.set("yearfiamt", entry.get("inventry_finanapproveamt"));
            budgetBase.set("arrearsamt", entry.get("inventry_arrearsamt"));
            budgetBase.set("lastyearbugamt", entry.get("inventry_lastyearbugamt"));
            budgetBase.set("lastyearfiamt", entry.get("inventry_lastyearfiamt"));
            budgetBase.set("enable", (Object)1);
            budgetBase.set("projectkind", (Object)entry.getDynamicObject("inventry_projectkind"));
            budgetBaseCol[index] = budgetBase;
            ++index;
        }
        return budgetBaseCol;
    }

    private void syncBudgetBaseDataByInvestBudget(DynamicObject dynamicObject, String formBillId, String operationKey) {
        DynamicObjectCollection inventrys = dynamicObject.getDynamicObjectCollection("inventry");
        DynamicObject[] budgetBaseCol = new DynamicObject[inventrys.size()];
        this.constructBudgetBaseData(dynamicObject, budgetBaseCol);
        SaveServiceHelper.save((DynamicObject[])budgetBaseCol);
        if (!dynamicObject.getBoolean("isreport") && formBillId.equals("pmim_investbugetplan") || formBillId.equals("pmim_budgetaudit")) {
            this.synProjectProposalData(dynamicObject, operationKey);
        }
    }

    protected void constructBudgetBaseData(DynamicObject dynamicObject, DynamicObject[] budgetBaseCol) {
        DynamicObjectCollection inventrys = dynamicObject.getDynamicObjectCollection("inventry");
        int index = 0;
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"pmim_budgetbase");
        for (DynamicObject inventry : inventrys) {
            DynamicObject budgetBase = new DynamicObject((DynamicObjectType)dynamicObjectType);
            budgetBase.set("investbudgetplan", (Object)dynamicObject.getPkValue().toString());
            budgetBase.set("number", dynamicObject.get("billno"));
            budgetBase.set("name", dynamicObject.get("billname"));
            budgetBase.set("year", dynamicObject.get("year"));
            budgetBase.set("reportorg", dynamicObject.get("org"));
            budgetBase.set("replyorg", dynamicObject.get("reportorg"));
            budgetBase.set("yearbugamt", inventry.get("inventry_yearbugamt"));
            budgetBase.set("yearfiamt", inventry.get("inventry_yearfiamt"));
            budgetBase.set("arrearsamt", inventry.get("inventry_arrearsamt"));
            budgetBase.set("lastyearbugamt", inventry.get("inventry_lastyearbugamt"));
            budgetBase.set("lastyearfiamt", inventry.get("inventry_lastyearfiamt"));
            budgetBase.set("enable", (Object)1);
            DynamicObject projectProposalf7 = inventry.getDynamicObject("inventry_projectproposal");
            budgetBase.set("proproposal", projectProposalf7.get("projectproposalid"));
            budgetBaseCol[index] = budgetBase;
            ++index;
        }
    }

    protected void constructAuditBillData(DynamicObject investBudgetPlan, DynamicObject budgetAudit) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmim_budgetaudit", (DynamicObject)budgetAudit, (String)String.valueOf(RequestContext.get().getOrgId()));
        budgetAudit.set("org", investBudgetPlan.get("reportorg"));
        if (null != codeRuleInfo) {
            budgetAudit.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)budgetAudit));
        } else {
            budgetAudit.set("billno", investBudgetPlan.get("billno"));
        }
        budgetAudit.set("yearbugappno", (Object)investBudgetPlan);
        budgetAudit.set("yearbugappname", investBudgetPlan.get("billname"));
        budgetAudit.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s\u7684\u5ba1\u6279\u5355", (String)"InvestBudgetPlanHelper_1", (String)"pmgt-pmim-business", (Object[])new Object[0]), investBudgetPlan.get("billname")));
        budgetAudit.set("year", investBudgetPlan.get("year"));
        budgetAudit.set("fillorg", investBudgetPlan.get("org"));
        budgetAudit.set("yearbugamt", investBudgetPlan.get("yearbugamt"));
        budgetAudit.set("yearfiamt", investBudgetPlan.get("yearfiamt"));
        budgetAudit.set("description", investBudgetPlan.get("description"));
        budgetAudit.set("creator", investBudgetPlan.get("creator"));
        budgetAudit.set("createtime", investBudgetPlan.get("createtime"));
        budgetAudit.set("billstatus", (Object)"A");
        budgetAudit.set("creator", investBudgetPlan.get("creator"));
        budgetAudit.set("createtime", investBudgetPlan.get("createtime"));
        budgetAudit.set("investbudgetplan", (Object)investBudgetPlan.getPkValue().toString());
        DynamicObjectCollection newInventrys = budgetAudit.getDynamicObjectCollection("inventry");
        DynamicObjectCollection invbugetEntry = investBudgetPlan.getDynamicObjectCollection("inventry");
        for (DynamicObject invbugetentry : invbugetEntry) {
            DynamicObject newInventry = newInventrys.addNew();
            newInventry.set("bugetnumber", invbugetentry.get("inventry_bugetnumber"));
            newInventry.set("projectproposal", invbugetentry.get("inventry_projectproposal"));
            newInventry.set("projectstatus", invbugetentry.get("inventry_projectstatus"));
            newInventry.set("bugetamt", invbugetentry.get("inventry_bugetamt"));
            newInventry.set("arrearsamt", invbugetentry.get("inventry_arrearsamt"));
            newInventry.set("inventry_yearbugamt", invbugetentry.get("inventry_yearbugamt"));
            newInventry.set("inventry_yearfiamt", invbugetentry.get("inventry_yearfiamt"));
            newInventry.set("lastyearbugamt", invbugetentry.get("inventry_lastyearbugamt"));
            newInventry.set("lastyearfiamt", invbugetentry.get("inventry_lastyearfiamt"));
            newInventry.set("projectkind", invbugetentry.get("inventry_projectkind"));
        }
    }
}

