/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.projectkind.ProjectKindService;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.MapSortUtil;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmim.business.bean.investscreen.InvestAmountBean;
import kd.pmgt.pmim.business.bean.investscreen.InvestByKindBean;
import kd.pmgt.pmim.business.bean.investscreen.OrgBean;
import kd.pmgt.pmim.business.bean.investscreen.ProByKindBean;
import kd.pmgt.pmim.business.bean.investscreen.ProKindBean;

public class InvestScreenService {
    private String VIEW_PERM_ITEM_ID = "47150e89000000ac";
    private BigDecimal ONE_HUNDRED_DECIMAL = new BigDecimal(100);
    private final String[] COLUMNKEY = new String[]{"projectkind", "month_1", "month_2", "month_3", "month_4", "month_5", "month_6", "month_7", "month_8", "month_9", "month_10", "month_11", "month_12", "month_13"};
    private String[] header = null;
    private ProjectKindService projectKindService = new ProjectKindService();

    public void getInitData(JSONObject returnData, IFormView view) {
        long orgId = RequestContext.get().getOrgId();
        DynamicObject currency = CurrencyHelper.getCurrency((Long)orgId);
        if (currency == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u672a\u627e\u5230\u3002", (String)"InvestScreenService_17", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            this.initReturnData(returnData);
            return;
        }
        returnData.put("currency", (Object)currency.getLocaleString("name").getLocaleValue());
        this.getOrgInfo(returnData);
        int year = Calendar.getInstance().get(1);
        returnData.put("year", (Object)year);
        this.getReserveProInfo(orgId, false, year, returnData);
        this.getApprovalProInfo(orgId, false, year, returnData);
        this.getCompleteProInfo(orgId, false, year, returnData);
        List<Long> projectKindIds = this.getProjectKindsInfo(orgId, false, returnData);
        this.getInvestInfo(orgId, false, year, projectKindIds, returnData, view);
    }

    public void getAllData(JSONObject requestParams, JSONObject returnData, IFormView view) {
        long orgId = requestParams.getLong("orgId");
        DynamicObject currency = CurrencyHelper.getCurrency((Long)orgId);
        if (currency == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u672a\u627e\u5230\u3002", (String)"InvestScreenService_17", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            this.initReturnData(returnData);
            return;
        }
        returnData.put("currency", (Object)currency.getLocaleString("name").getLocaleValue());
        boolean includeSub = requestParams.getBoolean("includeSub");
        int year = requestParams.getInteger("year");
        List<Long> projectKindIds = this.getProjectKindsInfo(orgId, includeSub, returnData);
        this.getReserveProInfo(orgId, includeSub, year, returnData);
        this.getApprovalProInfo(orgId, includeSub, year, returnData);
        this.getCompleteProInfo(orgId, includeSub, year, returnData);
        this.getInvestInfo(orgId, includeSub, year, projectKindIds, returnData, view);
    }

    public void getReserveProData(JSONObject requestParams, JSONObject returnData) {
        long orgId = requestParams.getLong("orgId");
        boolean includeSub = requestParams.getBoolean("includeSub");
        int year = requestParams.getInteger("year");
        this.getReserveProInfo(orgId, includeSub, year, returnData);
    }

    public void getApprovalProData(JSONObject requestParams, JSONObject returnData) {
        long orgId = requestParams.getLong("orgId");
        boolean includeSub = requestParams.getBoolean("includeSub");
        int year = requestParams.getInteger("year");
        this.getApprovalProInfo(orgId, includeSub, year, returnData);
    }

    public void getCompleteProData(JSONObject requestParams, JSONObject returnData) {
        long orgId = requestParams.getLong("orgId");
        boolean includeSub = requestParams.getBoolean("includeSub");
        int year = requestParams.getInteger("year");
        this.getCompleteProInfo(orgId, includeSub, year, returnData);
    }

    public void getInvestData(JSONObject requestParams, JSONObject returnData, IFormView view) {
        long orgId = requestParams.getLong("orgId");
        boolean includeSub = requestParams.getBoolean("includeSub");
        int year = requestParams.getInteger("year");
        List<Long> projectKindIds = requestParams.getJSONArray("projectKindIds").stream().map(kind -> Long.parseLong(kind.toString())).collect(Collectors.toList());
        this.getInvestInfo(orgId, includeSub, year, projectKindIds, returnData, view);
    }

    public void getOrgInfo(JSONObject returnData) {
        long userId = UserServiceHelper.getCurrentUserId();
        List permObjectList = PermissionServiceHelper.getPermObjectsByNumber((String)"pmim_investment_screen");
        String permId = "";
        for (Map map : permObjectList) {
            if (map.get("permItemId") == null || !((String)map.get("permItemId")).equals(this.VIEW_PERM_ITEM_ID)) continue;
            permId = (String)map.get("permItemId");
            break;
        }
        List allAllPermOrgId = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)"pmim", (String)"pmim_investment_screen", (String)permId);
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allAllPermOrgId)});
        ArrayList<OrgBean> orgBeanList = new ArrayList<OrgBean>(10);
        for (DynamicObject dynamicObject : orgArr) {
            OrgBean orgBean = new OrgBean();
            orgBean.setId(String.valueOf(dynamicObject.getPkValue()));
            String orgName = dynamicObject.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)orgName)) {
                orgName = dynamicObject.getString("name");
            }
            orgBean.setName(orgName);
            if (dynamicObject.getPkValue().equals(RequestContext.get().getOrgId())) {
                returnData.put("defaultOrg", (Object)orgBean);
            }
            orgBeanList.add(orgBean);
        }
        returnData.put("orgList", orgBeanList);
        returnData.put("includeSub", (Object)Boolean.FALSE);
    }

    public List<Long> getProjectKindsInfo(long orgId, boolean includeSub, JSONObject returnData) {
        DynamicObject[] projectKindArr;
        ArrayList<ProKindBean> projectKinds = new ArrayList<ProKindBean>(10);
        ArrayList<Long> projectKindIds = new ArrayList<Long>(10);
        for (DynamicObject projectKind : projectKindArr = this.projectKindService.getAuthorizedProjectKindList(null, Long.valueOf(orgId))) {
            ProKindBean proKindBean = new ProKindBean();
            proKindBean.setId(String.valueOf(projectKind.getPkValue()));
            String projectKindName = projectKind.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)projectKindName)) {
                projectKindName = projectKind.getString("name");
            }
            proKindBean.setName(projectKindName);
            projectKinds.add(proKindBean);
            projectKindIds.add(Long.parseLong(projectKind.getPkValue().toString()));
        }
        returnData.put("projectKinds", projectKinds);
        return projectKindIds;
    }

    public void getReserveProInfo(long orgId, boolean includeSub, int year, JSONObject returnData) {
        Date yearStartTime = DateUtil.getYearStartTime((int)year);
        Date yearEndTime = DateUtil.getYearEndTime((int)year);
        ArrayList passDeclareBills = new ArrayList(16);
        List<Long> orgList = new ArrayList<Long>(10);
        orgList.add(orgId);
        if (includeSub) {
            orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter dateFilter = new QFilter("year", ">=", (Object)yearStartTime).and("year", "<=", (Object)yearEndTime);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] declareBills = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)String.join((CharSequence)",", "inventry", "projectno", "inventry_approveamt", "projecttype", "inventry_approvalcon", "inventry_projectkind"), (QFilter[])new QFilter[]{statusFilter, auditFilter, orgFilter, dateFilter});
        if (declareBills.length > 0) {
            for (DynamicObject declareBill : declareBills) {
                List passReserves;
                DynamicObjectCollection entries = declareBill.getDynamicObjectCollection("inventry");
                if (entries.size() <= 0 || (passReserves = entries.stream().filter(o -> StringUtil.equals((String)o.getString("inventry_approvalcon"), (String)"pass")).filter(o -> StringUtil.equals((String)o.getString("projecttype"), (String)"pmim_proposalbill_f7")).collect(Collectors.toList())).size() <= 0) continue;
                passDeclareBills.addAll(passReserves);
            }
        }
        if (passDeclareBills.size() > 0) {
            BigDecimal reserveProAmount = passDeclareBills.stream().map(bill -> bill.getBigDecimal("inventry_approveamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            returnData.put("proAmount", (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)reserveProAmount));
            int reserveProCount = passDeclareBills.size();
            returnData.put("proCount", (Object)reserveProCount);
            HashMap<Object, BigDecimal> reserveAmountMap = new HashMap<Object, BigDecimal>(16);
            HashMap<Object, Integer> reserveCountMap = new HashMap<Object, Integer>(16);
            for (DynamicObject reservePro : passDeclareBills) {
                DynamicObject projectKind = reservePro.getDynamicObject("inventry_projectkind");
                BigDecimal amount = reservePro.getBigDecimal("inventry_approveamt");
                if (projectKind == null) continue;
                BigDecimal amountByKind = (BigDecimal)reserveAmountMap.get(projectKind.getPkValue());
                if (amountByKind == null) {
                    reserveAmountMap.put(projectKind.getPkValue(), amount);
                } else {
                    reserveAmountMap.put(projectKind.getPkValue(), amountByKind.add(amount));
                }
                Integer countByKind = (Integer)reserveCountMap.get(projectKind.getPkValue());
                if (countByKind == null) {
                    reserveCountMap.put(projectKind.getPkValue(), 1);
                    continue;
                }
                reserveCountMap.put(projectKind.getPkValue(), countByKind + 1);
            }
            this.projectTypeAnalysis(reserveAmountMap, reserveCountMap, reserveProAmount, reserveProCount, "reserveAmountByKind", "reserveCountByKind", returnData);
        }
    }

    public void getApprovalProInfo(long orgId, boolean includeSub, int year, JSONObject returnData) {
        Date yearStartTime = DateUtil.getYearStartTime((int)year);
        Date yearEndTime = DateUtil.getYearEndTime((int)year);
        List<Long> orgList = new ArrayList<Long>(10);
        orgList.add(orgId);
        if (includeSub) {
            orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter createTimeStartFilter = new QFilter("createtime", ">=", (Object)yearStartTime);
        QFilter createTimeEndFilter = new QFilter("createtime", "<=", (Object)yearEndTime);
        QFilter applyDateFilter = new QFilter("projectapplydate", "is not null", null).and("projectapplydate", ">=", (Object)yearStartTime).and("projectapplydate", "<=", (Object)yearEndTime);
        QFilter createDateFilter = new QFilter("projectapplydate", "is null", null).and(createTimeStartFilter).and(createTimeEndFilter);
        QFilter dateFilter = applyDateFilter.or(createDateFilter);
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"isreport,projcetbugamt,kind", (QFilter[])new QFilter[]{auditFilter, orgFilter, dateFilter});
        List approvalPros = Arrays.stream(proApps).filter(proApp -> !proApp.getBoolean("isreport") || proApp.getBoolean("isreport") && BusinessDataServiceHelper.loadSingle((String)"pmas_proj_audit", (String)"id", (QFilter[])new QFilter[]{new QFilter("project", "=", (Object)String.valueOf(proApp.getPkValue())), auditFilter}) != null).collect(Collectors.toList());
        BigDecimal approvalProAmount = approvalPros.stream().map(proApp -> proApp.getBigDecimal("projcetbugamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        returnData.put("approvalProAmount", (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)approvalProAmount));
        int approvalProCount = approvalPros.size();
        returnData.put("approvalProCount", (Object)approvalProCount);
        HashMap<Object, BigDecimal> approvalAmountMap = new HashMap<Object, BigDecimal>(16);
        HashMap<Object, Integer> approvalCountMap = new HashMap<Object, Integer>(16);
        for (DynamicObject approvalPro : approvalPros) {
            DynamicObject projectKind = approvalPro.getDynamicObject("kind");
            BigDecimal amount = approvalPro.getBigDecimal("projcetbugamt");
            if (projectKind == null) continue;
            BigDecimal amountByKind = (BigDecimal)approvalAmountMap.get(projectKind.getPkValue());
            if (amountByKind == null) {
                approvalAmountMap.put(projectKind.getPkValue(), amount);
            } else {
                approvalAmountMap.put(projectKind.getPkValue(), amountByKind.add(amount));
            }
            Integer countByKind = (Integer)approvalCountMap.get(projectKind.getPkValue());
            if (countByKind == null) {
                approvalCountMap.put(projectKind.getPkValue(), 1);
                continue;
            }
            approvalCountMap.put(projectKind.getPkValue(), countByKind + 1);
        }
        this.projectTypeAnalysis(approvalAmountMap, approvalCountMap, approvalProAmount, approvalProCount, "approvalAmountByKind", "approvalCountByKind", returnData);
    }

    public void getCompleteProInfo(long orgId, boolean includeSub, int year, JSONObject returnData) {
        DynamicObject[] proApps;
        Date yearStartTime = DateUtil.getYearStartTime((int)year);
        Date yearEndTime = DateUtil.getYearEndTime((int)year);
        List<Long> orgList = new ArrayList<Long>(10);
        orgList.add(orgId);
        if (includeSub) {
            orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter createTimeStartFilter = new QFilter("createtime", ">=", (Object)yearStartTime);
        QFilter createTimeEndFilter = new QFilter("createtime", "<=", (Object)yearEndTime);
        BigDecimal completeProAmount = BigDecimal.ZERO;
        int completeProCount = 0;
        HashMap<Object, BigDecimal> completeAmountMap = new HashMap<Object, BigDecimal>(16);
        HashMap<Object, Integer> completeCountMap = new HashMap<Object, Integer>(16);
        QFilter proEndTimeFilter = new QFilter("proendtime", "is not null", null).and("proendtime", ">=", (Object)yearStartTime).and("proendtime", "<=", (Object)yearEndTime);
        QFilter createDateFilter = new QFilter("proendtime", "is null", null).and(createTimeStartFilter).and(createTimeEndFilter);
        QFilter dateFilter = proEndTimeFilter.or(createDateFilter);
        QFilter newStatusFilter = new QFilter("newstatus.number", "=", (Object)ProjectStatusEnum.BUSSINESS_CLOSE.getValue()).and("newstatus.issys", "=", (Object)true);
        for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,kind,projcetbugamt", (QFilter[])new QFilter[]{auditFilter, orgFilter})) {
            DynamicObject projectKind;
            BigDecimal amount = BigDecimal.ZERO;
            DynamicObject pro = proApp.getDynamicObject("pro");
            if (pro == null) continue;
            QFilter proFilter = new QFilter("project", "=", pro.getPkValue());
            DynamicObject proCompleteAccept = BusinessDataServiceHelper.loadSingle((String)"pmsc_pro_comp_acc", (String)"prototalinvest", (QFilter[])new QFilter[]{proFilter, dateFilter, auditFilter});
            boolean complete = false;
            if (proCompleteAccept != null) {
                amount = proCompleteAccept.getBigDecimal("prototalinvest");
                completeProAmount = completeProAmount.add(amount);
                ++completeProCount;
                complete = true;
            } else {
                DynamicObject projectExecStatus = BusinessDataServiceHelper.loadSingle((String)"pmsc_projectexecstatus", (String)"", (QFilter[])new QFilter[]{proFilter, auditFilter, newStatusFilter, createTimeStartFilter, createTimeEndFilter});
                if (projectExecStatus != null) {
                    amount = proApp.getBigDecimal("projcetbugamt");
                    completeProAmount = completeProAmount.add(amount);
                    ++completeProCount;
                    complete = true;
                }
            }
            if (!complete || (projectKind = proApp.getDynamicObject("kind")) == null) continue;
            BigDecimal amountByKind = (BigDecimal)completeAmountMap.get(projectKind.getPkValue());
            if (amountByKind == null) {
                completeAmountMap.put(projectKind.getPkValue(), amount);
            } else {
                completeAmountMap.put(projectKind.getPkValue(), amountByKind.add(amount));
            }
            Integer countByKind = (Integer)completeCountMap.get(projectKind.getPkValue());
            if (countByKind == null) {
                completeCountMap.put(projectKind.getPkValue(), 1);
                continue;
            }
            completeCountMap.put(projectKind.getPkValue(), countByKind + 1);
        }
        returnData.put("completeProAmount", (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)completeProAmount));
        returnData.put("completeProCount", (Object)completeProCount);
        this.projectTypeAnalysis(completeAmountMap, completeCountMap, completeProAmount, completeProCount, "completeAmountByKind", "completeCountByKind", returnData);
    }

    /*
     * WARNING - void declaration
     */
    public void getInvestInfo(long orgId, boolean includeSub, int year, List<Long> projectKindIds, JSONObject returnData, IFormView view) {
        Date yearStartTime = DateUtil.getYearStartTime((int)year);
        Date yearEndTime = DateUtil.getYearEndTime((int)year);
        List<Long> orgList = new ArrayList<Long>(10);
        orgList.add(orgId);
        if (includeSub) {
            orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter createTimeStartFilter = new QFilter("createtime", ">=", (Object)yearStartTime);
        QFilter createTimeEndFilter = new QFilter("createtime", "<=", (Object)yearEndTime);
        QFilter yearFilter = createTimeStartFilter.and(createTimeEndFilter);
        QFilter periodStartFilter = new QFilter("period", ">=", (Object)yearStartTime);
        QFilter periodEndFilter = new QFilter("period", "<=", (Object)yearEndTime);
        QFilter periodFilter = periodStartFilter.and(periodEndFilter);
        QFilter kindIdFilter = new QFilter("id", "in", projectKindIds);
        Map<Object, DynamicObject> projectKindMap = Stream.of(BusinessDataServiceHelper.load((String)"bd_projectkind", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,description", (QFilter[])new QFilter[]{kindIdFilter})).collect(Collectors.toList()).stream().collect(Collectors.toMap(DataEntityBase::getPkValue, a -> a, (k1, k2) -> k1));
        HashMap<Object, BigDecimal> amountByKindMap = new HashMap<Object, BigDecimal>(16);
        HashMap amountByKindAndMonthMap = new HashMap(16);
        HashMap<Integer, BigDecimal> amountByMonthMap = new HashMap<Integer, BigDecimal>(16);
        BigDecimal allInvestAmount = BigDecimal.ZERO;
        for (DynamicObject projectKind : projectKindMap.values()) {
            QFilter kindFilter = new QFilter("projectkind", "=", projectKind.getPkValue());
            List<DynamicObject> investRegisterList = Arrays.asList(BusinessDataServiceHelper.load((String)"pmfs_investregister", (String)"investamount,createtime", (QFilter[])new QFilter[]{orgFilter, auditFilter, kindFilter, yearFilter}));
            BigDecimal investRegisterAmount = investRegisterList.stream().map(invest -> invest.getBigDecimal("investamount")).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal(10000));
            List<DynamicObject> imageProgressReportList = Arrays.asList(BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"mutiwbs,periodinvest,entryEntity.entryperiodinvest,period", (QFilter[])new QFilter[]{orgFilter, auditFilter, kindFilter, periodFilter}));
            Object imageProgressReportAmount = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : imageProgressReportList) {
                if (dynamicObject.getBoolean("mutiwbs")) {
                    DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryEntity) {
                        imageProgressReportAmount = ((BigDecimal)imageProgressReportAmount).add(entry.getBigDecimal("entryperiodinvest"));
                    }
                    continue;
                }
                imageProgressReportAmount = ((BigDecimal)imageProgressReportAmount).add(dynamicObject.getBigDecimal("periodinvest"));
            }
            BigDecimal bigDecimal = investRegisterAmount.add((BigDecimal)imageProgressReportAmount);
            amountByKindMap.put(projectKind.getPkValue(), bigDecimal);
            allInvestAmount = allInvestAmount.add(bigDecimal);
            Map map = (Map)amountByKindAndMonthMap.get(projectKind.getPkValue());
            if (map == null) {
                HashMap hashMap = new HashMap(16);
                amountByKindAndMonthMap.put(projectKind.getPkValue(), hashMap);
            }
            for (int month = 1; month <= 12; ++month) {
                void var33_38;
                Date firstDayOfMonth = DateUtil.getMonthStartTime((int)year, (int)month);
                Date lastDayOfMonth = DateUtil.getMonthEndTime((int)year, (int)month);
                List investRegisterByMonth = investRegisterList.stream().filter(invest -> invest.getDate("createtime").getTime() >= firstDayOfMonth.getTime() && invest.getDate("createtime").getTime() <= lastDayOfMonth.getTime()).collect(Collectors.toList());
                BigDecimal investRegisterAmountByMonth = investRegisterByMonth.stream().map(invest -> invest.getBigDecimal("investamount")).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal(10000));
                List imageProgressReportByMonth = imageProgressReportList.stream().filter(invest -> invest.getDate("period").getTime() >= firstDayOfMonth.getTime() && invest.getDate("period").getTime() <= lastDayOfMonth.getTime()).collect(Collectors.toList());
                BigDecimal imageProgressReportAmountByMonth = BigDecimal.ZERO;
                Iterator iterator = imageProgressReportByMonth.iterator();
                while (iterator.hasNext()) {
                    DynamicObject imageProgressReport = (DynamicObject)iterator.next();
                    if (imageProgressReport.getBoolean("mutiwbs")) {
                        DynamicObjectCollection entryEntity = imageProgressReport.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entryEntity) {
                            imageProgressReportAmountByMonth = imageProgressReportAmountByMonth.add(entry.getBigDecimal("entryperiodinvest"));
                        }
                        continue;
                    }
                    imageProgressReportAmountByMonth = imageProgressReportAmountByMonth.add(imageProgressReport.getBigDecimal("periodinvest"));
                }
                BigDecimal amountByKindAndMonth = investRegisterAmountByMonth.add(imageProgressReportAmountByMonth);
                var33_38.put(month, amountByKindAndMonth);
                BigDecimal amountByMonth = (BigDecimal)amountByMonthMap.get(month);
                if (amountByMonth == null) {
                    amountByMonthMap.put(month, amountByKindAndMonth);
                    continue;
                }
                amountByMonthMap.put(month, amountByMonth.add(amountByKindAndMonth));
            }
        }
        ArrayList<InvestByKindBean> investByKindBeanList = new ArrayList<InvestByKindBean>(10);
        HashMap<Integer, BigDecimal> sumAmountByMonthMap = new HashMap<Integer, BigDecimal>(16);
        BigDecimal sumAllAmountByKind = BigDecimal.ZERO;
        Map proKindAmountSortMap = MapSortUtil.sortByValueDesc(amountByKindMap);
        DynamicObjectCollection dynamicObjectCollection = view.getModel().getEntryEntity("entryentity");
        dynamicObjectCollection.clear();
        int index = 0;
        for (Map.Entry entry : proKindAmountSortMap.entrySet()) {
            InvestByKindBean investByKindBean = new InvestByKindBean();
            DynamicObject projectKind = projectKindMap.get(entry.getKey());
            String projectKindName = projectKind.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)projectKindName)) {
                projectKindName = projectKind.getString("name");
            }
            DynamicObject dynamicObject = dynamicObjectCollection.addNew();
            dynamicObject.set("projectkind", (Object)projectKindName);
            sumAllAmountByKind = sumAllAmountByKind.add((BigDecimal)amountByKindMap.get(entry.getKey()));
            ArrayList<InvestAmountBean> investAmountBeanList = new ArrayList<InvestAmountBean>(10);
            Map amountMap = (Map)amountByKindAndMonthMap.get(entry.getKey());
            for (Map.Entry amountEntry : amountMap.entrySet()) {
                int month = (Integer)amountEntry.getKey();
                BigDecimal amount = (BigDecimal)amountEntry.getValue();
                InvestAmountBean investAmountBean = new InvestAmountBean();
                investAmountBean.setMonth(String.valueOf(month));
                investAmountBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)amount));
                investAmountBeanList.add(investAmountBean);
                dynamicObject.set(String.format("month_%s", amountEntry.getKey()), (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)amount));
                BigDecimal sumAmountByMonth = (BigDecimal)sumAmountByMonthMap.get(month);
                if (sumAmountByMonth == null) {
                    sumAmountByMonthMap.put(month, amount);
                    continue;
                }
                sumAmountByMonthMap.put(month, sumAmountByMonth.add(amount));
            }
            InvestAmountBean investAmountBean = new InvestAmountBean();
            investAmountBean.setMonth("all");
            investAmountBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)((BigDecimal)amountByKindMap.get(entry.getKey()))));
            dynamicObject.set("month_13", (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)((BigDecimal)amountByKindMap.get(entry.getKey()))));
            investAmountBeanList.add(investAmountBean);
            investByKindBean.setProKindName(projectKindName);
            investByKindBean.setInvestInfoList(investAmountBeanList);
            investByKindBeanList.add(investByKindBean);
            if (proKindAmountSortMap.size() <= 8 || ++index != 7) continue;
            InvestByKindBean otherInvestByKindBean = new InvestByKindBean();
            ArrayList<InvestAmountBean> otherInvestAmountBeanList = new ArrayList<InvestAmountBean>(10);
            DynamicObject otherDynamicObject = dynamicObjectCollection.addNew();
            otherDynamicObject.set("projectkind", (Object)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InvestScreenService_0", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            for (int month = 1; month <= 12; ++month) {
                BigDecimal otherAmountByMonth = ((BigDecimal)amountByMonthMap.get(month)).subtract((BigDecimal)sumAmountByMonthMap.get(month));
                InvestAmountBean otherInvestAmountBean = new InvestAmountBean();
                otherInvestAmountBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)otherAmountByMonth));
                otherInvestAmountBean.setMonth(String.valueOf(month));
                otherInvestAmountBeanList.add(investAmountBean);
                otherDynamicObject.set(String.format("month_%s", month), (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)otherAmountByMonth));
            }
            investAmountBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)allInvestAmount.subtract(sumAllAmountByKind)));
            otherDynamicObject.set("month_13", (Object)NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)allInvestAmount.subtract(sumAllAmountByKind)));
            investAmountBean.setMonth("all");
            otherInvestAmountBeanList.add(investAmountBean);
            otherInvestByKindBean.setInvestInfoList(otherInvestAmountBeanList);
            otherInvestByKindBean.setProKindName(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InvestScreenService_0", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            investByKindBeanList.add(otherInvestByKindBean);
            break;
        }
        returnData.put("investDataByMonth", investByKindBeanList);
        view.getModel().updateEntryCache(dynamicObjectCollection);
        view.updateView("entryentity");
        ArrayList<InvestAmountBean> investAmountBeanList = new ArrayList<InvestAmountBean>(10);
        for (Map.Entry entry : amountByMonthMap.entrySet()) {
            InvestAmountBean investAmountBean = new InvestAmountBean();
            investAmountBean.setMonth(String.valueOf(entry.getKey()));
            investAmountBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)((BigDecimal)entry.getValue())));
            investAmountBeanList.add(investAmountBean);
        }
        InvestAmountBean investAmountBean = new InvestAmountBean();
        investAmountBean.setMonth("all");
        investAmountBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)allInvestAmount));
        investAmountBeanList.add(investAmountBean);
        returnData.put("investData", investAmountBeanList);
    }

    public void projectTypeAnalysis(Map<Object, BigDecimal> amountMap, Map<Object, Integer> countMap, BigDecimal allProAmount, Integer allProCount, String amountByKindKey, String countByKindKey, JSONObject returnData) {
        Map amountSortMap = MapSortUtil.sortByValueDesc(amountMap);
        ArrayList<ProByKindBean> amountByKindList = new ArrayList<ProByKindBean>(10);
        int index = 0;
        int sumCountByKind = 0;
        BigDecimal sumAmountByKind = BigDecimal.ZERO;
        BigDecimal sumPerCentByKind = BigDecimal.ZERO;
        for (Map.Entry entry : amountSortMap.entrySet()) {
            String projectKindName;
            ProByKindBean proByKindBean = new ProByKindBean();
            DynamicObject projectKind = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"bd_projectkind");
            int countByKind = countMap.get(projectKind.getPkValue());
            BigDecimal percentage = new BigDecimal("0.00");
            if (((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) != 0) {
                percentage = ((BigDecimal)entry.getValue()).divide(allProAmount, 4, RoundingMode.HALF_UP);
            }
            if (StringUtils.isEmpty((CharSequence)(projectKindName = projectKind.getLocaleString("name").getLocaleValue()))) {
                projectKindName = projectKind.getString("name");
            }
            proByKindBean.setProKindName(projectKindName);
            proByKindBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)((BigDecimal)entry.getValue())));
            proByKindBean.setCount(countByKind);
            proByKindBean.setPercentage(percentage.multiply(this.ONE_HUNDRED_DECIMAL));
            amountByKindList.add(proByKindBean);
            sumAmountByKind = sumAmountByKind.add((BigDecimal)entry.getValue());
            sumCountByKind += countByKind;
            sumPerCentByKind = sumPerCentByKind.add(percentage);
            if (amountSortMap.size() <= 8 || ++index != 7) continue;
            ProByKindBean otherProByKindBean = new ProByKindBean();
            otherProByKindBean.setProKindName(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InvestScreenService_0", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            otherProByKindBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)allProAmount.subtract(sumAmountByKind)));
            otherProByKindBean.setCount(allProCount - sumCountByKind);
            otherProByKindBean.setPercentage(BigDecimal.ONE.subtract(sumPerCentByKind).multiply(this.ONE_HUNDRED_DECIMAL));
            amountByKindList.add(otherProByKindBean);
            break;
        }
        returnData.put(amountByKindKey, amountByKindList);
        ArrayList<ProByKindBean> countByKindList = new ArrayList<ProByKindBean>(10);
        Map countSortMap = MapSortUtil.sortByValueDesc(countMap);
        index = 0;
        sumCountByKind = 0;
        sumAmountByKind = BigDecimal.ZERO;
        sumPerCentByKind = BigDecimal.ZERO;
        for (Map.Entry entry : countSortMap.entrySet()) {
            ProByKindBean proByKindBean = new ProByKindBean();
            DynamicObject projectKind = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"bd_projectkind");
            BigDecimal amountByKind = amountMap.get(projectKind.getPkValue());
            BigDecimal percentage = new BigDecimal((Integer)entry.getValue()).divide(new BigDecimal(allProCount), 4, RoundingMode.HALF_UP);
            String projectKindName = projectKind.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)projectKindName)) {
                projectKindName = projectKind.getString("name");
            }
            proByKindBean.setProKindName(projectKindName);
            proByKindBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)amountByKind));
            proByKindBean.setCount((Integer)entry.getValue());
            proByKindBean.setPercentage(percentage.multiply(this.ONE_HUNDRED_DECIMAL));
            countByKindList.add(proByKindBean);
            sumCountByKind += ((Integer)entry.getValue()).intValue();
            sumAmountByKind = sumAmountByKind.add(amountByKind);
            sumPerCentByKind = sumPerCentByKind.add(percentage);
            if (countSortMap.size() <= 8 || ++index != 7) continue;
            ProByKindBean otherProByKindBean = new ProByKindBean();
            otherProByKindBean.setProKindName(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InvestScreenService_0", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            otherProByKindBean.setAmount(NumberHelper.getBigDecimalDivideTenthousand((BigDecimal)allProAmount.subtract(sumAmountByKind)));
            otherProByKindBean.setCount(allProCount - sumCountByKind);
            otherProByKindBean.setPercentage(BigDecimal.ONE.subtract(sumPerCentByKind).multiply(this.ONE_HUNDRED_DECIMAL));
            countByKindList.add(otherProByKindBean);
            break;
        }
        returnData.put(countByKindKey, countByKindList);
    }

    public void exportInvestData(IFormView view) {
        JSONArray data = new JSONArray();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            JSONObject obj = new JSONObject();
            obj.put("projectkind", (Object)entry.getString("projectkind"));
            obj.put("month_1", (Object)entry.getBigDecimal("month_1"));
            obj.put("month_2", (Object)entry.getBigDecimal("month_2"));
            obj.put("month_3", (Object)entry.getBigDecimal("month_3"));
            obj.put("month_4", (Object)entry.getBigDecimal("month_4"));
            obj.put("month_5", (Object)entry.getBigDecimal("month_5"));
            obj.put("month_6", (Object)entry.getBigDecimal("month_6"));
            obj.put("month_7", (Object)entry.getBigDecimal("month_7"));
            obj.put("month_8", (Object)entry.getBigDecimal("month_8"));
            obj.put("month_9", (Object)entry.getBigDecimal("month_9"));
            obj.put("month_10", (Object)entry.getBigDecimal("month_10"));
            obj.put("month_11", (Object)entry.getBigDecimal("month_11"));
            obj.put("month_12", (Object)entry.getBigDecimal("month_12"));
            obj.put("month_13", (Object)entry.getBigDecimal("month_13"));
            data.add((Object)obj);
        }
        String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])this.COLUMNKEY, null, (JSONArray)data);
        view.download(url);
    }

    public String getFileName() {
        return ResManager.loadKDString((String)"\u6708\u5ea6\u6295\u8d44\u5b8c\u6210\u60c5\u51b5", (String)"InvestScreenService_1", (String)"pmgt-pmim-business", (Object[])new Object[0]);
    }

    public String getSheetName() {
        return ResManager.loadKDString((String)"\u6708\u5ea6\u6295\u8d44\u5b8c\u6210\u60c5\u51b5", (String)"InvestScreenService_1", (String)"pmgt-pmim-business", (Object[])new Object[0]);
    }

    public String[] getHeader() {
        if (this.header == null) {
            this.header = new String[]{ResManager.loadKDString((String)"\u9879\u76ee\u5206\u7c7b", (String)"InvestScreenService_2", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"1\u6708", (String)"InvestScreenService_3", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"2\u6708", (String)"InvestScreenService_4", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"3\u6708", (String)"InvestScreenService_5", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"4\u6708", (String)"InvestScreenService_6", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"5\u6708", (String)"InvestScreenService_7", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"6\u6708", (String)"InvestScreenService_8", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"7\u6708", (String)"InvestScreenService_9", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"8\u6708", (String)"InvestScreenService_10", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"9\u6708", (String)"InvestScreenService_11", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"10\u6708", (String)"InvestScreenService_12", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"11\u6708", (String)"InvestScreenService_13", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"12\u6708", (String)"InvestScreenService_14", (String)"pmgt-pmim-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1", (String)"InvestScreenService_15", (String)"pmgt-pmim-business", (Object[])new Object[0])};
        }
        return this.header;
    }

    private void initReturnData(JSONObject returnData) {
        ArrayList initList = new ArrayList(10);
        returnData.put("reserveCountByKind", initList);
        returnData.put("reserveAmountByKind", initList);
        returnData.put("approvalCountByKind", initList);
        returnData.put("approvalAmountByKind", initList);
        returnData.put("completeCountByKind", initList);
        returnData.put("completeAmountByKind", initList);
        returnData.put("projectKinds", initList);
        returnData.put("investData", initList);
    }
}

