/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.business.helper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.AddPmsgEntryTypeEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;

public class ProjectProposalHelper {
    public static final String CTRL_SUBMIT = "submit";
    public static final String CTRL_UNSUBMIT = "unsubmit";
    public static final String CTRL_AUDIT = "audit";
    public static final String CTRL_UNAUDIT = "unaudit";
    private static final Log logger = LogFactory.getLog(ProjectProposalHelper.class);
    public static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String BOS_ATTACHMENT_FATTACHMENTSIZE = "fattachmentsize";
    private static final String BOS_ATTACHMENT_FNUMBER = "fnumber";
    private static final String BOS_ATTACHMENT_FATTACHMENTNAME = "fattachmentname";
    private static final String BOS_ATTACHMENT_FFILEID = "ffileid";
    private static final String BOS_ATTACHMENT_FEXTNAME = "fextname";
    private static final String BOS_ATTACHMENT_FCREATEMEN = "fcreatemen";
    private static final String BOS_ATTACHMENT_FCREATETIME = "fcreatetime";
    private static final String BOS_ATTACHMENT_FMODIFYTIME = "fmodifytime";
    private static final String BOS_ATTACHMENT_FINTERID = "finterid";
    public static final String BD_ATTACHMENT = "bd_attachment";
    private static final String BD_ATTACHMENT_ID = "id";
    private static final String BD_ATTACHMENT_SIZE = "size";
    private static final String BD_ATTACHMENT_NAME = "name";
    private static final String BD_ATTACHMENT_NUMBER = "number";
    private static final String BD_ATTACHMENT_UID = "uid";
    private static final String BD_ATTACHMENT_URL = "url";
    private static final String BD_ATTACHMENT_TYPE = "type";
    private static final String BD_ATTACHMENT_CREATETIME = "createtime";
    private static final String BD_ATTACHMENT_CREATOR = "creator";
    private static final String BD_ATTACHMENT_MODIFYTIME = "modifytime";
    private static final String BD_ATTACHMENT_STATUS = "status";
    private static final String BD_ATTACHMENT_TEMPFILE = "tempfile";

    public static void syncProjectProposalF7(DynamicObject projectProposal) {
        DeleteServiceHelper.delete((String)"pmim_projectproposal_f7", (QFilter[])new QFilter[]{new QFilter("projectproposalid", "=", (Object)String.valueOf(projectProposal.getPkValue()))});
        DynamicObjectCollection funSources = projectProposal.getDynamicObjectCollection("sourceentry");
        DynamicObjectCollection entrys = projectProposal.getDynamicObjectCollection("pmsgentry");
        DynamicObject[] dynamicObjects = new DynamicObject[entrys.size()];
        int index = 0;
        for (DynamicObject entry : entrys) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmim_projectproposal_f7");
            DynamicObject proProposalF7 = new DynamicObject((DynamicObjectType)dt);
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmim_projectproposal_f7", (DynamicObject)proProposalF7, (String)String.valueOf(RequestContext.get().getOrgId()));
            if (null != codeRuleInfo) {
                proProposalF7.set(BD_ATTACHMENT_NUMBER, (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)proProposalF7));
            } else {
                proProposalF7.set(BD_ATTACHMENT_NUMBER, projectProposal.get("billno"));
            }
            proProposalF7.set(BD_ATTACHMENT_NAME, projectProposal.get("billname"));
            proProposalF7.set("projectkind", projectProposal.get("projectkind"));
            proProposalF7.set("projectproposalid", projectProposal.getPkValue());
            proProposalF7.set("enable", (Object)1);
            proProposalF7.set("org", projectProposal.get("org"));
            proProposalF7.set("useorg", projectProposal.get("org"));
            proProposalF7.set(BD_ATTACHMENT_ID, entry.getPkValue());
            proProposalF7.set("year", entry.get("pmsgentry_year"));
            proProposalF7.set("yearbugamt", entry.get("pmsgentry_yearbugamt"));
            proProposalF7.set("yearfiamt", entry.get("pmsgentry_yearfiamt"));
            proProposalF7.set("arrearsamt", entry.get("pmsgentry_arrearsamt"));
            proProposalF7.set("lastyearbugamt", entry.get("pmsgentry_lastyearbugamt"));
            proProposalF7.set("lastyearfiamt", entry.get("pmsgentry_lastyearfiamt"));
            proProposalF7.set("projectstatus", entry.get("pmsgentry_projectstatus"));
            proProposalF7.set("version", entry.get("version"));
            proProposalF7.set("datasource", (Object)"projectProposal");
            String billStatus = projectProposal.getString("billstatus");
            if (StatusEnum.CHECKED.getValue().equals(billStatus)) {
                proProposalF7.set(BD_ATTACHMENT_STATUS, (Object)StatusEnum.CHECKED.getValue());
            } else {
                proProposalF7.set(BD_ATTACHMENT_STATUS, (Object)StatusEnum.TEMPSAVE.getValue());
            }
            proProposalF7.set("reportorg", entry.get("pmsg_reportorg"));
            proProposalF7.set("accepted", (Object)false);
            if (entry.getBoolean("pmsg_reportbudget")) {
                proProposalF7.set("approvalcon", (Object)"report");
            } else {
                proProposalF7.set("approvalcon", (Object)"pass");
            }
            proProposalF7.set("sourceorg", projectProposal.get("org"));
            proProposalF7.set("budgetapplyresult", entry.get("budgetapplyresult"));
            proProposalF7.set("reportbudget", entry.get("pmsg_reportbudget"));
            proProposalF7.set("currency", projectProposal.get("currency"));
            DynamicObjectCollection entryAttachments = entry.getDynamicObjectCollection("pmsgentry_attachment");
            for (DynamicObject entryAttachment : entryAttachments) {
                String insertSql = "insert into t_pmim_projectbdmsgdoc (fpkid,fid,fbasedataid) values (" + entryAttachment.getPkValue() + "," + entry.getPkValue() + "," + entryAttachment.get("fbasedataid_id") + ")";
                DB.execute((DBRoute)DBRoute.of((String)"cr"), (String)insertSql);
            }
            if (funSources.size() > 0) {
                DynamicObjectCollection sourceEntry = proProposalF7.getDynamicObjectCollection("funsourceentry");
                sourceEntry.clear();
                funSources.forEach(funSource -> {
                    DynamicObject source = sourceEntry.addNew();
                    source.set("seq", (Object)sourceEntry.size());
                    source.set("fundsourcetype", (Object)funSource.getDynamicObject("sourceentry_fundresource"));
                    source.set("investcurrency", (Object)funSource.getDynamicObject("sourceentry_currency"));
                    source.set("entryamt", (Object)funSource.getBigDecimal("sourceentry_amount"));
                    source.set("formofinvest", (Object)funSource.getString("sourceentry_formofinvest"));
                    source.set("currententryamt", (Object)funSource.getBigDecimal("currententryamt"));
                    source.set("scale", (Object)funSource.getBigDecimal("sourceentry_scale"));
                    source.set("comment", (Object)funSource.getString("sourceentry_remark"));
                });
            }
            dynamicObjects[index] = proProposalF7;
            ++index;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public static void syncProjectProposalF72BillData(DynamicObject projectProposalf7, Boolean modify, String type, int selectRow) {
        Long billId = Long.parseLong(projectProposalf7.getString("projectproposalid"));
        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_projectproposal");
        DynamicObjectCollection pmsgEntry = projectProposal.getDynamicObjectCollection("pmsgentry");
        DynamicObject entry = null;
        if (modify.booleanValue()) {
            entry = (DynamicObject)pmsgEntry.get(selectRow);
        } else if (AddPmsgEntryTypeEnum.ADJUST.getValue().equals(type)) {
            entry = new DynamicObject(pmsgEntry.getDynamicObjectType());
            pmsgEntry.add(selectRow + 1, entry);
        } else if (AddPmsgEntryTypeEnum.RESUBMIT.getValue().equals(type)) {
            entry = pmsgEntry.addNew();
        }
        if (entry != null) {
            entry.set(BD_ATTACHMENT_ID, projectProposalf7.get(BD_ATTACHMENT_ID));
            if (!modify.booleanValue()) {
                entry.set("seq", (Object)pmsgEntry.size());
            }
            entry.set("pmsgentry_year", projectProposalf7.get("year"));
            entry.set("pmsgentry_yearbugamt", projectProposalf7.get("yearbugamt"));
            entry.set("pmsgentry_yearfiamt", projectProposalf7.get("yearfiamt"));
            entry.set("pmsgentry_arrearsamt", projectProposalf7.get("arrearsamt"));
            entry.set("pmsgentry_lastyearbugamt", projectProposalf7.get("lastyearbugamt"));
            entry.set("pmsgentry_lastyearfiamt", projectProposalf7.get("lastyearfiamt"));
            entry.set("pmsgentry_projectstatus", projectProposalf7.get("projectstatus"));
            entry.set("version", projectProposalf7.get("version"));
            entry.set("pmsg_reportbudget", projectProposalf7.get("reportbudget"));
            entry.set("pmsg_reportorg", projectProposalf7.get("reportorg"));
            boolean isReport = projectProposalf7.getBoolean("reportbudget");
            if (!isReport) {
                entry.set("budgetapplyresult", (Object)"PASS");
                entry.set("pmsgentry_isquote", (Object)Boolean.TRUE);
                entry.set("yearbugappamt", projectProposalf7.get("yearbugamt"));
                entry.set("yearfiappamt", projectProposalf7.get("yearfiamt"));
            } else {
                entry.set("budgetapplyresult", null);
                entry.set("pmsgentry_isquote", (Object)Boolean.FALSE);
                entry.set("yearbugappamt", (Object)BigDecimal.ZERO);
                entry.set("yearfiappamt", (Object)BigDecimal.ZERO);
            }
            ProjectProposalHelper.syncAttachmentToEntry(projectProposalf7);
            if (modify.booleanValue()) {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{projectProposal});
            } else {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectProposal});
                ProjectProposalHelper.reSetPMSGEntrySeq(pmsgEntry);
            }
        }
    }

    private static void syncAttachmentToEntry(DynamicObject projectProposalF7) {
        String deleteSql = "delete from t_pmim_projectmsgdoc where fentryid = " + projectProposalF7.getPkValue();
        DB.execute((DBRoute)DBRoute.of((String)"cr"), (String)deleteSql);
        DynamicObjectCollection attachments = projectProposalF7.getDynamicObjectCollection("attachmentfield");
        for (DynamicObject attachment : attachments) {
            String insertSql = "insert into t_pmim_projectmsgdoc (fpkid,fentryid,fbasedataid) values (" + attachment.getPkValue() + "," + projectProposalF7.getPkValue() + "," + attachment.get("fbasedataid_id") + ")";
            DB.execute((DBRoute)DBRoute.of((String)"cr"), (String)insertSql);
        }
    }

    public static void checkEnable2Import(DynamicObject projectProposalf7, IFormView view, BeforeDoOperationEventArgs args) {
        Long billId = Long.parseLong(projectProposalf7.getString("projectproposalid"));
        DynamicObject projectProposal = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmim_projectproposal");
        DynamicObjectCollection pmsgEntry = projectProposal.getDynamicObjectCollection("pmsgentry");
        LocalDate year = projectProposalf7.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        for (DynamicObject entry : pmsgEntry) {
            LocalDate entryYear;
            if (null == entry.get("pmsgentry_year") || (entryYear = ((Date)entry.get("pmsgentry_year")).toInstant().atZone(ZoneId.systemDefault()).toLocalDate()) == null || year.getYear() != entryYear.getYear()) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728%s\u5e74\u6570\u636e\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ProjectProposalHelper_15", (String)"pmgt-pmim-business", (Object[])new Object[0]), year.getYear()));
            args.setCancel(true);
            return;
        }
    }

    public static void reSetPMSGEntrySeq(DynamicObjectCollection entries) {
        for (int i = 0; i < entries.size(); ++i) {
            ((DynamicObject)entries.get(i)).set("seq", (Object)(i + 1));
        }
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])entries.toArray((Object[])new DynamicObject[entries.size()])));
    }

    public static boolean checkCanDoOperation(IFormView view, DynamicObject projectProposal, BeforeDoOperationEventArgs args, String type) {
        String bizStatus = projectProposal.getString("bizstatus");
        if (BizStatusEnum.CANCEL.getValue().equals(bizStatus)) {
            if (AddPmsgEntryTypeEnum.ADJUST.getValue().equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"ProjectProposalHelper_16", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            } else if (AddPmsgEntryTypeEnum.RESUBMIT.getValue().equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u7eed\u62a5\u3002", (String)"ProjectProposalHelper_17", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            } else if ("deleteentry".equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u5220\u9664\u884c\u3002", (String)"ProjectProposalHelper_18", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            }
            args.setCancel(true);
            return false;
        }
        if (BizStatusEnum.COMPLETE.getValue().equals(bizStatus)) {
            if (AddPmsgEntryTypeEnum.ADJUST.getValue().equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5b8c\u7ed3\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"ProjectProposalHelper_19", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            } else if (AddPmsgEntryTypeEnum.RESUBMIT.getValue().equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5b8c\u7ed3\uff0c\u65e0\u6cd5\u7eed\u62a5\u3002", (String)"ProjectProposalHelper_20", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            } else if ("deleteentry".equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5b8c\u7ed3\uff0c\u65e0\u6cd5\u5220\u9664\u884c\u3002", (String)"ProjectProposalHelper_21", (String)"pmgt-pmim-business", (Object[])new Object[0]));
            }
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public static boolean checkProjectProposalF7IsRefenced(Object projectProposalF7Id) {
        QFilter entryFilter = new QFilter("inventry.inventry_projectproposal.id", "=", projectProposalF7Id);
        DynamicObject[] investBudgetPlans = BusinessDataServiceHelper.load((String)"pmim_investbugetplan", (String)BD_ATTACHMENT_ID, (QFilter[])new QFilter[]{entryFilter});
        return investBudgetPlans.length > 0;
    }

    public static void auditProjectProposalF7(DynamicObject[] dynamicObjects) {
        Object[] ids = new Object[dynamicObjects.length];
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            ids[i] = dynamicObject.getPkValue();
            ++i;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        OperationServiceHelper.executeOperate((String)CTRL_AUDIT, (String)"pmim_proposalbill_f7", (Object[])ids, (OperateOption)option);
    }

    public static void updateCurBillAndDataF7(DynamicObject projectProposal, String operateKey) {
        DynamicObjectCollection entries = projectProposal.getDynamicObjectCollection("pmsgentry");
        boolean isReport = projectProposal.getBoolean("reportbudget");
        if (CTRL_SUBMIT.equals(operateKey) || CTRL_UNSUBMIT.equals(operateKey)) {
            Boolean isQuote;
            Boolean bl = isQuote = operateKey.equals(CTRL_SUBMIT) ? Boolean.TRUE : Boolean.FALSE;
            if (entries.size() > 0 && !isReport) {
                DynamicObject entry2 = (DynamicObject)entries.get(0);
                entry2.set("pmsgentry_isquote", (Object)isQuote);
                if (QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)entry2.getPkValue())) {
                    DynamicObject dataF7 = BusinessDataServiceHelper.loadSingle((Object)entry2.getPkValue(), (String)"pmim_projectproposal_f7");
                    dataF7.set("isquote", (Object)isQuote);
                    SaveServiceHelper.update((DynamicObject)dataF7);
                }
                SaveServiceHelper.update((DynamicObject)projectProposal);
            }
        } else if (CTRL_AUDIT.equals(operateKey) || CTRL_UNAUDIT.equals(operateKey)) {
            List cols;
            if (entries.size() > 0 && !isReport && (cols = entries.stream().filter(entry -> !entry.getBoolean("pmsg_reportbudget")).collect(Collectors.toList())).size() > 0) {
                DynamicObject[] updateBills = new DynamicObject[cols.size()];
                Boolean isQuote = operateKey.equals(CTRL_AUDIT) ? Boolean.TRUE : Boolean.FALSE;
                for (int i = 0; i < cols.size(); ++i) {
                    DynamicObject col = (DynamicObject)cols.get(i);
                    col.set("pmsgentry_isquote", (Object)isQuote);
                    String applyResult = operateKey.equals(CTRL_AUDIT) ? "PASS" : "";
                    col.set("budgetapplyresult", (Object)applyResult);
                    BigDecimal yearBugAppAmt = operateKey.equals(CTRL_AUDIT) ? col.getBigDecimal("pmsgentry_yearbugamt") : BigDecimal.ZERO;
                    col.set("yearbugappamt", (Object)yearBugAppAmt);
                    BigDecimal yearFiAppAmt = operateKey.equals(CTRL_AUDIT) ? col.getBigDecimal("pmsgentry_yearfiamt") : BigDecimal.ZERO;
                    col.set("yearfiappamt", (Object)yearFiAppAmt);
                    if (!QueryServiceHelper.exists((String)"pmim_projectproposal_f7", (Object)col.getPkValue())) continue;
                    DynamicObject dataF7 = BusinessDataServiceHelper.loadSingle((Object)col.getPkValue(), (String)"pmim_projectproposal_f7");
                    dataF7.set("isquote", (Object)isQuote);
                    String approvalCon = operateKey.equals(CTRL_AUDIT) ? "pass" : "";
                    dataF7.set("approvalcon", (Object)approvalCon);
                    dataF7.set("budgetapplyresult", (Object)applyResult);
                    dataF7.set("yearbugappamt", (Object)yearBugAppAmt);
                    dataF7.set("yearfiappamt", (Object)yearFiAppAmt);
                    updateBills[i] = dataF7;
                }
                SaveServiceHelper.update((DynamicObject[])updateBills);
                BigDecimal sumYearBugAppAmt = BigDecimal.ZERO;
                BigDecimal sumYearFiAppAmt = BigDecimal.ZERO;
                for (int i = 0; i < cols.size(); ++i) {
                    DynamicObject col = (DynamicObject)cols.get(i);
                    String applyResult = col.getString("budgetapplyresult");
                    if (!"PASS".equals(applyResult)) continue;
                    sumYearBugAppAmt = sumYearBugAppAmt.add(col.getBigDecimal("yearbugappamt"));
                    sumYearFiAppAmt = sumYearFiAppAmt.add(col.getBigDecimal("yearfiappamt"));
                }
                projectProposal.set("proinvestbudappamt", (Object)sumYearBugAppAmt);
                projectProposal.set("profinexbudappamt", (Object)sumYearFiAppAmt);
            }
            SaveServiceHelper.update((DynamicObject)projectProposal);
        }
    }

    public static void updateSumAppAmt(DynamicObject projectProposal) {
        BigDecimal approveTotalAmt = BigDecimal.ZERO;
        BigDecimal approveFinExTotalAmt = BigDecimal.ZERO;
        HashMap<Integer, DynamicObject> newVisionMap = new HashMap<Integer, DynamicObject>();
        DynamicObjectCollection pmsgEntries = projectProposal.getDynamicObjectCollection("pmsgentry");
        for (DynamicObject entry : pmsgEntries) {
            BigDecimal version2;
            String applyResult = entry.getString("budgetapplyresult");
            if (StringUtils.isBlank((CharSequence)applyResult) || entry.getDate("pmsgentry_year") == null) continue;
            LocalDate curYear = entry.getDate("pmsgentry_year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            Integer year = curYear.getYear();
            DynamicObject projectProposalObj = (DynamicObject)newVisionMap.get(year);
            if (projectProposalObj == null) {
                newVisionMap.put(year, entry);
                continue;
            }
            BigDecimal version1 = projectProposalObj.getBigDecimal("version");
            if (version1.compareTo(version2 = entry.getBigDecimal("version")) >= 0) continue;
            newVisionMap.put(year, entry);
        }
        if (newVisionMap.size() > 0) {
            Set newVisionEntries = newVisionMap.entrySet();
            for (Map.Entry newVision : newVisionEntries) {
                DynamicObject entry = (DynamicObject)newVision.getValue();
                String applyResult = entry.getString("budgetapplyresult");
                if (!"PASS".equals(applyResult)) continue;
                approveTotalAmt = approveTotalAmt.add(entry.getBigDecimal("yearbugappamt"));
                approveFinExTotalAmt = approveFinExTotalAmt.add(entry.getBigDecimal("yearfiappamt"));
            }
        }
        projectProposal.set("proinvestbudappamt", (Object)approveTotalAmt);
        projectProposal.set("profinexbudappamt", (Object)approveFinExTotalAmt);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{projectProposal});
    }
}

