/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;

public class TacticInvestPlanAmountHelper {
    public static List<String> getAmountName(DynamicObject dataEntity) {
        ArrayList<String> amountNameList = new ArrayList<String>();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof AmountProp)) continue;
            amountNameList.add(property.getName());
        }
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            if (!(collectionProperty instanceof EntryProp)) continue;
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionProperty.getName());
            DataEntityPropertyCollection entryProperties = entryColl.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : entryProperties) {
                if (!(property instanceof AmountProp)) continue;
                amountNameList.add(property.getName());
            }
        }
        return amountNameList;
    }

    public static List<String> getBillHeadAmountName(DynamicObject dataEntity, String ... propKey) {
        ArrayList<String> amountNameList = new ArrayList<String>();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        if (propKey == null || propKey.length == 0) {
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof AmountProp)) continue;
                amountNameList.add(property.getName());
            }
        } else {
            for (String key : propKey) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
                if (!(property instanceof AmountProp)) continue;
                amountNameList.add(property.getName());
            }
        }
        return amountNameList;
    }

    public static List<String> getBillEntryAmountName(DynamicObject dataEntity) {
        ArrayList<String> amountNameList = new ArrayList<String>();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            if (!(collectionProperty instanceof EntryProp)) continue;
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionProperty.getName());
            DataEntityPropertyCollection entryProperties = entryColl.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : entryProperties) {
                if (!(property instanceof AmountProp)) continue;
                amountNameList.add(property.getName());
            }
        }
        return amountNameList;
    }

    public static void convertMoneyUnit(DynamicObject dataEntity, BigDecimal moneyUnit, boolean multiply, List<String> propKeyList) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String key : propKeyList) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
            if (!(property instanceof AmountProp)) continue;
            BigDecimal bigDecimal = dataEntity.getBigDecimal(property.getName());
            BigDecimal convertAmount = multiply ? bigDecimal.multiply(moneyUnit) : bigDecimal.divide(moneyUnit, RoundingMode.HALF_UP);
            dataEntity.set(property.getName(), (Object)convertAmount);
        }
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            if (!(collectionProperty instanceof EntryProp)) continue;
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionProperty.getName());
            DataEntityPropertyCollection entryProperties = entryColl.getDynamicObjectType().getProperties();
            for (String key : propKeyList) {
                IDataEntityProperty property = (IDataEntityProperty)entryProperties.get((Object)key);
                if (!(property instanceof AmountProp)) continue;
                for (DynamicObject dyn : entryColl) {
                    BigDecimal bigDecimal = dyn.getBigDecimal(property.getName());
                    BigDecimal convertAmount = multiply ? bigDecimal.multiply(moneyUnit) : bigDecimal.divide(moneyUnit, RoundingMode.HALF_UP);
                    dyn.set(property.getName(), (Object)convertAmount);
                }
            }
            dataEntity.set(collectionProperty.getName(), (Object)entryColl);
        }
    }
}

