/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.business.helper;

import com.alibaba.fastjson.JSONArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jetbrains.annotations.NotNull;

public class TacticInvestPlanImportHelper {
    private static final Log logger = LogFactory.getLog(TacticInvestPlanImportHelper.class);
    private static final String FORMID_IMPORTEXCEL = "pmim_excelimport";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_NAME_TITLE = "nametitle";
    public static final String PARAM_ENTRY = "entry";
    public static final String NAME = "name";
    public static final String IMPORT_ENTRY_FLAG = "importentry";

    public static void importExcel(AbstractBillPlugIn plugin, Map<String, List<String>> header) {
        IFormView view = plugin.getView();
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(FORMID_IMPORTEXCEL);
        Map params = importExcelFormParameter.getCustomParams();
        DynamicObjectCollection entry = view.getModel().getEntryEntity("treeentryentity");
        params.put(PARAM_ENTRY, TacticInvestPlanImportHelper.buildJsonArray(entry, header.get(PARAM_NAME_TITLE)));
        params.put(PARAM_TITLE, header.get(PARAM_TITLE));
        params.put(PARAM_NAME_TITLE, header.get(PARAM_NAME_TITLE));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, IMPORT_ENTRY_FLAG));
        view.showForm(importExcelFormParameter);
    }

    public static JSONArray buildJsonArray(DynamicObjectCollection entry, List<String> nameTitleList) {
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject dynamicObject : entry) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            Iterator<String> iterator = nameTitleList.iterator();
            block9: while (iterator.hasNext()) {
                String name;
                switch (name = iterator.next()) {
                    case "orgfield_id": {
                        paramMap.put(name, dynamicObject.getDynamicObject("orgfield").getString("id"));
                        continue block9;
                    }
                    case "orgfield": {
                        paramMap.put(name, dynamicObject.getDynamicObject("orgfield").getString(NAME));
                        continue block9;
                    }
                }
                paramMap.put(name, dynamicObject.get(name).toString());
            }
            jsonArray.add(paramMap);
        }
        return jsonArray;
    }

    public static void exportExcel(IFormView formView, String sheetName, String[] title, String[] nameTitle, List<Map<String, Object>> entryList) {
        HSSFWorkbook wb = TacticInvestPlanImportHelper.setWorkbook(sheetName, title, nameTitle, entryList);
        String fileName = TacticInvestPlanImportHelper.buildFileName();
        TacticInvestPlanImportHelper.writeAndDownLoad(formView, wb, fileName);
    }

    @NotNull
    private static HSSFWorkbook setWorkbook(String sheetName, String[] title, String[] nameTitle, List<Map<String, Object>> entryList) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        HSSFCellStyle nameTitleStyle = wb.createCellStyle();
        nameTitleStyle.setHidden(true);
        HSSFRow nameTitleRow = sheet.createRow(0);
        nameTitleRow.setZeroHeight(true);
        HSSFRow titleRow = sheet.createRow(1);
        for (int i = 0; i < title.length; ++i) {
            HSSFCell nameTitleCell = nameTitleRow.createCell(i);
            nameTitleCell.setCellValue(nameTitle[i]);
            sheet.setColumnWidth(i, 4024);
            HSSFCell titleCell = titleRow.createCell(i);
            titleCell.setCellValue(title[i]);
            titleCell.setCellStyle(titleStyle);
            sheet.setColumnWidth(i, 4024);
        }
        TacticInvestPlanImportHelper.setExportRowData((Sheet)sheet, 2, nameTitle, entryList);
        return wb;
    }

    @NotNull
    private static String buildFileName() {
        Calendar cal = Calendar.getInstance();
        int y = cal.get(1);
        int m = cal.get(2) + 1;
        int d = cal.get(5);
        return String.format(ResManager.loadKDString((String)"\u6218\u7565\u6295\u8d44\u89c4\u5212\u5bfc\u5165\u6a21\u677f-%1$s-%2$s-%3$s.xls", (String)"TacticInvestPlanImportHelper_0", (String)"pmgt-pmim-business", (Object[])new Object[0]), y, m, d);
    }

    private static void writeAndDownLoad(IFormView formView, HSSFWorkbook wb, String fileName) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        PermCheckParam permCheckParam = new PermCheckParam(url, formView.getParentView().getEntityId(), formView.getParentView().getFormShowParameter().getAppId(), "47150e89000000ac");
        CheckPermissionHelper.setFileUrlPermCheckParam((PermCheckParam)permCheckParam);
        formView.download(url);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void setExportRowData(Sheet sheet, int index, String[] nameTitle, List<Map<String, Object>> entryList) {
        DataFormat format = sheet.getWorkbook().createDataFormat();
        for (Map<String, Object> map : entryList) {
            String[] rowData = new String[nameTitle.length];
            Row cur = sheet.createRow(index);
            for (int j = 0; j < nameTitle.length; ++j) {
                rowData[j] = map.get(nameTitle[j]).toString();
                Cell cell = cur.createCell(j);
                cell.getCellStyle().setDataFormat(format.getFormat("TEXT"));
                cell.setCellValue(rowData[j]);
            }
            ++index;
        }
    }

    public static List<String> getHeadByExcel(String url) {
        ArrayList<String> reurnArray = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                Row columnKeyRow = sheet.getRow(0);
                int columnNum = columnKeyRow.getLastCellNum();
                for (int i = 0; i < columnNum; ++i) {
                    columnKeyRow.getCell(i).setCellType(CellType.STRING);
                    String headkey = columnKeyRow.getCell(i).getStringCellValue();
                    if ("".equals(columnKeyRow.getCell(i).getStringCellValue())) continue;
                    reurnArray.add(headkey);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return reurnArray;
    }

    public static boolean checkTitle(List<String> list, List<String> title) {
        if (list == null || list.size() != title.size()) {
            return false;
        }
        for (int i = 0; i < title.size(); ++i) {
            if (StringUtils.equals((CharSequence)list.get(i), (CharSequence)title.get(i))) continue;
            return false;
        }
        return true;
    }

    public static DynamicObjectCollection buildEntryExcel(String url, IFormView formView, String entryId, List<String> nameTitleList) {
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(entryId);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                StringBuffer message = new StringBuffer();
                boolean messageNum = false;
                int rowNum = sheet.getLastRowNum();
                Row columnKeyHashRow = sheet.getRow(0);
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                HashMap<Long, Row> rowMap = new HashMap<Long, Row>(16);
                block2: for (int i = 1; i < rowNum; ++i) {
                    Row row = sheet.getRow(i + 1);
                    if (row == null) continue;
                    for (int j = 0; j < nameTitleList.size(); ++j) {
                        String propertyName = nameTitleList.get(j);
                        String valueStr = TacticInvestPlanImportHelper.getExcelCellStringValue(row.getCell(j));
                        if (!"orgfield_id".equals(propertyName)) continue;
                        long rowOrgId = Long.parseLong(valueStr);
                        rowMap.put(rowOrgId, row);
                        continue block2;
                    }
                }
                TacticInvestPlanImportHelper.getTreeEntryEntity(rowMap, entryEntity, nameTitleList);
            }
            catch (Exception e) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"TacticInvestPlanImportHelper_1", (String)"pmgt-pmim-business", (Object[])new Object[0]));
                logger.error((Throwable)e);
            }
        }
        return entryEntity;
    }

    public static void getTreeEntryEntity(HashMap<Long, Row> rowMap, DynamicObjectCollection entryEntity, List<String> nameTitleList) {
        for (DynamicObject entity : entryEntity) {
            long orgId = entity.getDynamicObject("orgfield").getLong("id");
            if (!rowMap.containsKey(orgId)) continue;
            for (int i = 0; i < nameTitleList.size(); ++i) {
                String propertyName = nameTitleList.get(i);
                String valueStr = TacticInvestPlanImportHelper.getExcelCellStringValue(rowMap.get(orgId).getCell(i));
                if (propertyName.equals("orgfield") || propertyName.equals("orgfield_id")) continue;
                entity.set(propertyName, (Object)valueStr);
            }
        }
    }

    public static String getExcelCellStringValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BLANK: 
            case _NONE: 
            case ERROR: 
            case FORMULA: {
                return null;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case NUMERIC: {
                String doubleValue = String.valueOf(Double.toString(cell.getNumericCellValue()));
                if (doubleValue.length() > 2 && ".0".equals(doubleValue.substring(doubleValue.length() - 2, doubleValue.length()))) {
                    return doubleValue.substring(0, doubleValue.length() - 2);
                }
                return doubleValue;
            }
            case STRING: {
                return cell.getStringCellValue().trim();
            }
        }
        return null;
    }
}

