/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmim.servicehelper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.form.upgrade.AbstractUpgradePlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang3.StringUtils;

public class InvestEntryUpgradePlugin
extends AbstractUpgradePlugin {
    private static final Log logger = LogFactory.getLog(InvestEntryUpgradePlugin.class);

    public UpgradeResult beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
        String algoKey = "InvestEntryUpgradePlugin.beforeExecuteSql";
        StringBuilder queryPoSal = new StringBuilder("select invest.FEntryID,posal.fprojectstatusid,posal_a.finvestdirection,posal_a.finvestkind,posal_a.foverseapro,posal.fplanbegindate,posal.fplanenddate,posal.fprojcetbugamt ");
        queryPoSal.append("from  t_pmim_auinvestplanentry invest ");
        queryPoSal.append("left join t_pmim_projectproposal posal on posal.fid = invest.fprojectproposalid ");
        queryPoSal.append("left join t_pmim_projectproposal_a posal_a on  posal.fid = posal_a.fid ");
        DataSet entries = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)queryPoSal.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
        while (entries.hasNext()) {
            Row row = entries.next();
            Object[] param = new Object[7];
            param[0] = row.getLong(0);
            param[1] = row.get(1) != null ? row.getLong(1) : 0L;
            param[2] = row.get(2) != null ? row.getString(2) : "main";
            Object object = param[3] = row.get(3) != null ? row.getString(3) : "newstrategy";
            param[4] = row.get(4) != null ? (row.getBoolean(4) != false ? "1" : "0") : "0";
            Object startEndTime = "";
            Date planBeginDate = row.getDate(5);
            Date planEndDate = row.getDate(6);
            if (planBeginDate != null) {
                startEndTime = sdf.format(planBeginDate);
            }
            if (planEndDate != null) {
                startEndTime = sdf.format(planEndDate);
            }
            if (planBeginDate != null && planEndDate != null) {
                startEndTime = String.join((CharSequence)"-", sdf.format(planBeginDate), sdf.format(planEndDate));
            }
            param[5] = startEndTime;
            param[6] = row.get(3) != null ? row.getBigDecimal(7) : BigDecimal.ZERO;
            paramsList.add(param);
        }
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(16);
        if (paramsList.size() > 0) {
            String updateSql = "update t_pmim_auinvestplanentry set findustrykind = ?,finvestdirection = ?,finvestkind = ?,foverseapro = ?,fstartendtime = ?,fprojcetbugamt= ? where FEntryID = ?";
            for (Object[] param : paramsList) {
                SqlParameter[] sqlParam = new SqlParameter[]{new SqlParameter(":findustrykind", -5, param[1]), new SqlParameter(":finvestdirection", 12, param[2]), new SqlParameter(":finvestkind", 12, param[3]), new SqlParameter(":foverseapro", 12, param[4]), new SqlParameter(":fstartendtime", 12, param[5]), new SqlParameter(":fprojcetbugamt", 3, param[6]), new SqlParameter(":FEntryID", -5, param[0])};
                updateParams.add(sqlParam);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, updateParams);
        }
        String getPoSal = "select fid,fprojectproposalid from  t_pmim_projectproposalbd where fprojectproposalid != ' '";
        DataSet poSalData = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)getPoSal);
        ArrayList insertParams = new ArrayList(16);
        String querySource = "select fseq,ffundresourceid,fformofinvest,famount,fcurrencyid,fscale,fcurrententryamt,fremark from t_pmim_sourceentry where fid = ?";
        while (poSalData.hasNext()) {
            Row poSal = poSalData.next();
            Long billId = poSal.getLong(0);
            if (!StringUtils.isNotBlank((CharSequence)poSal.getString(1))) continue;
            long poSalId = Long.parseLong(poSal.getString(1));
            Object[] param = new Object[]{poSalId};
            DataSet sourceData = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)querySource, (Object[])param);
            while (sourceData.hasNext()) {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                Row source = sourceData.next();
                params.put("fid", billId);
                params.put("fseq", source.getInteger(0));
                params.put("ffundresourceid", source.getLong(1));
                params.put("fformofinvest", source.getString(2));
                params.put("famount", source.getBigDecimal(3));
                params.put("fcurrencyid", source.getLong(4));
                params.put("fscale", source.getBigDecimal(5));
                params.put("fcurrententryamt", source.getBigDecimal(6));
                params.put("fremark", source.getString(7));
                insertParams.add(params);
            }
        }
        if (insertParams.size() > 0) {
            long[] ids = DB.genLongIds((String)"t_pmim_proposal_f7_source", (int)insertParams.size());
            StringBuilder insertSql = new StringBuilder("insert into t_pmim_proposal_f7_source (FEntryID,Fid,FSeq,ffundsourcetype,fformofinvest,fentryamt,finvestcurrency,fscale,fcurrententryamt,fcomment )");
            insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?)");
            updateParams = new ArrayList(16);
            for (int i = 0; i < insertParams.size(); ++i) {
                Map param = (Map)insertParams.get(i);
                SqlParameter[] sqlParam = new SqlParameter[]{new SqlParameter(":FEntryID", -5, (Object)ids[i]), new SqlParameter(":Fid", -5, param.get("fid")), new SqlParameter(":FSeq", 4, param.get("fseq")), new SqlParameter(":ffundsourcetype", -5, param.get("ffundresourceid")), new SqlParameter(":fformofinvest", 12, param.get("fformofinvest")), new SqlParameter(":fentryamt", 3, param.get("famount")), new SqlParameter(":finvestcurrency", -5, param.get("fcurrencyid")), new SqlParameter(":fscale", 3, param.get("fscale")), new SqlParameter(":fcurrententryamt", 3, param.get("fcurrententryamt")), new SqlParameter(":fcomment", -9, param.get("fremark"))};
                updateParams.add(sqlParam);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)insertSql.toString(), updateParams);
        }
        return super.beforeExecuteSql(ver, iteration, dbKey, sqlFileName);
    }
}

