/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;

public class PlanEntryUtil {
    public static DynamicObject cloneTaskToEntry(DynamicObject task, DynamicObjectType dt) {
        DynamicObject entry = new DynamicObject(dt);
        entry.set("id", task.getPkValue());
        entry.set("taskid", task.getPkValue());
        entry.set("taskname", (Object)task.getString("name"));
        entry.set("absoluteshedule", (Object)task.getBigDecimal("absoluteduration"));
        entry.set("achievementnode", task.get("achievementnode"));
        entry.set("aimfinishtime", task.get("aimfinishtime"));
        entry.set("comptimedeviation", task.get("comptimedeviation"));
        entry.set("controllevel", task.get("controllevel"));
        entry.set("directorg", task.get("responsibledept"));
        entry.set("directperson", task.get("responsibleperson"));
        entry.set("indirectorg", task.get("cooperationdept"));
        entry.set("indirectperson", task.get("cooperationperson"));
        entry.set("isleaf", task.get("isleaf"));
        entry.set("level", task.get("level"));
        entry.set("pid", task.getDynamicObject("parent") == null ? Integer.valueOf(0) : task.getDynamicObject("parent").getPkValue());
        entry.set("logical", task.get("logical"));
        entry.set("parent", (Object)task.getDynamicObject("parent"));
        entry.set("percent", (Object)task.getBigDecimal("percent"));
        entry.set("planbegindate", task.get("planstarttime"));
        entry.set("planenddate", task.get("planendtime"));
        entry.set("pretask", task.get("prechangetask"));
        entry.set("realendtime", task.get("realendtime"));
        entry.set("relativeschedule", task.get("relativeduration"));
        entry.set("spectype", task.get("majortype"));
        entry.set("tasknumber", task.get("number"));
        entry.set("tasktype", task.get("tasktype"));
        return entry;
    }

    public static int getSameLevelChildIndex(IFormView view, IDataModel model, int seq) {
        String parentTaskId = (String)model.getValue("taskid", seq);
        int lastChildIndex = seq;
        HashSet<String> parentIdSet = new HashSet<String>();
        parentIdSet.add(parentTaskId);
        int rowCount = model.getEntryRowCount("taskentity");
        for (int i = seq + 1; i < rowCount; ++i) {
            String curParentId;
            DynamicObject curParent = (DynamicObject)model.getValue("parent", i);
            String string = curParentId = curParent == null ? "" : curParent.getString("id");
            if (!parentIdSet.contains(curParentId)) break;
            String curTaskId = (String)model.getValue("taskid", i);
            parentIdSet.add(curTaskId);
            if (!curParentId.equals(parentTaskId)) continue;
            lastChildIndex = i;
            break;
        }
        return lastChildIndex;
    }

    public static void beforeEntryF7Select(IFormView view, IDataModel model, BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        int curIndex = model.getEntryCurrentRowIndex("taskentity");
        if (curIndex < 0) {
            view.showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u884c\u5931\u8d25", (String)"PlanEntryUtil_0", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return;
        }
        switch (propName) {
            case "pretask": {
                String taskId = (String)model.getValue("taskid", curIndex);
                PlanEntryUtil.setPreTaskFilter(arg0, taskId);
                break;
            }
            case "directperson": {
                DynamicObject responsibleDept = (DynamicObject)model.getValue("directorg");
                if (responsibleDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(responsibleDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "directorg": {
                DynamicObject responsiblePreson = (DynamicObject)model.getValue("directperson");
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                if (responsiblePreson != null) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsiblePreson.getPkValue().toString()), (boolean)false);
                    QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                    showParameter.getListFilterParameter().setFilter(orgFilter);
                }
                showParameter.setMultiSelect(false);
                break;
            }
            case "indirectperson": {
                DynamicObject cooperationDept = (DynamicObject)model.getValue("indirectorg");
                if (cooperationDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(cooperationDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "indirectorg": {
                DynamicObject cooperationPreson = (DynamicObject)model.getValue("indirectperson");
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                if (cooperationPreson != null) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(cooperationPreson.getPkValue().toString()), (boolean)false);
                    QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                    showParameter.getListFilterParameter().setFilter(orgFilter);
                }
                showParameter.setMultiSelect(false);
                break;
            }
            case "spectype": {
                DynamicObject projectKind;
                DynamicObject project = (DynamicObject)model.getValue("project");
                if (project == null || (projectKind = project.getDynamicObject("group")) == null) break;
                QFilter kindFilter = new QFilter("group", "=", (Object)projectKind.getString("id"));
                QFilter enbleFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(kindFilter.and(enbleFilter));
                break;
            }
        }
    }

    public static void saveTask(IFormView view, IDataModel model) {
        int rowCount = model.getEntryRowCount("taskentity");
        DynamicObject[] savedTaskArr = new DynamicObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject rowObj = model.getEntryRowEntity("taskentity", i);
            String taskId = (String)model.getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            task.set("name", (Object)rowObj.getString("taskname"));
            task.set("number", (Object)rowObj.getString("tasknumber"));
            task.set("controllevel", (Object)rowObj.getDynamicObject("controllevel"));
            task.set("majortype", (Object)rowObj.getDynamicObject("spectype"));
            task.set("tasktype", (Object)rowObj.getDynamicObject("tasktype"));
            task.set("absoluteduration", (Object)rowObj.getBigDecimal("absoluteshedule"));
            task.set("pretask", (Object)rowObj.getDynamicObject("pretask"));
            task.set("logical", (Object)rowObj.getString("logical"));
            task.set("parent", (Object)rowObj.getDynamicObject("parent"));
            task.set("level", (Object)rowObj.getBigDecimal("level"));
            task.set("isleaf", (Object)rowObj.getBoolean("isleaf"));
            task.set("relativeduration", (Object)rowObj.getBigDecimal("relativeschedule"));
            task.set("planstarttime", (Object)rowObj.getDate("planbegindate"));
            task.set("planendtime", (Object)rowObj.getDate("planenddate"));
            task.set("aimfinishtime", (Object)rowObj.getDate("aimfinishtime"));
            task.set("comptimedeviation", (Object)rowObj.getBigDecimal("comptimedeviation"));
            task.set("responsibleperson", (Object)rowObj.getDynamicObject("directperson"));
            task.set("responsibledept", (Object)rowObj.getDynamicObject("directorg"));
            task.set("cooperationperson", (Object)rowObj.getDynamicObject("indirectperson"));
            task.set("cooperationdept", (Object)rowObj.getDynamicObject("indirectorg"));
            task.set("achievementnode", (Object)rowObj.getString("achievementnode"));
            task.set("taskseq", (Object)(i + 1));
            savedTaskArr[i] = task;
        }
        SaveServiceHelper.save((DynamicObject[])savedTaskArr);
    }

    public static void setRowTaskObj(IFormView view, IDataModel model, DynamicObject task, int seq) {
        model.beginInit();
        model.setValue("taskname", (Object)task.getString("name"), seq);
        model.setValue("tasknumber", (Object)task.getString("number"), seq);
        model.setValue("controllevel", (Object)task.getDynamicObject("controllevel"), seq);
        model.setValue("spectype", (Object)task.getDynamicObject("majortype"), seq);
        model.setValue("tasktype", (Object)task.getDynamicObject("tasktype"), seq);
        model.setValue("absoluteshedule", (Object)task.getBigDecimal("absoluteduration"), seq);
        model.setValue("pretask", (Object)task.getDynamicObject("pretask"), seq);
        model.setValue("parent", (Object)task.getDynamicObject("parent"), seq);
        model.setValue("level", (Object)task.getBigDecimal("level"), seq);
        model.setValue("isleaf", (Object)task.getBoolean("isleaf"), seq);
        model.setValue("relativeschedule", (Object)task.getBigDecimal("relativeduration"), seq);
        model.setValue("planbegindate", (Object)task.getDate("planstarttime"), seq);
        model.setValue("planenddate", (Object)task.getDate("planendtime"), seq);
        model.setValue("directperson", (Object)task.getDynamicObject("responsibleperson"), seq);
        model.setValue("directorg", (Object)task.getDynamicObject("responsibledept"), seq);
        model.setValue("indirectperson", (Object)task.getDynamicObject("cooperationperson"), seq);
        model.setValue("indirectorg", (Object)task.getDynamicObject("cooperationdept"), seq);
        model.setValue("taskid", (Object)task.getString("id"), seq);
        model.setValue("aimfinishtime", (Object)task.getDate("aimfinishtime"), seq);
        model.setValue("comptimedeviation", (Object)task.getBigDecimal("comptimedeviation"), seq);
        model.setValue("logical", (Object)task.getString("logical"), seq);
        model.setValue("achievementnode", (Object)task.getString("achievementnode"), seq);
        model.setValue("realendtime", (Object)task.getString("realendtime"), seq);
        model.setValue("percent", (Object)task.getString("percent"), seq);
        model.endInit();
        view.updateView("taskentity");
    }

    public static void setRowTaskObjForImp(IFormView view, IDataModel model, DynamicObject task, int seq) {
        model.setValue("taskid", (Object)task.getString("id"), seq);
        model.setValue("taskname", (Object)task.getString("name"), seq);
        model.setValue("tasknumber", (Object)task.getString("number"), seq);
        model.setValue("controllevel", (Object)task.getDynamicObject("controllevel"), seq);
        model.setValue("spectype", (Object)task.getDynamicObject("majortype"), seq);
        model.setValue("tasktype", (Object)task.getDynamicObject("tasktype"), seq);
        model.setValue("achievementnode", (Object)task.getString("achievementnode"), seq);
        model.setValue("level", (Object)task.getBigDecimal("level"), seq);
        model.setValue("isleaf", (Object)task.getBoolean("isleaf"), seq);
        model.setValue("comptimedeviation", (Object)task.getBigDecimal("comptimedeviation"), seq);
        model.beginInit();
        model.setValue("absoluteshedule", (Object)task.getBigDecimal("absoluteduration"), seq);
        model.setValue("planbegindate", (Object)task.getDate("planstarttime"), seq);
        model.setValue("planenddate", (Object)task.getDate("planendtime"), seq);
        model.setValue("pretask", (Object)task.getDynamicObject("pretask"), seq);
        model.setValue("parent", (Object)task.getDynamicObject("parent"), seq);
        model.setValue("logical", (Object)task.getString("logical"), seq);
        model.setValue("relativeschedule", (Object)task.getBigDecimal("relativeduration"), seq);
        model.setValue("aimfinishtime", (Object)task.getDate("aimfinishtime"), seq);
        model.setValue("directperson", (Object)task.getDynamicObject("responsibleperson"), seq);
        model.setValue("directorg", (Object)task.getDynamicObject("responsibledept"), seq);
        model.setValue("indirectperson", (Object)task.getDynamicObject("cooperationperson"), seq);
        model.setValue("indirectorg", (Object)task.getDynamicObject("cooperationdept"), seq);
        model.endInit();
        view.updateView("absoluteshedule", seq);
        view.updateView("planbegindate", seq);
        view.updateView("planenddate", seq);
        view.updateView("pretask", seq);
        view.updateView("parent", seq);
        view.updateView("logical", seq);
        view.updateView("relativeschedule", seq);
        view.updateView("aimfinishtime", seq);
        view.updateView("directperson", seq);
        view.updateView("directorg", seq);
        view.updateView("indirectperson", seq);
        view.updateView("indirectorg", seq);
    }

    public static void updateTaskEntryComTimeDeviationColor(IFormView view, IDataModel model) {
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentity");
        EntryGrid grid = (EntryGrid)view.getControl("taskentity");
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>(taskEntry.size());
        for (int i = 0; i < taskEntry.size(); ++i) {
            BigDecimal comTimeDeviation = ((DynamicObject)taskEntry.get(i)).getBigDecimal("comptimedeviation");
            CellStyle statusStyle = new CellStyle();
            statusStyle.setRow(i);
            statusStyle.setFieldKey("comptimedeviation");
            if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
                statusStyle.setForeColor("#00DD2C");
            } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
                statusStyle.setForeColor("#FF0000");
            }
            statusStyles.add(statusStyle);
        }
        grid.setCellStyle(statusStyles);
    }

    public static void calCompTimeDeviation(IFormView view, IDataModel model, int curIndex) {
        Date aimFinishTime = (Date)model.getValue("aimfinishtime", curIndex);
        Date planEndTime = (Date)model.getValue("planenddate", curIndex);
        DynamicObject project = (DynamicObject)model.getValue("project");
        if (aimFinishTime == null || planEndTime == null) {
            model.setValue("comptimedeviation", null, curIndex);
            return;
        }
        if (project != null) {
            try {
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planEndTime, (Date)aimFinishTime);
                model.setValue("comptimedeviation", (Object)days, curIndex);
            }
            catch (KDBizException e) {
                view.showTipNotification(e.getMessage());
                int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
                model.setValue("comptimedeviation", (Object)days, curIndex);
            }
        } else {
            int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
            model.setValue("comptimedeviation", (Object)days, curIndex);
        }
        PlanEntryUtil.updateTimeDeviationColor(view, model, curIndex);
        view.updateView("taskentity");
    }

    public static void updateTimeDeviationColor(IFormView view, IDataModel model, int curIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)model.getValue("comptimedeviation", curIndex);
        EntryGrid grid = (EntryGrid)view.getControl("taskentity");
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(curIndex);
        statusStyle.setFieldKey("comptimedeviation");
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            statusStyle.setForeColor("#00DD2C");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            statusStyle.setForeColor("#FF0000");
        } else {
            statusStyle.setForeColor("#666");
        }
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    public static void calPlanTimeByPreTaskAndLogical(IFormView view, IDataModel model, int curIndex) {
        block42: {
            Date preTaskPlanEndTime;
            DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
            if (preTask == null) {
                return;
            }
            preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getString("id"), (String)"pmpm_task");
            int rowCount = model.getEntryRowCount("taskentity");
            if (rowCount == 0) {
                return;
            }
            for (int i = 0; i < rowCount; ++i) {
                String taskId = (String)model.getValue("taskid", i);
                if (!StringUtils.equals((CharSequence)String.valueOf(preTask.getPkValue()), (CharSequence)taskId)) continue;
                PlanEntryUtil.setRowValToTask(view, model, preTask, i);
            }
            String logical = (String)model.getValue("logical", curIndex);
            BigDecimal absDuration = (BigDecimal)model.getValue("absoluteshedule", curIndex);
            DynamicObject project = (DynamicObject)model.getValue("project");
            BigDecimal relativeduration = (BigDecimal)model.getValue("relativeschedule");
            if ((relativeduration = relativeduration.add(BigDecimal.ONE)).floatValue() < 0.0f) {
                relativeduration = relativeduration.subtract(BigDecimal.ONE);
            }
            model.beginInit();
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                            if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime)) break block42;
                            model.setValue("planbegindate", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absDuration.intValue() - 1));
                                if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", planEndTime)) {
                                    model.setValue("planenddate", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planbegindate", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planbegindate", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planbegindate", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanEndTime2 = preTask.getDate("planendtime");
                if (preTaskPlanEndTime2 != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                            if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime)) break block42;
                            model.setValue("planbegindate", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absDuration.intValue() - 1));
                                if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", planEndTime)) {
                                    model.setValue("planenddate", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planbegindate", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planbegindate", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                        model.setValue("planbegindate", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                            if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planenddate", planEndTime)) break block42;
                            model.setValue("planenddate", (Object)planEndTime, curIndex);
                            try {
                                Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absDuration.intValue()));
                                if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime)) {
                                    model.setValue("planbegindate", (Object)planStartTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planbegindate", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planenddate", null, curIndex);
                        }
                    } else {
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                        model.setValue("planbegindate", (Object)planStartTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && (preTaskPlanEndTime = preTask.getDate("planendtime")) != null) {
                if (project != null) {
                    try {
                        Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                        if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planenddate", planEndTime)) break block42;
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absDuration.intValue()));
                            if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime)) {
                                model.setValue("planbegindate", (Object)planStartTime, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planbegindate", null, curIndex);
                        }
                    }
                    catch (KDBizException e) {
                        view.showTipNotification(e.getMessage());
                        model.setValue("planenddate", null, curIndex);
                    }
                } else {
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                    model.setValue("planenddate", (Object)planEndTime, curIndex);
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                    model.setValue("planbegindate", (Object)planStartTime, curIndex);
                }
            }
        }
        model.endInit();
        PlanEntryUtil.calCompTimeDeviation(view, model, curIndex);
        view.updateView("taskentity");
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor(view, model);
    }

    public static void calMarjorPlanTimeByPreTaskAndLogical(IFormView view, IDataModel model, int curIndex, BigDecimal oldRelativeschedule) {
        block42: {
            Date preTaskPlanEndTime;
            DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
            if (preTask == null) {
                return;
            }
            preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getString("id"), (String)"pmpm_task");
            int rowCount = model.getEntryRowCount("taskentity");
            if (rowCount == 0) {
                return;
            }
            for (int i = 0; i < rowCount; ++i) {
                String taskId = (String)model.getValue("taskid", i);
                if (!StringUtils.equals((CharSequence)String.valueOf(preTask.getPkValue()), (CharSequence)taskId)) continue;
                PlanEntryUtil.setRowValToTask(view, model, preTask, i);
            }
            String logical = (String)model.getValue("logical", curIndex);
            BigDecimal absDuration = (BigDecimal)model.getValue("absoluteshedule", curIndex);
            DynamicObject project = (DynamicObject)model.getValue("project");
            BigDecimal relativeduration = (BigDecimal)model.getValue("relativeschedule");
            if ((relativeduration = relativeduration.add(BigDecimal.ONE)).floatValue() < 0.0f) {
                relativeduration = relativeduration.subtract(BigDecimal.ONE);
            }
            model.beginInit();
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                            if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime, oldRelativeschedule)) break block42;
                            model.setValue("planbegindate", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absDuration.intValue() - 1));
                                if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planbegindate", planEndTime, oldRelativeschedule)) {
                                    model.setValue("planenddate", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planbegindate", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planbegindate", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planbegindate", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanEndTime2 = preTask.getDate("planendtime");
                if (preTaskPlanEndTime2 != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                            if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime, oldRelativeschedule)) break block42;
                            model.setValue("planbegindate", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absDuration.intValue() - 1));
                                if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planbegindate", planEndTime, oldRelativeschedule)) {
                                    model.setValue("planenddate", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planbegindate", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planbegindate", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                        model.setValue("planbegindate", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                            if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planenddate", planEndTime, oldRelativeschedule)) break block42;
                            model.setValue("planenddate", (Object)planEndTime, curIndex);
                            try {
                                Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absDuration.intValue()));
                                if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime, oldRelativeschedule)) {
                                    model.setValue("planbegindate", (Object)planStartTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planbegindate", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planenddate", null, curIndex);
                        }
                    } else {
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                        model.setValue("planbegindate", (Object)planStartTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && (preTaskPlanEndTime = preTask.getDate("planendtime")) != null) {
                if (project != null) {
                    try {
                        Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                        if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planenddate", planEndTime, oldRelativeschedule)) break block42;
                        model.setValue("planenddate", (Object)planEndTime, curIndex);
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absDuration.intValue()));
                            if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planbegindate", planStartTime, oldRelativeschedule)) {
                                model.setValue("planbegindate", (Object)planStartTime, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planbegindate", null, curIndex);
                        }
                    }
                    catch (KDBizException e) {
                        view.showTipNotification(e.getMessage());
                        model.setValue("planenddate", null, curIndex);
                    }
                } else {
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                    model.setValue("planenddate", (Object)planEndTime, curIndex);
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                    model.setValue("planbegindate", (Object)planStartTime, curIndex);
                }
            }
        }
        model.endInit();
        PlanEntryUtil.calCompTimeDeviation(view, model, curIndex);
        view.updateView("taskentity");
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor(view, model);
    }

    private static boolean newCheckOutMainTaskTime(IFormView view, IDataModel model, int curIndex, String timeField, Date newTime) {
        if (newTime == null) {
            return false;
        }
        String taskId = (String)model.getValue("taskid", curIndex);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        belongplantype = BusinessDataServiceHelper.loadSingle((Object)belongplantype.getString("id"), (String)"pmpm_majortype", (String)"plantype");
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask((DynamicObject)task)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4,\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_1", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
                        model.setValue(timeField, null, curIndex);
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4,\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
                        model.setValue(timeField, null, curIndex);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean checkOutMainTaskTime(IFormView view, IDataModel model, int curIndex, String timeField, Date newTime, BigDecimal oldRelativeschedule) {
        if (newTime == null) {
            return false;
        }
        String taskId = (String)model.getValue("taskid", curIndex);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
        DynamicObject belongplantype = BusinessDataServiceHelper.loadSingle((Object)task.getDynamicObject("belongplantype").getString("id"), (String)"pmpm_majortype", (String)"plantype");
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask((DynamicObject)task)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4,\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_1", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
                        model.setValue("relativeschedule", (Object)oldRelativeschedule, curIndex);
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4,\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
                        model.setValue("relativeschedule", (Object)oldRelativeschedule, curIndex);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void calPlanTime(IFormView view, IDataModel model, int curIndex, String changeField) {
        Date planStartTime = (Date)model.getValue("planbegindate", curIndex);
        BigDecimal absoluteDuration = (BigDecimal)model.getValue("absoluteshedule", curIndex);
        Date planEndTime = (Date)model.getValue("planenddate", curIndex);
        DynamicObject project = (DynamicObject)model.getValue("project");
        if (project == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"PlanEntryUtil_3", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return;
        }
        switch (changeField) {
            case "absoluteshedule": {
                DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
                String logical = (String)model.getValue("logical", curIndex);
                if (preTask != null && (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) || StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical))) {
                    if (planEndTime == null) break;
                    model.beginInit();
                    Date newPlanStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()));
                    if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", newPlanStartTime)) {
                        return;
                    }
                    model.setValue("planbegindate", (Object)newPlanStartTime, curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (planStartTime != null) {
                    model.beginInit();
                    Date newPlanEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                    if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planenddate", newPlanEndTime)) {
                        return;
                    }
                    model.setValue("planenddate", (Object)newPlanEndTime, curIndex);
                    PlanEntryUtil.calCompTimeDeviation(view, model, curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (planEndTime == null) break;
                model.beginInit();
                Date newPlanStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()));
                if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", newPlanStartTime)) {
                    return;
                }
                model.setValue("planbegindate", (Object)newPlanStartTime, curIndex);
                model.endInit();
                view.updateView("taskentity");
                break;
            }
            case "planenddate": {
                if (planStartTime != null) {
                    model.beginInit();
                    BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
                    model.setValue("absoluteshedule", (Object)newAbsoluteDuration.add(BigDecimal.ONE), curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                model.beginInit();
                Date newPlanStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()));
                if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planbegindate", newPlanStartTime)) {
                    return;
                }
                model.setValue("planbegindate", (Object)newPlanStartTime, curIndex);
                model.endInit();
                view.updateView("taskentity");
                break;
            }
            case "planbegindate": {
                DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
                String logical = (String)model.getValue("logical", curIndex);
                if (preTask != null && (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical))) {
                    preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getString("id"), (String)"pmpm_task");
                    if (planEndTime == null) break;
                    model.beginInit();
                    BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
                    model.setValue("absoluteshedule", (Object)newAbsoluteDuration.add(BigDecimal.ONE), curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (absoluteDuration != null && absoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
                    if (planEndTime == null) break;
                    model.beginInit();
                    BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
                    model.setValue("absoluteshedule", (Object)newAbsoluteDuration.add(BigDecimal.ONE), curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                model.beginInit();
                Date newPlanEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planenddate", newPlanEndTime)) {
                    return;
                }
                model.setValue("planenddate", (Object)newPlanEndTime, curIndex);
                model.setValue("planenddate", (Object)newPlanEndTime, curIndex);
                PlanEntryUtil.calCompTimeDeviation(view, model, curIndex);
                model.endInit();
                view.updateView("taskentity");
                break;
            }
        }
    }

    public static void updateEntryTaskTimeWhenCalModify(IFormView view, IDataModel model) {
        int i;
        int rowCount = model.getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>();
        ArrayList<DynamicObject> referTaskList = new ArrayList<DynamicObject>();
        DynamicObject majorType = model.getDataEntity().getDynamicObject("majortype");
        if (majorType != null) {
            DynamicObject rowTask;
            String taskId;
            int i2;
            majorType = BusinessDataServiceHelper.loadSingle((Object)majorType.getPkValue(), (String)"pmpm_majortype");
            String planType = majorType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                for (i2 = 0; i2 < rowCount; ++i2) {
                    taskId = (String)model.getValue("taskid", i2);
                    rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                    PlanEntryUtil.setRowValToTask(view, model, rowTask, i2);
                    referTaskList.add(rowTask);
                    taskIdIndexMap.put(taskId, i2);
                }
            } else if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType)) {
                for (i2 = 0; i2 < rowCount; ++i2) {
                    taskId = (String)model.getValue("taskid", i2);
                    rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                    DynamicObject belongPlanType = rowTask.getDynamicObject("belongplantype");
                    if (belongPlanType == null) continue;
                    String taskBelongPlanType = belongPlanType.getString("plantype");
                    if (!StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)taskBelongPlanType)) continue;
                    PlanEntryUtil.setRowValToTask(view, model, rowTask, i2);
                    referTaskList.add(rowTask);
                    taskIdIndexMap.put(taskId, i2);
                }
            }
        }
        DynamicObject[] referTaskArr = referTaskList.toArray(new DynamicObject[referTaskList.size()]);
        DynamicObject prObject = (DynamicObject)model.getValue("project");
        for (i = 0; i < referTaskArr.length; ++i) {
            Date planStartTime = referTaskArr[i].getDate("planstarttime");
            BigDecimal absoluteDuration = referTaskArr[i].getBigDecimal("absoluteduration");
            Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)prObject.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
            if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, (Integer)taskIdIndexMap.get(referTaskArr[i].getString("id")), "planenddate", planEndTime)) {
                referTaskArr[i].set("planendtime", (Object)planEndTime);
                Date aimEndTime = referTaskArr[i].getDate("aimfinishtime");
                BigDecimal compTimeDeviation = PmpmTaskUtil.getDaysBetweenTwoDate((Object)prObject.getPkValue(), (Date)planEndTime, (Date)aimEndTime);
                referTaskArr[i].set("comptimedeviation", (Object)compTimeDeviation);
                continue;
            }
            referTaskArr[i].set("planendtime", null);
            referTaskArr[i].set("aimfinishtime", null);
            referTaskArr[i].set("comptimedeviation", (Object)0);
        }
        for (i = 0; i < referTaskArr.length; ++i) {
            PmpmTaskUtil.updataAfterTaskTime((DynamicObject[])referTaskArr, (DynamicObject)referTaskArr[i]);
            PmpmTaskUtil.updateParentTaskTime((DynamicObject[])referTaskArr, (DynamicObject)referTaskArr[i]);
        }
        for (DynamicObject taskObj : referTaskArr) {
            String taskId = taskObj.getString("id");
            int index = (Integer)taskIdIndexMap.get(taskId);
            model.beginInit();
            model.setValue("absoluteshedule", taskObj.get("absoluteduration"), index);
            model.setValue("planbegindate", taskObj.get("planstarttime"), index);
            model.setValue("planenddate", taskObj.get("planendtime"), index);
            model.setValue("aimfinishtime", taskObj.get("aimfinishtime"), index);
            model.setValue("comptimedeviation", taskObj.get("comptimedeviation"), index);
            model.endInit();
        }
        SaveServiceHelper.save((DynamicObject[])referTaskArr);
        view.updateView("taskentity");
    }

    public static void updateReferTaskTime(IFormView view, IDataModel model, DynamicObject task) {
        int rowCount = model.getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>(rowCount);
        DynamicObject[] referTaskArr = new DynamicObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject rowTask;
            String taskId = (String)model.getValue("taskid", i);
            referTaskArr[i] = rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            PlanEntryUtil.setRowValToTask(view, model, rowTask, i);
            taskIdIndexMap.put(taskId, i);
        }
        PmpmTaskUtil.updataAfterTaskTime((DynamicObject[])referTaskArr, (DynamicObject)task);
        PmpmTaskUtil.updateParentTaskTime((DynamicObject[])referTaskArr, (DynamicObject)task);
        for (DynamicObject taskObj : referTaskArr) {
            String taskId = taskObj.getString("id");
            int index = (Integer)taskIdIndexMap.get(taskId);
            model.beginInit();
            model.setValue("absoluteshedule", taskObj.get("absoluteduration"), index);
            model.setValue("planbegindate", taskObj.get("planstarttime"), index);
            model.setValue("planenddate", taskObj.get("planendtime"), index);
            model.setValue("aimfinishtime", taskObj.get("aimfinishtime"), index);
            model.setValue("comptimedeviation", taskObj.get("comptimedeviation"), index);
            model.endInit();
            view.updateView("absoluteshedule", index);
            view.updateView("planbegindate", index);
            view.updateView("planenddate", index);
            view.updateView("aimfinishtime", index);
            view.updateView("comptimedeviation", index);
        }
    }

    public static void updateReferTaskTimeForTreeGrade(IFormView view, IDataModel model, DynamicObject task) {
        int rowCount = model.getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>(rowCount);
        DynamicObject[] referTaskArr = new DynamicObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)model.getValue("taskid", i);
            DynamicObject rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            PlanEntryUtil.setRowValToTask(view, model, rowTask, i);
            referTaskArr[i] = rowTask;
            taskIdIndexMap.put(taskId, i);
        }
        PlanEntryUtil.checkPreTask(view, Arrays.asList(referTaskArr));
        PmpmTaskUtil.updataAfterTaskTime((DynamicObject[])referTaskArr, (DynamicObject)task);
        PmpmTaskUtil.updateParentTaskTime((DynamicObject[])referTaskArr, (DynamicObject)task);
        for (DynamicObject taskObj : referTaskArr) {
            String taskId = taskObj.getString("id");
            int index = (Integer)taskIdIndexMap.get(taskId);
            model.beginInit();
            model.setValue("absoluteshedule", taskObj.get("absoluteduration"), index);
            model.setValue("planbegindate", taskObj.get("planstarttime"), index);
            model.setValue("planenddate", taskObj.get("planendtime"), index);
            model.setValue("aimfinishtime", taskObj.get("aimfinishtime"), index);
            model.setValue("comptimedeviation", taskObj.get("comptimedeviation"), index);
            model.endInit();
            view.updateView("absoluteshedule", index);
            view.updateView("planbegindate", index);
            view.updateView("planenddate", index);
            view.updateView("aimfinishtime", index);
            view.updateView("comptimedeviation", index);
        }
    }

    private static void checkPreTask(IFormView view, List<DynamicObject> taskList) {
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask == null) continue;
            boolean flag = false;
            boolean flag1 = PlanEntryUtil.preTaskIdInParentIds(view, taskList, preTask.getString("id"), task);
            boolean flag2 = PlanEntryUtil.preTaskIdInAfterTaskIds(taskList, preTask.getString("id"), task);
            if (task.getString("id").equals(preTask.getString("id"))) {
                flag = true;
            }
            if (!flag && !flag1 && !flag2) continue;
            task.set("pretask", null);
            task.set("logical", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        }
    }

    private static boolean preTaskIdInParentIds(IFormView view, List<DynamicObject> taskList, String preTaskId, DynamicObject task) {
        if (task == null || task.getDynamicObject("parent") == null) {
            return false;
        }
        for (DynamicObject parentTask = task.getDynamicObject("parent"); parentTask != null; parentTask = parentTask.getDynamicObject("parent")) {
            boolean hasUpdate = false;
            for (DynamicObject taskObject : taskList) {
                if (!taskObject.getString("id").equals(parentTask.getString("id"))) continue;
                parentTask = taskObject;
                hasUpdate = true;
                break;
            }
            if (!hasUpdate) {
                parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getString("id"), (String)"pmpm_task");
            }
            if (!preTaskId.equals(parentTask.getString("id"))) continue;
            return true;
        }
        return false;
    }

    private static boolean preTaskIdInAfterTaskIds(List<DynamicObject> taskList, String preTaskId, DynamicObject task) {
        if (task == null) {
            return false;
        }
        for (DynamicObject curTask : taskList) {
            DynamicObject preTask = curTask.getDynamicObject("pretask");
            if (preTask == null || !preTask.getString("id").equals(task.getString("id"))) continue;
            if (preTaskId.equals(preTask.getString("id"))) {
                return true;
            }
            PlanEntryUtil.preTaskIdInAfterTaskIds(taskList, preTaskId, curTask);
        }
        return false;
    }

    public static void setRowValToTask(IFormView view, IDataModel model, DynamicObject task, int curIndex) {
        BigDecimal absoluteShedule = (BigDecimal)model.getValue("absoluteshedule", curIndex);
        BigDecimal relativeSchedule = (BigDecimal)model.getValue("relativeschedule", curIndex);
        Date planbegindate = (Date)model.getValue("planbegindate", curIndex);
        Date planenddate = (Date)model.getValue("planenddate", curIndex);
        Date aimfinishtime = (Date)model.getValue("aimfinishtime", curIndex);
        BigDecimal comptimedeviation = (BigDecimal)model.getValue("comptimedeviation", curIndex);
        DynamicObject parentTask = (DynamicObject)model.getValue("parent", curIndex);
        DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
        task.set("absoluteduration", (Object)absoluteShedule);
        task.set("relativeduration", (Object)relativeSchedule);
        task.set("planstarttime", (Object)planbegindate);
        task.set("planendtime", (Object)planenddate);
        task.set("aimfinishtime", (Object)aimfinishtime);
        task.set("comptimedeviation", (Object)comptimedeviation);
        task.set("parent", (Object)parentTask);
        task.set("pretask", (Object)preTask);
    }

    public static void setPreTaskFilter(BeforeF7SelectEvent arg, String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
        QFilter mulInPutFilter = new QFilter("name", "is not null", (Object)"").and(new QFilter("planstarttime", "is not null", (Object)"")).and(new QFilter("planendtime", "is not null", (Object)""));
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        Set parentIdSet = PmpmTaskUtil.getParentAndAfterTaskIdSet((DynamicObject)task);
        QFilter notParentFilter = new QFilter("id", "not in", (Object)parentIdSet);
        QFilter notSelfPkFilter = new QFilter("id", "!=", (Object)taskId);
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", (Object)"0");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter notFenjieFilter = new QFilter("belongplantype.plantype", "!=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
        DynamicObject prObject = task.getDynamicObject("project");
        ListShowParameter showParameter1 = (ListShowParameter)arg.getFormShowParameter();
        if (prObject != null) {
            QFilter projectFilter = new QFilter("project", "=", prObject.getPkValue());
            if (belongPlanType != null) {
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)belongPlanType.getString("plantype"))) {
                    DynamicObject[] taskArr = PlanEntryUtil.getThisTaskBelongPlanTask(task);
                    HashSet<Object> thisIdSet = new HashSet<Object>(16);
                    for (DynamicObject thisTask : taskArr) {
                        thisIdSet.add(thisTask.getPkValue());
                    }
                    Set<Object> prePlanTaskIdSet = PlanEntryUtil.getThisTaskBelongPlanPrePlanTaskIdSet(task);
                    QFilter notInPrePlanTaskIdSet = new QFilter("id", "not in", prePlanTaskIdSet);
                    QFilter filter = projectFilter.and(sourceTaskFilter).and(statusFilter).and(notInPrePlanTaskIdSet);
                    QFilter filter2 = new QFilter("id", "in", thisIdSet);
                    QFilter filter3 = filter.or(filter2).and(mulInPutFilter).and(notSelfPkFilter).and(notParentFilter);
                    showParameter1.getListFilterParameter().getQFilters().add(filter3.and(notFenjieFilter));
                } else {
                    Set<Object> taskIdSet = PlanEntryUtil.getThisTaskBelongPlanTaskIdSet(task);
                    QFilter filter = new QFilter("id", "in", taskIdSet);
                    showParameter1.getListFilterParameter().getQFilters().add(filter.and(notSelfPkFilter).and(notParentFilter).and(mulInPutFilter));
                }
            } else {
                showParameter1.getListFilterParameter().getQFilters().add(projectFilter.and(notSelfPkFilter).and(notParentFilter).and(mulInPutFilter));
            }
        } else {
            showParameter1.getListFilterParameter().getQFilters().add(notSelfPkFilter.and(notParentFilter).and(mulInPutFilter));
        }
    }

    public static Set<Object> getThisTaskBelongPlanPrePlanTaskIdSet(DynamicObject task) {
        HashSet<Object> idSet = new HashSet<Object>();
        if (task == null) {
            return idSet;
        }
        JSONObject plansObj = JSONObject.parseObject((String)task.getString("plans"));
        String planId = plansObj.getString("majorproplanid");
        QFilter majorPlanIdFilter = new QFilter("id", "=", (Object)planId);
        DynamicObject majorPlan = BusinessDataServiceHelper.loadSingle((String)"pmpm_majorplan", (String)"id,prechangeplan,taskentity,taskentity.taskid", (QFilter[])new QFilter[]{majorPlanIdFilter});
        DynamicObject preChangePlan = majorPlan.getDynamicObject("prechangeplan");
        if (preChangePlan != null) {
            DynamicObject[] taskArr;
            QFilter belongPlanTypeFilter = new QFilter("plans", "like", (Object)("%" + String.valueOf(preChangePlan.getPkValue()) + "%"));
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name", (QFilter[])new QFilter[]{belongPlanTypeFilter})) {
                idSet.add(dynamicObject.getPkValue());
            }
        }
        return idSet;
    }

    public static DynamicObject[] getThisTaskBelongPlanTask(DynamicObject task) {
        if (task == null) {
            return new DynamicObject[0];
        }
        JSONObject plansObj = JSONObject.parseObject((String)task.getString("plans"));
        String planId = plansObj.getString("majorproplanid");
        QFilter plansFilter = new QFilter("plans", "like", (Object)("%" + planId + "%"));
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,sourcetask", (QFilter[])new QFilter[]{plansFilter});
        return taskArr;
    }

    public static Set<Object> getThisTaskBelongPlanTaskIdSet(DynamicObject task) {
        HashSet<Object> idSet = new HashSet<Object>();
        if (task == null) {
            return idSet;
        }
        DynamicObject belongPlantype = task.getDynamicObject("belongplantype");
        if (belongPlantype != null) {
            JSONObject plansObj = JSONObject.parseObject((String)task.getString("plans"));
            String planType = belongPlantype.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                DynamicObject[] taskArr;
                String planId = plansObj.getString("mainproplanid");
                QFilter plansFilter = new QFilter("plans", "like", (Object)("%" + planId + "%"));
                for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id", (QFilter[])new QFilter[]{plansFilter})) {
                    idSet.add(dynamicObject.getPkValue());
                }
                return idSet;
            }
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType)) {
                DynamicObject[] taskArr;
                String planId = plansObj.getString("majorproplanid");
                QFilter plansFilter = new QFilter("plans", "like", (Object)("%" + planId + "%"));
                for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,sourcetask", (QFilter[])new QFilter[]{plansFilter})) {
                    idSet.add(dynamicObject.getPkValue());
                }
                return idSet;
            }
        }
        return idSet;
    }
}

