/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.TaskConstant;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.TaskCloneUtil;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.common.utils.PlanEntryUtil;
import kd.pmgt.pmpm.common.utils.PlanTaskPOIHelper;

public class PlanTaskImpAndExpUtil {
    private static final Log logger = LogFactory.getLog(PlanTaskImpAndExpUtil.class);
    private static final String[] COLUMNKEY = new String[]{"taskname", "controllevel", "spectype", "tasktype", "achievementnode", "pretask", "logical", "parent", "relativeschedule", "absoluteshedule", "planbegindate", "planenddate", "aimfinishtime", "directperson", "directperson.name", "directorg", "indirectperson", "indirectperson.name", "indirectorg"};
    private static String fileName = null;
    private static String sheetName = null;
    private static String[] header = null;
    private static List<String> mustFillColumn = null;

    private PlanTaskImpAndExpUtil() {
    }

    public static void exportModel(IFormView view, JSONArray datas) {
        if (fileName == null) {
            fileName = ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355", (String)"PlanTaskImpAndExpUtil_0", (String)"pmgt-pmpm-common", (Object[])new Object[0]);
        }
        if (sheetName == null) {
            sheetName = ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5217\u8868", (String)"PlanTaskImpAndExpUtil_1", (String)"pmgt-pmpm-common", (Object[])new Object[0]);
        }
        if (header == null) {
            header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PlanTaskImpAndExpUtil_3", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_4", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_5", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u679c\u8282\u70b9", (String)"PlanTaskImpAndExpUtil_6", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"PlanTaskImpAndExpUtil_7", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903b\u8f91\u5173\u7cfb", (String)"PlanTaskImpAndExpUtil_8", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"PlanTaskImpAndExpUtil_9", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f8\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_10", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_11", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"PlanTaskImpAndExpUtil_12", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"PlanTaskImpAndExpUtil_13", (String)"pmgt-pmpm-common", (Object[])new Object[0]), "\u5185\u63a7\u5b8c\u6210\u65e5\u671f", "\u8d23\u4efb\u4eba.\u5de5\u53f7", "\u8d23\u4efb\u4eba.\u59d3\u540d", ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_16", (String)"pmgt-pmpm-common", (Object[])new Object[0]), "\u534f\u529e\u4eba.\u5de5\u53f7", "\u534f\u529e\u4eba.\u59d3\u540d", ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_18", (String)"pmgt-pmpm-common", (Object[])new Object[0])};
        }
        if (mustFillColumn == null) {
            mustFillColumn = Arrays.asList(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PlanTaskImpAndExpUtil_3", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_5", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u679c\u8282\u70b9", (String)"PlanTaskImpAndExpUtil_6", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"PlanTaskImpAndExpUtil_12", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"PlanTaskImpAndExpUtil_13", (String)"pmgt-pmpm-common", (Object[])new Object[0]), "\u8d23\u4efb\u4eba.\u5de5\u53f7", ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_19", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
        }
        JSONArray data = null;
        if (datas != null) {
            data = datas;
        }
        String url = PlanTaskPOIHelper.newOutPutExcel(fileName, sheetName, header, COLUMNKEY, mustFillColumn, data);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"PlanTaskImpAndExpUtil_20", (String)"pmgt-pmpm-common", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    public static List<DynamicObject> importTask(IFormView view, String url) {
        String columnKeyHash = POIHelper.stringArrayToHash((String[])COLUMNKEY);
        JSONArray jsonArray = PlanTaskPOIHelper.newInputExcelForTask(url, columnKeyHash);
        if (jsonArray == null || jsonArray.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u4e0d\u5339\u914d\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"PlanTaskImpAndExpUtil_21", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
        }
        int seq = 0;
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        if (jsonArray != null && !jsonArray.isEmpty()) {
            for (Object obj : jsonArray) {
                JSONArray jArray = JSONArray.parseArray((String)obj.toString());
                PlanTaskImpAndExpUtil.createTask(view, jArray, taskList, seq);
                ++seq;
            }
        }
        String selRule = (String)view.getFormShowParameter().getCustomParam("selRule");
        if (!taskList.isEmpty() && "1".equals(selRule)) {
            PlanTaskImpAndExpUtil.calculateByDate(view, taskList);
        } else if (!taskList.isEmpty() && "2".equals(selRule)) {
            PlanTaskImpAndExpUtil.calculateByAbsoluteduration(view, taskList);
        }
        String formId = view.getFormShowParameter().getFormId();
        if ("pmpm_projectplan".equals(formId)) {
            PlanTaskImpAndExpUtil.setPreTaskForProPlan(taskList);
        } else if ("pmpm_majorplan".equals(formId)) {
            PlanTaskImpAndExpUtil.setPreTaskForMajoPlan(view, taskList);
        }
        PlanTaskImpAndExpUtil.checkAndCaculatePreTask(taskList);
        for (DynamicObject task : taskList) {
            PmpmTaskUtil.updateParentTaskTime((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]), (DynamicObject)task);
        }
        if (!taskList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]));
        }
        return taskList;
    }

    public static void calculateByDate(IFormView view, List<DynamicObject> taskList) {
        for (DynamicObject task : taskList) {
            DynamicObject project = task.getDynamicObject("project");
            Date planStartTime = task.getDate("planstarttime");
            Date planEndTime = task.getDate("planendtime");
            BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
            task.set("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
            PlanTaskImpAndExpUtil.calCompTimeDeviation(view, task);
        }
    }

    public static void calculateByAbsoluteduration(IFormView view, List<DynamicObject> taskList) {
        for (DynamicObject task : taskList) {
            DynamicObject project = task.getDynamicObject("project");
            Date planStartTime = task.getDate("planstarttime");
            BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
            Date newPlanEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
            task.set("planendtime", (Object)newPlanEndTime);
            PlanTaskImpAndExpUtil.calCompTimeDeviation(view, task);
        }
    }

    public static void calCompTimeDeviation(IFormView view, DynamicObject task) {
        Date aimFinishTime = task.getDate("aimfinishtime");
        Date planEndTime = task.getDate("planendtime");
        DynamicObject project = task.getDynamicObject("project");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planEndTime, (Date)aimFinishTime);
                task.set("comptimedeviation", (Object)days);
            }
            catch (KDBizException e) {
                view.showTipNotification(e.getMessage());
                int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
                task.set("comptimedeviation", (Object)days);
            }
        } else {
            int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
            task.set("comptimedeviation", (Object)days);
        }
    }

    private static void checkAndCaculatePreTask(List<DynamicObject> taskList) {
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask == null) continue;
            if (task.getString("id").equals(preTask.getString("id"))) {
                task.set("pretask", null);
                continue;
            }
            boolean flag1 = PlanTaskImpAndExpUtil.preTaskIdInParentIds(preTask.getString("id"), task);
            boolean flag2 = PlanTaskImpAndExpUtil.preTaskIdInAfterTaskIds(taskList, preTask.getString("id"), task);
            if (flag1 || flag2) {
                task.set("pretask", null);
                continue;
            }
            PlanTaskImpAndExpUtil.calulatePreTaskTime(task, preTask);
        }
    }

    private static boolean preTaskIdInParentIds(String preTaskId, DynamicObject task) {
        if (task == null || task.getDynamicObject("parent") == null) {
            return false;
        }
        for (DynamicObject parentTask = task.getDynamicObject("parent"); parentTask != null; parentTask = parentTask.getDynamicObject("parent")) {
            if (!preTaskId.equals(parentTask.getString("id"))) continue;
            return true;
        }
        return false;
    }

    private static boolean preTaskIdInAfterTaskIds(List<DynamicObject> taskList, String preTaskId, DynamicObject task) {
        if (task == null) {
            return false;
        }
        for (DynamicObject curTask : taskList) {
            DynamicObject preTask = curTask.getDynamicObject("pretask");
            if (preTask == null || !preTask.getString("id").equals(task.getString("id"))) continue;
            if (preTaskId.equals(preTask.getString("id"))) {
                return true;
            }
            PlanTaskImpAndExpUtil.preTaskIdInAfterTaskIds(taskList, preTaskId, curTask);
        }
        return false;
    }

    private static void setPreTaskForProPlan(List<DynamicObject> taskList) {
        for (DynamicObject task : taskList) {
            DynamicObject preTask;
            Object preTaskObj = task.get("pretask");
            if (preTaskObj == null) continue;
            String preTaskName = preTaskObj.toString();
            List preTaskList = taskList.stream().filter(obj -> preTaskName.equals(obj.getString("name"))).collect(Collectors.toList());
            if (preTaskList.isEmpty() || (preTask = (DynamicObject)preTaskList.get(0)).getDate("planstarttime") == null || preTask.getDate("planendtime") == null) continue;
            task.set("pretask", preTaskList.get(0));
        }
    }

    private static void setPreTaskForMajoPlan(IFormView view, List<DynamicObject> taskList) {
        IDataModel model = view.getModel();
        HashMap<String, DynamicObject> proTaskMap = new HashMap<String, DynamicObject>();
        int rowCount = model.getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskName = (String)model.getValue("taskname", i);
            String taskId = (String)model.getValue("taskid", i);
            if (!PlanTaskImpAndExpUtil.isMainTask(taskId)) continue;
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"id");
            proTaskMap.put(taskName, taskObj);
        }
        ArrayList<DynamicObject> delList = new ArrayList<DynamicObject>();
        for (DynamicObject task : taskList) {
            DynamicObject preTask;
            if (proTaskMap.containsKey(task.getString("name"))) {
                delList.add(task);
                continue;
            }
            if (task.getDynamicObject("parent") != null && proTaskMap.get(task.getDynamicObject("parent").getString("name")) != null) {
                task.set("parent", proTaskMap.get(task.getDynamicObject("parent").getString("name")));
            }
            if (task.getString("pretask") == null || proTaskMap.get(task.getString("pretask")) == null || (preTask = (DynamicObject)proTaskMap.get(task.getString("pretask"))).getDate("planstarttime") == null || preTask.getDate("planendtime") == null) continue;
            task.set("pretask", (Object)preTask);
        }
        if (!delList.isEmpty()) {
            taskList.removeAll(delList);
        }
        for (DynamicObject task : taskList) {
            Object preTaskObj = task.get("pretask");
            if (preTaskObj == null) continue;
            String preTaskName = preTaskObj.toString();
            List preTaskList = taskList.stream().filter(obj -> preTaskName.equals(obj.getString("name"))).collect(Collectors.toList());
            if (preTaskList.size() <= 0) continue;
            task.set("pretask", preTaskList.get(0));
            PlanTaskImpAndExpUtil.calulatePreTaskTime(task, (DynamicObject)preTaskList.get(0));
        }
    }

    private static boolean isMainTask(String taskId) {
        if (taskId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1ID\u4e3a\u7a7a", (String)"PlanTaskImpAndExpUtil_23", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        return "1".equals((belongplantype = BusinessDataServiceHelper.loadSingle((Object)belongplantype.getString("id"), (String)"pmpm_majortype", (String)"plantype")).getString("plantype"));
    }

    public static void calulatePreTaskTime(DynamicObject task, DynamicObject preTask) {
        block29: {
            Date preTaskPlanEndTime;
            String logical = task.getString("logical");
            DynamicObject project = task.getDynamicObject("project");
            BigDecimal relativeduration = task.getBigDecimal("relativeduration");
            BigDecimal absoluteduration = task.getBigDecimal("absoluteduration");
            if ((relativeduration = relativeduration.add(BigDecimal.ONE)).floatValue() < 0.0f) {
                relativeduration = relativeduration.subtract(BigDecimal.ONE);
            }
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (project != null) {
                    try {
                        Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        task.set("planstarttime", (Object)planStartTime);
                        Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteduration.intValue() - 1));
                        task.set("planendtime", (Object)planEndTime);
                    }
                    catch (KDBizException e) {
                        throw new KDBizException(e.getMessage());
                    }
                } else {
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                    task.set("planstarttime", (Object)planStartTime);
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absoluteduration.intValue() - 1));
                    task.set("planendtime", (Object)planEndTime);
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanEndTime2 = preTask.getDate("planendtime");
                if (preTaskPlanEndTime2 != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                            task.set("planstarttime", (Object)planStartTime);
                            try {
                                Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteduration.intValue() - 1));
                                task.set("planendtime", (Object)planEndTime);
                                break block29;
                            }
                            catch (KDBizException e) {
                                throw new KDBizException(e.getMessage());
                            }
                        }
                        catch (KDBizException e) {
                            throw new KDBizException(e.getMessage());
                        }
                    }
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                    task.set("planstarttime", (Object)planStartTime);
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absoluteduration.intValue() - 1));
                    task.set("planendtime", (Object)planEndTime);
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                            task.set("planendtime", (Object)planEndTime);
                            try {
                                Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteduration.intValue()));
                                task.set("planstarttime", (Object)planStartTime);
                                break block29;
                            }
                            catch (KDBizException e) {
                                throw new KDBizException(e.getMessage());
                            }
                        }
                        catch (KDBizException e) {
                            throw new KDBizException(e.getMessage());
                        }
                    }
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                    task.set("planendtime", (Object)planEndTime);
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absoluteduration.intValue() + 1));
                    task.set("planstarttime", (Object)planStartTime);
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && (preTaskPlanEndTime = preTask.getDate("planendtime")) != null) {
                if (project != null) {
                    try {
                        Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                        task.set("planendtime", (Object)planEndTime);
                        try {
                            Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteduration.intValue()));
                            task.set("planstarttime", (Object)planStartTime);
                            break block29;
                        }
                        catch (KDBizException e) {
                            throw new KDBizException(e.getMessage());
                        }
                    }
                    catch (KDBizException e) {
                        throw new KDBizException(e.getMessage());
                    }
                }
                Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                task.set("planendtime", (Object)planEndTime);
                Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absoluteduration.intValue() + 1));
                task.set("planstarttime", (Object)planStartTime);
            }
        }
        PlanTaskImpAndExpUtil.calCompTimeDeviation(task);
    }

    public static void calCompTimeDeviation(DynamicObject task) {
        Date aimFinishTime = task.getDate("aimfinishtime");
        Date planEndTime = task.getDate("planendtime");
        DynamicObject project = task.getDynamicObject("project");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planEndTime, (Date)aimFinishTime);
                task.set("comptimedeviation", (Object)days);
            }
            catch (KDBizException e) {
                int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
                task.set("comptimedeviation", (Object)days);
            }
        } else {
            int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
            task.set("comptimedeviation", (Object)days);
        }
    }

    private static void createTask(IFormView view, JSONArray jArray, List<DynamicObject> taskList, int seq) {
        DynamicObject task = new DynamicObject(TaskConstant.dt);
        ORM orm = ORM.create();
        Long taskId = orm.genLongId("pmpm_task");
        task.set("id", (Object)taskId);
        IDataModel model = view.getModel();
        DynamicObject project = (DynamicObject)model.getValue("project");
        task.set("project", (Object)project);
        task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
        task.set("taskseq", (Object)seq);
        task.set("enable", (Object)1);
        task.set("level", (Object)1);
        task.set("isleaf", (Object)Boolean.TRUE);
        DynamicObject majorType = (DynamicObject)model.getValue("majortype");
        task.set("belongplantype", (Object)majorType);
        String formId = view.getFormShowParameter().getFormId();
        String planId = model.getDataEntity().getPkValue().toString();
        JSONObject plansJsonObject = new JSONObject();
        if ("pmpm_projectplan".equals(formId)) {
            plansJsonObject.put("mainproplanid", (Object)planId);
        } else if ("pmpm_majorplan".equals(formId)) {
            plansJsonObject.put("majorproplanid", (Object)planId);
            task.set("majortype", (Object)majorType);
        }
        String plans = plansJsonObject.toString();
        task.set("plans", (Object)plans);
        boolean isSamePerson = false;
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        for (Object object : jArray) {
            DynamicObject indirectOrg;
            DynamicObject directPerson;
            QFilter numberFilter;
            QFilter nameFilter;
            Object nameFilter2;
            JSONObject jObject = JSONObject.parseObject((String)object.toString());
            String columnKey = jObject.getString("columnKey");
            Object columnName = jObject.get((Object)"columnName");
            Object cellValueObject = jObject.get((Object)"cellValue");
            if (cellValueObject == null || StringUtils.isEmpty((CharSequence)cellValueObject.toString())) continue;
            String cellValue = cellValueObject.toString();
            if (columnKey.equalsIgnoreCase("taskname")) {
                if (!PlanTaskImpAndExpUtil.isUniqueName(taskList, cellValue) || cellValue.length() > 80) continue;
                task.set("name", (Object)cellValue);
                continue;
            }
            if (columnKey.equalsIgnoreCase("controllevel")) {
                nameFilter2 = new QFilter("name", "=", (Object)cellValue);
                DynamicObject controlLevel = BusinessDataServiceHelper.loadSingleFromCache((String)"pmpm_controllevel", (String)"id", (QFilter[])new QFilter[]{nameFilter2, enableFilter});
                task.set("controllevel", (Object)controlLevel);
                continue;
            }
            if (columnKey.equalsIgnoreCase("spectype")) {
                DynamicObject projectKind;
                if ("pmpm_majorplan".equals(formId) || (projectKind = project.getDynamicObject("group")) == null) continue;
                nameFilter = new QFilter("name", "=", (Object)cellValue);
                QFilter projectKindFilter = new QFilter("group", "=", (Object)projectKind.getString("id"));
                DynamicObject majorTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"pmpm_majortype", (String)"id,name", (QFilter[])new QFilter[]{projectKindFilter, enableFilter, nameFilter});
                task.set("majortype", null);
                if (majorTypeObj == null) continue;
                task.set("majortype", (Object)majorTypeObj);
                continue;
            }
            if (columnKey.equalsIgnoreCase("tasktype")) {
                nameFilter2 = new QFilter("name", "=", (Object)cellValue);
                QFilter proFilter = new QFilter("checkboxisprojecttask", "=", (Object)"1");
                DynamicObject taskType = BusinessDataServiceHelper.loadSingleFromCache((String)"pmpm_tasktype", (String)"id,name", (QFilter[])new QFilter[]{enableFilter, nameFilter2, proFilter});
                if (taskType == null) continue;
                task.set("tasktype", (Object)taskType);
                continue;
            }
            if (columnKey.equalsIgnoreCase("achievementnode")) {
                if (DefaultEnum.YES.getName().equals(cellValue)) {
                    task.set("achievementnode", (Object)DefaultEnum.YES.getValue());
                    continue;
                }
                task.set("achievementnode", (Object)DefaultEnum.NO.getValue());
                continue;
            }
            if (columnKey.equalsIgnoreCase("pretask")) {
                task.set("pretask", (Object)cellValue);
                continue;
            }
            if (columnKey.equalsIgnoreCase("logical")) {
                if (cellValue.equalsIgnoreCase(LogicalEnum.START_START.getName())) {
                    task.set("logical", (Object)LogicalEnum.START_START.getValue());
                    continue;
                }
                if (cellValue.equalsIgnoreCase(LogicalEnum.START_FINISH.getName())) {
                    task.set("logical", (Object)LogicalEnum.START_FINISH.getValue());
                    continue;
                }
                if (cellValue.equalsIgnoreCase(LogicalEnum.FINISH_START.getName())) {
                    task.set("logical", (Object)LogicalEnum.FINISH_START.getValue());
                    continue;
                }
                if (!cellValue.equalsIgnoreCase(LogicalEnum.FINISH_FINISH.getName())) continue;
                task.set("logical", (Object)LogicalEnum.FINISH_FINISH.getValue());
                continue;
            }
            if (columnKey.equalsIgnoreCase("parent")) {
                for (DynamicObject parentTask : taskList) {
                    if (!cellValue.equals(parentTask.getString("name"))) continue;
                    parentTask.set("pretask", null);
                    parentTask.set("logical", null);
                    parentTask.set("relativeduration", null);
                    task.set("parent", (Object)parentTask);
                    BigDecimal level = parentTask.getBigDecimal("level").add(BigDecimal.ONE);
                    task.set("level", (Object)level);
                    parentTask.set("isleaf", (Object)Boolean.FALSE);
                }
                if (task.getDynamicObject("parent") != null) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u7684\u7236\u4efb\u52a1\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"PlanTaskImpAndExpUtil_26", (String)"pmgt-pmpm-common", (Object[])new Object[0]), seq + 1));
            }
            if (columnKey.equalsIgnoreCase("relativeschedule")) {
                task.set("relativeduration", (Object)new BigDecimal(cellValue));
                continue;
            }
            if (columnKey.equalsIgnoreCase("absoluteshedule")) {
                task.set("absoluteduration", (Object)new BigDecimal(cellValue));
                continue;
            }
            if (columnKey.equalsIgnoreCase("planbegindate")) {
                Date beginDate = null;
                try {
                    beginDate = new Date(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    throw new KDBizException(String.format("\u5217\u201c%s\u201d\u4e2d\u5b58\u5728\u683c\u5f0f\u4e0d\u6b63\u786e\u7684\u6570\u636e\u201c%s\u201d\u3002", columnName.toString().replace("*", ""), cellValue));
                }
                task.set("planstarttime", (Object)beginDate);
                continue;
            }
            if (columnKey.equalsIgnoreCase("planenddate")) {
                Date endDate = null;
                try {
                    endDate = new Date(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    throw new KDBizException(String.format("\u5217\u201c%s\u201d\u4e2d\u5b58\u5728\u683c\u5f0f\u4e0d\u6b63\u786e\u7684\u6570\u636e\u201c%s\u201d\u3002", columnName.toString().replace("*", ""), cellValue));
                }
                task.set("planendtime", (Object)endDate);
                continue;
            }
            if (columnKey.equalsIgnoreCase("aimfinishtime")) {
                Date aimFinishDate = null;
                try {
                    aimFinishDate = new Date(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    throw new KDBizException(String.format("\u5217\u201c%s\u201d\u4e2d\u5b58\u5728\u683c\u5f0f\u4e0d\u6b63\u786e\u7684\u6570\u636e\u201c%s\u201d\u3002", columnName.toString().replace("*", ""), cellValue));
                }
                task.set("aimfinishtime", (Object)aimFinishDate);
                continue;
            }
            if (columnKey.equalsIgnoreCase("directperson")) {
                numberFilter = new QFilter("number", "=", (Object)cellValue);
                directPerson = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{numberFilter, enableFilter});
                if (directPerson == null) continue;
                task.set("responsibleperson", (Object)directPerson);
                continue;
            }
            if (columnKey.equalsIgnoreCase("directorg")) {
                nameFilter2 = new QFilter("name", "=", (Object)cellValue);
                directPerson = task.getDynamicObject("responsibleperson");
                if (directPerson != null) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(directPerson.getPkValue().toString()), (boolean)false);
                    QFilter directPersonFilter = new QFilter("id", "in", (Object)deptIds);
                    Map directOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{directPersonFilter, enableFilter});
                    for (Map.Entry item : directOrgs.entrySet()) {
                        DynamicObject entry = (DynamicObject)item.getValue();
                        if (!cellValue.equals(entry.getString("name"))) continue;
                        task.set("responsibledept", (Object)entry);
                    }
                    continue;
                }
                DynamicObject directOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter2, enableFilter});
                if (directOrg == null) continue;
                task.set("responsibledept", (Object)directOrg);
                continue;
            }
            if (columnKey.equalsIgnoreCase("indirectperson")) {
                DynamicObject inDirectPerson;
                if (task.getDynamicObject("responsibleperson") != null && cellValue.equals(task.getDynamicObject("responsibleperson").getString("name"))) {
                    task.set("cooperationperson", null);
                }
                if ((inDirectPerson = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{numberFilter = new QFilter("number", "=", (Object)cellValue), enableFilter})) == null) continue;
                task.set("cooperationperson", (Object)inDirectPerson);
                continue;
            }
            if (!columnKey.equalsIgnoreCase("indirectorg")) continue;
            if (isSamePerson) {
                task.set("cooperationdept", null);
                continue;
            }
            DynamicObject inDirectPerson = task.getDynamicObject("cooperationperson");
            if (inDirectPerson != null) {
                List inDeptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(inDirectPerson.getPkValue().toString()), (boolean)false);
                QFilter inDirectPersonFilter = new QFilter("id", "in", (Object)inDeptIds);
                Map indirectOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{inDirectPersonFilter, enableFilter});
                for (Map.Entry item : indirectOrgs.entrySet()) {
                    DynamicObject entry = (DynamicObject)item.getValue();
                    if (!cellValue.equals(entry.getString("name"))) continue;
                    task.set("cooperationdept", (Object)entry);
                }
                continue;
            }
            if (!columnKey.equalsIgnoreCase("indirectorg") || (indirectOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter = new QFilter("name", "=", (Object)cellValue), enableFilter})) == null) continue;
            task.set("cooperationdept", (Object)indirectOrg);
        }
        taskList.add(task);
    }

    private static boolean isUniqueName(List<DynamicObject> taskList, String name) {
        for (DynamicObject task : taskList) {
            String taskName = task.getString("name");
            if (!name.equals(taskName)) continue;
            return false;
        }
        return true;
    }

    public static void cloneTaskToEntry(IFormView view, String level, ArrayList<String> taskIdList, List<DynamicObject> saveTaskList, Map<String, String> taskIdRelation) {
        IDataModel model = view.getModel();
        Date planStartDate = (Date)view.getFormShowParameter().getCustomParam("planstartdate");
        String formBillId = view.getFormShowParameter().getFormId();
        String billId = model.getDataEntity().getPkValue().toString();
        JSONObject jsonObject = new JSONObject();
        if ("pmpm_projectplan".equals(formBillId)) {
            jsonObject.put("mainproplanid", (Object)billId);
        } else if ("pmpm_majorplan".equals(formBillId)) {
            jsonObject.put("majorproplanid", (Object)billId);
        }
        if (taskIdList == null || taskIdList.isEmpty()) {
            return;
        }
        if (Integer.parseInt(level) == 1) {
            ORM orm = ORM.create();
            long[] newTakIds = orm.genLongIds("pmpm_task", taskIdList.size());
            int idIndex = 0;
            for (String oldTaskId : taskIdList) {
                int index = model.createNewEntryRow("taskentity");
                DynamicObject oldTask = BusinessDataServiceHelper.loadSingle((Object)oldTaskId, (String)"pmpm_task");
                DynamicObject newTask = (DynamicObject)OrmUtils.clone((Object)oldTask, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                TaskCloneUtil.cloneTask((DynamicObject)newTask, (DynamicObject)oldTask);
                newTask.set("id", (Object)newTakIds[idIndex]);
                newTask.set("status", (Object)"A");
                newTask.set("responsibleperson", null);
                newTask.set("responsibledept", null);
                newTask.set("cooperationperson", null);
                newTask.set("cooperationdept", null);
                newTask.set("prechangetask", null);
                newTask.set("realendtime", null);
                newTask.set("planstarttime", (Object)planStartDate);
                newTask.set("sourcetask", (Object)0);
                newTask.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                newTask.set("percent", (Object)0);
                newTask.set("plans", (Object)jsonObject.toString());
                newTask.set("parent", null);
                newTask.set("level", (Object)1);
                newTask.set("isleaf", (Object)Boolean.TRUE);
                DynamicObject project = (DynamicObject)model.getValue("project");
                newTask.set("project", (Object)project);
                taskIdRelation.put(oldTaskId, String.valueOf(newTakIds[idIndex]));
                model.setValue("taskid", (Object)newTakIds[idIndex], index);
                saveTaskList.add(newTask);
                ++idIndex;
            }
        } else {
            ORM orm = ORM.create();
            long[] newTakIds = orm.genLongIds("pmpm_task", taskIdList.size());
            int idIndex = 0;
            for (String oldTaskId : taskIdList) {
                int index;
                DynamicObject oldTask = BusinessDataServiceHelper.loadSingle((Object)oldTaskId, (String)"pmpm_task");
                DynamicObject oldParent = oldTask.getDynamicObject("parent");
                String oldParentId = oldParent.getString("id");
                int parentIndex = PlanTaskImpAndExpUtil.findNewTaskIndex(view, oldParentId, taskIdRelation);
                if (parentIndex != -1) {
                    index = model.insertEntryRow("taskentity", parentIndex);
                    TreeEntryGrid grid = (TreeEntryGrid)view.getControl("taskEntity");
                    grid.expand(parentIndex);
                    DynamicObject newTask = (DynamicObject)OrmUtils.clone((Object)oldTask, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                    TaskCloneUtil.cloneTask((DynamicObject)newTask, (DynamicObject)oldTask);
                    newTask.set("id", (Object)newTakIds[idIndex]);
                    newTask.set("status", (Object)"A");
                    newTask.set("responsibleperson", null);
                    newTask.set("responsibledept", null);
                    newTask.set("cooperationperson", null);
                    newTask.set("cooperationdept", null);
                    newTask.set("prechangetask", null);
                    newTask.set("realendtime", null);
                    newTask.set("planstarttime", (Object)planStartDate);
                    newTask.set("sourcetask", (Object)0);
                    newTask.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                    newTask.set("percent", (Object)0);
                    newTask.set("level", (Object)level);
                    newTask.set("plans", (Object)jsonObject.toString());
                    DynamicObject project = (DynamicObject)model.getValue("project");
                    newTask.set("project", (Object)project);
                    taskIdRelation.put(oldTaskId, String.valueOf(newTakIds[idIndex]));
                    String newParetId = (String)model.getValue("taskid", parentIndex);
                    for (DynamicObject parent : saveTaskList) {
                        if (!newParetId.equals(parent.getString("id"))) continue;
                        newTask.set("parent", (Object)parent);
                        parent.set("isleaf", (Object)Boolean.FALSE);
                    }
                    model.setValue("taskid", (Object)newTakIds[idIndex], index);
                    saveTaskList.add(newTask);
                    ++idIndex;
                    continue;
                }
                if (!"pmpm_majorplan".equals(formBillId)) continue;
                index = model.createNewEntryRow("taskentity");
                oldTask = BusinessDataServiceHelper.loadSingle((Object)oldTaskId, (String)"pmpm_task");
                DynamicObject newTask = (DynamicObject)OrmUtils.clone((Object)oldTask, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                TaskCloneUtil.cloneTask((DynamicObject)newTask, (DynamicObject)oldTask);
                newTask.set("id", (Object)newTakIds[idIndex]);
                newTask.set("status", (Object)"A");
                newTask.set("responsibleperson", null);
                newTask.set("responsibledept", null);
                newTask.set("cooperationperson", null);
                newTask.set("cooperationdept", null);
                newTask.set("parent", null);
                newTask.set("level", (Object)1);
                newTask.set("isleaf", (Object)Boolean.TRUE);
                newTask.set("sourcetask", (Object)0);
                newTask.set("realendtime", null);
                newTask.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                newTask.set("percent", (Object)0);
                newTask.set("plans", (Object)jsonObject.toString());
                DynamicObject project = (DynamicObject)model.getValue("project");
                newTask.set("project", (Object)project);
                taskIdRelation.put(oldTaskId, String.valueOf(newTakIds[idIndex]));
                model.setValue("taskid", (Object)newTakIds[idIndex], index);
                saveTaskList.add(newTask);
                ++idIndex;
            }
        }
    }

    private static int findNewTaskIndex(IFormView view, String oldTaskId, Map<String, String> taskIdRelation) {
        IDataModel model = view.getModel();
        int rowCount = model.getEntryRowCount("taskentity");
        String newTaskId = taskIdRelation.get(oldTaskId);
        for (int i = 0; i < rowCount; ++i) {
            String rowTaskId = (String)model.getValue("taskid", i);
            if (!newTaskId.equals(rowTaskId)) continue;
            return i;
        }
        return -1;
    }

    public static void setPretask(IFormView view, List<DynamicObject> saveTaskList, Map<String, String> taskIdRelation) {
        IDataModel model = view.getModel();
        for (DynamicObject task : saveTaskList) {
            Optional<DynamicObject> optional;
            DynamicObject oldPreTask = task.getDynamicObject("pretask");
            if (oldPreTask == null) continue;
            String oldPreTaskId = oldPreTask.getString("id");
            if (taskIdRelation.get(oldPreTaskId) == null) {
                task.set("pretask", null);
                task.set("logical", null);
                task.set("relativeduration", null);
                continue;
            }
            int newPreTaskIndex = PlanTaskImpAndExpUtil.findNewTaskIndex(view, oldPreTaskId, taskIdRelation);
            String newPreTaskId = (String)model.getValue("taskid", newPreTaskIndex);
            List pretasks = saveTaskList.stream().filter(obj -> newPreTaskId.equals(obj.getString("id"))).collect(Collectors.toList());
            if (pretasks.size() <= 0 || !(optional = saveTaskList.stream().filter(obj -> newPreTaskId.equals(obj.getString("id"))).findFirst()).isPresent()) continue;
            DynamicObject newPreTask = optional.get();
            task.set("pretask", (Object)newPreTask);
            PlanTaskImpAndExpUtil.calulatePreTaskTime(task, newPreTask);
        }
    }

    public static void loadSameLevelTask(IFormView view, List<DynamicObject> taskList, List<DynamicObject> sameLevelTaskList, int curLevel) {
        IDataModel model = view.getModel();
        if (curLevel == 1) {
            for (DynamicObject task : sameLevelTaskList) {
                String taskId = task.getString("id");
                int index = model.createNewEntryRow("taskentity");
                model.setValue("taskid", (Object)taskId, index);
                model.updateCache();
            }
        } else {
            Collections.sort(sameLevelTaskList, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject task1, DynamicObject task2) {
                    return task1.getBigDecimal("taskseq").compareTo(task2.getBigDecimal("taskseq"));
                }
            });
            block1: for (DynamicObject task : sameLevelTaskList) {
                String parentId = task.getDynamicObject("parent").getString("id");
                int rowCount = model.getEntryRowCount("taskentity");
                for (int i = 0; i < rowCount; ++i) {
                    String rowtaskId = (String)model.getValue("taskid", i);
                    if (!parentId.equals(rowtaskId)) continue;
                    int parentIndex = i;
                    int index = model.insertEntryRow("taskentity", parentIndex);
                    String taskId = task.getString("id");
                    model.setValue("taskid", (Object)taskId, index);
                    model.updateCache();
                    continue block1;
                }
            }
        }
        TreeEntryGrid grid = (TreeEntryGrid)view.getControl("taskEntity");
        int rowCount = model.getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)model.getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            boolean isLeaf = task.getBoolean("isleaf");
            if (!isLeaf) {
                grid.expand(i);
            }
            PlanEntryUtil.setRowTaskObjForImp(view, model, task, i);
        }
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor(view, model);
    }

    public static void createTaskJsonObject(DynamicObject task, JSONObject jsonObject) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        jsonObject.put("taskname", (Object)task.getString("name"));
        jsonObject.put("controllevel", task.getDynamicObject("controllevel") == null ? task.getDynamicObject("controllevel") : task.getDynamicObject("controllevel").getString("name"));
        jsonObject.put("spectype", task.getDynamicObject("majortype") == null ? task.getDynamicObject("majortype") : task.getDynamicObject("majortype").getString("name"));
        jsonObject.put("tasktype", task.getDynamicObject("tasktype") == null ? task.getDynamicObject("tasktype") : task.getDynamicObject("tasktype").getString("name"));
        jsonObject.put("achievementnode", (Object)(task.getBoolean("achievementnode") ? ResManager.loadKDString((String)"\u662f", (String)"PlanTaskImpAndExpUtil_25", (String)"pmgt-pmpm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PlanTaskImpAndExpUtil_29", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        jsonObject.put("pretask", task.getDynamicObject("pretask") == null ? task.getDynamicObject("pretask") : task.getDynamicObject("pretask").getString("name"));
        jsonObject.put("logical", (Object)task.getString("logical"));
        jsonObject.put("parent", task.getDynamicObject("parent") == null ? task.getDynamicObject("parent") : task.getDynamicObject("parent").getString("name"));
        jsonObject.put("relativeschedule", (Object)task.getBigDecimal("relativeduration"));
        jsonObject.put("absoluteshedule", (Object)task.getBigDecimal("absoluteduration"));
        jsonObject.put("planbegindate", task.getDate("planstarttime") == null ? null : simpleDateFormat.format(task.getDate("planstarttime")));
        jsonObject.put("planenddate", task.getDate("planendtime") == null ? null : simpleDateFormat.format(task.getDate("planendtime")));
        jsonObject.put("aimfinishtime", task.getDate("aimfinishtime") == null ? null : simpleDateFormat.format(task.getDate("aimfinishtime")));
        jsonObject.put("directperson", task.getDynamicObject("responsibleperson") == null ? task.getDynamicObject("responsibleperson") : task.getDynamicObject("responsibleperson").getString("number"));
        jsonObject.put("directperson.name", task.getDynamicObject("responsibleperson") == null ? task.getDynamicObject("responsibleperson") : task.getDynamicObject("responsibleperson").getString("name"));
        jsonObject.put("directorg", task.getDynamicObject("responsibledept") == null ? task.getDynamicObject("responsibledept") : task.getDynamicObject("responsibledept").getString("name"));
        jsonObject.put("indirectperson", task.getDynamicObject("cooperationperson") == null ? task.getDynamicObject("cooperationperson") : task.getDynamicObject("cooperationperson").getString("number"));
        jsonObject.put("indirectperson.name", task.getDynamicObject("cooperationperson") == null ? task.getDynamicObject("cooperationperson") : task.getDynamicObject("cooperationperson").getString("name"));
        jsonObject.put("indirectorg", task.getDynamicObject("cooperationdept") == null ? task.getDynamicObject("cooperationdept") : task.getDynamicObject("cooperationdept").getString("name"));
    }

    public static void setEnableByLogical(IFormView view) {
        IDataModel model = view.getModel();
        int rowCount = model.getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            Object pretask = model.getValue("pretask", i);
            String logical = (String)model.getValue("logical", i);
            if (pretask == null || logical == null) continue;
            if ("SS".equals(logical) || "FS".equals(logical)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"planbegindate"});
                continue;
            }
            if (!"SF".equals(logical) && !"FF".equals(logical)) continue;
            view.setEnable(Boolean.FALSE, i, new String[]{"planenddate"});
        }
    }
}

