/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;

public class PlanTaskPOIHelper {
    private static final Log logger = LogFactory.getLog(PlanTaskPOIHelper.class);

    public static String newOutPutExcel(String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, JSONArray data) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        columnKeyHashCell.setCellValue(POIHelper.stringArrayToHash((String[])columnKey));
        HSSFRow columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        HSSFRow nameRow = sheet.createRow(2);
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("taskname", 3, 4, 0, 0, ResManager.loadKDString((String)"\u6587\u672c", (String)"PlanTaskPOIHelper_0", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("controllevel", 3, 4, 1, 3, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskPOIHelper_1", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("achievementnode", 3, 10, 4, 4, null));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("pretask", 3, 4, 5, 5, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskPOIHelper_2", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        LogicalEnum.values();
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("logical", 3, 10, 6, 6, null));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("parent", 3, 4, 7, 7, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskPOIHelper_2", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("relativeschedule", 3, 4, 8, 9, ResManager.loadKDString((String)"\u6570\u5b57", (String)"PlanTaskPOIHelper_3", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("planbegindate", 3, 4, 10, 12, ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1ayyyy/MM/dd", (String)"PlanTaskPOIHelper_4", (String)"pmgt-pmpm-common", (Object[])new Object[0])));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("directperson", 3, 4, 13, 13, "\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u5458\u5de5\u5de5\u53f7\u3002"));
        sheet.addValidationData((DataValidation)PlanTaskPOIHelper.setTip("indirectperson", 3, 4, 16, 16, "\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u5458\u5de5\u5de5\u53f7\u3002"));
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell columnKeyCell = null;
        Cell nameCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            if (mustFillColumn != null && mustFillColumn.contains(header[i])) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue(header[i] + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
                continue;
            }
            nameCell.setCellValue(header[i]);
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle css = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        sheet.setDefaultColumnStyle(10, (CellStyle)css);
        sheet.setDefaultColumnStyle(11, (CellStyle)css);
        sheet.setDefaultColumnStyle(12, (CellStyle)css);
        sheet.setDefaultColumnStyle(13, (CellStyle)css);
        sheet.setDefaultColumnStyle(16, (CellStyle)css);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                nameRow = sheet.createRow(i + 3);
                for (int j = 0; j < columnKey.length; ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return url;
    }

    public static HSSFDataValidation setTip(String key, int firstRow, int lastRow, int firstCol, int lastCol, String tip) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint dvConstraint = null;
        switch (key) {
            case "achievementnode": {
                String[] DATA_LIST = new String[]{DefaultEnum.YES.getName(), DefaultEnum.NO.getName()};
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])DATA_LIST);
                break;
            }
            case "logical": {
                String[] DATA_LIST1 = new String[]{LogicalEnum.START_START.getName(), LogicalEnum.START_FINISH.getName(), LogicalEnum.FINISH_START.getName(), LogicalEnum.FINISH_FINISH.getName()};
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])DATA_LIST1);
                break;
            }
            default: {
                dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
            }
        }
        HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"PlanTaskPOIHelper_5", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f60\u8f93\u5165\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlanTaskPOIHelper_6", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
        dataValidation.setSuppressDropDownArrow(false);
        if (tip != null) {
            dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"PlanTaskPOIHelper_7", (String)"pmgt-pmpm-common", (Object[])new Object[0]), tip);
        }
        dataValidation.setShowPromptBox(true);
        return dataValidation;
    }

    public static Set<String> getHeadByExcel(String url) {
        HashSet<String> reurnArray = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(url);
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                HSSFRow columnKeyRow = sheet.getRow(0);
                int columnNum = columnKeyRow.getLastCellNum();
                for (int i = 0; i < columnNum; ++i) {
                    columnKeyRow.getCell(i).setCellType(CellType.STRING);
                    String headkey = columnKeyRow.getCell(i).getStringCellValue();
                    if ("".equals(columnKeyRow.getCell(i).getStringCellValue())) continue;
                    reurnArray.add(headkey);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return reurnArray;
    }

    public static JSONArray newInputExcelForTask(String url, String coulmnHashCode) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                HSSFRow columnKeyRow = sheet.getRow(1);
                HSSFRow headerRow = sheet.getRow(2);
                HSSFRow columnKeyHashRow = sheet.getRow(0);
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)coulmnHashCode)) {
                    return jsonArray;
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    HSSFRow iRow = sheet.getRow(j);
                    if (iRow == null) continue;
                    for (int i = 0; i < columnNum; ++i) {
                        JSONObject jsonObject = new JSONObject();
                        HSSFCell columnKeyRowCell = columnKeyRow.getCell(i);
                        HSSFCell headRowCell = headerRow.getCell(i);
                        columnKeyRowCell.setCellType(CellType.STRING);
                        headRowCell.setCellType(CellType.STRING);
                        jsonObject.put("columnKey", (Object)columnKeyRowCell.getStringCellValue());
                        jsonObject.put("columnName", (Object)headRowCell.getStringCellValue());
                        HSSFCell cell = iRow.getCell(i);
                        if (cell != null) {
                            if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                                cell.setCellType(CellType.NUMERIC);
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    jsonObject.put("cellValue", (Object)cell.getDateCellValue());
                                } else {
                                    jsonObject.put("cellValue", (Object)cell.getNumericCellValue());
                                }
                            } else {
                                cell.setCellType(CellType.STRING);
                                jsonObject.put("cellValue", (Object)cell.getStringCellValue());
                            }
                        } else {
                            jsonObject.put("cellValue", null);
                        }
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return jsonArray;
    }
}

