/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;

public class PlanTplUtil {
    private static final Log logger = LogFactory.getLog(PlanTplUtil.class);

    private PlanTplUtil() {
    }

    public static List<DynamicObject> generateTaskListByPlanTpl(Object planTplPk, IFormView formView) {
        IDataModel dataModel = formView.getModel();
        DynamicObject projecPlan = dataModel.getDataEntity();
        DynamicObject project = projecPlan.getDynamicObject("project");
        DynamicObject majorType = projecPlan.getDynamicObject("majortype");
        MainEntityType planTplDt = EntityMetadataCache.getDataEntityType((String)"pmpm_plantemplate");
        DynamicObject planTpl = BusinessDataServiceHelper.loadSingle((Object)planTplPk, (DynamicObjectType)planTplDt);
        DynamicObjectCollection planTplTaskListCol = planTpl.getDynamicObjectCollection("taskentry");
        MainEntityType taskDt = EntityMetadataCache.getDataEntityType((String)"pmpm_task");
        ArrayList<DynamicObject> saveTaskList = new ArrayList<DynamicObject>(10);
        HashMap<Object, DynamicObject> tplTaskIdMap = new HashMap<Object, DynamicObject>(16);
        if (!planTplTaskListCol.isEmpty()) {
            JSONObject plansJsonObject = null;
            ORM orm = ORM.create();
            long[] taskIds = orm.genLongIds("pmpm_task", planTplTaskListCol.size());
            int idIndex = 0;
            for (DynamicObject planTplTask : planTplTaskListCol) {
                String associatePersonId;
                Object associatePostId;
                boolean disAble = planTplTask.getBoolean("disable");
                if (disAble) continue;
                DynamicObject newTask = new DynamicObject((DynamicObjectType)taskDt);
                Boolean achievementNode = planTplTask.getBoolean("achievementnode");
                newTask.set("id", (Object)taskIds[idIndex++]);
                newTask.set("project", (Object)project);
                newTask.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                newTask.set("taskseq", planTplTask.get("seq"));
                newTask.set("belongplantype", (Object)majorType);
                newTask.set("name", planTplTask.get("taskname"));
                newTask.set("isleaf", planTplTask.get("isleaf"));
                DynamicObject parentTask = (DynamicObject)tplTaskIdMap.get(planTplTask.get("pid"));
                newTask.set("parent", (Object)parentTask);
                newTask.set("level", (Object)(parentTask == null ? 1 : parentTask.getInt("level") + 1));
                newTask.set("pretask", planTplTask.get("pretask"));
                newTask.set("logical", planTplTask.get("logical"));
                newTask.set("controllevel", planTplTask.get("controllevel_id"));
                newTask.set("tasktype", planTplTask.get("tasktype_id"));
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                Object responsiblePostId = planTplTask.get("responsiblepost_id");
                QFilter roleFilter = new QFilter("role", "=", responsiblePostId);
                DynamicObject[] nowTeamPeopleArr = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"project,role,member", (QFilter[])new QFilter[]{projectFilter, roleFilter});
                Object responsiblePersonId = 0;
                if (nowTeamPeopleArr.length == 1) {
                    responsiblePersonId = nowTeamPeopleArr[0].get("member_id");
                    newTask.set("responsibleperson", responsiblePersonId);
                    long responsibleDept = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePersonId.toString()));
                    newTask.set("responsibledept", (Object)responsibleDept);
                }
                if ((nowTeamPeopleArr = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"project,role,member", (QFilter[])new QFilter[]{projectFilter, roleFilter = new QFilter("role", "=", associatePostId = planTplTask.get("associatepost_id"))})).length == 1 && !StringUtils.equals((CharSequence)(associatePersonId = nowTeamPeopleArr[0].get("member_id").toString()), (CharSequence)responsiblePersonId.toString())) {
                    newTask.set("cooperationperson", (Object)associatePersonId);
                    long associateDept = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(associatePersonId));
                    newTask.set("cooperationdept", (Object)associateDept);
                }
                newTask.set("absoluteduration", planTplTask.get("absoluteduration"));
                newTask.set("relativeduration", planTplTask.get("relativeduration"));
                String formId = formView.getEntityId();
                String planId = projecPlan.getPkValue().toString();
                plansJsonObject = new JSONObject();
                if ("pmpm_projectplan".equals(formId)) {
                    plansJsonObject.put("mainproplanid", (Object)planId);
                    newTask.set("majortype", planTplTask.get("spectype_id"));
                } else if ("pmpm_majorplan".equals(formId)) {
                    plansJsonObject.put("majorproplanid", (Object)planId);
                    newTask.set("majortype", (Object)majorType);
                }
                newTask.set("plans", (Object)plansJsonObject.toString());
                newTask.set("achievementnode", (Object)"0");
                if (achievementNode.booleanValue()) {
                    newTask.set("achievementnode", (Object)"1");
                    DynamicObjectCollection taskResultDocEntryCol = newTask.getDynamicObjectCollection("taskresultdocentry");
                    DynamicObjectType taskResultDocDT = taskResultDocEntryCol.getDynamicObjectType();
                    DynamicObjectCollection planTplTaskResultDocEntryCol = planTplTask.getDynamicObjectCollection("taskresultdocdetail");
                    int seq = 1;
                    for (DynamicObject planTplTaskResultDocEntry : planTplTaskResultDocEntryCol) {
                        DynamicObject newTaskResultDoc = new DynamicObject(taskResultDocDT);
                        newTaskResultDoc.set("seq", (Object)seq++);
                        newTaskResultDoc.set("resultname", planTplTaskResultDocEntry.get("resultname"));
                        newTaskResultDoc.set("force", planTplTaskResultDocEntry.get("force"));
                        newTaskResultDoc.set("frequency", planTplTaskResultDocEntry.get("frequency"));
                        newTaskResultDoc.set("resultdescription", planTplTaskResultDocEntry.get("resultdescription"));
                        taskResultDocEntryCol.add((Object)newTaskResultDoc);
                    }
                }
                DynamicObjectCollection referDocEntryCol = newTask.getDynamicObjectCollection("taskreferdocentry");
                DynamicObjectType referDocEntryDT = referDocEntryCol.getDynamicObjectType();
                DynamicObjectCollection relevantDocCol = planTplTask.getDynamicObjectCollection("relevantdoc");
                for (DynamicObject relevantDoc : relevantDocCol) {
                    DynamicObject newReferDocEntry = new DynamicObject(referDocEntryDT);
                    DynamicObjectCollection referDocCol = newReferDocEntry.getDynamicObjectCollection("attachmentfield");
                    DynamicObjectType referDocDT = referDocCol.getDynamicObjectType();
                    DynamicObject newReferDoc = new DynamicObject(referDocDT);
                    DynamicObject relevantFile = relevantDoc.getDynamicObject("fbasedataid");
                    newReferDoc.set("fbasedataid", (Object)relevantFile);
                    String docxName = relevantFile.getString("name");
                    String description = relevantFile.getString("description");
                    newReferDocEntry.set("referdocname", (Object)docxName);
                    newReferDocEntry.set("description", (Object)description);
                    referDocCol.add((Object)newReferDoc);
                    newReferDocEntry.set("attachmentfield", (Object)referDocCol);
                    referDocEntryCol.add((Object)newReferDocEntry);
                }
                saveTaskList.add(newTask);
                tplTaskIdMap.put(planTplTask.getPkValue(), newTask);
            }
        }
        PlanTplUtil.setPreTask(saveTaskList);
        return saveTaskList;
    }

    private static void setPreTask(List<DynamicObject> taskList) {
        HashMap<String, DynamicObject> taskNameMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject task : taskList) {
            taskNameMap.put(task.getString("name"), task);
        }
        for (DynamicObject task : taskList) {
            if (task.get("pretask") == null) continue;
            task.set("pretask", taskNameMap.get(task.getString("pretask")));
        }
    }

    public static void getAfterTaskIdSet(List<DynamicObject> taskList, Set<Object> idSet, DynamicObject currentTask) {
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            Long preTaskId = task.getLong("pretaskid");
            if (preTaskId == 0L || !currentTask.getPkValue().equals(preTaskId)) continue;
            idSet.add(task.getPkValue());
            if (task.get("pid") != null) {
                PlanTplUtil.getParentIdSet(taskList, idSet, task);
            }
            PlanTplUtil.getAfterTaskIdSet(taskList, idSet, task);
        }
    }

    public static void getParentIdSet(List<DynamicObject> taskList, Set<Object> idSet, DynamicObject currentTask) {
        Object parentTaskId = currentTask.get("pid");
        if (parentTaskId == null) {
            return;
        }
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            if (!parentTaskId.equals(task.getPkValue())) continue;
            idSet.add(task.getPkValue());
            PlanTplUtil.getAfterTaskIdSet(taskList, idSet, task);
            if (task.get("pid") == null) continue;
            PlanTplUtil.getParentIdSet(taskList, idSet, task);
        }
    }

    public static String outPutExcel(Object proKindId, String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, JSONArray data) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        columnKeyHashCell.setCellValue(POIHelper.stringArrayToHash((String[])columnKey));
        HSSFRow columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        HSSFRow nameRow = sheet.createRow(2);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObject[] controlLevelArr = BusinessDataServiceHelper.load((String)"pmpm_controllevel", (String)"name", (QFilter[])new QFilter[]{enableFilter});
        List<String> clNameList = Arrays.stream(controlLevelArr).map(cl -> cl.getString("name")).collect(Collectors.toList());
        QFilter isProjectTaskFilter = new QFilter("checkboxisprojecttask", "=", (Object)"1");
        DynamicObject[] taskTypeArr = BusinessDataServiceHelper.load((String)"pmpm_tasktype", (String)"name", (QFilter[])new QFilter[]{enableFilter, isProjectTaskFilter});
        List<String> taskTypeNameList = Arrays.stream(taskTypeArr).map(tt -> tt.getString("name")).collect(Collectors.toList());
        QFilter kindFilter = new QFilter("group", "=", proKindId);
        DynamicObject[] majorTypeArr = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"name", (QFilter[])new QFilter[]{enableFilter, kindFilter});
        List<String> majorTypeNameList = Arrays.stream(majorTypeArr).map(mt -> mt.getString("name")).collect(Collectors.toList());
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 4, 0, 0, ResManager.loadKDString((String)"\u6587\u672c", (String)"PlanTplUtil_0", (String)"pmgt-pmpm-common", (Object[])new Object[0]), null, 0));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 1, 1, null, clNameList.toArray(new String[clNameList.size()]), 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 2, 2, null, majorTypeNameList.toArray(new String[majorTypeNameList.size()]), 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 3, 3, null, taskTypeNameList.toArray(new String[taskTypeNameList.size()]), 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 4, 4, ResManager.loadKDString((String)"\u6570\u5b57", (String)"PlanTplUtil_1", (String)"pmgt-pmpm-common", (Object[])new Object[0]), null, 1));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 5, 5, null, new String[]{DefaultEnum.YES.getName(), DefaultEnum.NO.getName()}, 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 4, 6, 6, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTplUtil_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]), null, 0));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 7, 7, null, new String[]{LogicalEnum.START_START.getName(), LogicalEnum.START_FINISH.getName(), LogicalEnum.FINISH_START.getName(), LogicalEnum.FINISH_FINISH.getName()}, 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 4, 8, 8, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTplUtil_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]), null, 0));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 9, 9, ResManager.loadKDString((String)"\u6570\u5b57", (String)"PlanTplUtil_1", (String)"pmgt-pmpm-common", (Object[])new Object[0]), null, 1));
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell columnKeyCell = null;
        Cell nameCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            if (mustFillColumn != null && mustFillColumn.contains(header[i])) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue(header[i] + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
                continue;
            }
            nameCell.setCellValue(header[i]);
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle css = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        sheet.setDefaultColumnStyle(10, (CellStyle)css);
        sheet.setDefaultColumnStyle(11, (CellStyle)css);
        sheet.setDefaultColumnStyle(12, (CellStyle)css);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                nameRow = sheet.createRow(i + 3);
                for (int j = 0; j < columnKey.length; ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return url;
    }

    public static HSSFDataValidation getDataValidation(int firstRow, int lastRow, int firstCol, int lastCol, String tip, String[] dvConstraintArr, int type) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint dvConstraint = null;
        switch (type) {
            case 1: {
                dvConstraint = DVConstraint.createNumericConstraint((int)1, (int)0, (String)"0", (String)"10000");
                break;
            }
            case 7: {
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dvConstraintArr);
                break;
            }
            default: {
                dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
            }
        }
        HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"PlanTplUtil_3", (String)"pmgt-pmpm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f60\u8f93\u5165\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlanTplUtil_4", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
        dataValidation.setSuppressDropDownArrow(false);
        if (tip != null) {
            dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"PlanTplUtil_5", (String)"pmgt-pmpm-common", (Object[])new Object[0]), tip);
        }
        dataValidation.setShowPromptBox(true);
        return dataValidation;
    }
}

