/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.common.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TreeEntryUtils {
    private TreeEntryUtils() {
    }

    public static void upgradeRow(IFormView view, IDataModel model, int[] selRows, String yemianbiaoshi) {
        String curTaskId;
        int i;
        String parentTaskId;
        if (selRows.length <= 0) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c", (String)"TreeEntryUtils_0", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return;
        }
        int beginSeq = model.getEntryCurrentRowIndex("taskentity");
        int level = (Integer)model.getValue("level", beginSeq);
        if (level == 1) {
            view.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u662f\u6839\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"TreeEntryUtils_1", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return;
        }
        DynamicObject insertTaskObj = model.getEntryRowEntity("taskentity", beginSeq);
        int endSeq = TreeEntryUtils.findLastChildIndex(beginSeq, model);
        DynamicObject curParentTaskObj = (DynamicObject)model.getValue("parent", beginSeq);
        String string = parentTaskId = curParentTaskObj == null ? "" : curParentTaskObj.getString("id");
        if (StringUtils.equalsIgnoreCase((CharSequence)yemianbiaoshi, (CharSequence)"pmpm_deptplan")) {
            int parentTaskIndexDept = -1;
            for (i = beginSeq - 1; i >= 0; --i) {
                curTaskId = (String)model.getValue("taskid", i);
                if (!curTaskId.equals(parentTaskId)) continue;
                parentTaskIndexDept = i;
                break;
            }
            if (parentTaskIndexDept != -1 && StringUtils.equalsIgnoreCase((CharSequence)yemianbiaoshi, (CharSequence)"pmpm_deptplan")) {
                boolean isImport = (Boolean)model.getValue("isimport", parentTaskIndexDept);
                DynamicObject task = insertTaskObj.getDynamicObject("taskname");
                DynamicObject plantype = task.getDynamicObject("belongplantype");
                if (isImport && null != plantype && StringUtils.equalsIgnoreCase((CharSequence)plantype.getPkValue().toString(), (CharSequence)"697516877831783424")) {
                    view.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u89e3\u4efb\u52a1\u7684\u7236\u7ea7\u662f\u5f15\u5165\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"TreeEntryUtils_2", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
                    return;
                }
            }
        }
        int parentTaskIndex = -1;
        for (i = beginSeq - 1; i >= 0; --i) {
            curTaskId = (String)model.getValue("taskid", i);
            if (!curTaskId.equals(parentTaskId)) continue;
            parentTaskIndex = i;
            DynamicObject parent = (DynamicObject)model.getValue("parent", i);
            model.setValue("parent", (Object)parent, beginSeq);
            break;
        }
        insertTaskObj.set("level", (Object)(insertTaskObj.getInt("level") - 1));
        ArrayList<DynamicObject> rowObjList = new ArrayList<DynamicObject>(endSeq);
        for (int i2 = endSeq; i2 >= beginSeq + 1; --i2) {
            rowObjList.add(model.getEntryRowEntity("taskentity", i2));
            model.deleteEntryRow("taskentity", i2);
            model.updateCache();
        }
        model.deleteEntryRow("taskentity", beginSeq);
        model.updateCache();
        int[] insertIndexArr = model.appendEntryRow("taskentity", parentTaskIndex, 1);
        model.updateCache();
        TreeEntryUtils.setRowObj(insertTaskObj, insertIndexArr[0], view, yemianbiaoshi);
        TreeEntryUtils.insertRowObjToEntry(rowObjList, "upgrade", view, yemianbiaoshi);
        TreeEntryGrid grid = (TreeEntryGrid)view.getControl("taskentity");
        grid.focus(parentTaskIndex, insertIndexArr[0]);
        view.getModel().setEntryCurrentRowIndex("taskentity", insertIndexArr[0]);
        grid.selectRows(insertIndexArr[0]);
        int lastIndex = TreeEntryUtils.findLastChildIndex(parentTaskIndex, model);
        if (parentTaskIndex == lastIndex) {
            model.setValue("isleaf", (Object)Boolean.TRUE, lastIndex);
            model.getEntryRowEntity("taskentity", lastIndex).set("isGroupNode", (Object)Boolean.FALSE);
        }
        model.updateCache();
    }

    public static void downgradeRow(IFormView view, IDataModel model, int[] selRows, String yemianbiaoshi) {
        String curTaskId;
        int i;
        if (selRows.length <= 0) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c", (String)"TreeEntryUtils_0", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return;
        }
        int beginSeq = model.getEntryCurrentRowIndex("taskentity");
        boolean isFirstNode = TreeEntryUtils.checkFirstNode(beginSeq, view, model);
        if (isFirstNode) {
            return;
        }
        int endSeq = TreeEntryUtils.findLastChildIndex(beginSeq, model);
        DynamicObject curParentTask = model.getEntryRowEntity("taskentity", beginSeq).getDynamicObject("parent");
        String parentTaskId = curParentTask == null ? "" : curParentTask.getString("id");
        DynamicObject parentTask = TreeEntryUtils.findLastSameParentTask(beginSeq, parentTaskId, model);
        String formId = view.getFormShowParameter().getFormId();
        if ("pmpm_majorplan".equals(formId)) {
            parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getString("id"), (String)"pmpm_task");
            DynamicObject belongPlanType = parentTask.getDynamicObject("belongplantype");
            boolean isleaf = parentTask.getBoolean("isleaf");
            if (!isleaf && "1".equals(belongPlanType.getString("plantype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u964d\u7ea7\u7684\u4e0a\u7ea7\u8282\u70b9\u662f\u975e\u660e\u7ec6\u4e3b\u9879\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TreeEntryUtils_3", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)yemianbiaoshi, (CharSequence)"pmpm_deptplan")) {
            boolean isImport;
            int parentIndexDept = 0;
            for (i = beginSeq - 1; i >= 0; --i) {
                curTaskId = (String)model.getValue("taskid", i);
                if (!curTaskId.equals(parentTask.getString("id"))) continue;
                parentIndexDept = i;
            }
            if (parentIndexDept >= 0 && (isImport = ((Boolean)model.getValue("isimport", parentIndexDept)).booleanValue())) {
                view.showMessage(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e0d\u80fd\u964d\u7ea7\u4e3a\u5f15\u5165\u4efb\u52a1\u7684\u5b50\u7ea7", (String)"TreeEntryUtils_4", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
                return;
            }
        }
        int parentIndex = 0;
        for (i = beginSeq - 1; i >= 0; --i) {
            curTaskId = (String)model.getValue("taskid", i);
            if (!curTaskId.equals(parentTask.getString("id"))) continue;
            model.setValue("isleaf", (Object)Boolean.FALSE, i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)yemianbiaoshi, (CharSequence)"pmpm_deptplan")) {
                model.setValue("pretask", null, i);
                model.setValue("logical", null, i);
            }
            parentIndex = i;
        }
        if (parentTask != null && StringUtils.equalsIgnoreCase((CharSequence)yemianbiaoshi, (CharSequence)"pmpm_deptplan")) {
            model.setValue("isleaf", (Object)Boolean.FALSE, parentIndex);
        }
        model.getEntryRowEntity("taskentity", beginSeq).set("parent", (Object)parentTask);
        ArrayList<DynamicObject> rowObjsList = new ArrayList<DynamicObject>(endSeq);
        for (int i2 = endSeq; i2 >= beginSeq; --i2) {
            rowObjsList.add(model.getEntryRowEntity("taskentity", i2));
            model.deleteEntryRow("taskentity", i2);
            model.updateCache();
        }
        TreeEntryUtils.insertRowObjToEntry(rowObjsList, "downgrade", view, yemianbiaoshi);
        TreeEntryGrid grid = (TreeEntryGrid)view.getControl("taskentity");
        grid.focus(parentIndex, beginSeq);
        view.getModel().setEntryCurrentRowIndex("taskentity", beginSeq);
        grid.selectRows(beginSeq);
        model.updateCache();
    }

    public static boolean isAllowMoveDown(IDataModel dataModel, int[] selectRows, String entryId) {
        boolean bAllowMove = true;
        int maxRow = Integer.MIN_VALUE;
        for (int i : selectRows) {
            if (maxRow >= i) continue;
            maxRow = i;
        }
        int rowCount = dataModel.getEntryRowCount(entryId);
        if (maxRow >= rowCount - 1) {
            bAllowMove = false;
        } else {
            bAllowMove = false;
            Object pid = dataModel.getEntryRowEntity(entryId, maxRow).get("pid");
            int j = 1;
            while (dataModel.getEntryRowEntity(entryId, maxRow + j) != null) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, maxRow + j).get("pid"))) {
                    bAllowMove = true;
                    break;
                }
                ++j;
            }
            for (int i : selectRows) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, i).get("pid"))) continue;
                bAllowMove = false;
            }
        }
        return bAllowMove;
    }

    public static boolean isAllowMoveUp(IDataModel dataModel, int[] selectRows, String entryId) {
        boolean bAllowMove = true;
        int minRow = Integer.MAX_VALUE;
        for (int i : selectRows) {
            if (minRow <= i) continue;
            minRow = i;
        }
        if (minRow <= 0) {
            bAllowMove = false;
        } else {
            Object pid = dataModel.getEntryRowEntity(entryId, minRow).get("pid");
            for (int i : selectRows) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, i).get("pid"))) continue;
                bAllowMove = false;
            }
            if (pid != null && !pid.toString().equals("0") && pid.equals(dataModel.getEntryRowEntity(entryId, minRow - 1).getPkValue())) {
                bAllowMove = false;
            }
        }
        return bAllowMove;
    }

    private static int findLastChildIndex(int beginSeq, IDataModel model) {
        int rowCount = model.getEntryRowCount("taskentity") - 1;
        int endSeq = beginSeq;
        if (beginSeq < rowCount) {
            String thisTaskId = (String)model.getValue("taskid", beginSeq);
            HashSet<String> parents = new HashSet<String>();
            parents.add(thisTaskId);
            while (endSeq < rowCount) {
                DynamicObject nextRowTaskParentObj;
                String nextRowTaskParentId;
                String string = nextRowTaskParentId = (nextRowTaskParentObj = (DynamicObject)model.getValue("parent", ++endSeq)) == null ? "" : nextRowTaskParentObj.getString("id");
                if (!parents.contains(nextRowTaskParentId)) {
                    --endSeq;
                    break;
                }
                parents.add(model.getValue("taskid", endSeq).toString());
            }
        }
        return endSeq;
    }

    private static void setRowObj(DynamicObject rowObj, int seq, IFormView view, String yemianbiaoshi) {
        IDataModel model = view.getModel();
        if (StringUtils.equalsIgnoreCase((CharSequence)yemianbiaoshi, (CharSequence)"pmpm_deptplan")) {
            model.beginInit();
            model.setValue("taskname", (Object)rowObj.getDynamicObject("taskname"), seq);
            model.setValue("parent", (Object)rowObj.getDynamicObject("parent"), seq);
            model.setValue("level", (Object)rowObj.getBigDecimal("level"), seq);
            model.setValue("taskid", (Object)rowObj.getString("taskid"), seq);
            model.setValue("isleaf", (Object)rowObj.getBoolean("isleaf"), seq);
            model.setValue("tasknametx", (Object)rowObj.getString("tasknametx"), seq);
            model.setValue("isimport", (Object)rowObj.getString("isimport"), seq);
            model.setValue("tasksourcetx", (Object)rowObj.getString("tasksourcetx"), seq);
            model.setValue("taskcontrolleveltx", (Object)rowObj.getDynamicObject("taskcontrolleveltx"), seq);
            model.setValue("taskstarttimetx", (Object)rowObj.getDate("taskstarttimetx"), seq);
            model.setValue("taskendtimetx", (Object)rowObj.getDate("taskendtimetx"), seq);
            model.setValue("taskmubiaotx", (Object)rowObj.getDate("taskmubiaotx"), seq);
            model.setValue("tasktimepctx", (Object)rowObj.getBigDecimal("tasktimepctx"), seq);
            model.setValue("taskjdgqtx", (Object)rowObj.getBigDecimal("taskjdgqtx"), seq);
            model.setValue("respersontx", (Object)rowObj.getDynamicObject("respersontx"), seq);
            model.setValue("resdepttx", (Object)rowObj.getDynamicObject("resdepttx"), seq);
            model.setValue("coopersontx", (Object)rowObj.getDynamicObject("coopersontx"), seq);
            model.setValue("coodepttx", (Object)rowObj.getDynamicObject("coodepttx"), seq);
            model.endInit();
            view.updateView("taskname", seq);
            view.updateView("tasknametx", seq);
            view.updateView("isimport", seq);
            view.updateView("tasksourcetx", seq);
            view.updateView("taskcontrolleveltx", seq);
            view.updateView("taskstarttimetx", seq);
            view.updateView("taskendtimetx", seq);
            view.updateView("taskmubiaotx", seq);
            view.updateView("tasktimepctx", seq);
            view.updateView("taskjdgqtx", seq);
            view.updateView("respersontx", seq);
            view.updateView("resdepttx", seq);
            view.updateView("coopersontx", seq);
            view.updateView("coodepttx", seq);
        } else {
            model.beginInit();
            model.setValue("taskname", (Object)rowObj.getString("taskname"), seq);
            model.setValue("tasknumber", (Object)rowObj.getString("tasknumber"), seq);
            model.setValue("controllevel", (Object)rowObj.getDynamicObject("controllevel"), seq);
            model.setValue("spectype", (Object)rowObj.getDynamicObject("spectype"), seq);
            model.setValue("tasktype", (Object)rowObj.getDynamicObject("tasktype"), seq);
            model.setValue("absoluteshedule", (Object)rowObj.getBigDecimal("absoluteshedule"), seq);
            model.setValue("pretask", (Object)rowObj.getDynamicObject("pretask"), seq);
            model.setValue("logical", (Object)rowObj.getString("logical"), seq);
            model.setValue("parent", (Object)rowObj.getDynamicObject("parent"), seq);
            model.setValue("level", (Object)rowObj.getBigDecimal("level"), seq);
            model.setValue("relativeschedule", (Object)rowObj.getBigDecimal("relativeschedule"), seq);
            model.setValue("planbegindate", (Object)rowObj.getDate("planbegindate"), seq);
            model.setValue("planenddate", (Object)rowObj.getDate("planenddate"), seq);
            model.setValue("aimfinishtime", (Object)rowObj.getDate("aimfinishtime"), seq);
            model.setValue("comptimedeviation", (Object)rowObj.getBigDecimal("comptimedeviation"), seq);
            model.setValue("directperson", (Object)rowObj.getDynamicObject("directperson"), seq);
            model.setValue("directorg", (Object)rowObj.getDynamicObject("directorg"), seq);
            model.setValue("indirectperson", (Object)rowObj.getDynamicObject("indirectperson"), seq);
            model.setValue("indirectorg", (Object)rowObj.getDynamicObject("indirectorg"), seq);
            model.setValue("taskid", (Object)rowObj.getString("taskid"), seq);
            model.endInit();
            model.setValue("isleaf", (Object)rowObj.getBoolean("isleaf"), seq);
            view.updateView("taskname", seq);
            view.updateView("tasknumber", seq);
            view.updateView("controllevel", seq);
            view.updateView("tasktype", seq);
            view.updateView("spectype", seq);
            view.updateView("absoluteshedule", seq);
            view.updateView("pretask", seq);
            view.updateView("logical", seq);
            view.updateView("relativeschedule", seq);
            view.updateView("planbegindate", seq);
            view.updateView("planenddate", seq);
            view.updateView("aimfinishtime", seq);
            view.updateView("comptimedeviation", seq);
            view.updateView("directperson", seq);
            view.updateView("directorg", seq);
            view.updateView("indirectperson", seq);
            view.updateView("indirectorg", seq);
            view.updateView("taskname", seq);
            view.updateView("parent", seq);
            view.updateView("level", seq);
        }
    }

    private static void insertRowObjToEntry(List<DynamicObject> rowObjsList, String type, IFormView view, String yemianbiaoshi) {
        IDataModel model = view.getModel();
        if (rowObjsList != null && rowObjsList.size() <= 0) {
            return;
        }
        int rowCount = 0;
        int curLevel = 0;
        if (rowObjsList != null && rowObjsList.size() > 0 && rowObjsList.get(rowObjsList.size() - 1).get("level") != null) {
            curLevel = (Integer)rowObjsList.get(rowObjsList.size() - 1).get("level");
        }
        ArrayList<DynamicObject> levelList = null;
        while (rowObjsList != null && rowObjsList.size() > 0) {
            levelList = new ArrayList<DynamicObject>();
            for (DynamicObject obj : rowObjsList) {
                if (obj.getInt("level") != curLevel) continue;
                levelList.add(obj);
            }
            if (levelList.size() <= 0) break;
            levelList.sort((obj1, obj2) -> obj1.getInt("seq") - obj2.getInt("seq"));
            for (int i = 0; i < levelList.size(); ++i) {
                DynamicObject rowObj = (DynamicObject)levelList.get(i);
                DynamicObject rowParentObj = rowObj.getDynamicObject("parent");
                String rowParentTaskId = rowParentObj == null ? "" : rowParentObj.getString("id");
                rowCount = model.getEntryRowCount("taskentity");
                for (int j = 0; j < rowCount; ++j) {
                    String rowtaskId = model.getEntryRowEntity("taskentity", j).getString("taskid");
                    if (!rowParentTaskId.equals(rowtaskId)) continue;
                    int rowIndex = model.insertEntryRow("taskentity", j);
                    model.updateCache();
                    if ("upgrade".equals(type)) {
                        rowObj.set("level", (Object)(rowObj.getInt("level") - 1));
                    } else if ("downgrade".equals(type)) {
                        rowObj.set("level", (Object)(rowObj.getInt("level") + 1));
                    }
                    TreeEntryUtils.setRowObj(rowObj, rowIndex, view, yemianbiaoshi);
                    rowObjsList.remove(rowObj);
                }
            }
            ++curLevel;
        }
    }

    private static boolean checkFirstNode(int index, IFormView view, IDataModel model) {
        DynamicObject preRowObj;
        String parentTaskId;
        DynamicObject curRowObj;
        int beginSeq = index;
        if (beginSeq == 0) {
            view.showMessage(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u662f\u672c\u7ea7\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"TreeEntryUtils_5", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return true;
        }
        if (beginSeq > 0 && (curRowObj = model.getEntryRowEntity("taskentity", beginSeq)).getDynamicObject("parent") != null && (parentTaskId = curRowObj.getDynamicObject("parent").getString("id")).equals((preRowObj = model.getEntryRowEntity("taskentity", beginSeq - 1)).getString("taskid"))) {
            view.showMessage(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u662f\u672c\u7ea7\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"TreeEntryUtils_5", (String)"pmgt-pmpm-common", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static DynamicObject findLastSameParentTask(int beginSeq, String parentTaskId, IDataModel model) {
        for (int i = beginSeq - 1; i >= 0; --i) {
            String pid;
            DynamicObject rowParentObj = model.getEntryRowEntity("taskentity", i).getDynamicObject("parent");
            String string = pid = rowParentObj == null ? "" : rowParentObj.getString("id");
            if (!pid.equals(parentTaskId)) continue;
            parentTaskId = model.getEntryRowEntity("taskentity", i).getString("taskid");
            DynamicObject parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTaskId, (String)"pmpm_task");
            return parentTask;
        }
        return null;
    }
}

