/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.TaskConstant;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.validator.PersonPlanValidator;

public class PersonPlanOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("respersontx");
        e.getFieldKeys().add("resdepttx");
        e.getFieldKeys().add("coopersontx");
        e.getFieldKeys().add("coodepttx");
        e.getFieldKeys().add("taskname");
        e.getFieldKeys().add("taskcontrolleveltx");
        e.getFieldKeys().add("taskstarttimetx");
        e.getFieldKeys().add("taskendtimetx");
        e.getFieldKeys().add("taskmubiaotx");
        e.getFieldKeys().add("tasktimepctx");
        e.getFieldKeys().add("taskabstractdate");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("planningcycle");
        e.getFieldKeys().add("timerangestartdate");
        e.getFieldKeys().add("timerangeenddate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PersonPlanValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Object> list = new ArrayList<Object>();
        QFilter[] filters = new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.PRIVATEPLAN.getValue())};
        DynamicObject plantype = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"id", (QFilter[])filters);
        String plantypeid = plantype.get("id").toString();
        switch (key) {
            case "submit": {
                this.onSubmit(dataEntities);
                break;
            }
            case "audit": {
                this.doAudit(dataEntities, list, plantypeid);
                break;
            }
            case "unaudit": {
                this.doUnaudit(dataEntities, list, plantypeid);
                break;
            }
        }
    }

    private void doUnaudit(DynamicObject[] dataEntities, ArrayList<Object> list, String plantypeid) {
        DynamicObject[] taskObjs;
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection taskEntry = bill.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < taskEntry.size(); ++i) {
                DynamicObject taskid = (DynamicObject)((DynamicObject)taskEntry.get(i)).get("task");
                Object pkValue = taskid.getPkValue();
                list.add(pkValue);
            }
        }
        Object[] array = list.toArray();
        for (DynamicObject taskObj : taskObjs = BusinessDataServiceHelper.load((Object[])array, (DynamicObjectType)TaskConstant.dt)) {
            String belongplantype = taskObj.getDynamicObject("belongplantype").getPkValue().toString();
            if (!plantypeid.equals(belongplantype)) continue;
            taskObj.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])taskObjs);
    }

    private void doAudit(DynamicObject[] dataEntities, ArrayList<Object> list, String plantypeid) {
        DynamicObject[] taskObjs;
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection taskEntry = bill.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < taskEntry.size(); ++i) {
                DynamicObject taskid = (DynamicObject)((DynamicObject)taskEntry.get(i)).get("task");
                Object pkValue = taskid.getPkValue();
                list.add(pkValue);
            }
        }
        Object[] array = list.toArray();
        for (DynamicObject taskObj : taskObjs = BusinessDataServiceHelper.load((Object[])array, (DynamicObjectType)TaskConstant.dt)) {
            String belongplantype = taskObj.getDynamicObject("belongplantype").getPkValue().toString();
            if (!plantypeid.equals(belongplantype)) continue;
            taskObj.set("status", (Object)StatusEnum.CHECKED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])taskObjs);
        HashSet<Object> set = new HashSet<Object>(list);
        PmpmTaskUtil.updateTaskStatusByIdSet(set);
    }

    protected void onSubmit(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject[] savedTaskArr = new DynamicObject[entryEntities.size()];
            ArrayList<DynamicObject[]> taskIds = new ArrayList<DynamicObject[]>(10);
            for (DynamicObject entry : entryEntities) {
                DynamicObject taskObject = entry.getDynamicObject("task");
                DynamicObject[] taskId = taskObject.getPkValue().toString();
                taskIds.add(taskId);
            }
            QFilter qFilter = new QFilter("id", "in", taskIds);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,controllevel,majortype,tasktype,absoluteduration,pretask,logical,relativeduration,responsibleperson,responsibledept,taskresultdocentry.id,taskresultdocentry.seq,taskresultdocentry.resultname,taskresultdocentry.force,taskresultdocentry.frequency,taskresultdocentry.resultdescription,taskreferdocentry.id,taskreferdocentry.attachmentfield,taskreferdocentry.description,taskreferdocentry.referdocname,taskreferdocentry.seq,project,plans,sourcetask,prechangetask,sharer,comment,percent,completionstatus,taskseq,achievementnode,realendtime,comptimedeviation,resultdoc,version,planstarttime,planendtime,aimfinishtime,cooperationperson,cooperationdept,belongplantype,realtimedeviation", (QFilter[])new QFilter[]{qFilter});
            HashMap<String, DynamicObject> taskIdIndexMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject task : tasks) {
                taskIdIndexMap.put(task.getPkValue().toString(), task);
            }
            int count = 0;
            for (DynamicObject entry : entryEntities) {
                DynamicObject taskObject = entry.getDynamicObject("task");
                String taskId = taskObject.getPkValue().toString();
                DynamicObject task = (DynamicObject)taskIdIndexMap.get(taskId);
                task.set("responsibleperson", (Object)entry.getDynamicObject("respersontx"));
                task.set("responsibledept", (Object)entry.getDynamicObject("resdepttx"));
                task.set("cooperationperson", (Object)entry.getDynamicObject("coopersontx"));
                task.set("cooperationdept", (Object)entry.getDynamicObject("coodepttx"));
                task.set("name", (Object)entry.getString("taskname"));
                task.set("controllevel", (Object)entry.getDynamicObject("taskcontrolleveltx"));
                task.set("planstarttime", (Object)entry.getDate("taskstarttimetx"));
                task.set("planendtime", (Object)entry.getDate("taskendtimetx"));
                task.set("aimfinishtime", (Object)entry.getDate("taskmubiaotx"));
                task.set("comptimedeviation", (Object)entry.getBigDecimal("tasktimepctx"));
                task.set("absoluteduration", (Object)entry.getBigDecimal("taskabstractdate"));
                savedTaskArr[count++] = task;
            }
            SaveServiceHelper.save((DynamicObject[])savedTaskArr);
        }
    }
}

