/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.TaskConstant;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.EcSaveServiceHelper;
import kd.pmgt.pmbs.common.utils.TaskCloneUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;

public class ProjectPlanOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("sourceplan");
        e.getFieldKeys().add("planstatus");
        e.getFieldKeys().add("taskname");
        e.getFieldKeys().add("taskid");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("prechangeplan");
        e.getFieldKeys().add("majortype");
        e.getFieldKeys().add("plantype");
        e.getFieldKeys().add("taskentity");
        e.getFieldKeys().add("spectype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (key) {
            case "submit": {
                this.verifyTaskDate(dataEntities);
                for (DynamicObject bill : dataEntities) {
                    bill.set("planstatus", (Object)PlanEnum.CHECKING.getValue());
                }
                break;
            }
            case "unsubmit": {
                for (DynamicObject bill : dataEntities) {
                    bill.set("planstatus", (Object)PlanEnum.CREATEING.getValue());
                }
                break;
            }
            case "audit": {
                this.doAudit(dataEntities);
                break;
            }
            case "delete": {
                this.doDeleteTask(dataEntities);
                break;
            }
        }
    }

    private void doDeleteTask(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection entrys;
            String planType = null;
            DynamicObject majorType = bill.getDynamicObject("majortype");
            if (majorType != null) {
                majorType = BusinessDataServiceHelper.loadSingle((Object)majorType.getString("id"), (String)"pmpm_majortype", (String)"plantype");
            }
            if (majorType != null) {
                planType = majorType.getString("plantype");
            }
            if ((entrys = bill.getDynamicObjectCollection("taskentity")).size() <= 0) continue;
            Object[] delTaskIdArr = new String[entrys.size()];
            for (int i = 0; i < entrys.size(); ++i) {
                String taskId = ((DynamicObject)entrys.get(i)).getString("taskid");
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
                if (PlanTypeEnum.MAJORPLAN.getValue().equals(planType) && "2".equals(task.getDynamicObject("belongplantype").getString("plantype"))) {
                    delTaskIdArr[i] = ((DynamicObject)entrys.get(i)).getString("taskid");
                    continue;
                }
                if (!PlanTypeEnum.MAINPLAN.getValue().equals(planType)) continue;
                delTaskIdArr[i] = ((DynamicObject)entrys.get(i)).getString("taskid");
            }
            DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])delTaskIdArr);
        }
    }

    private void doAudit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            String planId = bill.getString("id");
            PmpmTaskUtil.updateDelTaskByPlanWhenAudit((Object)planId);
        }
        this.changeBillStatus(dataEntities);
        for (DynamicObject bill : dataEntities) {
            BigDecimal version = (BigDecimal)bill.get("version");
            String preBillId = "";
            if (bill.getDynamicObject("prechangeplan") != null) {
                preBillId = bill.getDynamicObject("prechangeplan").getString("id");
            }
            if (version.compareTo(BigDecimal.ONE) == 0 || preBillId.trim().isEmpty()) continue;
            this.changeId(dataEntities);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (key) {
            case "audit": {
                HashSet<String> taskIdSet = new HashSet<String>();
                for (DynamicObject bill : dataEntities) {
                    bill = BusinessDataServiceHelper.loadSingle((Object)bill.getString("id"), (String)"pmpm_projectplan");
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("taskentity");
                    for (DynamicObject entryInfo : entrys) {
                        String taskId = entryInfo.getString("taskid");
                        taskIdSet.add(taskId);
                        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                        PmpmTaskUtil.updateReferTaskTime((DynamicObject)task);
                    }
                }
                if (taskIdSet.size() <= 0) break;
                PmpmTaskUtil.updateTaskStatusByIdSet(taskIdSet);
                break;
            }
        }
    }

    private void verifyTaskDate(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            if ("0".equals(bill.getString("id"))) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("taskentity");
            for (DynamicObject entryInfo : entrys) {
                Date parentEndDate;
                Date parentBeginDate;
                String taskId = entryInfo.getString("taskid");
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                DynamicObject parentTask = task.getDynamicObject("parent");
                if (parentTask == null) continue;
                parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getString("id"), (String)"pmpm_task");
                Date beginDate = task.getDate("planstarttime");
                if (beginDate.compareTo(parentBeginDate = parentTask.getDate("planstarttime")) < 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0c\u4efb\u52a1\u540d\u79f0\u4e3a\uff1a%s\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"ProjectPlanOp_0", (String)"pmgt-pmpm-opplugin", (Object[])new Object[0]), entryInfo.get("seq"), task.getString("name"));
                    throw new KDBizException(msg);
                }
                Date endDate = task.getDate("planendtime");
                if (endDate.compareTo(parentEndDate = parentTask.getDate("planendtime")) <= 0) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0c\u4efb\u52a1\u540d\u79f0\u4e3a\uff1a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u665a\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"ProjectPlanOp_1", (String)"pmgt-pmpm-opplugin", (Object[])new Object[0]), entryInfo.get("seq"), task.getString("name"));
                throw new KDBizException(msg);
            }
        }
    }

    private void changeBillStatus(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> preList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<Object> currentTaskListPk = new ArrayList<Object>(10);
        for (DynamicObject bill : dataEntities) {
            BigDecimal version = (BigDecimal)bill.get("version");
            String preBillId = "";
            if (bill.getDynamicObject("prechangeplan") != null) {
                preBillId = bill.getDynamicObject("prechangeplan").getString("id");
            }
            if (version.compareTo(BigDecimal.ONE) != 0 && !preBillId.trim().isEmpty()) {
                DynamicObject preDynamicObject = BusinessDataServiceHelper.loadSingle((Object)preBillId, (String)"pmpm_projectplan");
                preDynamicObject.set("planstatus", (Object)PlanEnum.HISTORY.getValue());
                preList.add(preDynamicObject);
            }
            bill.set("planstatus", (Object)PlanEnum.PUBLISHED.getValue());
            DynamicObjectCollection currentTaskEntry = bill.getDynamicObjectCollection("taskentity");
            for (DynamicObject curEntry : currentTaskEntry) {
                if (null == curEntry.get("taskid")) continue;
                currentTaskListPk.add(curEntry.get("taskid"));
            }
            list.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
        SaveServiceHelper.save((DynamicObject[])preList.toArray(new DynamicObject[preList.size()]));
        HashMap<String, String> currentupdateParam = new HashMap<String, String>();
        currentupdateParam.put("status", StatusEnum.CHECKED.getValue());
        EcSaveServiceHelper.batchUpdate((String)"pmpm_task", (Object[])currentTaskListPk.toArray(new Object[currentTaskListPk.size()]), currentupdateParam);
    }

    private void changeId(DynamicObject[] dataEntities) {
        ArrayList<String> preChangeTaskListPk = null;
        ArrayList<String> curRelateTaskListPk = null;
        ArrayList<DynamicObject> curtasklistCopy = null;
        ArrayList<DynamicObject> preTaskListCopy = null;
        for (DynamicObject bill : dataEntities) {
            preChangeTaskListPk = new ArrayList<String>(10);
            curRelateTaskListPk = new ArrayList<String>(10);
            HashMap<String, String> taskIdRelation1 = new HashMap<String, String>();
            HashMap<String, String> taskIdRelation2 = new HashMap<String, String>();
            DynamicObject majorType = bill.getDynamicObject("majortype");
            majorType = BusinessDataServiceHelper.loadSingle((Object)majorType.getString("id"), (String)"pmpm_majortype", (String)"plantype");
            String billPlanType = majorType.getString("plantype");
            BigDecimal version = (BigDecimal)bill.get("version");
            String preBillId = "";
            if (bill.getDynamicObject("prechangeplan") != null) {
                preBillId = bill.getDynamicObject("prechangeplan").getString("id");
            }
            if (version.compareTo(BigDecimal.ONE) != 0 && !preBillId.trim().isEmpty()) {
                DynamicObjectCollection curTaskEntry = bill.getDynamicObjectCollection("taskentity");
                for (DynamicObject curEntry : curTaskEntry) {
                    String curRelatedTaskId = curEntry.getString("taskid");
                    DynamicObject curRelateTask = BusinessDataServiceHelper.loadSingle((Object)curRelatedTaskId, (DynamicObjectType)TaskConstant.dt);
                    String taskPlanType = curRelateTask.getDynamicObject("belongplantype").getString("plantype");
                    if (!"1".equals(billPlanType) && (!"2".equals(billPlanType) || !"2".equals(taskPlanType)) || null == curRelateTask.getDynamicObject("prechangetask")) continue;
                    curRelateTaskListPk.add(curRelatedTaskId);
                    String preTaskId = curRelateTask.getDynamicObject("prechangetask").getString("id");
                    preChangeTaskListPk.add(preTaskId);
                    taskIdRelation1.put(curRelatedTaskId, preTaskId);
                    taskIdRelation2.put(preTaskId, curRelatedTaskId);
                }
            }
            curtasklistCopy = new ArrayList<DynamicObject>(10);
            preTaskListCopy = new ArrayList<DynamicObject>(10);
            for (int i = 0; i < curRelateTaskListPk.size(); ++i) {
                DynamicObject curRelateTask = BusinessDataServiceHelper.loadSingle(curRelateTaskListPk.get(i), (String)"pmpm_task");
                DynamicObject curRealteTaskCopy = (DynamicObject)OrmUtils.clone((Object)curRelateTask, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                TaskCloneUtil.cloneTask((DynamicObject)curRealteTaskCopy, (DynamicObject)curRelateTask);
                DynamicObject pretask = BusinessDataServiceHelper.loadSingle(preChangeTaskListPk.get(i), (String)"pmpm_task");
                DynamicObject pretaskCopy = (DynamicObject)OrmUtils.clone((Object)pretask, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                TaskCloneUtil.cloneTask((DynamicObject)pretaskCopy, (DynamicObject)pretask);
                curRelateTask = TaskCloneUtil.cloneTask((DynamicObject)curRelateTask, (DynamicObject)pretaskCopy);
                curRelateTask.set("status", (Object)StatusEnum.CHECKED.getValue());
                curRelateTask.set("sourcetask", (Object)pretask);
                curtasklistCopy.add(curRelateTask);
                pretask = TaskCloneUtil.cloneTask((DynamicObject)pretask, (DynamicObject)curRealteTaskCopy);
                pretask.set("sourcetask", null);
                preTaskListCopy.add(pretask);
            }
            SaveServiceHelper.save((IDataEntityType)TaskConstant.dt, (Object[])curtasklistCopy.toArray(new DynamicObject[curtasklistCopy.size()]));
            SaveServiceHelper.save((IDataEntityType)TaskConstant.dt, (Object[])preTaskListCopy.toArray(new DynamicObject[preTaskListCopy.size()]));
            this.updateTaskReport(preTaskListCopy);
            DynamicObject curBill = BusinessDataServiceHelper.loadSingle((Object)bill.getString("id"), (String)"pmpm_projectplan");
            DynamicObject preBill = BusinessDataServiceHelper.loadSingle((Object)preBillId, (String)"pmpm_projectplan");
            ArrayList<DynamicObject> changedTaskList = new ArrayList<DynamicObject>();
            this.changCurBillContent(taskIdRelation1, curBill, changedTaskList);
            this.changCurBillContent(taskIdRelation2, preBill, changedTaskList);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBill, preBill});
            SaveServiceHelper.save((DynamicObject[])changedTaskList.toArray(new DynamicObject[changedTaskList.size()]));
            ArrayList<DynamicObject> changePreTaskList = new ArrayList<DynamicObject>();
            this.changePreTaskContent(taskIdRelation1, curBill, changePreTaskList);
            this.changePreTaskContent(taskIdRelation2, preBill, changePreTaskList);
            SaveServiceHelper.save((DynamicObject[])changePreTaskList.toArray(new DynamicObject[changePreTaskList.size()]));
        }
    }

    private void updateTaskReport(List<DynamicObject> preTaskListCopy) {
        ArrayList<DynamicObject> updatedTaskReportList = new ArrayList<DynamicObject>(8);
        for (DynamicObject task : preTaskListCopy) {
            DynamicObject[] taskReportArr;
            String newestTaskId = task.getString("id");
            QFilter taskIdFilter = new QFilter("task", "=", (Object)newestTaskId);
            for (DynamicObject taskReport : taskReportArr = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"resultid", (QFilter[])new QFilter[]{taskIdFilter})) {
                DynamicObjectCollection newResultEntryCol = task.getDynamicObjectCollection("taskresultdocentry");
                DynamicObjectCollection chengguoEntrycol = taskReport.getDynamicObjectCollection("chengguoentity");
                for (int i = 0; i < chengguoEntrycol.size(); ++i) {
                    DynamicObject chnegguoEntryInfo = (DynamicObject)chengguoEntrycol.get(i);
                    if (newResultEntryCol.get(i) == null) continue;
                    chnegguoEntryInfo.set("resultid", (Object)((DynamicObject)newResultEntryCol.get(i)).getString("id"));
                }
                updatedTaskReportList.add(taskReport);
            }
            if (updatedTaskReportList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])updatedTaskReportList.toArray(new DynamicObject[updatedTaskReportList.size()]));
        }
    }

    private void changePreTaskContent(Map<String, String> taskIdRelation, DynamicObject curBill, List<DynamicObject> changePreTaskList) {
        DynamicObjectCollection entrys = curBill.getDynamicObjectCollection("taskentity");
        for (int i = 0; i < entrys.size(); ++i) {
            String preTaskId;
            String newPreTaskId;
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            String taskId = entryInfo.getString("taskid");
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"pretask");
            if (task.getDynamicObject("pretask") == null || (newPreTaskId = taskIdRelation.get(preTaskId = task.getDynamicObject("pretask").getString("id"))) == null) continue;
            DynamicObject newPreTask = BusinessDataServiceHelper.loadSingle((Object)newPreTaskId, (String)"pmpm_task", (String)"id");
            task.set("pretask", (Object)newPreTask);
            changePreTaskList.add(task);
        }
    }

    private void changCurBillContent(Map<String, String> taskIdRelation, DynamicObject bill, List<DynamicObject> changedTaskList) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("taskentity");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            String taskId = entryInfo.getString("taskid");
            String taskIdValue = taskIdRelation.get(taskId);
            if (taskIdValue != null) {
                entryInfo.set("taskid", (Object)taskIdValue);
                this.changeNewTaskParent(taskIdRelation, taskIdValue, changedTaskList);
                continue;
            }
            this.changeNewTaskParent(taskIdRelation, taskId, changedTaskList);
        }
    }

    private void changeNewTaskParent(Map<String, String> taskIdRelation, String taskId, List<DynamicObject> changedTaskList) {
        String oldParentTaskId;
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"parent");
        if (task.getDynamicObject("parent") != null && taskIdRelation.get(oldParentTaskId = task.getDynamicObject("parent").getString("id")) != null) {
            String newParentTaskId = taskIdRelation.get(oldParentTaskId);
            DynamicObject newParentTask = BusinessDataServiceHelper.loadSingle((Object)newParentTaskId, (String)"pmpm_task", (String)"id");
            task.set("parent", (Object)newParentTask);
            changedTaskList.add(task);
        }
    }
}

