/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.MajorTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;

public class TaskReportOp
extends AbstractOperationServicePlugIn {
    private static final String PERCENT = "100";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("percent");
        e.getFieldKeys().add("completetime");
        e.getFieldKeys().add("huibaoperson");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block20: {
            DynamicObject[] dataEntities;
            String operationKey;
            block21: {
                block19: {
                    operationKey = e.getOperationKey();
                    dataEntities = e.getDataEntities();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"audit")) break block19;
                    ArrayList<DynamicObject> saveTasks = new ArrayList<DynamicObject>();
                    for (DynamicObject bill : dataEntities) {
                        int percent = bill.getInt("percent");
                        DynamicObject task = (DynamicObject)bill.get("task");
                        Date realendtime = bill.getDate("completetime");
                        String huibaoPerson = bill.getString("huibaoperson");
                        DynamicObject loadTask = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"pmpm_task");
                        DynamicObjectCollection entity = bill.getDynamicObjectCollection("chengguoentity");
                        if (entity != null && entity.size() > 0) {
                            int uploadNum = 0;
                            for (int i = 0; i < entity.size(); ++i) {
                                QFilter taskreportStatus;
                                DynamicObjectCollection files = (DynamicObjectCollection)((DynamicObject)entity.get(i)).get("attachmentfield");
                                if (files.size() > 0) {
                                    ++uploadNum;
                                    continue;
                                }
                                QFilter taskid = new QFilter("task", "=", task.getPkValue());
                                QFilter[] filters = new QFilter[]{taskid, taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())};
                                DynamicObject[] taskReporcollection = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"id,billno,billstatus,persontype,creator,modifier,auditor,auditdate,modifytime,createtime,chengguoentity.id,chengguoentity.attachmentfield,chengguoentity.resultname,chengguoentity.desc,chengguoentity.force,chengguoentity.resultid,chengguoentity.frequency,iscomplete,completetime,tips,reportdesc,huibaojlentity.id,huibaojlentity.completeprocess,huibaojlentity.resultdate,huibaojlentity.reportperson,huibaojlentity.completedesc,huibaojlentity.taskreport,huibaojlentity.historytask,huibaojlentity.resultstatus,task,percent,huibaoperson", (QFilter[])filters, (String)"modifytime desc");
                                if (taskReporcollection == null || taskReporcollection.length <= 0) continue;
                                for (DynamicObject oldRe : taskReporcollection) {
                                    DynamicObjectCollection oldEntity = oldRe.getDynamicObjectCollection("chengguoentity");
                                    DynamicObjectCollection oldFiles = (DynamicObjectCollection)((DynamicObject)oldEntity.get(i)).get("attachmentfield");
                                    if (oldFiles.size() <= 0) continue;
                                    ++uploadNum;
                                }
                            }
                            loadTask.set("resultdoc", (Object)("(" + uploadNum + "/" + entity.size() + ")"));
                        }
                        if (!StringUtils.containsIgnoreCase((CharSequence)huibaoPerson, (CharSequence)ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"TaskReportOp_0", (String)"pmgt-pmpm-opplugin", (Object[])new Object[0]))) {
                            loadTask.set("percent", (Object)percent);
                            Date planendtime = task.getDate("planendtime");
                            Date currentDate = DateUtil.getCurrentDate();
                            if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(percent), (CharSequence)PERCENT)) {
                                DynamicObject project = task.getDynamicObject("project");
                                BigDecimal realTimeDeviatiom = BigDecimal.ZERO;
                                realTimeDeviatiom = project != null ? PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)realendtime, (Date)planendtime) : BigDecimal.valueOf(DateUtil.getDaysBetweenTwoDate((Date)realendtime, (Date)planendtime));
                                loadTask.set("realtimedeviation", (Object)realTimeDeviatiom);
                                if (DateUtil.compareByDay((Date)realendtime, (Date)planendtime) <= 0) {
                                    loadTask.set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
                                } else if (DateUtil.compareByDay((Date)realendtime, (Date)planendtime) > 0) {
                                    loadTask.set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                                }
                                loadTask.set("realendtime", (Object)realendtime);
                            } else if (percent > 0) {
                                if (DateUtil.compareByDay((Date)planendtime, (Date)currentDate) < 0) {
                                    loadTask.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                                } else if (DateUtil.compareByDay((Date)realendtime, (Date)planendtime) > 0) {
                                    loadTask.set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
                                } else if (DateUtil.compareByDay((Date)planendtime, (Date)currentDate) > 0) {
                                    loadTask.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                                }
                            }
                            saveTasks.add(loadTask);
                        }
                        this.updateTaskReportStatus(loadTask.getPkValue(), bill.getPkValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])saveTasks.toArray(new DynamicObject[saveTasks.size()]));
                    break block20;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"submit")) break block21;
                for (DynamicObject bill : dataEntities) {
                    DynamicObject task = bill.getDynamicObject("task");
                    DynamicObject majortype = task.getDynamicObject("majortype");
                    DynamicObject project = task.getDynamicObject("project");
                    if (majortype == null || !StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) continue;
                    StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, (ProjectStatusEnum)ProjectStatusEnum.APPROVAL_IN);
                }
                break block20;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"unsubmit")) break block20;
            for (DynamicObject bill : dataEntities) {
                DynamicObject task = bill.getDynamicObject("task");
                DynamicObject majortype = task.getDynamicObject("majortype");
                DynamicObject project = task.getDynamicObject("project");
                if (majortype == null || !StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue()) || project == null) continue;
                DynamicObject[] budgetStage = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)BudgetStageEnum.PREINSTALL_2.getValue())});
                QFilter filter1 = new QFilter("budgetstage", "=", budgetStage[0].getPkValue());
                QFilter filter2 = new QFilter("version", "=", (Object)BigDecimal.valueOf(1.0));
                QFilter filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                filter3.or(new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue()));
                DynamicObject[] budget = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, name, project, version, sourcetype, issys, type, description, isvalid, currency, totalamount, group, budgetstage, presamount, prevamount, schangeamount, vchangeamount", (QFilter[])new QFilter[]{filter1, filter2, filter3});
                if (budget != null && budget.length >= 1) continue;
                StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, null);
            }
        }
    }

    private void updateTaskReportStatus(Object taskId, Object currentReportId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter task = new QFilter("task", "=", taskId);
        filters.add(task);
        QFilter ids = new QFilter("id", "!=", currentReportId);
        filters.add(ids);
        DynamicObject[] reports = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"latest", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (reports.length == 0) {
            return;
        }
        for (DynamicObject report : reports) {
            report.set("latest", (Object)DefaultEnum.NO.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])reports);
    }
}

