/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.validator;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PersonPlanValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            this.submitValidate();
        }
    }

    protected void submitValidate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        String userId = RequestContext.get().getUserId();
        for (ExtendedDataEntity dataEntity : entities) {
            boolean result = true;
            StringBuilder sb = new StringBuilder();
            DynamicObject object = dataEntity.getDataEntity();
            result = this.validateOfNull(object, sb);
            if (result) {
                result = this.onePlan(object, sb);
            }
            if (result) {
                result = this.validateCoopAndResp(object, sb, userId);
            }
            if (result) continue;
            this.addErrorMessage(dataEntity, sb.toString());
        }
    }

    protected boolean validateCoopAndResp(DynamicObject object, StringBuilder sb, String userId) {
        DynamicObjectCollection entryEntities = object.getDynamicObjectCollection("entryentity");
        if (entryEntities != null) {
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject response = entryEntity.getDynamicObject("respersontx");
                DynamicObject cooper = entryEntity.getDynamicObject("coopersontx");
                if (response != null && response.getPkValue().toString().equals(userId) && (cooper == null || !cooper.getPkValue().toString().equals(userId))) continue;
                sb.append("\u4e3b\u8d23\u4eba\u6216\u8005\u534f\u529e\u4eba\u5fc5\u987b\u6709\u4e00\u4e2a\u662f\u5f53\u524d\u767b\u5f55\u4eba\uff1b");
                return false;
            }
        }
        return true;
    }

    protected boolean onePlan(DynamicObject object, StringBuilder sb) {
        DynamicObject org = object.getDynamicObject("org");
        DynamicObject modifier = object.getDynamicObject("modifier");
        Object planningCycle = object.get("planningcycle");
        Object startTime = object.get("timerangestartdate");
        Object endTime = object.get("timerangeenddate");
        QFilter time1 = new QFilter("timerangestartdate", "<=", startTime).and(new QFilter("timerangeenddate", ">=", startTime));
        QFilter time2 = new QFilter("timerangestartdate", "<=", endTime).and(new QFilter("timerangeenddate", ">=", endTime));
        QFilter time = time1.or(time2);
        QFilter time3 = new QFilter("timerangestartdate", ">=", startTime).and(new QFilter("timerangeenddate", "<=", endTime));
        time.or(time3);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("planningcycle", "=", planningCycle), new QFilter("modifier", "=", modifier.get("id")), time, new QFilter("id", "!=", object.getPkValue())};
        boolean exists = QueryServiceHelper.exists((String)"pmpm_personplan", (QFilter[])filters);
        if (exists) {
            sb.append("\u8be5\u7ec4\u7ec7\u8be5\u65f6\u95f4\u6bb5\u5df2\u5b58\u5728\u4e2a\u4eba\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5236\u5b9a\uff1b");
        }
        return !exists;
    }

    protected boolean validateOfNull(DynamicObject object, StringBuilder sb) {
        boolean flag = true;
        Object planningcycle = object.get("planningcycle");
        if (null == planningcycle) {
            sb.append("\u8bf7\u586b\u5199\u8ba1\u5212\u5468\u671f\uff1b");
            flag = false;
        }
        Object startTime = object.get("timerangestartdate");
        Object endTime = object.get("timerangeenddate");
        if (null == startTime || null == endTime) {
            sb.append("\u8bf7\u586b\u5199\u65f6\u95f4\u8303\u56f4\uff1b");
            flag = false;
        }
        return flag;
    }
}

