/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.hierarchy.DynamicObjectTreeNode;
import kd.pmgt.pmbs.common.hierarchy.Hierarchy;
import kd.pmgt.pmbs.common.tree.OrgProjectTreeHelper;
import kd.pmgt.pmbs.common.utils.EcSerializeHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.template.OrgProjectTreeDeptListPlugin;

public class DeptImportListPlugin
extends OrgProjectTreeDeptListPlugin {
    private static final Log logger = LogFactory.getLog(DeptImportListPlugin.class);

    public void initializeTree(EventObject e) {
        Object source = e.getSource();
        if (source instanceof BillList) {
            return;
        }
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (customMap.get("deptid") != null) {
            Long deptid = Long.valueOf(customMap.get("deptid").toString());
            DynamicObject[] projs = ProjectPermissionHelper.getPermProjByOrgList((long)deptid, null);
            ArrayList<String> proIds = new ArrayList<String>(projs.length);
            for (DynamicObject proj : projs) {
                proIds.add(proj.getPkValue().toString());
            }
            Hierarchy tree = OrgProjectTreeHelper.initNavTree((TreeView)this.getTreeListView().getTreeView(), (Long)deptid, (boolean)false, proIds);
            if (tree != null) {
                DynamicObjectTreeNode node = (DynamicObjectTreeNode)tree.getRootNode();
                TreeNode root = node.getTreeNode();
                this.getTreeModel().setRoot(root);
                TreeView treeView = this.getTreeListView().getTreeView();
                treeView.focusNode(root);
                treeView.treeNodeClick(null, root.getId());
            }
            this.getPageCache().put("orgproject_tree_key", EcSerializeHelper.serialize((Object)tree));
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        TreeView treeView = this.getTreeListView().getTreeView();
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusProject = treeState.getFocusNode();
        if (null != focusProject && this.isProjectNode(focusProject.get("id"))) {
            ArrayList<String> proIds = new ArrayList<String>(10);
            proIds.add(focusProject.get("id").toString());
            this.addTreeFilterByNode(e, proIds);
        } else if (null != focusProject) {
            String orgId = focusProject.get("id").toString();
            DynamicObject[] projs = ProjectPermissionHelper.getPermProjByOrgList((long)Long.parseLong(orgId), null);
            ArrayList<String> proIds = new ArrayList<String>(projs.length);
            for (DynamicObject proj : projs) {
                proIds.add(proj.getPkValue().toString());
            }
            this.addTreeFilterByNode(e, proIds);
        }
        e.setCancel(true);
    }

    private void addTreeFilterByNode(BuildTreeListFilterEvent e, List<String> proIds) {
        QFilter taskFilter;
        QFilter qFilter = new QFilter("project", "in", proIds);
        QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        DynamicObject[] projectPlans = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"taskentity,taskid", (QFilter[])new QFilter[]{qFilter, statusFilter});
        ArrayList<String> taskIds = new ArrayList<String>(10);
        for (DynamicObject projectPlan : projectPlans) {
            DynamicObjectCollection taskEntrys = projectPlan.getDynamicObjectCollection("taskentity");
            for (DynamicObject taskEntry : taskEntrys) {
                String taskId = taskEntry.getString("taskid");
                if (null == taskId) continue;
                taskIds.add(taskId);
            }
        }
        if (!taskIds.isEmpty()) {
            taskFilter = new QFilter("id", "in", taskIds).and(qFilter);
            e.addQFilter(taskFilter);
        } else {
            taskFilter = new QFilter("id", "=", (Object)0);
            e.addQFilter(taskFilter);
        }
    }

    private boolean isProjectNode(Object nodeId) {
        DynamicObject project = null;
        try {
            project = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"bd_project");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return project != null;
    }
}

