/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmFormPlugin;

public class DeptPlanReachRatePlugin
extends AbstractPmpmFormPlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String[] COLUMNKEY = new String[]{"org", "planend", "ontimeend", "overtimeend", "totalend", "overtimenotend", "ontimeendrate", "overtimeendrate", "endrate"};
    private String fileName = ResManager.loadKDString((String)"\u90e8\u95e8\u8ba1\u5212\u8fbe\u6210\u7387-\u6570\u636e\u660e\u7ec6", (String)"DeptPlanReachRatePlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
    private String sheetName = ResManager.loadKDString((String)"\u6570\u636e\u660e\u7ec6", (String)"DeptPlanReachRatePlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
    private String[] header = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"DeptPlanReachRatePlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u603b\u6570", (String)"DeptPlanReachRatePlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0])};

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)"orgs", (CharSequence)propName)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            long orgId = RequestContext.get().getOrgId();
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add(orgId);
            List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
            QFilter orgFilter = new QFilter("id", "in", (Object)allOrgIds);
            showParameter.getListFilterParameter().getQFilters().add(orgFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit orgs = (MulBasedataEdit)this.getControl("orgs");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Chart totalChart = (Chart)this.getControl("histogramchartap");
        totalChart.addClickListener((ClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"querydata", (CharSequence)operateKey)) {
            this.updateData();
        } else if (StringUtils.equals((CharSequence)"refreshdata", (CharSequence)operateKey)) {
            this.updateData();
        } else if (StringUtils.equals((CharSequence)"export", (CharSequence)operateKey)) {
            JSONArray data = new JSONArray();
            DynamicObjectCollection dataCol = this.getModel().getEntryEntity("entryentity");
            DecimalFormat df2 = new DecimalFormat("#.##");
            for (DynamicObject dynamicObject : dataCol) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("org", (Object)dynamicObject.getString("org.name"));
                jsonObj.put("planend", (Object)dynamicObject.getInt("planend"));
                jsonObj.put("ontimeend", (Object)dynamicObject.getInt("ontimeend"));
                jsonObj.put("overtimeend", (Object)dynamicObject.getInt("overtimeend"));
                jsonObj.put("totalend", (Object)dynamicObject.getInt("totalend"));
                jsonObj.put("overtimenotend", (Object)dynamicObject.getInt("overtimenotend"));
                jsonObj.put("ontimeendrate", (Object)(df2.format(dynamicObject.getBigDecimal("ontimeendrate").multiply(BigDecimal.valueOf(100L))) + "%"));
                jsonObj.put("overtimeendrate", (Object)(df2.format(dynamicObject.getBigDecimal("overtimeendrate").multiply(BigDecimal.valueOf(100L))) + "%"));
                jsonObj.put("endrate", (Object)(df2.format(dynamicObject.getBigDecimal("endrate").multiply(BigDecimal.valueOf(100L))) + "%"));
                data.add((Object)jsonObj);
            }
            ArrayList mustFillColumn = new ArrayList(10);
            String url = POIHelper.exportExcel((String)this.fileName, (String)this.sheetName, (String[])this.header, (String[])COLUMNKEY, mustFillColumn, (JSONArray)data);
            this.getView().download(url);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"DeptPlanReachRatePlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (StringUtils.equals((CharSequence)"queryclick", (CharSequence)operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]))) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"dataap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("thisweek", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private Set<Object> getControlLevelSet(DynamicObject thisModel) {
        DynamicObjectCollection controlLevelCol = thisModel.getDynamicObjectCollection("controllevels");
        HashSet<Object> controlLevelIdSet = new HashSet<Object>();
        if (controlLevelCol != null && controlLevelCol.size() > 0) {
            for (DynamicObject dynamicObject : controlLevelCol) {
                DynamicObject controlLevel = dynamicObject.getDynamicObject("fbasedataid");
                if (controlLevel == null) continue;
                controlLevelIdSet.add(controlLevel.getPkValue());
            }
        }
        return controlLevelIdSet;
    }

    private Set<Object> getTaskTypeIdSet(DynamicObject thisModel) {
        HashSet<Object> taskTypeIdSet = new HashSet<Object>();
        DynamicObjectCollection taskTypeCol = thisModel.getDynamicObjectCollection("tasktypes");
        if (taskTypeCol != null && taskTypeCol.size() > 0) {
            for (DynamicObject dynamicObject : taskTypeCol) {
                DynamicObject taskType = dynamicObject.getDynamicObject("fbasedataid");
                if (taskType == null) continue;
                taskTypeIdSet.add(taskType.getPkValue());
            }
        }
        return taskTypeIdSet;
    }

    private String[] getPlanTypeArr(DynamicObject thisModel) {
        String[] planTypeArr;
        String planTypes = thisModel.getString("plantypes");
        if (StringUtils.isNotBlank((CharSequence)planTypes) && (planTypeArr = planTypes.split(",")) != null && planTypeArr.length > 0) {
            return planTypeArr;
        }
        return null;
    }

    public void click(EventObject evt) {
        ChartClickEvent chartClickEvent;
        Chart chart;
        super.click(evt);
        String sourceName = evt.getSource().getClass().getName();
        if (StringUtils.equals((CharSequence)sourceName, (CharSequence)HistogramChart.class.getName()) && StringUtils.equals((CharSequence)"histogramchartap", (CharSequence)(chart = (chartClickEvent = (ChartClickEvent)evt).getSource()).getKey())) {
            String[] planTypeArr;
            Set<Object> taskTypeIdSet;
            String orgName = chartClickEvent.getName();
            String seriesName = chartClickEvent.getSeriesName();
            if (orgName == null || seriesName == null) {
                return;
            }
            if (seriesName.contains("%")) {
                return;
            }
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)orgName)});
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u70b9\u51fb\u7684\u7ec4\u7ec7\u7684\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"DeptPlanReachRatePlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
            String completionStatus = "";
            if (StringUtils.equals((CharSequence)seriesName, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getName())) {
                completionStatus = CompletionStatusEnum.OVERDUECOMPLETE.getValue();
            } else if (StringUtils.equals((CharSequence)seriesName, (CharSequence)ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]))) {
                completionStatus = CompletionStatusEnum.OVERDUE.getValue();
            } else if (StringUtils.equals((CharSequence)seriesName, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getName())) {
                completionStatus = CompletionStatusEnum.ONTIMECOMPLETE.getValue();
            }
            if (StringUtils.isBlank((CharSequence)completionStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u70b9\u51fb\u7684\u56fe\u5757\u7684\u72b6\u6001\u4e0e\u7cfb\u7edf\u4efb\u52a1\u72b6\u6001\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeptPlanReachRatePlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            DynamicObject thisModel = this.getModel().getDataEntity();
            Set<Object> controlLevelIdSet = this.getControlLevelSet(thisModel);
            if (!controlLevelIdSet.isEmpty()) {
                paramMap.put("controllevels", controlLevelIdSet);
            }
            if (!(taskTypeIdSet = this.getTaskTypeIdSet(thisModel)).isEmpty()) {
                paramMap.put("tasktypes", taskTypeIdSet);
            }
            if ((planTypeArr = this.getPlanTypeArr(thisModel)) != null && planTypeArr.length > 0) {
                paramMap.put("plantypes", planTypeArr);
            }
            paramMap.put("beginDate", this.getRangeBeginDate(thisModel));
            paramMap.put("endDate", this.getRangeEndDate(thisModel));
            boolean containsub = thisModel.getBoolean("containsub");
            String dutys = thisModel.getString("dutys");
            paramMap.put("dutys", dutys);
            paramMap.put("containsub", containsub);
            paramMap.put("formId", "pmpm_tasklist");
            paramMap.put("orgId", org.getString("id"));
            paramMap.put("completionStatus", completionStatus);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private Date getRangeBeginDate(DynamicObject thisModel) {
        boolean thisWeek = thisModel.getBoolean("thisweek");
        boolean thisMonth = thisModel.getBoolean("thisMonth");
        boolean threeMonth = thisModel.getBoolean("threeMonth");
        Date nowDate = new Date();
        if (thisWeek) {
            Date firstDayOfThisWeek = DateUtil.getThisWeekMonday((Date)nowDate);
            return firstDayOfThisWeek;
        }
        if (thisMonth) {
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)nowDate);
            return firstDayOfThisMonth;
        }
        if (threeMonth) {
            Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth((Date)nowDate);
            Date firstDayOfPreTwoMonth = DateUtil.getFirstDayOfPreMonth((Date)firstDayOfPreMonth);
            return firstDayOfPreTwoMonth;
        }
        Date firstDayOfRange = thisModel.getDate("daterange_startdate");
        return firstDayOfRange;
    }

    private Date getRangeEndDate(DynamicObject thisModel) {
        boolean thisWeek = thisModel.getBoolean("thisweek");
        boolean thisMonth = thisModel.getBoolean("thisMonth");
        boolean threeMonth = thisModel.getBoolean("threeMonth");
        Date nowDate = new Date();
        if (thisWeek) {
            Date lastDayOfThisWeek = DateUtil.getThisWeekSunDay((Date)nowDate);
            return lastDayOfThisWeek;
        }
        if (thisMonth) {
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            return lastDayOfThisMonth;
        }
        if (threeMonth) {
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            return lastDayOfThisMonth;
        }
        Date lastDayOfRange = thisModel.getDate("daterange_enddate");
        return lastDayOfRange;
    }

    private void updateData() {
        DynamicObjectCollection orgCol = this.getModel().getDataEntity().getDynamicObjectCollection("orgs");
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : orgCol) {
            DynamicObject org = dynamicObject.getDynamicObject("fbasedataid");
            if (org == null) continue;
            orgIdList.add(org.getLong("id"));
        }
        boolean containsub = this.getModel().getDataEntity().getBoolean("containsub");
        if (containsub) {
            orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIdList, (boolean)true);
        }
        this.getModel().deleteEntryData("entryentity");
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject[] taskArr = this.getTaskArr(thisModel, orgIdList);
        if (taskArr == null || taskArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u5207\u6362\u6761\u4ef6\u67e5\u8be2\u3002", (String)"DeptPlanReachRatePlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"dataap"});
        Map<String, Map<String, Object>> orgDataMap = this.handledata(taskArr, orgIdList);
        ArrayList<Integer> onTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeNotEndList = new ArrayList<Integer>(10);
        ArrayList<String> projectNameList = new ArrayList<String>(10);
        ArrayList<BigDecimal> endRateList = new ArrayList<BigDecimal>(10);
        for (Map.Entry<String, Map<String, Object>> data : orgDataMap.entrySet()) {
            Map<String, Object> taskQtyMap = data.getValue();
            String orgName = taskQtyMap.get("orgname").toString();
            Integer onTimeEnd = (Integer)taskQtyMap.get("ontimeend");
            Integer overTimeEnd = (Integer)taskQtyMap.get("overtimeend");
            Integer overTimeNotEnd = (Integer)taskQtyMap.get("overtimenotend");
            Integer planEnd = (Integer)taskQtyMap.get("planend");
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("org", (Object)data.getKey(), rowIndex);
            this.getModel().setValue("planend", (Object)planEnd, rowIndex);
            onTimeEndList.add(onTimeEnd);
            this.getModel().setValue("ontimeend", (Object)onTimeEnd, rowIndex);
            overTimeEndList.add(overTimeEnd);
            this.getModel().setValue("overtimeend", (Object)overTimeEnd, rowIndex);
            overTimeNotEndList.add(overTimeNotEnd);
            this.getModel().setValue("overtimenotend", (Object)overTimeNotEnd, rowIndex);
            projectNameList.add(orgName);
            Integer totalEnd = onTimeEnd + overTimeEnd;
            BigDecimal endRate = BigDecimal.ZERO;
            if (planEnd != 0) {
                endRate = BigDecimal.valueOf(totalEnd.intValue()).divide(BigDecimal.valueOf(planEnd.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            }
            endRateList.add(endRate);
        }
        for (int i = projectNameList.size(); i < 8; ++i) {
            projectNameList.add("");
        }
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        histogramChart.clearData();
        Axis xAxis = histogramChart.createXAxis("", projectNameList);
        if (projectNameList.size() > 8) {
            HashMap<String, Integer> axisLabelMap = new HashMap<String, Integer>();
            axisLabelMap.put("interval", 0);
            axisLabelMap.put("rotate", -40);
            xAxis.setPropValue("axisLabel", axisLabelMap);
        }
        kd.bos.form.chart.Label plLabel = new kd.bos.form.chart.Label();
        plLabel.setShow(true);
        plLabel.setFontSize("14");
        plLabel.setPosition(Position.inside);
        histogramChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"DeptPlanReachRatePlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), AxisType.value);
        BarSeries series = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        series.setBarWidth("50px");
        series.setStack("aa");
        series.setData((Number[])onTimeEndList.toArray(new Integer[onTimeEndList.size()]));
        series.setColor("#83F348");
        series.setLabel(plLabel);
        BarSeries series1 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        series1.setBarWidth("50px");
        series1.setStack("aa");
        series1.setData((Number[])overTimeEndList.toArray(new Integer[overTimeEndList.size()]));
        series1.setColor("#2DECE9");
        series1.setLabel(plLabel);
        BarSeries series2 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        series2.setBarWidth("50px");
        series2.setStack("aa");
        series2.setData((Number[])overTimeNotEndList.toArray(new Integer[overTimeNotEndList.size()]));
        series2.setColor("#FF585A");
        series2.setLabel(plLabel);
        Axis yAxis2 = histogramChart.createYAxis(ResManager.loadKDString((String)"\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formatter", "{value}%");
        yAxis2.setPropValue("axisLabel", map);
        yAxis2.setMax((Number)100);
        LineSeries lineSeries = histogramChart.createLineSeries(ResManager.loadKDString((String)"\u5b8c\u6210\u7387\uff08%\uff09", (String)"DeptPlanReachRatePlugin_18", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        lineSeries.setData((Number[])endRateList.toArray(new BigDecimal[endRateList.size()]));
        HashMap itemStyleMap = new HashMap();
        HashMap<String, String> normalMap = new HashMap<String, String>();
        normalMap.put("color", "#1A94E6");
        itemStyleMap.put("normal", normalMap);
        lineSeries.setPropValue("itemStyle", itemStyleMap);
        lineSeries.setYAxisIndex(1);
        histogramChart.setShowTooltip(true);
        histogramChart.setShowLegend(true);
        histogramChart.setShowTitle(false);
        histogramChart.refresh();
    }

    private QFilter getPlanEndTimeFilter(DynamicObject thisModel) {
        QFilter planEndTimeFilter = null;
        boolean thisWeek = thisModel.getBoolean("thisweek");
        boolean thisMonth = thisModel.getBoolean("thisMonth");
        boolean threeMonth = thisModel.getBoolean("threeMonth");
        Date nowDate = new Date();
        if (thisWeek) {
            Date firstDayOfThisWeek = DateUtil.getThisWeekMonday((Date)nowDate);
            Date lastDayOfThisWeek = DateUtil.getThisWeekSunDay((Date)nowDate);
            QFilter largeFirstDayOfThisWeek = new QFilter("planendtime", ">=", (Object)firstDayOfThisWeek);
            QFilter lessLastDayOfThisWeek = new QFilter("planendtime", "<=", (Object)lastDayOfThisWeek);
            planEndTimeFilter = largeFirstDayOfThisWeek.and(lessLastDayOfThisWeek);
        } else if (thisMonth) {
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)nowDate);
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            QFilter largeFirstDayOfThisMonth = new QFilter("planendtime", ">=", (Object)firstDayOfThisMonth);
            QFilter lessLastDatOfThisMonth = new QFilter("planendtime", "<=", (Object)lastDayOfThisMonth);
            planEndTimeFilter = largeFirstDayOfThisMonth.and(lessLastDatOfThisMonth);
        } else if (threeMonth) {
            Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth((Date)nowDate);
            Date firstDayOfPreTwoMonth = DateUtil.getFirstDayOfPreMonth((Date)firstDayOfPreMonth);
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            QFilter largeFirstDayOfPreTwoMonth = new QFilter("planendtime", ">=", (Object)firstDayOfPreTwoMonth);
            QFilter lessLastDayOfThisMonth = new QFilter("planendtime", "<=", (Object)lastDayOfThisMonth);
            planEndTimeFilter = largeFirstDayOfPreTwoMonth.and(lessLastDayOfThisMonth);
        } else {
            Date firstDayOfRange = thisModel.getDate("daterange_startdate");
            Date lastDayOfRange = thisModel.getDate("daterange_enddate");
            if (firstDayOfRange != null && lastDayOfRange != null) {
                QFilter largeFirstDayOfRange = new QFilter("planendtime", ">=", (Object)firstDayOfRange);
                QFilter lessLastDayOfRange = new QFilter("planendtime", "<=", (Object)lastDayOfRange);
                planEndTimeFilter = largeFirstDayOfRange.and(lessLastDayOfRange);
            }
        }
        return planEndTimeFilter;
    }

    private DynamicObject[] getTaskArr(DynamicObject thisModel, List<Long> orgIdList) {
        String[] dutyArr;
        String dutys;
        String[] planTypeArr;
        Set<Object> taskTypeIdSet;
        QFilter commonFilter = this.getCommonFilter();
        QFilter controlLevelFilter = null;
        QFilter taskTypeFilter = null;
        QFilter planEndTimeFilter = this.getPlanEndTimeFilter(thisModel);
        QFilter planTypeQfilter = null;
        QFilter responsibleDeptFilter = null;
        QFilter cooperationdeptFilter = null;
        QFilter orgFilter = null;
        Set<Object> controlLevelIdSet = this.getControlLevelSet(thisModel);
        if (!controlLevelIdSet.isEmpty()) {
            controlLevelFilter = new QFilter("controllevel", "in", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(thisModel)).isEmpty()) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypeIdSet);
        }
        if ((planTypeArr = this.getPlanTypeArr(thisModel)) != null && planTypeArr.length != 0) {
            planTypeQfilter = new QFilter("belongplantype.plantype", "in", (Object)planTypeArr);
        }
        if (StringUtils.isNotBlank((CharSequence)(dutys = thisModel.getString("dutys"))) && (dutyArr = dutys.split(",")).length == 0) {
            responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
            cooperationdeptFilter = new QFilter("cooperationdept", "in", orgIdList);
            orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
        }
        if (dutys == null || StringUtils.contains((CharSequence)dutys, (CharSequence)"1") && StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
            responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
            cooperationdeptFilter = new QFilter("cooperationdept", "in", orgIdList);
            orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
        } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1")) {
            orgFilter = new QFilter("responsibledept", "in", orgIdList);
        } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
            orgFilter = new QFilter("cooperationdept", "in", orgIdList);
        }
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,majortype,planendtime,completionstatus,responsibledept,cooperationdept", (QFilter[])new QFilter[]{planEndTimeFilter, commonFilter, planTypeQfilter, controlLevelFilter, taskTypeFilter, orgFilter});
        return taskArr;
    }

    private Map<String, Map<String, Object>> handledata(DynamicObject[] taskArr, List<Long> orgIdList) {
        HashMap<String, Map<String, Object>> projectDataMap = new HashMap<String, Map<String, Object>>();
        for (DynamicObject task : taskArr) {
            DynamicObject responsibleDept = task.getDynamicObject("responsibledept");
            String status = task.getString("completionstatus");
            DynamicObject cooperationDept = task.getDynamicObject("cooperationdept");
            ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(10);
            dyList.add(responsibleDept);
            dyList.add(cooperationDept);
            for (DynamicObject org : dyList) {
                String orgId;
                if (org == null || !orgIdList.contains(Long.valueOf(orgId = org.getString("id")))) continue;
                HashMap<String, Object> taskQtyMap = (HashMap<String, Object>)projectDataMap.get(orgId);
                if (taskQtyMap != null && !taskQtyMap.isEmpty()) {
                    Integer planEnd;
                    Integer n = planEnd = (Integer)taskQtyMap.get("planend");
                    Integer n2 = planEnd = Integer.valueOf(planEnd + 1);
                    taskQtyMap.put("planend", planEnd);
                    if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)status)) {
                        Integer onTimeEnd;
                        n2 = onTimeEnd = (Integer)taskQtyMap.get("ontimeend");
                        Integer n3 = onTimeEnd = Integer.valueOf(onTimeEnd + 1);
                        taskQtyMap.put("ontimeend", onTimeEnd);
                    } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)status)) {
                        Integer overTimeEnd;
                        n2 = overTimeEnd = (Integer)taskQtyMap.get("overtimeend");
                        Integer n4 = overTimeEnd = Integer.valueOf(overTimeEnd + 1);
                        taskQtyMap.put("overtimeend", overTimeEnd);
                    } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)status)) {
                        Integer overTimeNotEnd;
                        n2 = overTimeNotEnd = (Integer)taskQtyMap.get("overtimenotend");
                        Integer n5 = overTimeNotEnd = Integer.valueOf(overTimeNotEnd + 1);
                        taskQtyMap.put("overtimenotend", overTimeNotEnd);
                    }
                    projectDataMap.put(orgId, taskQtyMap);
                    continue;
                }
                taskQtyMap = new HashMap<String, Object>();
                int planEnd = 0;
                int onTimeEnd = 0;
                int overTimeEnd = 0;
                int overTimeNotEnd = 0;
                ++planEnd;
                taskQtyMap.put("orgname", org.getString("name"));
                if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)status)) {
                    ++onTimeEnd;
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)status)) {
                    ++overTimeEnd;
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)status)) {
                    ++overTimeNotEnd;
                }
                taskQtyMap.put("planend", planEnd);
                taskQtyMap.put("ontimeend", onTimeEnd);
                taskQtyMap.put("overtimeend", overTimeEnd);
                taskQtyMap.put("overtimenotend", overTimeNotEnd);
                projectDataMap.put(orgId, taskQtyMap);
            }
        }
        return projectDataMap;
    }

    private QFilter getCommonFilter() {
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", (Object)"0");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return sourceTaskFilter.and(statusFilter);
    }
}

