/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.PlanningCycleEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmListPlugin;

public class FuncPlanMonitorListPlugin
extends AbstractPmpmListPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String KEY_TREEENTRYENTITY = "taskentity";
    private static final String CODE_EXPORT = "export";
    private static final String CODE_SEARCH = "search";
    private static final String CODE_QUERYCLICK = "queryclick";
    private static String[] COLUMNKEY = new String[]{"taskname", "completionstatus", "project", "controllevelname", "majortypename", "tasktype", "absoluteduration", "percent", "pretaskname", "planstarttime", "planendtime", "aimfinishtime", "comptimedeviation", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname", "resultdoc"};
    private String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"FuncPlanMonitorListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"FuncPlanMonitorListPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"FuncPlanMonitorListPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"FuncPlanMonitorListPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"FuncPlanMonitorListPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"FuncPlanMonitorListPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"FuncPlanMonitorListPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6\uff08%\uff09", (String)"FuncPlanMonitorListPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"FuncPlanMonitorListPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"FuncPlanMonitorListPlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"FuncPlanMonitorListPlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76ee\u6807\u5b8c\u6210\u65f6\u95f4", (String)"FuncPlanMonitorListPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u504f\u5dee", (String)"FuncPlanMonitorListPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"FuncPlanMonitorListPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"FuncPlanMonitorListPlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"FuncPlanMonitorListPlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u679c", (String)"FuncPlanMonitorListPlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0])};
    private Map<String, DynamicObject> mapAllTasks = null;

    private String getFileName() {
        return ResManager.loadKDString((String)"\u804c\u80fd\u8ba1\u5212\u76d1\u63a7", (String)"FuncPlanMonitorListPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"FuncPlanMonitorListPlugin_18", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit belongplantype = (BasedataEdit)this.getControl("belongplantype");
        belongplantype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)"org", (CharSequence)propName)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()), (String)"01", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pmpm"), (String)"pmpm_funcplanmonitor", (String)"47150e89000000ac");
            List allOrgIds = new ArrayList(10);
            if (hasPermOrgs != null) {
                if (!hasPermOrgs.hasAllOrgPerm()) {
                    allOrgIds = hasPermOrgs.getHasPermOrgs();
                } else {
                    ArrayList<Long> orgIds = new ArrayList<Long>(10);
                    orgIds.add(RequestContext.get().getOrgId());
                    allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("01"), orgIds, (boolean)true);
                }
            }
            QFilter orgFilter = new QFilter("id", "in", allOrgIds);
            showParameter.getListFilterParameter().getQFilters().add(orgFilter);
        } else if (StringUtils.equals((CharSequence)"belongplantype", (CharSequence)propName)) {
            this.beforeDoBelongPlanType(arg0);
        }
    }

    private void beforeDoBelongPlanType(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90", (String)"FuncPlanMonitorListPlugin_19", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Object planningcycle = this.getModel().getValue("planningcycle");
        if (planningcycle == null) {
            return;
        }
        Object plantime = this.getModel().getValue("plantime");
        if (plantime == null) {
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        qFilters.add(orgFilter);
        QFilter cycleFilter = new QFilter("planningcycle", "=", (Object)PlanningCycleEnum.getEnumByValue((Object)planningcycle));
        qFilters.add(cycleFilter);
        QFilter timeFilter = new QFilter("STARTTIME", "<=", plantime).and("ENDTIME", ">=", plantime);
        qFilters.add(timeFilter);
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        qFilters.add(planVersion);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpm_deptplan", (String)"id,taskentity,taskentity.taskid", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        HashSet<Object> allTaskids = new HashSet<Object>();
        if (plans == null || plans.length == 0) {
            return;
        }
        for (DynamicObject plan : plans) {
            DynamicObject[] taskentries = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY);
            if (taskentries == null || taskentries.isEmpty()) continue;
            for (DynamicObject entry : taskentries) {
                Object id = entry.get("taskid");
                allTaskids.add(id);
            }
        }
        if (allTaskids.isEmpty()) {
            return;
        }
        QFilter ids = new QFilter("id", "in", (Object)allTaskids.toArray());
        ArrayList<QFilter> idFilter = new ArrayList<QFilter>(10);
        idFilter.add(ids);
        DynamicObject[] allTasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,belongplantype", (QFilter[])idFilter.toArray(new QFilter[idFilter.size()]), (String)"taskseq");
        HashSet<Object> planTypeIdSet = new HashSet<Object>();
        for (DynamicObject task : allTasks) {
            DynamicObject belongplantype = task.getDynamicObject("belongplantype");
            if (belongplantype == null) continue;
            planTypeIdSet.add(belongplantype.getPkValue());
        }
        QFilter planTypeIdFilter = new QFilter("id", "in", planTypeIdSet);
        showParameter.getListFilterParameter().getQFilters().add(planTypeIdFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_EXPORT.equals(operateKey)) {
            this.doExportExcel();
        } else if (CODE_SEARCH.equals(operateKey)) {
            this.doSearch();
        } else if (CODE_QUERYCLICK.equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]))) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_25", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_25", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void doSearch() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object planningCycle = this.getModel().getValue("planningCycle");
        Object plantime = this.getModel().getValue("plantime");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7", (String)"FuncPlanMonitorListPlugin_21", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (planningCycle == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u5468\u671f", (String)"FuncPlanMonitorListPlugin_22", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (plantime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65f6\u95f4", (String)"FuncPlanMonitorListPlugin_23", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        FormDataModel dataModel = (FormDataModel)grid.getModel();
        dataModel.deleteEntryData(KEY_TREEENTRYENTITY);
        DynamicObject[] deptPlans = this.getDeptPlans(org, planningCycle, plantime);
        if (deptPlans == null || deptPlans.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"FuncPlanMonitorListPlugin_20", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> allTaskids = new ArrayList<Object>(10);
        HashMap<String, DynamicObject> taskEntryMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection entries = new DynamicObjectCollection();
        this.getTaskEntryFromDept(deptPlans, allTaskids, taskEntryMap, entries);
        if (allTaskids.isEmpty()) {
            return;
        }
        QFilter ids = new QFilter("id", "in", (Object)allTaskids.toArray());
        ArrayList<QFilter> idFilter = new ArrayList<QFilter>(10);
        idFilter.add(ids);
        DynamicObject[] allTasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,parent,tasktype,controllevel,planstarttime,planendtime,sourcetask,status,completionstatus,comptimedeviation,belongplantype,percent", (QFilter[])idFilter.toArray(new QFilter[idFilter.size()]), (String)"taskseq");
        this.mapAllTasks = new HashMap<String, DynamicObject>(16);
        HashMap<String, QFilter> mapFilters = new HashMap<String, QFilter>(16);
        this.constructTaskFilter(mapFilters);
        this.filterTask(taskEntryMap, allTasks, mapFilters);
        if (taskEntryMap.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"FuncPlanMonitorListPlugin_20", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.batchCreateTaskEntryRows(grid, taskEntryMap);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }

    private void getTaskEntryFromDept(DynamicObject[] deptPlans, List<Object> allTaskids, Map<String, DynamicObject> taskEntryMap, DynamicObjectCollection entries) {
        for (DynamicObject plan : deptPlans) {
            DynamicObjectCollection taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY);
            if (taskEntry == null || taskEntry.isEmpty()) continue;
            entries.addAll((Collection)taskEntry);
        }
        for (DynamicObject entry : entries) {
            Object id = entry.get("taskid");
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmpm_task");
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            if (sourceTask != null) {
                id = sourceTask.getPkValue();
            }
            allTaskids.add(id);
            taskEntryMap.put(id.toString(), entry);
        }
    }

    private void batchCreateTaskEntryRows(TreeEntryGrid grid, Map<String, DynamicObject> mapEntries) {
        DynamicObjectCollection afterFilterEntries = new DynamicObjectCollection();
        Iterator<Map.Entry<String, DynamicObject>> iter = mapEntries.entrySet().iterator();
        while (iter.hasNext()) {
            afterFilterEntries.add((Object)iter.next().getValue());
        }
        afterFilterEntries.sort(Comparator.comparing(obj -> obj.getInt("seq")));
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(KEY_TREEENTRYENTITY, afterFilterEntries.size());
        int seq = 0;
        for (DynamicObject entry : afterFilterEntries) {
            model.setValue("taskentity.id", entry.getPkValue(), seq);
            model.setValue("task", entry.get("taskId"), seq);
            model.setValue("pid", entry.get("pid"), seq);
            DynamicObject task = this.mapAllTasks.get(entry.getString("taskId"));
            if (task != null) {
                model.setValue("completionstatusvalue", task.get("completionstatus"), seq);
            }
            ++seq;
        }
        this.setTextColor();
        grid.setCollapse(false);
    }

    private void filterTask(Map<String, DynamicObject> mapEntries, DynamicObject[] allTasks, Map<String, QFilter> mapFilters) {
        for (DynamicObject task : allTasks) {
            this.mapAllTasks.put(task.getPkValue().toString(), task);
            Object controllevel = task.get("controllevel.id");
            if (mapFilters.get("controllevel.id") != null) {
                Object levelIds = mapFilters.get("controllevel.id").getValue();
                ArrayList<Long> levelList = new ArrayList<Long>(10);
                if (levelIds instanceof List) {
                    for (Object obj : (List)levelIds) {
                        levelList.add((Long)obj);
                    }
                }
                if (!levelList.isEmpty() && !levelList.contains(controllevel)) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            DynamicObject taskType = task.getDynamicObject("tasktype");
            if (mapFilters.get("tasktype.id") != null && taskType != null) {
                Object typeIds = mapFilters.get("tasktype.id").getValue();
                ArrayList<Long> taskTypeList = new ArrayList<Long>(10);
                if (typeIds instanceof List) {
                    Object obj;
                    obj = ((List)typeIds).iterator();
                    while (obj.hasNext()) {
                        Object obj2 = obj.next();
                        taskTypeList.add((Long)obj2);
                    }
                }
                if (!taskTypeList.isEmpty() && !taskTypeList.contains(taskType.getPkValue())) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            Object completionStatus = task.get("completionstatus");
            if (mapFilters.get("completionstatus") != null) {
                Object statusIds = mapFilters.get("completionstatus").getValue();
                ArrayList<String> statusList = new ArrayList<String>(10);
                if (statusIds instanceof List) {
                    for (Object obj : (List)statusIds) {
                        statusList.add((String)obj);
                    }
                }
                if (!statusList.isEmpty() && !statusList.contains(completionStatus)) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            Object belongPlanType = task.get("belongplantype.id");
            if (mapFilters.get("belongplantype.id") == null) continue;
            Object planTypeIds = mapFilters.get("belongplantype.id").getValue();
            ArrayList<Long> belongPlantypeList = new ArrayList<Long>(10);
            if (planTypeIds instanceof List) {
                for (Object obj : (List)planTypeIds) {
                    belongPlantypeList.add((Long)obj);
                }
            }
            if (belongPlantypeList.isEmpty() || belongPlantypeList.contains(belongPlanType)) continue;
            mapEntries.remove(task.getPkValue().toString());
        }
    }

    private void constructTaskFilter(Map<String, QFilter> mapFilters) {
        DynamicObjectCollection belongPlanTypes;
        Object completionStatusObj;
        DynamicObjectCollection tasktypes;
        DynamicObjectCollection controllevels = (DynamicObjectCollection)this.getModel().getValue("controllevel");
        if (!controllevels.isEmpty()) {
            QFilter filter1 = new QFilter("controllevel.id", "in", controllevels.stream().map(controllevel -> controllevel.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("controllevel.id", filter1);
        }
        if (!(tasktypes = (DynamicObjectCollection)this.getModel().getValue("tasktype")).isEmpty()) {
            QFilter filter2 = new QFilter("tasktype.id", "in", tasktypes.stream().map(tasktype -> tasktype.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("tasktype.id", filter2);
        }
        if ((completionStatusObj = this.getModel().getValue("completionstatus")) != null) {
            String completionStatusText = this.getModel().getValue("completionstatus").toString();
            String[] completionStatusArray = completionStatusText.split(",");
            ArrayList<String> compleStatusList = new ArrayList<String>(10);
            for (String status : completionStatusArray) {
                if (status == null) continue;
                compleStatusList.add(status);
            }
            QFilter filter3 = new QFilter("completionstatus", "in", compleStatusList);
            mapFilters.put("completionstatus", filter3);
        }
        if (!(belongPlanTypes = (DynamicObjectCollection)this.getModel().getValue("belongplantype")).isEmpty()) {
            QFilter filter4 = new QFilter("belongplantype.id", "in", belongPlanTypes.stream().map(belongplantype -> belongplantype.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("belongplantype.id", filter4);
        }
    }

    private DynamicObject[] getDeptPlans(DynamicObject org, Object planningCycle, Object plantime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        qFilters.add(orgFilter);
        QFilter cycleFilter = new QFilter("planningcycle", "=", (Object)PlanningCycleEnum.getEnumByValue((Object)planningCycle));
        qFilters.add(cycleFilter);
        QFilter timeFilter = new QFilter("STARTTIME", "<=", plantime).and("ENDTIME", ">=", plantime);
        qFilters.add(timeFilter);
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        qFilters.add(planVersion);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpm_deptplan", (String)"id,taskentity,taskentity.taskid,taskentity.pid,taskentity.seq,taskentity.level,taskentity.isleaf", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return plans;
    }

    private void doExportExcel() {
        JSONArray data;
        DynamicObjectCollection rowDatas = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (!rowDatas.isEmpty()) {
            data = new JSONArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject row : rowDatas) {
                JSONObject obj = new JSONObject();
                DynamicObject task = row.getDynamicObject("task");
                obj.put("taskname", (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("completionstatus", (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getValue());
                obj.put("project", task.getDynamicObject("project") == null ? null : task.getDynamicObject("project").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("controllevelname", task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("majortypename", task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("tasktype", task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("absoluteduration", (Object)task.getInt("absoluteduration"));
                obj.put("percent", (Object)task.getBigDecimal("percent").setScale(2));
                obj.put("pretaskname", task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("planstarttime", (Object)sdf.format(task.getDate("planstarttime")));
                obj.put("planendtime", (Object)sdf.format(task.getDate("planendtime")));
                Date aimFinishTime = task.getDate("aimfinishtime");
                if (aimFinishTime == null) {
                    obj.put("aimfinishtime", (Object)aimFinishTime);
                } else {
                    obj.put("aimfinishtime", (Object)sdf.format(aimFinishTime));
                }
                obj.put("comptimedeviation", (Object)task.getInt("comptimedeviation"));
                obj.put("responsiblepersonname", task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("responsibledeptname", task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("cooperationpersonsname", task.getDynamicObject("cooperationperson") == null ? null : task.getDynamicObject("cooperationperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("resultdoc", task.get("resultdoc"));
                data.add((Object)obj);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"FuncPlanMonitorListPlugin_20", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
        this.getView().download(url);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        if (StringUtils.equals((CharSequence)"taskname", (CharSequence)fieldName)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
            if (task != null) {
                paramMap.put("formId", "pmpm_reporttaskview");
                paramMap.put("pkId", String.valueOf(task.getPkValue()));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("planningcycle".equalsIgnoreCase(key) || "plantime".equalsIgnoreCase(key)) {
            this.setTimeRange();
        }
    }

    private void setTimeRange() {
        String planningcycle = (String)this.getModel().getValue("planningcycle");
        Date plantime = (Date)this.getModel().getValue("plantime");
        Date start = null;
        Date end = null;
        if (null != plantime) {
            if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.YEAR.getValue())) {
                start = DateUtil.getYearFirst((Date)plantime);
                end = DateUtil.getYearLast((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.HALFYEAR.getValue())) {
                start = DateUtil.getHalfYearStartTime((Date)plantime);
                end = DateUtil.getHalfYearEndTime((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.QUART.getValue())) {
                start = DateUtil.getQuarterStartTime((Date)plantime);
                end = DateUtil.getQuarterEndTime((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.MONTH.getValue())) {
                start = DateUtil.getFirstDayOfThisMonth((Date)plantime);
                end = DateUtil.getLastDayOfThisMonth((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.WEEK.getValue())) {
                start = DateUtil.getThisWeekMonday((Date)plantime);
                end = DateUtil.getThisWeekSunDay((Date)plantime);
            }
        }
        this.getModel().setValue("starttime", start);
        this.getModel().setValue("endtime", end);
    }

    private void setTextColor() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        int rows = this.getModel().getEntryRowCount(KEY_TREEENTRYENTITY);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        for (int i = 0; i < rows; ++i) {
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("comptimedeviation");
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", i);
            BigDecimal comptimedeviation = new BigDecimal(task.getString("comptimedeviation"));
            if (BigDecimal.ZERO.compareTo(comptimedeviation) > 0) {
                style.setForeColor("red");
            } else if (BigDecimal.ZERO.compareTo(comptimedeviation) < 0) {
                style.setForeColor("green");
            }
            styles.add(style);
        }
        grid.setCellStyle(styles);
    }
}

