/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.MajorplanConstant;
import kd.pmgt.pmbs.business.model.pmpm.TaskConstant;
import kd.pmgt.pmpm.common.utils.PlanEntryUtil;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmBillPlugin;

public class MajorPlanAdjustComparePlugin
extends AbstractPmpmBillPlugin
implements TabSelectListener {
    private static final String KEY_ADJUSTTAB = "adjusttab";
    private static final String KEY_TAB = "tabap";
    private static final String KEY_CONTROLLEVELFILTER = "controllevelfilter";
    private static final String KEY_DISPLAYFILTER = "displayfilter";
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String KEY_SEQ = "seq";
    private static final String KEY_TASKID = "taskid";
    private static final String KEY_PRECHANGETASKID = "prechangetaskid";
    private static final String KEY_PARENT = "parent";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_TASK = "task";
    private static final String KEY_TASKNAME = "taskname";
    private static final String KEY_TASKCONTROLLEVEL = "taskcontrollevel";
    private static final String KEY_TASKTYPE = "tasktype";
    private static final String KEY_RESPONSIBLEPERSON = "responsibleperson";
    private static final String KEY_STARTTIME = "planstarttime0";
    private static final String KEY_ENDTIME = "planendtime0";
    private static final String KEY_AIMFINISHTIME = "aimfinishtime0";
    private static final String KEY_ABSDURATION = "absoluteduration0";
    private static final String KEY_SPECIALTASK = "specialtask";
    private static final String KEY_STARTTIME1 = "planstarttime1";
    private static final String KEY_STARTTIME2 = "planstarttime2";
    private static final String KEY_ENDTIME1 = "planendtime1";
    private static final String KEY_ENDTIME2 = "planendtime2";
    private static final String KEY_AIMFINISHTIME1 = "aimfinishtime1";
    private static final String KEY_AIMFINISHTIME2 = "aimfinishtime2";
    private static final String KEY_ABSDURATION1 = "absoluteduration1";
    private static final String KEY_ABSDURATION2 = "absoluteduration2";
    private static final String KEY_ABSDURATION3 = "absoluteduration3";
    private static final String KEY_ISADJUST = "adjustedtask";
    private SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(KEY_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        if (KEY_ADJUSTTAB.equals(tabKey)) {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_CONTROLLEVELFILTER, null);
            this.getModel().setValue(KEY_DISPLAYFILTER, (Object)Boolean.FALSE);
            this.getView().updateView(KEY_CONTROLLEVELFILTER);
            this.getView().updateView(KEY_DISPLAYFILTER);
            this.getModel().endInit();
            PlanEntryUtil.saveTask((IFormView)this.getView(), (IDataModel)this.getModel());
            DynamicObject basePlan = (DynamicObject)this.getModel().getValue("prechangeplan");
            if (basePlan == null) {
                return;
            }
            Object basePlanId = basePlan.getPkValue();
            Object changedPlanId = this.getModel().getDataEntity().getPkValue();
            this.loadData(basePlanId, changedPlanId, null, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_CONTROLLEVELFILTER.equals(key) || KEY_DISPLAYFILTER.equals(key)) {
            DynamicObject basePlan = (DynamicObject)this.getModel().getValue("prechangeplan");
            if (basePlan == null) {
                return;
            }
            Object basePlanId = basePlan.getPkValue();
            Object changedPlanId = this.getModel().getDataEntity().getPkValue();
            DynamicObject controlLevel = (DynamicObject)this.getModel().getValue(KEY_CONTROLLEVELFILTER);
            boolean isDisplay = Boolean.parseBoolean(this.getModel().getValue(KEY_DISPLAYFILTER).toString());
            this.loadData(basePlanId, changedPlanId, controlLevel, isDisplay);
        }
    }

    private void loadData(Object basePlanId, Object changedPlanId, DynamicObject controlLevel, boolean isDisplay) {
        JSONObject data = this.getTaskData(basePlanId, changedPlanId);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONArray taskArray = data.getJSONArray(KEY_TASK);
        taskArray.sort(Comparator.comparing(obj -> ((JSONObject)obj).getInteger(KEY_SEQ)));
        List allTaskIds = taskArray.stream().map(obj -> ((JSONObject)obj).getString(KEY_TASKID)).collect(Collectors.toList());
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        IDataModel model = treeGrid.getModel();
        model.deleteEntryData(KEY_TREEENTRYENTITY);
        if (!isDisplay && controlLevel == null) {
            treeGrid.setCollapse(false);
            JSONArray commonArray = new JSONArray();
            JSONArray rootArray = new JSONArray();
            for (Object obj2 : taskArray) {
                JSONObject task = (JSONObject)obj2;
                commonArray.add((Object)task);
                if (allTaskIds.contains(task.getString(KEY_PARENT))) continue;
                rootArray.add((Object)task);
            }
            this.fillTreeList(model, rootArray, commonArray, true, 0);
        } else {
            JSONArray dataArray = new JSONArray();
            for (Object obj3 : taskArray) {
                JSONObject task = (JSONObject)obj3;
                Object level = task.get((Object)KEY_TASKCONTROLLEVEL);
                boolean display = task.getBoolean(KEY_ISADJUST);
                if (controlLevel == null) {
                    if (!isDisplay || isDisplay != display) continue;
                    dataArray.add((Object)task);
                    continue;
                }
                if (isDisplay && isDisplay == display && controlLevel.getPkValue().toString().equals(level.toString())) {
                    dataArray.add((Object)task);
                    continue;
                }
                if (isDisplay || !controlLevel.getPkValue().toString().equals(level.toString())) continue;
                dataArray.add((Object)task);
            }
            this.fillList(model, dataArray);
        }
        this.initStyleTreeEntity(treeGrid);
    }

    private JSONObject getTaskData(Object basePlanId, Object changedPlanId) {
        DynamicObject[] compareTasks;
        DynamicObject[] baseTasks;
        if (null == basePlanId && changedPlanId != null) {
            return null;
        }
        JSONObject data = new JSONObject();
        HashMap<Object, JSONObject> tasksMap = new HashMap<Object, JSONObject>();
        DynamicObject basePlan = BusinessDataServiceHelper.loadSingle((Object)basePlanId, (DynamicObjectType)MajorplanConstant.dt);
        if (basePlan == null) {
            return null;
        }
        DynamicObjectCollection baseVersionEntries = basePlan.getDynamicObjectCollection("taskentity");
        if (baseVersionEntries == null || baseVersionEntries.isEmpty()) {
            return null;
        }
        for (DynamicObject dynamicObject : baseTasks = this.getTasksByEntry(baseVersionEntries)) {
            this.getNewArrayByTask(tasksMap, dynamicObject, true, false);
        }
        DynamicObject compareVersion = BusinessDataServiceHelper.loadSingle((Object)changedPlanId, (DynamicObjectType)MajorplanConstant.dt);
        DynamicObjectCollection compareVersionEntries = compareVersion.getDynamicObjectCollection("taskentity");
        block1: for (DynamicObject compareTask : compareTasks = this.getTasksByEntry(compareVersionEntries)) {
            for (DynamicObject baseTask : baseTasks) {
                DynamicObject basePreChangeTask = baseTask.getDynamicObject("prechangetask");
                if (basePreChangeTask == null) {
                    if (baseTask.getPkValue().toString().equals(compareTask.getPkValue().toString())) {
                        this.getNewArrayByTask(tasksMap, compareTask, false, false);
                        continue block1;
                    }
                    this.getNewArrayByTask(tasksMap, compareTask, false, true);
                    continue;
                }
                DynamicObject comparePreChangeTask = compareTask.getDynamicObject("prechangetask");
                if (comparePreChangeTask == null) {
                    if (basePreChangeTask.getPkValue().toString().equals(compareTask.getPkValue().toString())) {
                        this.getNewArrayByTask(tasksMap, compareTask, false, false);
                        continue block1;
                    }
                    this.getNewArrayByTask(tasksMap, compareTask, false, true);
                    continue;
                }
                if (basePreChangeTask.getPkValue().toString().equals(comparePreChangeTask.getPkValue().toString())) {
                    this.getNewArrayByTask(tasksMap, compareTask, false, false);
                    continue block1;
                }
                this.getNewArrayByTask(tasksMap, compareTask, false, true);
            }
        }
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry task : tasksMap.entrySet()) {
            jSONArray.add(task.getValue());
        }
        data.put(KEY_TASK, (Object)jSONArray);
        return data;
    }

    private Map<Object, JSONObject> getNewArrayByTask(Map<Object, JSONObject> tasksMap, DynamicObject task, boolean isOldVersion, boolean isSpecial) {
        Object taskId = task.getPkValue();
        DynamicObject preChangeTask = task.getDynamicObject("prechangetask");
        Object preChangeTaskId = null;
        preChangeTaskId = preChangeTask != null ? preChangeTask.getPkValue() : taskId;
        JSONObject taskJson = null;
        boolean isExist = false;
        if (tasksMap.get(preChangeTaskId) != null) {
            taskJson = tasksMap.get(preChangeTaskId);
            isExist = true;
        }
        if (!isExist) {
            taskJson = new JSONObject();
            taskJson.put(KEY_SEQ, (Object)task.getInt("taskseq"));
            taskJson.put(KEY_TASKID, (Object)taskId.toString());
            taskJson.put(KEY_SPECIALTASK, (Object)isSpecial);
            taskJson.put(KEY_PRECHANGETASKID, (Object)preChangeTaskId.toString());
            DynamicObject parent = task.getDynamicObject(KEY_PARENT);
            taskJson.put(KEY_PARENT, parent == null ? null : parent.getPkValue().toString());
            taskJson.put(KEY_LEVEL, (Object)task.getInt(KEY_LEVEL));
            taskJson.put(KEY_TASKNAME, (Object)task.getString("name"));
            DynamicObject ctrllevel = task.getDynamicObject("controllevel");
            taskJson.put(KEY_TASKCONTROLLEVEL, ctrllevel == null ? null : ctrllevel.getPkValue().toString());
            DynamicObject tasktype = task.getDynamicObject(KEY_TASKTYPE);
            taskJson.put(KEY_TASKTYPE, tasktype == null ? null : tasktype.getPkValue().toString());
            DynamicObject responsibleperson = task.getDynamicObject(KEY_RESPONSIBLEPERSON);
            taskJson.put(KEY_RESPONSIBLEPERSON, responsibleperson == null ? null : responsibleperson.getPkValue().toString());
        } else {
            taskJson.put(KEY_LEVEL, (Object)task.getString(KEY_LEVEL));
            taskJson.put(KEY_TASKNAME, (Object)task.getString("name"));
            DynamicObject ctrllevel = task.getDynamicObject("controllevel");
            taskJson.put(KEY_TASKCONTROLLEVEL, ctrllevel == null ? null : ctrllevel.getPkValue().toString());
            DynamicObject tasktype = task.getDynamicObject(KEY_TASKTYPE);
            taskJson.put(KEY_TASKTYPE, tasktype == null ? null : tasktype.getPkValue().toString());
            DynamicObject responsibleperson = task.getDynamicObject(KEY_RESPONSIBLEPERSON);
            taskJson.put(KEY_RESPONSIBLEPERSON, responsibleperson == null ? null : responsibleperson.getPkValue().toString());
        }
        boolean startTimeIsAdjust = true;
        JSONObject planstarttime = taskJson.getJSONObject(KEY_STARTTIME);
        if (planstarttime == null) {
            planstarttime = new JSONObject();
        }
        Date startDate = task.getDate("planstarttime");
        if (isOldVersion) {
            planstarttime.put(KEY_STARTTIME1, startDate == null ? null : this.SDF.format(startDate));
        } else {
            planstarttime.put(KEY_STARTTIME2, startDate == null ? null : this.SDF.format(startDate));
            JSONObject jsonStartTime = taskJson.getJSONObject(KEY_STARTTIME);
            if (jsonStartTime != null && !jsonStartTime.isEmpty()) {
                Date startTime1 = jsonStartTime.getDate(KEY_STARTTIME1);
                Date startTime2 = jsonStartTime.getDate(KEY_STARTTIME2);
                if (startTime1 != null && startTime2 != null && startTime1.compareTo(startTime2) == 0) {
                    startTimeIsAdjust = false;
                }
            }
        }
        taskJson.put(KEY_STARTTIME, (Object)planstarttime);
        boolean endtimeIsAdjust = true;
        JSONObject planendtime = taskJson.getJSONObject(KEY_ENDTIME);
        if (planendtime == null) {
            planendtime = new JSONObject();
        }
        Date endDate = task.getDate("planendtime");
        if (isOldVersion) {
            planendtime.put(KEY_ENDTIME1, endDate == null ? null : this.SDF.format(endDate));
        } else {
            planendtime.put(KEY_ENDTIME2, endDate == null ? null : this.SDF.format(endDate));
            JSONObject jsonEndTime = taskJson.getJSONObject(KEY_ENDTIME);
            if (jsonEndTime != null && !jsonEndTime.isEmpty()) {
                Date endTime1 = jsonEndTime.getDate(KEY_ENDTIME1);
                Date endTime2 = jsonEndTime.getDate(KEY_ENDTIME2);
                if (endTime1 != null && endTime2 != null && endTime1.compareTo(endTime2) == 0) {
                    endtimeIsAdjust = false;
                }
            }
        }
        taskJson.put(KEY_ENDTIME, (Object)planendtime);
        boolean aimfinishtimeIsAdjust = true;
        JSONObject planaimfinishtime = taskJson.getJSONObject(KEY_AIMFINISHTIME);
        if (planaimfinishtime == null) {
            planaimfinishtime = new JSONObject();
        }
        Date aimFinishDate = task.getDate("aimfinishtime");
        if (isOldVersion) {
            planaimfinishtime.put(KEY_AIMFINISHTIME1, aimFinishDate == null ? null : this.SDF.format(aimFinishDate));
        } else {
            planaimfinishtime.put(KEY_AIMFINISHTIME2, aimFinishDate == null ? null : this.SDF.format(aimFinishDate));
            JSONObject jsonAimFinishTime = taskJson.getJSONObject(KEY_AIMFINISHTIME);
            if (jsonAimFinishTime != null && !jsonAimFinishTime.isEmpty()) {
                Date aimFinishTime1 = jsonAimFinishTime.getDate(KEY_AIMFINISHTIME1);
                Date aimFinishTime2 = jsonAimFinishTime.getDate(KEY_AIMFINISHTIME2);
                if (aimFinishTime1 != null && aimFinishTime2 != null && aimFinishTime1.compareTo(aimFinishTime2) == 0) {
                    aimfinishtimeIsAdjust = false;
                }
            }
        }
        taskJson.put(KEY_AIMFINISHTIME, (Object)planaimfinishtime);
        boolean absolutedurationIsAdjust = true;
        JSONObject absoluteduration = taskJson.getJSONObject(KEY_ABSDURATION);
        if (absoluteduration == null) {
            absoluteduration = new JSONObject();
        }
        BigDecimal abs = task.getBigDecimal("absoluteduration");
        if (isOldVersion) {
            absoluteduration.put(KEY_ABSDURATION1, (Object)abs);
        } else {
            absoluteduration.put(KEY_ABSDURATION2, (Object)abs);
            JSONObject jsonAbs = taskJson.getJSONObject(KEY_ABSDURATION);
            if (jsonAbs != null && !jsonAbs.isEmpty()) {
                BigDecimal abs1 = jsonAbs.getBigDecimal(KEY_ABSDURATION1);
                BigDecimal abs2 = jsonAbs.getBigDecimal(KEY_ABSDURATION2);
                if (abs1 != null && abs2 != null && abs1.compareTo(abs2) == 0) {
                    absolutedurationIsAdjust = false;
                }
                if (abs1 != null && abs2 != null && abs1.compareTo(abs2) != 0) {
                    absoluteduration.put(KEY_ABSDURATION3, (Object)abs2.subtract(abs1));
                }
            }
        }
        boolean isAdjust = startTimeIsAdjust || endtimeIsAdjust || aimfinishtimeIsAdjust || absolutedurationIsAdjust;
        taskJson.put(KEY_ISADJUST, (Object)isAdjust);
        taskJson.put(KEY_ABSDURATION, (Object)absoluteduration);
        tasksMap.put(preChangeTaskId, taskJson);
        return tasksMap;
    }

    private DynamicObject[] getTasksByEntry(DynamicObjectCollection entries) {
        Object[] pks = new Object[entries.size()];
        for (int i = 0; i < pks.length; ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            pks[i] = entry.getString(KEY_TASKID);
        }
        return BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)TaskConstant.dt);
    }

    private void fillList(IDataModel model, JSONArray allTaskArray) {
        if (allTaskArray == null || allTaskArray.isEmpty()) {
            return;
        }
        JSONArray sons = null;
        JSONObject allTask = null;
        for (Object taskObj : allTaskArray) {
            JSONObject absoluteduration;
            JSONObject aimFinishTime;
            JSONObject endTime;
            JSONObject task = (JSONObject)taskObj;
            int rIndex = model.createNewEntryRow(KEY_TREEENTRYENTITY);
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
            grid.getModel().updateCache();
            model.setValue(KEY_TASK, task.get((Object)KEY_TASKID), rIndex);
            model.setValue("newtaskname", task.get((Object)KEY_TASKNAME), rIndex);
            model.setValue("newtaskcontrollevel", task.get((Object)KEY_TASKCONTROLLEVEL), rIndex);
            model.setValue("newtasktype", task.get((Object)KEY_TASKTYPE), rIndex);
            model.setValue("newresponsibleperson", task.get((Object)KEY_RESPONSIBLEPERSON), rIndex);
            JSONObject startTime = task.getJSONObject(KEY_STARTTIME);
            if (startTime != null && !startTime.isEmpty()) {
                for (Object key : startTime.keySet()) {
                    model.setValue((String)key, startTime.get(key), rIndex);
                }
            }
            if ((endTime = task.getJSONObject(KEY_ENDTIME)) != null && !endTime.isEmpty()) {
                Object key;
                key = endTime.keySet().iterator();
                while (key.hasNext()) {
                    String key2 = (String)key.next();
                    model.setValue(key2, endTime.get((Object)key2), rIndex);
                }
            }
            if ((aimFinishTime = task.getJSONObject(KEY_AIMFINISHTIME)) != null && !aimFinishTime.isEmpty()) {
                for (String key : aimFinishTime.keySet()) {
                    model.setValue(key, aimFinishTime.get((Object)key), rIndex);
                }
            }
            if ((absoluteduration = task.getJSONObject(KEY_ABSDURATION)) != null && !absoluteduration.isEmpty()) {
                for (String key : absoluteduration.keySet()) {
                    model.setValue(key, absoluteduration.get((Object)key), rIndex);
                }
            }
            sons = new JSONArray();
            for (Object allTaskObj : allTaskArray) {
                allTask = (JSONObject)allTaskObj;
                if (!task.get((Object)KEY_TASKID).equals(allTask.get((Object)KEY_PARENT))) continue;
                sons.add((Object)allTask);
            }
        }
    }

    private void fillTreeList(IDataModel model, JSONArray sameLevelTaskArray, JSONArray allTaskArray, boolean isRoot, int rowIndex) {
        if (sameLevelTaskArray == null || sameLevelTaskArray.isEmpty()) {
            return;
        }
        for (Object taskObj : sameLevelTaskArray) {
            JSONObject absoluteduration;
            JSONObject aimFinishTime;
            JSONObject endTime;
            JSONObject task = (JSONObject)taskObj;
            int rIndex = 0;
            rIndex = isRoot ? model.createNewEntryRow(KEY_TREEENTRYENTITY) : model.insertEntryRow(KEY_TREEENTRYENTITY, rowIndex);
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
            grid.setCollapse(false);
            this.getModel().beginInit();
            model.setValue(KEY_TASK, task.get((Object)KEY_TASKID), rIndex);
            model.setValue("newtaskname", task.get((Object)KEY_TASKNAME), rIndex);
            model.setValue("newtaskcontrollevel", task.get((Object)KEY_TASKCONTROLLEVEL), rIndex);
            model.setValue("newtasktype", task.get((Object)KEY_TASKTYPE), rIndex);
            model.setValue("newresponsibleperson", task.get((Object)KEY_RESPONSIBLEPERSON), rIndex);
            JSONObject startTime = task.getJSONObject(KEY_STARTTIME);
            if (startTime != null && !startTime.isEmpty()) {
                for (Object key : startTime.keySet()) {
                    model.setValue((String)key, startTime.get(key), rIndex);
                }
            }
            if ((endTime = task.getJSONObject(KEY_ENDTIME)) != null && !endTime.isEmpty()) {
                Object key;
                key = endTime.keySet().iterator();
                while (key.hasNext()) {
                    String key2 = (String)key.next();
                    model.setValue(key2, endTime.get((Object)key2), rIndex);
                }
            }
            if ((aimFinishTime = task.getJSONObject(KEY_AIMFINISHTIME)) != null && !aimFinishTime.isEmpty()) {
                for (Object key : aimFinishTime.keySet()) {
                    model.setValue((String)key, aimFinishTime.get(key), rIndex);
                }
            }
            if ((absoluteduration = task.getJSONObject(KEY_ABSDURATION)) != null && !absoluteduration.isEmpty()) {
                Object key;
                key = absoluteduration.keySet().iterator();
                while (key.hasNext()) {
                    String key3 = (String)key.next();
                    model.setValue(key3, absoluteduration.get((Object)key3), rIndex);
                }
            }
            JSONArray sons = new JSONArray();
            for (Object allTaskObj : allTaskArray) {
                JSONObject allTask = (JSONObject)allTaskObj;
                if (!task.getString(KEY_TASKID).equals(allTask.getString(KEY_PARENT))) continue;
                sons.add((Object)allTask);
            }
            this.getView().updateView(KEY_TREEENTRYENTITY);
            if (sons != null && !sons.isEmpty()) {
                this.fillTreeList(model, sons, allTaskArray, false, rIndex);
            }
            this.getModel().endInit();
        }
    }

    private void initStyleTreeEntity(TreeEntryGrid grid) {
        if (grid == null) {
            return;
        }
        IDataModel model = grid.getModel();
        DynamicObjectCollection rows = model.getEntryEntity(KEY_TREEENTRYENTITY);
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            Date start1 = row.getDate(KEY_STARTTIME1);
            Date start2 = row.getDate(KEY_STARTTIME2);
            if (start1 != null && start2 != null) {
                String color = "black";
                if (start2.before(start1)) {
                    color = "green";
                } else if (start2.after(start1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, KEY_STARTTIME2, color);
            }
            Date end1 = row.getDate(KEY_ENDTIME1);
            Date end2 = row.getDate(KEY_ENDTIME2);
            if (end1 != null && end2 != null) {
                String color = "black";
                if (end2.before(end1)) {
                    color = "green";
                } else if (end2.after(end1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, KEY_ENDTIME2, color);
            }
            Date aim1 = row.getDate(KEY_AIMFINISHTIME1);
            Date aim2 = row.getDate(KEY_AIMFINISHTIME2);
            if (aim1 != null && aim2 != null) {
                String color = "black";
                if (aim2.before(aim1)) {
                    color = "green";
                } else if (aim2.after(aim1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, KEY_AIMFINISHTIME2, color);
            }
            BigDecimal abs1 = row.getBigDecimal(KEY_ABSDURATION1);
            BigDecimal abs2 = row.getBigDecimal(KEY_ABSDURATION2);
            if (abs1 == null || abs2 == null || abs1.compareTo(BigDecimal.ZERO) == 0 || abs2.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal dvalue = abs2.subtract(abs1);
            String color = "black";
            if (dvalue.compareTo(BigDecimal.ZERO) < 0) {
                color = "green";
            } else if (dvalue.compareTo(BigDecimal.ZERO) > 0) {
                color = "red";
            }
            this.setCellTextColor(grid, i, KEY_ABSDURATION3, color);
        }
    }

    private void setCellTextColor(TreeEntryGrid grid, int rowIndex, String fieldKey, String color) {
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(rowIndex);
        statusStyle.setFieldKey(fieldKey);
        statusStyle.setForeColor(color);
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }
}

