/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.TaskConstant;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DynamicObjectTypeUtils;
import kd.pmgt.pmbs.common.utils.TaskCloneUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.common.utils.PlanEntryUtil;
import kd.pmgt.pmpm.common.utils.PlanTaskImpAndExpUtil;
import kd.pmgt.pmpm.common.utils.TreeEntryUtils;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmBillPlugin;

public class MajorPlanEditPlugin
extends AbstractPmpmBillPlugin
implements BeforeF7SelectListener {
    private static final String PARENTID = "parentBillId";
    private static final String INVOKEOPER = "invokeOper";
    private static final String HASCOPIED = "hasCopied";
    private static final String IMPORTTASK = "importtask";
    private static final String[] PROJECTPLAN_ROW_NAMES = new String[]{"taskname", "tasknumber", "controllevel", "spectype", "tasktype", "absoluteshedule", "pretask", "logical", "relativeschedule", "planbegindate", "planenddate", "aimfinishtime", "comptimedeviation", "directperson", "directorg", "indirectperson", "indirectorg", "achievementnode"};
    private static final String[] MAJORPLAN_ROW_NAMES = new String[]{"taskname", "tasknumber", "controllevel", "spectype", "tasktype", "absoluteshedule", "pretask", "logical", "relativeschedule", "planbegindate", "planenddate", "aimfinishtime", "comptimedeviation", "directperson", "directorg", "indirectperson", "indirectorg", "achievementnode"};

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        ChangeData changeSet = changeDatas[0];
        int curIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
        switch (key) {
            case "projectplan": {
                DynamicObject oldProPlan = (DynamicObject)changeSet.getOldValue();
                this.getPageCache().put("oldProPlanId", oldProPlan == null ? null : oldProPlan.getString("id"));
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                if (rowCount > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u6240\u6709\u5206\u5f55\u6240\u6709\u4e13\u9879\u8ba1\u5212\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MajorPlanEditPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("switchProPlan"));
                } else {
                    this.planChange();
                    this.generateName();
                }
                this.setDateEditRange();
                break;
            }
            case "pretask": {
                PlanEntryUtil.calPlanTimeByPreTaskAndLogical((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                this.setAllRowLocked();
                break;
            }
            case "version": {
                BigDecimal version = (BigDecimal)this.getModel().getValue("version");
                if (BigDecimal.valueOf(1.1).compareTo(version) != 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{IMPORTTASK});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{IMPORTTASK});
                break;
            }
            case "majortype": {
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                DynamicObject oldMajorType = (DynamicObject)changeSet.getOldValue();
                this.getPageCache().put("oldMajorTypeId", oldMajorType == null ? null : oldMajorType.getString("id"));
                if (rowCount > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u6240\u6709\u5206\u5f55\u6240\u6709\u4e13\u9879\u8ba1\u5212\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed", (String)"MajorPlanEditPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("switchMajorType"));
                } else {
                    this.planChange();
                }
                this.setDateEditRange();
                this.generateName();
                break;
            }
            case "aimfinishtime": {
                if (curIndex < 0) {
                    return;
                }
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                PlanEntryUtil.calCompTimeDeviation((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllRowLocked();
                break;
            }
            case "planbegindate": {
                if (curIndex < 0) {
                    return;
                }
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                Date planStartTime = (Date)this.getModel().getValue("planbegindate", curIndex);
                Date planEndTime = (Date)this.getModel().getValue("planenddate", curIndex);
                if (planStartTime == null) {
                    return;
                }
                if (planStartTime != null && planEndTime != null && planStartTime.after(planEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4", (String)"MajorPlanEditPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("planbegindate", changeSet.getOldValue(), curIndex);
                    return;
                }
                boolean isOutOfMainTaskTime = this.checkOutMainTaskTime("planbegindate", changeSet.getOldValue(), curIndex);
                if (isOutOfMainTaskTime) {
                    return;
                }
                PlanEntryUtil.calPlanTime((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (String)"planbegindate");
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllRowLocked();
                break;
            }
            case "planenddate": {
                if (curIndex < 0) {
                    return;
                }
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                Date planStartTime = (Date)this.getModel().getValue("planbegindate", curIndex);
                Date planEndTime = (Date)this.getModel().getValue("planenddate", curIndex);
                if (planEndTime == null) {
                    return;
                }
                if (planStartTime != null && planEndTime != null && planStartTime.after(planEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"MajorPlanEditPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("planenddate", null, curIndex);
                    return;
                }
                boolean isOutOfMainTaskTime = this.checkOutMainTaskTime("planenddate", changeSet.getOldValue(), curIndex);
                if (isOutOfMainTaskTime) {
                    return;
                }
                PlanEntryUtil.calPlanTime((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (String)"planenddate");
                PlanEntryUtil.calCompTimeDeviation((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllRowLocked();
                break;
            }
            case "absoluteshedule": {
                BigDecimal oldValue = (BigDecimal)changeSet.getOldValue();
                BigDecimal newValue = (BigDecimal)changeSet.getNewValue();
                if (newValue.compareTo(BigDecimal.ONE) < 0) {
                    this.getModel().setValue("absoluteshedule", (Object)oldValue, curIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u9700\u8981\u5927\u4e8e0", (String)"MajorPlanEditPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                }
                PlanEntryUtil.calPlanTime((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (String)"absoluteshedule");
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllRowLocked();
                break;
            }
            case "relativeschedule": {
                BigDecimal oldRelativeschedule = (BigDecimal)changeSet.getOldValue();
                PlanEntryUtil.calMarjorPlanTimeByPreTaskAndLogical((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (BigDecimal)oldRelativeschedule);
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllRowLocked();
                break;
            }
            case "indirectperson": {
                DynamicObject entryInfo;
                DynamicObject cooperationPreson;
                if (curIndex < 0) {
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("taskentity");
                if (curIndex >= rowCount || (cooperationPreson = (entryInfo = (DynamicObject)entrys.get(curIndex)).getDynamicObject("indirectperson")) == null) break;
                DynamicObject responsiblePerson = entryInfo.getDynamicObject("directperson");
                if (responsiblePerson != null && cooperationPreson.getString("id").equals(responsiblePerson.getString("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"MajorPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("indirectperson", null, curIndex);
                    return;
                }
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(cooperationPreson.getPkValue().toString()));
                this.getModel().setValue("indirectorg", (Object)orgId, curIndex);
                break;
            }
            case "directperson": {
                DynamicObject entryInfo;
                DynamicObject responsiblePreson;
                if (curIndex < 0) {
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("taskentity");
                if (curIndex >= rowCount || (responsiblePreson = (entryInfo = (DynamicObject)entrys.get(curIndex)).getDynamicObject("directperson")) == null) break;
                DynamicObject cooperationPreson = entryInfo.getDynamicObject("indirectperson");
                if (cooperationPreson != null && cooperationPreson.getString("id").equals(responsiblePreson.getString("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"MajorPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("directperson", null, curIndex);
                    return;
                }
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePreson.getPkValue().toString()));
                this.getModel().setValue("directorg", (Object)orgId, curIndex);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mesce) {
        String key;
        super.confirmCallBack(mesce);
        switch (key = mesce.getCallBackId()) {
            case "switchProPlan": {
                if (mesce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                    String oldProPlanId = this.getPageCache().get("oldProPlanId");
                    this.getModel().beginInit();
                    this.getModel().setValue("projectplan", (Object)oldProPlanId);
                    this.getModel().endInit();
                    this.getView().updateView("projectplan");
                    this.getPageCache().remove("oldProPlanId");
                    break;
                }
                this.generateName();
                this.planChange();
                break;
            }
            case "switchMajorType": {
                if (mesce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                    String oldMajorTypeId = this.getPageCache().get("oldMajorTypeId");
                    this.getModel().beginInit();
                    this.getModel().setValue("majortype", (Object)oldMajorTypeId);
                    this.getModel().endInit();
                    this.getView().updateView("majortype");
                    this.getPageCache().remove("oldMajorTypeId");
                    break;
                }
                this.planChange();
                break;
            }
            case "calmodify": {
                if (!MessageBoxResult.Yes.equals((Object)mesce.getResult())) break;
                PlanEntryUtil.updateEntryTaskTimeWhenCalModify((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllRowLocked();
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAdjustLocked();
                break;
            }
            case "proimptask": {
                if (!MessageBoxResult.Yes.equals((Object)mesce.getResult())) break;
                HashMap<String, Object> map = new HashMap<String, Object>();
                HashMap<String, String> customMap = new HashMap<String, String>();
                map.put("formId", "pmpm_impprotaskf7");
                map.put("customParams", customMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.setStatus(OperationStatus.EDIT);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_impprotaskf7"));
                StyleCss css = new StyleCss();
                css.setHeight("600px");
                css.setWidth("1200px");
                parameter.getOpenStyle().setInlineStyleCss(css);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                String orgId = org.getString("id");
                customMap.put("orgId", orgId);
                customMap.put("billType", "majorplan");
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                String projectId = project.getString("id");
                customMap.put("proId", projectId);
                this.getView().showForm(parameter);
                break;
            }
            case "importtask": {
                if (!MessageBoxResult.Yes.equals((Object)mesce.getResult())) break;
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"MajorPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter importExcelFormParameter = new FormShowParameter();
                importExcelFormParameter.setFormId("taskimpdialog");
                importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_taskimpdialog"));
                this.getView().showForm(importExcelFormParameter);
                break;
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit preTask = (BasedataEdit)this.getControl("pretask");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("directperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("directorg");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationPerson = (BasedataEdit)this.getControl("indirectperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationDept = (BasedataEdit)this.getControl("indirectorg");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taskType = (BasedataEdit)this.getControl("tasktype");
        taskType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit projectplan = (BasedataEdit)this.getControl("projectplan");
        projectplan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            List loginOrgId = ((ListView)parentView).getSelectedMainOrgIds();
            this.getModel().setValue("org", loginOrgId.get(0));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String key = (String)this.getView().getFormShowParameter().getCustomParam(INVOKEOPER);
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        String isCopied = (String)this.getView().getFormShowParameter().getCustomParam(HASCOPIED);
        if (null != key && key.equalsIgnoreCase("copy") && null != parentbill) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectplan"});
            if ("false".equals(isCopied)) {
                this.getView().getFormShowParameter().setCustomParam(HASCOPIED, (Object)"true");
                this.getView().invokeOperation("copy");
            } else {
                this.createCopy();
            }
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"adjusttab"});
    }

    private void createCopy() {
        DynamicObject proPlan;
        BigDecimal proVersion;
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        String latestPlanId = this.findLatestPlan();
        BigDecimal growth = BigDecimal.ONE.divide(BigDecimal.TEN);
        version = latestPlanId != null && latestPlanId.length() > 0 ? ((proVersion = (proPlan = BusinessDataServiceHelper.loadSingle((Object)latestPlanId, (String)"pmpm_projectplan", (String)"version")).getBigDecimal("version")).intValue() == version.intValue() ? version.add(growth) : proVersion.add(growth)) : version.add(growth);
        this.getModel().setValue("version", (Object)version);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            String name = project.getString("name");
            DynamicObject majortype = (DynamicObject)this.getModel().getValue("majortype");
            String majortypeName = "";
            if (majortype != null) {
                majortypeName = majortype.getString("plantypename");
            }
            name = name + majortypeName + version;
            this.getModel().setValue("name", (Object)name);
        }
        this.getModel().setValue("prechangeplan", (Object)String.valueOf(parentbill));
        DynamicObject preChangeDynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentbill, (String)"pmpm_majorplan", (String)"id, sourceplan");
        if (preChangeDynamicObject != null && preChangeDynamicObject.getDynamicObject("sourceplan") == null) {
            this.getModel().setValue("sourceplan", (Object)preChangeDynamicObject);
        } else if (null != preChangeDynamicObject) {
            this.getModel().setValue("sourceplan", (Object)preChangeDynamicObject.getDynamicObject("sourceplan"));
        }
        this.getModel().setValue("planstatus", (Object)PlanEnum.CREATEING.getValue());
        List selectedOrgId = ((ListView)this.getView().getParentView()).getSelectedMainOrgIds();
        String userId = RequestContext.get().getUserId();
        this.getModel().setValue("org", selectedOrgId.get(0));
        this.getModel().setValue("creator", (Object)userId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String latestPlanId = this.findLatestPlan();
        DynamicObject proPlan = (DynamicObject)this.getModel().getValue("projectplan");
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (latestPlanId != null && !latestPlanId.equals(proPlan.getString("id")) && "C".equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e13\u9879\u8ba1\u5212\u5b58\u5728\u65b0\u7248\u672c\u7684\u4e3b\u9879\u8ba1\u5212\uff0c\u8bf7\u8c03\u6574\u4e13\u9879\u8ba1\u5212\u3002", (String)"MajorPlanEditPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        } else if (latestPlanId != null && proPlan != null && !latestPlanId.equals(proPlan.getString("id"))) {
            this.getModel().beginInit();
            this.getModel().setValue("projectplan", (Object)latestPlanId);
            this.getModel().endInit();
            this.getView().updateView("projectplan");
            this.updateEntryByLatestPlan(latestPlanId);
        }
        if (!"C".equals(this.getModel().getDataEntity().getString("billstatus"))) {
            this.loadTask();
        }
        this.doAdjust();
        Object preChangePlan = this.getModel().getValue("prechangeplan");
        String status = this.getModel().getDataEntity().getString("billstatus");
        if (preChangePlan != null && !"C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"adjusttab"});
        }
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        if (BigDecimal.valueOf(1.1).compareTo(version) != 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMPORTTASK});
        }
        this.setDateEditRange();
        this.setAllRowLocked();
        this.setMajorTypeFilter();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void setDateEditRange() {
        DynamicObject project;
        DateEdit planStartTime = (DateEdit)this.getControl("planbegindate");
        DateEdit planEndTime = (DateEdit)this.getControl("planenddate");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        DynamicObject projectPlan = this.getModel().getDataEntity().getDynamicObject("projectplan");
        if (projectPlan != null && (project = projectPlan.getDynamicObject("project")) != null) {
            Date firstDay = PmpmTaskUtil.getFirstDayByProject((Object)project.getPkValue()).getTime();
            Date endDay = PmpmTaskUtil.getEndDayByProject((Object)project.getPkValue()).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    private void doAdjust() {
        String isCopied = (String)this.getView().getFormShowParameter().getCustomParam(HASCOPIED);
        String key = (String)this.getView().getFormShowParameter().getCustomParam(INVOKEOPER);
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        if (null != key && key.equalsIgnoreCase("copy") && null != parentbill && "true".equals(isCopied)) {
            this.getView().invokeOperation("save");
            DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
            ArrayList<DynamicObject> newTasks = new ArrayList<DynamicObject>();
            HashMap<String, String> taskIdRelation = new HashMap<String, String>();
            JSONObject jsonObject = null;
            long[] ids = null;
            if (!entries.isEmpty()) {
                ORM orm = ORM.create();
                ids = orm.genLongIds("pmpm_task", entries.size());
            }
            int idIndex = 0;
            for (DynamicObject entry : entries) {
                DynamicObject task;
                DynamicObject belongPlanType;
                if (null == entry.get("taskname") || (belongPlanType = (task = BusinessDataServiceHelper.loadSingle((Object)entry.get("taskid"), (String)"pmpm_task")).getDynamicObject("belongplantype")) != null && "1".equals(belongPlanType.getString("plantype"))) continue;
                DynamicObject newTask = (DynamicObject)OrmUtils.clone((Object)task, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                TaskCloneUtil.cloneTask((DynamicObject)newTask, (DynamicObject)task);
                BigDecimal version = (BigDecimal)this.getModel().getValue("version");
                newTask.set("version", (Object)version);
                newTask.set("sourcetask", (Object)task);
                DynamicObject plantype = (DynamicObject)task.get("belongplantype");
                DynamicObject plantypeObj = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)"pmpm_majortype");
                if (null != plantypeObj && (StringUtils.equalsIgnoreCase((CharSequence)plantypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAJORPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue()))) {
                    jsonObject = new JSONObject();
                    jsonObject.put("majorproplanid", this.getModel().getDataEntity().getPkValue());
                    newTask.set("plans", (Object)jsonObject.toString());
                }
                newTask.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                newTask.set("prechangetask", (Object)task);
                Long id = ids[idIndex++];
                taskIdRelation.put(task.getString("id"), String.valueOf(id));
                newTask.set("id", (Object)id);
                entry.set("taskid", (Object)String.valueOf(id));
                entry.set("taskname", (Object)newTask.getString("name"));
                newTasks.add(newTask);
            }
            for (int i = 0; i < newTasks.size(); ++i) {
                String oldPreTaskId;
                DynamicObject newTask = (DynamicObject)newTasks.get(i);
                if (null != newTask.getDynamicObject("parent")) {
                    String oldParentId = newTask.getDynamicObject("parent").getString("id");
                    String newParentId = (String)taskIdRelation.get(oldParentId);
                    if (newParentId == null) continue;
                    List parentList = newTasks.stream().filter(obj -> newParentId.equals(obj.getString("id"))).collect(Collectors.toList());
                    if (parentList.size() > 0) {
                        newTask.set("parent", parentList.get(0));
                    }
                }
                if (null == newTask.getDynamicObject("pretask") || taskIdRelation.get(oldPreTaskId = newTask.getDynamicObject("pretask").getString("id")) == null) continue;
                String newPreTaskId = (String)taskIdRelation.get(oldPreTaskId);
                List preTaskList = newTasks.stream().filter(obj -> newPreTaskId.equals(obj.getString("id"))).collect(Collectors.toList());
                newTask.set("pretask", preTaskList.get(0));
            }
            DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
            boolean isBefore = this.isBeforePlanAudit(project.getPkValue(), parentbill);
            if (isBefore) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u65e5\u5386\u53d1\u751f\u4e86\u4fee\u6539\uff0c\u662f\u5426\u9700\u8981\u91cd\u7b97\u65f6\u95f4\uff1f", (String)"MajorPlanEditPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("calmodify"));
            }
            SaveServiceHelper.save((DynamicObject[])newTasks.toArray(new DynamicObject[newTasks.size()]));
            this.loadTask();
            this.getView().invokeOperation("save");
            this.getView().getFormShowParameter().getCustomParams().clear();
        }
        this.getView().updateView("taskentity");
    }

    private void updateEntryByLatestPlan(String latestPlanId) {
        List taskIdList;
        DynamicObject projectPlan = BusinessDataServiceHelper.loadSingle((Object)latestPlanId, (String)"pmpm_projectplan", (String)"taskid,spectype");
        DynamicObjectCollection entrys = projectPlan.getDynamicObjectCollection("taskentity");
        DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
        if (majorType != null) {
            String majorTypeId = majorType.getString("id");
            entrys = entrys.stream().filter(obj -> majorTypeId.equals(obj.getDynamicObject("spectype").getString("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        if ((taskIdList = entrys.stream().map(entryInfo -> entryInfo.getString("taskid")).collect(Collectors.toList())).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = rowCount - 1; i >= 0; --i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
            DynamicObject belongplantype = taskObj.getDynamicObject("belongplantype");
            if (taskIdList.contains(taskId)) {
                taskIdList.remove(taskId);
                continue;
            }
            if (belongplantype == null || !"1".equals(belongplantype.getString("plantype"))) continue;
            this.getModel().deleteEntryRow("taskentity", i);
        }
        if (taskIdList.size() > 0) {
            for (String taskId : taskIdList) {
                int index = this.getModel().createNewEntryRow("taskentity");
                this.getModel().setValue("taskid", (Object)taskId, index);
            }
        }
    }

    private String findLatestPlan() {
        DynamicObject proPlan = (DynamicObject)this.getModel().getValue("projectplan");
        if (proPlan == null || this.getModel().getDataEntity().getPkValue() == null) {
            return null;
        }
        DynamicObject sourcePlan = proPlan.getDynamicObject("sourceplan");
        String sourcePlanId = null;
        sourcePlanId = sourcePlan == null ? proPlan.getString("id") : sourcePlan.getString("id");
        QFilter filter = new QFilter("sourcePlan.id", "=", (Object)sourcePlanId);
        filter.and(new QFilter("planstatus", "=", (Object)"3"));
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"id,version", (QFilter[])new QFilter[]{filter}, (String)"version");
        if (plans.length > 0) {
            String latestPlanId = plans[plans.length - 1].getString("id");
            return latestPlanId;
        }
        return null;
    }

    private void setProjectPlanFilter(BeforeF7SelectEvent arg) {
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            QFilter orgFilter;
            QFilter finalFilter = orgFilter = new QFilter("org", "=", (Object)org.getString("id"));
            DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"id", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue())});
            if (majorType != null) {
                QFilter majorTypeFilter = new QFilter("majortype", "=", (Object)majorType.getString("id"));
                finalFilter.and(majorTypeFilter);
            }
            if (showParameter.getListFilterParameter().getQFilters() != null) {
                showParameter.getListFilterParameter().getQFilters().add(finalFilter);
            } else {
                showParameter.getListFilterParameter().setFilter(finalFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskEntity");
        int[] selRows = grid.getSelectRows();
        switch (key) {
            case "save": {
                this.doSave(args);
                break;
            }
            case "submit": {
                if (this.isExistSameMajorType()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u4e0b\u5b58\u5728\u8be5\u4e13\u9879\u8ba1\u5212\u7c7b\u578b\u7684\u4e13\u9879\u8ba1\u5212\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MajorPlanEditPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                this.saveTask();
                break;
            }
            case "addtask": {
                this.doAddTask(grid, selRows);
                break;
            }
            case "modifytask": {
                this.doModifyTask(selRows);
                break;
            }
            case "deletetask": {
                this.doDeleteTask(selRows);
                break;
            }
            case "upgrade": {
                this.doUpgrade(selRows);
                break;
            }
            case "downgrade": {
                this.doDowngrade(selRows);
                break;
            }
            case "moveentryup": {
                this.doMoveEntryUp(args, selRows);
                break;
            }
            case "moveentrydown": {
                this.doMoveEntryDown(args, selRows);
                break;
            }
        }
    }

    private void doAddTask(TreeEntryGrid grid, int[] selRows) {
        if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"MajorPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        ORM orm = ORM.create();
        String taskId = String.valueOf(orm.genLongId((IDataEntityType)TaskConstant.dt));
        if (selRows.length == 0) {
            int index = this.getModel().createNewEntryRow("taskentity");
            this.getModel().setValue("taskid", (Object)taskId, index);
            this.getModel().setValue("level", (Object)1, index);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, index);
            DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
            this.getModel().setValue("spectype", (Object)majorType.getString("id"), index);
            this.createTask(index, "create");
        } else {
            String parentTaskId = (String)this.getModel().getValue("taskid", selRows[0]);
            DynamicObject parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTaskId, (String)"pmpm_task", (String)"belongplantype");
            DynamicObject belongPlanType = parentTask.getDynamicObject("belongplantype");
            QFilter taskFilter = new QFilter("belongplantype.plantype", "=", (Object)"1");
            QFilter parentFilter = new QFilter("parent", "=", (Object)parentTaskId);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id", (QFilter[])new QFilter[]{taskFilter, parentFilter});
            if (tasks.length > 0 && "1".equals(belongPlanType.getString("plantype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u5b50\u7ea7\u7684\u4e3b\u9879\u4efb\u52a1\u4e0b\u4e0d\u5141\u8bb8\u5efa\u7acb\u4e13\u9879\u4efb\u52a1", (String)"MajorPlanEditPlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
            int parentLevel = (Integer)this.getModel().getValue("level", selRows[0]);
            int curRowLevel = parentLevel + 1;
            int index = this.getModel().insertEntryRow("taskentity", selRows[0]);
            this.getModel().setValue("taskid", (Object)taskId, index);
            this.getModel().setValue("parent", (Object)parentTaskId, index);
            this.getModel().setValue("level", (Object)curRowLevel, index);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, index);
            DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
            this.getModel().setValue("spectype", (Object)majorType.getString("id"), index);
            if (!StringUtils.equals((CharSequence)belongPlanType.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                this.getModel().setValue("pretask", null, selRows[0]);
                this.getModel().setValue("logical", null, selRows[0]);
                this.getModel().setValue("isleaf", (Object)Boolean.FALSE, selRows[0]);
            }
            this.createTask(index, "insert");
            grid.expand(selRows[0]);
        }
    }

    private void doSave(BeforeDoOperationEventArgs args) {
        DynamicObject proPlan = (DynamicObject)this.getModel().getValue("projectplan");
        DynamicObject majortype = (DynamicObject)this.getModel().getValue("majortype");
        Object planName = this.getModel().getValue("name");
        if (proPlan == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a", (String)"MajorPlanEditPlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (majortype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u8ba1\u5212\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"MajorPlanEditPlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)planName.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"MajorPlanEditPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (this.isExistSameMajorType()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u4e0b\u5b58\u5728\u8be5\u4e13\u9879\u8ba1\u5212\u7c7b\u578b\u7684\u4e13\u9879\u8ba1\u5212\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MajorPlanEditPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void doModifyTask(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fee\u6539\u7684\u4efb\u52a1\u884c", (String)"MajorPlanEditPlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.saveTask();
        int index = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", index);
        if (this.isMainTask(taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"completionstatus");
        String completeStatus = taskObj.getString("completionstatus");
        if (CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completeStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"MajorPlanEditPlugin_18", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Object, Object> customMap1 = new HashMap<Object, Object>(16);
        this.openTaskPage(customMap1, taskId);
    }

    private void doMoveEntryDown(BeforeDoOperationEventArgs args, int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"MajorPlanEditPlugin_25", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u79fb\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_29", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
        int index = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", index);
        if (this.isMainTask(taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!TreeEntryUtils.isAllowMoveDown((IDataModel)this.getModel(), (int[])selRows, (String)"taskentity")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0b\u79fb\u672b\u884c\u6570\u636e", (String)"MajorPlanEditPlugin_30", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (index + 1 < rowCount) {
            int nextRowIndex = index + 1;
            String nextRowTaskId = (String)this.getModel().getValue("taskid", nextRowIndex);
            DynamicObject nextRowTask = BusinessDataServiceHelper.loadSingle((Object)nextRowTaskId, (String)"pmpm_task");
            DynamicObject belongPlanType = nextRowTask.getDynamicObject("belongplantype");
            if ("1".equals(belongPlanType.getString("plantype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u4e00\u884c\u662f\u4e3b\u9879\u8ba1\u5212\uff0c\u4e13\u9879\u8ba1\u5212\u4e0d\u80fd\u518d\u5f80\u4e0b\u79fb\u3002", (String)"MajorPlanEditPlugin_31", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
        }
        int pIndex = this.getParentRowIndex(selRows[0]);
        int bIndex = this.getYoungerBrotherIndex(selRows[0]);
        this.getPageCache().put("parentIndex", String.valueOf(pIndex));
        this.getPageCache().put("brotherIndex", String.valueOf(bIndex));
        this.setAllRowLocked();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void doMoveEntryUp(BeforeDoOperationEventArgs args, int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"MajorPlanEditPlugin_25", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u79fb\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_26", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
        int index = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", index);
        if (this.isMainTask(taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!TreeEntryUtils.isAllowMoveUp((IDataModel)this.getModel(), (int[])selRows, (String)"taskentity")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0a\u79fb\u9996\u884c\u6570\u636e", (String)"MajorPlanEditPlugin_27", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (index - 1 >= 0) {
            int preRowIndex = index - 1;
            String preRowTaskId = (String)this.getModel().getValue("taskid", preRowIndex);
            DynamicObject preRowTask = BusinessDataServiceHelper.loadSingle((Object)preRowTaskId, (String)"pmpm_task");
            DynamicObject belongPlanType = preRowTask.getDynamicObject("belongplantype");
            if ("1".equals(belongPlanType.getString("plantype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e00\u884c\u662f\u4e3b\u9879\u8ba1\u5212\uff0c\u4e13\u9879\u8ba1\u5212\u4e0d\u80fd\u518d\u5f80\u4e0a\u79fb\u3002", (String)"MajorPlanEditPlugin_28", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
        }
        int parentIndex = this.getParentRowIndex(selRows[0]);
        int brotherIndex = this.getOlderBrotherIndex(selRows[0]);
        this.getPageCache().put("parentIndex", String.valueOf(parentIndex));
        this.getPageCache().put("brotherIndex", String.valueOf(brotherIndex));
        this.setAllRowLocked();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void doDowngrade(int[] selRows) {
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u964d\u7ea7\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_23", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u964d\u7ea7\u884c", (String)"MajorPlanEditPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int index = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", index);
        if (this.isMainTask(taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeEntryUtils.downgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, null);
        if (selRows.length == 1) {
            taskId = (String)this.getModel().getValue("taskid", selRows[0]);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)selRows[0]);
            PlanEntryUtil.updateReferTaskTimeForTreeGrade((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
        }
        this.loadPreTask();
        this.getView().updateView("taskentity");
        this.setAllRowLocked();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void doUpgrade(int[] selRows) {
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_21", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5347\u7ea7\u884c", (String)"MajorPlanEditPlugin_22", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int index = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", index);
        if (this.isMainTask(taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeEntryUtils.upgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, null);
        if (selRows.length == 1) {
            taskId = (String)this.getModel().getValue("taskid", selRows[0]);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)selRows[0]);
            PlanEntryUtil.updateReferTaskTimeForTreeGrade((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
        }
        this.loadPreTask();
        this.getView().updateView("taskentity");
        this.setAllRowLocked();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void doDeleteTask(int[] selRows) {
        int index;
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5220\u9664\u7684\u4efb\u52a1", (String)"MajorPlanEditPlugin_19", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int j = selRows.length - 1; j >= 0; --j) {
            index = selRows[j];
            String delTaskId = (String)this.getModel().getValue("taskid", index);
            if (this.isMainTask(delTaskId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", index);
            if (isLeaf) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u7b2c%s\u884c\u7684\u5b50\u4efb\u52a1", (String)"MajorPlanEditPlugin_20", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), selRows[j] + 1);
            this.getView().showTipNotification(msg);
            return;
        }
        ArrayList<String> delIdsArr = new ArrayList<String>(10);
        ArrayList<String> delEntryIdsArr = new ArrayList<String>(10);
        for (int i = selRows.length - 1; i >= 0; --i) {
            index = selRows[0];
            String delTaskId = (String)this.getModel().getValue("taskid", index);
            if (delTaskId != null && !"0".equals(delTaskId) && !"".equals(delTaskId)) {
                delIdsArr.add(delTaskId);
            }
            delEntryIdsArr.add(this.getModel().getEntryRowEntity("taskentity", index).getString("id"));
            DynamicObject parentTaskObj = (DynamicObject)this.getModel().getValue("parent", index);
            if (parentTaskObj != null) {
                String parentTaskId = parentTaskObj.getString("id");
                for (int j = index - 1; j >= 0; --j) {
                    int lastChildIndex;
                    String curTaskId = (String)this.getModel().getValue("taskid", j);
                    if (!parentTaskId.equals(curTaskId) || (lastChildIndex = PlanEntryUtil.getSameLevelChildIndex((IFormView)this.getView(), (IDataModel)this.getModel(), (int)j)) != index) continue;
                    this.getModel().setValue("isleaf", (Object)Boolean.TRUE, j);
                    this.getModel().getEntryRowEntity("taskentity", j).set("isGroupNode", (Object)Boolean.FALSE);
                }
            }
            this.getModel().deleteEntryRow("taskentity", index);
        }
        DynamicObjectType subEntryDt = DynamicObjectTypeUtils.getEntryDynamicObjectType((String)"pmpm_projectplan", (String)"taskentity");
        DeleteServiceHelper.delete((IDataEntityType)subEntryDt, (Object[])delEntryIdsArr.toArray());
        DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])delIdsArr.toArray());
        for (String string : delIdsArr) {
            PmpmTaskUtil.cleanPreTaskAndLogicalWhereDelTask((Object)string);
        }
        this.saveTask();
        this.loadTask();
        this.setAllRowLocked();
        this.getView().updateView("taskentity");
    }

    private boolean isExistSameMajorType() {
        DynamicObject[] majorPlans;
        String billId;
        DynamicObject proPlan = (DynamicObject)this.getModel().getValue("projectplan");
        DynamicObject majortype = (DynamicObject)this.getModel().getValue("majortype");
        String proPlanId = proPlan.getString("id");
        String majorTypeId = majortype.getString("id");
        QFilter filter = new QFilter("projectplan", "=", (Object)proPlanId);
        filter.and(new QFilter("majortype", "=", (Object)majorTypeId));
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        filter.and(new QFilter("version", "=", (Object)version));
        if (this.getModel().getDataEntity().getPkValue() != null && !"0".equals(billId = this.getModel().getDataEntity().getPkValue().toString())) {
            filter.and(new QFilter("id", "!=", (Object)billId));
        }
        return (majorPlans = BusinessDataServiceHelper.load((String)"pmpm_majorplan", (String)"id", (QFilter[])new QFilter[]{filter})).length > 0;
    }

    private int getParentRowIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent", row);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                Object taskId = rowEntity.get("taskid");
                if (taskId == null || !parentId.toString().equals(taskId.toString())) continue;
                return i;
            }
        }
        return 0;
    }

    private int getOlderBrotherIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent", row);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
                if (rowParent == null || !parentId.equals(rowParent.getPkValue())) continue;
                return i;
            }
        } else {
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
                if (rowParent != null) continue;
                return i;
            }
        }
        return 0;
    }

    private int getYoungerBrotherIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent", row);
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (parent != null) {
            Object parentId = parent.getPkValue();
            int nextIndex = 0;
            int nextCount = 0;
            for (int i = row + 1; i < rowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
                if (rowParent == null || !parentId.equals(rowParent.getPkValue())) continue;
                if (nextIndex != 0) {
                    nextCount = i - nextIndex;
                    break;
                }
                nextIndex = i;
            }
            if (nextCount == 0) {
                nextCount = rowCount - nextIndex;
            }
            return row + nextCount;
        }
        int nextIndex = 0;
        int nextCount = 0;
        for (int i = row + 1; i < rowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
            DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
            if (rowParent != null) continue;
            if (nextIndex != 0) {
                nextCount = i - nextIndex;
                break;
            }
            nextIndex = i;
        }
        if (nextCount == 0) {
            nextCount = rowCount - nextIndex;
        }
        return row + nextCount;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        switch (key) {
            case "save": {
                this.saveTask();
                break;
            }
            case "submit": {
                this.saveTask();
                break;
            }
            case "batchmodify": {
                this.doBatchModify(grid);
                break;
            }
            case "viewtaskdetail": {
                this.doViewTaskDetail(grid);
                break;
            }
            case "moveentryup": {
                this.getModel().updateCache();
                String parentIndex = this.getPageCache().get("parentIndex");
                String brotherIndex = this.getPageCache().get("brotherIndex");
                if (parentIndex == null || brotherIndex == null) break;
                grid.selectRows(Integer.parseInt(brotherIndex));
                grid.focus(Integer.parseInt(parentIndex), Integer.parseInt(brotherIndex));
                this.getPageCache().remove("parentIndex");
                this.getPageCache().remove("brotherIndex");
                break;
            }
            case "moveentrydown": {
                this.getModel().updateCache();
                String pIndex = this.getPageCache().get("parentIndex");
                String bIndex = this.getPageCache().get("brotherIndex");
                if (pIndex == null || bIndex == null) break;
                grid.selectRows(Integer.parseInt(bIndex));
                grid.focus(Integer.parseInt(pIndex), Integer.parseInt(bIndex));
                this.getPageCache().remove("parentIndex");
                this.getPageCache().remove("brotherIndex");
                break;
            }
            case "proimptask": {
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"MajorPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u5220\u9664\u73b0\u6709\u4efb\u52a1\u53ca\u4efb\u52a1\u6267\u884c\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MajorPlanEditPlugin_35", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("proimptask"));
                break;
            }
            case "importtask": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5bfc\u5165\u5c06\u4f1a\u6e05\u7a7a\u73b0\u6709\u4e13\u9879\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MajorPlanEditPlugin_36", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IMPORTTASK));
                break;
            }
            case "exportmodel": {
                this.doExportModel();
                break;
            }
        }
    }

    private void doExportModel() {
        JSONArray data = new JSONArray();
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            JSONObject jsonObject = new JSONObject();
            PlanTaskImpAndExpUtil.createTaskJsonObject((DynamicObject)task, (JSONObject)jsonObject);
            data.add((Object)jsonObject);
        }
        PlanTaskImpAndExpUtil.exportModel((IFormView)this.getView(), (JSONArray)data);
    }

    private void doViewTaskDetail(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u4efb\u52a1\u8be6\u60c5\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"MajorPlanEditPlugin_33", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u884c", (String)"MajorPlanEditPlugin_34", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", rowIndex);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (taskId != null) {
            paramMap.put("formId", "pmpm_reporttaskview");
            paramMap.put("pkId", taskId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private void doBatchModify(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        for (int k = 0; k < selRows.length; ++k) {
            int index = selRows[k];
            String taskId = (String)this.getModel().getValue("taskid", index);
            if (!this.isMainTask(taskId)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u4fee\u6539", (String)"MajorPlanEditPlugin_32", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), index + 1);
            this.getView().showTipNotification(msg);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "pmpm_batchmodify");
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_batchmodify"));
        this.getView().showForm(parameter);
    }

    private void generateName() {
        DynamicObject proPlan = (DynamicObject)this.getModel().getValue("projectplan");
        if (proPlan == null) {
            this.getModel().setValue("name", null);
            return;
        }
        DynamicObject project = proPlan.getDynamicObject("project");
        this.getModel().setValue("project", (Object)project);
        this.setMajorTypeFilter();
        if (project != null) {
            String name = project.getString("name");
            BigDecimal version = (BigDecimal)this.getModel().getValue("version");
            DynamicObject majortype = (DynamicObject)this.getModel().getValue("majortype");
            String majortypeName = "";
            if (majortype != null) {
                majortypeName = majortype.getString("plantypename");
            }
            name = name + majortypeName + version.floatValue();
            this.getModel().setValue("name", (Object)name);
        }
    }

    private void planChange() {
        QFilter enableFilter;
        String kindId;
        QFilter groupFilter;
        DynamicObject[] majorTypes;
        DynamicObject projectPlanObj = (DynamicObject)this.getModel().getValue("projectplan");
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (rowCount > 0) {
            ArrayList<String> delEntryIdsList = new ArrayList<String>();
            ArrayList<String> delTaskIdsList = new ArrayList<String>();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity("taskentity", i);
                String taskId = rowObj.getString("taskid");
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                String plans = task.getString("plans");
                JSONObject plansObj = JSONObject.parseObject((String)plans);
                if (plansObj.get((Object)"majorproplanid") == null) continue;
                delEntryIdsList.add(rowObj.getPkValue().toString());
                delTaskIdsList.add(taskId);
            }
            DynamicObjectType subEntryDt = DynamicObjectTypeUtils.getEntryDynamicObjectType((String)"pmpm_majorplan", (String)"taskentity");
            if (delEntryIdsList.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)subEntryDt, (Object[])delEntryIdsList.toArray());
            }
            if (delTaskIdsList.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])delTaskIdsList.toArray());
            }
        }
        this.getModel().deleteEntryData("taskentity");
        if (projectPlanObj == null) {
            return;
        }
        DynamicObject project = projectPlanObj.getDynamicObject("project");
        DynamicObject projectKind = (project = BusinessDataServiceHelper.loadSingle((Object)project.getString("id"), (String)"bd_project", (String)"group")).getDynamicObject("group");
        if (projectKind != null && (majorTypes = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"id", (QFilter[])new QFilter[]{groupFilter = new QFilter("group", "=", (Object)(kindId = projectKind.getString("id"))), enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)})).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u7684\u9879\u76ee\u5206\u7c7b\u65e0\u4e13\u4e1a\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MajorPlanEditPlugin_37", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        projectPlanObj = BusinessDataServiceHelper.loadSingle((Object)projectPlanObj.getString("id"), (String)"pmpm_projectplan");
        BigDecimal version = projectPlanObj.getBigDecimal("version");
        version = version.add(BigDecimal.valueOf(0.1));
        this.getModel().setValue("version", (Object)version);
        DynamicObjectCollection projectEntrys = projectPlanObj.getDynamicObjectCollection("taskentity");
        DynamicObjectType dt = projectEntrys.getDynamicObjectType();
        ORM orm = ORM.create();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        long[] randomId = orm.genLongIds((IDataEntityType)dt, projectEntrys.size());
        int index = 0;
        for (DynamicObject pEntry : projectEntrys) {
            idMap.put(pEntry.getLong("id"), randomId[index++]);
        }
        DynamicObjectCollection majorEntrys = this.getModel().getEntryEntity("taskentity");
        DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
        if (majorType != null) {
            String majorTypeId = majorType.getString("id");
            for (DynamicObject entry : projectEntrys) {
                DynamicObject entrySpectype = entry.getDynamicObject("spectype");
                if (entrySpectype == null || !entrySpectype.getString("id").equals(majorTypeId)) continue;
                DynamicObject ancestorEntry = this.ancestor(entry, majorTypeId, projectEntrys);
                DynamicObject newEntry = new DynamicObject(dt);
                newEntry.set("id", idMap.get(entry.getLong("id")));
                if (ancestorEntry != null) {
                    newEntry.set("pid", idMap.get(ancestorEntry.getLong("id")));
                    newEntry.set("parent", (Object)ancestorEntry);
                }
                this.setEntry(entry, newEntry);
                majorEntrys.add((Object)newEntry);
            }
            this.getModel().updateEntryCache(majorEntrys);
            this.getModel().setValue("taskentity", (Object)majorEntrys);
            this.getView().updateView("taskentity");
        }
    }

    private void setEntry(DynamicObject oldEntry, DynamicObject newEntry) {
        newEntry.set("taskname", (Object)oldEntry.getString("taskname"));
        newEntry.set("tasknumber", (Object)oldEntry.getString("tasknumber"));
        newEntry.set("controllevel", (Object)oldEntry.getDynamicObject("controllevel"));
        newEntry.set("spectype", (Object)oldEntry.getDynamicObject("spectype"));
        newEntry.set("tasktype", (Object)oldEntry.getDynamicObject("tasktype"));
        newEntry.set("absoluteshedule", (Object)oldEntry.getBigDecimal("absoluteshedule"));
        newEntry.set("pretask", (Object)oldEntry.getDynamicObject("pretask"));
        newEntry.set("level", (Object)oldEntry.getBigDecimal("level"));
        newEntry.set("isleaf", (Object)oldEntry.getBoolean("isleaf"));
        newEntry.set("relativeschedule", (Object)oldEntry.getBigDecimal("relativeschedule"));
        newEntry.set("planbegindate", (Object)oldEntry.getDate("planbegindate"));
        newEntry.set("planenddate", (Object)oldEntry.getDate("planenddate"));
        newEntry.set("directperson", (Object)oldEntry.getDynamicObject("directperson"));
        newEntry.set("directorg", (Object)oldEntry.getDynamicObject("directorg"));
        newEntry.set("indirectperson", (Object)oldEntry.getDynamicObject("indirectperson"));
        newEntry.set("indirectorg", (Object)oldEntry.getDynamicObject("indirectorg"));
        newEntry.set("taskid", (Object)oldEntry.getString("taskid"));
        newEntry.set("aimfinishtime", (Object)oldEntry.getDate("aimfinishtime"));
        newEntry.set("comptimedeviation", (Object)oldEntry.getBigDecimal("comptimedeviation"));
        newEntry.set("logical", (Object)oldEntry.getString("logical"));
        newEntry.set("achievementnode", (Object)oldEntry.getString("achievementnode"));
    }

    private DynamicObject ancestor(DynamicObject entry, String majorTypeId, DynamicObjectCollection projectEntrys) {
        Long pid = entry.getLong("pid");
        if (pid == null) {
            return null;
        }
        DynamicObject parentEntry = null;
        for (DynamicObject pEntry : projectEntrys) {
            if (pEntry.getLong("id") != pid.longValue()) continue;
            parentEntry = pEntry;
            break;
        }
        if (parentEntry == null) {
            return null;
        }
        DynamicObject spectype = parentEntry.getDynamicObject("spectype");
        if (spectype != null && spectype.getString("id").equals(majorTypeId)) {
            return parentEntry;
        }
        return this.ancestor(parentEntry, majorTypeId, projectEntrys);
    }

    private void openTaskPage(Map<Object, Object> customMap, String pkId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", "pmpm_task");
        map.put("customParams", customMap);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        if (pkId != null) {
            ((BillShowParameter)parameter).setPkId((Object)pkId);
        } else {
            customMap.put("majorproplanid", this.getModel().getDataEntity().getPkValue());
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                customMap.put("projectid", project.getString("id"));
            }
        }
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_task"));
        this.getView().showForm(parameter);
    }

    private void createTask(int index, String type) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity("taskentity", index);
        DynamicObject task = new DynamicObject(TaskConstant.dt);
        task.set("id", (Object)rowObj.getString("taskid"));
        task.set("parent", (Object)rowObj.getString("parent"));
        task.set("level", (Object)rowObj.getString("level"));
        task.set("isleaf", (Object)rowObj.getString("isleaf"));
        task.set("taskseq", (Object)index);
        task.set("enable", (Object)1);
        task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        task.set("project", (Object)project);
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        task.set("version", (Object)version);
        JSONObject plansJsonObject = new JSONObject();
        String majorPlanId = this.getModel().getDataEntity().getPkValue().toString();
        plansJsonObject.put("majorproplanid", (Object)majorPlanId);
        String plans = plansJsonObject.toString();
        task.set("plans", (Object)plans);
        DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
        task.set("belongplantype", (Object)majorType);
        task.set("majortype", (Object)majorType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        this.getView().invokeOperation("save");
    }

    private void setRowTaskLocked(int index) {
        this.getView().setEnable(Boolean.FALSE, index, MAJORPLAN_ROW_NAMES);
    }

    private void loadTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            PlanEntryUtil.setRowTaskObj((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)i);
            DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
            if (belongPlanType == null || !"1".equals(belongPlanType.getString("plantype"))) continue;
            this.setRowTaskLocked(i);
        }
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void loadPreTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask != null) continue;
            this.getModel().setValue("pretask", null, i);
            this.getModel().setValue("logical", null, i);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        switch (key = closedCallBackEvent.getActionId()) {
            case "pmpm_batchmodify": {
                Map dataMap = (Map)closedCallBackEvent.getReturnData();
                if (dataMap == null) break;
                String directperson = (String)dataMap.get("directperson");
                String directorg = (String)dataMap.get("directorg");
                String indirectperson = (String)dataMap.get("indirectperson");
                String indirectorg = (String)dataMap.get("indirectorg");
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
                int[] selRows = grid.getSelectRows();
                for (int k = 0; k < selRows.length; ++k) {
                    int index = selRows[k];
                    if (directperson != null) {
                        DynamicObject inDirectPerson = (DynamicObject)this.getModel().getValue("indirectperson", index);
                        if (inDirectPerson != null && directperson.equals(inDirectPerson.getString("id"))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"MajorPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                            this.getModel().setValue("directperson", null, index);
                        } else {
                            this.getModel().setValue("directperson", (Object)directperson, index);
                        }
                    }
                    if (directorg != null) {
                        this.getModel().setValue("directorg", (Object)directorg, index);
                    }
                    if (indirectperson != null) {
                        DynamicObject responsiblePerson = (DynamicObject)this.getModel().getValue("directperson", index);
                        if (responsiblePerson != null && indirectperson.equals(responsiblePerson.getString("id"))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"MajorPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                            this.getModel().setValue("indirectperson", null, index);
                        } else {
                            this.getModel().setValue("indirectperson", (Object)indirectperson, index);
                        }
                    }
                    if (indirectorg == null) continue;
                    this.getModel().setValue("indirectorg", (Object)indirectorg, index);
                }
                grid.selectRows(-1);
                break;
            }
            case "pmpm_task": {
                this.loadTask();
                this.setAdjustLocked();
                break;
            }
            case "pmpm_impprotaskf7": {
                String taskId;
                int i;
                Map taskMap = (Map)closedCallBackEvent.getReturnData();
                if (taskMap == null) {
                    return;
                }
                this.deleteAllTask();
                ArrayList saveTaskList = new ArrayList();
                HashMap taskIdRelation = new HashMap();
                for (Map.Entry entry : taskMap.entrySet()) {
                    String level = (String)entry.getKey();
                    ArrayList taskIdList = (ArrayList)entry.getValue();
                    PlanTaskImpAndExpUtil.cloneTaskToEntry((IFormView)this.getView(), (String)level, (ArrayList)taskIdList, saveTaskList, taskIdRelation);
                }
                DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
                try {
                    PlanTaskImpAndExpUtil.calculateByAbsoluteduration((IFormView)this.getView(), saveTaskList);
                    PlanTaskImpAndExpUtil.setPretask((IFormView)this.getView(), saveTaskList, taskIdRelation);
                }
                catch (Exception e) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u7684\u4efb\u52a1\u65e5\u671f\u8d85\u51fa\u65e5\u5386\u8303\u56f4\uff0c\u8bf7\u8bbe\u7f6e\u65e5\u5386\u540e\u518d\u91cd\u65b0\u5f15\u5165\u3002", (String)"MajorPlanEditPlugin_38", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                }
                if (saveTaskList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveTaskList.toArray(new DynamicObject[saveTaskList.size()]));
                }
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                for (i = 0; i < rowCount; ++i) {
                    taskId = (String)this.getModel().getValue("taskid", i);
                    DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                    PlanEntryUtil.setRowTaskObjForImp((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)i);
                }
                for (i = 0; i < rowCount; ++i) {
                    QFilter idFilter;
                    taskId = (String)this.getModel().getValue("taskid", i);
                    QFilter belongPlanTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
                    DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"pmpm_task", (String)"name", (QFilter[])new QFilter[]{belongPlanTypeFilter, idFilter = new QFilter("id", "=", (Object)taskId)});
                    if (taskObj != null) continue;
                    this.getModel().setValue("spectype", (Object)majorType.getString("id"), i);
                }
                for (DynamicObject task : saveTaskList) {
                    PmpmTaskUtil.updateParentTaskTime((DynamicObject[])saveTaskList.toArray(new DynamicObject[saveTaskList.size()]), (DynamicObject)task);
                }
                this.getView().invokeOperation("save");
                PlanTaskImpAndExpUtil.setEnableByLogical((IFormView)this.getView());
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "pmpm_taskimpdialog": {
                List taskList = (List)closedCallBackEvent.getReturnData();
                if (taskList == null || taskList.size() <= 0) {
                    return;
                }
                this.deleteAllTask();
                this.getModel().updateCache();
                int curLevel = 1;
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                int maxLevel = curLevel;
                for (DynamicObject task : taskList) {
                    if (task.getBigDecimal("level") == null || task.getBigDecimal("level").compareTo(BigDecimal.valueOf(maxLevel)) <= 0) continue;
                    maxLevel = task.getBigDecimal("level").intValue();
                }
                while (true) {
                    ArrayList<DynamicObject> sameLevelTaskList = new ArrayList<DynamicObject>();
                    for (DynamicObject task : taskList) {
                        if (task.getInt("level") != curLevel) continue;
                        sameLevelTaskList.add(task);
                    }
                    if (curLevel > maxLevel) break;
                    PlanTaskImpAndExpUtil.loadSameLevelTask((IFormView)this.getView(), (List)taskList, sameLevelTaskList, (int)curLevel);
                    ++curLevel;
                }
                this.getView().invokeOperation("save");
                break;
            }
        }
    }

    private void deleteAllTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (rowCount > 0) {
            ArrayList<String> delEntryIdsList = new ArrayList<String>();
            ArrayList<String> delTaskIdsList = new ArrayList<String>();
            for (int i = rowCount - 1; i >= 0; --i) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity("taskentity", i);
                String taskId = rowObj.getString("taskid");
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                String plans = task.getString("plans");
                JSONObject plansObj = JSONObject.parseObject((String)plans);
                if (plansObj.get((Object)"majorproplanid") == null) continue;
                delEntryIdsList.add(rowObj.getPkValue().toString());
                delTaskIdsList.add(taskId);
                this.getModel().deleteEntryRow("taskentity", i);
                this.getModel().updateCache();
            }
            DynamicObjectType subEntryDt = DynamicObjectTypeUtils.getEntryDynamicObjectType((String)"pmpm_majorplan", (String)"taskentity");
            if (delEntryIdsList.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)subEntryDt, (Object[])delEntryIdsList.toArray());
            }
            if (delTaskIdsList.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])delTaskIdsList.toArray());
            }
        }
    }

    private void setMajorTypeFilter() {
        DynamicObject projectKind;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null && (projectKind = (project = BusinessDataServiceHelper.loadSingle((Object)project.getString("id"), (String)"bd_project", (String)"group")).getDynamicObject("group")) != null) {
            BasedataEdit majorTypeCtl = (BasedataEdit)this.getControl("majortype");
            majorTypeCtl.setQFilter(new QFilter("group", "=", (Object)projectKind.getString("id")));
            BasedataEdit entrySpecType = (BasedataEdit)this.getControl("spectype");
            entrySpecType.setQFilter(new QFilter("group", "=", (Object)projectKind.getString("id")));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("spectype");
        keyList.add("directorg");
        keyList.add("directperson");
        keyList.add("indirectorg");
        keyList.add("indirectperson");
        keyList.add("pretask");
        String propName = arg.getProperty().getName();
        if (keyList.contains(propName)) {
            PlanEntryUtil.beforeEntryF7Select((IFormView)this.getView(), (IDataModel)this.getModel(), (BeforeF7SelectEvent)arg);
            return;
        }
        switch (propName) {
            case "projectplan": {
                this.setProjectPlanFilter(arg);
                break;
            }
        }
    }

    private boolean isMainTask(String taskId) {
        if (taskId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1ID\u4e3a\u7a7a", (String)"MajorPlanEditPlugin_39", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        return "1".equals((belongplantype = BusinessDataServiceHelper.loadSingle((Object)belongplantype.getString("id"), (String)"pmpm_majortype", (String)"plantype")).getString("plantype"));
    }

    private boolean checkOutMainTaskTime(String timeField, Object oldTime, int curIndex) {
        this.getModel().beginInit();
        Date newTime = (Date)this.getModel().getValue(timeField, curIndex);
        String taskId = (String)this.getModel().getValue("taskid");
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        belongplantype = BusinessDataServiceHelper.loadSingle((Object)belongplantype.getString("id"), (String)"pmpm_majortype", (String)"plantype");
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask((DynamicObject)task)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        Date oldDate;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"MajorPlanEditPlugin_40", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        if (oldTime != null && (oldDate = (Date)oldTime).before(sourceTaskPlanStartTime)) {
                            this.getModel().setValue(timeField, null, curIndex);
                            return true;
                        }
                        this.getModel().setValue(timeField, oldTime, curIndex);
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        Date oldDate;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"MajorPlanEditPlugin_41", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        if (oldTime != null && (oldDate = (Date)oldTime).before(sourceTaskPlanStartTime)) {
                            this.getModel().setValue(timeField, null, curIndex);
                            return true;
                        }
                        this.getModel().setValue(timeField, oldTime, curIndex);
                        return true;
                    }
                }
            }
        }
        this.getModel().endInit();
        this.getView().updateView("taskentity");
        return false;
    }

    private void setAllRowLocked() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            Object preChangePlan;
            boolean isleaf;
            String taskId = (String)this.getModel().getValue("taskid", i);
            boolean isMainTask = this.isMainTask(taskId);
            if (isMainTask) {
                this.setRowTaskLocked(i);
            }
            if (!(isleaf = ((Boolean)this.getModel().getValue("isleaf", i)).booleanValue())) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"pretask", "logical", "planbegindate", "planenddate"});
            }
            if ((preChangePlan = this.getModel().getValue("prechangeplan")) == null) continue;
            this.setAdjustLocked();
        }
    }

    private void setAdjustLocked() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"completionstatus,prechangetask");
            if ((CompletionStatusEnum.UNSTART.getValue().equals(task.get("completionstatus")) || CompletionStatusEnum.PROGRESSING.getValue().equals(task.get("completionstatus"))) && task.getDynamicObject("prechangetask") != null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"taskname", "controllevel", "spectype", "tasktype", "achievementnode"});
                continue;
            }
            if (!CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(task.get("completionstatus")) && !CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(task.get("completionstatus"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, PROJECTPLAN_ROW_NAMES);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String status = this.getModel().getDataEntity().getString("billstatus");
        if ("B".equals(status) || "C".equals(status)) {
            e.setCheckDataChange(false);
        }
    }

    private void saveTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        ArrayList<DynamicObject> savedTaskArr = new ArrayList<DynamicObject>();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity("taskentity", i);
            String taskId = (String)this.getModel().getValue("taskid", i);
            if (this.isMainTask(taskId)) continue;
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            task.set("name", (Object)rowObj.getString("taskname"));
            task.set("number", (Object)rowObj.getString("tasknumber"));
            task.set("controllevel", (Object)rowObj.getDynamicObject("controllevel"));
            task.set("majortype", (Object)rowObj.getDynamicObject("spectype"));
            task.set("tasktype", (Object)rowObj.getDynamicObject("tasktype"));
            task.set("absoluteduration", (Object)rowObj.getBigDecimal("absoluteshedule"));
            task.set("pretask", (Object)rowObj.getDynamicObject("pretask"));
            task.set("logical", (Object)rowObj.getString("logical"));
            task.set("parent", (Object)rowObj.getDynamicObject("parent"));
            task.set("level", (Object)rowObj.getBigDecimal("level"));
            task.set("isleaf", (Object)rowObj.getBoolean("isleaf"));
            task.set("relativeduration", (Object)rowObj.getBigDecimal("relativeschedule"));
            task.set("planstarttime", (Object)rowObj.getDate("planbegindate"));
            task.set("planendtime", (Object)rowObj.getDate("planenddate"));
            task.set("aimfinishtime", (Object)rowObj.getDate("aimfinishtime"));
            task.set("comptimedeviation", (Object)rowObj.getBigDecimal("comptimedeviation"));
            task.set("responsibleperson", (Object)rowObj.getDynamicObject("directperson"));
            task.set("responsibledept", (Object)rowObj.getDynamicObject("directorg"));
            task.set("cooperationperson", (Object)rowObj.getDynamicObject("indirectperson"));
            task.set("cooperationdept", (Object)rowObj.getDynamicObject("indirectorg"));
            task.set("achievementnode", (Object)rowObj.getString("achievementnode"));
            task.set("taskseq", (Object)(i + 1));
            savedTaskArr.add(task);
        }
        SaveServiceHelper.save((DynamicObject[])savedTaskArr.toArray(new DynamicObject[savedTaskArr.size()]));
    }

    private DynamicObject[] getProCal(Object projectId) {
        QFilter projectFilter = new QFilter("project", "=", projectId);
        DynamicObject[] projectCalendarArr = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)"id,project,modifytime,version", (QFilter[])new QFilter[]{projectFilter}, (String)"modifytime desc");
        return projectCalendarArr;
    }

    private boolean isBeforePlanAudit(Object projectId, Object prePlanId) {
        boolean flag = false;
        DynamicObject[] proCalArr = this.getProCal(projectId);
        if (proCalArr != null && proCalArr.length > 0) {
            DynamicObject lastProCal = proCalArr[0];
            Date modifyTime = lastProCal.getDate("modifytime");
            DynamicObject prePlanObj = BusinessDataServiceHelper.loadSingle((Object)prePlanId, (String)"pmpm_majorplan");
            Date auditTime = prePlanObj.getDate("auditdate");
            if (modifyTime != null && auditTime != null && modifyTime.after(auditTime)) {
                flag = true;
            }
        }
        return flag;
    }
}

