/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmListPlugin;

public class PersonPlanBillListPlugin
extends AbstractPmpmListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List list = args.getCommonFilterColumns();
        Long orgId = RequestContext.get().getOrgId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List deptList = UserServiceHelper.getUserDepartment((long)userId, (boolean)true);
        if (null == deptList || !deptList.contains(orgId)) {
            CommonFilterColumn userCFC = (CommonFilterColumn)list.get(4);
            List<ComboItem> comboItems = this.buildUserComboItem(userId);
            userCFC.setComboItems(comboItems);
            userCFC.setDefaultValue(RequestContext.get().getUserId());
        } else {
            CommonFilterColumn userCFC = (CommonFilterColumn)list.get(4);
            List<ComboItem> comboItemsOfOrg = this.buildUserOfOrgComboItem(RequestContext.get().getOrgId());
            userCFC.setComboItems(comboItemsOfOrg);
            userCFC.setDefaultValue(RequestContext.get().getUserId());
        }
    }

    private List<ComboItem> buildUserComboItem(Long userId) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        ComboItem item = new ComboItem();
        item.setId(user.getString("id"));
        item.setCaption(new LocaleString(user.getString("name")));
        item.setValue(user.getString("id"));
        combos.add(item);
        return combos;
    }

    private List<ComboItem> buildUserOfOrgComboItem(Long orgId) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        List directUsersOfOrg = UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)true);
        QFilter idFilter = new QFilter("id", "in", (Object)directUsersOfOrg);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] bos_users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])filters);
        for (int i = 0; i < bos_users.length; ++i) {
            ComboItem item = new ComboItem();
            item.setId(bos_users[i].getString("id"));
            item.setCaption(new LocaleString(bos_users[i].getString("name")));
            item.setValue(bos_users[i].getString("id"));
            combos.add(item);
        }
        return combos;
    }

    public void setFilter(SetFilterEvent e) {
        List filterList = e.getQFilters();
        QFilter deptQFilter = null;
        for (QFilter qFilter : filterList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"planperson")) continue;
            deptQFilter = qFilter;
        }
        if (null != deptQFilter) {
            QFilter deptFilter;
            filterList.remove(deptQFilter);
            Object value = deptQFilter.getValue();
            if (value instanceof ArrayList) {
                deptFilter = new QFilter("modifier", "in", deptQFilter.getValue());
                filterList.add(deptFilter);
            } else {
                deptFilter = new QFilter("modifier", "=", deptQFilter.getValue());
                filterList.add(deptFilter);
            }
        }
    }
}

