/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmBillPlugin;

public class PersonTaskCalendarViewPlugin
extends AbstractPmpmBillPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(PersonTaskCalendarViewPlugin.class);
    private static final Log LOG = LogFactory.getLog(PersonTaskCalendarViewPlugin.class);
    private static final int ROW = 7;
    private static final int COL = 8;
    private static final String TIME_KEY = "datefield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.addClickListeners(new String[]{"buttonap_" + i + "_" + j});
            }
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date datefield;
        if (TIME_KEY.equals(e.getProperty().getName()) && (datefield = (Date)this.getModel().getValue(TIME_KEY)) != null) {
            this.setCalendar(datefield);
        }
    }

    public void init() {
        this.setCalendar(new Date());
    }

    private void setCalendar(Date date) {
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> infoMap = new HashMap<String, String>(16);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("tasks");
        JSONArray jsons = (JSONArray)customParam;
        for (Object json : jsons) {
            JSONObject object = (JSONObject)json;
            String entryid = object.get((Object)"id").toString();
            String planstarttime = object.get((Object)"planstarttime").toString();
            String taskname = object.get((Object)"taskname").toString();
            infoMap.put(entryid, planstarttime + "@22KD&&@" + taskname);
        }
        int index = 1;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                this.getModel().setValue("textfield_" + i + "_" + j, (Object)dfnyr.format(calendar.getTime()));
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("<div title=\"\"><div style=\"text-align:right;\"><span style=\"width:28px;font-size:16px;height:28px;color:#333333;border-radius:50%;display:inline-block;line-height:28px;text-align:center;");
                if (index < weekday || index - weekday - maxday + 1 > 0) {
                    sBuilder.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(dfnyr.format(calendar.getTime()))) {
                    sBuilder.append("background:rgba(95,137,243,1);");
                    sBuilder.append("color:#ffffff;");
                }
                sBuilder.append("\">").append(dfdd.format(calendar.getTime())).append("</span>").append("</div>");
                int k = 0;
                for (Map.Entry entry : infoMap.entrySet()) {
                    String value = (String)entry.getValue();
                    String[] split = value.split("@22KD&&@");
                    String starttime = split[0];
                    String taskname = split[1];
                    int tasknamelength = taskname.length();
                    String tasknametitle = null;
                    tasknametitle = tasknamelength > 6 ? taskname.substring(0, 6) + "..." : taskname;
                    Date starttimeFrom = null;
                    try {
                        starttimeFrom = dfnyr.parse(starttime);
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                    }
                    if (!dfnyr.format(starttimeFrom).equals(dfnyr.format(calendar.getTime()))) continue;
                    sBuilder.append("<div style=\"text-align:left\" id=\"item_").append(i).append('_').append(j).append('_').append(k).append("\">");
                    sBuilder.append("<span style=\"background:#FC8555;width:4px;height:4px;display:inline-block;font-size:large;\"></span>");
                    sBuilder.append("<span style=\"color:rgba(51,51,51,1);margin-left:4px;font-size:large;\">").append(tasknametitle).append("</span>");
                    sBuilder.append("</div>");
                    if (++k <= 1) continue;
                    break;
                }
                sBuilder.append("</div></div>");
                html.setConent(sBuilder.toString());
                ++index;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        String btnNumber = key.split("buttonap_")[1];
        String value = this.getModel().getValue("textfield_" + btnNumber).toString();
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        IDataModel model = entryGrid.getModel();
        model.deleteEntryData("treeentryentity");
        Date parse = null;
        try {
            parse = dfnyr.parse(value);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        Object customParam = this.getView().getFormShowParameter().getCustomParam("tasks");
        JSONArray jsons = (JSONArray)customParam;
        int size = jsons.size();
        for (int i = 0; i < size; ++i) {
            JSONObject object = (JSONObject)jsons.get(i);
            String taskid = object.get((Object)"taskid").toString();
            String planstarttime = object.get((Object)"planstarttime").toString();
            Date starttimeFrom = null;
            try {
                starttimeFrom = dfnyr.parse(planstarttime);
                if (!starttimeFrom.equals(parse)) continue;
                int entryRow = model.createNewEntryRow("treeentryentity");
                this.getModel().setValue("taskname", (Object)taskid, entryRow);
                continue;
            }
            catch (ParseException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        String fieldName = arg.getFieldName();
        int rowIndex = arg.getRowIndex();
        DynamicObject fieldValue = (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
        this.openUpdateParameter(fieldValue);
    }

    private void openUpdateParameter(DynamicObject task) {
        String id = task.getPkValue().toString();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject plantype = (DynamicObject)task.get("belongplantype");
        DynamicObject plamtypeObj = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)"pmpm_majortype");
        Object orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        if (StringUtils.equalsIgnoreCase((CharSequence)plamtypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plamtypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAJORPLAN.getValue())) {
            map.put("formId", "pmpm_deptprojecttasktk");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)plamtypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue())) {
            map.put("deptId", orgid);
            map.put("formId", "pmpm_depttasktk");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)plamtypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) {
            map.put("formId", "pmpm_task");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)plamtypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue())) {
            map.put("formId", "pmpm_persontask");
        }
        map.put("actionId", "showtask");
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
        DynamicObject taskobj = (DynamicObject)entryRowEntity.get("taskname");
        String taskstatus = taskobj.getString("status");
        if (OperationStatus.VIEW.equals((Object)status) || StringUtils.equals((CharSequence)taskstatus, (CharSequence)StatusEnum.CHECKED.getValue()) || StringUtils.equals((CharSequence)taskstatus, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updateentry"));
        ((BillShowParameter)parameter).setPkId((Object)id);
        this.getView().showForm(parameter);
    }
}

