/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmBillPlugin;

public class PmpmTaskEditPlugin
extends AbstractPmpmBillPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(PmpmTaskEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid taskReferDocEntry = (EntryGrid)this.getControl("taskreferdocentry");
        taskReferDocEntry.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit preTask = (BasedataEdit)this.getControl("pretask");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("responsibleperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("responsibledept");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationPerson = (BasedataEdit)this.getControl("cooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationDept = (BasedataEdit)this.getControl("cooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taskType = (BasedataEdit)this.getControl("tasktype");
        taskType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit majorTypeEdit = (BasedataEdit)this.getControl("majortype");
        majorTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject responsibleDept;
        DynamicObject responsiblePreson;
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        Date planEndTime = this.getModel().getDataEntity().getDate("planendtime");
        Date planStartTime = this.getModel().getDataEntity().getDate("planstarttime");
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"attachmentfield")) {
            this.carryEntryDocName(changeSet);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"pretask")) {
            this.controlLogicalInputByPreTask();
            this.calPlanTimeByPreTaskAndLogical();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"achievementnode")) {
            this.controlResultDocEntry();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"aimfinishtime")) {
            this.calCompTimeDeviation();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"planstarttime")) {
            if (planStartTime == null) {
                return;
            }
            if (planStartTime != null && planEndTime != null && planStartTime.after(planEndTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4", (String)"PmpmTaskEditPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("planstarttime", changeSet.getOldValue());
                return;
            }
            this.deptFenjie("planstarttime");
            this.calPlanTime("planstarttime");
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"planendtime")) {
            if (planEndTime == null) {
                return;
            }
            if (planStartTime != null && planEndTime != null && planStartTime.after(planEndTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"PmpmTaskEditPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("planendtime", null);
                return;
            }
            this.deptFenjie("planendtime");
            this.calPlanTime("planendtime");
            this.calCompTimeDeviation();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"absoluteduration")) {
            BigDecimal oldValue = (BigDecimal)changeSet.getOldValue();
            BigDecimal newValue = (BigDecimal)changeSet.getNewValue();
            if (newValue.compareTo(BigDecimal.ONE) < 0) {
                this.getModel().setValue("absoluteduration", (Object)oldValue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u9700\u8981\u5927\u4e8e0", (String)"PmpmTaskEditPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            }
            this.calPlanTime("absoluteduration");
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"relativeduration")) {
            this.calPlanTimeByPreTaskAndLogical();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"logical")) {
            this.calPlanTimeByPreTaskAndLogical();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"cooperationperson")) {
            DynamicObject cooperationDept;
            DynamicObject cooperationPreson = this.getModel().getDataEntity().getDynamicObject("cooperationperson");
            if (cooperationPreson != null && (cooperationDept = this.getModel().getDataEntity().getDynamicObject("cooperationdept")) == null) {
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(cooperationPreson.getPkValue().toString()));
                this.getModel().setValue("cooperationdept", (Object)orgId);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"responsibleperson") && (responsiblePreson = this.getModel().getDataEntity().getDynamicObject("responsibleperson")) != null && (responsibleDept = this.getModel().getDataEntity().getDynamicObject("responsibledept")) == null) {
            long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePreson.getPkValue().toString()));
            this.getModel().setValue("responsibledept", (Object)orgId);
        }
    }

    private boolean newCheckOutMainTaskTime(String timeField, Date newTime) {
        if (newTime == null) {
            return false;
        }
        DynamicObject belongPlanType = this.getModel().getDataEntity().getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            boolean isFromDB;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (isFromDB = this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask((DynamicObject)this.getModel().getDataEntity())).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PmpmTaskEditPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("pretask", null);
                        this.getModel().setValue("logical", null);
                        this.getView().updateView("logical");
                        this.getView().updateView("pretask");
                        this.controlLogicalInputByPreTask();
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PmpmTaskEditPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("logical", null);
                        this.getModel().setValue("pretask", null);
                        this.getView().updateView("logical");
                        this.getView().updateView("pretask");
                        this.controlLogicalInputByPreTask();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean checkOutMainTaskTime(String timeField, Date newTime) {
        if (newTime == null) {
            return false;
        }
        DynamicObject belongPlanType = this.getModel().getDataEntity().getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            boolean isFromDB;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (isFromDB = this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask((DynamicObject)this.getModel().getDataEntity())).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PmpmTaskEditPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PmpmTaskEditPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void calPlanTimeByPreTaskAndLogical() {
        Date preTaskPlanEndTime;
        DynamicObject preTask = this.getModel().getDataEntity().getDynamicObject("pretask");
        if (preTask == null) {
            return;
        }
        String logical = this.getModel().getDataEntity().getString("logical");
        BigDecimal absDuration = this.getModel().getDataEntity().getBigDecimal("absoluteduration");
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        int relativeduration = this.getModel().getDataEntity().getInt("relativeduration");
        if (++relativeduration < 0) {
            --relativeduration;
        }
        if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
            Date preTaskPlanStartTime = preTask.getDate("planstarttime");
            if (preTaskPlanStartTime != null && project != null) {
                try {
                    Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration);
                    if (this.newCheckOutMainTaskTime("planstarttime", planStartTime)) {
                        return;
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue("planstarttime", (Object)planStartTime);
                    this.getModel().endInit();
                    try {
                        Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absDuration.intValue() - 1));
                        if (!this.newCheckOutMainTaskTime("planendtime", planEndTime)) {
                            this.getModel().beginInit();
                            this.getModel().setValue("planendtime", (Object)planEndTime);
                            if (absDuration.compareTo(BigDecimal.ZERO) == 0) {
                                this.getModel().setValue("absoluteduration", (Object)BigDecimal.ONE);
                                this.getModel().setValue("planstarttime", (Object)planStartTime);
                            }
                            this.getModel().endInit();
                        }
                    }
                    catch (KDBizException e) {
                        this.getView().showTipNotification(e.getMessage());
                        this.getModel().beginInit();
                        this.getModel().setValue("planendtime", null);
                        this.getModel().endInit();
                    }
                }
                catch (KDBizException e) {
                    this.getView().showTipNotification(e.getMessage());
                    this.getModel().beginInit();
                    this.getModel().setValue("planstarttime", null);
                    this.getModel().endInit();
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
            Date preTaskPlanEndTime2 = preTask.getDate("planendtime");
            if (preTaskPlanEndTime2 != null && project != null) {
                try {
                    Date planStartTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime2, (int)relativeduration);
                    if (!this.newCheckOutMainTaskTime("planstarttime", planStartTime)) {
                        this.getModel().beginInit();
                        this.getModel().setValue("planstarttime", (Object)planStartTime);
                        this.getModel().endInit();
                    }
                    try {
                        Date planEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absDuration.intValue() - 1));
                        if (!this.newCheckOutMainTaskTime("planendtime", planEndTime)) {
                            this.getModel().beginInit();
                            this.getModel().setValue("planendtime", (Object)planEndTime);
                            if (absDuration.compareTo(BigDecimal.ZERO) == 0) {
                                this.getModel().setValue("absoluteduration", (Object)BigDecimal.ONE);
                            }
                            this.getModel().endInit();
                        }
                    }
                    catch (KDBizException e) {
                        this.getModel().beginInit();
                        this.getView().showTipNotification(e.getMessage());
                        this.getModel().setValue("planendtime", null);
                        this.getModel().endInit();
                    }
                }
                catch (KDBizException e) {
                    this.getModel().beginInit();
                    this.getView().showTipNotification(e.getMessage());
                    this.getModel().setValue("planstarttime", null);
                    this.getModel().endInit();
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
            Date preTaskPlanStartTime = preTask.getDate("planstarttime");
            if (preTaskPlanStartTime != null && project != null) {
                try {
                    Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeduration);
                    if (!this.newCheckOutMainTaskTime("planendtime", planEndTime)) {
                        this.getModel().beginInit();
                        this.getModel().setValue("planendtime", (Object)planEndTime);
                        if (absDuration.compareTo(BigDecimal.ZERO) == 0) {
                            this.getModel().setValue("absoluteduration", (Object)BigDecimal.ONE);
                        }
                        this.getModel().endInit();
                    }
                    try {
                        Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absDuration.intValue()));
                        if (!this.newCheckOutMainTaskTime("planstarttime", planStartTime)) {
                            this.getModel().beginInit();
                            this.getModel().setValue("planstarttime", (Object)planStartTime);
                            this.getModel().endInit();
                        }
                    }
                    catch (KDBizException e) {
                        this.getModel().beginInit();
                        this.getView().showTipNotification(e.getMessage());
                        this.getModel().setValue("planstarttime", null);
                        this.getModel().endInit();
                    }
                }
                catch (KDBizException e) {
                    this.getModel().beginInit();
                    this.getView().showTipNotification(e.getMessage());
                    this.getModel().setValue("planendtime", null);
                    this.getModel().endInit();
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && (preTaskPlanEndTime = preTask.getDate("planendtime")) != null && project != null) {
            try {
                Date planEndTime = PmpmTaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeduration);
                if (!this.newCheckOutMainTaskTime("planendtime", planEndTime)) {
                    this.getModel().beginInit();
                    this.getModel().setValue("planendtime", (Object)planEndTime);
                    if (absDuration.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue("absoluteduration", (Object)BigDecimal.ONE);
                    }
                    this.getModel().endInit();
                }
                try {
                    Date planStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absDuration.intValue()));
                    if (!this.newCheckOutMainTaskTime("planstarttime", planStartTime)) {
                        this.getModel().beginInit();
                        this.getModel().setValue("planstarttime", (Object)planStartTime);
                        this.getModel().endInit();
                    }
                }
                catch (KDBizException e) {
                    this.getModel().beginInit();
                    this.getView().showTipNotification(e.getMessage());
                    this.getModel().setValue("planstarttime", null);
                    this.getModel().endInit();
                }
            }
            catch (KDBizException e) {
                this.getModel().beginInit();
                this.getView().showTipNotification(e.getMessage());
                this.getModel().setValue("planendtime", null);
                this.getModel().endInit();
            }
        }
        this.getView().updateView("planstarttime");
        this.getView().updateView("planendtime");
        this.getView().updateView("aimfinishtime");
        this.getView().updateView("absoluteduration");
        this.calCompTimeDeviation();
    }

    private void deptFenjie(String changeField) {
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        Date planEndTime = model.getDate("planendtime");
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype");
        switch (changeField) {
            case "planstarttime": {
                Date parentStart;
                if (null == planStartTime || null == parent || null == plantype || !StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue()) || DateUtil.compareByDay((Date)planStartTime, (Date)(parentStart = parent.getDate("planstarttime"))) >= 0) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5206\u89e3\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4", (String)"PmpmTaskEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "planendtime": {
                Date parentEnd;
                if (null == planEndTime || null == parent || null == plantype || !StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue()) || DateUtil.compareByDay((Date)planEndTime, (Date)(parentEnd = parent.getDate("planendtime"))) <= 0) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5206\u89e3\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4", (String)"PmpmTaskEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void calPlanTime(String changeField) {
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        BigDecimal absoluteDuration = model.getBigDecimal("absoluteduration");
        Date planEndTime = model.getDate("planendtime");
        DynamicObject project = model.getDynamicObject("project");
        DynamicObject preTask = model.getDynamicObject("pretask");
        String logical = model.getString("logical");
        switch (changeField) {
            case "absoluteduration": {
                if (preTask != null && (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) || StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical))) {
                    if (planEndTime == null) break;
                    this.getModel().beginInit();
                    if (project != null) {
                        Date newPlanStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()));
                        if (!this.checkOutMainTaskTime("planstarttime", newPlanStartTime)) {
                            this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                        } else {
                            this.getModel().setValue("planstarttime", null);
                            this.getView().updateView("planstarttime");
                            this.getModel().endInit();
                            return;
                        }
                    }
                    this.getModel().endInit();
                    this.getView().updateView("planstarttime");
                    break;
                }
                if (planStartTime != null) {
                    this.getModel().beginInit();
                    if (project != null) {
                        Date newPlanEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                        if (!this.checkOutMainTaskTime("planendtime", newPlanEndTime)) {
                            this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                        } else {
                            this.getModel().setValue("planendtime", null);
                            this.getView().updateView("planendtime");
                            this.getModel().endInit();
                            return;
                        }
                    }
                    this.calCompTimeDeviation();
                    this.getModel().endInit();
                    this.getView().updateView("planendtime");
                    break;
                }
                if (planEndTime == null) break;
                this.getModel().beginInit();
                if (project != null) {
                    Date newPlanStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()));
                    if (!this.checkOutMainTaskTime("planstarttime", newPlanStartTime)) {
                        this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                    } else {
                        this.getModel().setValue("planstarttime", null);
                        this.getView().updateView("planstarttime");
                        this.getModel().endInit();
                        return;
                    }
                }
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                break;
            }
            case "planendtime": {
                if (planStartTime != null) {
                    this.getModel().beginInit();
                    if (project != null) {
                        BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                    }
                    this.getModel().endInit();
                    this.getView().updateView("absoluteduration");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().beginInit();
                if (project != null) {
                    Date newPlanStartTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()));
                    if (!this.checkOutMainTaskTime("planstarttime", newPlanStartTime)) {
                        this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                    } else {
                        this.getModel().setValue("planstarttime", null);
                        this.getView().updateView("planstarttime");
                        this.getModel().endInit();
                        return;
                    }
                }
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                break;
            }
            case "planstarttime": {
                if (preTask != null && (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical))) {
                    if (planEndTime == null) break;
                    this.getModel().beginInit();
                    if (project != null) {
                        BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                    }
                    this.getModel().endInit();
                    this.getView().updateView("absoluteduration");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
                    if (planEndTime == null) break;
                    this.getModel().beginInit();
                    if (project != null) {
                        BigDecimal newAbsoluteDuration = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime);
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                    }
                    this.getModel().endInit();
                    this.getView().updateView("absoluteduration");
                    break;
                }
                if (absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().beginInit();
                if (project != null) {
                    Date newPlanEndTime = PmpmTaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                    if (!this.checkOutMainTaskTime("planendtime", newPlanEndTime)) {
                        this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                    } else {
                        this.getModel().setValue("planendtime", null);
                        this.getView().updateView("planendtime");
                        this.getModel().endInit();
                        return;
                    }
                }
                this.calCompTimeDeviation();
                this.getModel().endInit();
                this.getView().updateView("planendtime");
                this.getView().updateView("aimfinishtime");
                break;
            }
        }
    }

    private void calCompTimeDeviation() {
        Date aimFinishTime = this.getModel().getDataEntity().getDate("aimfinishtime");
        Date planEndTime = this.getModel().getDataEntity().getDate("planendtime");
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                BigDecimal days = PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planEndTime, (Date)aimFinishTime);
                this.getModel().setValue("comptimedeviation", (Object)days);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
        }
        this.getView().updateView("comptimedeviation");
        this.updateTimeDeviationColor();
    }

    private void controlResultDocEntry() {
        String achievementNode = (String)this.getModel().getValue("achievementnode");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)achievementNode)) {
            this.getModel().deleteEntryData("taskresultdocentry");
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)achievementNode)) {
            int rowIndex = this.getModel().createNewEntryRow("taskresultdocentry");
            this.getModel().setValue("resultname", (Object)ResManager.loadKDString((String)"\u5176\u4ed6\u6210\u679c", (String)"PmpmTaskEditPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), rowIndex);
            this.getModel().setValue("force", (Object)Boolean.FALSE, rowIndex);
        }
    }

    private void carryEntryDocName(ChangeData changeSet) {
        DynamicObject bdAtt;
        DynamicObject attachment;
        DynamicObjectCollection attachmentCol = (DynamicObjectCollection)changeSet.getNewValue();
        if (attachmentCol != null && attachmentCol.size() > 0 && (attachment = (DynamicObject)attachmentCol.get(0)) != null && (bdAtt = attachment.getDynamicObject("fbasedataid")) != null) {
            String fileName = bdAtt.getString("name");
            int rowIndex = changeSet.getRowIndex();
            this.getModel().setValue("referdocname", (Object)fileName, rowIndex);
        }
    }

    private void controlLogicalInputByPreTask() {
        Object newPreTask = this.getModel().getValue("pretask");
        ComboEdit logicalEdit = (ComboEdit)this.getControl("logical");
        ComboProp logicalProp = (ComboProp)this.getModel().getDataEntityType().getProperty("logical");
        if (newPreTask != null) {
            logicalEdit.setMustInput(true);
            logicalProp.setMustInput(true);
        } else {
            logicalEdit.setMustInput(false);
            logicalProp.setMustInput(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            if (null != customMap.get("deptId") && null != customMap.get("starttime") && null != customMap.get("endtime")) {
                boolean flag;
                String starttime = customMap.get("starttime").toString();
                String endtime = customMap.get("endtime").toString();
                Date taskstarttimeFrom = null;
                Date taskendtimeTo = null;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    taskstarttimeFrom = dateFormat.parse(starttime);
                    taskendtimeTo = dateFormat.parse(endtime);
                }
                catch (ParseException e) {
                    LOG.error((Throwable)e);
                }
                Date planstarttime = (Date)this.getModel().getValue("planstarttime");
                Date planendtime = (Date)this.getModel().getValue("planendtime");
                if (null != planstarttime && null != planendtime && !(flag = this.responsAndCoopration(taskstarttimeFrom, taskendtimeTo))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u4e0e\u90e8\u95e8\u8ba1\u5212\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u3002", (String)"PmpmTaskEditPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            int rowCount = this.getModel().getEntryRowCount("taskresultdocentry");
            String resultDoc = this.getModel().getDataEntity().getString("resultdoc");
            if (rowCount != 0) {
                String newResultDoc = PmpmTaskUtil.updateResultDoc((String)resultDoc, (int)1, (int)rowCount);
                this.getModel().setValue("resultdoc", (Object)newResultDoc);
            }
        }
    }

    private boolean responsAndCoopration(Date taskstarttimeFrom, Date taskendtimeTo) {
        Date planstarttime = (Date)this.getModel().getValue("planstarttime");
        Date planendtime = (Date)this.getModel().getValue("planendtime");
        if (planstarttime.equals(taskstarttimeFrom) && planendtime.equals(taskendtimeTo)) {
            return true;
        }
        return !planendtime.before(taskstarttimeFrom) && !planstarttime.after(taskendtimeTo);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map paramMap = showParameter.getCustomParams();
        this.initTask(paramMap);
    }

    private void initTask(Map<String, Object> paramMap) {
        DynamicObject majorType;
        Object parentTaskId = paramMap.get("parenttaskid");
        Object projectId = paramMap.get("projectid");
        this.getModel().setValue("project", projectId);
        Object taskSeq = paramMap.get("seq");
        this.getModel().setValue("taskseq", taskSeq);
        Object mainproPlanId = paramMap.get("mainproplanid");
        Object majorproPlanId = paramMap.get("majorproplanid");
        Object deptPlanId = paramMap.get("deptplanid");
        Object privatePlanId = paramMap.get("privateplanid");
        if (parentTaskId != null) {
            this.getModel().setValue("parent", parentTaskId);
            this.getModel().setValue("isleaf", (Object)"1");
        }
        JSONObject plansJsonObject = new JSONObject();
        if (mainproPlanId != null) {
            plansJsonObject.put("mainproplanid", mainproPlanId);
            majorType = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"id,plantype", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue())});
            this.getModel().setValue("belongplantype", (Object)majorType);
        }
        if (majorproPlanId != null) {
            plansJsonObject.put("majorproplanid", majorproPlanId);
        }
        if (deptPlanId != null) {
            DynamicObject parent;
            plansJsonObject.put("deptplanid", deptPlanId);
            majorType = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"id,plantype", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue())});
            this.getModel().setValue("belongplantype", (Object)majorType);
            if (null != parentTaskId && null != (parent = BusinessDataServiceHelper.loadSingle((Object)parentTaskId, (String)"pmpm_task")).get("project")) {
                this.copyDeptTask(parent);
            }
        }
        if (privatePlanId != null) {
            plansJsonObject.put("privateplanid", privatePlanId);
        }
        String plans = plansJsonObject.toString();
        this.getModel().setValue("plans", (Object)plans);
    }

    private void copyDeptTask(DynamicObject parent) {
        this.getModel().setValue("controllevel", parent.get("controllevel"));
        this.getModel().setValue("majortype", parent.get("majortype"));
        this.getModel().setValue("tasktype", parent.get("tasktype"));
        this.getModel().setValue("planstarttime", parent.get("planstarttime"));
        this.getModel().setValue("planendtime", parent.get("planendtime"));
        this.getModel().setValue("absoluteduration", parent.get("absoluteduration"));
        this.getModel().setValue("pretask", parent.get("pretask"));
        this.getModel().setValue("logical", parent.get("logical"));
        this.getModel().setValue("relativeduration", parent.get("relativeduration"));
        this.getModel().setValue("responsibleperson", parent.get("responsibleperson"));
        this.getModel().setValue("responsibledept", parent.get("responsibledept"));
        this.getModel().setValue("cooperationdept", parent.get("cooperationdept"));
        this.getModel().setValue("project", parent.get("project"));
        this.getModel().setValue("plans", parent.get("plans"));
        this.getModel().setValue("sourcetask", parent.get("sourcetask"));
        this.getModel().setValue("prechangetask", parent.get("prechangetask"));
        this.getModel().setValue("sharer", parent.get("sharer"));
        this.getModel().setValue("comment", parent.get("comment"));
        this.getModel().setValue("percent", parent.get("percent"));
        this.getModel().setValue("achievementnode", parent.get("achievementnode"));
        this.getModel().setValue("realendtime", parent.get("realendtime"));
        this.getModel().setValue("aimfinishtime", parent.get("aimfinishtime"));
        this.getModel().setValue("cooperationperson", parent.get("cooperationperson"));
        this.getModel().setValue("comptimedeviation", parent.get("comptimedeviation"));
        this.getModel().setValue("version", parent.get("version"));
    }

    private Set<Object> getThisTaskBelongPlanTaskIdSet(DynamicObject task) {
        HashSet<Object> idSet = new HashSet<Object>();
        if (task == null) {
            return idSet;
        }
        DynamicObject belongPlantype = task.getDynamicObject("belongplantype");
        if (belongPlantype != null) {
            JSONObject plansObj = JSONObject.parseObject((String)task.getString("plans"));
            String planType = belongPlantype.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                DynamicObject[] taskArr;
                String planId = plansObj.getString("mainproplanid");
                QFilter plansFilter = new QFilter("plans", "like", (Object)("%" + planId + "%"));
                for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id", (QFilter[])new QFilter[]{plansFilter})) {
                    idSet.add(dynamicObject.getPkValue());
                }
                return idSet;
            }
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType)) {
                DynamicObject[] taskArr;
                String planId = plansObj.getString("majorproplanid");
                QFilter plansFilter = new QFilter("plans", "like", (Object)("%" + planId + "%"));
                for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,sourcetask", (QFilter[])new QFilter[]{plansFilter})) {
                    idSet.add(dynamicObject.getPkValue());
                }
                return idSet;
            }
        }
        return idSet;
    }

    private DynamicObject[] getThisTaskBelongPlanTask(DynamicObject task) {
        if (task == null) {
            return new DynamicObject[0];
        }
        JSONObject plansObj = JSONObject.parseObject((String)task.getString("plans"));
        String planId = plansObj.getString("majorproplanid");
        QFilter plansFilter = new QFilter("plans", "like", (Object)("%" + planId + "%"));
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,sourcetask", (QFilter[])new QFilter[]{plansFilter});
        return taskArr;
    }

    private Set<Object> getThisTaskBelongPlanPrePlanTaskIdSet(DynamicObject task) {
        HashSet<Object> idSet = new HashSet<Object>();
        if (task == null) {
            return idSet;
        }
        JSONObject plansObj = JSONObject.parseObject((String)task.getString("plans"));
        String planId = plansObj.getString("majorproplanid");
        QFilter majorPlanIdFilter = new QFilter("id", "=", (Object)planId);
        DynamicObject majorPlan = BusinessDataServiceHelper.loadSingle((String)"pmpm_majorplan", (String)"id,prechangeplan,taskentity,taskentity.taskid", (QFilter[])new QFilter[]{majorPlanIdFilter});
        DynamicObject preChangePlan = majorPlan.getDynamicObject("prechangeplan");
        if (preChangePlan != null) {
            DynamicObject[] taskArr;
            QFilter belongPlanTypeFilter = new QFilter("plans", "like", (Object)("%" + String.valueOf(preChangePlan.getPkValue()) + "%"));
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name", (QFilter[])new QFilter[]{belongPlanTypeFilter})) {
                idSet.add(dynamicObject.getPkValue());
            }
        }
        return idSet;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        switch (propName) {
            case "pretask": {
                QFilter mulInPutFilter = new QFilter("name", "is not null", (Object)"").and(new QFilter("planstarttime", "is not null", (Object)"")).and(new QFilter("planendtime", "is not null", (Object)""));
                DynamicObject belongPlanType = this.getModel().getDataEntity().getDynamicObject("belongplantype");
                Object thisPk = this.getModel().getDataEntity().getPkValue();
                QFilter notParentFilter = null;
                Set parentIdSet = PmpmTaskUtil.getParentAndAfterTaskIdSet((DynamicObject)this.getModel().getDataEntity());
                notParentFilter = new QFilter("id", "not in", (Object)parentIdSet);
                QFilter notSelfPkFilter = new QFilter("id", "!=", thisPk);
                QFilter sourceTaskFilter = new QFilter("sourcetask", "=", (Object)"0");
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter notFenjieFilter = new QFilter("belongplantype.plantype", "!=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
                DynamicObject prObject = this.getModel().getDataEntity().getDynamicObject("project");
                ListShowParameter showParameter1 = (ListShowParameter)arg0.getFormShowParameter();
                if (prObject != null) {
                    QFilter projectFilter = new QFilter("project", "=", prObject.getPkValue());
                    if (belongPlanType != null) {
                        if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)belongPlanType.getString("plantype"))) {
                            DynamicObject[] taskArr = this.getThisTaskBelongPlanTask(this.getModel().getDataEntity());
                            HashSet<Object> thisIdSet = new HashSet<Object>(16);
                            for (DynamicObject thisTask : taskArr) {
                                thisIdSet.add(thisTask.getPkValue());
                            }
                            Set<Object> prePlanTaskIdSet = this.getThisTaskBelongPlanPrePlanTaskIdSet(this.getModel().getDataEntity());
                            QFilter notInPrePlanTaskIdSet = new QFilter("id", "not in", prePlanTaskIdSet);
                            QFilter filter = projectFilter.and(sourceTaskFilter).and(statusFilter).and(notInPrePlanTaskIdSet);
                            QFilter filter2 = new QFilter("id", "in", thisIdSet);
                            QFilter filter3 = filter.or(filter2).and(mulInPutFilter).and(notSelfPkFilter).and(notParentFilter);
                            showParameter1.getListFilterParameter().getQFilters().add(filter3.and(notFenjieFilter));
                            break;
                        }
                        Set<Object> taskIdSet = this.getThisTaskBelongPlanTaskIdSet(this.getModel().getDataEntity());
                        QFilter filter = new QFilter("id", "in", taskIdSet);
                        showParameter1.getListFilterParameter().getQFilters().add(filter.and(notSelfPkFilter).and(notParentFilter).and(mulInPutFilter));
                        break;
                    }
                    showParameter1.getListFilterParameter().getQFilters().add(projectFilter.and(notSelfPkFilter).and(notParentFilter).and(mulInPutFilter));
                    break;
                }
                showParameter1.getListFilterParameter().getQFilters().add(notSelfPkFilter.and(notParentFilter).and(mulInPutFilter));
                break;
            }
            case "responsibleperson": {
                DynamicObject responsibleDept = this.getModel().getDataEntity().getDynamicObject("responsibledept");
                DynamicObject cooperationPreson1 = this.getModel().getDataEntity().getDynamicObject("cooperationperson");
                QFilter notSameCooperationPresonFilter = null;
                if (cooperationPreson1 != null) {
                    notSameCooperationPresonFilter = new QFilter("id", "!=", cooperationPreson1.getPkValue());
                }
                if (null != customMap.get("deptId")) {
                    Long orgId = Long.valueOf(customMap.get("deptId").toString());
                    if (responsibleDept != null) {
                        orgId = Long.valueOf(responsibleDept.getPkValue().toString());
                    }
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(orgId);
                    String userId = RequestContext.get().getUserId();
                    List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                    List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)"15", (List)deptChargeList, (boolean)true);
                    List userIds = null;
                    userIds = null != orgIdList_1 && orgIdList_1.contains(orgId) ? UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)true) : UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)false);
                    QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                    ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(userFilter.and(notSameCooperationPresonFilter));
                    break;
                }
                if (responsibleDept != null) {
                    List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(responsibleDept.getPkValue().toString()));
                    QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                    ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(userFilter.and(notSameCooperationPresonFilter));
                    break;
                }
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(notSameCooperationPresonFilter);
                break;
            }
            case "responsibledept": {
                DynamicObject responsiblePreson = this.getModel().getDataEntity().getDynamicObject("responsibleperson");
                if (null != customMap.get("deptId")) {
                    Long orgId = Long.valueOf(customMap.get("deptId").toString());
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(orgId);
                    List orgIdList = OrgServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
                    String userId = RequestContext.get().getUserId();
                    if (responsiblePreson != null) {
                        userId = responsiblePreson.getPkValue().toString();
                    }
                    List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                    List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)"15", (List)deptChargeList, (boolean)true);
                    QFilter orgFilter = null;
                    if (null != orgIdList_1 && orgIdList_1.contains(orgId)) {
                        orgFilter = new QFilter("id", "in", (Object)orgIdList);
                    } else {
                        List allDeptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                        allDeptList.retainAll(orgIdList);
                        orgFilter = new QFilter("id", "in", (Object)allDeptList);
                    }
                    ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(orgFilter);
                    break;
                }
                if (responsiblePreson == null) break;
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsiblePreson.getPkValue().toString()), (boolean)false);
                QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
            case "cooperationperson": {
                DynamicObject cooperationDept = this.getModel().getDataEntity().getDynamicObject("cooperationdept");
                DynamicObject responsiblePreson1 = this.getModel().getDataEntity().getDynamicObject("responsibleperson");
                QFilter notSamePeopleFilter = null;
                if (responsiblePreson1 != null) {
                    notSamePeopleFilter = new QFilter("id", "!=", responsiblePreson1.getPkValue());
                }
                if (cooperationDept != null) {
                    List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(cooperationDept.getPkValue().toString()));
                    QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                    ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(userFilter.and(notSamePeopleFilter));
                    break;
                }
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(notSamePeopleFilter);
                break;
            }
            case "cooperationdept": {
                DynamicObject cooperationPreson = this.getModel().getDataEntity().getDynamicObject("cooperationperson");
                if (null != customMap.get("deptId")) {
                    if (cooperationPreson == null) break;
                    String userId = cooperationPreson.getPkValue().toString();
                    List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                    List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)"15", (List)deptChargeList, (boolean)true);
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                    deptIds.removeAll(orgIdList_1);
                    deptIds.addAll(orgIdList_1);
                    QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                    ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(orgFilter);
                    break;
                }
                if (cooperationPreson == null) break;
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(cooperationPreson.getPkValue().toString()), (boolean)false);
                QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
            case "tasktype": {
                String plans = this.getModel().getDataEntity().getString("plans");
                if (!StringUtils.contains((CharSequence)plans, (CharSequence)"mainproplanid") && !StringUtils.contains((CharSequence)plans, (CharSequence)"majorproplanid")) break;
                QFilter isProjectTaskFilter = new QFilter("checkboxisprojecttask", "=", (Object)"1");
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(isProjectTaskFilter);
                break;
            }
            case "majortype": {
                DynamicObject projectKind;
                DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
                if (project == null || (projectKind = project.getDynamicObject("group")) == null) break;
                QFilter kindFilter = new QFilter("group", "=", projectKind.getPkValue());
                QFilter enbleFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(kindFilter.and(enbleFilter));
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject bdAtt;
        DynamicObject attachment;
        DynamicObjectCollection attachmentCol;
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"referdocname") && (attachmentCol = (DynamicObjectCollection)this.getModel().getValue("attachmentfield", rowIndex)) != null && attachmentCol.size() > 0 && (attachment = (DynamicObject)attachmentCol.get(0)) != null && (bdAtt = attachment.getDynamicObject("fbasedataid")) != null) {
            String docUrl = bdAtt.getString("url");
            this.getView().download(docUrl);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getView().getParentView() != null) {
            String parentForm = this.getView().getParentView().getFormShowParameter().getFormId();
            if ("pmpm_projectplan".equals(parentForm) || "pmpm_majorplan".equals(parentForm)) {
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("taskId", this.getModel().getDataEntity().getPkValue().toString());
                int seq = (Integer)this.getModel().getValue("taskseq");
                returnData.put("seq", seq);
                this.getView().returnDataToParent(returnData);
            } else if ("pmpm_deptplan".equals(parentForm)) {
                DynamicObject parent;
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                if (null != this.getModel().getDataEntity() && null != this.getModel().getDataEntity().getPkValue()) {
                    returnData.put("taskId", this.getModel().getDataEntity().getPkValue().toString());
                }
                if (null != (parent = (DynamicObject)this.getModel().getValue("parent"))) {
                    returnData.put("parentTaskId", parent.getPkValue().toString());
                }
                int seq = (Integer)this.getModel().getValue("taskseq");
                returnData.put("seq", seq);
                this.getView().returnDataToParent(returnData);
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject plantype;
        super.afterBindData(e);
        this.controlLogicalInputByPreTask();
        this.updateTimeDeviationColor();
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project != null) {
            this.setDateEditRange();
        }
        if (null != (plantype = (DynamicObject)this.getModel().getValue("belongplantype")) && StringUtils.equalsIgnoreCase((CharSequence)plantype.getPkValue().toString(), (CharSequence)"697516877831783424")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pretask", "logical", "realtimedeviation"});
        }
    }

    private void setDateEditRange() {
        DynamicObject project;
        DateEdit planStartTime = (DateEdit)this.getControl("planstarttime");
        DateEdit planEndTime = (DateEdit)this.getControl("planendtime");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        DynamicObject belongPlanType = this.getModel().getDataEntity().getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (sourceParentBelongPlanType = (sourceParentTask = PmpmTaskUtil.getNearestMainPlanParentTask((DynamicObject)this.getModel().getDataEntity())).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date firstDay = sourceParentTask.getDate("planstarttime");
                    Date endDay = sourceParentTask.getDate("planendtime");
                    planStartTime.setMinDate(firstDay);
                    planStartTime.setMaxDate(endDay);
                    planEndTime.setMinDate(firstDay);
                    planEndTime.setMaxDate(endDay);
                    aimFinishTime.setMinDate(firstDay);
                    aimFinishTime.setMaxDate(endDay);
                    return;
                }
            }
        }
        if ((project = this.getModel().getDataEntity().getDynamicObject("project")) != null) {
            Object projecId = project.getPkValue();
            Date firstDay = PmpmTaskUtil.getFirstDayByProject((Object)projecId).getTime();
            Date endDay = PmpmTaskUtil.getEndDayByProject((Object)projecId).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    private void updateTimeDeviationColor() {
        BigDecimal comTimeDeviation = this.getModel().getDataEntity().getBigDecimal("comptimedeviation");
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            propMap.put("fc", "#00DD2C");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            propMap.put("fc", "#FF0000");
        } else {
            propMap.put("fc", "#666");
        }
        this.getView().updateControlMetadata("comptimedeviation", propMap);
    }
}

